<?php

namespace App\Http\Controllers\Site\Fee;

use App\Http\Controllers\ProjectController;
use App\Jobs\Site\PaymentHistoryJob;
use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Examinations\Examination;
use App\Models\Site\Accounts\Accounts;
use App\Models\Site\Accounts\AccountsVoucherDetails;
use App\Models\Site\Accounts\SiteAccountsVoucherDetailsStudentPaymentHistoryRecord;
use App\Models\Site\Employee\StudentAssignToTeacher;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeeFineAllocation;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\Site\Fee\SiteStudentFeeWaiverOfferHistory;
use App\Models\Site\Role\SiteRole;
use App\Models\Student\StudentHistory;
use App\Models\User\GlobalUser;
use App\Models\User\User;
use App\Models\Site\SiteInfo;
//use App\Models\Site\StudentPaySlip\SiteStudentPaymentSlip;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use DB;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicVersion;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicSession;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\Employee\SiteEmployeeOtherPermission;
use App\Models\Site\Fee\Fine\GlobalSiteStudentFeeFine;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteStudentFeeFineAllocation;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\Fee\SiteStudentHeadWiseFeePaymentHistory;
use App\Models\Site\Payment\SitePaymentGateway;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Traits\Site\Fee\StudentFeeTrait;
use JsonSchema\Exception\ValidationException;
use PDF;
use Response;
use Session;
use Error;
use Illuminate\Support\Facades\Response as FacadesResponse;

class SiteStudentFeePaymentHistoryController extends ProjectController
{
    use StudentFeeTrait;

    private $siteStudentFeePaymentHistory;
    private $siteStudentFeeDemandSlipDetails;
    private $siteStudentFeeGenerate;
    private $siteStudentFeeWaiverOfferHistory;
    private $siteStudentHeadWiseFeePaymentHistory;

    public function __construct(
        GlobalSiteStudentFeePaymentHistory $siteStudentFeePaymentHistory,
        SiteStudentFeeDemandSlipDetails $siteStudentFeeDemandSlipDetails,
        SiteStudentFeeGenerate $siteStudentFeeGenerate,
        SiteStudentFeeWaiverOfferHistory $siteStudentFeeWaiverOfferHistory,
        SiteStudentHeadWiseFeePaymentHistory $siteStudentHeadWiseFeePaymentHistory
    ) {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->siteStudentFeePaymentHistory = $siteStudentFeePaymentHistory;
        $this->siteStudentFeeDemandSlipDetails = $siteStudentFeeDemandSlipDetails;
        $this->siteStudentFeeGenerate = $siteStudentFeeGenerate;
        $this->siteStudentFeeWaiverOfferHistory = $siteStudentFeeWaiverOfferHistory;
        $this->siteStudentHeadWiseFeePaymentHistory = $siteStudentHeadWiseFeePaymentHistory;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Fee Collection';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function feeCancelIndex()
    {
        $viewType = 'Fee Cancellation';
        return view('default.admin.layouts.master', compact('viewType'));
        //        return view('default.admin.sites.fee.fee-cancellation.view', compact('viewType'));
    }

    public function getStudentListForPaymentList(Request $request)
    {
        $data = $request->all();
        $siteStudentList = StudentHistory::with('student')
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('status', true)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                return $query->where('academic_student_category_id', $data['academic_student_category_id']);
            })
            ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_type_id', $data['academic_student_type_id']);
            })
            ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
            })
            ->when(!empty($data['student_histories_id']), function ($query) use ($data) {
                return $query->where('id', $data['student_histories_id']);
            })
            ->when(!empty($data['search_user_name']), function ($query) use ($data) {
                return $query->whereHas('student', function ($q) use ($data) {
                    $q->where('username', $data['search_user_name']);
                });
            })
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_department_id')
            ->get();
        return $siteStudentList;
    }
    public function getDemandSlipNoListForPayment()
    {


        /////////
        $site_info = SiteInfo::where('id', Session::get('SITE_ID'))->first();


        ////////////////

        $data_list = [];
        $user_role = request()->user()->roles()->pluck('key')->first();
        $student_history_ids = [];

        if ($site_info->all_admin_fee_collection_status && $user_role == 'admin') {


            $demand_slip_list = GlobalSiteStudentFeeDemandSlipDetails::where('status', 1)
                ->where('site_id', Session::get('SITE_ID'))
                ->get();

            if (count($demand_slip_list)) {
                foreach ($demand_slip_list as $key => $value) {
                    $data_list[$key]['id'] = $value->id;
                    $data_list[$key]['slip_no'] = 100000 + $value->id;
                }
            }
        } else {

            $employee_permission = SiteEmployeeOtherPermission::where('user_id', request()->user()->id)->get();

            $class_id_array = [];
            $group_id_array = [];
            $key = 0;
            foreach ($employee_permission as $k => $item) {
                $group_id_array[$k] = $item->academic_group_id;
                foreach ($item->fee_permission_class_ids[1] as $items) {
                    $class_id_array[$key] = $items;
                    $key++;
                }
            }
            if (!count($class_id_array)) {
                return Response::json(['message' => 'You Have No Permissison!'], 411);
            }
            //   dd($class_id_array);
            $studentHistoryIDList = GlobalStudentHistory::where('site_id', Session::get('SITE_ID'))
                ->whereIn('academic_class_id', $class_id_array)
                ->whereIn('academic_group_id', $group_id_array)
                ->pluck('id');

            $demand_slip_list = GlobalSiteStudentFeeDemandSlipDetails::where('status', 1)
                ->where('site_id', Session::get('SITE_ID'))
                ->whereIn('student_history_id', $studentHistoryIDList)
                ->get();

            // dd($demand_slip_list);
            if (count($demand_slip_list)) {
                foreach ($demand_slip_list as $key => $value) {
                    $data_list[$key]['id'] = $value->id;
                    $data_list[$key]['slip_no'] = 100000 + $value->id;
                }
            }
        }


        return $data_list;
    }

    public function getStudentLastPaymentListPdf(Request $request)
    {
        //        return $request;
        $data_list = $this->getStudentLastPaymentList($request);

        $report_tittle = 'Payment List';
        $report_tittle2  = '';
        $title_view = '';

        $pdf = PDF::loadView(
            'default.admin.site.student-fee.report.student-last-payment-list-pdf',
            compact(
                'data_list',
                'report_tittle',
                'report_tittle2',
                'title_view',
            )
        )
            ->setPaper('a4', 'landscape')
            ->setWarnings(false);


        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';
        return response()->json(route('open-pdf-file-storage', [$name]));
    }
    public function getStudentLastPaymentList(Request $request)
    {
        //        return $request;
        $siteStudentList = $this->getStudentListForPaymentList($request);
        $data = $request->all();

        $data_list = array();

        if (count($siteStudentList)) {
            $sl = 1;

            foreach ($siteStudentList as $key => $value) {
                $std_payment = $this->siteStudentFeePaymentHistory->where('student_history_id', $value->id)
                    ->when($data['search_date'], function ($query) use ($data) {
                        return $query->where('payment_date', $data['search_date']);
                    })
                    ->when($data['search_voucher_no'], function ($query) use ($data) {
                        return $query->where('voucher_no', $data['search_voucher_no']);
                    })
                    ->where('site_id', Session::get('SITE_ID'))
                    ->where('academic_group_id', $value->academic_group_id)
                    ->where('status', 1)
                    ->orderBy('id', 'DESC')
                    ->first();

                if ($std_payment) {
                    $data_list[$sl]['sl'] = $sl;
                    $data_list[$sl]['id'] = $std_payment->id;
                    $data_list[$sl]['student_name'] = $value->student->full_name;
                    $data_list[$sl]['student_roll_number'] = $value->student_roll_number;
                    $data_list[$sl]['user_name'] = $value->student->username;
                    $data_list[$sl]['voucher_no'] = $std_payment->voucher_no;
                    $data_list[$sl]['payment_date'] = $std_payment->payment_date;
                    $data_list[$sl]['paid_amount'] = $std_payment->paid_amount;
                    $data_list[$sl]['due_amount'] = $std_payment->due_amount;
                    $sl++;
                }
            }
        } else {
            //            return Response::json(['message' => 'Sorry data not found!'], 411);
            $data_list = null;
        }
        return $data_list;
    }

    public function singleStudentPaymetCancel(Request $request)
    {

        //=============accounts creation check===============

        $check_accounts_creation = SiteStudentFeePaymentHistory::where('id', $request->id)->first();

        if ($check_accounts_creation->accounts_received_status) {
            return Response::json(['message' => 'Sorry! this payment has been included in accounts!', 'mode' => 'error!'], 410);
        }

        if ($check_accounts_creation->academic_payment_type_key == 'online' || $check_accounts_creation->online_payment_status) {
            return Response::json(['message' => 'Sorry! can not be canceled! this payment is paid through online!', 'mode' => 'error'], 410);
        }


        //==============accoutns create===================

        $payment_history = $this->siteStudentFeePaymentHistory->findOrFail($request->id);
        $paid_amount = $payment_history->paid_amount;
        if ($payment_history->site_student_fee_demand_slip_details_id) {
            $demand_slip = $this->siteStudentFeeDemandSlipDetails->findOrFail($payment_history->site_student_fee_demand_slip_details_id);

            ///////============
            $headWiseFeePaymentHistory = SiteStudentHeadWiseFeePaymentHistory::where('site_student_fee_payment_history_id', $check_accounts_creation->id)->get();

            $pre_total_waiver = 0;
            foreach ($headWiseFeePaymentHistory as $paymentHistory) {
                $studentFee = SiteStudentFeeGenerate::where('id', $paymentHistory->student_fee_generate_id)->first();

                $checkWaiver = SiteStudentFeeWaiverOfferHistory::where('site_student_fee_demand_slip_detail_id', $studentFee->site_student_fee_demand_slip_detail_id)
                    ->where('site_student_fee_fine_allocation_id', $studentFee->site_student_fee_fine_allocation_id)
                    ->where('student_history_id', $studentFee->student_history_id)
                    ->where('fee_head_type_id', $studentFee->fee_head_type_id)
                    ->where('academic_fee_head_id', $studentFee->academic_fee_head_id)
                    ->where('academic_fee_sub_head_id', $studentFee->academic_fee_sub_head_id)
                    ->where('demand_slip_create_status', true)
                    ->orderBy('id', 'DESC')
                    ->first();


                if ($checkWaiver) {

                    if ($checkWaiver->percantage_status) {
                        $amount_for_waiver = $checkWaiver->amount - ($paymentHistory->waiver_amount * 100 / $studentFee->amount);
                    } else {
                        $amount_for_waiver = $checkWaiver->amount - $paymentHistory->waiver_amount;
                    }
                    $pre_total_waiver += $paymentHistory->waiver_amount;

                    $checkWaiver->amount = round($amount_for_waiver);
                    $checkWaiver->updated_by = Auth::user()->id;
                    $checkWaiver->save();

                    //    $pay_history=$this->siteStudentFeeWaiverOfferHistory->findOrFail($checkWaiver->id);

                    if ($checkWaiver->amount == 0) {
                        $checkWaiver->delete();
                    }
                }

                //cancelling fee fine

              
              
                $paymentHistory->delete();

                $lastItem = $this->siteStudentHeadWiseFeePaymentHistory->where('student_fee_generate_id', $studentFee->id)->orderBy('id', 'DESC')->first();
                if ($lastItem) {
                    $lastItem->status = true;
                    $lastItem->save();
                }
            }


            ///////============

            $new_waiver_amount = $demand_slip->waiver_amount - $pre_total_waiver;
            $new_total_amount = $demand_slip->total_amount + $pre_total_waiver;
            // dd($new_total_amount);
            if ($payment_history->due_amount == 0) {

                $demand_slip->update([
                    'waiver_amount' => $new_waiver_amount,
                    'total_amount' => $new_total_amount,
                    'status' => 1,
                ]);
            } else {
                $demand_slip->update([
                    'waiver_amount' => $new_waiver_amount,
                    'total_amount' => $new_total_amount,
                ]);
            }
        }


        $demandslip_id_for_last_payment_find = $payment_history->site_student_fee_demand_slip_details_id;

        GlobalSiteStudentFeeFine::where('site_student_fee_payment_history_id', $request->id)
                ->where('site_student_fee_demand_slip_details_id', $payment_history->site_student_fee_demand_slip_details_id)
                ->where('fee_type', 'delayfine')
                ->update([
                    'status' => true,
                    'site_student_fee_payment_history_id' => null,
                ]);

        SiteStudentFeeFine::where('site_student_fee_payment_history_id', $request->id)
            ->where('fee_type', 'extrapayment')
            ->delete();


        if ($payment_history->delete()) {
            $payment_history_exist = SiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $demandslip_id_for_last_payment_find)
                ->orderBy('id', 'desc')->first();
            if ($payment_history_exist) {
                $payment_history_exist->update([
                    'status' => 1,
                ]);
            }
        }

     
        return Response::json(['message' => 'Payment Successfully Cancelled!', 'mode' => 'Cancelled!'], 200);
    }

    public function getDemandListForPayment(Request $request)
    {
        /// return $request;

        if (!$request->student_registration_number && !$request->demand_slip_no) {
            return Response::json(['message' => 'Please, fill the fields!'], 411);
        }

        $site_info = SiteInfo::where('id', Session::get('SITE_ID'))->first();

        //////////////
        $user_role = request()->user()->roles()->pluck('key')->first();
        $student_history_ids = [];

        // if($site_info->all_admin_fee_collection_status && $user_role=='admin'){

        if ($request->student_registration_number) {
            $userList = GlobalUser::where('username', $request->student_registration_number)->select('id')->first();

            if (!$userList) {
                return Response::json(['message' => 'User ID is not valid!'], 411);
            }

            $studentHistoryIDList = GlobalStudentHistory::where('user_id', $userList->id)
                ->where('site_id', Session::get('SITE_ID'))
                //->where('status',1)
                ->pluck('id');

            $demanSlipId = GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
                ->where('status', 1)
                ->where('site_id', Session::get('SITE_ID'))
                ->orderBy('id', 'ASC')
                ->first();

            if (!$demanSlipId) {
                $paidDemanSlipId = GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
                    ->where('site_id', Session::get('SITE_ID'))
                    ->where('status', false)
                    ->orderBy('id', 'ASC')
                    ->first();
                if ($paidDemanSlipId) {
                    return Response::json(['message' => 'There are no rest Demand Slip!', 'mode' => 'Error!'], 411);
                }
            }

            $slip_number = $demanSlipId->id;
            $slip_no = $demanSlipId->id + 100000;
        } else if ($request->demand_slip_no) {
            $slip_number = $request->demand_slip_no - 100000;
            $slip_no = $request->demand_slip_no;
        }


        // }

        // else{

        //     $employee_permission=SiteEmployeeOtherPermission::where('user_id',request()->user()->id)->get();

        //     $class_id_array=[];
        //     $group_id_array=[];
        //     $key=0;
        //     foreach($employee_permission as $k=>$item){
        //         $group_id_array[$k]=$item->academic_group_id;

        //         foreach($item->fee_permission_class_ids[1] as $items){
        //             $class_id_array[$key]=$items;
        //             $key++;
        //         }
        //     }
        //     if(!count($class_id_array)){
        //         return Response::json(['message' => 'You Have No Permissison!'], 411);
        //     }



        //     if($request->student_registration_number){


        //         $userList=GlobalUser::where('username', $request->student_registration_number)->select('id')->first();
        //         if(!$userList){
        //             return Response::json(['message' => 'User ID is not valid!'], 411);
        //         }
        //         $studentHistoryIDList=GlobalStudentHistory::where('user_id',$userList->id)
        //            ->where('site_id',Session::get('SITE_ID'))
        //            ->whereIn('academic_class_id',$class_id_array)
        //            ->whereIn('academic_group_id',$group_id_array)
        //            //->where('status',1)
        //             ->pluck('id');
        //           //  dd($studentHistoryIDList);

        //         $demanSlipId=GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
        //             ->where('status',1)
        //             ->where('site_id',Session::get('SITE_ID'))
        //             ->orderBy('id', 'desc')
        //             ->first();

        //         if(!$demanSlipId){
        //             $paidDemanSlipId=GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
        //                // ->where('site_id',Session::get('SITE_ID'))
        //                 ->where('status',false)
        //                 ->orderBy('id', 'desc')
        //                 ->first();
        //             if($paidDemanSlipId){
        //                 return Response::json(['message' => 'There are no rest Demand Slip!', 'mode' => 'Error!'],411);
        //             }

        //         }

        //         $slip_number = $demanSlipId->id;
        //         $slip_no = $demanSlipId->id+100000;
        //     }else if($request->demand_slip_no){
        //         $slip_number = $request->demand_slip_no - 100000;
        //         $slip_no = $request->demand_slip_no;

        //     }
        // }

        // $paidDemanSlipIdcheck=SiteStudentFeeDemandSlipDetails::where('id', $slip_number)->first();

        // if(!$paidDemanSlipIdcheck){
        //     return Response::json(['message' => 'Invalid Demand Slip!', 'mode' => 'Error!'],411);
        // }else{
        //     if($paidDemanSlipIdcheck->status==false){
        //         return Response::json(['message' => 'This Demand Slip Amount Is Paid!', 'mode' => 'Error!'],411);
        //     }
        // }


        $demand_slip_details = GlobalSiteStudentFeeDemandSlipDetails::where('id', $slip_number)->where('site_id', Session::get('SITE_ID'))->first();
        //        return $paidDemanSlipIdcheck;
        $student_details = GlobalStudentHistory::with(['student', 'stClass', 'accGroup', 'section', 'department'])
            ->where('id', $demand_slip_details->student_history_id)
            ->where('site_id', Session::get('SITE_ID'))
            ->first();

        $checkPermission = $this->checkPaymentPermission($student_details->academic_class_id, $student_details->academic_group_id);

        if (!$checkPermission) {
            return Response::json(['message' => 'You Have No Permissison!'], 411);
        }


        if (!$demand_slip_details) {
            return Response::json(['message' => 'Invalid Demand Slip!', 'mode' => 'Error!'], 411);
        } else {
            if ($demand_slip_details->status == false) {
                return Response::json(['message' => 'This Demand Slip Amount Is Paid!', 'mode' => 'Error!'], 411);
            }
        }

        $student_details = GlobalStudentHistory::with(['student', 'stClass', 'accGroup', 'section', 'department'])
            ->where('id', $demand_slip_details->student_history_id)
            ->where('site_id', Session::get('SITE_ID'))
            ->first();

        $user_details = GlobalUser::where('id', $demand_slip_details->created_by)->first();
        $user_name = $user_details->first_name;

        
        $user=GlobalUser::where('id',$student_details->usr_id)->first();
        $student_history_ids=GlobalStudentHistory::where('user_id',$user_details->id)->pluck('id');


        $fee_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_generate_ids);
        $fee_generate_list = SiteStudentFeeGenerate::where('site_student_fee_demand_slip_detail_id', $demand_slip_details->id)->get();
        //  dd($demand_slip_details->site_student_fee_generate_ids);
        $waiver_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_waiver_offer_history_ids);
        $waiver_generate_list = SiteStudentFeeWaiverOfferHistory::where('site_student_fee_demand_slip_detail_id', $demand_slip_details->id)->get();
        //==================Fee List=========
        //   dd($fee_generate_list);
        $fee_allocation_details_array = [];
        $fee_allocation_details_arr = array();
        foreach ($fee_generate_list as $key => $value) {

            $fee_allocation_detail = GlobalSiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup', 'academicFeeSubHead'])
                ->where('id', $value->site_student_fee_fine_allocation_id)
                ->where('site_id', Session::get('SITE_ID'))
                ->first();


            if ($fee_allocation_detail->academicFeeHead->head_key == 'admission') {
                $fee_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;
            } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'monthly') {
                $fee_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;
            } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'examination') {
                $fee_type = Examination::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->examination_name;
            } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'general') {
                $fee_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;
            }


            ///====extra add for modify====
            $currentWaiverAndDueHistory = SiteStudentHeadWiseFeePaymentHistory::where('student_fee_generate_id', $value->id)
                ->where('status', true)
                ->orderBy('id', 'DESC')
                ->first();

            if ($currentWaiverAndDueHistory) {
                if ($currentWaiverAndDueHistory->sub_total_due_amount || $currentWaiverAndDueHistory->sub_total_waiver_amount) {
                    $fee_allocation_details_arr['select_fee_type'] = true;
                } else {
                    $fee_allocation_details_arr['select_fee_type'] = true;
                }

                if ($currentWaiverAndDueHistory->site_student_fee_payment_history_id == null) {
                    $fee_allocation_details_arr['select_waiver_field'] = false;
                } else {
                    $fee_allocation_details_arr['select_waiver_field'] = true;
                }
                $fee_allocation_details_arr['waiver_amount'] = $currentWaiverAndDueHistory->sub_total_waiver_amount;
                $fee_allocation_details_arr['due_amount'] = $currentWaiverAndDueHistory->sub_total_due_amount;
                $fee_allocation_details_arr['payable_amount'] = $currentWaiverAndDueHistory->payable_amount;
                $fee_allocation_details_arr['payment_due_status'] = $currentWaiverAndDueHistory->payment_due_status;
                $fee_allocation_details_arr['pay_amount'] = $currentWaiverAndDueHistory->pay_amount;
                $fee_allocation_details_arr['sub_total_pay_amount'] = $currentWaiverAndDueHistory->sub_total_pay_amount;
                $fee_allocation_details_arr['first_payment_status'] = false;
            } else {
                $fee_allocation_details_arr['select_fee_type'] = true;
                $fee_allocation_details_arr['select_waiver_field'] = true;
                $fee_allocation_details_arr['waiver_amount'] = null;
                $fee_allocation_details_arr['due_amount'] = null;
                $fee_allocation_details_arr['payable_amount'] = $value->amount;
                $fee_allocation_details_arr['payment_due_status'] = false;
                $fee_allocation_details_arr['pay_amount'] = $value->amount;
                $fee_allocation_details_arr['sub_total_pay_amount'] = $value->amount;
                $fee_allocation_details_arr['first_payment_status'] = true;
            }

            ///====

            $fee_allocation_details_arr['academic_fee_head'] = $fee_allocation_detail->academicFeeHead;
            $fee_allocation_details_arr['academic_fee_sub_head'] = $fee_allocation_detail->academicFeeSubHead;
            //    return $fee_allocation_detail;
            $fee_allocation_details_array[$key] = array_merge($fee_allocation_details_arr, $value->toArray());
        }

        $fee_allocation_details = collect($fee_allocation_details_array);
        $total_in_word = $this->convertNumberToWord($demand_slip_details->total_amount);
        $tot_amount =  $demand_slip_details->total_amount;


        $fee_allocation_details_list = $this->feeHeadSubHeadTypeMultiStemArray($fee_allocation_details);

        //==================Waiver List =========

        $waiver_allocation_details_array = [];
        $waiver_allocation_details_arr = array();
        foreach ($waiver_generate_list as $key => $value) {

            if ($value->site_student_fee_fine_allocation_id) {
                
                $waiver_allocation_detail = GlobalSiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup', 'academicFeeSubHead'])
                    ->where('id', $value->site_student_fee_fine_allocation_id)
                    ->where('site_id', Session::get('SITE_ID'))
                    ->first();

                if ($waiver_allocation_detail->academicFeeHead->head_key == 'admission') {
                    $waiver_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;
                } elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'monthly') {
                    $waiver_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;
                } elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'examination') {
                    $waiver_type = Examination::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->examination_name;
                } elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'general') {
                    $waiver_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;
                }


                $waiver_allocation_details_arr['academic_fee_head'] = $waiver_allocation_detail->academicFeeHead;
                $waiver_allocation_details_arr['academic_fee_sub_head'] = $waiver_allocation_detail->academicFeeSubHead;


                $waiver_allocation_details_array[$key] = array_merge($waiver_allocation_details_arr, $value->toArray());
            }
        }
        //================due fine=======================

        // $check_paymnet_happend = GlobalSiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $slip_number)
        //     ->where('site_id', Session::get('SITE_ID'))
        //     ->first();
        // //   dd($check_paymnet_happend);
        // if ($check_paymnet_happend) {
        //     $due_fine = GlobalSiteStudentFeeFine::where('site_student_fee_demand_slip_details_id', $demand_slip_details->previous_site_student_fee_demand_slip_detail_id)
        //         ->where('fee_type', 'duefine')
        //         ->where('site_id', Session::get('SITE_ID'))
        //         ->get();
        //     if (count($due_fine) > 0) {
        //         $due_fine_check = $due_fine;
        //     } else {
        //         $due_fine_check = GlobalSiteStudentFeeFine::where('status', 1)->where('student_history_id', $demand_slip_details->student_history_id)
        //             ->where('site_id', Session::get('SITE_ID'))
        //             ->get();
        //     }
        // } else {
        //     $due_fine_check = GlobalSiteStudentFeeFine::where('status', 1)->where('student_history_id', $demand_slip_details->student_history_id)
        //         ->where('site_id', Session::get('SITE_ID'))
        //         ->get();
        // }

        // $site_std_fee_fine_id = [];
        // $fee_due_fine = 0;
        // if (count($due_fine_check)) {
        //     foreach ($due_fine_check as $key => $value) {
        //         $fee_due_fine += $value->fine_amount;
        //         $site_std_fee_fine_id[$key] = $value->id;
        //     }
        // } else {
        //     $fee_due_fine = 0;
        // }

        $fee_delay_fine=$this->feeDelayFine($demand_slip_details,$student_history_ids);

        // $extra_fine = 0;
        // $check_extra_fine = GlobalSiteStudentFeeFine::where('site_student_fee_demand_slip_details_id', $slip_number)
        //     ->where('fee_type', 'extrafine')
        //     ->where('site_id', Session::get('SITE_ID'))
        //     ->get();

        // if (count($check_extra_fine) > 0) {
        //     foreach ($check_extra_fine as $kk => $vl) {
        //         $extra_fine += $vl->fine_amount;
        //     }
        // }



        $total_fee_fine = $fee_delay_fine;// + $fee_due_fine + $extra_fine;


        //        return $fee_due_fine;

        $total_fee_fine = number_format((float)$total_fee_fine, 2, '.', '');

        $total_amount = $tot_amount + $total_fee_fine;
        $total_amount = number_format((float)$total_amount, 2, '.', '');

        $waiver_allocation = collect($waiver_allocation_details_array);

        $waiver_allocation_details = $this->feeHeadSubHeadTypeMultiStemArray($waiver_allocation);

        $previous_paid_amount = 0;
        $payment_list_by_demand_slip = GlobalSiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $slip_number)
            ->where('site_id', Session::get('SITE_ID'))
            ->get();
        if (count($payment_list_by_demand_slip)) {
            foreach ($payment_list_by_demand_slip as $kk => $vv) {
                $previous_paid_amount += $vv->paid_amount;
            }
        }

        $finalArray = compact(
            'demand_slip_details',
            'student_details',
            'slip_no',
            'fee_allocation_details_list',
            'waiver_allocation_details',
            'total_amount',
            'user_name',
            'total_in_word',
            'fee_delay_fine',
          //  'fee_due_fine',
            'total_fee_fine',
         //   'site_std_fee_fine_id',
            'previous_paid_amount'
        );

        return $finalArray;
    }

    public function getDemandListForPaymentEdit(Request $request)
    {
        //        return $request;


        $slip_number = $request->demand_slip_no - 100000;
        $slip_no = $request->demand_slip_no;
        //        return $request->demand_slip_no;

        $demand_slip_details = SiteStudentFeeDemandSlipDetails::where('id', $slip_number)->first();
        $student_details = StudentHistory::with(['student', 'stClass', 'accGroup', 'section', 'department'])
            ->where('id', $demand_slip_details->student_history_id)
            ->first();

        $user_details = GlobalUser::where('id', $demand_slip_details->created_by)->first();
        $user_name = $user_details->first_name;

        $fee_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_generate_ids);
        $fee_generate_list = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)->get();

        $waiver_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_waiver_offer_history_ids);
        $waiver_generate_list = SiteStudentFeeWaiverOfferHistory::whereIn('id', $waiver_generate_id_splite)->get();

        //==================Fee List=========
        $fee_allocation_details_array = [];
        $fee_allocation_details_arr = array();
        foreach ($fee_generate_list as $key => $value) {

            $fee_allocation_detail = SiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup', 'academicFeeSubHead'])
                ->where('id', $value->site_student_fee_fine_allocation_id)->first();


            if ($fee_allocation_detail->academicFeeHead->head_key == 'admission') {
                $fee_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;
            } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'monthly') {
                $fee_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;
            } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'examination') {
                $fee_type = Examination::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->examination_name;
            } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'general') {
                $fee_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;
            }

            $fee_allocation_details_arr['academic_fee_head'] = $fee_allocation_detail->academicFeeHead;
            $fee_allocation_details_arr['academic_fee_sub_head'] = $fee_allocation_detail->academicFeeSubHead;

            $fee_allocation_details_array[$key] = array_merge($fee_allocation_details_arr, $value->toArray());
        }
        //  dd($fee_allocation_details_array);

        $fee_allocation_details = collect($fee_allocation_details_array);
        $total_in_word = $this->convertNumberToWord($demand_slip_details->total_amount);
        $tot_amount =  $demand_slip_details->total_amount;


        $fee_allocation_details_list = $this->feeHeadSubHeadTypeMultiStemArray($fee_allocation_details);

        //==================Waiver List =========
        $waiver_allocation_details_array = [];
        $waiver_allocation_details_arr = array();
        foreach ($waiver_generate_list as $key => $value) {


            if ($value->site_student_fee_fine_allocation_id) {


                $waiver_allocation_detail = SiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup', 'academicFeeSubHead'])
                    ->where('id', $value->site_student_fee_fine_allocation_id)->first();


                if ($waiver_allocation_detail->academicFeeHead->head_key == 'admission') {
                    $waiver_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;
                } elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'monthly') {
                    $waiver_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;
                } elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'examination') {
                    $waiver_type = Examination::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->examination_name;
                } elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'general') {
                    $waiver_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;
                }


                $waiver_allocation_details_arr['academic_fee_head'] = $waiver_allocation_detail->academicFeeHead;
                $waiver_allocation_details_arr['academic_fee_sub_head'] = $waiver_allocation_detail->academicFeeSubHead;


                $waiver_allocation_details_array[$key] = array_merge($waiver_allocation_details_arr, $value->toArray());
            }
        }
        //================due fine=======================

        $due_fine_check = SiteStudentFeeFine::where('student_history_id', $demand_slip_details->student_history_id)->get();
        //        return $due_fine_check;
        $fee_fine = 0;
        $site_std_fee_fine_id = [];
        $fee_due_fine = 0;
        if (count($due_fine_check)) {
            foreach ($due_fine_check as $key => $value) {
                $fee_due_fine += $value->fine_amount;
                $site_std_fee_fine_id[$key] = $value->id;
            }
        } else {
            $fee_due_fine = 0;
        }

        $mytime = Carbon::now();
        $today_date =  $mytime->toDateString();


        $fee_delay_fine = 0;
        $fee_due_fine = 0;

        if ($demand_slip_details->payment_from_date) {
            $start_date = $demand_slip_details->payment_from_date;
            $end_date = $demand_slip_details->payment_to_date;

            $period = CarbonPeriod::create($start_date, $end_date);

            $delay_fine_test = 1;
            $delay_fine = 0;

            foreach ($period as $date) {
                $formated_date =  $date->format('Y-m-d');
                if ($formated_date == $today_date) {
                    $delay_fine_test = 0;
                }
            }

            if ($delay_fine_test == 1) {
                $delay_fine = $demand_slip_details->delay_fine;
            } else {
                $delay_fine = 0;
            }

            //
            //                if($delay_fine>0){
            //                    $fee_fine_create = SiteStudentFeeFine::create([
            //                        'site_student_fee_demand_slip_details_id' => $demand_slip_details->id,
            //                        'fine_amount' => $delay_fine,
            //                    ]);
            //                }

            $fee_delay_fine = $delay_fine;
        }


        $total_fee_fine = $fee_delay_fine + $fee_due_fine;

        //        return $fee_due_fine;

        $total_fee_fine = number_format((float)$total_fee_fine, 2, '.', '');

        $total_amount = $tot_amount + $total_fee_fine;
        $total_amount = number_format((float)$total_amount, 2, '.', '');

        $waiver_allocation = collect($waiver_allocation_details_array);

        $waiver_allocation_details = $this->feeHeadSubHeadTypeMultiStemArray($waiver_allocation);


        $finalArray = compact(
            'demand_slip_details',
            'student_details',
            'slip_no',
            'fee_allocation_details_list',
            'waiver_allocation_details',
            'total_amount',
            'user_name',
            'total_in_word',
            'fee_delay_fine',
            'fee_due_fine',
            'total_fee_fine',
            'site_std_fee_fine_id'
        );

        return $finalArray;
    }


    private function feeHeadSubHeadTypeMultiStemArray($fee_allocation_details)
    {

        //        return $fee_allocation_details;
        $head_Id = $fee_allocation_details->pluck('academic_fee_head.id')->unique();
        $fee_head_list = AcademicFeeHead::get();


        $fee_head_arr = array();
        $fee_head_array = [];
        $key = 0;
        // dd($fee_allocation_details);

        foreach ($head_Id as $value) {

            $head_list = $fee_head_list->where('id', $value)->first();

            $fee_head_arr['id'] = $value;
            $fee_head_arr['name'] = $head_list->name;


            $fee_head_pre_array = [];
            foreach ($fee_allocation_details as $keys => $values) {
                if ($value == $values['academic_fee_head']['id']) {

                    $fee_head_pre_array[$keys] = $values;
                }
            }

            $fee_head_pre_array_collect = collect($fee_head_pre_array);
            $fee_head_pre_array_collect_id = $fee_head_pre_array_collect->pluck('fee_head_type_id')->unique();


            $fee_head_type_arr = array();
            $fee_head_type_array = [];
            $sub_head_full_count = [];
            foreach ($fee_head_pre_array_collect_id as $keyt => $valuet) {

                $fee_head_type_listt = $fee_head_pre_array_collect->where('fee_head_type_id', $valuet)->first();
                //                return $fee_head_type_listt;

                $fee_head_type_arr['fee_type_id'] = $valuet;
                $fee_head_type_arr['fee_type_name'] = $fee_head_type_listt['fee_type_name'];


                $fee_head_type_pre_array = [];
                $keytt = 0;
                foreach ($fee_head_pre_array_collect as $valuett) {

                    if ($valuet == $valuett['fee_head_type_id']) {
                        $fee_head_type_pre_array[$keytt] = $valuett;
                        $keytt++;
                    }
                }

                $fee_head_type_arr['fee_sub_head_count'] = count($fee_head_type_pre_array);
                $fee_head_type_arr['fee_sub_head'] = $fee_head_type_pre_array;

                $sub_head_full_count[$keyt] = count($fee_head_type_pre_array);

                $fee_head_type_array[$keyt] = array_merge($fee_head_type_arr);
            }

            $fee_head_arr['head_type_base_sub_head_count'] = array_sum($sub_head_full_count);
            $fee_head_arr['head_type'] = $fee_head_type_array;

            $fee_head_array[$key] = array_merge($fee_head_arr);

            $key++;
        }
        $fee_allocation_details_list = collect($fee_head_array);

        return $fee_allocation_details_list;
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function getStudentPaySlipList()
    {
        $slip = new SiteStudentPaymentSlip();
        $slip_list = $slip->orderBy('id', 'DESC')->get();
        return $slip_list;
    }

    public function singleStudentPaymentPDF($print_status, $voucher_no)
    {
        //        return $voucher_no;
        $payment_history_details = $this->siteStudentFeePaymentHistory->where('voucher_no', $voucher_no)
            ->where('site_id', Session::get('SITE_ID'))
            ->first();

        $demand_slip_details = GlobalSiteStudentFeeDemandSlipDetails::where('id', $payment_history_details->site_student_fee_demand_slip_details_id)->first();
        //$this->siteStudentFeeDemandSlipDetails
        $fee_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_generate_ids);
        $fee_generate_list = $this->siteStudentFeeGenerate->whereIn('id', $fee_generate_id_splite)->get();

        $waiver_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_waiver_offer_history_ids);

        $waiver_generate_list =  $this->siteStudentFeeWaiverOfferHistory->whereIn('id', $waiver_generate_id_splite)->get();

        $student_details = GlobalStudentHistory::with(['student', 'stClass', 'accGroup', 'section', 'department'])
            ->where('id', $payment_history_details->student_history_id)
            ->where('site_id', Session::get('SITE_ID'))
            ->first();

        $slip_no = $demand_slip_details->id + 100000;

        $paid_amount = $payment_history_details->paid_amount;
        $due_amount = $payment_history_details->due_amount;

        //==================Fee List=========
        $fee_allocation_details_array = [];
        $fee_allocation_details_arr = array();
        foreach ($fee_generate_list as $key => $value) {

            $fee_allocation_detail = GlobalSiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup', 'academicFeeSubHead'])
                ->where('id', $value->site_student_fee_fine_allocation_id)->first();


            if ($fee_allocation_detail->academicFeeHead->head_key == 'admission') {
                $fee_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;
            } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'monthly') {
                $fee_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;
            } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'examination') {
                $fee_type = Examination::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->examination_name;
            } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'general') {
                $fee_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;
            }

            $fee_allocation_details_arr['academic_fee_head'] = $fee_allocation_detail->academicFeeHead;
            $fee_allocation_details_arr['academic_fee_sub_head'] = $fee_allocation_detail->academicFeeSubHead;

            $fee_allocation_details_array[$key] = array_merge($fee_allocation_details_arr, $value->toArray());
        }

        $fee_allocation_details = collect($fee_allocation_details_array);
        $total_paid_amount_in_word = $this->convertNumberToWord($paid_amount);




        $fee_allocation_details_list = $this->feeHeadSubHeadTypeMultiStemArray($fee_allocation_details);

        //==================Waiver List =========
        $waiver_allocation_details_array = [];
        $waiver_allocation_details_arr = array();
        foreach ($waiver_generate_list as $key => $value) {


            if ($value->site_student_fee_fine_allocation_id) {


                $waiver_allocation_detail = GlobalSiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup', 'academicFeeSubHead'])
                    ->where('id', $value->site_student_fee_fine_allocation_id)
                    ->first();


                if ($waiver_allocation_detail->academicFeeHead->head_key == 'admission') {
                    $waiver_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;
                } elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'monthly') {
                    $waiver_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;
                } elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'examination') {
                    $waiver_type = Examination::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->examination_name;
                } elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'general') {
                    $waiver_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;
                }


                $waiver_allocation_details_arr['academic_fee_head'] = $waiver_allocation_detail->academicFeeHead;
                $waiver_allocation_details_arr['academic_fee_sub_head'] = $waiver_allocation_detail->academicFeeSubHead;


                $waiver_allocation_details_array[$key] = array_merge($waiver_allocation_details_arr, $value->toArray());
            }
        }
        $waiver_allocation = collect($waiver_allocation_details_array);

        $waiver_allocation_details = $this->feeHeadSubHeadTypeMultiStemArray($waiver_allocation);

        $previous_paid_amount = SiteStudentFeePaymentHistory::where('id', '<', $payment_history_details->id)
            ->where('site_student_fee_demand_slip_details_id', $demand_slip_details->id)->sum('paid_amount');

        $fee_fine_amount_with_present_demand_slip = SiteStudentFeeFine::where('site_student_fee_demand_slip_details_id', $demand_slip_details->id)
            ->orWhere('site_student_fee_demand_slip_details_id', $demand_slip_details)->sum('fine_amount');

        $fee_fine_amount_with_previous_demand_slip = SiteStudentFeeFine::where('site_student_fee_demand_slip_details_id', $demand_slip_details->previous_site_student_fee_demand_slip_detail_id)
            ->where('fee_type', 'duefine')
            ->sum('fine_amount');

        //        $fee_fine_data = SiteStudentFeeFine::where('site_student_fee_payment_history_id', $payment_history_details->id)->get();
        $fee_fine = $fee_fine_amount_with_present_demand_slip + $fee_fine_amount_with_previous_demand_slip;
        //        if(count($fee_fine_data)){
        //
        //            foreach ($fee_fine_data as $key => $value){
        //                $fee_fine+= $value->fine_amount;
        //            }
        //        }

        $fee_fine = number_format((float)$fee_fine, 2, '.', '');


        $total_amount =  $demand_slip_details->total_amount + $fee_fine;

        $total_amount = number_format((float)$total_amount, 2, '.', '');

        $title_view = 'Payment Slip';
        $user_name = "";
        $payment_date = $payment_history_details->payment_date;

        $report_tittle = '<b>Payment Slip</b><br>' . $payment_date;
        $report_tittle2  = '<b><br>Slip No: </b>' . $voucher_no;

        $slip_quantity  = [1, 2];

        if ($print_status == 1) {
            // $pdf = PDF::loadView('default.admin.site.student-fee.report.payment-bank-slip-pdf', compact('title_view','demand_slip_details','student_details','slip_no','voucher_no',
            //     'payment_date','slip_quantity','fee_allocation_details_list','previous_paid_amount','report_tittle','report_tittle2','waiver_allocation_details', 'total_amount','user_name','total_paid_amount_in_word','paid_amount','due_amount','fee_fine'));
            $pdf = PDF::loadView('default.admin.site.student-fee.report.payment-voucher-for-pos', compact(
                'title_view',
                'demand_slip_details',
                'student_details',
                'slip_no',
                'voucher_no',
                'payment_date',
                'slip_quantity',
                'fee_allocation_details_list',
                'previous_paid_amount',
                'report_tittle',
                'report_tittle2',
                'waiver_allocation_details',
                'total_amount',
                'user_name',
                'total_paid_amount_in_word',
                'paid_amount',
                'due_amount',
                'fee_fine'
            ));
        } else {

            

            $pdf = PDF::loadView('default.admin.site.student-fee.report.payment-voucher-pdf', compact(
                'title_view',
                'demand_slip_details',
                'student_details',
                'slip_no',
                'voucher_no',
                'payment_date',
                'previous_paid_amount',
                'report_tittle',
                'report_tittle2',
                'fee_allocation_details_list',
                'waiver_allocation_details',
                'total_amount',
                'user_name',
                'total_paid_amount_in_word',
                'paid_amount',
                'due_amount',
                'fee_fine'
            ));
        }


        return $pdf->stream(time() . '-student-payment.pdf');

        //        return [$demand_slip_details,$student_details,$slip_no,$voucher_no,$fee_allocation_details_list,$waiver_allocation_details,$total_amount,$total_in_word];



    }


    public function getStudentPaySlipPdf($voucher_no)
    {
        //  $demand_slip_details = SiteStudentFeeDemandSlipDetails::with(['siteStudentFeePaymentHistory'])->where('slip_no', $slip_id)->first();
        $payment_history_details = SiteStudentFeePaymentHistory::with(['siteStudentFeeDemandSlipDetails'])->where('voucher_no', $voucher_no)->first();
        $student_details = StudentHistory::with(['student', 'stClass', 'accGroup', 'section'])->where('id', $payment_history_details->student_history_id)->first();
       
        $user_details = User::where('id', $payment_history_details->created_by)->where('site_id', Session::get('SITE_ID'))->first();
        $user_name = $user_details->first_name;

        $fee_generate_id_splite = explode(',', $payment_history_details->siteStudentFeeDemandSlipDetails->site_student_fee_generate_ids);
        $fee_generate_list = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)->get();
        $fee_allocation_details = [];

        foreach ($fee_generate_list as $key => $value) {

            $fee_allocation_details[$key] = SiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup', 'academicFeeSubHead'])->where('id', $value->site_student_fee_fine_allocation_id)->first();
            foreach ($fee_allocation_details as $k => $v) {

                if ($v->academicFeeHead->name == 'Admission') {
                    $fee_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                    $fee_allocation_details[$key]['fee_type_name'] = $fee_type->name;
                } elseif ($v->academicFeeHead->name == 'Monthly') {
                    $fee_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                    $fee_allocation_details[$key]['fee_type_name'] = $fee_type->name;
                } elseif ($v->academicFeeHead->name == 'Examination') {
                    $fee_type = Examination::where('id', $value->fee_head_type_id)->first();
                    $fee_allocation_details[$key]['fee_type_name'] = $fee_type->examination_name;
                }
            }
        }

        $paid_amount_in_word = $this->convertNumberToWord($payment_history_details->paid_amount);
        $total_with_due =  $payment_history_details->siteStudentFeeDemandSlipDetails['fee_amount'] + $payment_history_details->siteStudentFeeDemandSlipDetails['previous_due'];
        $pdf = PDF::loadView(
            'default.admin.site.student-fee.report.payment-voucher-pdf',
            compact('payment_history_details', 'student_details', 'voucher_no', 'fee_allocation_details', 'total_with_due', 'user_name', 'paid_amount_in_word')
        );
        return $pdf->stream(time() . '-student-payment.pdf');


        $pdf = PDF::loadView('default.admin.site.student-fee.report.fee-report', compact('slip', 'std_name', 'std_roll', 'current_date', 'final', 'total', 'class', 'section', 'site_address', 'report_tittle'));
        return $pdf->stream(time() . '-student-payment.pdf');

        //        $pdf = PDF::loadView('default.admin.site.attendance.report.routine-report2', compact('slip_id','std_name','std_roll','current_date','final','total','class_list','section_list','site_address','report_tittle'));
        //        return $pdf->stream(time() . '-student-payment.pdf');

    }





    public function getMultipleStudentDemandSlipListForPayment(Request $request)
    {

        $data = $request->all();

        if ($request->academic_class_id) {
            //            return 'ok';
            $user_role = request()->user()->roles()->pluck('key')->first();
            $student_history_ids = [];
            if ($user_role != 'admin') {
                $assign_student_to_teacher_data = StudentAssignToTeacher::where('employee_id', Auth::user()->id)
                    ->where('academic_version_id', $request->academic_version_id)
                    ->where('academic_shift_id', $request->academic_shift_id)
                    ->where('academic_year_id', $request->academic_year_id)
                    ->where('academic_class_id', $request->academic_class_id)
                    ->where('status', true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->first();

                if ($assign_student_to_teacher_data) {
                    $student_history_ids = explode(',', $assign_student_to_teacher_data->student_history_ids);
                    //                    $student_history_ids = $assign_student_to_teacher_data->student_history_ids;
                }
                if ($request->academic_class_group_present) {

                    $siteStudentIDs = StudentHistory::with([
                        'student' => function ($query) {
                            $query->select('id', 'username');
                        },
                        'stClass',
                        'accGroup',
                        'section',
                        'department',
                        'siteStudentFeeDemandSlipDetails' => function ($query) {
                            $query->where('status', true);
                        }
                    ])->when(!empty($data['student_history_id']), function ($query) use ($data) {
                        return $query->where('id', $data['student_history_id']);
                    })

                        ->whereIn('id', $student_history_ids)
                        ->where('academic_version_id', $request->academic_version_id)
                        ->where('academic_shift_id', $request->academic_shift_id)
                        ->where('academic_year_id', $request->academic_year_id)
                        ->where('academic_class_id', $request->academic_class_id)
                        ->where('status', true)
                        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })
                        ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                            return $query->where('academic_section_id', $data['academic_section_id']);
                        })
                        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                        })
                        ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                            return $query->where('academic_session_id', $data['academic_session_id']);
                        })
                        ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                            return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                        })
                        ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                            return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                        })
                        ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                            return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                        })
                        ->orderBy('student_roll_number')
                        ->orderBy('academic_section_id')
                        ->orderBy('academic_class_group_id')
                        ->orderBy('academic_class_id')
                        ->orderBy('academic_department_id')
                        ->orderBy('academic_shift_id')
                        ->get([
                            'id',
                            'user_id',
                            'site_id',
                            'student_roll_number',
                            'academic_class_id',
                            'academic_class_group_id',
                            'academic_session_id',
                            'academic_department_id'
                        ]);
                } else {


                    $siteStudentIDs = StudentHistory::with([
                        'student' => function ($query) {
                            $query->select('id', 'username');
                        },
                        'stClass',
                        'accGroup',
                        'section',
                        'department',
                        'siteStudentFeeDemandSlipDetails' => function ($query) {
                            $query->where('status', true);
                        }
                    ])->when(!empty($data['student_history_id']), function ($query) use ($data) {
                        return $query->where('id', $data['student_history_id']);
                    })

                        ->whereIn('id', $student_history_ids)
                        ->where('academic_version_id', $request->academic_version_id)
                        ->where('academic_shift_id', $request->academic_shift_id)
                        ->where('academic_year_id', $request->academic_year_id)
                        ->where('academic_class_id', $request->academic_class_id)
                        ->where('status', true)
                        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })
                        ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                            return $query->where('academic_section_id', $data['academic_section_id']);
                        })
                        ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                            return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                        })
                        ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                            return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                        })
                        ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                            return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                        })
                        ->orderBy('student_roll_number')
                        ->orderBy('academic_section_id')
                        ->orderBy('academic_class_group_id')
                        ->orderBy('academic_class_id')
                        ->orderBy('academic_department_id')
                        ->orderBy('academic_shift_id')
                        ->get([
                            'id',
                            'user_id',
                            'site_id',
                            'student_roll_number',
                            'academic_class_id',
                            'academic_class_group_id',
                            'academic_session_id',
                            'academic_department_id'
                        ]);
                }
            } else {

                if ($request->academic_class_group_present) {

                    $siteStudentIDs = StudentHistory::with([
                        'student' => function ($query) {
                            $query->select('id', 'username');
                        },
                        'stClass',
                        'accGroup',
                        'section',
                        'department',
                        'siteStudentFeeDemandSlipDetails' => function ($query) {
                            $query->where('status', true);
                        }
                    ])->when(!empty($data['student_history_id']), function ($query) use ($data) {
                        return $query->where('id', $data['student_history_id']);
                    })


                        ->where('academic_version_id', $request->academic_version_id)
                        ->where('academic_shift_id', $request->academic_shift_id)
                        ->where('academic_year_id', $request->academic_year_id)
                        ->where('academic_class_id', $request->academic_class_id)
                        ->where('status', true)
                        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })
                        ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                            return $query->where('academic_section_id', $data['academic_section_id']);
                        })
                        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                        })
                        ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                            return $query->where('academic_session_id', $data['academic_session_id']);
                        })
                        ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                            return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                        })
                        ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                            return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                        })
                        ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                            return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                        })
                        ->orderBy('student_roll_number')
                        ->orderBy('academic_section_id')
                        ->orderBy('academic_class_group_id')
                        ->orderBy('academic_class_id')
                        ->orderBy('academic_department_id')
                        ->orderBy('academic_shift_id')
                        ->get([
                            'id',
                            'user_id',
                            'site_id',
                            'student_roll_number',
                            'academic_class_id',
                            'academic_class_group_id',
                            'academic_session_id',
                            'academic_department_id'
                        ]);
                } else {

                   
                    $siteStudentIDs = StudentHistory::with([
                        'student' => function ($query) {
                            $query->select('id', 'username');
                        },
                        'stClass',
                        'accGroup',
                        'section',
                        'department',
                        'siteStudentFeeDemandSlipDetails' => function ($query) {
                            $query->where('status', true)
                                ->orderBy('id', 'ASC');
                        }
                    ])->when(!empty($data['student_history_id']), function ($query) use ($data) {
                        return $query->where('id', $data['student_history_id']);
                    })

                        ->where('academic_version_id', $request->academic_version_id)
                        ->where('academic_shift_id', $request->academic_shift_id)
                        ->where('academic_year_id', $request->academic_year_id)
                        ->where('academic_class_id', $request->academic_class_id)
                        ->where('status', true)
                        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })
                        ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                            return $query->where('academic_section_id', $data['academic_section_id']);
                        })
                        ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                            return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                        })
                        ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                            return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                        })
                        ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                            return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                        })
                        ->orderBy('student_roll_number')
                        ->orderBy('academic_section_id')
                        ->orderBy('academic_class_group_id')
                        ->orderBy('academic_class_id')
                        ->orderBy('academic_department_id')
                        ->orderBy('academic_shift_id')
                        ->get([
                            'id',
                            'user_id',
                            'site_id',
                            'student_roll_number',
                            'academic_class_id',
                            'academic_class_group_id',
                            'academic_session_id',
                            'academic_department_id'
                        ]);

                       
                }
            }
        }

      
        $final_data = array();
        $mytime = Carbon::now();
        $today_date =  $mytime->toDateString();
        foreach ($siteStudentIDs as $key => $value) {
            $fee_generate_list = null;
            if ($value->siteStudentFeeDemandSlipDetails) {
                $site_student_fee_generate_ids =  $value->siteStudentFeeDemandSlipDetails->site_student_fee_generate_ids;
                $fee_generate_id_splite = explode(',', $site_student_fee_generate_ids);
                $fee_generate_list = SiteStudentFeeGenerate::where('site_student_fee_demand_slip_detail_id', $value->siteStudentFeeDemandSlipDetails->id)->get();

                //  dd($fee_generate_list);
            }

            $final_data[$key]['id'] = $value->id;
            $final_data[$key]['full_name'] = $value->full_name;
            $final_data[$key]['username'] = $value->student->username;
            $final_data[$key]['student_roll_number'] = $value->student_roll_number;
            $final_data[$key]['academic_class_id'] = $value->academic_class_id;
            $final_data[$key]['academic_class_group_id'] = $value->academic_class_group_id;
            $final_data[$key]['academic_department_id'] = $value->academic_department_id;
            $final_data[$key]['section'] = $value->section;
            $final_data[$key]['site_id'] = $value->site_id;
            $final_data[$key]['site_student_fee_demand_slip_details'] = $value->siteStudentFeeDemandSlipDetails;
            $final_data[$key]['fee_generate_list'] = $fee_generate_list;
            $final_data[$key]['reference_no'] = "";
            $final_data[$key]['payment_date'] = $today_date;
            $fee_fine_details = SiteStudentFeeFine::where('student_history_id', $value->id)->where('status', 1)->get();

            //=========due fine================
            $fine = 0;
            if (count($fee_fine_details)) {
                foreach ($fee_fine_details as $k => $v) {
                    $fine += $v->fine_amount;
                }
            }

            //===============delay fine===========

            $delay_fine = 0;
            $previous_paid_amount = 0;
            if ($value->siteStudentFeeDemandSlipDetails) {


                $payment_history = SiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $value->siteStudentFeeDemandSlipDetails->id)
                    ->get();
                if (count($payment_history)) {
                    foreach ($payment_history as $ke => $vvl) {
                        $previous_paid_amount += $vvl->paid_amount;
                    }
                    //                    $previous_paid_amount = $value->siteStudentFeeDemandSlipDetails->total_amount - $payment_history->due_amount;
                }


                //                $final_data[$key]['previous_paid_amount'] = $previous_paid_amount;


                if ($value->siteStudentFeeDemandSlipDetails->payment_from_date) {
                    //                    return 'date';
                    $mytime = Carbon::now();
                    $today_date =  $mytime->toDateString();
                    $fee_delay_fine = 0;
                    $start_date = $value->siteStudentFeeDemandSlipDetails->payment_from_date;
                    $end_date = $value->siteStudentFeeDemandSlipDetails->payment_to_date;

                    $period = CarbonPeriod::create($start_date, $end_date);

                    $delay_fine_test = 1;
                    $delay_fine = 0;

                    foreach ($period as $date) {
                        $formated_date =  $date->format('Y-m-d');
                        if ($formated_date == $today_date) {
                            $delay_fine_test = 0;
                        }
                    }

                    if ($delay_fine_test == 1) {
                        $delay_fine = $value->siteStudentFeeDemandSlipDetails->delay_fine;
                    } else {
                        $delay_fine = 0;
                    }

                    $fee_delay_fine = $delay_fine;
                    $final_data[$key]['fine_amount'] = ($fee_delay_fine + $fine) . ".00";
                } else {
                    $fee_delay_fine = 0;
                    $final_data[$key]['fine_amount'] = ($fee_delay_fine + $fine) . ".00";
                }
                //                $final_data[$key]['previous_paid_amount'] = $previous_paid_amount +  $final_data[$key]['fine_amount'];
                $final_data[$key]['total_amount'] = ($fee_delay_fine + $fine + $value->siteStudentFeeDemandSlipDetails->total_amount - $previous_paid_amount) . ".00";
            } else {
                //                return 'not date';
                $final_data[$key]['total_amount'] = 0;

                $final_data[$key]['fine_amount'] = 0;
                //                $final_data[$key]['total_amount'] = ($value->siteStudentFeeDemandSlipDetails->total_amount - $previous_paid_amount).".00";


            }

            $final_data[$key]['previous_paid_amount'] = $previous_paid_amount;


            //            $final_data[$key]['fine_amount'] = $fine.".00";


        }

       // dd($final_data);
        return $final_data;
    }

    private function checkPaymentPermission($class_id, $ac_group_id)
    {
        // dd(request()->user()->id);

        $site_info = SiteInfo::where('id', Session::get('SITE_ID'))->first();

        $user_role = request()->user()->roles()->pluck('key')->first();

        if ($site_info->all_admin_fee_collection_status && $user_role == 'admin') {
            return true;
        } else {
            $employee_permission = SiteEmployeeOtherPermission::where('user_id', request()->user()->id)->get();
            //  dd($employee_permission);
            $class_id_array = [];
            $group_id_array = [];
            $key = 0;
            foreach ($employee_permission as $k => $item) {

                //  dd($class_ids);
                if ($item->academic_group_id == $ac_group_id) {
                    $group_id_array[$k] = $item->academic_group_id;

                    //$class_ids=explode(',',$item->fee_permission_class_ids[0]);
                    foreach ($item->fee_permission_class_ids[1] as $items) {
                        if ($items == $class_id) {
                            $class_id_array[$key] = $items;
                            $key++;
                        }
                    }
                }
            }
            if (count($class_id_array)) {
                return true;
            } else {
                return false;
            }
        }
    }


    public function createSiteBaseMultipleStudentPayment(SiteStudentFeePaymentHistory $payment, Request $request)
    {

        // return  Response::json(['message' => 'You Have No Permission!'], 411); // temporary 

        // dd('you have no permission to create multiple payment!');

    
        //==============entry section================
        DB::beginTransaction();
        try {

            $checkPermission = $this->checkPaymentPermission($request->academic_class_id, Session::get('ACADEMIC_GROUP_ID'));
            if (!$checkPermission) {
                return Response::json(['message' => 'You Have No Permissison!'], 411);
            }

            $demandSlipIDs = [];
            $paymentHistoryIDs = [];
            foreach ($request->select_student_for_fee as $key => $value) {
                $SiteStudentFeeDemandList = $request->SiteStudentFeeDemandList;
                $SiteStudentFeeDemandListCollecton = collect($SiteStudentFeeDemandList);
                $checkPaymentSelect = $SiteStudentFeeDemandListCollecton->where('id', $value)->first();
                if ($checkPaymentSelect) {

                    $dmndSlipId = $checkPaymentSelect['site_student_fee_demand_slip_details']['id'];
                    $demand_slip_details = SiteStudentFeeDemandSlipDetails::where('id', $dmndSlipId)->first();


                    if($demand_slip_details->credit_condition=='online'){
                        $student_history = StudentHistory::where('id', $demand_slip_details->student_history_id)->get();
                        DB::rollBack();
                        return Response::json(['message' => $student_history->full_name . 'This payment is only allowed for online banking!'], 411);
                    }


                    if ($demand_slip_details->site_payment_gateway_id) {
                        $student_history = StudentHistory::where('id', $demand_slip_details->student_history_id)->get();
                         DB::rollBack();
                        return Response::json(['message' => $student_history->full_name . 'Slip has been defined in payment gateway'], 411);
                    }

                  
                    //================previous student fee payment status change======================
                    $check_payment_history = SiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $dmndSlipId)
                        ->where('status', 1)->first();
                    if ($check_payment_history) {
                        $check_payment_history->update([
                            'status' => 0,
                        ]);
                    }
                    //=================================create payment=================================
                    $current_date = Carbon::now()->format('Y-m-d');
                    $newPaymentSlipNo = $dmndSlipId+100000;

                    $MultiplePayment = new SiteStudentFeePaymentHistory();
                    $MultiplePayment->student_history_id = $value;
                    $MultiplePayment->site_student_fee_demand_slip_details_id = $dmndSlipId;
                    $MultiplePayment->paid_amount = $checkPaymentSelect['total_amount'];
                    $payment->due_amount = 0;
                    $MultiplePayment->voucher_no = $newPaymentSlipNo;
                    $MultiplePayment->created_by = Auth::user()->id;
                    $MultiplePayment->status = true;
                    $MultiplePayment->payment_date = $checkPaymentSelect['payment_date'];
                //    $MultiplePayment->payment_date = $current_date;
                    $MultiplePayment->paid_by = $request->paid_by;
                    $MultiplePayment->reference_no = $checkPaymentSelect['reference_no'];


                    if ($MultiplePayment->save()) {

                        $demand_slip_details->update([
                            'status' => false
                        ]);
                    }

                    //                $latest_paymen_data = SiteStudentFeePaymentHistory::orderBy('id', 'DESC')->first();
                    $paymentHistoryIDs[] = $MultiplePayment->id;

                    $demandSlipIDs[] = $dmndSlipId;

                    //=======================student fee fine status change===========================

                    $fee_due_fine = SiteStudentFeeFine::where('student_history_id', $value)->where('status', 1)->update([
                        'status' => 0,
                    ]);

                    //============================check delay fine=================================


                    //                return $demand_slip_details;
                    if ($demand_slip_details && $demand_slip_details->payment_from_date) {
                        $mytime = Carbon::now();
                        $today_date =  $mytime->toDateString();
                        $fee_delay_fine = 0;
                        $start_date = $demand_slip_details->payment_from_date;
                        $end_date = $demand_slip_details->payment_to_date;

                        $period = CarbonPeriod::create($start_date, $end_date);

                        $delay_fine_test = 1;
                        $delay_fine = 0;

                        foreach ($period as $date) {
                            $formated_date =  $date->format('Y-m-d');
                            if ($formated_date == $today_date) {
                                $delay_fine_test = 0;
                            }
                        }

                        if ($delay_fine_test == 1) {
                            $delay_fine = $demand_slip_details->delay_fine;
                        } else {
                            $delay_fine = 0;
                        }
                        if ($delay_fine > 0) {
                            $payment_history = SiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $dmndSlipId)->first();
                            $fee_fine_create = SiteStudentFeeFine::create([
                                'site_student_fee_demand_slip_details_id' => $dmndSlipId,
                                'fine_amount' => $delay_fine,
                                'student_history_id' => $value,
                                'site_student_fee_payment_history_id' => $payment_history->id,
                                'status' => 0,
                                'fee_type' => 'delayfine',
                            ]);
                        }
                    }

                    /// subhead wise data store

                    if (count($checkPaymentSelect['fee_generate_list'])) {

                        foreach ($checkPaymentSelect['fee_generate_list'] as $item) {

                            $studentFee = SiteStudentFeeGenerate::where('id', $item['id'])
                                ->where('status', true)
                                ->first();

                            // $feeHistores=$this->siteStudentHeadWiseFeePaymentHistory->where('student_fee_generate_id',$studentFee->id)->get();

                            $lastHistory = $this->siteStudentHeadWiseFeePaymentHistory->where('student_fee_generate_id', $studentFee->id)->orderBy('id', 'DESC')->first();


                            if ($studentFee) {
                                if ($lastHistory) {
                                    if ($studentFee->amount > $lastHistory->sub_total_pay_amount) {


                                        $new_pay_amount = $studentFee->amount - ($lastHistory->sub_total_pay_amount + $lastHistory->sub_total_waiver_amount);
                                        $new_sub_total_pay_amount = $lastHistory->sub_total_pay_amount + $new_pay_amount;
                                        if ($new_pay_amount) {

                                            $headWiseFeeHistory = new SiteStudentHeadWiseFeePaymentHistory;

                                            $headWiseFeeHistory->student_history_id = $studentFee->student_history_id;
                                            $headWiseFeeHistory->site_student_fee_payment_history_id = $MultiplePayment->id;
                                            $headWiseFeeHistory->student_fee_generate_id = $studentFee->id;

                                            $headWiseFeeHistory->amount = $studentFee->amount;

                                            if ($lastHistory->sub_total_due_amount) {
                                                $headWiseFeeHistory->payable_amount = $lastHistory->sub_total_due_amount;
                                                $headWiseFeeHistory->pay_amount = $lastHistory->sub_total_due_amount;
                                                $headWiseFeeHistory->due_amount = -$lastHistory->sub_total_due_amount;
                                            } else {
                                                $headWiseFeeHistory->payable_amount = $new_pay_amount;
                                                $headWiseFeeHistory->pay_amount = $new_pay_amount;
                                            }

                                            $headWiseFeeHistory->sub_total_pay_amount = $new_sub_total_pay_amount;
                                            $headWiseFeeHistory->sub_total_waiver_amount = $lastHistory->sub_total_waiver_amount;
                                            $headWiseFeeHistory->collected_gateway = 'cash';

                                            $headWiseFeeHistory->payment_due_status = false;


                                            $headWiseFeeHistory->payment_collected_status = true;

                                            $headWiseFeeHistory->collected_by = Auth::user()->id;
                                            $headWiseFeeHistory->status = true;
                                            $headWiseFeeHistory->save();
                                        }

                                        // $lastHistory->update(['status'=>false]);

                                    }
                                } else {
                                    $headWiseFeeHistory = new SiteStudentHeadWiseFeePaymentHistory;

                                    $headWiseFeeHistory->student_history_id = $studentFee->student_history_id;
                                    $headWiseFeeHistory->site_student_fee_payment_history_id = $MultiplePayment->id;
                                    $headWiseFeeHistory->student_fee_generate_id = $studentFee->id;

                                    $headWiseFeeHistory->amount = $studentFee->amount;

                                    $headWiseFeeHistory->payable_amount = $studentFee->amount;

                                    $headWiseFeeHistory->pay_amount = $studentFee->amount;
                                    $headWiseFeeHistory->sub_total_pay_amount = $studentFee->amount;
                                    $headWiseFeeHistory->collected_gateway = 'cash';

                                    $headWiseFeeHistory->payment_due_status = false;

                                    $headWiseFeeHistory->payment_collected_status = true;

                                    $headWiseFeeHistory->collected_by = Auth::user()->id;
                                    $headWiseFeeHistory->status = true;
                                    $headWiseFeeHistory->save();
                                }
                            }
                        }
                    }

                      /// previous slip fee
              
                $prev_fee_generate_id_splite=[];


                $prevSlip=SiteStudentFeeDemandSlipDetails::where('due_transfer_to_promoted_student_history_id',$demand_slip_details->student_history_id)
                    ->where('previous_academic_class_due_status',true)
                    ->first();


                if($prevSlip){
                    $prev_fee_generate_id_splite = explode(',', $prevSlip->site_student_fee_generate_ids);
                

                $fee_generate_list = SiteStudentFeeGenerate::where('site_student_fee_demand_slip_detail_id', $prevSlip->id)->get();
                    
                     if(count($fee_generate_list)){
       
                       foreach($fee_generate_list as $item){
       
                           $studentFee=SiteStudentFeeGenerate::where('id',$item['id'])
                               ->where('status',true)
                               ->first();
                          
                           // $feeHistores=$this->siteStudentHeadWiseFeePaymentHistory->where('student_fee_generate_id',$studentFee->id)->get();
       
                            $lastHistory=SiteStudentHeadWiseFeePaymentHistory::where('student_fee_generate_id',$studentFee->id)->orderBy('id','DESC')->first();
                              
                           if($studentFee){   
                               if($lastHistory){   
                                   if($studentFee->amount > ($lastHistory->sub_total_pay_amount+$lastHistory->sub_total_waiver_amount)){   
       
                                       $headWiseFeeHistory=new SiteStudentHeadWiseFeePaymentHistory();
                                   
                                       $new_pay_amount=$studentFee->amount-($lastHistory->sub_total_pay_amount+$lastHistory->sub_total_waiver_amount);
                                       $new_sub_total_pay_amount=$lastHistory->sub_total_pay_amount+$new_pay_amount;
                                       if($new_pay_amount){
       
                                       $headWiseFeeHistory->student_history_id=$studentFee->student_history_id;
                                       $headWiseFeeHistory->site_student_fee_payment_history_id=$MultiplePayment->id;
                                       $headWiseFeeHistory->student_fee_generate_id=$studentFee->id;
       
                                       $headWiseFeeHistory->amount=$studentFee->amount;
       
                                       if($lastHistory->sub_total_due_amount){
                                           $headWiseFeeHistory->payable_amount=$lastHistory->sub_total_due_amount;
                                           $headWiseFeeHistory->pay_amount=$lastHistory->sub_total_due_amount;
                                           $headWiseFeeHistory->due_amount= -$lastHistory->sub_total_due_amount; /// nagetive value
                                       }else{
                                           $headWiseFeeHistory->payable_amount=$new_pay_amount;
                                           $headWiseFeeHistory->pay_amount=$new_pay_amount;
                                       }
                                       $headWiseFeeHistory->sub_total_pay_amount=$new_sub_total_pay_amount;
                                       $headWiseFeeHistory->sub_total_waiver_amount=$lastHistory->sub_total_waiver_amount;
                                     
                                       $headWiseFeeHistory->payment_due_status=false;
                                   
                                       $headWiseFeeHistory->payment_collected_status=true;
                                       $headWiseFeeHistory->collected_gateway='cash';
                                       $headWiseFeeHistory->collected_by = Auth::user()->id;

                                       $headWiseFeeHistory->status=true;
                                       $headWiseFeeHistory->save();
       
                                   }
       
                                   // $lastHistory->update(['status'=>false]);
       
                                   }
                               }else{
                                   $headWiseFeeHistory=new SiteStudentHeadWiseFeePaymentHistory();
       
                                   $headWiseFeeHistory->student_history_id=$studentFee->student_history_id;
                                   $headWiseFeeHistory->site_student_fee_payment_history_id=$MultiplePayment->id;
                                   $headWiseFeeHistory->student_fee_generate_id=$studentFee->id;
       
                                   $headWiseFeeHistory->amount=$studentFee->amount;
       
                                   $headWiseFeeHistory->payable_amount=$studentFee->amount;
       
                                   $headWiseFeeHistory->pay_amount=$studentFee->amount;
                                   $headWiseFeeHistory->sub_total_pay_amount=$studentFee->amount;
                               
                                   $headWiseFeeHistory->payment_due_status=false;
                               
                                   $headWiseFeeHistory->payment_collected_status=true;
                                   $headWiseFeeHistory->collected_by = Auth::user()->id;

                                   $headWiseFeeHistory->collected_gateway='cash';
                                   $headWiseFeeHistory->status=true;
                                   $headWiseFeeHistory->save();
       
                               }
                           }
                       }

                        // inactive update previous class due
                       $prevSlip->previous_academic_class_due_status=false;
                       
                       }
                    
                    }
       

                //////////////







                    //======================notification========================
                    $payment_history = SiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $dmndSlipId)->first();
                    $paymentHistoryDetails = SiteStudentFeePaymentHistory::where('student_history_id', $payment_history->student_history_id)->where('status', 1)->with('studentHistory')->first();

                    dispatch(new PaymentHistoryJob($paymentHistoryDetails));

                    //======================end========================

                }
            }

            $paymentHistoryIDsWithComa = implode(',', $paymentHistoryIDs);


            SiteStudentFeeDemandSlipDetails::whereIn('id', $demandSlipIDs)
                ->update(['status' => false]);

            //        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);
            DB::commit();
            return Response::json(['message' => 'Payment Done Successfully!', 'mode' => 'Saved!', 'paymentHistoryIDs' => $paymentHistoryIDsWithComa], 200);
        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }


    public function store(Request $request)
    {

     //   dd($request->all());


        if ($request->total_amount > 0) {
            if ($request->paied_amount == null || $request->paied_amount == 0) {
                return Response::json(['message' => 'Please enter pay amount!'], 411);
            }
        }
        if (!$request->paid_by) {
            throw new Error('Please select paid by');
        }
        if ($request->paid_by == 'bank' && !$request->reference_no) {
            throw new Error('This is bank payment! Please write reference no');
        }

        // if (Session::get('SITE_ID') == 180) {
        //     return Response::json(['message' => 'You have no permission!', 'status' => '410'], 410);
        // }
        //        return 'sorry';




        DB::beginTransaction();
        try {

            ///========custom calculation start====
            $total_due_amount = 0;
            $total_waiver_amount = 0;
            foreach ($request->fee_allocation_details_list as $fee_allocation_details) {
                foreach ($fee_allocation_details['head_type'] as $head_type) {
                    foreach ($head_type['fee_sub_head'] as $fee_sub_head) {
                        $total_due_amount += $fee_sub_head['due_amount'];
                        $total_waiver_amount += $fee_sub_head['waiver_amount'];
                    }
                }
            }
            ///========custom calculation end====

            $slip_id = $request->slip_no - 100000;

            $demand_slip_details = GlobalSiteStudentFeeDemandSlipDetails::where('id', $slip_id)->first();

           // dd($demand_slip_details);

            if ($demand_slip_details->site_payment_gateway_id || $demand_slip_details->credit_condition == 'online') {
                return Response::json(['message' => 'This slip has been defined in payment gateway !'], 411);
            }

            // dd($demand_slip_details);


            //------------------previous payment status change end------------------------
            //        $student_payment_save = "";
            $check_payment = GlobalSiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $demand_slip_details->id)
                ->where('site_id', Session::get('SITE_ID'))
                ->get();


            if (count($check_payment) > 0) {
                foreach ($check_payment as $kkk => $vvv) {
                    $vvv->update([
                        'status' => 0,
                    ]);
                    if ($vvv->due_amount == 0) {
                        return Response::json(['message' => 'Sorry! This Payment Already Taken!'], 411);
                    }
                }
            } else {
                //------------------previous payment status change------------------------

                $check_previous_payment_status = GlobalSiteStudentFeePaymentHistory::where('student_history_id', $demand_slip_details->student_history_id)
                    ->where('site_id', Session::get('SITE_ID'))
                    ->where('academic_group_id', $demand_slip_details->academic_group_id)
                    ->where('status', 1)
                    ->get();

                if (count($check_previous_payment_status)) {
                    foreach ($check_previous_payment_status as $kkkk => $vvvv) {
                        $vvvv->update([
                            'status' => 0,
                        ]);
                    }
                }
            }
            //=========================== new payment ===================================

          //  $current_date = Carbon::now()->format('Y-m-d');

            $student_payment_save = new GlobalSiteStudentFeePaymentHistory();
            $student_payment_save->payment_date = $request->payment_date;
           // $student_payment_save->payment_date = $current_date;
            $student_payment_save->site_student_fee_demand_slip_details_id = $demand_slip_details->id;
            $student_payment_save->student_history_id = $demand_slip_details->student_history_id;
            if ($request->extraPayment) {
                $student_payment_save->paid_amount = $request->paied_amount + $request->extraPayment;
            } else {
                $student_payment_save->paid_amount = $request->paied_amount;
            }
            //  $student_payment_save->due_amount = $request->due_amount;
            $student_payment_save->due_amount = $total_due_amount;
            $student_payment_save->created_by = Auth::user()->id;
            $student_payment_save->site_id = Session::get('SITE_ID');
            $student_payment_save->academic_group_id = $demand_slip_details->academic_group_id;
            $student_payment_save->status = 1;
            $student_payment_save->paid_by = $request->paid_by;
            $student_payment_save->reference_no = $request->reference_no;
            //     $student_payment_save->site_payment_gateway_id = $demand_slip_details->site_payment_gateway_id;

            // $payment_history = GlobalSiteStudentFeePaymentHistory::orderBy('voucher_no', 'desc')
            //     ->where('site_id', Session::get('SITE_ID'))
            //     ->select('id','voucher_no')
            //     ->first();

            $student_payment_save->voucher_no = $request->slip_no;
           

            if ($student_payment_save->save()) {
                if ($request->due_amount == 0) {
                    $demand_slip_details->status = 0;
                $this->paymentTotalFineAmount($demand_slip_details,$student_payment_save);

                }

                /////
                //======================fee waiver store========================


                //======================fee details store========================


                foreach ($request->fee_allocation_details_list as $fee_allocation_details) {
                    foreach ($fee_allocation_details['head_type'] as $head_type) {
                        foreach ($head_type['fee_sub_head'] as $fee_sub_head) {

                            $studentFee = SiteStudentFeeGenerate::where('id', $fee_sub_head['id'])
                                ->where('status', true)
                                ->first();

                            $checkWaiver = SiteStudentFeeWaiverOfferHistory::where('site_student_fee_demand_slip_detail_id', $studentFee->site_student_fee_demand_slip_detail_id)
                                ->where('site_student_fee_fine_allocation_id', $studentFee->site_student_fee_fine_allocation_id)
                                ->where('student_history_id', $studentFee->student_history_id)
                                ->where('fee_head_type_id', $studentFee->fee_head_type_id)
                                ->where('academic_fee_head_id', $studentFee->academic_fee_head_id)
                                ->where('academic_fee_sub_head_id', $studentFee->academic_fee_sub_head_id)
                                //    ->where('academic_waiver_type_id',1)
                                ->where('demand_slip_create_status', true)
                                ->orderBy('id', 'DESC')
                                ->first();

                            if ($checkWaiver) {

                                if ($checkWaiver->waiver_amount != $fee_sub_head['waiver_amount']) {
                                    if ($checkWaiver->percantage_status) {
                                        $waiver_amount = ($fee_sub_head['waiver_amount'] * 100) / $fee_sub_head['amount'];
                                    } else {
                                        $waiver_amount = $fee_sub_head['waiver_amount'];
                                    }
                                    $checkWaiver->amount = $waiver_amount;
                                    $checkWaiver->updated_by = Auth::user()->id;
                                    $checkWaiver->status = true;
                                    $checkWaiver->save();
                                }
                            } else {
                                if ($fee_sub_head['waiver_amount']) {
                                    $waiver = new SiteStudentFeeWaiverOfferHistory;

                                    $waiver->academic_waiver_type_id = 1;
                                    $waiver->student_history_id = $demand_slip_details->student_history_id;
                                    $waiver->amount = $fee_sub_head['waiver_amount'];
                                    $waiver->site_student_fee_demand_slip_detail_id = $studentFee->site_student_fee_demand_slip_detail_id;
                                    $waiver->site_student_fee_fine_allocation_id = $studentFee->site_student_fee_fine_allocation_id;
                                    $waiver->academic_fee_head_id = $studentFee->academic_fee_head_id;
                                    $waiver->academic_fee_sub_head_id = $studentFee->academic_fee_sub_head_id;
                                    $waiver->fee_head_type_id = $studentFee->fee_head_type_id;
                                    $waiver->demand_slip_create_status = true;
                                    $waiver->created_by = Auth::user()->id;
                                    $waiver->status = true;
                                    $waiver->save();
                                }
                            }

                            //    if($fee_sub_head['due_amount'] || $fee_sub_head['waiver_amount']){


                            $studentFee = SiteStudentFeeGenerate::where('id', $fee_sub_head['id'])
                                ->where('status', true)
                                ->first();



                            /// due and waiver history
                            if ($studentFee) {

                                $feeHistores = $this->siteStudentHeadWiseFeePaymentHistory->where('student_fee_generate_id', $studentFee->id)->get();


                                $lastHistory = $this->siteStudentHeadWiseFeePaymentHistory->where('student_fee_generate_id', $studentFee->id)->orderBy('id', 'DESC')->first();

                                if ($lastHistory) {

                                    $payable_amount = $lastHistory->amount - $fee_sub_head['waiver_amount'];

                                    $payable_amount_history = $studentFee->amount - ($feeHistores->sum('waiver_amount') + $feeHistores->sum('pay_amount'));

                                    $new_waiver = $fee_sub_head['waiver_amount'] - $feeHistores->sum('waiver_amount');
                                    $new_due = $fee_sub_head['due_amount'] - $lastHistory->sub_total_due_amount;


                                    $pay_amount = $payable_amount - ($fee_sub_head['due_amount'] + $lastHistory->sub_total_pay_amount);
                                    $sub_total_pay_amount = $lastHistory->sub_total_pay_amount + $pay_amount;


                                    if ($lastHistory->sub_total_due_amount != $fee_sub_head['due_amount'] || $lastHistory->sub_total_waiver_amount != $fee_sub_head['waiver_amount']) {

                                        $headWiseFeeHistory = new SiteStudentHeadWiseFeePaymentHistory;

                                        $headWiseFeeHistory->student_history_id = $studentFee->student_history_id;
                                        $headWiseFeeHistory->site_student_fee_payment_history_id = $student_payment_save->id;
                                        $headWiseFeeHistory->student_fee_generate_id = $studentFee->id;

                                        $headWiseFeeHistory->amount = $studentFee->amount;

                                        $headWiseFeeHistory->payable_amount = $payable_amount_history;

                                        $headWiseFeeHistory->pay_amount = $pay_amount;
                                        $headWiseFeeHistory->sub_total_pay_amount = $sub_total_pay_amount;

                                        $headWiseFeeHistory->waiver_amount = $new_waiver;

                                        $headWiseFeeHistory->sub_total_waiver_amount = $fee_sub_head['waiver_amount'];

                                        $headWiseFeeHistory->due_amount = $new_due;

                                        $headWiseFeeHistory->sub_total_due_amount = $fee_sub_head['due_amount'];

                                        if ($fee_sub_head['due_amount']) {
                                            $headWiseFeeHistory->payment_due_status = true;
                                        } else {
                                            $headWiseFeeHistory->payment_due_status = false;
                                        }


                                        $headWiseFeeHistory->payment_collected_status = true;
                                        $headWiseFeeHistory->collected_gateway = 'cash';

                                        $headWiseFeeHistory->collected_by = Auth::user()->id;
                                        $headWiseFeeHistory->status = true;
                                        $headWiseFeeHistory->save();

                                        $lastHistory->update(['status' => false]);
                                    } else {

                                        if ($lastHistory->payment_collected_status == false && $lastHistory->site_student_fee_payment_history_id == null) {

                                            $pay_amount = $payable_amount - $fee_sub_head['due_amount'];
                                            $sub_total_pay_amount = $pay_amount;

                                            $headWiseFeeHistory = new SiteStudentHeadWiseFeePaymentHistory;

                                            $headWiseFeeHistory->student_history_id = $studentFee->student_history_id;
                                            $headWiseFeeHistory->site_student_fee_payment_history_id = $student_payment_save->id;
                                            $headWiseFeeHistory->student_fee_generate_id = $studentFee->id;

                                            $headWiseFeeHistory->amount = $studentFee->amount;

                                            $headWiseFeeHistory->payable_amount = $payable_amount_history;

                                            $headWiseFeeHistory->pay_amount = $pay_amount;
                                            $headWiseFeeHistory->sub_total_pay_amount = $sub_total_pay_amount;
                                            $headWiseFeeHistory->waiver_amount = 0;
                                            $headWiseFeeHistory->due_amount = 0;

                                            $headWiseFeeHistory->sub_total_waiver_amount = $fee_sub_head['waiver_amount'];
                                            $headWiseFeeHistory->sub_total_due_amount = $fee_sub_head['due_amount'];

                                            $headWiseFeeHistory->payment_due_status = false;

                                            $headWiseFeeHistory->payment_collected_status = true;
                                            $headWiseFeeHistory->collected_gateway = 'cash';

                                            $headWiseFeeHistory->collected_by = Auth::user()->id;
                                            $headWiseFeeHistory->status = true;
                                            $headWiseFeeHistory->save();
                                        }
                                    }
                                } else {

                                    $payable_amount = $studentFee->amount - $fee_sub_head['waiver_amount'];
                                    $pay_amount = $payable_amount - $fee_sub_head['due_amount'];
                                    $sub_total_pay_amount = $pay_amount;

                                    $headWiseFeeHistory = new SiteStudentHeadWiseFeePaymentHistory;

                                    $headWiseFeeHistory->student_history_id = $studentFee->student_history_id;
                                    $headWiseFeeHistory->site_student_fee_payment_history_id = $student_payment_save->id;
                                    $headWiseFeeHistory->student_fee_generate_id = $studentFee->id;

                                    $headWiseFeeHistory->amount = $studentFee->amount;

                                    $headWiseFeeHistory->payable_amount = $payable_amount;

                                    $headWiseFeeHistory->pay_amount = $pay_amount;
                                    $headWiseFeeHistory->sub_total_pay_amount = $sub_total_pay_amount;

                                    $headWiseFeeHistory->waiver_amount = $fee_sub_head['waiver_amount'];
                                    $headWiseFeeHistory->sub_total_waiver_amount = $fee_sub_head['waiver_amount'];

                                    $headWiseFeeHistory->due_amount = $fee_sub_head['due_amount'];
                                    $headWiseFeeHistory->sub_total_due_amount = $fee_sub_head['due_amount'];

                                    if ($fee_sub_head['due_amount']) {
                                        $headWiseFeeHistory->payment_due_status = true;
                                    } else {
                                        $headWiseFeeHistory->payment_due_status = false;
                                    }

                                    $headWiseFeeHistory->payment_collected_status = true;
                                    $headWiseFeeHistory->collected_gateway = 'cash';
                                    $headWiseFeeHistory->collected_by = Auth::user()->id;
                                    $headWiseFeeHistory->status = true;
                                    $headWiseFeeHistory->save();
                                }
                            }

                            //  }
                        }
                    }
                }


                /// previous slip fee
              
                $prev_fee_generate_id_splite=[];

                  $prevSlip=SiteStudentFeeDemandSlipDetails::where('due_transfer_to_promoted_student_history_id',$demand_slip_details->student_history_id)
                    ->where('previous_academic_class_due_status',true)
                    ->first();

                if($prevSlip){
                                

                $fee_generate_list = SiteStudentFeeGenerate::where('site_student_fee_demand_slip_detail_id', $prevSlip->id)->get();
                    
                     if(count($fee_generate_list)){
       
                       foreach($fee_generate_list as $item){
       
                           $studentFee=SiteStudentFeeGenerate::where('id',$item['id'])
                               ->where('status',true)
                               ->first();
                          
                           // $feeHistores=$this->siteStudentHeadWiseFeePaymentHistory->where('student_fee_generate_id',$studentFee->id)->get();
       
                            $lastHistory=SiteStudentHeadWiseFeePaymentHistory::where('student_fee_generate_id',$studentFee->id)->orderBy('id','DESC')->first();
                              
                           if($studentFee){   
                               if($lastHistory){   
                                   if($studentFee->amount > ($lastHistory->sub_total_pay_amount+$lastHistory->sub_total_waiver_amount)){   
       
                                       $headWiseFeeHistory=new SiteStudentHeadWiseFeePaymentHistory();
                                   
                                       $new_pay_amount=$studentFee->amount-($lastHistory->sub_total_pay_amount+$lastHistory->sub_total_waiver_amount);
                                       $new_sub_total_pay_amount=$lastHistory->sub_total_pay_amount+$new_pay_amount;
                                       if($new_pay_amount){
       
                                       $headWiseFeeHistory->student_history_id=$studentFee->student_history_id;
                                       $headWiseFeeHistory->site_student_fee_payment_history_id=$student_payment_save->id;
                                       $headWiseFeeHistory->student_fee_generate_id=$studentFee->id;
       
                                       $headWiseFeeHistory->amount=$studentFee->amount;
       
                                       if($lastHistory->sub_total_due_amount){
                                           $headWiseFeeHistory->payable_amount=$lastHistory->sub_total_due_amount;
                                           $headWiseFeeHistory->pay_amount=$lastHistory->sub_total_due_amount;
                                           $headWiseFeeHistory->due_amount= -$lastHistory->sub_total_due_amount; /// nagetive value
                                       }else{
                                           $headWiseFeeHistory->payable_amount=$new_pay_amount;
                                           $headWiseFeeHistory->pay_amount=$new_pay_amount;
                                       }
                                       $headWiseFeeHistory->sub_total_pay_amount=$new_sub_total_pay_amount;
                                       $headWiseFeeHistory->sub_total_waiver_amount=$lastHistory->sub_total_waiver_amount;
                                     
                                       $headWiseFeeHistory->payment_due_status=false;
                                   
                                       $headWiseFeeHistory->payment_collected_status=true;
                                       $headWiseFeeHistory->collected_gateway='cash';
                                       $headWiseFeeHistory->collected_by = Auth::user()->id;

                                       $headWiseFeeHistory->status=true;
                                       $headWiseFeeHistory->save();
       
                                   }
       
                                   // $lastHistory->update(['status'=>false]);
       
                                   }
                               }else{
                                   $headWiseFeeHistory=new SiteStudentHeadWiseFeePaymentHistory();
       
                                   $headWiseFeeHistory->student_history_id=$studentFee->student_history_id;
                                   $headWiseFeeHistory->site_student_fee_payment_history_id=$student_payment_save->id;
                                   $headWiseFeeHistory->student_fee_generate_id=$studentFee->id;
       
                                   $headWiseFeeHistory->amount=$studentFee->amount;
       
                                   $headWiseFeeHistory->payable_amount=$studentFee->amount;
       
                                   $headWiseFeeHistory->pay_amount=$studentFee->amount;
                                   $headWiseFeeHistory->sub_total_pay_amount=$studentFee->amount;
                               
                                   $headWiseFeeHistory->payment_due_status=false;
                               
                                   $headWiseFeeHistory->payment_collected_status=true;
                                   $headWiseFeeHistory->collected_by = Auth::user()->id;

                                   $headWiseFeeHistory->collected_gateway='cash';
                                   $headWiseFeeHistory->status=true;
                                   $headWiseFeeHistory->save();
       
                               }
                           }
                       }
                       // inactive update previous class due
                       $prevSlip->previous_academic_class_due_status=false;

                       }
                    
                    }
       

                //////////////


                $student_waiver_history_list = SiteStudentFeeWaiverOfferHistory::where('site_student_fee_demand_slip_detail_id', $demand_slip_details->id)
                    //->where('status',true)
                    ->get();

                $student_waiver_history_ids = [];
                foreach ($student_waiver_history_list as $key => $item) {
                    $student_waiver_history_ids[$key] = $item->id;
                }

                $student_waiver_his_ids = implode(',', $student_waiver_history_ids);
                $total_fee_amount = $demand_slip_details->total_amount + $demand_slip_details->waiver_amount;
                $total_amount = $total_fee_amount - $total_waiver_amount;

                $demand_slip_details->waiver_amount = $total_waiver_amount;
                $demand_slip_details->total_amount = $total_amount;
                $demand_slip_details->site_student_fee_waiver_offer_history_ids = $student_waiver_his_ids;

                ////
                $demand_slip_details->save();

                //==============fine section===================

                $fee_delay_array = [];
                $fee_due_fine_id_array = [];

                $last_payment_history_get = GlobalSiteStudentFeePaymentHistory::where('status', 1)
                    ->where('site_id', Session::get('SITE_ID'))
                    ->where('academic_group_id', $demand_slip_details->academic_group_id)
                    ->orderBy('id', 'DESC')
                    ->first();

                if ($request->fee_due_fine > 0) {

                    $fine_ids = $request->site_std_fee_fine_id;
                    $fee_fine_update = GlobalSiteStudentFeeFine::whereIn('id', $fine_ids)->where('site_student_fee_payment_history_id', "=", null)
                        ->where('site_id', Session::get('SITE_ID'))
                        ->get();

                    if (count($fee_fine_update) > 0) {
                        foreach ($fee_fine_update as $kke => $vvll) {
                            $vvll->update([
                                'status' => 0,
                                'site_student_fee_payment_history_id' => $last_payment_history_get->id,
                            ]);
                        }
                    }
                    //$fee_fine_update = SiteStudentFeeFine::whereIn('id', $fine_ids)->update([
                    //'status' => 0,
                    //'site_student_fee_payment_history_id' => $last_payment_history_get->id,
                    //]);

                }

                // $fee_fine_generate = GlobalSiteStudentFeeFine::where('site_student_fee_demand_slip_details_id', $slip_id)
                //     ->where('site_id', Session::get('SITE_ID'))
                //     ->where('academic_group_id', $demand_slip_details->academic_group_id)
                //     ->where('fee_type', 'delayfine')
                //     ->first();

                // if (!$fee_fine_generate) {
                //     if ($request->fee_delay_fine > 0) {

                //         $fee_fine_create = GlobalSiteStudentFeeFine::create([
                //             'site_student_fee_demand_slip_details_id' => $slip_id,
                //             'fine_amount' => $request->fee_delay_fine,
                //             'status' => 0,
                //             'site_student_fee_payment_history_id' => $last_payment_history_get->id,
                //             'student_history_id' => $demand_slip_details->student_history_id,
                //             'fee_type' => 'delayfine',
                //             'created_date' => $request->payment_date,
                //             'site_id' => Session::get('SITE_ID'),
                //             'academic_group_id' => $demand_slip_details->academic_group_id,
                //         ]);
                //     }
                // }

                // if ($request->extraPayment) {
                //     $fee_fine_create = GlobalSiteStudentFeeFine::create([
                //         'site_student_fee_demand_slip_details_id' => $slip_id,
                //         'fine_amount' => $request->extraPayment,
                //         'status' => 0,
                //         'site_student_fee_payment_history_id' => $last_payment_history_get->id,
                //         'student_history_id' => $demand_slip_details->student_history_id,
                //         'fee_type' => 'extrafine',
                //         'created_date' => $request->payment_date,
                //         'site_id' => Session::get('SITE_ID'),
                //         'academic_group_id' => $demand_slip_details->academic_group_id,
                //     ]);
                // }


                // head wise payment history sotre

            }



            //=========================sms================================

            if ($request->sendSms) {
                $student_history = GlobalStudentHistory::where('id', $demand_slip_details->student_history_id)->with('student')->first();
                $phone_number =  $student_history->student->contact_number;
                $student_name = $student_history->student->full_name;
                $paid_amount = $request->paied_amount;
                $due_amount = $request->due_amount;
                // $paypment_date = Carbon::today();
                $paypment_date = Carbon::now();;
                $the_site = SiteInfo::findOrFail(Session::get('SITE_ID'));

                //                        $url = config('app.url');

                $sms_txt = "Payment Successful";
                $sms_txt .= ', ' . $student_name;
                $sms_txt .= ', ' . 'Paid:' . $paid_amount;
                $sms_txt .= ', ' . 'Due:' . $due_amount;
                $sms_txt .= ', ' . 'Payment Date:' . $paypment_date;
                $sms_txt .= ', ' . 'Thanks:' . $the_site->site_name;

                $tt = $this->sendSms($the_site->id, [$phone_number], $sms_txt);
            }




            //======================notification========================


            $paymentHistoryDetails = GlobalSiteStudentFeePaymentHistory::with('studentHistory')
                ->where('student_history_id', $demand_slip_details->student_history_id)
                ->where('site_id', Session::get('SITE_ID'))
                ->where('academic_group_id', $demand_slip_details->academic_group_id)
                ->where('status', 1)
                ->first();

            dispatch(new PaymentHistoryJob($paymentHistoryDetails));

            //======================end========================

            DB::commit();
            $voucher_no = $student_payment_save->voucher_no ?? null;
            return $voucher_no;
            // return Response::json(['message' => 'information Save Successfully!','voucher_no'=>$voucher_no, 'mode' => 'Saved!'], 200);

        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    public function siteStudentOnlinePaymentPDF(Request $request)
    {
        $data=$request->all();
        $payment_history_list = $this->siteStudentOnlinePaymentList($request,'for_pdf');

        $total_amount=collect($payment_history_list)->sum('paid_amount');

     
        $report_tittle = 'Online Payment Details';

        $academicYear=AcademicYear::where('id',$request->academic_year_id)->first();
        $academicShift=AcademicShift::where('id',$request->academic_shift_id)->first();
        $academicClass=AcademicClass::where('id',$request->academic_class_id)->first();
        $academicClassGroup=AcademicClassGroup::where('id',$request->academic_class_group_id)->first();
        $academicSection=AcademicSection::where('id',$request->academic_section_id)->first();

        $report_tittle2  = '';

        if($academicYear){
             $report_tittle2  .=' Year: '.$academicYear->year_name;
        }
        if($academicShift){
             $report_tittle2  .=', Shift: '.$academicShift->shift_name;
        }
        if($academicShift){
             $report_tittle2  .=', Class: '.$academicClass->class_name;
        }
        if($academicClassGroup){
             $report_tittle2  .=', Group: '.$academicClassGroup->group_name;
        }
        if($academicSection){
             $report_tittle2  .=', Section: '.$academicSection->section_name;
        }

        if($data['payment_method']){
            $report_tittle2  .=', Payment Method: '.$data['payment_method'];
        }
        if($data['start_date']){
            $report_tittle2  .=', Date: '. Carbon::parse($data['start_date'])->format('d-m-Y');
            $report_tittle2  .=', To: '. Carbon::parse($data['end_date'])->format('d-m-Y');
          //  $report_tittle2  .=' to '.$data['end_date'];
        }


      
        $title_view = '';

        $pdf = PDF::loadView(
            'default.admin.site.student-fee.report.student-online-payment',
            compact(
                'payment_history_list',
                'report_tittle',
                'total_amount',
                'report_tittle2',
                'title_view',
            )
        )
            ->setPaper('a4', 'landscape')
            ->setWarnings(false);


        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';
        return response()->json(route('open-pdf-file-storage', [$name]));
    }
    public function siteStudentOnlinePaymentList(Request $request,$key='site')
    {
        $data = $request->all();
       
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';
        $siteStudentIDs = StudentHistory::with(['student'=>function($q){
                $q->select('id','username');
            }])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('status', $data['status'])
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                return $query->where('academic_student_category_id', $data['academic_student_category_id']);
            })
            ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_type_id', $data['academic_student_type_id']);
            })
            ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
            })
            ->whereHas('student', function ($query) use ($search_txt, $txt) {
                $query->where('user_type', 'student')
                    ->when($search_txt, function ($q) use ($txt) {
                        return $q->where(function ($query) use ($txt) {
                            $query->where('username', 'LIKE', $txt)
                                ->orWhereTranslationLike('first_name', $txt)
                                ->orWhereTranslationLike('last_name', $txt);
                        });
                    })->select('id', 'religion_id', 'gender_id', 'biometric_id', 'username', 'present_id_card_code');
            })

            ->pluck('id')
            ->unique();
        // ->get(['id','user_id', 'site_id', 'student_roll_number', 'academic_class_id', 'academic_class_group_id',
        //     'academic_session_id', 'academic_department_id']);

        //  dd($siteStudentIDs);

        $query  = SiteStudentFeePaymentHistory::with(['studentHistory' => function ($q) {
            $q->with(['student' => function ($query) {
                $query->select('id', 'username');
            }, 'stClass', 'accGroup', 'section', 'department']);
        }])
            ->whereIn('student_history_id', $siteStudentIDs)
            ->where('academic_payment_type_key', 'online')
            ->where('online_payment_status', 1)
            ->when(isset($data['start_date']) && isset($data['end_date']), function ($q) use ($data) {
                $q->whereBetween('payment_date', [$data['start_date'], $data['end_date']]);
            })
            ->when($data['payment_method']!="", function ($q) use ($data) {
                $q->where('paid_by', $data['payment_method']);
            })
            ->orderBy('id', 'DESC');

            
        $payment_history_list = ($key == 'for_pdf') ? $query->get() : $query->paginate($data['paginate']);
        

        $aggregate = (clone $query);
        $total_amount = $aggregate->sum('paid_amount');
        $total_count  = $aggregate->count();
        $total_student_count = (clone $query)->distinct('student_history_id')->count('student_history_id');


        // return [
        //     'total_amount' => $total_amount,
        //     'total_count'  => $total_count,
        //     'list'         => $payment_history_list->through(function ($pay_history) {
        //         if ($pay_history->paid_by == 'SonaliPay') {
        //             $api_responce = json_decode($pay_history->sonali_pay_api_response_details, true);
        //         } else {
        //             $api_responce = [];
        //         }
        //         return [
        //             'id' => $pay_history->id,
        //             'voucher_no' => $pay_history->voucher_no,
        //             'transaction_id' => $pay_history->transaction_id ,
        //             'studentHistory' => $pay_history->studentHistory,
        //             'paid_amount' => $pay_history->paid_amount,
        //             'paid_by' => $pay_history->paid_by,
        //             'payment_date' => $pay_history->payment_date,
        //             'sonali_pay_mode' => $pay_history->sonali_pay_mode,
        //             'created_at' => Carbon::parse($pay_history->created_at)->format('h:i:s A'),
        //             'api_responce' => $api_responce,
        //         ];
        //     }),
        // ];



                
        $payment_history_list->transform(function ($pay_history) {
            if ($pay_history->paid_by == 'SonaliPay') {
                $api_responce = json_decode($pay_history->sonali_pay_api_response_details, true);
            } else {
                $api_responce = [];
            }
            return [
                'id' => $pay_history->id,
                'voucher_no' => $pay_history->voucher_no,
                'transaction_id' => $pay_history->transaction_id ,
                'studentHistory' => $pay_history->studentHistory,
                'paid_amount' => $pay_history->paid_amount,
                'paid_by' => $pay_history->paid_by,
                'payment_date' => $pay_history->payment_date,
                'sonali_pay_mode' => $pay_history->sonali_pay_mode,
                'created_at' => Carbon::parse($pay_history->created_at)->format('h:i:s A'),
                'api_responce' => $api_responce,
            ];
        });

        return [
            'total_amount' => $total_amount,
            'total_slip_count'  => $total_count,
            'total_student_count'  => $total_student_count,
            'list'         => $payment_history_list,
        ];
    }

    public function geSiteStudentPaymentBankSlipPdf($voucher_no)
    {


        $check_payment = SiteStudentFeePaymentHistory::where('voucher_no', $voucher_no)->first();
        if (!$check_payment) {
            return response()->json(['message' => 'Data not found!'], 410);
        }
     
        $payment_details = $this->paymentSlipData($voucher_no);

     //   dd($payment_details);
        
        if($payment_details['status']!=200){
            return $payment_details['message'];
        }

        $payment_data=$payment_details['payment_data'];
        $student_info=$payment_details['student_info'];

    
        $report_tittle ='Student Fee Voucher';
        $report_tittle2  ='';
        $title_view='Student Fee Voucher';

        $siteInfo=SiteInfo::where('id', Session::get('SITE_ID'))
                ->select('id','web_student_fee_collection_status','show_subhead_in_payment_slip')
                ->first();
                
        $slip_key='admin';

        $pdf = PDF::loadView('default.admin.site.student-fee.report.student-payment-voucher-pdf',
            compact('title_view','report_tittle','report_tittle2','payment_data','student_info','siteInfo','slip_key'));

        return $pdf->stream(time() . '-site-student-payment-slip.pdf');


    }



    public function siteStudentAccountWiseOnlinePaymentList(Request $request)
    {

        $data=$request->all();
        $data['academic_payment_method_key']=$data['payment_method']=='SonaliPay'?'sonali_pay':$data['payment_method'];

        $siteStudentIDs = GlobalStudentHistory::where('academic_version_id', $data['academic_version_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('site_id', Session::get('SITE_ID'))
            ->where('academic_group_id', $data['academic_group_id'])
            ->where('status', true)
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                return $query->where('academic_student_category_id', $data['academic_student_category_id']);
            })
            ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_type_id', $data['academic_student_type_id']);
            })
            ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
            })

            ->pluck('id')
            ->unique();

        $paymentGatewayList =  SitePaymentGateway::with(['academicOnlinePaymentMethod','academicOnlinePaymentMarchentType',
            'academicFeeType'])
          ->when(!empty($data['academic_payment_method_key']), function ($query) use ($data) {
                return $query->where('academic_payment_method_key', $data['academic_payment_method_key']);
            })
            ->get();

        $payment_history_credit_info = GlobalSiteStudentFeePaymentHistory::where('site_id', Session::get('SITE_ID'))
            ->where('academic_group_id', $data['academic_group_id'])
            ->where('academic_payment_type_key', 'online')
            ->where('online_payment_status', 1)
            ->when(isset($data['start_date']) && isset($data['end_date']), function ($q) use ($data) {
                $q->whereBetween('payment_date', [$data['start_date'], $data['end_date']]);
            })
            ->when(!empty($data['payment_method']), function ($q) use ($data) {
                $q->where('paid_by', $data['payment_method']);
            })
            ->whereIn('student_history_id', $siteStudentIDs)
            ->whereNotNull('credit_info')
            ->where('credit_info', '!=', '[]')
            ->pluck('credit_info')
            ->filter() 
            ->flatMap(function ($item) {
                return json_decode($item, true) ?? [];
            })
            ->values();

         //   dd($payment_history_credit_info);

        $accont_amount_array=[];
        $total_amount=0;
        foreach($paymentGatewayList as $key=>$gateway){
            $account_amount=$payment_history_credit_info->where('gateway_account_no',$gateway->partner_number)->sum('total_payable_amount');
            $formated_account_amount=number_format((float)$account_amount, 2, '.', '');

            $payment_method_name=$gateway->academic_payment_method_key=='sonali_pay'?'SonaliPay':$gateway->academic_payment_method_key;

            $accont_amount_array[$key]['gateway_account_no']=$gateway->partner_number;
            $accont_amount_array[$key]['pay_amount']=$formated_account_amount;
            $accont_amount_array[$key]['academic_payment_type_key']=$gateway->academic_payment_type_key;
            $accont_amount_array[$key]['academic_payment_method_key']=$gateway->academic_payment_method_key;
            $accont_amount_array[$key]['payment_method_name']=$payment_method_name;
            $accont_amount_array[$key]['user_name']=$gateway->user_name;

           $total_amount+=$account_amount;
        }

        $data=[
            'total_amount'=>number_format((float)$total_amount, 2, '.', ''),
            'accont_amount_array'=>$accont_amount_array,
        ];

        return $data;

    }

    

    public function siteStudentAccountWiseOnlinePaymentListPdf(Request $request){

        $resdata=$this->siteStudentAccountWiseOnlinePaymentList($request);

        $accont_amount_array=$resdata['accont_amount_array'];
        $total_amount=$resdata['total_amount'];
        $input=$request->all();

       // $request=collect($input);

     //   dd($input);


        $start_date=$input['start_date'];
        $end_date=$input['end_date'];

        $data=[
            'accont_amount_array'=>$accont_amount_array,
            'total_amount'=>$total_amount,
            'start_date'=>$start_date,
            'end_date'=>$end_date,
        ];

        $version= AcademicVersion::where('id',$input['academic_version_id'])->first();
        $shift= AcademicShift::where('id',$input['academic_shift_id'])->first();
        $year= AcademicYear::where('id',$input['academic_year_id'])->first();

        $report_tittle2  ='';
        $report_tittle2  .='Version: '.$version->version_name;
        $report_tittle2  .=', Year: '.$year->year_name;
        $report_tittle2  .=', Shift: '.$shift->shift_name;
      //  dd($request->all());
        if($input['academic_class_id']){
            $class= AcademicClass::where('id',$input['academic_class_id'])->first();
            $report_tittle2  .=', Class: '.$class->class_name;
        }
        if($input['academic_class_group_id']){
            $classgroup= AcademicClassGroup::where('id',$input['academic_class_group_id'])->first();
            $report_tittle2  .=', Class Group: '.$classgroup->group_name;
        }
        if($input['academic_session_id']){
            $session= AcademicSession::where('id',$input['academic_session_id'])->first();
            $report_tittle2  .=', Class Group: '.$session->session_name;
        }
        if($input['payment_method']){
            $report_tittle2  .=', Payment Method: '.$input['payment_method'];
        }
        if($input['start_date']){
            $report_tittle2  .=', Date: '.$input['start_date'];
            $report_tittle2  .=' to '.$input['end_date'];
        }
        
        $report_tittle ='Account Wise Fee Report';
        $title_view='Account Wise Fee Report';

        $pdf = PDF::loadView('default.admin.site.student-fee.report.account-base-fee-report-pdf',
            compact('data','title_view','report_tittle','report_tittle2'));

        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '-site-account-base-fee-report.pdf', 'UTF-8');
        $name = $time . '-site-account-base-fee-report.pdf';

         return Response::json([
            'link' => route('open-pdf-file-storage-for-public', [$name]),
            'message' => 'Successfully Created Card Report'
        ],200);
        
       // return response()->json(route('open-pdf-file-storage', [$name]));
      //  return $pdf->stream(time() . '-site-account-base-fee-report.pdf');
    }

    
}
