<?php

namespace App\Http\Controllers\Site\Fee;

use App\Models\Academic\AcademicFeeGroup;
use App\Models\Academic\AcademicWaiverType;
use App\Models\Site\Fee\SiteFeeWaiverOfferHistory;
use App\Models\Site\Fee\SiteStudentFeeFineAllocation;
use App\Models\Site\Fee\SiteStudentFeeWaiverOfferHistory;
use App\Models\Student\StudentHistory;
use DB;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use JsonSchema\Exception\ValidationException;
use Response;
use Session;

class StudentFineHistoryController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }

    public function index()
    {
        $viewType = 'Fee Head List';
        return view('default.admin.sites.fee.student-waiver-history.view', compact('viewType'));
    }

  
    public function getStudentFineList (Request $request){

        $data=$request->all();
       
        $siteStudentHistoryList = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('status', true)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                return $query->where('academic_student_category_id', $data['academic_student_category_id']);
            })
            ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_type_id', $data['academic_student_type_id']);
            })
            ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
            })
            ->get()
            ->values();


            $student_data=[];
            foreach($siteStudentHistoryList as $key=>$studentHistory){
                $fee_fine_list=SiteStudentFeeFine::where('student_history_id',$studentHistory->id)->get();

                $tota_fine_amount=$fee_fine_list->sum('fine_amount');
                $due_fine_amount=$fee_fine_list->where('site_student_fee_payment_history_id',null)->sum('fine_amount');

              //  if(count($fee_fine_list)){

                $student_data[$key]['id']=$studentHistory->id;
                $student_data[$key]['student_name']=$studentHistory->full_name;  
                $student_data[$key]['username']=$studentHistory->username;  
                $student_data[$key]['class_roll']=$studentHistory->student_full_roll_number;  
                $student_data[$key]['total_fine_amount']=number_format($tota_fine_amount, 2, '.', '');
                $student_data[$key]['due_fine_amount']=number_format($due_fine_amount, 2, '.', '');;
           
                $fee_fine_array=[];
                foreach($fee_fine_list as $keys=>$fine){
                    $fee_fine_array[$keys]['id']=$fine->id;
                    $fee_fine_array[$keys]['fee_type']=$fine->fee_type=='delay_fine'?'Delay Fine':'Fine';
                    $fee_fine_array[$keys]['fine_amount']=$fine->fine_amount;
                    $fee_fine_array[$keys]['site_student_fee_demand_slip_details_id']=$fine->site_student_fee_demand_slip_details_id;
                    $fee_fine_array[$keys]['status']=$fine->status;
                    $fee_fine_array[$keys]['payment_status']=$fine->site_student_fee_payment_history_id?'Paid':'Due';
                }

                $student_data[$key]['fine_list']=$fee_fine_array;
               
              //  }
            }

            $total_fine_amount=number_format(collect($student_data)->sum('total_fine_amount'), 2, '.', '');
            $total_due_amount=number_format(collect($student_data)->sum('due_fine_amount'), 2, '.', '');

            return ['student_list'=>$student_data, 'total_fine_amount'=>$total_fine_amount,'total_due_amount'=>$total_due_amount];

          return $student_data;

    }

}
