<?php

namespace App\Http\Controllers\Site\HolidayOnDuty;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Event\Event;
use App\Models\Site\Employee\Employee;
use App\Models\Site\EmployeOnDutyInHolidaySetting\EmployeOnDutyInHolidaySetting;
use Carbon\Carbon;
use Exception;

class HolidayOnDutyController extends Controller
{
    private $employee;
    private $EmployeOnDutyInHolidaySetting;
    public function __construct(Employee $employee, EmployeOnDutyInHolidaySetting $EmployeOnDutyInHolidaySetting)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->employee = $employee;
        $this->EmployeOnDutyInHolidaySetting = $EmployeOnDutyInHolidaySetting;
    }
    public function index()
    {
        $viewType = 'HolidayOnDuty';

        return view('default.admin.layouts.master', compact('viewType'));
    }
    public function SiteEmployeeGetHolidayOnDuty(Request $request)
    {
        $year = $request->selectedYear;
        $month = $request->selectedMonth;


        $offDayOfMonth = Event::whereYear('activate_date', '=', $year)
            ->whereMonth('activate_date', '=', $month)
            ->where('status', 1)
            ->with('academicCalendarHead')
            ->pluck('activate_date')
            ->toArray();

        $EmployeOnDutyInHoliday = array_map(function ($date) {
            return [
                'date' => Carbon::parse($date)->format('d-M-Y'),
                'onDuty' => false,
                'dayOfWeek' =>  date('l', strtotime($date)),
            ];
        }, $offDayOfMonth);

        $designationList = $this->employee
            ->with('designation')
            ->get()
            ->pluck('designation.name')
            ->filter(function ($designation) {
                return !is_null($designation);
            })
            ->unique()
            ->toArray();


            $TransformedEmployeOnDutyInHoliday = array_map(function ($designation) use ($EmployeOnDutyInHoliday,$month,$year) {
                
                $EmployeOnDutyInHolidaySetting =    $this->EmployeOnDutyInHolidaySetting
                ->where('employe_designation', $designation)
                ->where('month', $month)
                ->where('year', $year)
                ->get();

                foreach ($EmployeOnDutyInHoliday as &$OnDutyInHoliday) {
                    $OnDutyInHolidaydate = Carbon::parse($OnDutyInHoliday['date'])->format('Y-m-d');

                    foreach ($EmployeOnDutyInHolidaySetting as $setting) {
                        if ($OnDutyInHolidaydate == $setting->on_duty) {
                            $OnDutyInHoliday['onDuty'] = true;
                        }
                    }
                }

                return [
                    'designation' => $designation,
                    'EmployeOnDutyInHoliday' => $EmployeOnDutyInHoliday,
                ];

            }, $designationList);

        return $TransformedEmployeOnDutyInHoliday;
    }
    public function SiteEmployeeGetHolidayOnDutySettings(Request $request)
    {

        $item          = json_decode($request->input('item'), true);
        $date          =  Carbon::parse($item['date'])->format('Y-m-d');
        $onDuty        =  $item['onDuty'];

        $designation   =  $request->designation;
        $selectedYear  =  $request->selectedYear;
        $selectedMonth =  $request->selectedMonth;

        $EmployeOnDutyInHolidaySetting =    $this->EmployeOnDutyInHolidaySetting->where('on_duty', $date)
            ->where('employe_designation', $designation)
            ->where('month', $selectedMonth)
            ->where('year', $selectedYear)
            ->first();

        if ($EmployeOnDutyInHolidaySetting) {
            if (!$onDuty) {
                $EmployeOnDutyInHolidaySetting->delete();
            }
        } else {
            $EmployeOnDutyInHolidaySetting = new EmployeOnDutyInHolidaySetting();
            $EmployeOnDutyInHolidaySetting->employe_designation = $designation;
            $EmployeOnDutyInHolidaySetting->year                = $selectedYear;
            $EmployeOnDutyInHolidaySetting->month               = $selectedMonth;
            $EmployeOnDutyInHolidaySetting->on_duty             = $date;
            $EmployeOnDutyInHolidaySetting->site_id             = session()->get('SITE_ID');
            $EmployeOnDutyInHolidaySetting->save();
        }
     return "successfull";
    }
}
