<?php

namespace App\Http\Controllers\Site\Live;

use App\Http\Controllers\ProjectController;
use App\Models\Site\Live\Meeting;
use App\Models\Site\Live\MeetingInvitation;
use App\Models\Site\Live\Setting;
use App\Models\Student\StudentHistory;
use App\Notifications\Live\MeetingInvitationSent;
use App\Traits\LiveStreamingApiTrait;
use App\User;
use Auth;
use Carbon\Carbon;
use DateTime;
use DateTimeZone;
use Error;
use Exception;
use Illuminate\Http\Request;
use Notification;

class MeetingController extends ProjectController
{
    use   LiveStreamingApiTrait;

    private $setting;
    private $meeting;
    private $meetingInvitation;
    private $studentHistory;
    private $user;

    public function __construct(Setting $setting, Meeting $meeting, MeetingInvitation $meetingInvitation, StudentHistory $studentHistory,
                                User $user)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');


        $this->setting = $setting;
        $this->meeting = $meeting;
        $this->meetingInvitation = $meetingInvitation;
        $this->studentHistory = $studentHistory;
        $this->user = $user;
    }


    public function index()
    {


        /*   $date = new DateTime('2020-10-29 19:50:14');
           $date2 = new DateTime("now");

           $diff = $date2->getTimestamp() - $date->getTimestamp();

           dd($date,$date2,$diff);*/
        //2020-11-05T13:53:01Z

        /*     $rr = date("Y-m-d H:i:s", strtotime('2020-11-06T20:05:00Z'));//7 nov 8:05 PM

             //  dd($rr);

             date_default_timezone_set('Europe/London');

             $datetime = new DateTime('2020-11-06T20:05:00Z');
             $d1 = $datetime->format('Y-m-d H:i:s') . "\n";

             $la_time = new DateTimeZone('America/Los_Angeles');
             $datetime->setTimezone($la_time);
             $d2 = $datetime->format('Y-m-d H:i:s');

             dd($d1, $d2);


             $curl = curl_init();
             $token1 = 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJhdWQiOm51bGwsImlzcyI6IkFKd1Q3bHJJUU9XOFVPSmhNelpodHciLCJleHAiOjE3NjIzNTE5MjAsImlhdCI6MTYwNDU4MDE1Nn0.wr1Zv9glaEChYDnO6e1nUR7z-sZvQU4pNpEyCnp1mOA';
             $token = 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJhdWQiOm51bGwsImlzcyI6IkpJVTMxRHZoVGxtWWVTWUNaM19MTmciLCJleHAiOjE3NjE5MDA0ODAsImlhdCI6MTYwNDEyODc1NH0.6Jy2qV23Wqs63Dc6TPRpNuF0-faN8JQfhETD0Uu7Z5c';

             curl_setopt_array($curl, array(
                 CURLOPT_URL => "https://api.zoom.us/v2/meetings/98620585227 ",
                 CURLOPT_RETURNTRANSFER => true,
                 CURLOPT_ENCODING => "",
                 CURLOPT_MAXREDIRS => 10,
                 CURLOPT_TIMEOUT => 30,
                 CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                 CURLOPT_CUSTOMREQUEST => "GET",
                 CURLOPT_HTTPHEADER => array(
                     "authorization: Bearer " . $token,
                     "content-type: application/json"
                 ),
             ));

             $response = curl_exec($curl);
             $err = curl_error($curl);

             curl_close($curl);


             dd($response);*/
        /*

                $t = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJhdWQiOm51bGwsImlzcyI6IndxLThvQXdEU19LREZrRkpRblNuV0EiLCJleHAiOjE2MDUyMjYwODQsImlhdCI6MTYwNDYyMTI5MH0.77H5O5p9NdLKGHMNP0k8jdX0WLHazeYYlVUCPJ9s3vc";
                $this->addParticipant('76258209778',$t);*/

        $viewType = 'Live Meeting View';
        return view('default.admin.layouts.master', compact('viewType'));

    }


    public function getUserToInvite(Request $request)
    {
        try {

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id;
            $data['academic_section_id'] = $request->academic_section_id;
            $data['academic_session_id'] = $request->academic_session_id;
            $date_time = $request->join_date_time;
            $date = date('Y-m-d', strtotime($date_time));

            $joined = $request->joined;
            $user_type = $request->user_type;
            $meeting_id = $request->meeting_id;
            $search_txt = $request->search_txt;
            $status = $request->status;
            $paginate = $request->paginate ?? 20;
            $txt = '%' . $search_txt . '%';

            $alias=\Session::get('ALIAS1');

            $user_list = $this->user
                ->where('alias',$alias)
                ->when($user_type == 'student', function ($q) use ($user_type, $data) {
                    return $q->whereHas('studentHistories', function ($q1) use ($data) {
                        $q1->when($data['academic_version_id'], function ($query) use ($data) {
                            return $query->where('academic_version_id', $data['academic_version_id']);
                        })->when($data['academic_year_id'], function ($query) use ($data) {
                            return $query->where('academic_year_id', $data['academic_year_id']);
                        })->when($data['academic_shift_id'], function ($query) use ($data) {
                            return $query->where('academic_shift_id', $data['academic_shift_id']);
                        })->when($data['academic_class_id'], function ($query) use ($data) {
                            return $query->where('academic_class_id', $data['academic_class_id']);
                        })->when($data['academic_department_id'], function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })->when($data['academic_section_id'], function ($query) use ($data) {
                            return $query->where('academic_section_id', $data['academic_section_id']);
                        })->when($data['academic_class_group_id'], function ($query) use ($data) {
                            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                        })->when($data['academic_session_id'], function ($query) use ($data) {
                            return $query->where('academic_session_id', $data['academic_session_id']);
                        })->where('status', 1);
                    });
                })
                ->when($user_type, function ($q) use ($user_type) {
                    return $q->where('user_type', $user_type);
                })->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('username', 'LIKE', $txt)
                            ->orWhere('email', 'LIKE', $txt)
                            ->orWhere('contact_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('first_name', $txt)
                            ->orWhereTranslationLike('last_name', $txt);
                    });
                })->when($joined, function ($qu) use ($date, $meeting_id) {
                    $qu->whereHas('meetingInvitation', function ($q) use ($date, $meeting_id) {
                        $q->where('meeting_id', $meeting_id);
                        $q->where('join_date', $date);
                        $q->where('joined_time', '!=', null);
                    });
                })->with(['meetingInvitation' => function ($q) use ($date, $meeting_id) {
                    $q->where('meeting_id', $meeting_id);
                    $q->where('join_date', $date);
                }])
                ->where('status', $status)
                ->paginate($paginate);

            $user_list->getCollection()->transform(function ($value) {
                return [
                    'id' => $value->id,
                    'selected' => true,
                    'full_name' => $value->full_name ?? '',
                    'username' => $value->student->username ?? '',
                    'join_url' => $value->meetingInvitation->meeting->join_url ?? null,
                    'join_date_time' => $value->meetingInvitation->join_date_time ?? null,
                    'joined_time' => $value->meetingInvitation->joined_time ?? null,
                    'user_activities' => $value->meetingInvitation->user_activities ?? null,
                    'status' => $value->meetingInvitation->status ?? true,
                ];
            });

            if (count($user_list) < 1) {
                throw new Error('No User Found For the Query !');
            }


            return response()->json($user_list, 200);

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }

    }


    public function sendMeetingToUser(Request $request)
    {
        try {


            $date_time = $request->join_date_time;
            $meeting_id = $request->meeting_id;
            $data = $request->userList;
            $the_meeting = $this->meeting->findOrFail($meeting_id);
            $date = date('Y-m-d', strtotime($date_time));

            if (count($data) < 1) {
                throw new Error('No User Found For the Query!');
            }

            $filter_data = array_filter($data, function ($var) {
                return ($var['selected'] == true);
            });


            $all_invitations = $this->meetingInvitation
                ->where('meeting_id', $meeting_id)
                ->where('join_date', $date)
                ->get();


            $user_ids = [];
            $inv = [];
            foreach ($filter_data as $item) {

                $invitation_exist = $all_invitations->where('user_id', $item['id'])->first();

                if ($invitation_exist) {
                    $invitation_exist->join_date_time = $date_time;
                    $invitation_exist->status = $item['status'];
                    $invitation_exist->save();

                } else {
                    $inv[] = new MeetingInvitation(array('user_id' => $item['id'], 'join_date_time' => $date_time, 'join_date' => $date));
                }

                $user_ids[] = $item['id'] ?? 0;

            }
            $the_meeting->invitations()->saveMany($inv);

            $title = "Join " . $the_meeting->topic . " @ " . date('d M Y h:i:s A', strtotime($date_time));
            $description = "An invitation sent for you :" . $the_meeting->topic . ". Join time:" . date('d M Y h:i:s A', strtotime($date_time));

            $users = $this->user->whereIn('id', $user_ids)->get();
            Notification::send($users, new MeetingInvitationSent($the_meeting, $title, $description));


            $this->logDetails($the_meeting, 'Invitation To: ' . $request->user_type . ' :' . count($filter_data));
            //  $this->logDetails($the_meeting, 'Invitation To: ' . $this->getStudentHistoryDetails($request) . ' :' . count($filter_data));
            return response()->json(['mode' => 'Success', 'message' => 'Successfully Send To:' . count($filter_data)], 200);

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }

    }


    public function sendMeetingToRoutine(Request $request)
    {
        try {


            $meeting_id = $request->meeting_id;
            $date = $request->att_date;
            $routinePeriodList = $request->routinePeriodList;
            $the_meeting = $this->meeting->find($meeting_id);

            if (!$the_meeting) {
                throw new Error('No Meeting Found!');
            }

            /* $filter_data = array_filter($routinePeriodList, function ($var) {
                 return ($var['selected'] == true);
             });*/

            $formatted_date = date('Y-m-d', strtotime($date));
            $all_invitations = $this->meetingInvitation
                //  ->where('meeting_id', $meeting_id)
                ->where('join_date', $formatted_date)
                ->get();

            $inv = [];
            $count = 0;
            foreach ($routinePeriodList as $item) {
                $invitation_exist = $all_invitations->where('routine_allocation_id', $item['id'])->first();


                if ($invitation_exist) {
                    if ($item['invited']) {

                        $invitation_exist->join_date_time = $formatted_date;
                        $invitation_exist->meeting_id = $meeting_id;
                        $invitation_exist->status = $item['invited'];
                        $invitation_exist->save();
                        $count++;
                    } else {
                        $invitation_exist->delete();
                    }

                } else {
                    if ($item['invited']) {
                        $inv[] = new MeetingInvitation(array('routine_allocation_id' => $item['id'], 'subject_id' => 0, 'join_date' => $date, 'status' => $item['invited']));
                        $count++;
                    }
                }
            }
            $the_meeting->invitations()->saveMany($inv);

            $this->logDetails($the_meeting, ' invited to  ' . $count . ' Routine allocation for:' . date('d M yy', strtotime($date)));


            return response()->json(['mode' => 'Success', 'message' => 'Successfully send to:' . $count . ' allocations'], 200);

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }

    }


    public function getInvitationList(Request $request)
    {

        // return Auth::user()->id;

        $status = $request->status;
        $search_txt = $request->search_txt;
        $date = $request->join_date;
        // $date_range = $request->date_range ? json_decode($request->date_range) : null;
        $paginate = $request->paginate ?? 20;
        $txt = '%' . $search_txt . '%';

        $meetings = $this->meetingInvitation
            ->where('user_id', Auth::user()->id)
            ->whereDate('join_date', '>=', $date)
            ->whereDate('join_date', '<=', $date)
            ->when($search_txt, function ($q1) use ($txt) {
                $q1->whereHas('meeting', function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('meeting_id', 'LIKE', $txt)
                            ->orWhere('contact_email', 'LIKE', $txt);
                    });
                });

            })
            ->orderBy('id', 'DESC')
            ->paginate($paginate);

        $meetings->getCollection()->transform(function ($value) {
            return [
                'id' => $value->id,
                'joining' => false,
                'join_url' => $value->meeting->join_url ?? null,
                'join_date_time' => $value->join_date_time ?? null,
                'joined_time' => $value->joined_time ?? null,
                'meeting_details' => $value->meeting->meeting_id ?? null,
            ];
        });

        return response()->json($meetings, 200);


    }


    public function saveUserActivity(Request $request)
    {
        $the_inv = $this->meetingInvitation
            ->with('meeting')
            ->find($request->invitation_id);
        if (!$the_inv->status) {
            return response()->json(['message' => 'Your invitation has expired!'], 410);
        }


        $date = new DateTime($the_inv->join_date_time);
        $date2 = new DateTime("now");

        $diff = $date2->getTimestamp() - $date->getTimestamp();

        if ($diff < 0) {
            return response()->json(['message' => 'Your meeting time not started yet!'], 410);
        }

//        return response()->json(['message' => 'Your invitation has expired!' . $date . '-' . $date2 . '-' . $diff], 410);


        $time = Carbon::now()->toDateTime()->format('d M Y g:i A');
        $the_inv->joined_time = Carbon::now()->toDateTime()->format('yy-m-d H:i:s');
        $the_inv->user_activities = ($the_inv->user_activities . ' <br/> User joined the meeting <i class="fa fa-clock-o"></i>' . $time);

        $the_inv->save();


        $return = [
            'join_url' => $the_inv->meeting->join_url ?? null,
        ];


        return response()->json($return, 200);


    }

    private function logDetails($the_meeting, $sent_log)
    {
        $time = Carbon::now()->toDateTime()->format('d M Y g:i A');

        $the_meeting->sent_request = ($the_meeting->sent_request . ' <br/>' . $sent_log . ' <i class="fa fa-clock-o"></i>' . $time);
        $the_meeting->save();

        return $the_meeting;
    }

    public function getZoomMeetingList(Request $request)
    {

        /*  $dtae="2020-11-20T02:55:00Z";

    //        $rr=gmdate("Y-m-d H:i:s", strtotime($dtae));

         $rr= date("Y-m-d H:i:s", strtotime($dtae));
          dd($rr);*/


        $status = $request->status;
        $search_txt = $request->search_txt;
        // $date_range = $request->date_range ? json_decode($request->date_range) : null;
        $paginate = $request->paginate ?? 20;
        $txt = '%' . $search_txt . '%';

        $meeting = $this->meeting
            ->where('streamed_by', $request->type)
            ->where('user_id', Auth::user()->id)
            //    ->where('status', $status)
            //->whereDate('created_at', '>=', $date_start)
            // ->whereDate('created_at', '<=', $date_end)
            ->when($search_txt, function ($q) use ($txt) {
                return $q->where(function ($query) use ($txt) {
                    $query->where('meeting_id', 'LIKE', $txt)
                        ->orWhere('contact_email', 'LIKE', $txt);
                });
            })
            ->orderBy('id', 'DESC')
            ->paginate($paginate);


        $meeting->getCollection()->transform(function ($value) {

            return
                [
                    'id' => $value->id,
                    'loading' => false,
                    'meeting_id' => $value->meeting_id,
                    'contact_email' => $value->contact_email,
                    'topic' => $value->topic,
                    'start_time' => $value->start_time,
                    'join_url' => $value->join_url,
                    'start_url' => $value->start_url,
                    'duration' => $value->duration,
                    'sent_request' => $value->sent_request,
                    'updated_at' => $value->updated_at,
                    'status' => $value->status,
                ];
        });


        return response()->json($meeting, 200);
    }


    public function getMeetingDetails($m_id)
    {

        $the_meeting = $this->meeting
            ->where('id', $m_id)
            ->where('user_id', Auth::user()->id)
            ->first();

        //dd($the_meeting);

        return response()->json($the_meeting, 200);
    }

    public function getZoomMeeting($id)
    {
        $setting = $this->setting->where('type', 'zoom')
            ->where('created_by', Auth::user()->id)
            ->first();


        $meeting = $this->meeting
            ->where('id', $id)
            ->where('user_id', Auth::user()->id)
            ->first();

        $response = $this->getMeeting($meeting->meeting_id, $setting->api_token);
        $response_decoded = json_decode($response);


        if ($response_decoded->code ?? null) {
            return response()->json(['message' => $response_decoded->message], 413);
        }

        if (!$meeting) {
            $meeting = new Meeting();
        }


        $meeting->streamed_by = 'zoom';
        $meeting->contact_email = $response_decoded->host_email ?? '';
        $meeting->meeting_id = $response_decoded->id ?? '';
        $meeting->uuid = $response_decoded->uuid ?? '';
        $meeting->host_id = $response_decoded->host_id ?? '';
        $meeting->topic = $response_decoded->topic ?? '';
        $meeting->start_time = date("Y-m-d H:i:s", strtotime($response_decoded->created_at)) ?? '';
        $meeting->start_url = $response_decoded->start_url ?? '';
        $meeting->join_url = $response_decoded->join_url ?? '';
        $meeting->recurrence = $response_decoded->recurrence ?? '';

        $meeting->user_id = Auth::user()->id;
        $meeting->response = $response;
        $meeting->save();

        return response()->json([$meeting, $response_decoded], 200);
    }


    public function createZoomMeeting(Request $request)
    {


        /* return $request->start_time;
         return date("Y-m-d h:i:s", strtotime($request->start_time)) ;*/


        $this->validate($request, [
            'start_time' => 'required',
            'topic' => 'required',
        ]);

        $setting = $this->setting->where('type', 'zoom')->where('created_by', Auth::user()->id)->first();

        if (!$setting) {
            return response()->json(['message' => 'Please Set Api Setting First'], 412);
        }


        $req = array(
            'start_time' => date("Y-m-d h:i:s", strtotime($request->start_time)),
            'topic' => $request->topic,
            'email' => $setting->email,
            'token' => $setting->api_token,
        );


        $response = $this->zoomMeetingCreate($req);
        $response_decoded = json_decode($response);

//        \Log::info($response);

        if ($response_decoded->id ?? null) {

        } else {
            return response()->json(['message' => 'Zoom Meeting Returns: ' . $response], 412);

        }

        $meeting = new Meeting();

        $meeting->streamed_by = 'zoom';
        $meeting->contact_email = $response_decoded->host_email ?? '';
        $meeting->meeting_id = $response_decoded->id ?? '';
        $meeting->uuid = $response_decoded->uuid ?? '';
        $meeting->host_id = $response_decoded->host_id ?? '';
        $meeting->topic = $response_decoded->topic ?? '';
        $meeting->start_time = date("Y-m-d H:i:s", strtotime($response_decoded->start_time)) ?? '';
        $meeting->start_url = $response_decoded->start_url ?? '';
        $meeting->join_url = $response_decoded->join_url ?? '';
        $meeting->recurrence = $response_decoded->recurrence ?? '';
        $meeting->user_id = Auth::user()->id;

        $meeting->response = $response;
        $meeting->save();

        return response()->json(['message' => 'Zoom Meeting Successfully Created!', 'mode' => 'save'], 200);
    }

    public function zoomMeetingDelete($id)
    {
        $setting = $this->setting->where('type', 'zoom')->where('created_by', Auth::user()->id)->first();
        $the_meeting = $this->meeting->find($id);

        $this->deleteZoomMeeting($the_meeting->meeting_id, $setting->api_token);
        $the_meeting->delete();

        return response()->json(['message' => 'Zoom Meeting Successfully Deleted!', 'mode' => 'save'], 200);
    }

}
