<?php

namespace App\Http\Controllers\Site\Live;

use App\Models\Site\Live\Setting;
use App\Traits\LiveStreamingApiTrait;
use Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class SettingController extends Controller
{
    use   LiveStreamingApiTrait;

    private $setting;

    public function __construct(Setting $setting)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');


        $this->setting = $setting;
    }


    public function getSetting(Request $request)
    {
        // $setting = $this->setting->where('type', $request->type)->first();
        $setting = $this->setting
            ->where('type', 'zoom')
            ->where('created_by', Auth::user()->id)
            ->first();

        return response()->json($setting, 200);
    }


    public function getMeeting(Request $request)
    {
        $setting = $this->setting
            ->where('type', $request->type)
            ->where('created_by', Auth::user()->id)
            ->first();
        return response()->json($setting, 200);
    }


    public function create(Request $request)
    {

        // return $request;


        $this->validate($request, [
            'email' => 'required',
            'api_token' => 'required',
        ]);


        if ($request->id) {
            $setting = $this->setting->find($request->id);
            $this->setting = $setting;
            $message = 'Successfully Updated!';
        } else {
            $this->setting = new Setting();
            $message = 'Successfully Saved!';

        }


        if (isset($this->setting->ownFields)) {
            foreach ($this->setting->ownFields as $ownField) {
                if ($request->{$ownField}) {
                    $this->setting->{$ownField} = $request->{$ownField};
                }
            }
            $this->setting->created_by = Auth::user()->id;
        }

        $this->setting->save();

        return response()->json(['message' => $message, 'mode' => 'save', 'data' => $this->setting], 200);
    }

}
