<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/16/16
 * Time: 2:25 PM
 */

namespace App\Http\Controllers\Site\Message;

use App\Forms\NoticeForm;
use App\Forms\MessageForm;
use App\Http\Controllers\Controller;
use App\Forms\FormControll;
use App\Forms\DataHelper;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicClass;
use App\Models\Site\Notice\Notice;
use App\Models\Site\Notification\Notification;
use App\Models\Site\Role\SiteRole;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;

use App\Models\Role\Role;
use App\Models\User\User;
use App\Notifications\TaskCompleted;
use Carbon\Traits\Date;
use DB;
use Exception;
use Faker\Provider\cs_CZ\DateTime;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Requests;
use Carbon\Carbon;

use Illuminate\Notifications\HasDatabaseNotifications;
use Illuminate\Notifications\Notifiable;

use Illuminate\Validation\ValidationException;
use Image;
use Response;


class MessageController extends Controller
{
    use Notifiable, Lang, FormControll, DataHelper;


    private $notice;

    /**
     * NoticesController constructor.
     * @param Notice $notice
     */
    public function __construct(Notice $notice)
    {

        $this->middleware('auth');
        $this->notice = $notice;
        $this->middleware('sitepagechecker');
    }



//    /**
//     * @param Notice $notice
//     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
//     */
    public function messageIndex(Notice $notice)
    {
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();

        $messageList = $notice->with('user')->where('type', 'message')->get();
        //dd($messageList);

        $viewType = 'Message List';

        return view('default.admin.message.index', compact('viewType', 'messageList', 'locale', 'defaultLocale'));
    }


//    /**
//     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
//     */
    public function createMessageForm()
    {
        $viewType = 'Create Message';

        return view('default.admin.message.create', compact('viewType'));
    }
//
//    /**
//     * @param Requests\Validator $validatedRequest
//     */
    public function createMessage(Notice $notice, Notification $notification, Request $validatedRequest)
    {

        try {

            if ($validatedRequest->notice_name == null) {
                return Response::json(['message' => 'Subject field is required'], 300);
            } elseif ($validatedRequest->notice_description == null) {
                return Response::json(['message' => 'Description field is required'], 300);
            }

            foreach ($this->notice->translatedAttributes as $field) {
                foreach (config('app.locales') as $locale => $value) {
                    if ($validatedRequest->get($field . '_' . $locale)) {
                        $this->notice->translateOrNew($locale)->{$field} = $validatedRequest->get($field . '_' . $locale);
                    }
                }
            }

            if ($validatedRequest->notice_image != "") {
                $name = time() . '.' . explode('/', explode(':', substr($validatedRequest->notice_image, 0, strpos($validatedRequest->notice_image, ';')))[1])[1];
                Image::make($validatedRequest->notice_image)->save(public_path('img/site/messageImage/') . $name);
                $validatedRequest->merge(['notice_image' => $name]);
                $userPhoto = public_path('img/noticeImage/');
                if (file_exists($userPhoto)) {
                    @unlink($userPhoto);
                }

                $notice->notice_image = $name;
            }

            $roles = [];
            if ($validatedRequest->sendto == "all") {

                $roles = SiteRole::where('name', "!=", 'admin')->pluck('id');
                $notice->send_to_role_ids = $roles->implode(',');

            } else {
                $roleListArray = [];
                if ($validatedRequest->roleListcheckbox) {
                    $roleListArray = $validatedRequest->roleListcheckbox;

                }
                $roleList = collect($roleListArray)->implode(',');
                $notice->send_to_role_ids = $roleList;
            }

            $employeeUserArray = [];
            if ($validatedRequest->employeeListcheckbox) {
                $employeeUserArray = $validatedRequest->employeeListcheckbox;
            }
            $studentArray = [];
            if ($validatedRequest->studentListcheckbox) {
                $studentArray = $validatedRequest->studentListcheckbox;
            }
            $guardianArray = [];
            if ($validatedRequest->guardianListcheckbox) {
                $guardianArray = $validatedRequest->guardianListcheckbox;
            }

            $guestUserArray = [];
            if ($validatedRequest->guestUserListcheckbox) {
                $guestUserArray = $validatedRequest->guestUserListcheckbox;
            }

            $allListArrayMerge = array_merge($employeeUserArray, $studentArray, $guardianArray, $guestUserArray);
            $arrayImplode = collect($allListArrayMerge)->implode(',');


            $siteRolelist = SiteRole::whereIn('id', $roles)->pluck('name');
            $siteUsers = User::whereIn('user_type', $siteRolelist)->pluck('id');


            $userlist = User::whereIn('id', $allListArrayMerge)->pluck('id');
            // return $userlist;

            $classListArray = [];
            if ($validatedRequest->classListcheckbox) {
                $classListArray = $validatedRequest->classListcheckbox;

            }
            $classList = collect($classListArray)->implode(',');


            $userListClassWise = User::whereIn('academic_class_id', $classListArray)->pluck('id');

            //role list wise work

            $roleListArray = [];
            if ($validatedRequest->roleListcheckbox) {
                $roleListArray = $validatedRequest->roleListcheckbox;

            }

            $siteRolelist2 = SiteRole::whereIn('id', $roleListArray)->pluck('name');
            $userListRoleWise = User::whereIn('user_type', $siteRolelist2)->pluck('id');


            $userListClassWiseAnduserListRoleWiseMerge = array_merge($userListClassWise->toArray(), $userListRoleWise->toArray());

            //return $userListClassWiseAnduserListRoleWiseMerge;

            $notice->notice_name = $validatedRequest->get('notice_name');
            $notice->notice_description = $validatedRequest->get('notice_description');
            //$notice->notice_publish_date = $validatedRequest->get('notice_publish_date');
            // $notice->send_from = $validatedRequest->get('send_from');
            $notice->send_to_academic_department_ids = $validatedRequest->get('send_to_academic_department_ids');
            $notice->send_to_academic_class_ids = $classList;
            $notice->send_to_user_ids = $arrayImplode;
            $notice->type = 'message';
            $notice->created_by = request()->user()->id;

            $notice->status = $validatedRequest->get('status');

            if (count($userListClassWiseAnduserListRoleWiseMerge) > 0 || count($siteUsers) > 0 || count($userlist) > 0) {


                //auth()->user()->notify(new TaskCompleted());

                //Log:info(notify(new TaskCompleted()));
                $notice->save();
            }
            $noticeid = $notice->id;
            $noticeTitle = $notice->notice_name;


            if (count($siteUsers) > 0) {
                foreach ($siteUsers as $key => $value) {

                    $charges[] = [
                        'type' => 'message',
                        'notifiable_type' => 'App\User',
                        'notifiable_id' => $value,
                        'data' => json_encode($noticeTitle),
                        'notice_id' => $noticeid,
                        'created_at' => Carbon::now(),


                    ];
                }

            } else if (count($userlist) > 0) {

                foreach ($userlist as $keys => $values) {

                    $charges[] = [
                        'type' => 'message',
                        'notifiable_type' => 'App\User',
                        'notifiable_id' => $values,
                        'data' => json_encode($noticeTitle),
                        'notice_id' => $noticeid,
                        'created_at' => Carbon::now(),


                    ];
                }
            } else if (count($userListClassWiseAnduserListRoleWiseMerge) > 0) {
                foreach ($userListClassWiseAnduserListRoleWiseMerge as $ke => $va) {


                    $charges[] = [
                        'type' => 'message',
                        'notifiable_type' => 'App\User',
                        'notifiable_id' => $va,
                        'data' => json_encode($noticeTitle),
                        'notice_id' => $noticeid,
                        'created_at' => Carbon::now(),

                    ];
                }

            } else {
                return Response::json(['message' => 'No User Found!'], 300);
            }


            $notification->insert($charges);
            return Response::json(['message' => 'Message Send Successfully!'], 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }

    }


    public function messageInbox()
    {

        $viewType = 'Inbox';
        $notification = auth()->user()->notifications()->where('read_at', null)->get();

        if ($notification) {
            $notification->markAsRead();
            //return redirect($notification->data['link']);
        }

        return view('default.admin.message.inbox', compact('viewType'));
    }


    public function getMessageListWithPagination()
    {


        // $loggerId = request()->user()->id;

        $messageList = Notice::with(['notification'])
            ->whereHas('notification', function ($query) {
                $loggerId = request()->user()->id;
                return $query->where('status', 1)->where('notifiable_id', $loggerId);
            })
            ->where('status', '=', '1')
            ->where('type', '=', 'message')
            ->orderBy('id', 'desc')->paginate(10);

        $CountmessageList = Notice::with(['notification'])
            ->whereHas('notification', function ($query) {
                $loggerId = request()->user()->id;
                return $query->where('status', 1)->where('notifiable_id', $loggerId);
            })
            ->where('status', '=', '1')
            ->where('type', '=', 'message')
            ->count();

        return [$messageList, $CountmessageList];
    }


    public function getSentMessageListWithPagination()
    {
        $loggerId = request()->user()->id;

        $sentMessageList = Notice::select('id', 'notice_publish_date', 'send_from', 'type', 'notice_image', 'status', 'sent_status', 'created_by', 'created_at')
            ->where('sent_status', 1)
            ->where('type', '=', 'message')
            ->where('created_by', $loggerId)
            ->orderBy('id', 'desc')->paginate(10);


        $countSentMessageList = Notice::all()
            ->where('sent_status', 1)
            ->where('type', '=', 'message')
            ->where('created_by', $loggerId)
            ->count();

        return [$sentMessageList, $countSentMessageList];
    }


    public function viewMessage($id)
    {
        $viewType = 'View Message';
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();

        $noticeData = $this->notice->findOrFail($id);

        $notification = auth()->user()->notifications()->where('notice_id', $id)->first();

        if ($notification) {
            $notification->markAsRead();
            //return redirect($notification->data['link']);
        }

        return view('default.admin.message.view', compact('viewType', 'noticeData', 'locale', 'defaultLocale'));
    }


    public function getTrashMessageListWithPagination()
    {

        $loggerId = request()->user()->id;
        $tarshMessageList = Notice::with(['notification'])
            ->whereHas('notification', function ($query) {
                $loggerId = request()->user()->id;
                return $query->where('status', 0)
                    ->
                    where('notifiable_id', $loggerId);
            })
            ->where('type', '=', 'message')
            ->where('created_by', $loggerId)
            ->orderBy('id', 'desc')->paginate(10);


        $counttarshMessageList = Notice::with(['notification'])
            ->whereHas('notification', function ($query) {
                $loggerId = request()->user()->id;
                return $query->where('status', 0)
                    ->
                    where('notifiable_id', $loggerId);
            })
            ->where('type', '=', 'message')
            ->where('created_by', $loggerId)
            ->count();

        return [$tarshMessageList, $counttarshMessageList];
    }


    public function sentmessageDelete($id)
    {
        $loggerId = request()->user()->id;
        $messageSoftDelete = Notice::where('id', $id)
            ->where('created_by', $loggerId)
            ->where('type', 'message')
            ->where('sent_status', 1)
            ->first();
        $messageSoftDelete->sent_status = 0;
        $messageSoftDelete->save();
        return Response::json(['message' => 'Successful!']);
    }

    public function softDeleteMessage($id)
    {
        try {
            // $loggerId = request()->user()->id;
            $messageSoftDelete = Notification::where('notice_id', $id)
                ->where('type', 'message')
                ->first();

            if ($messageSoftDelete->status == 0) {
                $messageSoftDelete->delete();
                return Response::json(['message' => 'Successfully Delete!']);

            } else {
                $messageSoftDelete->status = 0;
                $messageSoftDelete->save();
                return Response::json(['message' => 'Successful!']);
            }


        } catch (Exception $ex) {
            return Response::json(['message' => 'Something went Wrong!'], 405);

        } catch (ModelNotFoundException $ex) {
            return Response::json(['message' => 'The Notice Not Found!'], 405);

        }
    }


}