<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/16/16
 * Time: 2:25 PM
 */

namespace App\Http\Controllers\Site\Notice;


use App\Http\Controllers\Controller;
use App\Http\Controllers\ProjectController;
use App\Jobs\Site\NoticeJob;
use App\Models\Image\Photo;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Notice\Notice;
use App\Models\Student\StudentHistory;
use Auth;
use Carbon\Carbon;
use Error;
use Exception;
use File;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\Storage;
use Image;
use Response;

/*

use Illuminate\Support\Facades\Notification;

// Get the users
$users = User::where(...)->get();

// Send the notifications
Notification::send($users, new TaskAssigned($task));*/

class NoticesController extends ProjectController
{


    private $notice;
    private $employee;

    /**
     * NoticesController constructor.
     * @param Notice $notice
     */
    public function __construct(Notice $notice, Employee $employee)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->notice = $notice;
        $this->employee = $employee;
    }


    /**
     * @param Notice $notice
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {

        $viewType = 'Notice List';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.notice.index', compact('viewType'));
    }


    public function createNotice(Notice $notice, Request $request)
    {

        // return $request;


        $this->validate($request, [
            'notice_title' => 'required',
          //  'notice_description' => 'required',
           // 'files0' => 'mimes:jpeg,png,jpg,gif,svg,bmp,pdf',
        ]);

        $files = range(1, $request->length);
        $file_path = null;
        $user_id = Auth::user()->id;

        if($request->pin_status=='true'){
            $pin_status=1;
        }else{
            $pin_status=0;
        }


        $notice->notice_title = $request->notice_title;
        $notice->doc_number = $request->doc_number;
        $notice->notice_description = $request->notice_description ?? $request->notice_title;
        $notice->type = 'notice';
        $notice->created_by = request()->user()->id;
        $notice->status = $request->status;
        $notice->pin_status = $pin_status;
        $notice->save();


        if ($request->length) {
            foreach ($files as $k => $val) {

                $file = Input::file('files' . $k);
                $file_name = $notice->site_id . '/' . $file->getClientOriginalName().'-'. uniqid() . '.' . $file->getClientOriginalExtension();

                Storage::disk('uploads')->put($file_name, File::get($file));
                $file_path = '/uploads/files/' . $file_name;

                $notice->files()->create([
                    'user_id' => $user_id,
                    'path' => $file_path,
                    'name' => $file->getClientOriginalName(),
                ]);
            }
        }

        return response()->json(['message' => 'Successfully Saved!', 'mode' => 'save'], 200);
    }

    public function updateNotice(Request $request)
    {
        try {
            if($request->pin_status=='true'){
                $pin_status=1;
            }else{
                $pin_status=0;
            }


            $the_notice = $this->notice->findOrFail($request->id);
            if ($request->web_publish_time) {
                $the_notice->web_publish_time = $request->web_publish_time;
                $the_notice->pin_status = $pin_status;
                $the_notice->web_publish_by = Auth::user()->id;

                $this->logNoticeSentDetails($the_notice, '<b>Publish on web </b> ');
                $the_notice->save();
                return response()->json(['message' => 'The Notice Will Be Published To Web At ' . $the_notice->web_publish_time, 'mode' => 'Update'], 200);
            }
            $this->validate($request, [
                'notice_title' => 'required',
            ]);


            $files = range(1, $request->length);
            $file_path = null;
            $deletes = $request->deletes ? explode(',', $request->deletes) : [];

            $the_notice = $this->notice->findOrFail($request->id);

            foreach ($the_notice->ownFields as $k => $ownField) {
                if ($request->{$ownField}) {
                    $the_notice->{$ownField} = $request->{$ownField};
                }
            }

            $the_notice->status = $request->status;
            $the_notice->pin_status= $pin_status;
            $the_notice->save();

            if ($request->length) {
                foreach ($files as $k => $val) {

                    $file = Input::file('files' . $k);
                    $file_type = $file->getClientMimeType();

                    $file_name = $the_notice->site_id . '/' . $file->getClientOriginalName().'-'. uniqid() . '.' . $file->getClientOriginalExtension();
                    $file_path = '/uploads/files/' . $file_name;

                    if (in_array($file_type, ['image/png', 'image/gif', 'image/jpeg', 'image/png'])) {
                        Image::make($file->getRealPath())->resize(700, null, function ($constraint) {
                            $constraint->aspectRatio();
                        })->save('uploads/files/' . $file_name);

                    } else {
                        Storage::disk('uploads')->put($file_name, File::get($file));
                    }

                    $this->deleteFiles($the_notice);


                    $the_notice->files()->create([
                        'user_id' => Auth::user()->id,
                        'path' => $file_path,
                        'name' => $file->getClientOriginalName(),
                    ]);
                }
            }

            if (count($deletes)) {

                foreach ($deletes as $k => $id) {
                    $the_photo = Photo::where('id', $id)->first();
                    $image_path = public_path($the_photo->path);
                    if (File::exists($image_path)) {
                        unlink($image_path);
                    }
                    $the_photo->delete();
                }
            }


            return response()->json(['data' => $the_notice, 'message' => $the_notice->notice_name . ' Successfully Updated!', 'mode' => 'Update'], 200);
        } catch (ModelNotFoundException $exception) {
            throw new Error($exception->getMessage());

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }

    }


    public function getNoticeDetails($id)
    {
        try {
            $the_notice = $this->notice
                ->with('files')
                ->findOrFail($id);

            return response()->json($the_notice, 200);

        } catch (Exception $ex) {
            return Response::json([$ex->getMessage()], 405);
        }

    }

    public function sendNoticeToStudent(Request $request, Notice $notice)
    {
        try {

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id;
            $data['academic_section_id'] = $request->academic_section_id;
            $data['academic_session_id'] = $request->academic_session_id;
            $notice_id = $request->notice_id;

            $the_notice = $notice->findOrFail($notice_id);

            $user_ids_array = (new StudentHistory)
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->whereHas('student')
                ->where('status', 1)
                //  ->limit(5)
                ->pluck('user_id');

            if (count($user_ids_array) < 1) {
                throw new Error('No Student Found For the year !');
            }
            $this->sendNotification($user_ids_array, $the_notice);
            $this->logNoticeSentDetails($the_notice, 'Student of: ' . $this->getStudentHistoryDetails($data) . ' Total:' . count($user_ids_array));

            return Response::json(['mode' => 'Success', 'message' => 'Successfully Send To:' . count($user_ids_array)], 200);

        } catch (ModelNotFoundException $exception) {
            throw new Error($exception->getMessage());

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }

    }

    public function sendNoticeToGuardian(Request $request, Notice $notice)
    {


        try {


            $data = [];
            $data['academic_version_id'] = $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id;
            $data['academic_section_id'] = $request->academic_section_id;
            $data['academic_session_id'] = $request->academic_session_id;

            $notice_id = $request->notice_id;
            // $notice_publish_date = $request->publish_date;


            $the_notice = $notice->findOrFail($notice_id);

            $user_ids_array = [];


            $user_ids_array = (new StudentHistory)
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->whereHas('student', function ($q) {
                    $q->where('status', 1);
                })
                ->with('student')
                ->where('status', 1)
                ->get()
                //  ->limit(5)
                ->pluck('student.local_guardian_user_id')
                ->filter();;


            //   return $user_ids_array;

            if (count($user_ids_array) < 1) {
                throw new Error('No Guardian Found!');
            }
            $this->sendNotification($user_ids_array, $the_notice);
            $this->logNoticeSentDetails($the_notice, 'Guardian of: ' . $this->getStudentHistoryDetails($data) . ' :' . count($user_ids_array) . ' Users');

            return Response::json(['mode' => 'Success', 'message' => 'Successfully Send To:' . count($user_ids_array)], 200);
        } catch (ModelNotFoundException $exception) {
            throw new Error($exception->getMessage());

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }


    public function sendNoticeToEmployee(Request $request, Notice $notice)
    {


        try {

            $notice_id = $request->notice_id;
            $user_ids_array = $request->id_array;


            $the_notice = $notice->findOrFail($notice_id);


            if (count($user_ids_array) < 1) {
                throw new Error('No Employee Found!');
            }
            $this->sendNotification($user_ids_array, $the_notice);
            $this->logNoticeSentDetails($the_notice, 'Employee:' . count($user_ids_array) . ' Numbers');

            return Response::json(['mode' => 'success', 'message' => 'Successfully Send To:' . count($user_ids_array) . ' Employee'], 200);

        } catch (ModelNotFoundException $exception) {
            throw new Error($exception->getMessage());

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    private function sendNotification($user_ids_array, Notice $the_notice)
    {

        $route = 'user/notification/view';// route('site-notice-view', ['']);
        dispatch(new NoticeJob($user_ids_array, $the_notice, $route));

    }


    private function logNoticeSentDetails($the_notice, $sent_log)
    {
        $time = Carbon::now()->toDateTime()->format('d M Y g:i A');
        $the_notice->sent_request = ($the_notice->sent_request . ' <br/>' . $sent_log . ' <i class="fa fa-clock-o"></i>' . $time);
        $the_notice->save();

        return $the_notice;
    }

    public function getNoticeListWithPagination(Request $request)
    {
        try {
            $status = $request->status;
            $search_txt = $request->search_txt;
            $date_range = $request->date_range ? json_decode($request->date_range) : null;
            $paginate = $request->paginate ?? 20;
            $txt = '%' . $search_txt . '%';

            if (!$date_range) {
                throw new Error('Please select Date');
            }


            $date_start = $date_range->start;//.' 00:00:00';
            $date_end = $date_range->end ?? $date_start;

            $noticeList = $this->notice
                ->where('status', $status)
                ->where('type', 'notice')
                ->whereDate('created_at', '>=', $date_start)
                ->whereDate('created_at', '<=', $date_end)
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('doc_number', 'LIKE', $txt)
                            ->orWhere('track_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('notice_name', $txt);
                    });
                })->with('files')
                ->orderBy('id', 'DESC')
                ->paginate($paginate);
            //  ->toSql();

            return $noticeList;
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }


    public function deleteNotice($id)
    {
        try {

            $the_notice = $this->notice->findOrFail($id);
            $the_notice->delete();
            $the_notice->deleteTranslations();

            $this->deleteFiles($the_notice);

            return Response::json(['message' => 'Successfully Deleted!'], 200);


        } catch (ModelNotFoundException $ex) {
            return Response::json(['message' => 'The Notice Not Found!'], 405);

        } catch (Exception $ex) {
            return Response::json(['message' => 'Something went Wrong!'], 405);
        }
    }

    private function deleteFiles($the_notice)
    {


        foreach ($the_notice->files as $k => $file) {
            $the_photo = Photo::where('id', $file->id)->first();
            $image_path = public_path($the_photo->path);
            if (File::exists($image_path)) {
                unlink($image_path);
            }
            $the_photo->delete();
        }
    }

    public function deleteNoticeFromNotification($id)
    {
        try {


            Notification::where('notice_id', $id)->delete();

            return back()->withSuccess('Successfully Deleted');

        } catch (ModelNotFoundException $ex) {
            return Response::json(['message' => 'The Notice Not Found!'], 405);
        } catch (Exception $ex) {
            return Response::json(['message' => 'Something went Wrong!'], 405);

        }

    }


    public function messageIndex(Notice $notice)
    {
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();

        $messageList = $notice->with('user')->where('type', 'message')->get();
        //dd($messageList);

        $viewType = 'Message List';

        return view('default.admin.message.index', compact('viewType', 'messageList', 'locale', 'defaultLocale'));
    }
//
//    public function messageSent(Notice $notice)
//    {
//        $viewType = 'Sent';
//        $loggerId = request()->user()->id;
//        $sentMessageList = $notice->with('user')->where('type', 'message')->where('from_send', $loggerId)->get();
//
//
//        return view('default.admin.message.sent', compact('viewType', 'sentMessageList'));
//    }
//
//    public function messageInbox(Notice $notice)
//    {
//        $locale = $this->chosenLanguage();
//        $defaultLocale = $this->defaultLocale();
//
//        $loggerId = request()->user()->id;
//        //dd($loggerId);
//
//        $inboxMessageList = $notice->with('user')->where('type', 'message')->where('to_send', $loggerId)->get();
//        //dd($inboxMessageList);
//
//        $viewType = 'Inbox';
//
//        return view('default.admin.message.inbox', compact('viewType', 'inboxMessageList', 'locale', 'defaultLocale'));
//    }
//
//    public function messageTrash(Notice $notice)
//    {
//        $locale = $this->chosenLanguage();
//        $defaultLocale = $this->defaultLocale();
//
//        $loggerId = request()->user()->id;
//
//        $trashMessageList = $notice->onlyTrashed()
//            ->where('type', 'message')
//            ->where('to_send', $loggerId)
//            ->get();
//        //dd($trashMessageList);
//        $viewType = 'Trash';
//
//        return view('default.admin.message.trash', compact('viewType', 'trashMessageList', 'locale', 'defaultLocale'));
//    }
//
//    /**
//     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
//     */

//
//    /**
//     * @param Requests\Validator $validatedRequest
//     */

//
//    /**
//     * Select users by role
//     *
//     * @param $roleId
//     * @param Role $role
//     * @param Request $request
//     * @return \Illuminate\Http\JsonResponse
//     */
//    public function userOfRole($roleId, Role $role, Request $request)
//    {
//        $roleOfUser = $role->findOrFail($roleId);
//        $users = $roleOfUser->users;
//        if ($request->ajax()) {
//            return response()->json([$users]);
//        }
//    }
//
//    /**
//     * @param $id
//     * @param MessageForm $messageForm
//     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
//     */
//    public function getMessageEditForm($id, MessageForm $messageForm)
//    {
//        $viewType = 'Edit Message';
//        $editMessage = $messageForm;
//        $messageData = $this->editFormModel($this->notice->findOrFail($id));
//
//        return view('default.admin.message.edit', compact('viewType', 'editMessage', 'messageData'));
//    }
//
//    /**
//     * @param $id
//     * @param Requests\Validator $validatedRequest
//     * @return null
//     */
//    public function editMessage($id, Requests\Validator $validatedRequest)
//    {
//        $messageToEdit = $this->notice->findOrFail($id);
//
//        foreach ($messageToEdit->translatedAttributes as $field) {
//            foreach (config('app.locales') as $locale => $value) {
//                if ($validatedRequest->get($field . '_' . $locale)) {
//                    $messageToEdit->translateOrNew($locale)->{$field} = $validatedRequest->get($field . '_' . $locale);
//                }
//            }
//        }
//        //$noticeToEdit->notice_date = $validatedRequest->get('notice_date');
//        $messageToEdit->from_send = request()->user()->id;
//        $messageToEdit->to_send = $validatedRequest->get('to_send');
//        $messageToEdit->type = 'message';
//        $messageToEdit->is_read = 0;
//        $messageToEdit->access_lists = null;
//        $messageToEdit->status = $validatedRequest->get('status');
//
//        return $messageToEdit->save() ? back()->withSuccess('Successfully Updated') : null;
//    }
//
//    /**
//     * @param $id
//     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
//     */
//    public function viewMessage($id)
//    {
//        $locale = $this->chosenLanguage();
//        $defaultLocale = $this->defaultLocale();
//        $messageData = $this->notice->with('user')->findOrFail($id);
////        $messageData = $this->notice->onlyTrashed()
////            ->where('type', 'message')
//////            ->where('to_send', $loggerId)
////            ->where('id', $id)
////            ->get();
//        return view('default.admin.message.view', compact('messageData', 'locale', 'defaultLocale'));
//    }
//
//    public function viewTrashMessage($id)
//    {
//        $locale = $this->chosenLanguage();
//        $defaultLocale = $this->defaultLocale();
//
//        $messageData = $this->notice->onlyTrashed()
//            ->where('type', 'message')
////            ->where('to_send', $loggerId)
//            ->where('id', $id)
//            ->get();
////        dd($messageData);
//        return view('default.admin.message.tview', compact('messageData', 'locale', 'defaultLocale'));
//    }
//
//    /**
//     * @param $id
//     * @return $this
//     */
//    public function deleteMessage($id)
//    {
//        $messageToDelete = $this->notice->findOrFail($id);
//        if ($messageToDelete->delete()):
//            return back()->withSuccess('Successfully Deleted');
//        endif;
//        return back()->withErrors('Not Successfully Deleted');
//    }

}