<?php

namespace App\Http\Controllers\Site\Result\Permission;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\ProjectController;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Site\Result\SiteResultPrimarySetting;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExamDeclareStudent;
use App\Models\SiteGroup\ExamResult\GlobalSiteGroupResultPermission;
use App\Models\Student\StudentHistory;

class SiteBaseResultPermissionController extends ProjectController
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }
    public function index()
    {
        $viewType = 'Site Result Permission Page';

        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getResultList(Request $request){

        $data=$request->all();

        $resultSettingIds = SiteResultPrimarySetting::where('academic_version_id', $request->academic_version_id)
        ->where('academic_year_id', $request->academic_year_id)
        ->where('academic_shift_id', $request->academic_shift_id)
        ->where('academic_class_id', $request->academic_class_id)
        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })
        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
        })
        ->where('status', true)
        ->pluck('academic_result_primary_type_id');

      $result_type_ids =  SiteStudentPrimaryResultDetail::whereIn('academic_result_primary_type_id',$resultSettingIds)->pluck('academic_result_primary_type_id');
     
       $resultList = AcademicResultPrimaryType::whereIn('id', $result_type_ids)->get();

        return $resultList;
    }


    public function getStudentListForResultPermission(Request $request){

        if(!$this->checkSiteGroupResultPermission($request)){
            return Response::json(['message'=>'You have no permission!'],401);
        }

        $data=$request->all();

       $academic_studetn_list = StudentHistory::select('id', 'user_id', 'student_roll_number')
            ->with(['student' => function ($query) {
                $query->select('id');
                $query->where('user_type', 'student');
            }])
            ->where('academic_version_id', $data['academic_version_id'])
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
      
    //    ->where('status', true)
       ->orderBy('student_roll_number', 'ASC')
       ->get();

    //   dd($academic_studetn_list);

       $academic_studetn_ids=$academic_studetn_list->pluck('id');

       $studetnIds=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $academic_studetn_ids)
            ->where('academic_result_primary_type_id',$request->academic_result_primary_type_id)
            ->pluck('student_history_id')
            ->unique()
            ->filter();

       $student_list=$academic_studetn_list->whereIn('id',$studetnIds);

       $sudent_array=[];
       $key=0;
       foreach($student_list as $item){
            $sudent_array[$key]=$item;
            $key++;
       }

       
       if($request->permission_for=='employee'){
        $selected_studetn_ids=SiteStudentPrimaryResultDetail::where('result_employee_publish_status', true)
            ->whereIn('student_history_id',$studetnIds)
            ->where('academic_result_primary_type_id',$request->academic_result_primary_type_id)
            ->where('status',true)
            ->pluck('student_history_id')
            ->unique()
            ->filter();
      
       }
       elseif($request->permission_for=='student'){
        $selected_studetn_ids=SiteStudentPrimaryResultDetail::where('result_student_publish_status', true)
            ->where('academic_result_primary_type_id',$request->academic_result_primary_type_id)
            ->where('status',true)
            ->whereIn('student_history_id',$studetnIds)
            ->pluck('student_history_id')
            ->unique()
            ->filter();
       }
       elseif($request->permission_for=='public'){
        $selected_studetn_ids=SiteStudentPrimaryResultDetail::where('result_public_publish_status', true)
            ->whereIn('student_history_id',$studetnIds)
            ->where('academic_result_primary_type_id',$request->academic_result_primary_type_id)
            ->where('status',true)
            ->pluck('student_history_id')
            ->unique()
            ->filter();

       }
       elseif($request->permission_for=='public-full'){
        $selected_studetn_ids=SiteStudentPrimaryResultDetail::where('result_public_full_publish_status', true)
            ->whereIn('student_history_id',$studetnIds)
            ->where('academic_result_primary_type_id',$request->academic_result_primary_type_id)
            ->where('status',true)
            ->pluck('student_history_id')
            ->unique()
            ->filter();
      
       }
       else{
        return response()->json(['message'=>'Select Permission Key'],422);
       }

      
       return response()->json(['student_list'=>$sudent_array, 'select_studetn_ids'=>$selected_studetn_ids]);
      
    }

    public function submitStudentResultPermission(Request $request){
   //    dd($request->all());
    $all_student_ids=collect($request->StudentList)->pluck('id');
     $unselect_ids = collect($request->StudentList)->whereNotIn('id',$request->select_student_history_id)->pluck('id');
 //   dd($unselect_ids);

     $resutlList=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $all_student_ids)
     ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
     ->get();

    $data=$request->all();

   $select_student_ids=collect($request->select_student_history_id);

       if($request->permission_for=='employee'){
        SiteStudentPrimaryResultDetail::whereIn('student_history_id', $select_student_ids)
        ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
           ->update([
               'result_employee_publish_status'=>true
           ]);
   
       SiteStudentPrimaryResultDetail::whereIn('student_history_id', $unselect_ids)
        ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
           ->update([
               'result_employee_publish_status'=>false
           ]);
   
       }elseif($request->permission_for=='student'){
        SiteStudentPrimaryResultDetail::whereIn('student_history_id', $select_student_ids)
        ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
           ->update([
               'result_student_publish_status'=>true
           ]);
   
       SiteStudentPrimaryResultDetail::whereIn('student_history_id', $unselect_ids)
        ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
           ->update([
               'result_student_publish_status'=>false
           ]);
   
       }
       elseif($request->permission_for=='public'){
        SiteStudentPrimaryResultDetail::whereIn('student_history_id', $select_student_ids)
        ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
           ->update([
               'result_public_publish_status'=>true
           ]);

        
   
       SiteStudentPrimaryResultDetail::whereIn('student_history_id', $unselect_ids)
        ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
           ->update([
               'result_public_publish_status'=>false
           ]);
   
       }elseif($request->permission_for=='public-full'){
      //  dd($unselect_ids);
        SiteStudentPrimaryResultDetail::whereIn('student_history_id', $select_student_ids)
        ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
           ->update([
               'result_public_full_publish_status'=>true
           ]);
   
       SiteStudentPrimaryResultDetail::whereIn('student_history_id', $unselect_ids)
        ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
           ->update([
               'result_public_full_publish_status'=>false
           ]);

        
   
       }else{
        return response()->json(['message'=>'Select Permission Key'],422);
       }

       return response()->json(['message'=>'Permission Save Successfully'],200);
   
    }
}
