<?php

namespace App\Http\Controllers\Site\Result;


use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicResultSystem;
use App\Models\Site\Result\SiteResultSystemSetting;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicReportCardDesignation;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Site\Result\SiteExamResultReportSetting;
use App\Models\Site\Result\SiteResultPrimarySetting;
use Google\Service\Docs\Response as DocsResponse;
use Illuminate\Support\Str;
use Response;
use Session;
use Image;

class SiteBaseResultReportSettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }

//    public function index()
//    {
//        $viewType = 'Site Result Setting Page';
//
//
//        return view('default.admin.site.result.site-base-result-setting', compact('viewType'));
//
//    }


    public function getSiteBaseResultTypeList(Request $request){


        $academic_result_primary_type_ids=SiteResultPrimarySetting::where('academic_version_id',$request->academic_version_id)
            ->where('academic_year_id',$request->academic_year_id)
            ->pluck('academic_result_primary_type_id')
            ->unique()
            ->values();
        
        $primary_result_list=AcademicResultPrimaryType::whereIn('id',$academic_result_primary_type_ids)->where('use_key','site')->get();

        return Response::json(['primary_result_list'=>$primary_result_list],200);

    }



    public function getSiteClassBaseResultReportSettingsList(Request $request){

        $data = $request->all();
        $siteInfoSetting=SiteInfoSetting::select('academic_result_system_ids')
            ->first();

        $sClassLi=SiteShiftClassGroupSectionSetting::where('academic_year_id', $request->academic_year_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })

            ->distinct('academic_class_id')
            ->pluck('academic_class_id');

        $academic_class_list=AcademicClass::whereIn('id', $sClassLi)
            ->get();

        $siteExamResultReportSetting=SiteExamResultReportSetting::
             where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
             ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
          //  ->where('status',true)
            ->get();


        $class_list_arr=Array();
        $class_list_array=[];
        foreach ($academic_class_list as $key => $value) {

            $checks = $siteExamResultReportSetting
                ->where('academic_class_id',$value->id)
                ->first();

            if (!$checks) {

                $checks=SiteExamResultReportSetting::first();

                if(!$checks){
                    $model = new SiteExamResultReportSetting;

                    $ownFields = $model->ownFields ?? [];

                    $excludeFields = [
                        'site_id',
                        'academic_group_id',
                        'academic_year_id',
                        'academic_version_id',
                        'academic_class_id',
                        'academic_result_primary_type_id',
                    ];
                    $ownFields = $model->ownFields ?? [];

                    $defaults = [];
                    foreach ($ownFields as $field) {
                    if (!in_array($field, $excludeFields)) {
                            $defaults[$field] = false;
                        }
                    }

                    $checks = new SiteExamResultReportSetting($defaults);
                }

            
            }
            

            if($checks){
                $class_list_array[$key]['select_class']=true;
                $class_list_array[$key]['settings']=$checks;
            }else{
                $class_list_array[$key]['select_class']=false;
                $class_list_array[$key]['settings']=null;
            }
             $class_list_array[$key]['id']=$value->id;
             $class_list_array[$key]['class_name']=$value->class_name;

        }

        $title_list = AcademicReportCardDesignation::orderBy('serial', 'ASC')->get();

        //  return $class_list_array;

        $academic_result_primary_type_ids=SiteResultPrimarySetting::where('academic_version_id',$request->academic_version_id)
            ->where('academic_year_id',$request->academic_year_id)
            ->pluck('academic_result_primary_type_id')
            ->unique()
            ->values();
        
        $primary_result_list=AcademicResultPrimaryType::whereIn('id',$academic_result_primary_type_ids)->get();

        return Response::json(['title_list'=>$title_list, 'class_list_array'=>$class_list_array,'primary_result_list'=>$primary_result_list]);
     
    }



    public function createUpdateResultCardSetting(Request $request){


          $data = $request->all();
          $check_logo = SiteExamResultReportSetting::whereNotNull('bottom_logo')->orderBy('id','desc')->first();
          $checklast = SiteExamResultReportSetting::orderBy('id','desc')->first();

            if($check_logo){
                $imageName = $check_logo->bottom_logo;
            }else{
                $imageName = null;
            }
                
            if ($request->bottom_logo) {
                // Delete previous image if it exists
                if ($imageName && file_exists(public_path('uploads/') . $imageName)) {
                    unlink(public_path('uploads/') . $imageName);
                }

                // Process and save the new image
                $image = $request->bottom_logo;
                $extension = explode('/', explode(';', $image)[0])[1];
                $imageName = time() . "." . $extension;
                Image::make($image)->save(public_path('uploads/') . $imageName);
            }
          
        foreach($data['class_setting_list'] as $class){
            if($class['select_class']){


                $lookupData = [
                    'academic_group_id' => Session::get('ACADEMIC_GROUP_ID'),
                    'academic_year_id' => $request->academic_year_id,
                    'academic_version_id' => $request->academic_version_id,
                    'academic_result_primary_type_id' => $request->academic_result_primary_type_id,
                    'academic_class_id' => $class['id'],
                ];

                $checkSetting = SiteExamResultReportSetting::where($lookupData)->first();

                if (!$checkSetting) {
                    $checkSetting = new SiteExamResultReportSetting($lookupData);
                    $checkSetting->site_id = Session::get('SITE_ID');
                } 

           
            // left signature image upload

            if($class['settings']['left_signature']){
                $left_signature = $class['settings']['left_signature'];

                if (Str::startsWith($left_signature, 'data:image')) {
                                        $extension = explode('/', explode(';', $left_signature)[0])[1];
                    $left_signature_name = 'left_signature_'.time() . "." . $extension;
                    Image::make($left_signature)
                     ->resize(200, 80, function ($constraint) {
                            $constraint->aspectRatio();
                            $constraint->upsize();
                        })
                    ->save(public_path('uploads/') . $left_signature_name);

                    $class['settings']['left_signature'] = '/uploads/'.$left_signature_name;
                }
            

            }else{
                if($checklast){
                    $class['settings']['left_signature'] = $checklast->left_signature;
                }
            }

             // center signature image upload
            
            if($class['settings']['center_signature']){
                $center_signature = $class['settings']['center_signature'];

                  if (Str::startsWith($center_signature, 'data:image')) {
                    $extension = explode('/', explode(';', $center_signature)[0])[1];
                    $center_signature_name = 'center_signature_'.time() . "." . $extension;
                    Image::make($center_signature)
                     ->resize(200, 80, function ($constraint) {
                            $constraint->aspectRatio();
                            $constraint->upsize();
                        })
                        ->save(public_path('uploads/') . $center_signature_name);

                    $class['settings']['center_signature'] = '/uploads/'.$center_signature_name;
                  }
            }else{
                if($checklast){
                    $class['settings']['center_signature'] = $checklast->center_signature;
                }
            }

             // right signature image upload

            if($class['settings']['right_signature']){
                 $right_signature = $class['settings']['right_signature'];
                if(Str::startsWith($right_signature, 'data:image')) {
                   
                    $extension = explode('/', explode(';', $right_signature)[0])[1];
                    $right_signature_name = 'right_signature_'.time() . "." . $extension;
                    //Image::make($right_signature)->save(public_path('uploads/') . $right_signature_name);

                    Image::make($right_signature)
                        ->resize(200, 80, function ($constraint) {
                            $constraint->aspectRatio();
                            $constraint->upsize();
                        })
                        ->save(public_path('uploads/') . $right_signature_name);


                    $class['settings']['right_signature'] = '/uploads/'.$right_signature_name;
                }
            }else{
                if($checklast){
                    $class['settings']['right_signature'] = $checklast->right_signature;
                }
            }

             // bottom signature image upload

              if ($request->bottom_logo) {
                // Delete previous image if it exists
                if ($imageName && file_exists(public_path('uploads/') . $imageName)) {
                    unlink(public_path('uploads/') . $imageName);
                }

                // Process and save the new image
                $image = $request->bottom_logo;
                $extension = explode('/', explode(';', $image)[0])[1];
                $imageName = time() . "." . $extension;
                Image::make($image)->save(public_path('uploads/') . $imageName);
            }
          
 
                $checkSetting->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
                $checkSetting->site_address_show_status = $class['settings']['site_address_show_status'];
                $checkSetting->exam_type_show_status = $class['settings']['exam_type_show_status'];
                $checkSetting->std_image_show_status = $class['settings']['std_image_show_status'];
                $checkSetting->qrcode_show_status = $class['settings']['qrcode_show_status'];
                $checkSetting->merit_list_show_status = $class['settings']['merit_list_show_status'];
                $checkSetting->academic_perform_show_status = $class['settings']['academic_perform_show_status'];
                $checkSetting->section_wise_highest_mark_show_status = $class['settings']['section_wise_highest_mark_show_status'];
                $checkSetting->head_signature_show_status = $class['settings']['head_signature_show_status'];
                $checkSetting->countable_mark_show_status = $class['settings']['countable_mark_show_status'];
                $checkSetting->row_mark_show_status = $class['settings']['row_mark_show_status'];
                $checkSetting->mark_percentage_show_status = $class['settings']['mark_percentage_show_status'];
                $checkSetting->left_designation = $class['settings']['left_designation'];
                $checkSetting->center_designation = $class['settings']['center_designation'];
                $checkSetting->right_designation = $class['settings']['right_designation'];
                $checkSetting->sheet_no = $class['settings']['sheet_no'];
                $checkSetting->combine_result_sheet_no = $class['settings']['combine_result_sheet_no'];
                $checkSetting->behaviour_show_status = $class['settings']['behaviour_show_status'];
                $checkSetting->curriculam_activities_show_status = $class['settings']['curriculam_activities_show_status'];
                $checkSetting->comment_show_status = $class['settings']['comment_show_status'];
                $checkSetting->exam_marks_show_status = $class['settings']['exam_marks_show_status'];
                $checkSetting->obtained_marks_show_status = $class['settings']['obtained_marks_show_status'];
                $checkSetting->percentage_show_status = $class['settings']['percentage_show_status'];
                $checkSetting->grade_show_status = $class['settings']['grade_show_status'];
                $checkSetting->class_show_status = $class['settings']['class_show_status'];
                $checkSetting->section_show_status = $class['settings']['section_show_status'];
                $checkSetting->roll_no_show_status = $class['settings']['roll_no_show_status'];
                $checkSetting->shift_show_status = $class['settings']['shift_show_status'];
                $checkSetting->mother_name_show_status = $class['settings']['mother_name_show_status'];
                $checkSetting->father_name_show_status = $class['settings']['father_name_show_status'];
                $checkSetting->failed_show_status = $class['settings']['failed_show_status'];
                $checkSetting->gpa_show_status = $class['settings']['gpa_show_status'];
                $checkSetting->group_show_status = $class['settings']['group_show_status'];
                $checkSetting->session_show_status = $class['settings']['session_show_status'];
                $checkSetting->bottom_logo_show_status = $class['settings']['bottom_logo_show_status'];
                $checkSetting->bottom_logo = $imageName;  // image name আলাদা হলে
                $checkSetting->pdf_type = $class['settings']['pdf_type'];
                $checkSetting->signature_show_status_for_public = $class['settings']['signature_show_status_for_public'];
                $checkSetting->left_signature = $class['settings']['left_signature'] ?? null;
                $checkSetting->center_signature = $class['settings']['center_signature'] ?? null;
                $checkSetting->right_signature = $class['settings']['right_signature'] ?? null;

                $checkSetting->save();

            }
          
        }

        return Response::json(['message' => 'Information Save Successfully!', 'mode' => 'Saved!'], 200);


    }




}
