<?php

namespace App\Http\Controllers\Site\Result;

use App\Models\Academic\AcademicResultCombineType;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Academic\AcademicSubjectPassFailCountSystems;
use App\Models\Site\Exam\SiteExaminationExamTypeSetting;
use App\Models\Site\Result\SiteResultCombineSetting;
use App\Models\Site\Result\SiteResultPrimarySetting;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicClass;
use App\Models\Site\Result\SiteExamResultReportSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use Response;
use Session;

class SiteBaseResultSettingController extends Controller
{
    private $siteExamCommitteeSetting;
    private $simpleSiteExamCommitteeSetting;

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }

    public function index()
    {
        $viewType = 'Site Result Setting Page';

        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.site.result.site-base-result-setting', compact('viewType'));

    }



    public function getSiteBaseExaminationExamTypeList(Request $request){

        $siteInfoSetting=SiteInfoSetting::select('academic_result_primary_type_ids','academic_result_combine_type_ids')
            ->first();

        $academic_primary_result_type=AcademicResultPrimaryType::
            whereIn('id', explode(',', $siteInfoSetting->academic_result_primary_type_ids))
            ->where('use_key', 'site')
            ->get();

        $academic_combine_result_type=AcademicResultCombineType::
        whereIn('id', explode(',', $siteInfoSetting->academic_result_combine_type_ids))
            ->get();


//        $academic_subject_pass_fail_count_system_list=AcademicSubjectPassFailCountSystems::where('status', true)->get();


        $siteExaminationList = SiteExaminationExamTypeSetting::select('examination_id')
            ->whereHas('examination', function ($query) {
                $query->where('use_key', 'site');
            })
            ->distinct()
            ->get();


        $data = $request->all();

        $resultSettingList = SiteResultPrimarySetting::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();

        $combineResultSettingList = SiteResultCombineSetting::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();


        $examination_arr=Array();
        $examination_array=[];

        foreach ($academic_primary_result_type as $key => $value) {

            $siteExaminationList_arr=Array();
            $siteExaminationList_array=[];
            foreach ($siteExaminationList as $k => $v) {


                $checkResultSetting=$resultSettingList->where('academic_result_primary_type_id', $value['id'])
                    ->where('examination_id', $v['examination_id'])
                    ->first();

                if($checkResultSetting){
                    $siteExaminationList_arr['select_examination_id']=true;
                    $siteExaminationList_arr['marks_percentage']=$checkResultSetting->marks_percentage;
                    $siteExaminationList_arr['show_position']=$checkResultSetting->show_position;
                }
                else{
                    $siteExaminationList_arr['select_examination_id']=false;
                    $siteExaminationList_arr['marks_percentage']=null;
                    $siteExaminationList_arr['show_position']=null;
                }

                $siteExaminationList_array[$k]=array_merge($siteExaminationList_arr, $v->toArray());
            }

            $examination_arr['examination_list']=$siteExaminationList_array;

            $checkPrimayTypeid=$resultSettingList->where('academic_result_primary_type_id', $value['id'])->first();
          //  dd($checkPrimayTypeid);
            if($checkPrimayTypeid){
                $examination_arr['select_primary_result_type']=true;
                $examination_arr['math_condition']=$checkPrimayTypeid->math_condition;
                $examination_arr['combine_subject_result_condition']=$checkPrimayTypeid->combine_subject_result_condition;
            }else{
                $examination_arr['select_primary_result_type']=false;
                $examination_arr['math_condition']='ceil';
                $examination_arr['combine_subject_result_condition']='individually_pass_fail';

            }

           

            $examination_array[$key]=array_merge($examination_arr, $value->toArray());
        }





        $result_type_arr=Array();
        $result_type_array=[];

        foreach ($academic_combine_result_type as $key => $value) {

            $academic_primary_result_type_arr=Array();
            $academic_primary_result_type_array=[];
            foreach ($academic_primary_result_type as $k => $v) {


                $checkComResultSetting=$combineResultSettingList->where('academic_result_combine_type_id', $value['id'])
                    ->where('academic_result_primary_type_id', $v['id'])
                    ->first();


                if($checkComResultSetting){
                    $academic_primary_result_type_arr['select_primary_result_type_id']=true;
                    $academic_primary_result_type_arr['marks_percentage']=$checkComResultSetting->marks_percentage;
                    $academic_primary_result_type_arr['show_position']=$checkComResultSetting->show_position;
                }
                else{
                    $academic_primary_result_type_arr['select_primary_result_type_id']=false;
                    $academic_primary_result_type_arr['marks_percentage']=null;
                    $academic_primary_result_type_arr['show_position']=null;
                }


                $academic_primary_result_type_array[$k]=array_merge($academic_primary_result_type_arr, $v->toArray());
            }

            $result_type_arr['result_type_list']=$academic_primary_result_type_array;



            $checkCombineTypeid=$combineResultSettingList->where('academic_result_combine_type_id', $value['id'])
                ->first();
            if($checkCombineTypeid){
                $result_type_arr['select_result_type']=true;
                $result_type_arr['math_condition']=$checkCombineTypeid->math_condition;

            }else{
                $result_type_arr['select_result_type']=false;
                $result_type_arr['math_condition']='ceil';

            }



            $result_type_array[$key]=array_merge($result_type_arr, $value->toArray());
        }



        return [$examination_array, $result_type_array];



    }





    public function createUpdateSiteResultSetting(Request $request){

        $data = $request->all();

        $resultSettingList = SiteResultPrimarySetting::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
//            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->whereHas('examination', function ($query) {
                $query->where('use_key', 'site');
            })
            ->get();



            $charges=[];
            $checkPrimayResultSettingId=[];
            foreach ($request->ResultTypeList as $key => $value) {
                if($value['select_primary_result_type']){
                   
                    foreach ($value['examination_list'] as $k => $v) {
                        if($v['select_examination_id']){

                            if(count($resultSettingList)>0){

                                $checkResultSetting=$resultSettingList->where('academic_result_primary_type_id', $value['id'])
                                    ->where('examination_id', $v['examination_id'])
                                    ->first();
                                if($checkResultSetting){

                                    $checkPrimayResultSettingId[]=$checkResultSetting->id;

                                    $checkResultPercent=$resultSettingList->where('academic_result_primary_type_id', $value['id'])
                                        ->where('combine_subject_result_condition', $value['combine_subject_result_condition'])
                                        ->where('math_condition', $value['math_condition'])
                                        ->where('examination_id', $v['examination_id'])
                                        ->where('marks_percentage', $v['marks_percentage'])
                                        ->where('show_position', $v['show_position'])
                                        ->first();


                                    if(!$checkResultPercent){

                                        $checkResultSetting->update(['status'=>false]);
                                        $charges[] = [
                                            'academic_year_id'=>$request->academic_year_id,
                                            'academic_version_id'=>$request->academic_version_id,
                                            'academic_shift_id'=>$request->academic_shift_id,
                                            'academic_department_id'=>$request->academic_department_id,
                                            'academic_class_id'=>$request->academic_class_id,
                                            'academic_class_group_id'=>$request->academic_class_group_id,
                                            'academic_result_primary_type_id'=>$value['id'],
                                            'math_condition'=>$value['math_condition'],
                                            'combine_subject_result_condition'=>$value['combine_subject_result_condition'],
                                            'examination_id'=>$v['examination_id'],
                                            'marks_percentage'=>$v['marks_percentage'],
                                            'show_position'=>$v['show_position'],
                                            'status'=>true,
                                            'site_id'=>Session::get('SITE_ID'),
                                            'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                                        ];

                                    }

                                }else{

                                    $charges[] = [
                                        'academic_year_id'=>$request->academic_year_id,
                                        'academic_version_id'=>$request->academic_version_id,
                                        'academic_shift_id'=>$request->academic_shift_id,
                                        'academic_department_id'=>$request->academic_department_id,
                                        'academic_class_id'=>$request->academic_class_id,
                                        'academic_class_group_id'=>$request->academic_class_group_id,
                                        'academic_result_primary_type_id'=>$value['id'],
                                        'math_condition'=>$value['math_condition'],
                                        'combine_subject_result_condition'=>$value['combine_subject_result_condition'],
                                        'examination_id'=>$v['examination_id'],
                                        'marks_percentage'=>$v['marks_percentage'],
                                        'show_position'=>$v['show_position'],
                                        'status'=>true,
                                        'site_id'=>Session::get('SITE_ID'),
                                        'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                                    ];

                                }
                            }
                            else{
                                $charges[] = [
                                    'academic_year_id'=>$request->academic_year_id,
                                    'academic_version_id'=>$request->academic_version_id,
                                    'academic_shift_id'=>$request->academic_shift_id,
                                    'academic_department_id'=>$request->academic_department_id,
                                    'academic_class_id'=>$request->academic_class_id,
                                    'academic_class_group_id'=>$request->academic_class_group_id,
                                    'academic_result_primary_type_id'=>$value['id'],
                                    'math_condition'=>$value['math_condition'],
                                    'combine_subject_result_condition'=>$value['combine_subject_result_condition'],
                                    'examination_id'=>$v['examination_id'],
                                    'marks_percentage'=>$v['marks_percentage'],
                                    'show_position'=>$v['show_position'],
                                    'status'=>true,
                                    'site_id'=>Session::get('SITE_ID'),
                                    'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                                ];
                            }
                        }
                    }
                }
            }


            if(count($resultSettingList)>0){
                $resultId=$resultSettingList->pluck('id');
                $resultIdDiff=array_diff($resultId->toArray(), $checkPrimayResultSettingId);
                SiteResultPrimarySetting::whereIn('id', $resultIdDiff)->update(['status'=>false]);
            }

            if(count($charges)>0){
                SiteResultPrimarySetting::insert($charges);
            }


        $combineResultSettingList = SiteResultCombineSetting::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
//            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();

        $chargest=[];
        $checkCombineResultSettingId=[];
        foreach ($request->CombineResultTypeList as $key => $value) {
            if($value['select_result_type']){


                foreach ($value['result_type_list'] as $k => $v) {
                    if($v['select_primary_result_type_id']){




                        if(count($combineResultSettingList)>0){

                            $checkComResultSetting=$combineResultSettingList->where('academic_result_combine_type_id', $value['id'])
                                ->where('academic_result_primary_type_id', $v['id'])
                                ->first();
                            if($checkComResultSetting){

                                $checkCombineResultSettingId[]=$checkComResultSetting->id;

                                $checkComResultPercent=$combineResultSettingList->where('academic_result_combine_type_id', $value['id'])
                                    ->where('math_condition', $value['math_condition'])
                                    ->where('academic_result_primary_type_id', $v['id'])
                                    ->where('marks_percentage', $v['marks_percentage'])
                                    ->where('show_position', $v['show_position'])
                                    ->first();


                                if(!$checkComResultPercent){

                                    $checkComResultSetting->update(['status'=>false]);
                                    $chargest[] = [
                                        'academic_year_id'=>$request->academic_year_id,
                                        'academic_version_id'=>$request->academic_version_id,
                                        'academic_shift_id'=>$request->academic_shift_id,
                                        'academic_department_id'=>$request->academic_department_id,
                                        'academic_class_id'=>$request->academic_class_id,
                                        'academic_class_group_id'=>$request->academic_class_group_id,
                                        'academic_result_combine_type_id'=>$value['id'],
                                        'math_condition'=>$value['math_condition'],
                                        'academic_result_primary_type_id'=>$v['id'],
                                        'marks_percentage'=>$v['marks_percentage'],
                                        'show_position'=>$v['show_position'],
                                        'status'=>true,
                                        'site_id'=>Session::get('SITE_ID'),
                                        'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                                    ];

                                }

                            }else{

                                $chargest[] = [
                                    'academic_year_id'=>$request->academic_year_id,
                                    'academic_version_id'=>$request->academic_version_id,
                                    'academic_shift_id'=>$request->academic_shift_id,
                                    'academic_department_id'=>$request->academic_department_id,
                                    'academic_class_id'=>$request->academic_class_id,
                                    'academic_class_group_id'=>$request->academic_class_group_id,
                                    'academic_result_combine_type_id'=>$value['id'],
                                    'math_condition'=>$value['math_condition'],
                                    'academic_result_primary_type_id'=>$v['id'],
                                    'marks_percentage'=>$v['marks_percentage'],
                                    'show_position'=>$v['show_position'],
                                    'status'=>true,
                                    'site_id'=>Session::get('SITE_ID'),
                                    'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                                ];

                            }
                        }
                        else{
                            $chargest[] = [
                                'academic_year_id'=>$request->academic_year_id,
                                'academic_version_id'=>$request->academic_version_id,
                                'academic_shift_id'=>$request->academic_shift_id,
                                'academic_department_id'=>$request->academic_department_id,
                                'academic_class_id'=>$request->academic_class_id,
                                'academic_class_group_id'=>$request->academic_class_group_id,
                                'academic_result_combine_type_id'=>$value['id'],
                                'math_condition'=>$value['math_condition'],
                                'academic_result_primary_type_id'=>$v['id'],
                                'marks_percentage'=>$v['marks_percentage'],
                                'show_position'=>$v['show_position'],
                                'status'=>true,
                                'site_id'=>Session::get('SITE_ID'),
                                'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                            ];
                        }

                    }
                }
            }
        }


        if(count($resultSettingList)>0){
            $resultId=$resultSettingList->pluck('id');
            $resultIdDiff=array_diff($resultId->toArray(), $checkPrimayResultSettingId);
            SiteResultCombineSetting::whereIn('id', $resultIdDiff)->update(['status'=>false]);
        }

        if(count($chargest)>0){
            SiteResultCombineSetting::insert($chargest);
        }


        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);



    }

    

    public function getSiteClassBaseResultReportSettingsList(Request $request){

        $data = $request->all();
        $siteInfoSetting=SiteInfoSetting::select('academic_result_system_ids')
            ->first();

        $sClassLi=SiteShiftClassGroupSectionSetting::where('academic_year_id', $request->academic_year_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })

            ->distinct('academic_class_id')
            ->pluck('academic_class_id');

        $academic_class_list=AcademicClass::whereIn('id', $sClassLi)
            ->get();

        $siteExamResultReportSetting=SiteExamResultReportSetting::
             where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
             ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
          //  ->where('status',true)
            ->get();


        $class_list_arr=Array();
        $class_list_array=[];
        foreach ($academic_class_list as $key => $value) {

            $checks = $siteExamResultReportSetting
                ->where('academic_class_id',$value->id)
                ->first();

            if (!$checks) {

                $checks=SiteExamResultReportSetting::first();

                if(!$checks){
                    $model = new SiteExamResultReportSetting;

                    $ownFields = $model->ownFields ?? [];

                    $excludeFields = [
                        'site_id',
                        'academic_group_id',
                        'academic_year_id',
                        'academic_version_id',
                        'academic_class_id',
                        'academic_result_primary_type_id',
                    ];
                    $ownFields = $model->ownFields ?? [];

                    $defaults = [];
                    foreach ($ownFields as $field) {
                    if (!in_array($field, $excludeFields)) {
                            $defaults[$field] = false;
                        }
                    }

                    $checks = new SiteExamResultReportSetting($defaults);
                }

            
            }
            

            if($checks){
                $class_list_array[$key]['select_class']=true;
                $class_list_array[$key]['settings']=$checks;
            }else{
                $class_list_array[$key]['select_class']=false;
                $class_list_array[$key]['settings']=null;
            }
             $class_list_array[$key]['id']=$value->id;
             $class_list_array[$key]['class_name']=$value->class_name;

        }


        //  return $class_list_array;

        $academic_result_primary_type_ids=SiteResultPrimarySetting::where('academic_version_id',$request->academic_version_id)
            ->where('academic_year_id',$request->academic_year_id)
            ->pluck('academic_result_primary_type_id')
            ->unique()
            ->values();
        
        $primary_result_list=AcademicResultPrimaryType::whereIn('id',$academic_result_primary_type_ids)->get();

        return Response::json(['class_list_array'=>$class_list_array,'primary_result_list'=>$primary_result_list]);
     
    }





}
