<?php

namespace App\Http\Controllers\Site\Result\Testimonial;

use App\Models\Academic\AcademicResultCombineType;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Examinations\Examination;
use App\Models\Site\Employee\Employee;
use App\Models\SIte\Exam\SiteExaminationExamTypeSetting;
use App\Models\Site\Result\SiteResultCombineSetting;
use App\Models\Site\Result\SiteResultPrimarySetting;
use App\Models\Site\Result\SiteResultSystemSetting;
use App\Models\Site\Result\SiteStudentCombineResultDetail;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Site\Result\Testimonial\SiteTestimonialResult;
use App\Models\Site\Result\Testimonial\SiteTestimonialSetting;
use App\Models\Site\Result\Testimonial\SiteManuallyTestimonialSetting;
use App\Models\Site\Result\Testimonial\SiteManuallyTestimonial;

use App\Models\AcademicYear\AcademicYear;

use App\Models\Site\SiteInfo;
use App\Models\Student\StudentHistory;
use App\Models\Site\SiteInfoSetting;
use Carbon\Carbon;
use File;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Image;
use PDF;
use Response;
use Session;

class SiteManuallyTestimonialController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }
    public function getYearClassBaseResultTypeListForManuallyTestimonial(Request $request){
        $data = $request->all();
        $result_primary_type_ids = SiteManuallyTestimonialSetting::pluck('academic_result_primary_type_id')->unique()->values();

        $resultPrimaryTypeList=AcademicResultPrimaryType::whereIn('id',$result_primary_type_ids)->get();
        return compact('resultPrimaryTypeList');
    }

    public function getStudentListForGenerateMenuallyTestimonial(Request $request){

         $data = $request->all();
        $students = StudentHistory::with(['student'=>function($query){
            $query->select('id');
            //$query->select('id', 'date_of_birth', 'religion_id', 'gender_id', 'blood_group_id');
        }])
            ->select('id', 'user_id', 'student_roll_number', 'student_roll_number_prefix',
                'registration_no', 'board_registration_number', 'board_roll_number')
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', true)
        //    ->orderBy('academic_department_id', 'ASC')
            ->orderBy('academic_class_id', 'ASC')
        //    ->orderBy('academic_class_group_id', 'ASC')
        //    ->orderBy('academic_section_id', 'ASC')
            ->orderBy('board_roll_number', 'ASC')
            ->orderBy('student_roll_number', 'ASC')
            ->get();


            if($students){

                $testimoial_setting_list=SiteManuallyTestimonialSetting::
                    when(!empty($data['academic_result_primary_type_id']), function ($query) use ($data) {
                        return $query->where('academic_result_primary_type_id', $data['academic_result_primary_type_id']);
                    })->first();

                if($testimoial_setting_list){
                    if(!$data['academic_result_primary_type_id']){
                        return response()->json([
                            'message'=>'please select exam type list',
                            'mode' => 'Error'
                        ], 200);
                    }
                }else{
                    return response()->json([
                        'message'=>'please setting manually testimonial',
                        'mode' => 'Error'
                    ], 200);
                }

            $allTestimonial = SiteManuallyTestimonial::where('academic_result_primary_type_id', $request->academic_result_primary_type_id)->get();

            foreach ($students as $key => $value){
                $testimonial = $allTestimonial->where('student_history_id', $value['id'])->first();
                if($testimonial){
                    $student_list_arr['grade']=$testimonial->grade;
                    $student_list_arr['gpa']=$testimonial->gpa;
                    $student_list_arr['referance_prefix']=$testimonial->referance_prefix;
                    $student_list_arr['referance_number']=$testimonial->referance_number;
                    $student_list_arr['referance_suffix']=$testimonial->referance_suffix;
                    $student_list_arr['disable_gpa']=$testimonial->disable_gpa;
                    $student_list_arr['select_student']=true;
                    $student_list_arr['loadingtestimonialdownload']=true;
                    $student_list_arr['downloading_status']=false;
                    $student_list[$key]=array_merge($value->toArray(), $student_list_arr);

                }else{
                    $student_list_arr['grade']=null;
                    $student_list_arr['gpa']=null;
                    $student_list_arr['referance_prefix']=null;
                    $student_list_arr['referance_number']=null;
                    $student_list_arr['referance_suffix']=null;
                    $student_list_arr['disable_gpa']=false;
                    $student_list_arr['select_student']=false;
                    $student_list_arr['loadingtestimonialdownload']=false;
                    $student_list_arr['downloading_status']=false;

                    $student_list[$key]=array_merge($value->toArray(), $student_list_arr);
                }

            }
        }

            $site_info_settings = SiteInfoSetting::where('site_id',Session::get('SITE_ID'))->first();
            $site_academic_year_ids = explode(',', $site_info_settings->academic_year_ids);
            $academicYears=AcademicYear::whereIn('id',$site_academic_year_ids)->orderBy('id', 'DESC')->get();

            return response()->json([
                'student_list'=>$student_list,
                'academicYears'=>$academicYears,
            ], 200);

    }

    public function createUpdateSiteManuallyTestimonial(Request $request){

        if(!$request->passing_year){
            return Response::json(['message' => 'Plese Fill the Passing Year field!', 'mode' => 'Error'], 200);
        }

        $data = $request->all();

        $testimoial_setting_list=SiteManuallyTestimonialSetting::
            when(!empty($data['academic_result_primary_type_id']), function ($query) use ($data) {
                return $query->where('academic_result_primary_type_id', $data['academic_result_primary_type_id']);
            })->first();


        if(!$testimoial_setting_list){
            return Response::json(['message' => 'Plese Complete Your Testimonial Setup!', 'mode' => 'Error'], 200);
        }

            $selected_student_list=collect($request->StudentList)->where('select_student', true)->values();
            $all_student_ids=collect($request->StudentList)->pluck('id')->values();
            $non_selected_student_ids=collect($request->StudentList)->where('select_student', '!=', true)->pluck('id')->values();


            $testimonial_result_all = SiteManuallyTestimonial::
            where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->whereIn('student_history_id', $all_student_ids)
            ->get();

            SiteManuallyTestimonial::where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->whereIn('student_history_id', $all_student_ids)
            ->update([
                'passing_year'=>$request->passing_year
            ]);

            $max_ref_number=SiteManuallyTestimonial::
            when(!empty($data['academic_result_primary_type_id']), function ($query) use ($data) {
                return $query->where('academic_result_primary_type_id', $data['academic_result_primary_type_id']);
            })
            ->max('referance_number');


        if(!$max_ref_number){
            $ref_num=$testimoial_setting_list->initial_referance_number;
        }
        else{
            $ref_num=$max_ref_number+1;
        }


        $charges=[];
        foreach ($selected_student_list as $key => $value){

            $check_data=$testimonial_result_all->where('student_history_id', $value['id'])->first();
        //  dd($check_data);
            if($check_data){
                    $check_data->passing_year=$request->passing_year;
                    $check_data->gpa=$value['gpa'];
                    $check_data->grade=$value['grade'];
                    $check_data->testimonial_updated_by=\Auth::user()->id;
                    $check_data->status=true;
                    $check_data->save();
            }
            else{

                $charges[] = [
                    'passing_year'=>$request->passing_year,
                    'student_history_id'=>$value['id'],
                    'academic_result_primary_type_id'=>$request->academic_result_primary_type_id,
                    'gpa'=>$value['gpa'],
                    'grade'=>$value['grade'],

                    'referance_prefix'=>$testimoial_setting_list->initial_referance_prefix,
                    'referance_number'=>$ref_num,
                    'referance_suffix'=>$testimoial_setting_list->initial_referance_suffix,

                    'testimonial_created_by'=>\Auth::user()->id,
                    'status'=>true,
                    'site_id'=>Session::get('SITE_ID'),
                    'created_at'=>Carbon::now(),

                ];

                $ref_num++;
            }

        }
       // dd($charges);
        if(count($charges)>0){
            SiteManuallyTestimonial::insert($charges);
        }

        SiteManuallyTestimonial::where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->whereIn('student_history_id', $non_selected_student_ids)
            ->update([
                'status'=>false
            ]);

        return Response::json(['message' => 'Testimonial Generate Successfully!', 'mode' => 'Saved!'], 200);

    }


    public function getResultTypeListForManuallyTestimonial(){


        $result_primary_type_ids=SiteResultPrimarySetting::where('status', true)
            ->pluck('academic_result_primary_type_id')
            ->unique()
            ->values();

        $site_info_settings = SiteInfoSetting::where('site_id',Session::get('SITE_ID'))->first();

        $site_exam_type_ids = explode(',', $site_info_settings->academic_result_primary_type_ids);

        $resultPrimaryTypeList=AcademicResultPrimaryType::whereIn('id',$site_exam_type_ids)
                    ->whereNotIn('id',$result_primary_type_ids)
                    ->get();

        return compact('resultPrimaryTypeList');

    }

    public function getResultTypeBaseManuallyTestimonialSetting(Request $request){

        $data = $request->all();
        $existing_setting_list=SiteManuallyTestimonialSetting::
            when(!empty($data['academic_result_primary_type_id']), function ($query) use ($data) {
                return $query->where('academic_result_primary_type_id', $data['academic_result_primary_type_id']);
            })
            ->when(!empty($data['academic_result_combine_type_id']), function ($query) use ($data) {
                return $query->orWhere('academic_result_combine_type_id', $data['academic_result_combine_type_id']);
            })
            ->first();

         //   dd($existing_setting_list);

        if($existing_setting_list){

            $prefix_present=SiteManuallyTestimonial::
            where('referance_prefix', $existing_setting_list->initial_referance_prefix)
                ->Where('referance_suffix', $existing_setting_list->initial_referance_suffix)
                ->where('referance_number', $existing_setting_list->initial_referance_number)
                ->first();
           // dd($prefix_present);
            if($prefix_present){
                $arr=[
                    'ref_apply_status'=>true,
                    'edit_status'=>true,
                ];
            }
            else{
                $arr=[
                    'ref_apply_status'=>false,
                    'edit_status'=>true,
                ];
            }

            $setup_list=array_merge($existing_setting_list->toArray(), $arr);

        }
        else{
            $setup_list=[
                'logo_position'=> null,
                'border_image'=> null,
                'border_image_status'=> false,
                'watermark_image'=> null,
                'watermark_status'=> false,
                'address_present_status'=> true,
                'eiin_show_status'=> false,
                'college_code_show_status'=> false,
                'nu_code_show_status'=> false,
                'initial_referance_number'=> null,
                'initial_referance_prefix'=> null,
                'initial_referance_suffix'=> null,
                'ref_apply_status'=>false,

                'session_show_status'=>false,
                'testimonial_background_color'=>null,
                'exam_center_show_status'=>false,
                'exam_center'=>null,
                'exam_center_code'=>null,
                'edit_status'=>false,

            ];
        }

        return $setup_list;
    }

    public function createSiteManuallyTestimonialSetting(Request $request, SiteManuallyTestimonialSetting $siteTestimonialSetting){


        if(!$request->logo_position){
            return Response::json(['message' => 'Plese Select Logo Position!', 'mode' => 'Error'], 200);
        }

        if(!$request->initial_referance_number){
            return Response::json(['message' => 'You Can not blank Initial Referance Number.!', 'mode' => 'Error'], 200);
        }



        $data = $request->all();

        $existing_setting_list=SiteManuallyTestimonialSetting::
            when(!empty($data['academic_result_primary_type_id']), function ($query) use ($data) {
                return $query->where('academic_result_primary_type_id', $data['academic_result_primary_type_id']);
            })
            ->when(!empty($data['academic_result_combine_type_id']), function ($query) use ($data) {
                return $query->orWhere('academic_result_combine_type_id', $data['academic_result_combine_type_id']);
            })
            ->first();


        if($existing_setting_list){

            if ($request->border_image == "borderimage.png") {
                $border_image = $request->border_image;

            }
            else if($request->border_image ==$existing_setting_list->border_image){
                $border_image=$existing_setting_list->border_image;
            }
            else {

                $image_path = "img/site/testimonial/" . $existing_setting_list->border_image;  // Value is not URL but directory file path
                if (File::exists($image_path)) {
                    File::delete($image_path);
                }



                $name = time().'border' . '.' . explode('/', explode(':', substr($request->border_image, 0, strpos($request->border_image, ';')))[1])[1];
                $border_image = $name;

                Image::make($request->border_image)
//                ->resize(440, 442)
                    ->save(public_path('img/site/testimonial/') . $name);
            }

        }
        else{

            if($request->border_image){
                if ($request->border_image == "borderimage.png") {
                    $border_image = $request->border_image;

                }

                else{

                    $name = time().'border' . '.' . explode('/', explode(':', substr($request->border_image, 0, strpos($request->border_image, ';')))[1])[1];
                    $border_image = $name;

                    Image::make($request->border_image)
//                ->resize(440, 442)
                        ->save(public_path('img/site/testimonial/') . $name);
                }
            }
            else{
                $border_image =null;
            }
        }

        if($existing_setting_list){
            if ($request->watermark_image == "watermarkimage.png") {
                $watermark_image = $request->watermark_image;

            }
            else if($request->watermark_image ==$existing_setting_list->watermark_image){
                $watermark_image=$existing_setting_list->watermark_image;
            }
            else {

                $image_path = "img/site/testimonial/" . $existing_setting_list->watermark_image;  // Value is not URL but directory file path
                if (File::exists($image_path)) {
                    File::delete($image_path);
                }

                $name = time() .'watermark'. '.' . explode('/', explode(':', substr($request->watermark_image, 0, strpos($request->watermark_image, ';')))[1])[1];
                $watermark_image = $name;

                Image::make($request->watermark_image)
//                ->resize(440, 442)
                    ->save(public_path('img/site/testimonial/') . $name);
            }
        }
        else{

            if($request->watermark_image){
                if ($request->watermark_image == "watermarkimage.png") {
                    $watermark_image = $request->watermark_image;
                }
                else {

                    $name = time() .'watermark'. '.' . explode('/', explode(':', substr($request->watermark_image, 0, strpos($request->watermark_image, ';')))[1])[1];
                    $watermark_image = $name;

                    Image::make($request->watermark_image)
//                ->resize(440, 442)
                        ->save(public_path('img/site/testimonial/') . $name);
                }
            }
            else{
                $watermark_image =null;
            }
        }


        if($existing_setting_list){

            foreach ($existing_setting_list->ownFields as $ownFields) {
                if ($request->{$ownFields}) {
                        $existing_setting_list->{$ownFields} = $request->{$ownFields};
                }
            }
            $existing_setting_list->border_image=$border_image;
            $existing_setting_list->watermark_image=$watermark_image;
            $existing_setting_list->address_present_status=$request->address_present_status;
            $existing_setting_list->eiin_show_status=$request->eiin_show_status;
            $existing_setting_list->college_code_show_status=$request->college_code_show_status;
            $existing_setting_list->nu_code_show_status=$request->nu_code_show_status;

            $existing_setting_list->border_image_status=$request->border_image_status;
            $existing_setting_list->watermark_status=$request->watermark_status;
            $existing_setting_list->session_show_status=$request->session_show_status;
            $existing_setting_list->exam_center_show_status=$request->exam_center_show_status;

            // $existing_setting_list->logo_position=$request->logo_position;

            // $existing_setting_list->address_present_status=$request->address_present_status;
            // $existing_setting_list->initial_referance_number=$request->initial_referance_number;
            // $existing_setting_list->initial_referance_prefix=$request->initial_referance_prefix;
            // $existing_setting_list->initial_referance_suffix=$request->initial_referance_suffix;

             $existing_setting_list->testimonial_background_color=$request->testimonial_background_color??'white';
            // $existing_setting_list->exam_center=$request->exam_center;
            // $existing_setting_list->exam_center_code=$request->exam_center_code;

            $existing_setting_list->save();

        }else{

            foreach ($siteTestimonialSetting->ownFields as $ownFields) {
                if ($request->{$ownFields}) {
                        $siteTestimonialSetting->{$ownFields} = $request->{$ownFields};
                }
            }
            $siteTestimonialSetting->border_image=$border_image;
            $siteTestimonialSetting->watermark_image=$watermark_image;
            $siteTestimonialSetting->address_present_status=$request->address_present_status;
            $siteTestimonialSetting->eiin_show_status=$request->eiin_show_status;
            $siteTestimonialSetting->college_code_show_status=$request->college_code_show_status;
            $siteTestimonialSetting->nu_code_show_status=$request->nu_code_show_status;

            $siteTestimonialSetting->border_image_status=$request->border_image_status;
            $siteTestimonialSetting->watermark_status=$request->watermark_status;
            $siteTestimonialSetting->session_show_status=$request->session_show_status;
            $siteTestimonialSetting->exam_center_show_status=$request->exam_center_show_status;

            $siteTestimonialSetting->save();
        }

        return Response::json(['message' => 'Testimonial Setup Successfully!', 'mode' => 'Saved!'], 200);

    }


    //===================Testimonial Setting End====================


    public function manuallyTestimonialPdfDownload(Request $request){
        ini_set('memory_limit', '-1');


        $page_tittle = "Testimonial";
        $report_tittle = "<b>Testimonial</b> <br/>";
        $report_tittle2 = " ";
        $title_view = "Testimonial";


         $student_detail=StudentHistory::with(['student'=>function($q){
            $q->with(['gender', 'permanentDistrict', 'permanentThana']);
            $q->select('id', 'gender_id', 'permanent_district_id', 'permanent_thana_id', 'date_of_birth');
        },
            'siteStudentPrimaryResultDetail'=>function($qu) use ($request){
                $qu->where('academic_result_primary_type_id', $request->academic_result_primary_type_id);
                $qu->select('id', 'academic_result_primary_type_id', 'student_history_id', 'gpa', 'grade');

            },
            'SiteManuallyTestimonial'=>function($qu) use ($request){
                $qu->with(['AcademicResultPrimaryType']);
                $qu->where('academic_result_primary_type_id', $request->academic_result_primary_type_id);
                $qu->where('status', true);
              //  $qu->where('pass_fail_status', true);
                $qu->select('id', 'academic_result_primary_type_id', 'student_history_id', 'gpa',
                    'passing_year', 'pass_fail_status', 'referance_prefix', 'referance_number', 'referance_suffix');

            },
            'year','department','stClass', 'shift', 'classGroup', 'session'])
            ->where('id', $request->student_history_id)
            ->select('id', 'user_id', 'student_roll_number', 'academic_year_id', 'academic_department_id',
                'academic_class_id', 'academic_class_group_id', 'academic_session_id', 'board_registration_number','academic_student_category_id',
                'board_roll_number')
            ->get();




        $data = $request->all();

        $setting_list=SiteManuallyTestimonialSetting::
            when(!empty($data['academic_result_primary_type_id']), function ($query) use ($data) {
                return $query->where('academic_result_primary_type_id', $data['academic_result_primary_type_id']);
            })
            // ->when(!empty($data['academic_result_combine_type_id']), function ($query) use ($data) {
            //     return $query->orWhere('academic_result_combine_type_id', $data['academic_result_combine_type_id']);
            // })
            ->first();

         //       dd($setting_list);


        $site=SiteInfo::with(['district', 'photo', 'academicBoard'])
            ->where('id', Session::get('SITE_ID'))
            ->select('id','site_logo','district_id','academic_board_id','eiin','college_code','nu_code')
            ->first();


//        return compact('student_detail', 'site');

        $institute_head = Employee::where('institute_head', 1)->first();

        $signature = $institute_head->signature ?? '/img/signature/signature.png';
        $designation = $institute_head->designation->name ?? 'Institution Head';
    //    dd($student_detail->student);

        // $pdf = PDF::loadView('default.admin.site.result.testimonial.site-manually-testimonial-pdf',
        //     compact('student_detail', 'site', 'setting_list', 'signature', 'designation', 'report_tittle',
        //         'page_tittle', 'report_tittle2', 'title_view'))
        //     ->setPaper('a4', 'landscape')
        //     ->setWarnings(false);

            if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.testimonial.site-manually-testimonial-pdf')) {
                $pdf = PDF::loadView('custom.' . Session::get('ALIAS1') . '.student.testimonial.site-manually-testimonial-pdf',
                compact('student_detail', 'site', 'setting_list', 'signature', 'designation', 'report_tittle',
                    'page_tittle', 'report_tittle2', 'title_view'))
                ->setPaper('a4', 'landscape')
                ->setWarnings(false);

            } else {
                $pdf = PDF::loadView('default.admin.site.result.testimonial.site-manually-testimonial-pdf',
                compact('student_detail', 'site', 'setting_list', 'signature', 'designation', 'report_tittle',
                    'page_tittle', 'report_tittle2', 'title_view'))
                ->setPaper('a4', 'landscape')
                ->setWarnings(false);
            }



        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json(['link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'], 200);

    }
    public function manuallyTestimonialMultiplePdfDownload(Request $request){

        ini_set('memory_limit', '-1');


        $page_tittle = "Testimonial";
        $report_tittle = "<b>Testimonial</b> <br/>";
        $report_tittle2 = " ";
        $title_view = "Testimonial";

        $data = $request->all();

        $students_ids = StudentHistory::with(['student'=>function($query){
            $query->select('id');
            //$query->select('id', 'date_of_birth', 'religion_id', 'gender_id', 'blood_group_id');
        }])
            ->select('id', 'user_id', 'student_roll_number', 'student_roll_number_prefix',
                'registration_no', 'board_registration_number', 'board_roll_number')
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('board_roll_number', '>=', $request->board_roll_no_form)
            ->where('board_roll_number', '<=', $request->board_roll_no_to)
            ->where('status', true)
            ->orderBy('academic_department_id', 'ASC')
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_class_group_id', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('board_roll_number', 'ASC')
            ->orderBy('student_roll_number', 'ASC')
            ->pluck('id');
           // ->get();

           // dd($students_ids);

        $student_detail=StudentHistory::with(['student'=>function($q){
            $q->with(['gender', 'permanentDistrict', 'permanentThana']);
            $q->select('id', 'gender_id', 'permanent_district_id', 'permanent_thana_id', 'date_of_birth');
        },
            'siteStudentPrimaryResultDetail'=>function($qu) use ($request){
                $qu->where('academic_result_primary_type_id', $request->academic_result_primary_type_id);
                $qu->select('id', 'academic_result_primary_type_id', 'student_history_id', 'gpa', 'grade');

            },
            'SiteManuallyTestimonial'=>function($qu) use ($request){
                $qu->with(['AcademicResultPrimaryType']);
                $qu->where('academic_result_primary_type_id', $request->academic_result_primary_type_id);
                $qu->where('status', true);
              //  $qu->where('pass_fail_status', true);
                $qu->select('id', 'academic_result_primary_type_id', 'student_history_id', 'gpa',
                    'passing_year', 'pass_fail_status', 'referance_prefix', 'referance_number', 'referance_suffix');

            },
            'year','department','stClass', 'shift', 'classGroup', 'session'])
            ->whereIn('id', $students_ids)
            ->select('id', 'user_id', 'student_roll_number', 'academic_year_id', 'academic_department_id',
                'academic_class_id', 'academic_class_group_id', 'academic_session_id', 'board_registration_number',
                'board_roll_number','academic_student_category_id')
            ->orderBy('board_roll_number','ASC')
            ->get();

        //    dd($student_detail);


        $data = $request->all();

        $setting_list=SiteManuallyTestimonialSetting::
            when(!empty($data['academic_result_primary_type_id']), function ($query) use ($data) {
                return $query->where('academic_result_primary_type_id', $data['academic_result_primary_type_id']);
            })
            // ->when(!empty($data['academic_result_combine_type_id']), function ($query) use ($data) {
            //     return $query->orWhere('academic_result_combine_type_id', $data['academic_result_combine_type_id']);
            // })
            ->first();




        $site=SiteInfo::with(['district', 'photo', 'academicBoard'])
            ->where('id', Session::get('SITE_ID'))
            ->select('id','site_logo','district_id','academic_board_id','eiin','college_code','nu_code')
            ->first();





        $institute_head = Employee::where('institute_head', 1)->first();

        $signature = $institute_head->signature ?? '/img/signature/signature.png';
        $designation = $institute_head->designation->name ?? 'Institution Head';

          if($request->pdfDownloadType=='details'){
            if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.testimonial.site-manually-testimonial-pdf')) {
                $pdf = PDF::loadView('custom.' . Session::get('ALIAS1') . '.student.testimonial.site-manually-testimonial-pdf',
                compact('student_detail', 'site', 'setting_list', 'signature', 'designation', 'report_tittle',
                    'page_tittle', 'report_tittle2', 'title_view'))
                ->setPaper('a4', 'landscape')
                ->setWarnings(false);

            } else {
                $pdf = PDF::loadView('default.admin.site.result.testimonial.site-manually-testimonial-pdf',
                compact('student_detail', 'site', 'setting_list', 'signature', 'designation', 'report_tittle',
                    'page_tittle', 'report_tittle2', 'title_view'))
                ->setPaper('a4', 'landscape')
                ->setWarnings(false);
            }
          }
          else{
            $pdf = PDF::loadView('default.admin.site.result.testimonial.site-manually-testimonial-info-list-pdf',
            compact('student_detail', 'site', 'setting_list', 'signature', 'designation', 'report_tittle',
                'page_tittle', 'report_tittle2', 'title_view'))
            ->setPaper('a4', 'landscape')
            ->setWarnings(false);
          }



        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json(['link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'], 200);

    }



}
