<?php

namespace App\Http\Controllers\Site\Result\Testimonial;

use App\Models\Academic\AcademicResultCombineType;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Examinations\Examination;
use App\Models\Site\Employee\Employee;
use App\Models\SIte\Exam\SiteExaminationExamTypeSetting;
use App\Models\Site\Result\SiteResultCombineSetting;
use App\Models\Site\Result\SiteResultPrimarySetting;
use App\Models\Site\Result\SiteResultSystemSetting;
use App\Models\Site\Result\SiteStudentCombineResultDetail;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Site\Result\Testimonial\SiteTestimonialResult;
use App\Models\Site\Result\Testimonial\SiteTestimonialSetting;
use App\Models\Site\SiteInfo;
use App\Models\Student\StudentHistory;
use Carbon\Carbon;
use File;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Image;
use PDF;
use Response;
use Session;

class SiteTestimonialResultInputController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }


    public function index()
    {
        $viewType = 'Site Testimonial';

        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.site.result.site-base-result-report', compact('viewType'));

    }


    public function getResultTypeListForTestimonial(){

        $result_primary_type_ids=SiteResultPrimarySetting::where('status', true)
            ->pluck('academic_result_primary_type_id')
            ->unique()
            ->values();


        $resultPrimaryTypeList=AcademicResultPrimaryType::whereIn('id',$result_primary_type_ids)->get();

        $result_combine_type_ids=SiteResultCombineSetting::where('status', true)
            ->pluck('academic_result_combine_type_id')
            ->unique()
            ->values();

        $resultCombineTypeList=AcademicResultCombineType::whereIn('id',$result_combine_type_ids)->get();

        return compact('resultPrimaryTypeList', 'resultCombineTypeList');

    }



    public function getResultTypeBaseTestimonialSetting(Request $request){

        $data = $request->all();


        $existing_setting_list=SiteTestimonialSetting::
            when(!empty($data['academic_result_primary_type_id']), function ($query) use ($data) {
                return $query->where('academic_result_primary_type_id', $data['academic_result_primary_type_id']);
            })
            ->when(!empty($data['academic_result_combine_type_id']), function ($query) use ($data) {
                return $query->orWhere('academic_result_combine_type_id', $data['academic_result_combine_type_id']);
            })
            ->first();



        if($existing_setting_list){

            $prefix_present=SiteTestimonialResult::
            where('referance_prefix', $existing_setting_list->initial_referance_prefix)
                ->Where('referance_suffix', $existing_setting_list->initial_referance_suffix)
                ->where('referance_number', $existing_setting_list->initial_referance_number)
                ->first();


            if($prefix_present){
                $arr=[
                    'ref_apply_status'=>true,
                ];
            }
            else{
                $arr=[
                    'ref_apply_status'=>false,
                ];
            }

            $setup_list=array_merge($existing_setting_list->toArray(), $arr);

        }
        else{
            $setup_list=[
                'logo_position'=> null,
                'border_image'=> null,
                'border_image_status'=> false,
                'watermark_image'=> null,
                'watermark_status'=> false,
                'address_present_status'=> true,
                'eiin_show_status'=> false,
                'college_code_show_status'=> false,
                'nu_code_show_status'=> false,
                'initial_referance_number'=> null,
                'initial_referance_prefix'=> null,
                'initial_referance_suffix'=> null,
                'ref_apply_status'=>false,

                'session_show_status'=>false,
                'testimonial_background_color'=>null,
                'exam_center_show_status'=>false,
                'exam_center'=>null,
                'exam_center_code'=>null,
            ];
        }


        return $setup_list;
    }


    public function createSiteTestimonialSetting(Request $request, SiteTestimonialSetting $siteTestimonialSetting){


        if(!$request->logo_position){
            return Response::json(['message' => 'Plese Select Logo Position!', 'mode' => 'Error'], 200);
        }

        if(!$request->initial_referance_number){
            return Response::json(['message' => 'You Can not blank Initial Referance Number.!', 'mode' => 'Error'], 200);
        }



        $data = $request->all();

        $existing_setting_list=SiteTestimonialSetting::
            when(!empty($data['academic_result_primary_type_id']), function ($query) use ($data) {
                return $query->where('academic_result_primary_type_id', $data['academic_result_primary_type_id']);
            })
            ->when(!empty($data['academic_result_combine_type_id']), function ($query) use ($data) {
                return $query->orWhere('academic_result_combine_type_id', $data['academic_result_combine_type_id']);
            })
            ->first();




        if($existing_setting_list){

            if ($request->border_image == "borderimage.png") {
                $border_image = $request->border_image;

            }
            else if($request->border_image ==$existing_setting_list->border_image){
                $border_image=$existing_setting_list->border_image;
            }
            else {

                $image_path = "img/site/testimonial/" . $existing_setting_list->border_image;  // Value is not URL but directory file path
                if (File::exists($image_path)) {
                    File::delete($image_path);
                }



                $name = time().'border' . '.' . explode('/', explode(':', substr($request->border_image, 0, strpos($request->border_image, ';')))[1])[1];
                $border_image = $name;

                Image::make($request->border_image)
//                ->resize(440, 442)
                    ->save(public_path('img/site/testimonial/') . $name);
            }

        }
        else{

            if($request->border_image){
                if ($request->border_image == "borderimage.png") {
                    $border_image = $request->border_image;

                }

                else{

                    $name = time().'border' . '.' . explode('/', explode(':', substr($request->border_image, 0, strpos($request->border_image, ';')))[1])[1];
                    $border_image = $name;

                    Image::make($request->border_image)
//                ->resize(440, 442)
                        ->save(public_path('img/site/testimonial/') . $name);
                }
            }
            else{
                $border_image =null;
            }
        }

        if($existing_setting_list){
            if ($request->watermark_image == "watermarkimage.png") {
                $watermark_image = $request->watermark_image;

            }
            else if($request->watermark_image ==$existing_setting_list->watermark_image){
                $watermark_image=$existing_setting_list->watermark_image;
            }
            else {

                $image_path = "img/site/testimonial/" . $existing_setting_list->watermark_image;  // Value is not URL but directory file path
                if (File::exists($image_path)) {
                    File::delete($image_path);
                }



                $name = time() .'watermark'. '.' . explode('/', explode(':', substr($request->watermark_image, 0, strpos($request->watermark_image, ';')))[1])[1];
                $watermark_image = $name;

                Image::make($request->watermark_image)
//                ->resize(440, 442)
                    ->save(public_path('img/site/testimonial/') . $name);
            }
        }
        else{

            if($request->watermark_image){
                if ($request->watermark_image == "watermarkimage.png") {
                    $watermark_image = $request->watermark_image;

                }
                else {

                    $name = time() .'watermark'. '.' . explode('/', explode(':', substr($request->watermark_image, 0, strpos($request->watermark_image, ';')))[1])[1];
                    $watermark_image = $name;

                    Image::make($request->watermark_image)
//                ->resize(440, 442)
                        ->save(public_path('img/site/testimonial/') . $name);
                }
            }
            else{
                $watermark_image =null;
            }


        }

        if($existing_setting_list){
            foreach ($existing_setting_list->ownFields as $ownFields) {
                if ($request->{$ownFields}) {
                        $existing_setting_list->{$ownFields} = $request->{$ownFields};
                }
            }
            $existing_setting_list->border_image=$border_image;
            $existing_setting_list->watermark_image=$watermark_image;
            $existing_setting_list->address_present_status=$request->address_present_status;
            $existing_setting_list->eiin_show_status=$request->eiin_show_status;
            $existing_setting_list->college_code_show_status=$request->college_code_show_status;
            $existing_setting_list->nu_code_show_status=$request->nu_code_show_status;
            $existing_setting_list->written_by_show_status = $request->written_by_show_status;
            $existing_setting_list->printed_date_show = $request->printed_date_show;
            $existing_setting_list->parents_title_status = $request->parents_title_status;

            $existing_setting_list->border_image_status=$request->border_image_status;
            $existing_setting_list->watermark_status=$request->watermark_status;
            $existing_setting_list->session_show_status=$request->session_show_status;
            $existing_setting_list->exam_center_show_status=$request->exam_center_show_status;
            // $existing_setting_list->logo_position=$request->logo_position;
            // $existing_setting_list->initial_referance_number=$request->initial_referance_number;
            // $existing_setting_list->initial_referance_prefix=$request->initial_referance_prefix;
            // $existing_setting_list->initial_referance_suffix=$request->initial_referance_suffix;

            // $existing_setting_list->testimonial_background_color=$request->testimonial_background_color;
            // $existing_setting_list->exam_center=$request->exam_center;
            // $existing_setting_list->exam_center_code=$request->exam_center_code;


            $existing_setting_list->save();

        }else{

            foreach ($siteTestimonialSetting->ownFields as $ownFields) {
                if ($request->{$ownFields}) {
                        $siteTestimonialSetting->{$ownFields} = $request->{$ownFields};
                }
            }
            $siteTestimonialSetting->border_image=$border_image;
            $siteTestimonialSetting->watermark_image=$watermark_image;
            $siteTestimonialSetting->address_present_status=$request->address_present_status;
            $siteTestimonialSetting->eiin_show_status=$request->eiin_show_status;
            $siteTestimonialSetting->college_code_show_status=$request->college_code_show_status;
            $siteTestimonialSetting->nu_code_show_status=$request->nu_code_show_status;
            $siteTestimonialSetting->written_by_show_status = $request->written_by_show_status;
            $siteTestimonialSetting->printed_date_show = $request->printed_date_show;
            $siteTestimonialSetting->parents_title_status = $request->parents_title_status;

            $siteTestimonialSetting->border_image_status=$request->border_image_status;
            $siteTestimonialSetting->watermark_status=$request->watermark_status;
            $siteTestimonialSetting->session_show_status=$request->session_show_status;
            $siteTestimonialSetting->exam_center_show_status=$request->exam_center_show_status;

            $siteTestimonialSetting->save();
        }

        return Response::json(['message' => 'Testimonial Setup Successfully!', 'mode' => 'Saved!'], 200);

    }


    //===================Testimonial Setting End====================


    //===============Testimonial Generate & download Start================


    public function getYearClassBaseResultTypeListForTestimonial(Request $request){

        $data = $request->all();

        $result_primary_type_ids=SiteResultPrimarySetting::where('academic_class_id', $request->academic_class_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->pluck('academic_result_primary_type_id')
            ->unique()
            ->values();

        $setup_testimonial_primary_type_ids=SiteTestimonialSetting::
        whereIn('academic_result_primary_type_id', $result_primary_type_ids)
            ->pluck('academic_result_primary_type_id')
            ->unique()
            ->values();

        $resultPrimaryTypeList=AcademicResultPrimaryType::whereIn('id',$setup_testimonial_primary_type_ids)->get();


        $result_combine_type_ids=SiteResultCombineSetting::where('academic_class_id', $request->academic_class_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->pluck('academic_result_combine_type_id')
            ->unique()
            ->values();

        $setup_testimonial_combine_type_ids=SiteTestimonialSetting::
        whereIn('academic_result_combine_type_id', $result_combine_type_ids)
            ->pluck('academic_result_combine_type_id')
            ->unique()
            ->values();

        $resultCombineTypeList=AcademicResultCombineType::whereIn('id',$setup_testimonial_combine_type_ids)->get();

        return compact('resultPrimaryTypeList', 'resultCombineTypeList');

    }



    public function getStudentListForGenerateTestimonial(Request $request){

        $data = $request->all();


        $student_ids = StudentHistory::with(['student' => function ($query) {
                $query->select('id');
                $query->where('user_type', 'student');


            }])
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->pluck('id')
            ->unique();

          //  dd($request->academic_result_primary_type_id);

        if($request->academic_result_primary_type_id){

            $check_primary_result_present=SiteStudentPrimaryResultDetail::
                where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->whereIn('student_history_id', $student_ids)
                ->first();


            $check_testimonial_data=SiteTestimonialResult::where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->whereIn('student_history_id', $student_ids)
                ->first();

            if($check_testimonial_data){
                $passing_year=$check_testimonial_data->passing_year;
            }else{
                $passing_year=null;
            }




            $student_detail=StudentHistory::with(['student'=>function($q){
                $q->select('id');
            },
                'siteStudentPrimaryResultDetail'=>function($qu) use ($request, $student_ids){
                    $qu->where('academic_result_primary_type_id', $request->academic_result_primary_type_id);
//                        $qu->where('student_history_id', $student_ids);
                    $qu->select('id', 'academic_result_primary_type_id', 'student_history_id', 'gpa', 'grade');

                },
                'siteTestimonialResult'=>function($qu) use ($request, $student_ids){
                    $qu->where('academic_result_primary_type_id', $request->academic_result_primary_type_id);
                        $qu->where('status', true);
                    $qu->select('id', 'academic_result_primary_type_id', 'student_history_id', 'gpa', 'academic_result_system_id',
                        'referance_prefix', 'pass_fail_status', 'referance_number', 'referance_suffix');

                },
                'year','department','stClass', 'shift', 'classGroup', 'session'])
                ->whereIn('id', $student_ids)
                ->select('id', 'user_id', 'student_roll_number', 'academic_year_id', 'academic_department_id',
                    'academic_class_id', 'academic_class_group_id', 'academic_session_id', 'board_registration_number',
                    'board_roll_number')
                ->orderBy('academic_department_id', 'asc')
                ->orderBy('academic_class_id', 'asc')
                ->orderBy('academic_class_group_id', 'asc')
                ->orderBy('academic_section_id', 'asc')
                ->orderBy('student_roll_number', 'asc')
                ->get();



            $student_list=[];
            $student_list_arr=Array();
            foreach ($student_detail as $key => $value){

                if(!$value->siteStudentPrimaryResultDetail){


                    if(!$value->siteTestimonialResult){

                        $student_list_arr['gpa']=null;
                        $student_list_arr['disable_gpa']=$check_primary_result_present?true:false;
                        $student_list_arr['select_student']=false;
                        $student_list_arr['testimonial_genetate_status']=false;
                        $student_list_arr['loadingtestimonialdownload']=false;
                    }else{
                        $student_list_arr['gpa']=$value->siteTestimonialResult->gpa;
                        $student_list_arr['disable_gpa']=$check_primary_result_present?true:false;
                        $student_list_arr['select_student']=true;
                        $student_list_arr['testimonial_genetate_status']=true;
                        $student_list_arr['loadingtestimonialdownload']=false;
                    }

                }else{
                    if(!$value->siteTestimonialResult){
                        $student_list_arr['gpa']=$value->siteStudentPrimaryResultDetail->gpa;
                        $student_list_arr['disable_gpa']=true;
                        $student_list_arr['select_student']=false;
                        $student_list_arr['testimonial_genetate_status']=false;
                        $student_list_arr['loadingtestimonialdownload']=false;
                    }else{
                        $student_list_arr['gpa']=$value->siteStudentPrimaryResultDetail->gpa;
                        $student_list_arr['disable_gpa']=true;
                        $student_list_arr['select_student']=true;
                        $student_list_arr['testimonial_genetate_status']=true;
                        $student_list_arr['loadingtestimonialdownload']=false;
                    }
                }


                $student_list[$key]=array_merge($value->toArray(), $student_list_arr);

            }


        }
        else if($request->academic_result_combine_type_id){

            $check_primary_result_present=SiteStudentCombineResultDetail::
            where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->whereIn('student_history_id', $student_ids)
                ->first();


            $check_testimonial_data=SiteTestimonialResult::where('academic_result_combine_type_id', $request->academic_result_primary_type_id)
                ->whereIn('student_history_id', $student_ids)
                ->first();

            if($check_testimonial_data){
                $passing_year=$check_testimonial_data->passing_year;
            }else{
                $passing_year=null;
            }



            $student_detail=StudentHistory::with(['student'=>function($q){
                $q->select('id');
            },
                'siteStudentCombineResultDetail'=>function($qu) use ($request, $student_ids){
                    $qu->where('academic_result_primary_type_id', $request->academic_result_primary_type_id);
//                        $qu->where('student_history_id', $student_ids);
                    $qu->select('id', 'academic_result_primary_type_id', 'student_history_id', 'gpa', 'grade');

                },
                'siteTestimonialResult'=>function($qu) use ($request, $student_ids){
                    $qu->where('academic_result_primary_type_id', $request->academic_result_primary_type_id);
                    $qu->where('status', true);
                    $qu->select('id', 'academic_result_primary_type_id', 'student_history_id', 'gpa', 'academic_result_system_id',
                        'referance_prefix','pass_fail_status', 'referance_number', 'referance_suffix');

                },
                'year','department','stClass', 'shift', 'classGroup', 'session'])
                ->whereIn('id', $student_ids)
                ->select('id', 'user_id', 'student_roll_number', 'academic_year_id', 'academic_department_id',
                    'academic_class_id', 'academic_class_group_id', 'academic_session_id', 'board_registration_number')
                ->orderBy('academic_department_id', 'asc')
                ->orderBy('academic_class_id', 'asc')
                ->orderBy('academic_class_group_id', 'asc')
                ->orderBy('academic_section_id', 'asc')
                ->orderBy('student_roll_number', 'asc')
                ->get();

              //  dd('student_list');


            $student_list=[];
            $student_list_arr=Array();
            foreach ($student_detail as $key => $value){
                   // dd($value);
                if(!$value->siteStudentCombineResultDetail){


                    if(!$value->siteTestimonialResult){

                        $student_list_arr['gpa']=null;
                        $student_list_arr['referance_prefix']=null;
                        $student_list_arr['referance_number']=null;
                        $student_list_arr['referance_suffix']=null;
                        $student_list_arr['disable_gpa']=$check_primary_result_present?true:false;
                        $student_list_arr['select_student']=false;
                        $student_list_arr['loadingtestimonialdownload']=false;
                    }else{
                        $student_list_arr['gpa']=$value->siteTestimonialResult->gpa;
                        $student_list_arr['referance_prefix']=$value->siteTestimonialResult->referance_prefix;
                        $student_list_arr['referance_number']=$value->siteTestimonialResult->referance_number;
                        $student_list_arr['referance_suffix']=$value->siteTestimonialResult->referance_suffix;
                        $student_list_arr['disable_gpa']=$check_primary_result_present?true:false;
                        $student_list_arr['select_student']=true;
                        $student_list_arr['loadingtestimonialdownload']=false;
                    }

                }else{
                    if(!$value->siteTestimonialResult){
                        $student_list_arr['gpa']=$value->siteStudentCombineResultDetail->gpa;
                        $student_list_arr['referance_prefix']=null;
                        $student_list_arr['referance_number']=null;
                        $student_list_arr['referance_suffix']=null;
                        $student_list_arr['disable_gpa']=true;
                        $student_list_arr['select_student']=false;
                        $student_list_arr['loadingtestimonialdownload']=false;
                    }else{
                        $student_list_arr['gpa']=$value->siteStudentCombineResultDetail->gpa;
                        $student_list_arr['referance_prefix']=$value->siteTestimonialResult->referance_prefix;
                        $student_list_arr['referance_number']=$value->siteTestimonialResult->referance_number;
                        $student_list_arr['referance_suffix']=$value->siteTestimonialResult->referance_suffix;
                        $student_list_arr['disable_gpa']=true;
                        $student_list_arr['select_student']=true;
                        $student_list_arr['loadingtestimonialdownload']=false;
                    }
                }

                $student_list[$key]=array_merge($value->toArray(), $student_list_arr);
            }
        }

        return response()->json(
            [
                'student_list'=>$student_list,
                'passing_year' => $passing_year,
            ]);

    }




    public function createUpdateSiteTestimonial(Request $request){

        if(!$request->passing_year){
            return Response::json(['message' => 'Plese Fill the Passing Year field!', 'mode' => 'Error'], 200);
        }

        $data = $request->all();

        $testimoial_setting_list=SiteTestimonialSetting::
            when(!empty($data['academic_result_primary_type_id']), function ($query) use ($data) {
                return $query->where('academic_result_primary_type_id', $data['academic_result_primary_type_id']);
            })
            ->when(!empty($data['academic_result_combine_type_id']), function ($query) use ($data) {
                return $query->orWhere('academic_result_combine_type_id', $data['academic_result_combine_type_id']);
            })
            ->first();


        if(!$testimoial_setting_list){
            return Response::json(['message' => 'Plese Complete Your Testimonial Setup!', 'mode' => 'Error'], 200);
        }

        $data = $request->all();
        $selected_student_list=collect($request->StudentList)->where('select_student', true)->values();
        $all_student_ids=collect($request->StudentList)->pluck('id')->values();
        $non_selected_student_ids=collect($request->StudentList)->where('select_student', '!=', true)->pluck('id')->values();


        $testimonial_result_all=SiteTestimonialResult::
            where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->whereIn('student_history_id', $all_student_ids)
            ->get();

        $restult_system=SiteResultSystemSetting::with(['academicResultSystem'])
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->get()
            ->sortBy(function ($item) {
                return $item->academicResultSystem->serial ?? 0;
            });


        SiteTestimonialResult::where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->whereIn('student_history_id', $all_student_ids)
            ->update([
                'passing_year'=>$request->passing_year
            ]);


        $max_ref_number=SiteTestimonialResult::
            when(!empty($data['academic_result_primary_type_id']), function ($query) use ($data) {
                return $query->where('academic_result_primary_type_id', $data['academic_result_primary_type_id']);
            })
            ->when(!empty($data['academic_result_combine_type_id']), function ($query) use ($data) {
                return $query->orWhere('academic_result_combine_type_id', $data['academic_result_combine_type_id']);
            })
            ->max('referance_number');


        if(!$max_ref_number){
            $ref_num=$testimoial_setting_list->initial_referance_number;
        }
        else{
            $ref_num=$max_ref_number+1;
        }




        $charges=[];
        foreach ($selected_student_list as $key => $value){

            $present_gpa=$value['gpa']?$value['gpa']:0;


            $check_data=$testimonial_result_all->where('student_history_id', $value['id'])->first();
            $grade_find=$restult_system
            ->where('point_from', '<=', $present_gpa)
            ->where('point_to', '>=', $present_gpa)
            ->first();

            if($check_data){

                    $check_data->passing_year=$request->passing_year;
                    $check_data->gpa=$present_gpa;
                    $check_data->academic_result_system_id=$grade_find->academicResultSystem->id;
                    $check_data->pass_fail_status=$grade_find->pass_fail_status;
                    $check_data->testimonial_updated_by=\Auth::user()->id;
                    $check_data->status=true;

                    $check_data->save();

                }
                else{

                    $charges[] = [
                        'passing_year'=>$request->passing_year,
                        'student_history_id'=>$value['id'],
                        'academic_result_primary_type_id'=>$request->academic_result_primary_type_id,
                        'academic_result_combine_type_id'=>$request->academic_result_combine_type_id,
                        'gpa'=>$present_gpa,

                        'referance_prefix'=>$testimoial_setting_list->initial_referance_prefix,
                        'referance_number'=>$ref_num,
                        'referance_suffix'=>$testimoial_setting_list->initial_referance_suffix,

                        'academic_result_system_id'=>$grade_find->academicResultSystem->id,
                        'pass_fail_status'=>$grade_find->pass_fail_status,
                        'testimonial_created_by'=>\Auth::user()->id,
                        'status'=>true,
                        'site_id'=>Session::get('SITE_ID'),
                        'created_at'=>Carbon::now(),

                    ];

                    $ref_num++;
                }


        }


        if(count($charges)>0){
            SiteTestimonialResult::insert($charges);
        }


        SiteTestimonialResult::where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->whereIn('student_history_id', $non_selected_student_ids)
            ->update([
                'status'=>false
            ]);

        return Response::json(['message' => 'Testimonial Generate Successfully!', 'mode' => 'Saved!'], 200);

    }


    public function testimonialPdfDownload(Request $request){

        ini_set('memory_limit', '-1');


        $page_tittle = "Testimonial";
        $report_tittle = "<b>Testimonial</b> <br/>";
        $report_tittle2 = " ";
        $title_view = "Testimonial";


        $student_detail=StudentHistory::with(['student'=>function($q){
                $q->with(['gender', 'permanentDistrict', 'permanentThana']);
                $q->select('id', 'gender_id', 'permanent_district_id', 'permanent_thana_id', 'date_of_birth');
            },
            'siteStudentPrimaryResultDetail'=>function($qu) use ($request){
                $qu->where('academic_result_primary_type_id', $request->academic_result_primary_type_id);
                $qu->select('id', 'academic_result_primary_type_id', 'student_history_id', 'gpa', 'grade');

            },
            'siteTestimonialResult'=>function($qu) use ($request){
                $qu->with(['academicResultPrimaryType', 'academicResultSystem']);
                $qu->where('academic_result_primary_type_id', $request->academic_result_primary_type_id);
                $qu->where('status', true);
                $qu->where('pass_fail_status', true);
                $qu->select('id', 'academic_result_primary_type_id', 'student_history_id', 'gpa', 'academic_result_system_id',
                    'passing_year', 'pass_fail_status', 'referance_prefix', 'referance_number', 'referance_suffix');

            },
             'year','department','stClass', 'shift', 'classGroup', 'session'])
            ->where('id', $request->student_history_id)
            ->select('id', 'user_id', 'student_roll_number', 'academic_year_id', 'academic_department_id',
                'academic_class_id', 'academic_class_group_id', 'academic_session_id', 'board_registration_number',
                'board_roll_number')
            ->whereHas('siteTestimonialResult', function($qu) use ($request){
                $qu->with(['academicResultPrimaryType', 'academicResultSystem']);
                $qu->where('academic_result_primary_type_id', $request->academic_result_primary_type_id);
                $qu->where('status', true);
                $qu->where('pass_fail_status', true);
            })
            ->get();

            if(count($student_detail)<=0){
                return response()->json(['message'=>'Student Result Status Failed'],422);
            }



        $data = $request->all();

        $setting_list=SiteTestimonialSetting::
            when(!empty($data['academic_result_primary_type_id']), function ($query) use ($data) {
                return $query->where('academic_result_primary_type_id', $data['academic_result_primary_type_id']);
            })
            ->when(!empty($data['academic_result_combine_type_id']), function ($query) use ($data) {
                return $query->orWhere('academic_result_combine_type_id', $data['academic_result_combine_type_id']);
            })
            ->first();




        $site=SiteInfo::with(['district', 'photo', 'academicBoard'])
            ->where('id', Session::get('SITE_ID'))
            ->select('id', 'site_logo', 'district_id', 'board_id','eiin','college_code','nu_code')
            ->first();


//        return compact('student_detail', 'site');

        $institute_head = Employee::where('institute_head', 1)->first();

        $signature = $institute_head->signature ?? '/img/signature/signature.png';
        $designation = $institute_head->designation->name ?? 'Institution Head';
    //    dd($student_detail->student);

        $pdf = PDF::loadView('default.admin.site.result.testimonial.site-testimonial-pdf',
            compact('student_detail', 'site', 'setting_list', 'signature', 'designation', 'report_tittle',
                'page_tittle', 'report_tittle2', 'title_view'))
            ->setPaper('a4', 'landscape')
            ->setWarnings(false);


        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json(['link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'], 200);

    }





}
