<?php

namespace App\Http\Controllers\Site\Routine;


use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicSubject;
use App\Models\Edu\WeekdayName;
use App\Models\Employee\SiteEmployeeDepartmentClassSubject;
use App\Models\Site\Routine\ClassTiming;
use App\Models\Site\Routine\ClassTimingDetail;
use App\Models\Site\Routine\RoutineAllocation;
use App\Models\Site\Routine\RoutineDetail;
use App\Models\Site\Routine\SubjectWeeklyClass;
use App\Models\Site\Routine\WeekdayClassTiming;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Traits\Site\Routine\RoutineFunction;
use Error;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Http\Response;
use Session;

class AutoGeneratorController extends ProjectController
{


    use RoutineFunction;

    private $siteShiftClassGroupSectionSetting;
    private $routineDetail;
    private $routineAllocation;
    private $weekdayClassTiming;
    private $classTiming;
    private $classTimingDetail;
    private $academicSubject;
    private $subGroupCondSetting;
    private $weeklyClass;
    private $siteEmployeeSubject;


    public function __construct(RoutineDetail $routineDetail, SiteShiftClassGroupSectionSetting $siteShiftClassGroupSectionSetting, AcademicSubject $academicSubject,
                                SubjectGroupConditionSetting $subGroupCondSetting, SubjectWeeklyClass $weeklyClass, SiteEmployeeDepartmentClassSubject $siteEmployeeSubject,
                                RoutineAllocation $routineAllocation, WeekdayClassTiming $weekdayClassTiming, ClassTiming $classTiming, ClassTimingDetail $classTimingDetail)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');


        $this->routineDetail = $routineDetail;
        $this->siteShiftClassGroupSectionSetting = $siteShiftClassGroupSectionSetting;
        $this->routineAllocation = $routineAllocation;
        $this->weekdayClassTiming = $weekdayClassTiming;
        $this->classTiming = $classTiming;
        $this->classTimingDetail = $classTimingDetail;
        $this->academicSubject = $academicSubject;
        $this->subGroupCondSetting = $subGroupCondSetting;
        $this->weeklyClass = $weeklyClass;
        $this->siteEmployeeSubject = $siteEmployeeSubject;


    }


    public function autoGenerate(Request $request)
    {
        //  DB::beginTransaction();


        try {
            $message = 'Nothing';

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
            $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
            $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;
            $data['academic_period_type_id'] = $request->academic_period_type_id == 'null' ? null : $request->academic_period_type_id;

            if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_class_id'] || !$data['academic_shift_id'] || !$data['academic_period_type_id']) {
                return Response::json(['message' => 'Select * Marked Field!'], 410);
            }


            $allocated_subject_total_slots = $this->assignSubjectAuto($data);

            $allocated_teacher_total_slots = $this->assignTeacherAuto($data);


            if ($allocated_subject_total_slots > 0 || $allocated_teacher_total_slots > 0) {
                return response()->json(['message' => 'Total Allocated Subject:' . $allocated_subject_total_slots . ' Teacher:' . $allocated_teacher_total_slots]);
            }
            throw new Error('No Slot Allocated!');


        } catch (Exception $exception) {
            throw new Error($exception->getMessage());

        }
    }

    public function assignTeacherAuto(array $data)
    {
        $subject_but_teacher_unassigned_slots = $this->getSubjectButTeacherUnassignedSlots($data);

        $allocated = 0;
        if (count($subject_but_teacher_unassigned_slots)) {

            foreach ($subject_but_teacher_unassigned_slots as $k => $value) {
                $id = $value->id;
                $the_allocation = $this->routineAllocation->findOrFail($id);

                $subject_id = $value->subject_id;
                $data['academic_subject_id'] = $subject_id;
                $data['routine_details_id'] = $the_allocation->routine_details_id;
                $data['teacher_ids'] = $this->getAvailableTeacherIdsBySubject($data);

                if (count($data['teacher_ids'])) {
                    $data['teacher_id'] = $this->getAvailableTeacherForTheSlot($data);
                    if ($data['teacher_id']) {
                        $the_allocation->employee_id = $data['teacher_id'];
                        $the_allocation->save();
                        $allocated++;
                    }
                }

                continue;
            }
        }
        return $allocated;


    }


    public function assignSubjectAuto(array $data)
    {

        $total_period_slot = $this->totalSubjectUnassignedSlot($data);

        $allocated = 0;

        if (count($total_period_slot) < 1) {// weekly class no set
            return $allocated;
            //throw new Error('No Unassigned Subject Slot Found');
        }


        $weekdays = WeekdayName::all();


        foreach ($weekdays as $k => $weekday) {
            $weekly_slots = $total_period_slot->where('weekday', $weekday->weekday_key);


            if (count($weekly_slots) > 0) {

                foreach ($weekly_slots as $sk => $slot) {
                    $will_sub_id = $this->getSubjectToAllocate($weekday->weekday_key, $data);
                    $slot_id = $slot->id;
                    if ($will_sub_id < 1) {
                        continue;
                    }

                    $the_allocation = new RoutineAllocation();
                    $the_allocation->routine_details_id = $slot_id;
                    $the_allocation->subject_id = $will_sub_id;
                    $the_allocation->save();

                    $allocated = $allocated + 1;

                }


            } else {
                // dd($weekday->weekday_key);

                continue;

            }

        }

        return $allocated;
    }


    public function checkAutoCapability(Request $request)
    {
        //  DB::beginTransaction();

        try {


            $message = 'Nothing';

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
            $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
            $data['academic_session_id'] = $request->academic_session_id;
            $data['academic_period_type_id'] = $request->academic_period_type_id == 'null' ? 0 : $request->academic_period_type_id;


            $this->checkClassSection($data);


            $final_list = [];
            $total_subject = 0;
            $total_period_slot = $this->totalPeriodSlot($data);
            $total_period_slot_count = count($total_period_slot);


            if ($total_period_slot_count < 1) {
                throw new Error('No Period Found');
            }


            $total_period_slot_ids = $total_period_slot->pluck('id');
            $total_assigned_period_slot = $this->totalEmpAssignedPeriodSlot($data);
            $total_assigned_period_slot_count = count($this->totalEmpAssignedPeriodSlot($data));


            $weekly_class = $this->weeklyClass
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->where('academic_class_id', $data['academic_class_id'])
                ->get();

            $total_subject_set_ids = $weekly_class->pluck('academic_subject_id') ?? 0;

            $subjects = $this->academicSubject
                ->whereIn('id', $total_subject_set_ids)
                ->get();

            //  dd($subjects);


            foreach ($subjects as $k => $subject) {

                $emp_sub = $this->siteEmployeeSubject
                    ->when($data['academic_department_id'], function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->where('academic_class_id', $data['academic_class_id'])
                    ->where('academic_subject_id', $subject->id)
                    ->whereNull('release_date')
                    ->whereNotNull('user_id')
                    ->pluck('user_id');

                //  dd($emp_sub);


            }


        } catch (Exception $exception) {

            throw new Error($exception);

        }
    }


}
