<?php

namespace App\Http\Controllers\Site\Routine;

use App\Forms\DataHelper;
use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicSubject;
use App\Models\Site\Routine\ClassTiming;
use App\Models\Site\Routine\ClassTimingDetail;
use App\Models\Site\Routine\RoutineAllocation;
use App\Models\Site\Routine\RoutineDetail;
use App\Models\Site\Routine\RoutineSwapCancel;
use App\Models\Site\Routine\WeekdayClassTiming;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Traits\Site\Routine\RoutineFunction;
use DB;
use Error;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;

class RoutineDetailsController extends ProjectController
{

    use DataHelper, RoutineFunction;

    private $siteShiftClassGroupSectionSetting;
    private $routineDetail;
    private $routineAllocation;
    private $weekdayClassTiming;
    private $classTiming;
    private $classTimingDetail;
    private $academicSubject;
    private $subGroupCondSetting;
    private $swapCancel;


    public function __construct(RoutineDetail $routineDetail, SiteShiftClassGroupSectionSetting $siteShiftClassGroupSectionSetting, AcademicSubject $academicSubject,
                                SubjectGroupConditionSetting $subGroupCondSetting, RoutineSwapCancel $swapCancel,
                                RoutineAllocation $routineAllocation, WeekdayClassTiming $weekdayClassTiming, ClassTiming $classTiming, ClassTimingDetail $classTimingDetail)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->routineDetail = $routineDetail;
        $this->siteShiftClassGroupSectionSetting = $siteShiftClassGroupSectionSetting;
        $this->routineAllocation = $routineAllocation;
        $this->weekdayClassTiming = $weekdayClassTiming;
        $this->classTiming = $classTiming;
        $this->classTimingDetail = $classTimingDetail;
        $this->academicSubject = $academicSubject;
        $this->subGroupCondSetting = $subGroupCondSetting;
        $this->swapCancel = $swapCancel;


    }


    public function routineDetailsEntries(Request $request)
    {
        //  DB::beginTransaction();

        //  try {
        $message = 'Nothing';

        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
        $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
        $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;
        $data['site_batch_detail_id'] = $request->site_batch_detail_id == 'null' ? null : $request->site_batch_detail_id;
        $data['academic_period_type_id'] = $request->academic_period_type_id == 'null' ? 0 : $request->academic_period_type_id;
        $data['generate_status'] = $request->generate_status;


        if (!$data['academic_period_type_id']) {
            return Response::json(['message' => 'Select * Marked Field!'], 410);
        }


        $getRoutineDetails = $this->routineDetail
            ->with(['routineAllocations' => function ($q) {
                $q->where('status', 1);
            }, 'routineAllocations.room', 'routineAllocations.employee.latestPhoto', 'routineAllocations.subject'])
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->where('academic_period_type_id', $data['academic_period_type_id'])
            ->where('academic_department_id', $data['academic_department_id'])
            ->where('academic_section_id', $data['academic_section_id'])
            ->where('academic_class_group_id', $data['academic_class_group_id'])
            ->where('academic_session_id', $data['academic_session_id'])
            ->where('site_batch_detail_id', $data['site_batch_detail_id'])
            ->orderBy('start_time', 'ASC')
            ->orderBy('id', 'ASC')
            ->get();


        $gent = $this->serializeNthPosition($data);


        if (count($getRoutineDetails) >= 1) {
            $message = 'Generated At ' . ($getRoutineDetails[0]->created_at ?? '');

        } else {//create for the first time

            $this->checkClassSection($data);// check only if data not found . if found show them otherwise


            if ($data['generate_status']) {

                $gent = $this->generate($data);

                $getRoutineDetails = $this->routineDetail
                    ->with(['routineAllocations' => function ($q) {
                        $q->where('status', 1);
                    }, 'routineAllocations.room', 'routineAllocations.employee.latestPhoto', 'routineAllocations.subject'])
                    ->where('academic_version_id', $data['academic_version_id'])
                    ->where('academic_year_id', $data['academic_year_id'])
                    ->where('academic_shift_id', $data['academic_shift_id'])
                    ->where('academic_class_id', $data['academic_class_id'])
                    ->where('academic_period_type_id', $data['academic_period_type_id'])
                    ->where('academic_session_id', $data['academic_session_id'])
                    ->where('academic_department_id', $data['academic_department_id'])
                    ->where('academic_section_id', $data['academic_section_id'])
                    ->where('academic_class_group_id', $data['academic_class_group_id'])
                    ->where('site_batch_detail_id', $data['site_batch_detail_id'])
                    ->orderBy('start_time', 'ASC')
                    ->get();


                $message = 'Generated First Time At ' . ($getRoutineDetails[0]->created_at ?? '');
            } else {
                return Response::json(['message' => 'No Routine Found! '], 412);

            }


        }

        $weekDays = array();

        foreach ($this->getWeekDay() as $k => $weekDay) {
            $weekDays[$k] = $weekDay;
        }


        $total_period = count($this->totalPeriodSlot($data));

        if (count($getRoutineDetails) <= 0) {
            return Response::json(['message' => 'Generate Routine Error!'], 410);
        }
        $headingList = $getRoutineDetails->where('weekday', $getRoutineDetails[0]->weekday) ?? [];//$weekDays[0] ->0 index means first day of the week

        return Response::json([$weekDays, $getRoutineDetails, $headingList, $message, $total_period], 200);


        /*} catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }*/
    }

    public function addNewSlot(Request $request)
    {
        //  DB::beginTransaction();

        try {

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
            $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
            $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;
            $data['site_batch_detail_id'] = $request->site_batch_detail_id == 'null' ? null : $request->site_batch_detail_id;
            $data['academic_period_type_id'] = $request->academic_period_type_id == 'null' ? 0 : $request->academic_period_type_id;
            $data['generate_status'] = $request->generate_status;

            $this->checkClassSection($data);

            if (!$data['academic_period_type_id'] || !$request->weekday || !$request->start_time || !$request->end_time) {
                return Response::json(['message' => 'Select * Marked Field!'], 410);
            }


            $start_time = $request->start_time;
            $end_time = $request->end_time;
            $week_day = $request->weekday;
            $is_break = $request->is_break;
            $start_time_plus = date('H:i:s', strtotime('+1 minutes', strtotime($start_time)));
            $end_time_less = date('H:i:s', strtotime('-1 minutes', strtotime($end_time)));


            $getRoutineDetails = $this->routineDetail
                ->where('weekday', $week_day)
                ->where(function ($query) use ($start_time_plus, $end_time_less) {
                    $query->where('start_time', '<=', $start_time_plus)
                        ->where('end_time', '>=', $start_time_plus)
                        ->orWhere(function ($query1) use ($end_time_less) {
                            $query1->where('start_time', '<=', $end_time_less);
                            $query1->where('end_time', '>=', $end_time_less);
                        });
                })
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('academic_period_type_id', $data['academic_period_type_id'])
                ->where('academic_department_id', $data['academic_department_id'])
                ->where('academic_section_id', $data['academic_section_id'])
                ->where('academic_class_group_id', $data['academic_class_group_id'])
                ->where('academic_session_id', $data['academic_session_id'])
                ->where('site_batch_detail_id', $data['site_batch_detail_id'])
                ->first();

            if ($getRoutineDetails) {
                return Response::json(['message' => 'You can"t add slot in existed time!'], 410);
            }


            $routine_details = new RoutineDetail();
            $routine_details->academic_version_id = $data['academic_version_id'];
            $routine_details->academic_year_id = $data['academic_year_id'];
            $routine_details->academic_shift_id = $data['academic_shift_id'];
            $routine_details->academic_department_id = $data['academic_department_id'];
            $routine_details->academic_class_id = $data['academic_class_id'];
            $routine_details->academic_section_id = $data['academic_section_id'];
            $routine_details->academic_class_group_id = $data['academic_class_group_id'];
            $routine_details->academic_period_type_id = $data['academic_period_type_id'];
            $routine_details->academic_session_id = $data['academic_session_id'];
            $routine_details->site_batch_detail_id = $data['site_batch_detail_id'];
            $routine_details->weekday = $week_day;
            $routine_details->start_time = $start_time;
            $routine_details->end_time = $end_time;
            $routine_details->is_break = $is_break;
            $routine_details->save();

            return Response::json(['message' => 'New slot successfully saved'], 200);


        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    public function routineDetailsRegenerate(Request $request)
    {
        try {

            //\Log::info($request);

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
            $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
            $data['academic_period_type_id'] = $request->academic_period_type_id;
            $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;
            $data['site_batch_detail_id'] = $request->site_batch_detail_id == 'null' ? null : $request->site_batch_detail_id;


            if (!$data['academic_period_type_id']) {
                return Response::json(['message' => 'Select * Marked Field!'], 410);
            }

            $this->checkClassSection($data);

            //  dd($data);

            $headingList = [];

            $getRoutineDetails = $this->routineDetail
                ->with('allocation', 'allocation.attendances')
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('academic_period_type_id', $data['academic_period_type_id'])
                ->where('academic_session_id', $data['academic_session_id'])
                ->where('academic_department_id', $data['academic_department_id'])
                ->where('academic_section_id', $data['academic_section_id'])
                ->where('academic_class_group_id', $data['academic_class_group_id'])
                ->where('site_batch_detail_id', $data['site_batch_detail_id']);


            $main_data = $getRoutineDetails->get();


            if ($getRoutineDetails->count() < 1) {
                return Response::json(['message' => 'Nothing To Regenerate! Create First'], 410);
            }


            $total_class_existed = $getRoutineDetails->has('allocation.attendances')->count();
            if ($total_class_existed) {
                return Response::json(['message' => 'Sorry, the routine has existing periodic attendance!'], 412);
            }


            $r_details_tb_ids = $main_data->pluck('id')->toArray();
            //check the routine has swap cancel data
            $swap_cancel_existed = $this->swapCancel->whereHas('allocation', function ($q) use ($r_details_tb_ids) {
                $q->whereIn('routine_details_id', $r_details_tb_ids);
            })->count();
            if ($swap_cancel_existed) {
                return Response::json(['message' => 'Sorry, the routine has swapCancel!'], 412);
            }

            if ($this->destroyMany($r_details_tb_ids)) {
                $response_mgs = $this->generate($data);

                return Response::json(['message' => 'Previous Details Deleted And Regenerated Again !'], 200);
            }

        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);

        }

    }

    public function generate(array $data)
    {


        $get_section_class_group_detail = $this->siteShiftClassGroupSectionSetting
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->first();


        if (!$get_section_class_group_detail) {
            throw new Error('No SiteShiftClassGroupSectionSetting Found');
        }

        $getRoutineDetails = $this->routineDetail
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_period_type_id', $data['academic_period_type_id'])
            ->where('site_batch_detail_id', $data['site_batch_detail_id'])
            ->where('academic_session_id', $data['academic_session_id'])
            ->where('academic_department_id', $data['academic_department_id'])
            ->where('academic_section_id', $data['academic_section_id'])
            ->where('academic_class_group_id', $data['academic_class_group_id'])
            ->first();


        if (!$getRoutineDetails) {//previous routine not found

            $getWeekdayClassTiming = (new WeekdayClassTiming())
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('academic_department_id', $data['academic_department_id'])
                ->where('academic_section_id', $data['academic_section_id'])
                ->where('academic_class_group_id', $data['academic_class_group_id'])
                ->where('academic_session_id', $data['academic_session_id'])
                ->first();


            if ($getWeekdayClassTiming) {
                $weekdayArray = json_decode($getWeekdayClassTiming->weekday_timing_info, true);


                foreach ($weekdayArray as $k => $value) {
                    $cd = (new  ClassTimingDetail())->where('class_timing_id', $value)->orderBy('start_time', 'ASC')->get();
                    if (count($cd) > 0) {
                        continue;
                    } else {
                        $the_class_timing = $this->classTiming->findOrFail($value);
                        throw new Error('Please Create Class Timing Details For: ' . $the_class_timing->name);
                    }
                }

                //everything ok now generate routine
                foreach ($weekdayArray as $k => $value) {
                    $cd = (new  ClassTimingDetail())->where('class_timing_id', $value)->orderBy('start_time', 'ASC')->get();

                    if (count($cd) > 0) {

                        foreach ($cd as $kk => $val) {
                            $routine_details = new RoutineDetail();
                            $routine_details->academic_version_id = $data['academic_version_id'];
                            $routine_details->academic_year_id = $data['academic_year_id'];
                            $routine_details->academic_shift_id = $data['academic_shift_id'];
                            $routine_details->academic_department_id = $data['academic_department_id'];
                            $routine_details->academic_class_id = $data['academic_class_id'];
                            $routine_details->academic_section_id = $data['academic_section_id'];
                            $routine_details->academic_class_group_id = $data['academic_class_group_id'];
                            $routine_details->academic_period_type_id = $data['academic_period_type_id'];
                            $routine_details->academic_session_id = $data['academic_session_id'];
                            $routine_details->site_batch_detail_id = $data['site_batch_detail_id'];
                            $routine_details->weekday = $k;
                            $routine_details->start_time = $val->start_time;
                            $routine_details->end_time = $val->end_time;
                            $routine_details->is_break = $val->is_break;
                            $routine_details->save();

                        }
                    } else {

                        $the_class_timing = $this->classTiming->findOrFail($value);
                        throw new Error('Please Create Class Timing Details For: ' . $the_class_timing->name);
                    }
                }


            } else {
                throw new Error('Please Create Weekday Wise Class Timing First!');
            }
        }
    }


    public function serializeNthPosition(array $data)
    {


        $getRoutineDetails = $this->routineDetail
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->where('academic_period_type_id', $data['academic_period_type_id'])
            ->where('academic_department_id', $data['academic_department_id'])
            ->where('academic_section_id', $data['academic_section_id'])
            ->where('academic_class_group_id', $data['academic_class_group_id'])
            ->where('academic_session_id', $data['academic_session_id'])
            ->where('site_batch_detail_id', $data['site_batch_detail_id'])
            ->orderBy('start_time', 'ASC')
            ->get();


        foreach ($this->getWeekDay() as $wk => $weekDay) {

            $routine_days = array_values($getRoutineDetails->where('weekday', $weekDay->weekday_key)->toArray());
            $position = 1;

            foreach ($routine_days as $k => $detail) {
                $the_details = $this->routineDetail->find($detail['id']);
                $the_details->position = $position;
                $the_details->first_last = ($k == 0 ? 'first' : null);
                $the_details->first_last = ($k == (count($routine_days) - 1) ? 'last' : $the_details->first_last);
                $the_details->save();
                $position++;
            }

        }


    }


    public function getSubjectsBasedOnSlot($slot_id)
    {
        try {

            $the_slot = $this->routineDetail->find($slot_id);


            $year_id = $the_slot->academic_year_id;
            $department_id = $the_slot->academic_department_id;
            $class_id = $the_slot->academic_class_id;

            if (!$class_id || !$year_id) {
                return response()->json(['message' => 'Select * Marked Field!'], 410);
            }

            $sub_gr_cond_sett = $this->subGroupCondSetting
                ->with(['academicClass', 'academicSubject'])
                ->where('academic_class_id', $class_id)
                ->where('academic_year_id', $year_id)
                ->whereHas('academicSubjectClassExamCondition', function ($q) {
                    $q->whereIn('name_key', ["onlyforclass", "forclassandexam"]);
                })
                ->when($department_id, function ($query) use ($department_id) {
                    return $query->where('academic_department_id', $department_id);
                })->get();


            $subject_id_array = $sub_gr_cond_sett->pluck('academic_subject_id');
            $subject_list = $this->academicSubject
                ->whereIn('academic_subjects.id', $subject_id_array)
                ->orderByTranslation('subject_name', 'ASC')
                ->get();

            $subjects = $subject_list->transform(function ($value) {

                return [
                    'academic_subject_id' => $value->id,
                    'subject_name' => $value->subject_name
                ];
            });

            return response()->json($subjects, 200);


        } catch (Exception $exception) {
            return $exception->getMessage();

        }
    }

    public function dropRoutine(Request $request)
    {
        try {


            $routine_details_ids = $request->slotIds;
            $forced_drop = $request->forced_drop;

            if (count($routine_details_ids) < 1) {
                return response()->json(['message' => "No Routine To Delete!"], 410);
            }


            $swap_cancel_existed = $this->swapCancel->whereHas('allocation', function ($q) use ($routine_details_ids) {
                $q->whereIn('routine_details_id', $routine_details_ids);
            })->count();

            //   $allocation_existed = $this->routineAllocation->whereIn('routine_details_id', $routine_details_ids)->count();
            $allocation_existed = $this->routineAllocation->whereIn('routine_details_id', $routine_details_ids);

            $allocation_existed_count = $allocation_existed->count();


            if (!$forced_drop && ($swap_cancel_existed || $allocation_existed_count)) {
                return Response::json(['message' => "Existed Allocation:" . $allocation_existed_count . " & Swap Cancel:" . $swap_cancel_existed], 409);
            }


            if (!$forced_drop && ($swap_cancel_existed || $allocation_existed_count)) {
                return Response::json(['message' => "Existed Allocation:" . $allocation_existed_count . " & Swap Cancel:" . $swap_cancel_existed], 409);
            }


            $total_class_existed = $allocation_existed->has('attendances')->count();
            if ($total_class_existed) {
                return Response::json(['message' => 'Sorry, the routine has existing periodic attendance for ' . $total_class_existed . ' allocations.'], 412);
            }


            if ($this->destroyMany($routine_details_ids)) {
                return response()->json(["mode" => "Success", 'message' => "The routine has successfully dropped! "], 200);
            }


        } catch (Exception $exception) {
            throw new Error($exception->getMessage());

        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  array $ids
     * @return boolean
     */
    public function destroyMany(array $ids)
    {
        try {
            $this->swapCancel->whereHas('allocation', function ($q) use ($ids) {
                $q->whereIn('routine_details_id', $ids);
            })->delete();

            $this->routineAllocation->whereIn('routine_details_id', $ids)->delete();
            $this->routineDetail->destroy($ids);

            return true;

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());

        }
    }
}
