<?php

namespace App\Http\Controllers\Site\SiteAcademicSettingReplication;

use App\Models\Academic\AcademicSession;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\Employee\TeacherAssignToClassSection;
use App\Models\Site\Exam\SiteSubjectExaminationExamTypeMark;
use App\Models\Site\Exam\SiteSubjectExaminationMark;
use App\Models\Site\Fee\SiteStudentFeeFineAllocation;
use App\Models\Site\Result\SiteResultCombineSetting;
use App\Models\Site\Result\SiteResultPrimarySetting;
use App\Models\Site\Result\SiteResultSystemSetting;
use App\Models\Site\SiteAcademicSettingReplication\SiteAcademicSettingReplicationHistory;
use App\Models\Site\SiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Carbon\Carbon;
use DateTime;
use Error;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
//use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Session;
use Auth;
use Response;

class SiteAcademicSettingReplicationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Site Academic Setting Replication';

        return view('default.admin.layouts.master',compact('viewType'));
        return view('default.admin.site.site-academic-setting-replication.index',compact('viewType'));
    }

    public function getAcademicSettingList($present_academic_year_id, $transfer_academic_year_id)
    {
//        return [$present_academic_year_id, $transfer_academic_year_id];
            if ($present_academic_year_id == $transfer_academic_year_id) {
                throw new Error('Sorry! years are same!');
            }

            $present_year = AcademicYear::where('id', $present_academic_year_id)->first();
            $transfer_year = AcademicYear::where('id', $transfer_academic_year_id)->first();



            //===============present year======================
            $date_pr = DateTime::createFromFormat("Y-m-d", $present_year->start_date);

            $year_pr = $date_pr->format("Y");

            //===============transfer year======================
            $date_tr = DateTime::createFromFormat("Y-m-d", $transfer_year->start_date);

            $year_tr = $date_tr->format("Y");

//        return $transfer_year;
//        return [$year_pr, $year_tr];

            //===============check greater than new year===============
            if ($year_pr > $year_tr) {
                throw new Error('Sorry! present year can not be greater than new year!');

            }

            //===============check year difference more than 1===============
            $year_difference = $year_tr - $year_pr;

            if ($year_difference > 1 || $year_difference < 1) {
                throw new Error('Sorry! year difference can not be more than 1 year!');

            }


            //=======================================================[ setting details list]============================================================
            $array_data = [
                ["id" => 1, "name" => "Shift Version Year Class Department Group Section Setting"],
                ["id" => 2, "name" => "Subject Group Condition Setting"],
                ["id" => 3, "name" => "Result System Setting"],
                ["id" => 4, "name" => "Primary Result Setting"],
                ["id" => 5, "name" => "Combine Result Setting"],
                ["id" => 6, "name" => "Fee Setting"],
                ["id" => 7, "name" => "Teacher Assign To Class Setting"],
            ];
//        return $array_data;
            $site_id = Session::get('SITE_ID');

            $final_array_data = [];

            foreach ($array_data as $key => $value) {

                //==========================Site Academic Setting Replication History======================

                if ($value['id'] == 1) {

                    $final_array_data[$key]['id'] = $value['id'];
                    $final_array_data[$key]['name'] = $value['name'];
                    $final_array_data[$key]['present_academic_year_id'] = $present_academic_year_id;
                    $final_array_data[$key]['transfer_academic_year_id'] = $transfer_academic_year_id;

                    $present_data_check = SiteAcademicSettingReplicationHistory::where('setting_id', $value['id'])
                        ->where('to_academic_year_id', $transfer_academic_year_id)
                        ->where('site_id', $site_id)
                        ->where('status', 1)
                        ->get();
                    $replicatable_data = [];
                    if (count($present_data_check)) {
                        $check_setting_if_present = SiteShiftClassGroupSectionSetting::where('site_id', $site_id)
                            ->where('academic_year_id', $transfer_academic_year_id)
                            ->first();
                        if (!$check_setting_if_present) {
                            $check_setting_if_present = SiteShiftClassGroupSectionSetting::where('site_id', $site_id)
                                ->where('academic_year_id', $present_academic_year_id)
                                ->get();
                            if (count($check_setting_if_present)) {

                                foreach ($check_setting_if_present as $kk => $vvl) {
                                    $check_data = $present_data_check->where('replicated_table_row_id', $vvl->id);
                                    if (!$check_data) {
                                        $replicatable_data[$kk] = $vvl;
                                    }
                                }
                            }
                        }

                    } else {
                        $check_setting_if_present = SiteShiftClassGroupSectionSetting::where('site_id', $site_id)
                            ->where('academic_year_id', $present_academic_year_id)
                            ->get();
                        if (count($check_setting_if_present)) {
                            $replicatable_data = $check_setting_if_present;
                        }
                    }

                    $final_array_data[$key]['replicable_data'] = $replicatable_data;
                    if ($replicatable_data) {
                        $final_array_data[$key]['total_replicable_number'] = $replicatable_data->count();
                    } else {
                        $final_array_data[$key]['total_replicable_number'] = 0;

                    }
                }

//            return $final_array_data;

                //==========================Site Academic Setting Replication History======================
                if ($value['id'] == 2) {
                    $final_array_data[$key]['id'] = $value['id'];
                    $final_array_data[$key]['name'] = $value['name'];
                    $final_array_data[$key]['present_academic_year_id'] = $present_academic_year_id;
                    $final_array_data[$key]['transfer_academic_year_id'] = $transfer_academic_year_id;

                    $present_data_check = SiteAcademicSettingReplicationHistory::where('setting_id', $value['id'])
                        ->where('to_academic_year_id', $transfer_academic_year_id)
                        ->where('status', 1)
                        ->where('site_id', $site_id)
                        ->get();
                    $replicatable_data = [];
                    if (count($present_data_check)) {
                        $check_setting_if_present = SubjectGroupConditionSetting::where('site_id', $site_id)
                            ->where('academic_year_id', $transfer_academic_year_id)
                            ->where('status', 1)
                            ->first();
                        if (!$check_setting_if_present) {
                            $check_setting_if_present = SubjectGroupConditionSetting::where('site_id', $site_id)
                                ->where('academic_year_id', $present_academic_year_id)
                                ->where('status', 1)
                                ->get();
                            if (count($check_setting_if_present)) {

                                foreach ($check_setting_if_present as $kk => $vvl) {
                                    $check_data = $present_data_check->where('replicated_table_row_id', $vvl->id);
                                    if (!$check_data) {
                                        $replicatable_data[$kk] = $vvl;
                                    }
                                }
                            }
                        }

                    } else {
                        $check_setting_if_present = SubjectGroupConditionSetting::where('site_id', $site_id)
                            ->where('academic_year_id', $present_academic_year_id)
                            ->where('status', 1)
                            ->get();
                        if (count($check_setting_if_present)) {
                            $replicatable_data = $check_setting_if_present;
                        }
                    }

                    $final_array_data[$key]['replicable_data'] = $replicatable_data;
                    if ($replicatable_data) {
                        $final_array_data[$key]['total_replicable_number'] = $replicatable_data->count();
                    } else {
                        $final_array_data[$key]['total_replicable_number'] = 0;

                    }

                }

                //==========================Result System Setting======================

                if ($value['id'] == 3) {
                    $final_array_data[$key]['id'] = $value['id'];
                    $final_array_data[$key]['name'] = $value['name'];
                    $final_array_data[$key]['present_academic_year_id'] = $present_academic_year_id;
                    $final_array_data[$key]['transfer_academic_year_id'] = $transfer_academic_year_id;

                    //---------------------------site result system setting-----------------------
                    $present_data_check = SiteAcademicSettingReplicationHistory::where('setting_id', $value['id'])
                        ->where('to_academic_year_id', $transfer_academic_year_id)
                        ->where('site_id', $site_id)
                        ->where('status', 1)
                        ->get();
                    $replicatable_data = [];
                    if (count($present_data_check)) {
                        $check_setting_if_present = SiteResultSystemSetting::where('site_id', $site_id)
                            ->where('academic_year_id', $transfer_academic_year_id)
                            ->where('status', 1)
                            ->first();
                        if (!$check_setting_if_present) {
                            $check_setting_if_present = SiteResultSystemSetting::where('site_id', $site_id)
                                ->where('academic_year_id', $present_academic_year_id)
                                ->where('status', 1)
                                ->get();
                            if (count($check_setting_if_present)) {

                                foreach ($check_setting_if_present as $kk => $vvl) {
                                    $check_data = $present_data_check->where('replicated_table_row_id', $vvl->id);
                                    if (!$check_data) {
                                        $replicatable_data[$kk] = $vvl;
                                    }
                                }
                            }
                        }

                    } else {
                        $check_setting_if_present = SiteResultSystemSetting::where('site_id', $site_id)
                            ->where('academic_year_id', $present_academic_year_id)
                            ->where('status', 1)
                            ->get();
                        if (count($check_setting_if_present)) {
                            $replicatable_data = $check_setting_if_present;
                        }
                    }

                    $final_array_data[$key]['replicable_data'] = $replicatable_data;
                    if ($replicatable_data) {
                        $final_array_data[$key]['total_replicable_number'] = $replicatable_data->count();
                    } else {
                        $final_array_data[$key]['total_replicable_number'] = 0;

                    }
                }

                //==========================Primary Result Setting======================

                if ($value['id'] == 4) {
                    $final_array_data[$key]['id'] = $value['id'];
                    $final_array_data[$key]['name'] = $value['name'];
                    $final_array_data[$key]['present_academic_year_id'] = $present_academic_year_id;
                    $final_array_data[$key]['transfer_academic_year_id'] = $transfer_academic_year_id;

                    //---------------------------site result system setting-----------------------
                    $present_data_check = SiteAcademicSettingReplicationHistory::where('setting_id', $value['id'])
                        ->where('to_academic_year_id', $transfer_academic_year_id)
                        ->where('site_id', $site_id)
                        ->where('status', 1)
                        ->get();
                    $replicatable_data = [];
                    if (count($present_data_check)) {
                        $check_setting_if_present = SiteResultPrimarySetting::where('site_id', $site_id)
                            ->where('academic_year_id', $transfer_academic_year_id)
                            ->where('status', 1)
                            ->first();
                        if (!$check_setting_if_present) {
                            $check_setting_if_present = SiteResultPrimarySetting::where('site_id', $site_id)
                                ->where('academic_year_id', $present_academic_year_id)
                                ->where('status', 1)
                                ->get();
                            if (count($check_setting_if_present)) {

                                foreach ($check_setting_if_present as $kk => $vvl) {
                                    $check_data = $present_data_check->where('replicated_table_row_id', $vvl->id);
                                    if (!$check_data) {
                                        $replicatable_data[$kk] = $vvl;
                                    }
                                }
                            }
                        }

                    } else {
                        $check_setting_if_present = SiteResultPrimarySetting::where('site_id', $site_id)
                            ->where('academic_year_id', $present_academic_year_id)
                            ->where('status', 1)
                            ->get();
                        if (count($check_setting_if_present)) {
                            $replicatable_data = $check_setting_if_present;
                        }
                    }

                    $final_array_data[$key]['replicable_data'] = $replicatable_data;
                    if ($replicatable_data) {
                        $final_array_data[$key]['total_replicable_number'] = $replicatable_data->count();
                    } else {
                        $final_array_data[$key]['total_replicable_number'] = 0;

                    }
                }

                //==========================Combine Result Setting======================

                if ($value['id'] == 5) {
                    $final_array_data[$key]['id'] = $value['id'];
                    $final_array_data[$key]['name'] = $value['name'];
                    $final_array_data[$key]['present_academic_year_id'] = $present_academic_year_id;
                    $final_array_data[$key]['transfer_academic_year_id'] = $transfer_academic_year_id;

                    //---------------------------site result system setting-----------------------
                    $present_data_check = SiteAcademicSettingReplicationHistory::where('setting_id', $value['id'])
                        ->where('to_academic_year_id', $transfer_academic_year_id)
                        ->where('site_id', $site_id)
                        ->where('status', 1)
                        ->get();
                    $replicatable_data = [];
                    if (count($present_data_check)) {
                        $check_setting_if_present = SiteResultCombineSetting::where('site_id', $site_id)
                            ->where('academic_year_id', $transfer_academic_year_id)
                            ->where('status', 1)
                            ->first();
                        if (!$check_setting_if_present) {
                            $check_setting_if_present = SiteResultCombineSetting::where('site_id', $site_id)
                                ->where('academic_year_id', $present_academic_year_id)
                                ->where('status', 1)
                                ->get();
                            if (count($check_setting_if_present)) {

                                foreach ($check_setting_if_present as $kk => $vvl) {
                                    $check_data = $present_data_check->where('replicated_table_row_id', $vvl->id);
                                    if (!$check_data) {
                                        $replicatable_data[$kk] = $vvl;
                                    }
                                }
                            }
                        }

                    } else {
                        $check_setting_if_present = SiteResultCombineSetting::where('site_id', $site_id)
                            ->where('academic_year_id', $present_academic_year_id)
                            ->where('status', 1)
                            ->get();
                        if (count($check_setting_if_present)) {
                            $replicatable_data = $check_setting_if_present;
                        }
                    }

                    $final_array_data[$key]['replicable_data'] = $replicatable_data;
                    if ($replicatable_data) {
                        $final_array_data[$key]['total_replicable_number'] = $replicatable_data->count();
                    } else {
                        $final_array_data[$key]['total_replicable_number'] = 0;

                    }
                }

                //==========================Site Student Fee Fine Allocation======================

                if ($value['id'] == 6) {

                    $final_array_data[$key]['id'] = $value['id'];
                    $final_array_data[$key]['name'] = $value['name'];
                    $final_array_data[$key]['present_academic_year_id'] = $present_academic_year_id;
                    $final_array_data[$key]['transfer_academic_year_id'] = $transfer_academic_year_id;

                    $present_data_check = SiteAcademicSettingReplicationHistory::where('setting_id', $value['id'])
                        ->where('to_academic_year_id', $transfer_academic_year_id)
                        ->where('site_id', $site_id)
                        ->where('status', 1)
                        ->get();
                    $replicatable_data = [];
                    if (count($present_data_check)) {
                        $check_setting_if_present = SiteStudentFeeFineAllocation::where('site_id', $site_id)
                            ->where('academic_year_id', $transfer_academic_year_id)
                            ->where('status', 1)
                            ->first();
                        if (!$check_setting_if_present) {
                            $check_setting_if_present = SiteStudentFeeFineAllocation::where('site_id', $site_id)
                                ->where('academic_year_id', $present_academic_year_id)
                                ->where('status', 1)
                                ->get();
                            if (count($check_setting_if_present)) {

                                foreach ($check_setting_if_present as $kk => $vvl) {
                                    $check_data = $present_data_check->where('replicated_table_row_id', $vvl->id);
                                    if (!$check_data) {
                                        $replicatable_data[$kk] = $vvl;
                                    }
                                }
                            }
                        }

                    } else {
                        $check_setting_if_present = SiteStudentFeeFineAllocation::where('site_id', $site_id)
                            ->where('academic_year_id', $present_academic_year_id)
                            ->where('status', 1)
                            ->get();
                        if (count($check_setting_if_present)) {
                            $replicatable_data = $check_setting_if_present;
                        }
                    }

                    $final_array_data[$key]['replicable_data'] = $replicatable_data;
                    if ($replicatable_data) {
                        $final_array_data[$key]['total_replicable_number'] = $replicatable_data->count();
                    } else {
                        $final_array_data[$key]['total_replicable_number'] = 0;

                    }
                }


                //==========================Site Student Fee Fine Allocation======================

                if ($value['id'] == 7) {

                    $final_array_data[$key]['id'] = $value['id'];
                    $final_array_data[$key]['name'] = $value['name'];
                    $final_array_data[$key]['present_academic_year_id'] = $present_academic_year_id;
                    $final_array_data[$key]['transfer_academic_year_id'] = $transfer_academic_year_id;
                    $academic_group_id = (int)session()->get('ACADEMIC_GROUP_ID');

                    $present_data_check = SiteAcademicSettingReplicationHistory::where('setting_id', $value['id'])
                        ->where('to_academic_year_id', $transfer_academic_year_id)
                        ->where('site_id', $site_id)
                        ->where('academic_group_id', $academic_group_id)
                        ->where('status', 1)
                        ->get();
                    $replicatable_data = [];
                    if (count($present_data_check)) {
                        $check_setting_if_present = TeacherAssignToClassSection::where('site_id', $site_id)
                            ->where('academic_year_id', $transfer_academic_year_id)
                            ->where('academic_group_id', $academic_group_id)
                            ->where('status', 1)
                            ->first();
                        if (!$check_setting_if_present) {
                            $check_setting_if_present = TeacherAssignToClassSection::where('site_id', $site_id)
                                ->where('academic_year_id', $present_academic_year_id)
                                ->where('status', 1)
                                ->get();
                            if (count($check_setting_if_present)) {

                                foreach ($check_setting_if_present as $kk => $vvl) {
                                    $check_data = $present_data_check->where('replicated_table_row_id', $vvl->id);
                                    if (!$check_data) {
                                        $replicatable_data[$kk] = $vvl;
                                    }
                                }
                            }
                        }

                    } else {
                        $check_setting_if_present = TeacherAssignToClassSection::where('site_id', $site_id)
                            ->where('academic_year_id', $present_academic_year_id)
                            ->where('status', 1)
                            ->get();
                        if (count($check_setting_if_present)) {
                            $replicatable_data = $check_setting_if_present;
                        }
                    }

                    $final_array_data[$key]['replicable_data'] = $replicatable_data;
                    if ($replicatable_data) {
                        $final_array_data[$key]['total_replicable_number'] = $replicatable_data->count();
                    } else {
                        $final_array_data[$key]['total_replicable_number'] = 0;

                    }
                }


            }

            return $final_array_data;

    }

    public function replicateSiteAcademicSetting(Request $request)
    {
//        return $request;
        $data = $request->item;
        $session_selective_data = $request->session_selective_data;
//
//        if(!$academic_session_id){
//            return 'found';
//        }else{
//            return 'null';
//        }
//        return $academic_session_id;

            $present_academic_year_id = $data['present_academic_year_id'];
            $transfer_academic_year_id = $data['transfer_academic_year_id'];
            $replicable_data = $data['replicable_data'];

            //================replicaton site shift class group section setting===============
            if($data['id'] == 1 && $replicable_data){
                $response = $this->replicateSiteShiftClassGroupsectionSetting($data, $session_selective_data, $present_academic_year_id, $transfer_academic_year_id, $replicable_data);
                return $response;

            }

            //================subject group condition setting replicaton===============
            if($data['id'] == 2 && $replicable_data){
                $response = $this->replicateSubjectGroupConditionSetting($data, $present_academic_year_id, $transfer_academic_year_id, $replicable_data);
                return $response;

            }

            //======================= result system setting =======================
            if($data['id']== 3 && $replicable_data){
                $response = $this->replicateSiteResultSystemSetting($data, $session_selective_data, $present_academic_year_id, $transfer_academic_year_id, $replicable_data);
                return $response;

            }

            //======================= primary result setting =======================
            if($data['id'] == 4 && $replicable_data){
                $response = $this->replicateSiteResultPrimarySetting($data, $session_selective_data, $present_academic_year_id, $transfer_academic_year_id, $replicable_data);
                return $response;

            }

            //======================= combine result setting =======================
            if($data['id'] == 5 && $replicable_data){
                $response = $this->replicateSiteResultCombineSetting($data, $session_selective_data, $present_academic_year_id, $transfer_academic_year_id, $replicable_data);
                return $response;

            }

            //======================= fee fine allocation setting =======================
            if($data['id'] == 6 && $replicable_data){

                $response = $this->replicateSiteStudentFeeFineAllocationSetting($data, $session_selective_data, $present_academic_year_id, $transfer_academic_year_id, $replicable_data);
                return $response;
            }

            //======================= teacher class section assign setting =======================
            if($data['id'] == 7 && $replicable_data){

                $response = $this->replicateTeacherClassSectionAssignSetting($data, $present_academic_year_id, $transfer_academic_year_id, $replicable_data);
                return $response;
            }

//            return Response::json(['message' => 'Data Save Successfully!', 'mode' => 'Saved!'], 200);


    }

    public function replicateSiteShiftClassGroupsectionSetting($request, $session_selective_data, $present_academic_year_id, $transfer_academic_year_id, $replicable_data)
    {

        $session_ids_check = [];
        if(count($session_selective_data)){
            foreach ($session_selective_data as $kk => $vv){
                if($vv['select_session_status'] && $vv['id'] && $vv['new_session_id']){
                    if($vv['id'] == $vv['new_session_id']){
                        throw new Error('Sorry, sessions are same!');

                    }
                    $check_session_if_exist = StudentHistory::where('academic_session_id', $vv['new_session_id'])->first();
                    if($check_session_if_exist){
                        throw new Error('Sorry, session already present!');

                    }
                    $session_ids_check[$kk]['present_session_id'] = $vv['id'];
                    $session_ids_check[$kk]['new_session_id'] = $vv['new_session_id'];
                }

            }
            if(!$session_ids_check){
                throw new Error('Please, select session!');

            }

        }

        foreach ($replicable_data as $key => $value){


            if(!$session_selective_data){
                if($value['academic_session_id']){
                    return $session_check = 1;
                }else{

                    SiteShiftClassGroupSectionSetting::insert([
                        'academic_group_id' => $value['academic_group_id'],
                        'academic_year_id' => $transfer_academic_year_id,
                        'academic_version_id' => $value['academic_version_id'],
                        'academic_shift_id' => $value['academic_shift_id'],
                        'academic_class_id' => $value['academic_class_id'],
                        'academic_department_id' => $value['academic_department_id'],
                        'academic_session_id' => $value['academic_session_id'],
                        'academic_class_group_id' => $value['academic_class_group_id'],
                        'academic_section_ids' => $value['academic_section_ids'],
                        'seat_capacity' => $value['seat_capacity'],
                        'seat_extend' => $value['seat_extend'],
                        'site_id' => $value['site_id'],
                    ]);
                    $get_last_data = SiteShiftClassGroupSectionSetting::where('site_id', $value['site_id'])->orderBy('id','DESC')->first();
                    SiteAcademicSettingReplicationHistory::insert([
                        'from_academic_year_id' => $present_academic_year_id,
                        'to_academic_year_id' => $transfer_academic_year_id,
                        'replicated_table_row_id' => $get_last_data->id,
                        'setting_id' => $request['id'],
                        'created_by' => Auth::user()->id,
                        'site_id' => $value['site_id'],
                        'academic_group_id' => $value['academic_group_id'],
                        'status' => 1,
                    ]);

                }
            }else{

                if (count($session_ids_check)){
                    foreach ($session_ids_check as $kky => $vvl){
//                            return $vvl['present_session_id'];
                        if($value['academic_session_id']==$vvl['present_session_id']){


                            SiteShiftClassGroupSectionSetting::insert([
                                'academic_group_id' => $value['academic_group_id'],
                                'academic_year_id' => $transfer_academic_year_id,
                                'academic_version_id' => $value['academic_version_id'],
                                'academic_shift_id' => $value['academic_shift_id'],
                                'academic_class_id' => $value['academic_class_id'],
                                'academic_department_id' => $value['academic_department_id'],
                                'academic_session_id' => $vvl['new_session_id'],
                                'academic_class_group_id' => $value['academic_class_group_id'],
                                'academic_section_ids' => $value['academic_section_ids'],
                                'seat_capacity' => $value['seat_capacity'],
                                'seat_extend' => $value['seat_extend'],
                                'site_id' => $value['site_id'],

                            ]);
                            $get_last_data = SiteShiftClassGroupSectionSetting::where('site_id', $value['site_id'])->orderBy('id','DESC')->first();
                            SiteAcademicSettingReplicationHistory::insert([
                                'from_academic_year_id' => $present_academic_year_id,
                                'to_academic_year_id' => $transfer_academic_year_id,
                                'replicated_table_row_id' => $get_last_data->id,
                                'setting_id' => $request['id'],
                                'created_by' => Auth::user()->id,
                                'site_id' => $value['site_id'],
                                'academic_group_id' => $value['academic_group_id'],
                                'status' => 1,
                            ]);

                        }
                    }

                    if(!$value['academic_session_id']){



                        SiteShiftClassGroupSectionSetting::insert([
                            'academic_group_id' => $value['academic_group_id'],
                            'academic_year_id' => $transfer_academic_year_id,
                            'academic_version_id' => $value['academic_version_id'],
                            'academic_shift_id' => $value['academic_shift_id'],
                            'academic_class_id' => $value['academic_class_id'],
                            'academic_department_id' => $value['academic_department_id'],
                            'academic_session_id' => $value['academic_session_id'],
                            'academic_class_group_id' => $value['academic_class_group_id'],
                            'academic_section_ids' => $value['academic_section_ids'],
                            'seat_capacity' => $value['seat_capacity'],
                            'seat_extend' => $value['seat_extend'],
                            'site_id' => $value['site_id'],

                        ]);
                        $get_last_data = SiteShiftClassGroupSectionSetting::where('site_id', $value['site_id'])->orderBy('id','DESC')->first();
                        SiteAcademicSettingReplicationHistory::insert([
                            'from_academic_year_id' => $present_academic_year_id,
                            'to_academic_year_id' => $transfer_academic_year_id,
                            'replicated_table_row_id' => $get_last_data->id,
                            'setting_id' => $request['id'],
                            'created_by' => Auth::user()->id,
                            'site_id' => $value['site_id'],
                            'academic_group_id' => $value['academic_group_id'],
                            'status' => 1,
                        ]);

                    }
                }


            }

        }


    }

    public function replicateSubjectGroupConditionSetting($request, $present_academic_year_id, $transfer_academic_year_id, $replicable_data)
    {

            foreach ($replicable_data as $key => $value){
                SubjectGroupConditionSetting::insert([
                    'academic_subject_id' => $value['academic_subject_id'],
                    'academic_group_id' => $value['academic_group_id'],
                    'academic_year_id' => $transfer_academic_year_id,
                    'academic_class_id' => $value['academic_class_id'],
                    'academic_department_id' => $value['academic_department_id'],
                    'academic_class_group_ids' => $value['academic_class_group_ids'],
                    'academic_subject_condition_ids' => $value['academic_subject_condition_ids'],
                    'academic_subject_class_exam_condition_id' => $value['academic_subject_class_exam_condition_id'],
                    'exam_dependent_academic_subject_id' => $value['exam_dependent_academic_subject_id'],
                    'subject_position' => $value['subject_position'],
                    'result_show_in_table_bellow' => $value['result_show_in_table_bellow'],
                    'subject_code' => $value['subject_code'],
                    'note' => $value['note'],
                    'site_id' => $value['site_id'],
                    'status' => 1,
                ]);
                $get_last_newly_inserted_data = SubjectGroupConditionSetting::where('site_id', $value['site_id'])->where('status', 1)->orderBy('id','DESC')->first();

                //--------------------------------new data insert to site subject examination mark table---------------------------------------

                $site_subject_examintaion_mark_data = SiteSubjectExaminationMark::where('site_subject_group_condition_setting_id', $value['id'])->where('status', 1)->get();
                if(count($site_subject_examintaion_mark_data)){
                    foreach ($site_subject_examintaion_mark_data as $kk => $vl){
                        SiteSubjectExaminationMark::insert([
                            'site_subject_group_condition_setting_id' => $get_last_newly_inserted_data->id,
                            'examination_id' => $vl->examination_id,
                            'marks' => $vl->marks,
                            'pass_marks' => $vl->pass_marks,
                            'academic_group_id' => $vl->academic_group_id,
                            'site_id' => $value['site_id'],
                            'status' => 1,
                        ]);

                        $get_last_inserted_data = SiteSubjectExaminationMark::where('site_id', $value['site_id'])->where('status', 1)->orderBy('id','DESC')->first();


                        //--------------------------------new data insert to site subject examination exam type mark table---------------------------------------

                        $site_subject_examintaion_exam_type_mark_data = SiteSubjectExaminationExamTypeMark::where('site_subject_examination_mark_id', $vl->id)->where('status', 1)->get();
                        if(count($site_subject_examintaion_exam_type_mark_data)){
                            foreach ($site_subject_examintaion_exam_type_mark_data as $kkk => $vvl){
                                SiteSubjectExaminationExamTypeMark::insert([
                                    'site_subject_examination_mark_id' => $get_last_inserted_data->id,
                                    'academic_exam_type_id' => $vvl->academic_exam_type_id,
                                    'marks' => $vvl->marks,
                                    'pass_marks' => $vvl->pass_marks,
                                    'academic_group_id' => $vvl->academic_group_id,
                                    'site_id' => $value['site_id'],
                                    'status' => 1,
                                ]);
                            }
                        }
                    }
                }

                //------------------------------------insert to site academic setting replication history table--------------------------

                SiteAcademicSettingReplicationHistory::insert([
                    'from_academic_year_id' => $present_academic_year_id,
                    'to_academic_year_id' => $transfer_academic_year_id,
                    'replicated_table_row_id' => $get_last_newly_inserted_data->id,
                    'setting_id' => $request['id'],
                    'created_by' => Auth::user()->id,
                    'site_id' => $value['site_id'],
                    'academic_group_id' => $value['academic_group_id'],
                    'status' => 1,
                ]);

            }


    }

    public function replicateSiteResultSystemSetting($request, $session_selective_data, $present_academic_year_id, $transfer_academic_year_id, $replicable_data)
    {

            $session_ids_check = [];
            if(count($session_selective_data)){
                foreach ($session_selective_data as $kk => $vv){
                    if($vv['select_session_status'] && $vv['id'] && $vv['new_session_id']){
                        if($vv['id'] == $vv['new_session_id']){
                            throw new Error('Sorry, sessions are same!');

                        }
                        $check_session_if_exist = StudentHistory::where('academic_session_id', $vv['new_session_id'])->first();
                        if($check_session_if_exist){
                            throw new Error('Sorry, session already present!');

                        }
                        $session_ids_check[$kk]['present_session_id'] = $vv['id'];
                        $session_ids_check[$kk]['new_session_id'] = $vv['new_session_id'];
                    }

                }
                if(!$session_ids_check){
                    throw new Error('Please, select session!');

                }

            }

            foreach ($replicable_data as $key => $value){


                if(!$session_selective_data){
                    if($value['academic_session_id']){
                        return $session_check = 1;
                    }else{

                        SiteResultSystemSetting::insert([
                            'academic_group_id' => $value['academic_group_id'],
                            'academic_year_id' => $transfer_academic_year_id,
                            'academic_version_id' => $value['academic_version_id'],
                            'academic_shift_id' => $value['academic_shift_id'],
                            'academic_class_id' => $value['academic_class_id'],
                            'academic_department_id' => $value['academic_department_id'],
                            'academic_session_id' => $value['academic_session_id'],
                            'academic_result_system_id' => $value['academic_result_system_id'],
                            'number_from' => $value['number_from'],
                            'number_to' => $value['number_to'],
                            'point' => $value['point'],
                            'point_from' => $value['point_to'],
                            'site_id' => $value['site_id'],
                            'status' => 1,
                        ]);
                        $get_last_data = SiteResultSystemSetting::where('site_id', $value['site_id'])->where('status', 1)->orderBy('id','DESC')->first();
                        SiteAcademicSettingReplicationHistory::insert([
                            'from_academic_year_id' => $present_academic_year_id,
                            'to_academic_year_id' => $transfer_academic_year_id,
                            'replicated_table_row_id' => $get_last_data->id,
                            'setting_id' => $request['id'],
                            'created_by' => Auth::user()->id,
                            'site_id' => $value['site_id'],
                            'academic_group_id' => $value['academic_group_id'],
                            'status' => 1,
                        ]);

                    }
                }else{

                    if (count($session_ids_check)){
                        foreach ($session_ids_check as $kky => $vvl){
//                            return $vvl['present_session_id'];
                            if($value['academic_session_id']==$vvl['present_session_id']){

                                SiteResultSystemSetting::insert([
                                    'academic_group_id' => $value['academic_group_id'],
                                    'academic_year_id' => $transfer_academic_year_id,
                                    'academic_version_id' => $value['academic_version_id'],
                                    'academic_shift_id' => $value['academic_shift_id'],
                                    'academic_class_id' => $value['academic_class_id'],
                                    'academic_department_id' => $value['academic_department_id'],
                                    'academic_session_id' => $vvl['new_session_id'],
                                    'academic_result_system_id' => $value['academic_result_system_id'],
                                    'number_from' => $value['number_from'],
                                    'number_to' => $value['number_to'],
                                    'point' => $value['point'],
                                    'point_from' => $value['point_to'],
                                    'site_id' => $value['site_id'],
                                    'status' => 1,
                                ]);
                                $get_last_data = SiteResultSystemSetting::where('site_id', $value['site_id'])->where('status', 1)->orderBy('id','DESC')->first();
                                SiteAcademicSettingReplicationHistory::insert([
                                    'from_academic_year_id' => $present_academic_year_id,
                                    'to_academic_year_id' => $transfer_academic_year_id,
                                    'replicated_table_row_id' => $get_last_data->id,
                                    'setting_id' => $request['id'],
                                    'created_by' => Auth::user()->id,
                                    'site_id' => $value['site_id'],
                                    'academic_group_id' => $value['academic_group_id'],
                                    'status' => 1,
                                ]);


                            }
                        }

                        if(!$value['academic_session_id']){

                            SiteResultSystemSetting::insert([
                                'academic_group_id' => $value['academic_group_id'],
                                'academic_year_id' => $transfer_academic_year_id,
                                'academic_version_id' => $value['academic_version_id'],
                                'academic_shift_id' => $value['academic_shift_id'],
                                'academic_class_id' => $value['academic_class_id'],
                                'academic_department_id' => $value['academic_department_id'],
                                'academic_session_id' => $value['academic_session_id'],
                                'academic_result_system_id' => $value['academic_result_system_id'],
                                'number_from' => $value['number_from'],
                                'number_to' => $value['number_to'],
                                'point' => $value['point'],
                                'point_from' => $value['point_to'],
                                'site_id' => $value['site_id'],
                                'status' => 1,
                            ]);
                            $get_last_data = SiteResultSystemSetting::where('site_id', $value['site_id'])->where('status', 1)->orderBy('id','DESC')->first();
                            SiteAcademicSettingReplicationHistory::insert([
                                'from_academic_year_id' => $present_academic_year_id,
                                'to_academic_year_id' => $transfer_academic_year_id,
                                'replicated_table_row_id' => $get_last_data->id,
                                'setting_id' => $request['id'],
                                'created_by' => Auth::user()->id,
                                'site_id' => $value['site_id'],
                                'academic_group_id' => $value['academic_group_id'],
                                'status' => 1,
                            ]);


                        }
                    }


                }

            }


    }

    public function replicateSiteResultPrimarySetting($request, $session_selective_data, $present_academic_year_id, $transfer_academic_year_id, $replicable_data)
    {
        $session_ids_check = [];
        if(count($session_selective_data)){
            foreach ($session_selective_data as $kk => $vv){
                if($vv['select_session_status'] && $vv['id'] && $vv['new_session_id']){
                    if($vv['id'] == $vv['new_session_id']){
                        throw new Error('Sorry, sessions are same!');

                    }
                    $check_session_if_exist = StudentHistory::where('academic_session_id', $vv['new_session_id'])->first();
                    if($check_session_if_exist){
                        throw new Error('Sorry, session already present!');

                    }
                    $session_ids_check[$kk]['present_session_id'] = $vv['id'];
                    $session_ids_check[$kk]['new_session_id'] = $vv['new_session_id'];
                }

            }
            if(!$session_ids_check){
                throw new Error('Please, select session!');

            }

        }

        foreach ($replicable_data as $key => $value){


            if(!$session_selective_data){
                if($value['academic_session_id']){
                    return $session_check = 1;
                }else{

                    SiteResultPrimarySetting::insert([
                        'academic_group_id' => $value['academic_group_id'],
                        'academic_year_id' => $transfer_academic_year_id,
                        'academic_version_id' => $value['academic_version_id'],
                        'academic_shift_id' => $value['academic_shift_id'],
                        'academic_class_id' => $value['academic_class_id'],
                        'academic_department_id' => $value['academic_department_id'],
                        'academic_session_id' => $value['academic_session_id'],
                        'academic_result_primary_type_id' => $value['academic_result_primary_type_id'],
                        'academic_class_group_id' => $value['academic_class_group_id'],
                        'examination_id' => $value['examination_id'],
                        'show_position' => $value['show_position'],
                        'marks_percentage' => $value['marks_percentage'],
                        'is_average' => $value['is_average'],
                        'how_many_subject_fail_allow' => $value['how_many_subject_fail_allow'],
                        'site_id' => $value['site_id'],
                        'status' => 1,
                    ]);
                    $get_last_data = SiteResultPrimarySetting::where('site_id', $value['site_id'])->where('status', 1)->orderBy('id','DESC')->first();
                    SiteAcademicSettingReplicationHistory::insert([
                        'from_academic_year_id' => $present_academic_year_id,
                        'to_academic_year_id' => $transfer_academic_year_id,
                        'replicated_table_row_id' => $get_last_data->id,
                        'setting_id' => $request['id'],
                        'created_by' => Auth::user()->id,
                        'site_id' => $value['site_id'],
                        'academic_group_id' => $value['academic_group_id'],
                        'status' => 1,
                    ]);

                }
            }else{

                if (count($session_ids_check)){
                    foreach ($session_ids_check as $kky => $vvl){
//                            return $vvl['present_session_id'];
                        if($value['academic_session_id']==$vvl['present_session_id']){


                            SiteResultPrimarySetting::insert([
                                'academic_group_id' => $value['academic_group_id'],
                                'academic_year_id' => $transfer_academic_year_id,
                                'academic_version_id' => $value['academic_version_id'],
                                'academic_shift_id' => $value['academic_shift_id'],
                                'academic_class_id' => $value['academic_class_id'],
                                'academic_department_id' => $value['academic_department_id'],
                                'academic_session_id' => $vvl['new_session_id'],
                                'academic_result_primary_type_id' => $value['academic_result_primary_type_id'],
                                'academic_class_group_id' => $value['academic_class_group_id'],
                                'examination_id' => $value['examination_id'],
                                'show_position' => $value['show_position'],
                                'marks_percentage' => $value['marks_percentage'],
                                'is_average' => $value['is_average'],
                                'how_many_subject_fail_allow' => $value['how_many_subject_fail_allow'],
                                'site_id' => $value['site_id'],
                                'status' => 1,
                            ]);
                            $get_last_data = SiteResultPrimarySetting::where('site_id', $value['site_id'])->where('status', 1)->orderBy('id','DESC')->first();
                            SiteAcademicSettingReplicationHistory::insert([
                                'from_academic_year_id' => $present_academic_year_id,
                                'to_academic_year_id' => $transfer_academic_year_id,
                                'replicated_table_row_id' => $get_last_data->id,
                                'setting_id' => $request['id'],
                                'created_by' => Auth::user()->id,
                                'site_id' => $value['site_id'],
                                'academic_group_id' => $value['academic_group_id'],
                                'status' => 1,
                            ]);

                        }
                    }

                    if(!$value['academic_session_id']){


                        SiteResultPrimarySetting::insert([
                            'academic_group_id' => $value['academic_group_id'],
                            'academic_year_id' => $transfer_academic_year_id,
                            'academic_version_id' => $value['academic_version_id'],
                            'academic_shift_id' => $value['academic_shift_id'],
                            'academic_class_id' => $value['academic_class_id'],
                            'academic_department_id' => $value['academic_department_id'],
                            'academic_session_id' => $value['academic_session_id'],
                            'academic_result_primary_type_id' => $value['academic_result_primary_type_id'],
                            'academic_class_group_id' => $value['academic_class_group_id'],
                            'examination_id' => $value['examination_id'],
                            'show_position' => $value['show_position'],
                            'marks_percentage' => $value['marks_percentage'],
                            'is_average' => $value['is_average'],
                            'how_many_subject_fail_allow' => $value['how_many_subject_fail_allow'],
                            'site_id' => $value['site_id'],
                            'status' => 1,
                        ]);
                        $get_last_data = SiteResultPrimarySetting::where('site_id', $value['site_id'])->where('status', 1)->orderBy('id','DESC')->first();
                        SiteAcademicSettingReplicationHistory::insert([
                            'from_academic_year_id' => $present_academic_year_id,
                            'to_academic_year_id' => $transfer_academic_year_id,
                            'replicated_table_row_id' => $get_last_data->id,
                            'setting_id' => $request['id'],
                            'created_by' => Auth::user()->id,
                            'site_id' => $value['site_id'],
                            'academic_group_id' => $value['academic_group_id'],
                            'status' => 1,
                        ]);

                    }
                }


            }

        }

    }

    public function replicateSiteResultCombineSetting($request, $session_selective_data, $present_academic_year_id, $transfer_academic_year_id, $replicable_data)
    {

        $session_ids_check = [];
        if(count($session_selective_data)){
            foreach ($session_selective_data as $kk => $vv){
                if($vv['select_session_status'] && $vv['id'] && $vv['new_session_id']){
                    if($vv['id'] == $vv['new_session_id']){
                        throw new Error('Sorry, sessions are same!');

                    }
                    $check_session_if_exist = StudentHistory::where('academic_session_id', $vv['new_session_id'])->first();
                    if($check_session_if_exist){
                        throw new Error('Sorry, session already present!');

                    }
                    $session_ids_check[$kk]['present_session_id'] = $vv['id'];
                    $session_ids_check[$kk]['new_session_id'] = $vv['new_session_id'];
                }

            }
            if(!$session_ids_check){
                throw new Error('Please, select session!');

            }

        }

        foreach ($replicable_data as $key => $value){


            if(!$session_selective_data){
                if($value['academic_session_id']){
                    return $session_check = 1;
                }else{

                    SiteResultCombineSetting::insert([
                        'academic_group_id' => $value['academic_group_id'],
                        'academic_year_id' => $transfer_academic_year_id,
                        'academic_version_id' => $value['academic_version_id'],
                        'academic_shift_id' => $value['academic_shift_id'],
                        'academic_class_id' => $value['academic_class_id'],
                        'academic_department_id' => $value['academic_department_id'],
                        'academic_session_id' => $value['academic_session_id'],
                        'academic_class_group_id' => $value['academic_class_group_id'],
                        'result_academic_class_ids' => $value['result_academic_class_ids'],
                        'academic_result_combine_type_id' => $value['academic_result_combine_type_id'],
                        'academic_result_primary_type_id' => $value['academic_result_primary_type_id'],
                        'show_position' => $value['show_position'],
                        'marks_percentage' => $value['marks_percentage'],
                        'is_average' => $value['is_average'],
                        'fail_allow' => $value['fail_allow'],
                        'site_id' => $value['site_id'],
                        'status' => 1,
                    ]);
                    $get_last_data = SiteResultCombineSetting::where('site_id', $value['site_id'])->where('status', 1)->orderBy('id','DESC')->first();
                    SiteAcademicSettingReplicationHistory::insert([
                        'from_academic_year_id' => $present_academic_year_id,
                        'to_academic_year_id' => $transfer_academic_year_id,
                        'replicated_table_row_id' => $get_last_data->id,
                        'setting_id' => $request['id'],
                        'created_by' => Auth::user()->id,
                        'site_id' => $value['site_id'],
                        'academic_group_id' => $value['academic_group_id'],
                        'status' => 1,
                    ]);

                }
            }else{

                if (count($session_ids_check)){
                    foreach ($session_ids_check as $kky => $vvl){
//                            return $vvl['present_session_id'];
                        if($value['academic_session_id']==$vvl['present_session_id']){

                            SiteResultCombineSetting::insert([
                                'academic_group_id' => $value['academic_group_id'],
                                'academic_year_id' => $transfer_academic_year_id,
                                'academic_version_id' => $value['academic_version_id'],
                                'academic_shift_id' => $value['academic_shift_id'],
                                'academic_class_id' => $value['academic_class_id'],
                                'academic_department_id' => $value['academic_department_id'],
                                'academic_session_id' => $vvl['new_session_id'],
                                'academic_class_group_id' => $value['academic_class_group_id'],
                                'result_academic_class_ids' => $value['result_academic_class_ids'],
                                'academic_result_combine_type_id' => $value['academic_result_combine_type_id'],
                                'academic_result_primary_type_id' => $value['academic_result_primary_type_id'],
                                'show_position' => $value['show_position'],
                                'marks_percentage' => $value['marks_percentage'],
                                'is_average' => $value['is_average'],
                                'fail_allow' => $value['fail_allow'],
                                'site_id' => $value['site_id'],
                                'status' => 1,
                            ]);
                            $get_last_data = SiteResultCombineSetting::where('site_id', $value['site_id'])->where('status', 1)->orderBy('id','DESC')->first();
                            SiteAcademicSettingReplicationHistory::insert([
                                'from_academic_year_id' => $present_academic_year_id,
                                'to_academic_year_id' => $transfer_academic_year_id,
                                'replicated_table_row_id' => $get_last_data->id,
                                'setting_id' => $request['id'],
                                'created_by' => Auth::user()->id,
                                'site_id' => $value['site_id'],
                                'academic_group_id' => $value['academic_group_id'],
                                'status' => 1,
                            ]);

                        }
                    }

                    if(!$value['academic_session_id']){

                        SiteResultCombineSetting::insert([
                            'academic_group_id' => $value['academic_group_id'],
                            'academic_year_id' => $transfer_academic_year_id,
                            'academic_version_id' => $value['academic_version_id'],
                            'academic_shift_id' => $value['academic_shift_id'],
                            'academic_class_id' => $value['academic_class_id'],
                            'academic_department_id' => $value['academic_department_id'],
                            'academic_session_id' => $value['academic_session_id'],
                            'academic_class_group_id' => $value['academic_class_group_id'],
                            'result_academic_class_ids' => $value['result_academic_class_ids'],
                            'academic_result_combine_type_id' => $value['academic_result_combine_type_id'],
                            'academic_result_primary_type_id' => $value['academic_result_primary_type_id'],
                            'show_position' => $value['show_position'],
                            'marks_percentage' => $value['marks_percentage'],
                            'is_average' => $value['is_average'],
                            'fail_allow' => $value['fail_allow'],
                            'site_id' => $value['site_id'],
                            'status' => 1,
                        ]);
                        $get_last_data = SiteResultCombineSetting::where('site_id', $value['site_id'])->where('status', 1)->orderBy('id','DESC')->first();
                        SiteAcademicSettingReplicationHistory::insert([
                            'from_academic_year_id' => $present_academic_year_id,
                            'to_academic_year_id' => $transfer_academic_year_id,
                            'replicated_table_row_id' => $get_last_data->id,
                            'setting_id' => $request['id'],
                            'created_by' => Auth::user()->id,
                            'site_id' => $value['site_id'],
                            'academic_group_id' => $value['academic_group_id'],
                            'status' => 1,
                        ]);

                    }
                }


            }

        }

    }

    public function replicateSiteStudentFeeFineAllocationSetting($request, $session_selective_data, $present_academic_year_id, $transfer_academic_year_id, $replicable_data)
    {
//        return $academic_session_id;
//        return $session_check = 1;
//        return $request['id'];

//        return $session_check = 0;
//        return Response::json(['message' => 'Data Save Successfully!', 'mode' => 'Saved!'], 200);
        $session_ids_check = [];
        if(count($session_selective_data)){
            foreach ($session_selective_data as $kk => $vv){
                if($vv['select_session_status'] && $vv['id'] && $vv['new_session_id']){
                    if($vv['id'] == $vv['new_session_id']){
                        throw new Error('Sorry, sessions are same!');

                    }
                    $check_session_if_exist = StudentHistory::where('academic_session_id', $vv['new_session_id'])->first();
                    if($check_session_if_exist){
                        throw new Error('Sorry, session already present!');

                    }
                    $session_ids_check[$kk]['present_session_id'] = $vv['id'];
                    $session_ids_check[$kk]['new_session_id'] = $vv['new_session_id'];
                }

            }
            if(!$session_ids_check){
                throw new Error('Please, select session!');

            }

        }
//return 'ok';
//        return $replicable_data;

        foreach ($replicable_data as $key => $value){
//            return $value['academic_session_id'];
            $session_check = 0;

            if(!$session_selective_data){
                if($value['academic_session_id']){
                    return $session_check = 1;
                }else{
                    SiteStudentFeeFineAllocation::insert([
                        'academic_fee_sub_head_id' => $value['academic_fee_sub_head_id'],
                        'academic_year_id' => $transfer_academic_year_id,
                        'academic_fee_head_id' => $value['academic_fee_head_id'],
                        'academic_fee_group_id' => $value['academic_fee_group_id'],
                        'academic_shift_id' => $value['academic_shift_id'],
                        'academic_session_id' => $value['academic_session_id'],
                        'academic_student_category_id' => $value['academic_student_category_id'],
                        'academic_student_type_id' => $value['academic_student_type_id'],
                        'academic_student_admission_type_id' => $value['academic_student_admission_type_id'],
                        'academic_department_id' => $value['academic_department_id'],
                        'academic_class_id' => $value['academic_class_id'],
                        'academic_section_id' => $value['academic_section_id'],
                        'academic_class_group_id' => $value['academic_class_group_id'],
                        'academic_subject_id' => $value['academic_subject_id'],
                        'academic_version_id' => $value['academic_version_id'],
                        'amount' => $value['amount'],
                        'site_id' => $value['site_id'],
                        'academic_group_id' => $value['academic_group_id'],
                        'status' => 1,
                    ]);

                    $get_last_data = SiteStudentFeeFineAllocation::where('site_id', $value['site_id'])->where('status', 1)->orderBy('id','DESC')->first();
                    SiteAcademicSettingReplicationHistory::insert([
                        'from_academic_year_id' => $present_academic_year_id,
                        'to_academic_year_id' => $transfer_academic_year_id,
                        'replicated_table_row_id' => $get_last_data->id,
                        'setting_id' => $request['id'],
                        'created_by' => Auth::user()->id,
                        'site_id' => $value['site_id'],
                        'academic_group_id' => $value['academic_group_id'],
                        'status' => 1,
                    ]);
                }
            }else{

                    if (count($session_ids_check)){
                        foreach ($session_ids_check as $kky => $vvl){
//                            return $vvl['present_session_id'];
                            if($value['academic_session_id']==$vvl['present_session_id']){
                                SiteStudentFeeFineAllocation::insert([
                                    'academic_fee_sub_head_id' => $value['academic_fee_sub_head_id'],
                                    'academic_year_id' => $transfer_academic_year_id,
                                    'academic_fee_head_id' => $value['academic_fee_head_id'],
                                    'academic_fee_group_id' => $value['academic_fee_group_id'],
                                    'academic_shift_id' => $value['academic_shift_id'],
                                    'academic_session_id' => $vvl['new_session_id'],
                                    'academic_student_category_id' => $value['academic_student_category_id'],
                                    'academic_student_type_id' => $value['academic_student_type_id'],
                                    'academic_student_admission_type_id' => $value['academic_student_admission_type_id'],
                                    'academic_department_id' => $value['academic_department_id'],
                                    'academic_class_id' => $value['academic_class_id'],
                                    'academic_section_id' => $value['academic_section_id'],
                                    'academic_class_group_id' => $value['academic_class_group_id'],
                                    'academic_subject_id' => $value['academic_subject_id'],
                                    'academic_version_id' => $value['academic_version_id'],
                                    'amount' => $value['amount'],
                                    'site_id' => $value['site_id'],
                                    'academic_group_id' => $value['academic_group_id'],
                                    'status' => 1,
                                ]);

                                $get_last_data = SiteStudentFeeFineAllocation::where('site_id', $value['site_id'])->where('status', 1)->orderBy('id','DESC')->first();
                                SiteAcademicSettingReplicationHistory::insert([
                                    'from_academic_year_id' => $present_academic_year_id,
                                    'to_academic_year_id' => $transfer_academic_year_id,
                                    'replicated_table_row_id' => $get_last_data->id,
                                    'setting_id' => $request['id'],
                                    'created_by' => Auth::user()->id,
                                    'site_id' => $value['site_id'],
                                    'academic_group_id' => $value['academic_group_id'],
                                    'status' => 1,
                                ]);

                            }
                        }

                        if(!$value['academic_session_id']){
                            SiteStudentFeeFineAllocation::insert([
                                'academic_fee_sub_head_id' => $value['academic_fee_sub_head_id'],
                                'academic_year_id' => $transfer_academic_year_id,
                                'academic_fee_head_id' => $value['academic_fee_head_id'],
                                'academic_fee_group_id' => $value['academic_fee_group_id'],
                                'academic_shift_id' => $value['academic_shift_id'],
                                'academic_session_id' => $value['academic_session_id'],
                                'academic_student_category_id' => $value['academic_student_category_id'],
                                'academic_student_type_id' => $value['academic_student_type_id'],
                                'academic_student_admission_type_id' => $value['academic_student_admission_type_id'],
                                'academic_department_id' => $value['academic_department_id'],
                                'academic_class_id' => $value['academic_class_id'],
                                'academic_section_id' => $value['academic_section_id'],
                                'academic_class_group_id' => $value['academic_class_group_id'],
                                'academic_subject_id' => $value['academic_subject_id'],
                                'academic_version_id' => $value['academic_version_id'],
                                'amount' => $value['amount'],
                                'site_id' => $value['site_id'],
                                'academic_group_id' => $value['academic_group_id'],
                                'status' => 1,
                            ]);

                            $get_last_data = SiteStudentFeeFineAllocation::where('site_id', $value['site_id'])->where('status', 1)->orderBy('id','DESC')->first();
                            SiteAcademicSettingReplicationHistory::insert([
                                'from_academic_year_id' => $present_academic_year_id,
                                'to_academic_year_id' => $transfer_academic_year_id,
                                'replicated_table_row_id' => $get_last_data->id,
                                'setting_id' => $request['id'],
                                'created_by' => Auth::user()->id,
                                'site_id' => $value['site_id'],
                                'academic_group_id' => $value['academic_group_id'],
                                'status' => 1,
                            ]);
                        }
                    }


            }


        }
        return Response::json(['message' => 'Data Save Successfully!', 'mode' => 'Saved!'], 200);

    }

    public function replicateTeacherClassSectionAssignSetting($request, $present_academic_year_id, $transfer_academic_year_id, $replicable_data)
    {


//        $session_ids_check = [];
//        if(count($session_selective_data)){
//            foreach ($session_selective_data as $kk => $vv){
//                if($vv['select_session_status'] && $vv['id'] && $vv['new_session_id']){
//                    if($vv['id'] == $vv['new_session_id']){
//                        throw new Error('Sorry, sessions are same!');
//
//                    }
//                    $check_session_if_exist = StudentHistory::where('academic_session_id', $vv['new_session_id'])->first();
//                    if($check_session_if_exist){
//                        throw new Error('Sorry, session already present!');
//
//                    }
//                    $session_ids_check[$kk]['present_session_id'] = $vv['id'];
//                    $session_ids_check[$kk]['new_session_id'] = $vv['new_session_id'];
//                }
//
//            }
//            if(!$session_ids_check){
//                throw new Error('Please, select session!');
//
//            }
//
//        }
//return 'ok';
//        return $replicable_data;

        foreach ($replicable_data as $key => $value){
//            return $value;
                    $table_institiate = new TeacherAssignToClassSection();
                    $table_institiate->create([
                        'employee_id' =>$value['employee_id'],
                        'academic_version_id' => $value['academic_version_id'],
                        'academic_year_id' => $transfer_academic_year_id,
                        'academic_shift_id' => $value['academic_shift_id'],
                        'academic_department_id' => $value['academic_department_id'],
                        'academic_class_id' => $value['academic_class_id'],
                        'academic_section_id' => $value['academic_section_id'],
                        'academic_class_group_id' => $value['academic_class_group_id'],
                        'assign_date' =>  Carbon::today(),
                        'assigned_by' => Auth::user()->id,
                        'site_id' => $value['site_id'],
                        'academic_group_id' => $value['academic_group_id'],
                        'status' => 1,

                    ]);


                    $get_last_data = TeacherAssignToClassSection::where('site_id', $value['site_id'])
                                                                    ->where('academic_class_group_id', $value['academic_class_group_id'])
                                                                    ->where('employee_id', $value['employee_id'])
                                                                    ->where('status', 1)->orderBy('id','DESC')->first();
                    $table_institiate_sasrh = new SiteAcademicSettingReplicationHistory();
                    $table_institiate_sasrh->create([
                        'from_academic_year_id' => $present_academic_year_id,
                        'to_academic_year_id' => $transfer_academic_year_id,
                        'replicated_table_row_id' => $get_last_data->id,
                        'setting_id' => $request['id'],
                        'created_by' => Auth::user()->id,
                        'site_id' => $value['site_id'],
                        'academic_group_id' => $value['academic_group_id'],
                        'status' => 1,
                    ]);


        }
        return Response::json(['message' => 'Data Save Successfully!', 'mode' => 'Saved!'], 200);

    }

    public function sessionListForReplication()
    {
        $student_history = StudentHistory::where('status', 1)->select('academic_session_id')
            ->groupBy('academic_session_id')
            ->get();
        if(count($student_history)){
            $ids = [];
            foreach ($student_history as $kk => $vv){
//                return $vv->academic_session_id;
                $ids[$kk] = $vv->academic_session_id;
            }
        }

        $site_info_setting_data = SiteInfoSetting::where('site_id', Session::get('SITE_ID'))->first();
        $exploded_session_list = explode(',', $site_info_setting_data->academic_session_ids);

        $all_session_list = AcademicSession::whereIn('id', $exploded_session_list)->get();

        $session_list = AcademicSession::whereIn('id', $ids)->get();


        if(count($session_list)){
            $data_list = [];
            foreach ($session_list as $key => $value){
                $data_list[$key]['id'] = $value->id;
                $data_list[$key]['new_session_id'] = 0;
                $data_list[$key]['select_session_status'] = false;
                $data_list[$key]['name'] = $value->session_name;
                $data_list[$key]['array_session_data_list'] = $all_session_list;
            }
            return $data_list;

        }
        throw new Error('Sorry! session not found!');



    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
