<?php

namespace App\Http\Controllers\Site;

use App\Models\EmployeeGrade\EmpGrade;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;

use App\Models\Academic\AcademicFiscalYear;
use App\Models\Academic\AcademicGroup;
use App\Models\Academic\AcademicLeaveCategory;
use App\Models\Academic\AcademicLeaveType;
use App\Models\Academic\AcademicPeriodType;
use App\Models\Academic\AcademicResidence;

use App\Models\Academic\AcademicStudentQuata;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicSubjectClassExamCondition;
use App\Models\Academic\AcademicTransport;
use App\Models\Academic\AcademicVersion;
use App\Models\Academic\AcademicWaiverType;
use App\Models\Academic\SubjectCondition;
use App\Models\AcademicYear\AcademicYear;
use App\Models\ClassGroup\ClassGroup;
use App\Models\Country\Country;
use App\Models\Designation\Designation;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Examinations\Examination;
use App\Models\Gender\Gender;
use App\Models\Image\Photo;
use App\Models\Menu\Menu;
use App\Http\Requests;
use App\Models\Edu\DashboardPalette\DashboardPalette;
use App\Models\House\House;
use App\Models\Religion\Religion;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Site\Role\GlobalSiteRole;
use App\Models\Site\SiteGroupSetting;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Traits\Site\SiteInfoTrait;
use App\Traits\SubDomainCreationTrait;
use Auth;
use Error;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Log;
use Illuminate\Validation\ValidationException;
use Image;
use Intervention\Image\Facades\Image as InterImage;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;
use Mail;
use Response;

class SiteController extends ProjectController
{
    use SubDomainCreationTrait, Lang, FormControll, SiteInfoTrait;

    private $siteInfo;
    private $siteInfoSetting;
    private $newlyCreatedSite;

    public function __construct(SiteInfo $siteInfo, GlobalSiteInfoSetting $siteInfoSetting)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->siteInfo = $siteInfo;
        $this->siteInfoSetting = $siteInfoSetting;
    }


    public function getSiteGroupSiteList()
    {
        $site_info =  SiteInfo::where('id', session()->get('SITE_ID'))->first();
        $global_site_infos = GlobalSiteInfo::where('site_group_id', $site_info->site_group_id)
            ->get()
            ->transform(function ($site_info) {
                return [
                    'id' => $site_info->id,
                    'site_name' => $site_info->site_name
                ];
            });
        return $global_site_infos;
    }

    public function getSites()
    {
        try {
            return SiteInfo::all();
        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'Site Info Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }


    public function getDashboardPalette()
    {
        try {
            return DashboardPalette::oderBy('kye_id', 'DESC')->all()->get();
        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'Site Info Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }





    /**
     * Display a listing of the resource.
     *
     * @return JsonResponse
     */
    public function getSiteListBySiteGroup($id)
    {
        try {


            return SiteInfo::where('site_group_id', $id)->get();
        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'Site Group Id Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    /**
     * Display a listing of the Academic Group.
     *
     * @return JsonResponse
     */
    public function getAcademicGroupList()
    {
        try {
            $siteAcademicGroupIds = GlobalSiteInfoSetting::where('site_id', Session::get('SITE_ID'))
                ->pluck('academic_group_id');

            $academicGroup = AcademicGroup::whereIn('id', $siteAcademicGroupIds)->get();

            return $academicGroup;


            //
            //            return SiteInfo::findOrFail(Session::get(SITE_ID));


        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }


    /**
     * Display a listing of the resource.
     *
     * @return JsonResponse
     */
    public function getLoggedInUserSiteInfo()
    {
        try {
            return SiteInfo::findOrFail(Session::get(SITE_ID));
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function showCalendar()
    {


        $viewType = 'Calendar View';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.site.employee.calendar.calendar-view', compact('viewType'));
    }



    public function getSiteVersionYearShiftList()
    {

        $siteGroupVersion = GlobalSiteShiftClassGroupSectionSetting::with(['academicVersion'])
            ->where('site_id', Session::get('SITE_ID'))
            ->select('academic_version_id')
            ->distinct('academic_version_id')
            ->get();


        $siteGroupYear = GlobalSiteShiftClassGroupSectionSetting::with(['academicYear'])
            ->where('site_id', Session::get('SITE_ID'))
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->distinct('academic_year_id')->distinct('academic_year_id')
            ->select('academic_year_id')
            ->orderBy('id', 'DESC')
            ->get();


        $siteGroupShift = GlobalSiteShiftClassGroupSectionSetting::with(['academicShift'])
            ->where('site_id', Session::get('SITE_ID'))
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->distinct('academic_shift_id')
            ->select('academic_shift_id')
            ->get();


        return [$siteGroupVersion, $siteGroupYear, $siteGroupShift];
    }

    public function getGlobalSiteVersionYearShiftList()
    {

        $siteGroupVersion = GlobalSiteShiftClassGroupSectionSetting::with(['academicVersion'])
            ->where('site_id', Session::get('SITE_ID'))
            ->select('academic_version_id')
            ->distinct('academic_version_id')
            ->get();


        $siteGroupYear = GlobalSiteShiftClassGroupSectionSetting::with(['academicYear'])
            ->where('site_id', Session::get('SITE_ID'))
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->distinct('academic_year_id')->distinct('academic_year_id')
            ->select('academic_year_id')
            ->orderBy('id', 'DESC')
            ->get();


        $siteGroupShift = GlobalSiteShiftClassGroupSectionSetting::with(['academicShift'])
            ->where('site_id', Session::get('SITE_ID'))
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->distinct('academic_shift_id')
            ->select('academic_shift_id')
            ->get();


        return [$siteGroupVersion, $siteGroupYear, $siteGroupShift];
    }


    public function getPresentSiteInfoDetailData($id)
    {
        try {
            $siteDetail = SiteInfo::where('id', $id)->get();

            return $siteDetail;
        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'Present Site Info Details Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    /**
     * @param Request $validatedRequest
     * @return mixed
     */
    public function createSiteInfo(Request $request)
    {
        //  dd('tests');

        try {


            $existSiteInfo = $request->site_info_id ? $this->siteInfo->findOrFail($request->site_info_id) : null;
            $recentlyCreatedSite = [];
            if (!$request->site_info_id) {
                $recentlyCreatedSite = SiteInfo::where('site_alias', $request->site_alias)
                    ->first();
            }


            if ($existSiteInfo != null) { //update
                $this->validate($request, [
                    "site_membership_id" => "required",
                    "site_group_id" => "required",
                    "site_group_setting_id" => "required",
                    "academic_group_id" => "required",
                    "site_name" => "required",
                    "academic_class_ids" => "required",
                    "academic_period_type_ids" => "required",
                    "academic_subject_ids" => "required",
                    "academic_subject_condition_ids" => "required",
                    "shift_ids" => "required",
                    "gender_ids" => "required",
                    "country_id" => "required",
                    "division_id" => "required",
                    "district_id" => "required",
                    "thana_id" => "required",
                    "address" => "required",
                    "designation_ids" => "required",
                    "site_alias" => 'required|unique:site_infos,site_alias,' . $request->site_info_id . ',id|unique:site_groups,group_alias',
                    "site_email" => "required|unique:site_infos,site_email," . $request->site_info_id . ',id',
                    "site_phone" => "required",

                ]);


                //Shift Ids Create for Site Info Table
                $getSiteShift = SiteInfo::select('id', 'shift_ids')
                    ->where('site_alias', $request->site_alias)
                    ->first();

                $getSiteSettingShift = GlobalSiteInfoSetting::select('shift_ids')
                    ->where('site_id', $getSiteShift->id)
                    ->get();

                $shift_idsDetail = array_map(function ($element) {
                    return $element['shift_ids'];
                }, $getSiteSettingShift->toArray());
                $onlyPresentShiftIds = implode(", ", $shift_idsDetail);


                if ($getSiteShift) {
                    $previousShiftIds = array_map('intval', explode(',', $onlyPresentShiftIds));
                    $recentShiftIDs = $request->shift_ids;

                    $presentShiftIDs = array_unique(array_merge($previousShiftIds, $recentShiftIDs));
                } //End

                //                Log::info($request);

                if (isset($existSiteInfo->ownfields)) {

                    foreach ($existSiteInfo->ownfields as $ownField) {
                        if ($request->{$ownField}) {
                            if (is_array($request->{$ownField})) {
                                $existSiteInfo->{$ownField} = implode(',', $request->{$ownField});
                            } else {
                                $existSiteInfo->{$ownField} = $request->{$ownField};
                            }
                        }
                    }
                    $existSiteInfo->status = $request->status;
                }
                foreach ($existSiteInfo->translatedAttributes as $field) {
                    $existSiteInfo->{$field} = $request->get($field);
                }

                //image save

                if ($request->site_logo == "demo_logo.jpg") {
                    $existSiteInfo->site_logo = $request->site_logo;
                } elseif (strpos($request->site_logo, 'base64') || $existSiteInfo->site_logo != $request->site_logo) {

                    //delete logo first

                    $path = public_path('img/site/' . $existSiteInfo->site_logo);
                    if (file_exists($path) && $existSiteInfo->site_logo != "demo_logo.jpg") {
                        @unlink($path);
                    }

                    $name = $existSiteInfo->site_alias . '.' . explode('/', explode(':', substr($request->site_logo, 0, strpos($request->site_logo, ';')))[1])[1];
                    Image::make($request->site_logo)->resize(440, 442)->save(public_path('img/site/') . $name);
                    $request->merge(['site_logo' => $name]);
                    $existSiteInfo->site_logo = $name;
                }

                if ($existSiteInfo->save()) {
                    // $this->clearDatabaseSessionForSiteUsers($existSiteInfo->id);

                    $academicGroupPresentOrNot = GlobalSiteInfoSetting::where('site_id', $request->site_info_id)
                        ->where('academic_group_id', $request->academic_group_id)
                        ->first();


                    if ($academicGroupPresentOrNot) {

                        if (isset($academicGroupPresentOrNot->ownfields)) {
                            foreach ($academicGroupPresentOrNot->ownfields as $ownField) {


                                if (is_array($request->{$ownField})) {
                                    //     Log::info($request);

                                    $academicGroupPresentOrNot->{$ownField} = implode(',', $request->{$ownField});
                                } else {
                                    $academicGroupPresentOrNot->{$ownField} = $request->{$ownField};
                                }
                                $academicGroupPresentOrNot->status = 1;
                                $academicGroupPresentOrNot->site_id = $request->site_info_id;
                            }
                        }
                        $academicGroupPresentOrNot->save();
                    } else {
                        $this->dataSavetoGlobalSiteInfoSetting($request->site_info_id, $request);
                    }

                    /*   $url = config('app.url');
                       $parsedUrl = parse_url($url);
                       $sub_domain = $parsedUrl['scheme'] . '://' . $existSiteInfo->site_alias . '.' . $parsedUrl['host'];
                       $data = [
                           'username' => '',
                           'sub_domain' => $sub_domain,
                           'password' => '',
                           'message' => 'Site Successfully Updated!',
                           'user_id' => Auth::user()->username
                       ];
                       $subject = "Site  Info Update";
                       Mail::to([$existSiteInfo->site_email, 'eduworlderp@gmail.com'])->send(new SendMailToUserWithQueue($subject, $data));*/


                    return Response::json(['message' => 'Site information Updated Successfully!', 'mode' => 'Update!'], 200);
                }
            } else if ($recentlyCreatedSite) { //new site other academic group insert


                //throw new Error('Alias Already Existed');


                //Shift Ids Create for Site Info Table
                $getSiteShift = SiteInfo::select('id', 'shift_ids')
                    ->where('site_alias', $request->site_alias)
                    ->first();


                $getSiteSettingShift = GlobalSiteInfoSetting::select('shift_ids')
                    ->where('site_id', $getSiteShift->id)
                    ->get();

                $shift_idsDetail = array_map(function ($element) {
                    return $element['shift_ids'];
                }, $getSiteSettingShift->toArray());
                $onlyPresentShiftIds = implode(", ", $shift_idsDetail);

                $presentShiftIDs = [];
                if ($getSiteShift) {
                    $previousShiftIds = array_map('intval', explode(',', $onlyPresentShiftIds));
                    $recentShiftIDs = $request->shift_ids;
                    $presentShiftIDs = array_unique(array_merge($previousShiftIds, $recentShiftIDs));
                }


                $getSiteShift->shift_ids = implode(',', $presentShiftIDs);
                $getSiteShift->save();


                //First Time Second Save
                $academicGroupPresentOrNot = GlobalSiteInfoSetting::where('site_id', $recentlyCreatedSite->id)
                    ->where('academic_group_id', $request->academic_group_id)
                    ->first();


                if ($academicGroupPresentOrNot) {
                    if (isset($academicGroupPresentOrNot->ownfields)) {
                        foreach ($academicGroupPresentOrNot->ownfields as $ownField) {
                            if (is_array($request->{$ownField})) {
                                $academicGroupPresentOrNot->{$ownField} = implode(',', $request->{$ownField});
                            } else {
                                $academicGroupPresentOrNot->{$ownField} = $request->{$ownField};
                            }
                            $academicGroupPresentOrNot->status = 1;
                            $academicGroupPresentOrNot->site_id = $recentlyCreatedSite->id;
                        }
                    }
                    return Response::json(['message' => 'Site information Updated Successfully!', 'mode' => 'update'], 200);
                } else {
                    $this->dataSavetoGlobalSiteInfoSetting($recentlyCreatedSite->id, $request);
                }
            } else { //new site
                //  throw new Error('new site');


                $this->validate($request, [
                    "site_group_id" => "required",
                    "site_group_setting_id" => "required",
                    "academic_group_id" => "required",
                    "site_name" => "required",
                    "academic_class_ids" => "required",
                    "academic_subject_ids" => "required",
                    "academic_subject_condition_ids" => "required",
                    "designation_ids" => "required",
                    "shift_ids" => "required",
                    "gender_ids" => "required",
                    "country_id" => "required",
                    "division_id" => "required",
                    "district_id" => "required",
                    "thana_id" => "required",
                    "address" => "required",
                    "admin_first_name" => "required",
                    "admin_last_name" => "required",
                    "site_alias" => 'required|unique:site_infos,site_alias|unique:site_groups,group_alias',
                    "site_email" => "required|unique:site_infos",
                    "site_phone" => "required",

                ]);


                $allSiteInfo = $this->siteInfo;
                //image save
                if ($request->site_logo == "demo_logo.jpg") {
                    $allSiteInfo->site_logo = $request->site_logo;
                } else {

                    $name = $request->site_alias . '.' . explode('/', explode(':', substr($request->site_logo, 0, strpos($request->site_logo, ';')))[1])[1];
                    Image::make($request->site_logo)->resize(440, 442)->save(public_path('img/site/') . $name);
                    $request->merge(['site_logo' => $name]);
                    $allSiteInfo->site_logo = $name;
                }

                $newlyCreatedSite = $this->ownFieldsToSave($allSiteInfo, $request);


                $this->translatedAttrToSave($newlyCreatedSite, $request);
                $this->clearDatabaseSessionForSiteUsers($newlyCreatedSite->id);

                $this->dataSavetoGlobalSiteInfoSetting($newlyCreatedSite->id, $request);


                if ($newlyCreatedSite) {
                    //$this->createSubDomain($request->site_alias);

                    if ($this->createRolesForSite($newlyCreatedSite)) {
                        if ($this->createAdminUser($newlyCreatedSite, $request)) {
                            return Response::json(['message' => 'Site information Save Successfully with all!', 'mode' => 'Saved!'], 200);
                        } else {
                            return Response::json(['message' => 'Site information Save Successfully without creating admin user!', 'mode' => 'Saved!'], 200);
                        }
                    } else {
                        return Response::json(['message' => 'Site information Save Successfully Without creating role!', 'mode' => 'Saved!'], 200);
                    }
                }
                return Response::json(['message' => 'Site information Save Successfully Without creating role!', 'mode' => 'Saved!'], 200);
            }

            throw new Error('Something went wrong!');
        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }
    }












    private function savePhoto(SiteInfo $siteInfo, Requests\Validator $validatedRequest)
    {
        try {
            if ($validatedRequest->photo) {
                $image = $validatedRequest->file('photo');
                $this->imageUpload($image, $siteInfo);
            }
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    private function imageUpload($image, SiteInfo $newlyCreatedSite)
    {

        $this->fileName = time() . str_random(3) . $image->getClientOriginalName();
        InterImage::make($image->getRealPath())->resize(200, 200)->save('uploads/' . $this->fileName);
        $photo = new Photo();
        $photo->name = $this->fileName;
        $photo->user_id = $newlyCreatedSite->id;
        $newlyCreatedSite->photo()->save($photo);
    }

    public function editSiteInfoForm($id)
    {
        $viewType = 'Edit Institution Info';

        $siteToEdit = $this->editFormModel($this->siteInfo->findOrFail($id));

        return view('default.admin.sites.edit', compact('siteToEdit', 'viewType'));
    }

    public function editSiteInfo($id, Requests\Validator $validatedRequest)
    {

        $siteToEdit = $this->siteInfo->findOrFail($id);

        foreach ($siteToEdit->translatedAttributes as $field) {
            foreach (config('app.locales') as $locale => $value) {
                if ($validatedRequest->get($field . '_' . $locale)) {
                    $siteToEdit->translateOrNew($locale)->{$field} = $validatedRequest->get($field . '_' . $locale);
                }
            }
        }

        $siteToEdit->site_membership_id = $validatedRequest->get('site_membership_id');
        $siteToEdit->site_group_id = $validatedRequest->get('site_group_id');
        $siteToEdit->site_alias = $validatedRequest->get('site_alias');
        $siteToEdit->site_email = $validatedRequest->get('site_email');
        $siteToEdit->site_phone = $validatedRequest->get('site_phone');
        $siteToEdit->status = $validatedRequest->get('status');

        if ($siteToEdit->save()) {

            $this->savePhoto(
                $siteToEdit,
                $validatedRequest
            );
        }

        return back()->withSuccess('Successfully Updated');
    }

    public function deleteSiteInfo($id)
    {
        $siteToDelete = $this->siteInfo->findOrFail($id);

        if ($siteToDelete->delete()) {

            return back()->withSuccess('Successfully Deleted');
        }
    }

    public function viewSiteInfo($id)
    {
        $logo = '';
        $siteToView = $this->siteInfo->findOrFail($id);

        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();

        if (!$siteToView->photo->isEmpty()) {
            $logo = $siteToView->photo->last()->name;
        }


        return view('default.admin.sites.view', compact('siteToView', 'locale', 'defaultLocale', 'logo'));
    }


    public function getModuleAccessTable(Request $request, Menu $menuModel, SiteInfo $siteInfo)
    {
        $siteId = $request->siteId;
        $siteToAssign = $siteInfo->findOrFail($siteId);
        $getSiteAccess = $siteToAssign->menus()->pluck('menu_id')->toArray();
        $menus = $menuModel->where('is_common_access', false)->where('parent_id', 0)->where('is_displayable', 1)->get();

        if (request()->ajax()) {
            return view('default.admin.sites.group-access', compact('siteId', 'menuModel', 'menus', 'siteToAssign', 'getSiteAccess'));
        }
    }


    public function assignModuleAccess(Request $request, SiteInfo $siteInfo, SiteAccess $siteAccess)
    {

        $siteId = $request->access_site_id;
        $menuId = $request->access_menu_id;
        $siteAcc = $siteInfo->findOrFail($siteId);
        $insertedRow = $siteAccess->whereMenuId($menuId)->whereSiteId($siteId)->first();

        if (file_exists(base_path("resources/views/default/admin/layouts/sidebars/" . $siteAcc->site_alias))) {
            deleteDir((base_path("resources/views/default/admin/layouts/sidebars/" . $siteAcc->site_alias)));
        }

        if (is_null($insertedRow)) {
            $siteAcc->menus()->attach($menuId);
            $siteAcc->save();
            /*  $siteAccess->create([
                  'menu_id'=>$menuId,
                  'site_id'=>$siteId
              ]);*/
            $this->assignPermissionToAdmin($siteId);
            return response()->json(['success' => 'Module Assigned Successfully! ' . $menuId]);
        } else {
            $insertedRow->delete();
            $this->matchNewAccess($siteId);
            return response()->json(['success' => 'Module Removed Successfully!']);
        }
    }


    public function matchNewAccess($siteId)
    {
        $site = SiteInfo::findOrFail($siteId);
        $getSiteAccess = $site->menus()->pluck('menu_id')->toArray();
        $getGroupAccess = DB::table('group_accesses')->whereSiteId($siteId)->distinct('menu_id')->select('menu_id')->get();
        $willDeletedMenus = [];

        foreach ($getGroupAccess as $acces) {

            if (in_array($acces->menu_id, $getSiteAccess)) {
            } else {
                $willDeletedMenus[] = $acces->menu_id;
            }
        }
        DB::table('group_accesses')->whereIn('menu_id', $willDeletedMenus)->whereSiteId($siteId)->delete();
    }


    public function assignPermissionToAdmin($siteId)
    {

        $site = SiteInfo::findOrFail($siteId);
        $getSiteAccessibleMenu = $site->menus()->pluck('menu_id')->toArray();
        $roleId = GlobalSiteRole::where(['name' => 'admin', 'site_id' => $siteId])->first()->id;

        foreach ($getSiteAccessibleMenu as $menu_id) {
            $childMenus = Menu::whereParentId($menu_id)->pluck('id')->toArray();
            if (count($childMenus) > 0) { //assign child menu too
                foreach ($childMenus as $child) {
                    $hasChildAccess = DB::table('group_accesses')->where(['role_id' => $roleId, 'site_id' => $siteId, 'menu_id' => $child])->first();
                    if (!$hasChildAccess) {
                        DB::table('group_accesses')->insert([
                            'menu_id' => $child,
                            'role_id' => $roleId,
                            'view' => true,
                            'site_id' => $siteId,
                        ]);
                    }
                }
            }


            $hasAccess = DB::table('group_accesses')->where(['role_id' => $roleId, 'site_id' => $siteId, 'menu_id' => $menu_id])->first();
            if (!$hasAccess) {
                DB::table('group_accesses')->insert([
                    'menu_id' => $menu_id,
                    'role_id' => $roleId,
                    'view' => true,
                    'site_id' => $siteId,
                ]);
            }
        }
    }
}
