<?php

namespace App\Http\Controllers\Site\Student\Attendance;


use App\Http\Controllers\ProjectController;
use App\Models\Attendance\StudentAttendance;
use App\Models\Site\Academic\SitePeriodTypeDuration;
use App\Models\Site\Routine\RoutineAllocation;
use App\Models\Site\Routine\RoutineDetail;
use App\Models\Site\SiteShiftDetails;
use App\Models\Site\Student\Attendance\PeriodicAttendance;
use App\Traits\Site\EventTrait;
use App\Traits\Site\Routine\RoutineFunction;
use App\Traits\SmsFunctionsTrait;
use App\Models\Student\StudentHistory;
use Auth;
use Log;
use PDF;
use Error;
use Exception;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Response;

class PeriodicAttendanceController extends ProjectController
{

    use  SmsFunctionsTrait, RoutineFunction, EventTrait;
    private $carbon_now;

    private $periodicAttendance;
    private $setting;
    private $user;
    private $siteShiftDetails;
    private $academicClass;
    private $academicSection;
    private $periodTypeDuration;
    private $routineDetail;
    private $routineAllocation;
    private $studentHistory;
    private $studentAttendance;
    private $absentDetail;
    private $student;
    private $infoSetting;

    public function __construct(PeriodicAttendance $periodicAttendance, StudentAttendance $studentAttendance, RoutineAllocation $routineAllocation, SiteShiftDetails $siteShiftDetails,
                                StudentHistory $studentHistory, RoutineDetail $routineDetail, SitePeriodTypeDuration $periodTypeDuration)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->carbon_now = Carbon::now();

        $this->periodicAttendance = $periodicAttendance;
        $this->studentHistory = $studentHistory;
        $this->routineAllocation = $routineAllocation;
        $this->periodTypeDuration = $periodTypeDuration;
        $this->routineDetail = $routineDetail;
        $this->studentAttendance = $studentAttendance;
        $this->siteShiftDetails = $siteShiftDetails;

    }


    public function getPeriodListForAdmin(Request $request)
    {
        try {
            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
            $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
            $data['academic_session_id'] = $request->academic_session_id == 'null' ? 0 : $request->academic_session_id;
            $data['site_batch_detail_id'] = $request->site_batch_detail_id == 'null' ? 0 : $request->site_batch_detail_id;
            $attDate = $request->att_date;


            if (!$data['academic_version_id']) {
                return Response::json(['message' => 'Select * marked Field!'], 411);
            }


            /*    $this->checkClassSectionGroup($data['academic_version_id'], $data['academic_year_id'], $data['academic_shift_id'], $data['academic_department_id'],
                    $data['academic_class_id'], $data['academic_class_group_id'], $data['academic_section_id'], $data['academic_session_id']);*/


            $date = $attDate != 'null' ? $attDate : date('Y-m-d', time());//'2019-05-09';

            $day = date('l', strtotime($date));

            $get_period_type_duration = $this->periodTypeDuration
                ->where('start_date', '<=', $date)
                ->where('end_date', '>=', $date)
                ->first();


            $period_id = ($get_period_type_duration->academic_period_type_id ?? null);
            if (!$period_id) {
                return Response::json(['message' => 'Set Period Type Duration First:  <a target="_blank" href="' . route('site-academic-period-type-setting') . '">Click </a>'], 411);
            }

            $getRoutineDetails = $this->routineDetail
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_period_type_id', $period_id)
                ->where('weekday', $day)
                ->where('is_break', 0)
                ->where('status', 1)
                ->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['site_batch_detail_id'], function ($query) use ($data) {
                    return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
                })->with(['shift', 'class', 'section', 'batch', 'classGroup', 'routineAllocations.subject', 'routineAllocations.swapCancel',
                    'routineAllocations.employee', 'routineAllocations.room', 'routineAllocations.room',
                    'routineAllocations.liveMeeting' => function ($q) use ($date) {
                        $q->where('join_date', $date)->with('meeting');
                    }, 'routineAllocations' => function ($q) use ($date) {
                        $q->withCount(['attendances' => function ($q1) use ($date) {
                            $q1->where('present_date', $date);
                        }]);
                    }])
                ->orderBy('start_time', 'ASC')
                ->get();


            $getRoutineDetails->transform(function ($value, $k) {
                return [
                    'id' => $value->id,
                    'selected' => false,
                    'details' => $value->year->year_name . ' ' . $value->shift->shift_name . ' ' . $value->class->class_name . ' ' . ($value->section->section_name ?? $value->batch->batch_name ?? ''),
                    'class_timing_detail_name' => addOrdinalNumberSuffix($k + 1) ?? '',
                    'start_time' => $value->start_time ?? '',
                    'end_time' => $value->end_time ?? '',
                    'routine_allocations' => $value->routineAllocations ?? null,
                ];
            });


            if (count($getRoutineDetails) < 1) {
                return Response::json(['message' => 'No Active Routine Found For ' . $day], 411);
            }

            return response()->json([$getRoutineDetails, $date], 200);
        } catch (Exception $exception) {

            return response()->json(['message' => $exception->getMessage()], 410);
        }

    }


    public function getStudentListByAllocation(Request $request)
    {


//        return $request->routine_allocation_id;

        $data = [];
        $data['routine_allocation_id'] = $request->routine_allocation_id;
        $attDate = $request->att_date;
        $paginate = $request->paginate ?? 20;
        $status = $request->status ?? 1;
        $att_date = $attDate != '0' ? $attDate : date('Y-m-d', time());

        $present = $request->present;
        $leave = $request->leave;
        $absent = $request->absent;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';


        $history_ids = $this->getStudentHistoryIdsByAllocationId($data['routine_allocation_id']);
        $the_allocation = $this->routineAllocation->findOrFail($data['routine_allocation_id']);


        $student_history = $this->studentHistory
            ->whereIn('id', $history_ids)
            ->with(['attendance' => function ($q) use ($att_date) {
                $q->where('present_date', $att_date);
            }, 'absent' => function ($q) use ($att_date) {
                $q->where('absent_date', $att_date);
            }, 'leaveDetail' => function ($q) use ($att_date) {
                $q->where('leave_date', $att_date);
            }
            ])
            ->where('status', $status)
            ->with(['student', 'student.translations', 'stClass', 'section', 'student.latestPhoto'])
            ->orderBy('student_roll_number', 'ASC');


        $total_student = $student_history->count();

        $student_history_paginate = $student_history
            /*  ->when($leave, function ($qu) use ($att_date) {
               $qu->whereHas('leaveDetail', function ($q) use ($att_date) {
                   $q->leaveToday($att_date);
               });
           })*/
            ->when($absent && !$present && !$leave, function ($qu) use ($att_date, $data) {
                $qu->whereDoesntHave('periodic', function ($q) use ($att_date) {
                    //   $q->PresentByDate($att_date);
                });
                $qu->whereDoesntHave('leaveDetail', function ($q) use ($att_date) {
                    $q->leaveToday($att_date);
                });
            })->when($present && !$absent && !$leave, function ($qu) use ($att_date, $data) {
                $qu->whereHas('periodic', function ($q) use ($att_date, $data) {
                    $q->where('present_date', $att_date);
                    $q->where('routine_allocation_id', $data['routine_allocation_id']);
                });
            })->when(!$present && !$absent && $leave, function ($qu) use ($att_date, $data) {
                $qu->whereHas('periodic', function ($q) use ($att_date, $data) {
                    $q->where('in_leave', true);
                    $q->where('routine_allocation_id', $data['routine_allocation_id']);
                });
            })
            ->when($search_txt, function ($qu) use ($txt) {
                $qu->whereHas('student', function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('username', 'LIKE', $txt)
                            ->orWhere('email', 'LIKE', $txt)
                            ->orWhere('contact_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('first_name', $txt)
                            ->orWhereTranslationLike('last_name', $txt);
                    });
                });
            })
            ->paginate($paginate);


        $class_present = $this->studentAttendance
            ->where('present_date', $att_date)
            ->whereIn('student_history_id', $history_ids);

        $class_wise_total_present = $class_present->count();

        $period_wise = $this->periodicAttendance
            ->where('present_date', $att_date)
            ->where('routine_allocation_id', $data['routine_allocation_id'])
            ->get();
        $period_wise_found = count($period_wise);


        $period_wise_total = $period_wise
            ->count();

        $period_wise_total_present = $period_wise
            ->where('is_present', true)
            ->count();

        $period_wise_total_absent = $period_wise_found ? ($total_student - $period_wise_total_present) : 0;

//        Log::info($period_wise_total_present);

        $period_wise_total_leave = $period_wise
            ->where('in_leave', true)
            ->count();


        $student_history_paginate->getCollection()->transform(function ($value) use ($att_date, $the_allocation, $period_wise_found, $class_present, $period_wise, $absent, $present) {
            //have to check in leave

            $previous_att = $period_wise
                ->where('student_history_id', $value->id)
                ->first();
            //check daily att exist
            $class_present = $class_present
                ->where('student_history_id', $value->id)
                ->first();


            // Log::info($class_present);


            $in_time = null;
            $out_time = null;
            $is_present = null;
            $in_leave = null;
            $late_status = false;
            $note = null;

            if ($period_wise_found) {//at least one student is preset for the period

                if ($previous_att) {//previous  att found as present

                    $in_time = $previous_att->in_time;
                    $out_time = $previous_att->out_time;

                    $is_present = $previous_att->is_present;
                    $late_status = $previous_att->late_status;

                } else {//previous  att found-as absent
                    $in_time = $the_allocation->routineDetail->start_time ?? '';
                    $out_time = $the_allocation->routineDetail->end_time ?? '';

                    $is_present = false;
                    $late_status = false;

                }

            } else {


                if ($previous_att) {//previous  att found as present

                    $in_time = $previous_att->in_time;
                    $out_time = $previous_att->out_time;

                    $is_present = $previous_att->is_present;
                    $late_status = $previous_att->late_status;


                } else {//previous  att found-as absent
                    $in_time = $the_allocation->routineDetail->start_time ?? '';
                    $out_time = $the_allocation->routineDetail->end_time ?? '';
                    $is_present = $class_present ? true : false;
                    $late_status = false;

                }

            }

            return [

                'id' => $value->id ?? null,
                'academic_group_id' => $value->academic_group_id ?? null,
                'username' => $value->student->username ?? 'n/a',
                'latest_photo' => $value->student->latestPhoto->path ?? 'n/a',
                'date' => $att_date ?? null,
                'periodic_id' => $previous_att->id ?? null,
                'present' => $is_present ? 1 : 0,
                'class_present' => $class_present ? 1 : 0,
                'st_status' => ($value->leaveDetail) ? "In Leave" : ($is_present ? "Present" : "Absent"),
                'st_status_int' => ($value->leaveDetail) ? 2 : (($value->attendance) ? 1 : 0),
                //Absent
                'absent' => $value->absent ?? null,
                //Leave
                'in_leave' => $value->leaveDetail ? 1 : 0,
                'leave_id' => $value->leaveDetail->id ?? null,
                //other data
                'student_roll_number' => $value->student_full_roll_number ?? 'n/a',
                'contact_number' => $value->student->contact_number ?? 'n/a',
                'full_name' => ($value->student->full_name ?? 'n/a'),
                'academic_shift_id' => ($value->academic_shift_id ?? null),
                'note' => $previous_att->note ?? '',
                'present_type' => $previous_att->present_type ?? 'web',
                'in_time' => $in_time ?? null,
                'out_time' => $out_time ?? null,
                'present_date' => $previous_att->present_date ?? $att_date,
                'late_status' => $late_status,
                'site_id' => $value->site_id ?? null,
                'updated_at' => $previous_att->updated_at ?? null,
                // 'updated_by' => $previous_att->updateBy->full_name ?? null,

            ];
        });


        if (count($student_history_paginate) <= 0) {
            return Response::json(['message' => 'No Student Found For The Subject!'], 411);
        }
        return response()->json([$student_history_paginate, $att_date, $class_wise_total_present, $period_wise_total_present, $period_wise_total_absent, $period_wise_total_leave, $period_wise_total], 200);

    }


    public function savePeriodicAttendance(Request $request)
    {
         try {


        $data = $request->manualAttendance;
        $att_date = $request->att_date;
        $routine_allocation_id = $request->routine_allocation_id;


        if (!$att_date || count($data) < 1) {
            return Response::json(['message' => 'No Routine Selected!'], 410);
        }


        $day = date('D', strtotime($att_date));

        $get_period_type_duration = $this->periodTypeDuration
            ->where('start_date', '<=', $att_date)
            ->where('end_date', '>=', $att_date)
            ->first();

        if (!$get_period_type_duration) {
            throw new Error('No Period Found On ' . $att_date);
        }
        $routine_allocation = $this->routineAllocation->findOrFail($routine_allocation_id);
        $first_last_period = $routine_allocation->routineDetail->first_last ?? null;


        // return Response::json(['message' => 'No Routine Selected!'.$first_last_period], 410);


        $total_taken = 0;
        $total_updated = 0;
        $delete_ids = [];

        if (count($data) > 0) {
            foreach ($data as $item) {

                if ($item['present']) {

                    $existed = $this->periodicAttendance
                        ->where('student_history_id', $item['id'])
                        ->where('present_date', $att_date)
                        ->where('routine_allocation_id', $routine_allocation->id)
                        ->first();


                    if ($existed) {//previous found

                        $existed->in_time = $item['in_time'];
                        $existed->out_time = $item['out_time'];
                        $existed->in_leave = $item['in_leave'];
                        $existed->is_present = $item['present'];
                        $existed->late_status = $item['late_status'];
                        $existed->note = $item['note'];
                        $existed->updated_by = Auth::user()->id;
                        $existed->save();
                        $total_updated++;

                    } else {

                        $this->periodicAttendance = new PeriodicAttendance();

                        $this->periodicAttendance->routine_allocation_id = $routine_allocation_id;
                        $this->periodicAttendance->student_history_id = $item['id'];
                        $this->periodicAttendance->in_time = $item['in_time'];
                        $this->periodicAttendance->out_time = $item['out_time'];
                        $this->periodicAttendance->present_date = $att_date;
                        $this->periodicAttendance->present_year = date('Y', strtotime($att_date));
                        $this->periodicAttendance->present_month = date('m', strtotime($att_date));
                        $this->periodicAttendance->present_day = date('d', strtotime($att_date));
                        $this->periodicAttendance->in_leave = $item['in_leave'];
                        $this->periodicAttendance->is_present = $item['present'];
                        $this->periodicAttendance->late_status = $item['late_status'];
                        $this->periodicAttendance->note = $item['note'];
                        $this->periodicAttendance->taken_by = Auth::user()->id;
                        $this->periodicAttendance->save();
                        $total_taken++;
                    }


                    if ($first_last_period == 'first' || $first_last_period == 'last') {//save or update day attendance only if the routine is first period or last period


                        $day_present_exited = $this->studentAttendance
                            ->where('present_date', $att_date)
                            ->where('student_history_id', $item['id'])
                            ->where('academic_group_id', $item['academic_group_id'])
                            ->first();

                        $st_shift_details = $this->siteShiftDetails
                            ->where('academic_shift_id', $item['academic_shift_id'])
                            ->where('belongs_to', 'student')
                            ->where('academic_period_type_id', $get_period_type_duration->academic_period_type_id)
                            ->where('academic_group_id', $item['academic_group_id'])
                            ->where('week_day', $day)
                            ->where('status', true)
                            ->first();

                        if (!$st_shift_details) {
                            //   continue;
                            throw new Error('Shift Setting not found!');
                        }

                        $st_attendance = $day_present_exited ?? new StudentAttendance();
                        $st_attendance->student_history_id = $item['id'];
                        $st_attendance->present_type = 'web';
                        $st_attendance->site_shift_details_id = $st_shift_details->id ?? null;
                        $st_attendance->in_time = $first_last_period == 'first' ? $item['in_time'] : $st_attendance->in_time;
                        $st_attendance->out_time = $first_last_period == 'last' ? $item['out_time'] : $st_attendance->out_time;
                        $st_attendance->present_date = $att_date;
                        $st_attendance->present_year = date('Y', strtotime($att_date));
                        $st_attendance->present_month = date('m', strtotime($att_date));
                        $st_attendance->present_day = date('d', strtotime($att_date));
                        $st_attendance->late_status = $st_attendance->late_status ?? $item['late_status'];
                        $st_attendance->created_by = Auth::user()->id;
                        $st_attendance->updated_by = Auth::user()->id;
                        $st_attendance->save();
                    }


                } else {//delete previous present if exist
                    $delete_ids[] = $item['periodic_id'];
                }
            }

            $this->periodicAttendance
                ->whereIn('id', $delete_ids)
                ->delete();


            return Response::json(['message' => 'Periodic Attendance Successfully Saved:' . $total_taken . ' Updated:' . $total_updated], 200);

        }
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 411);
        }


    }


    //Teacher Periodic=================================================

    public function getPeriodListForEmployee(Request $request)
    {
//dd($request);

        // $history_ids = $this->getStudentHistoryIdsByAllocationId(1032);


        $data = [];
        $attDate = $request->att_date;
        $date = $attDate ? $attDate : date('Y-m-d', time());//'2019-05-09';
        $day = date('l', strtotime($date));


        $site_id = (int)session()->get('SITE_ID');
        $academic_group_id = (int)session()->get('ACADEMIC_GROUP_ID');
        $is_day_open = $this->isTheDateOpen($attDate, $academic_group_id, $site_id);

        if (!$is_day_open) {
            return response()->json(['message' => date('d M Y', strtotime($attDate)) . ' is holiday!'], 411);
        }

        $get_period_type_duration = $this->periodTypeDuration
            ->where('start_date', '<=', $date)
            ->where('end_date', '>=', $date)
            ->first();
        $emp_id = Auth::user()->id;


        $period_id = ($get_period_type_duration->academic_period_type_id ?? null);
        if (!$period_id) {
            return Response::json(['message' => 'Set Period Type Duration First:  <a target="_blank" href="' . route('site-academic-period-type-setting') . '">Click </a>'], 411);
        }


        $routineDetails = $this->routineDetail
            ->where('weekday', $day)
            ->where('academic_period_type_id', $period_id)
            ->where('status', true)
            ->where(function ($q1) use ($emp_id, $date) {
                $q1->whereHas('allocation', function ($q) use ($date, $emp_id) {
                    $q->where('employee_id', $emp_id)
                        ->where('status', true);
                });
                $q1->orWhereHas('allocation.swapCancel', function ($q) use ($date, $emp_id) {
                    $q->where('swap_cancel_date', $date)
                        ->where('employee_id', $emp_id);
                });
            })
            ->with(['allocation' => function ($q) use ($emp_id) {
                $q->where('employee_id', $emp_id);
            }, 'allocation.swapCancel' => function ($q) use ($emp_id) {
                $q->where('employee_id', $emp_id);
            },
                'allocation.liveMeeting' => function ($q) use ($date) {
                    $q->where('join_date', $date);
                }, 'allocation.attendances' => function ($q) use ($date) {
                    $q->where('present_date', $date)
                        ->where('is_present', true);
                }, 'allocation.subject', 'allocation.room', 'class', 'section'])
            ->orderBy('start_time', 'ASC')
            ->get();

        $allocation_lists = [];


        foreach ($routineDetails as $k => $detail) {

            // dd($emp_id, $detail->allocation->swapCancel);

            $allocation_lists[$k]['id'] = $detail->allocation->id ?? '';
            $allocation_lists[$k]['details'] = ($detail->allocation->swapCancel->subject_name_ex ??  $detail->allocation->subject_name_ex) . ' (' . ($detail->start_time ?? '') . '-' . ($detail->end_time ?? '') . ')';
            $allocation_lists[$k]['start_time'] = $detail->start_time ?? '';
            $allocation_lists[$k]['end_time'] = $detail->end_time ?? '';
            $allocation_lists[$k]['class_timing_detail_name'] = addOrdinalNumberSuffix($k + 1);
            $allocation_lists[$k]['class_name'] = ($detail->class->class_name ?? '') . ' (' . ($detail->year->year_name ?? '');
            $allocation_lists[$k]['section_name'] = $detail->section->section_name ?? '';
            $allocation_lists[$k]['subject_name'] = $detail->allocation->swapCancel->subject_name_ex ??  $detail->allocation->subject_name_ex;
            $allocation_lists[$k]['selected'] = false;
            $allocation_lists[$k]['loading'] = false;
            $allocation_lists[$k]['swapCancel'] = $detail->allocation->swapCancel ?? null;
            $allocation_lists[$k]['total_present'] = count($detail->allocation->attendances);
            $allocation_lists[$k]['status'] = $detail->allocation->status ?? false;

            $allocation_lists[$k]['invited'] = $detail->allocation->liveMeeting->status ?? false;
            $allocation_lists[$k]['meeting_id'] = $detail->allocation->liveMeeting->meeting->meeting_id ?? null;
            $allocation_lists[$k]['live_join_link'] = $detail->allocation->liveMeeting->meeting->join_url ?? null;
            $allocation_lists[$k]['start_url'] = $detail->allocation->liveMeeting->meeting->start_url ?? null;
            $allocation_lists[$k]['meeting_id'] = $detail->allocation->liveMeeting->meeting->meeting_id ?? null;

        }

        // dd($allocation_lists);

        if (count($routineDetails) < 1) {
            return Response::json(['message' => 'No Routine Is Assigned For You on ' . $day], 411);
        }
        return response()->json([$allocation_lists, $date], 200);

    }


    public function getStudentListBySubject(Request $request)
    {

//        $academic_version_id, $academic_year_id, $academic_shift_id, $academic_department_id, $academic_class_id, $academic_class_group_id,
// $academic_section_id, $academic_session_id, $routine_allocation_id, $attDate


        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
        $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
        $data['academic_session_id'] = $request->academic_session_id == 'null' ? 0 : $request->academic_session_id;
        $data['routine_allocation_id'] = $request->routine_allocation_id;
        $attDate = $request->att_date;

        if (!$data['routine_allocation_id']) {
            return Response::json(['message' => 'Please Select Subject!'], 411);
        }

        $dept = '';
        $class = '';
        $group = '';
        $section = '';
        $session = '';


        $routine_allocation = $this->routineAllocation->findOrFail($data['routine_allocation_id']);
        $att_date = $attDate ? $attDate : date('Y-m-d', time());

        $studentHistoryList = StudentHistory::
        where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->whereHas('student', function ($q) {
                $q->where('status', 1);
            })
            ->where('status', 1)
            ->with(['stClass', 'section', 'department', 'accGroup', 'session', 'student.latestPhoto'])
            ->orderBy('student_roll_number', 'ASC')
            ->get();

        $final_students = [];
        $subject_att_taken = $this->studentAttendance
            ->where('present_date', $att_date)
            ->where('present_type', 'subject')
            ->where('present_type_id', $routine_allocation->subject_id)
            ->first();


        foreach ($studentHistoryList as $key => $studentHistory) {

            if (count($studentHistory->subjects)) {
                $plucked_subject_ids = $studentHistory->subjects->pluck('id')->toArray();
                $has_subject = in_array($routine_allocation->subject_id, $plucked_subject_ids);

                if ($has_subject) {//the student has the subject

                    $dept = $studentHistory->department->name ?? '';
                    $class = $studentHistory->stClass->class_name ?? '';
                    $group = $studentHistory->accGroup->group_name ?? '';
                    $section = $studentHistory->section->section_name ?? '';
                    $session = $studentHistory->session->session_name ?? '';


                    $final_students[$key] = $studentHistory;
                    if ($subject_att_taken) {
                        $final_students[$key]->present = false;
                    } else {
                        $final_students[$key]->in_time = $routine_allocation->routineDetail->start_time;
                        $final_students[$key]->out_time = $routine_allocation->routineDetail->end_time;
                        $final_students[$key]->present = true;
                        continue;
                    }

                    $previous_att = $this->studentAttendance
                        ->where('present_date', $att_date)
                        ->where('student_history_id', $studentHistory->id)
                        ->where('present_type', 'subject')
                        ->where('present_type_id', $routine_allocation->subject_id)
                        ->first();

                    if ($previous_att) {//previous  att found as presetnt

                        $final_students[$key]->in_time = $previous_att->in_time;
                        if ($previous_att->out_time) {
                            $final_students[$key]->out_time = $previous_att->out_time;
                        }
                        $final_students[$key]->present = true;
                    } else {//previous  att found-as absent
                        $final_students[$key]->in_time = $routine_allocation->routineDetail->start_time;
                        $final_students[$key]->out_time = $routine_allocation->routineDetail->end_time;
                        $final_students[$key]->present = false;

                    }
                }
            }
        }
        if (count($final_students) <= 0) {
            return Response::json(['message' => 'No Student Found For The Subject!'], 411);
        }


        return response()->json([$final_students, $att_date, $dept, $class, $group, $section, $session], 200);
    }


}
