<?php

namespace App\Http\Controllers\Site\Student\QuickInsert;

use App\Imports\Site\SiteStudentListImport;
use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\SubjectCondition;
use App\Models\AcademicYear\AcademicYear;
use App\Models\BloodGroup\BloodGroup;
use App\Models\Gender\Gender;
use App\Models\Religion\Religion;
use App\Models\Site\Role\SiteRole;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\Student\Student;
use App\Models\Site\Student\StudentHistoryExcel;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Models\User\User;
use App\Models\User\UserForUsername;
use Auth;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;
use Maatwebsite\Excel\Facades\Excel;
use App\Models\Image\Photo;
use App\Models\SubjectGroupConditionSetting\SiteSubjectConditionLimit;

class SiteStudentQuickInsertController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }


    public function index()
    {
        $viewType = 'Student Form Quick Update';
        return view('default.admin.layouts.master', compact('viewType'));
    }


    private function classGroupSectionValidation($request)
    {

        $check_group_section = SiteShiftClassGroupSectionSetting::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->first();


        if ($check_group_section->academic_department_id && !$request->academic_department_id) {
            return Response::json(['message' => 'Plese Select Department!', 'mode' => 'Error'], 200);
        }

        if ($check_group_section->academic_class_group_id && !$request->academic_class_group_id) {
            return Response::json(['message' => 'Plese Select Group!', 'mode' => 'Error'], 200);
        }

        if ($check_group_section->academic_section_ids && !$request->academic_section_id) {
            return Response::json(['message' => 'Plese Select Section!', 'mode' => 'Error'], 200);
        }
    }


    public function getBlankStudentListForQuickInsert(Request $request)
    {

        $valiedation = $this->classGroupSectionValidation($request);
        if ($valiedation) {
            return $valiedation;
        }

        $insert_number = 5;

        for ($i = 1; $i <= $insert_number; $i++) {

            $student_array[] =

                [
                    'id' => 0,
                    'first_name' => null,
                    'last_name' => null,
                    'father_name' => null,
                    'mother_name' => null,
                    'date_of_birth' => null,
                    'gender_id' => 0,
                    'religion_id' => 0,
                    'blood_group_id' => 0,
                    'student_roll_number' => null,
                    'compulsory_subject_ids' => [],
                    'optional_subject_ids' => [],
                    'selective_markingless_subject_ids' => [],
                    'religion_subject_id' => null,

                    'academic_student_admission_type_id' => null,
                    'academic_student_category_id' => null,
                    'academic_student_type_id' => null,

                    'date_of_birth_required' => false,
                    'religion_id_required' => false,
                    'gender_id_required' => false,
                    'category_id_required' => false,
                    'religion_subject_id_required' => false,
                    'duplicate_value' => false,

                    'first_name_required' => false,
                    'father_name_required' => false,
                    'mother_name_required' => false,

                ];
        }







        $siteInfoSettinglist = SiteInfoSetting::first();

        $student_admission_type_listsplite = explode(',', $siteInfoSettinglist->academic_admission_type_ids);
        $admissionTypelist = AcademicAdmissionType::whereIn('id', $student_admission_type_listsplite)->get();

        $student_category_listsplite = explode(',', $siteInfoSettinglist->academic_student_category_ids);
        $studentCategorylist = AcademicStudentCategory::whereIn('id', $student_category_listsplite)->get();

        $student_type_listsplite = explode(',', $siteInfoSettinglist->academic_student_type_ids);
        $studentTypelist = AcademicStudentType::whereIn('id', $student_type_listsplite)->get();





        $genderlistsplite = explode(',', $siteInfoSettinglist->gender_ids);
        $genderlist = Gender::whereIn('id', $genderlistsplite)->get();

        $religionlistsplite = explode(',', $siteInfoSettinglist->religion_ids);
        $religionlist = Religion::whereIn('id', $religionlistsplite)->get();


        $bloodlist = BloodGroup::get();

        $subject_list = $this->getClassGroupBaseSubjectList(
            $request->academic_class_id,
            $request->academic_class_group_id,
            $request->academic_year_id,
            $request->academic_department_id
        );




           $religion_subject_list=$subject_list[0];
           $selective_compulsory_subject_list=$subject_list[1];
           $optional_subject_list=$subject_list[2];
           $selective_markingless_subject_list=$subject_list[3];
        //    $compulsory_subject_list=$subject_list[4];
        //    $slective_compulsory_subject_limit=$subject_list[5];
        //    $optional_subject_limit=$subject_list[6];




        // $religion_subject_list = $subject_list[0];
        // $selective_compulsory_subject_list = $subject_list[1];
        // $optional_subject_list = $subject_list[2];
        // $selective_markingless_subject_list = $subject_list[3];


        return response()->json(
            [
                'student_list' => $student_array,
                'genderlist' => $genderlist,
                'religionlist' => $religionlist,
                'blood_group' => $bloodlist,

                'admissionTypelist' => $admissionTypelist,
                'studentCategorylist' => $studentCategorylist,
                'studentTypelist' => $studentTypelist,

                'religion_subject_list' => $religion_subject_list,
                'selective_compulsory_subject_list' => $selective_compulsory_subject_list,
                'optional_subject_list' => $optional_subject_list,
                'selective_markingless_subject_list' => $selective_markingless_subject_list,


            ]
        );
    }

    


    private function getClassGroupBaseSubjectList($classid, $groupid, $yearid, $department_id)
    {

        $dept_id = $department_id;

        $groupPresentCount = SiteShiftClassGroupSectionSetting::select('academic_class_group_id')
            ->where('academic_class_id', $classid)
            ->where('academic_year_id', $yearid)
            ->when($department_id != 'null', function ($query) use ($dept_id) {
                return $query->where('academic_department_id', $dept_id);
            })
            ->whereNotNull('academic_class_group_id')
            ->get()
            ->count();

        $siteClassBaseSubjectDetail = SubjectGroupConditionSetting::with(['academicSubject'])
            ->where('academic_class_id', $classid)
            ->where('academic_year_id', $yearid)
            ->when($department_id != 'null', function ($query) use ($dept_id) {
                return $query->where('academic_department_id', $dept_id);
            })
            ->where('status', true)
            ->get();

        $subjectCondition = SubjectCondition::get();

        $limit_list = SiteSubjectConditionLimit::where('academic_class_id', $classid)
            ->where('academic_year_id', $yearid)
            ->where('academic_class_group_id', $groupid)
            ->when($department_id != 'null', function ($query) use ($dept_id) {
                return $query->where('academic_department_id', $dept_id);
            })
            ->where('status', true)
            ->get();



        $classBaseOptionalSubjectIDList = [];
        $classBaseSelectiveCompulsorySubjectIDList = [];
        $classBaseReligionSubjectIDList = [];
        $classBaseMarkinglessSubjectIDList = [];
        $classBaseCompulsorySubjectIDList = [];
        $optional_subject_limit = 0;
        $compulsory_subject_limit = 0;
      //  $classBaseSelectiveCompulsorySubjectIDList = [];

        if (!$groupPresentCount && !$groupid) {

         //   $classBaseReligionSubjectIDList = [];
            foreach ($siteClassBaseSubjectDetail as $key => $value) {

                $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                // $OptionalSubjectId = SubjectCondition::whereIn('id', $academicOptionalSubjectConditionIds)
                //     ->where('condition_key', 'optional')
                //     ->first();
                // if ($OptionalSubjectId) {
                //     $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                // }

                // $academicSelectiveCompulsorySubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
                // $SelectiveCompulsorySubjectId = SubjectCondition::whereIn('id', $academicSelectiveCompulsorySubjectConditionIds)
                //     ->where('condition_key', 'selectiveCompulsory')
                //     ->first();

                // if ($SelectiveCompulsorySubjectId) {
                //     $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                // }
                //====================== optional subject=======================
                //$academicSelectiveCompulsorySubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                $OptionalSubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                    ->where('condition_key', 'optional')
                    ->first();
                if ($OptionalSubjectId) {
                    $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                }

                // ================selective-compulsory subject======================//
                $SelectiveCompulsorySubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                    ->where('condition_key', 'selectiveCompulsory')
                    ->first();

                if ($SelectiveCompulsorySubjectId) {
                    $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                }

                 // ================religion subject======================//
                 $religionSubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                     ->where('condition_key', 'religion')
                     ->first();


                 if ($religionSubjectId) {
                     $classBaseReligionSubjectIDList[$key] = $value->academic_subject_id;
                 }

                 // ================selective-markingless subject======================//
                 $markinglessSubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                    ->where('condition_key', 'selectiveMarkingless')
                    ->first();

                if ($markinglessSubjectId) {
                    $classBaseMarkinglessSubjectIDList[$key] = $value->academic_subject_id;
                }

                // ================compulsory subject======================//

                $compulsorySubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                ->where('condition_key', 'compulsory')
                ->first();

                if ($compulsorySubjectId) {
                    $classBaseCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                }

                // ===== optional subject limit ===
                $academicOptionalSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                $optional_id = $subjectCondition->where('condition_key', 'optional')
                    ->first();

                $optional_sub_limit = $limit_list->where('academic_subject_condition_id', $optional_id->id)
                    ->first();


                $OptionalSubjectId = $subjectCondition->whereIn('id', $academicOptionalSubjectConditionIds)
                    ->where('condition_key', 'optional')
                    ->first();

                if ($OptionalSubjectId) {
                    if ($optional_sub_limit) {
                        if ($optional_sub_limit->not_show_academic_subject_ids) {
                            $limited_subject_list = AcademicSubject::
                            whereIn('id', explode(',', $optional_sub_limit->not_show_academic_subject_ids))
                                ->get();

                            $check_limit_not_show = $limited_subject_list->where('id', $value->academic_subject_id)->first();
                            if (!$check_limit_not_show) {
                                $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                            }

                            $optional_subject_limit = $optional_sub_limit->limit_amount ? $optional_sub_limit->limit_amount : 0;
                        } else {
                            $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                            $optional_subject_limit = $optional_sub_limit->limit_amount ? $optional_sub_limit->limit_amount : 0;
                        }
                    } else {
                        $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                    }

                }

                ///==
                   /// ====== compulsory subject limit ======
                   $academicSelectiveCompulsorySubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                   $selectiveCompulsory_id = $subjectCondition->where('condition_key', 'selectiveCompulsory')
                       ->first();

                   $selectiveCompulsory_sub_limit = $limit_list->where('academic_subject_condition_id', $selectiveCompulsory_id->id)
                       ->first();


                   $SelectiveCompulsorySubjectId = $subjectCondition->whereIn('id', $academicSelectiveCompulsorySubjectConditionIds)
                       ->where('condition_key', 'selectiveCompulsory')
                       ->first();

                   if ($SelectiveCompulsorySubjectId) {
                       if ($selectiveCompulsory_sub_limit) {
                           if ($selectiveCompulsory_sub_limit->not_show_academic_subject_ids) {
                               $limited_compulsory_subject_list = AcademicSubject::
                               whereIn('id', explode(',', $selectiveCompulsory_sub_limit->not_show_academic_subject_ids))
                                   ->get();

                               $check_limit_not_show_compulsory = $limited_compulsory_subject_list->where('id', $value->academic_subject_id)->first();
                               if (!$check_limit_not_show_compulsory) {
                                   $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                               }

                               $compulsory_subject_limit = $selectiveCompulsory_sub_limit->limit_amount ? $selectiveCompulsory_sub_limit->limit_amount : 0;
                           } else {
                               $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                               $compulsory_subject_limit = $selectiveCompulsory_sub_limit->limit_amount ? $selectiveCompulsory_sub_limit->limit_amount : 0;
                           }
                       } else {
                           $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                       }

                   }
                   ///======

            };

        } else if ($groupPresentCount && $groupid) {

            foreach ($siteClassBaseSubjectDetail as $key => $value) {

                $academicClassGroupIds = explode(',', $value->academic_class_group_ids);
                $academicClassGroupPresent = array_keys($academicClassGroupIds, $groupid);

                if ($academicClassGroupPresent) {
                    $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                   //====================== optional subject=======================
                    $OptionalSubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                        ->where('condition_key', 'optional')
                        ->first();
                    if ($OptionalSubjectId) {
                        $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                    }

                    // ================selective-compulsory subject======================//
                    $SelectiveCompulsorySubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                        ->where('condition_key', 'selectiveCompulsory')
                        ->first();

                    if ($SelectiveCompulsorySubjectId) {
                        $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                    }

                     // ================religion subject======================//
                     $religionSubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                         ->where('condition_key', 'religion')
                         ->first();


                     if ($religionSubjectId) {
                         $classBaseReligionSubjectIDList[$key] = $value->academic_subject_id;
                     }

                     // ================selective-markingless subject======================//
                     $markinglessSubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                        ->where('condition_key', 'selectiveMarkingless')
                        ->first();

                    if ($markinglessSubjectId) {
                        $classBaseMarkinglessSubjectIDList[$key] = $value->academic_subject_id;
                    }

                    // ================compulsory subject======================//

                    $compulsorySubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                    ->where('condition_key', 'compulsory')
                    ->first();

                    if ($compulsorySubjectId) {
                        $classBaseCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                    }

                // ===== optional subject limit ===
                $academicOptionalSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                $optional_id = $subjectCondition->where('condition_key', 'optional')
                    ->first();

                $optional_sub_limit = $limit_list->where('academic_subject_condition_id', $optional_id->id)
                    ->first();


                $OptionalSubjectId = $subjectCondition->whereIn('id', $academicOptionalSubjectConditionIds)
                    ->where('condition_key', 'optional')
                    ->first();

                if ($OptionalSubjectId) {
                    if ($optional_sub_limit) {
                        if ($optional_sub_limit->not_show_academic_subject_ids) {
                            $limited_subject_list = AcademicSubject::
                            whereIn('id', explode(',', $optional_sub_limit->not_show_academic_subject_ids))
                                ->get();

                            $check_limit_not_show = $limited_subject_list->where('id', $value->academic_subject_id)->first();
                            if (!$check_limit_not_show) {
                                $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                            }

                            $optional_subject_limit = $optional_sub_limit->limit_amount ? $optional_sub_limit->limit_amount : 0;
                            $not_sowing_subject = $optional_sub_limit->not_show_academic_subject_ids ? $optional_sub_limit->not_show_academic_subject_ids : "";
                          //  $test = explode(',' $optional_sub_limit->not_show_academic_subject_ids);
                        } else {
                            $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                            $optional_subject_limit = $optional_sub_limit->limit_amount ? $optional_sub_limit->limit_amount : 0;
                            $not_sowing_subject = $optional_sub_limit->not_show_academic_subject_ids ? $optional_sub_limit->not_show_academic_subject_ids : "";
                        }
                    } else {//
                        $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                    }

                }

                ///==

                      /// ====== compulsory subject limit ======
                   $academicSelectiveCompulsorySubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                   $selectiveCompulsory_id = $subjectCondition->where('condition_key', 'selectiveCompulsory')
                       ->first();

                   $selectiveCompulsory_sub_limit = $limit_list->where('academic_subject_condition_id', $selectiveCompulsory_id->id)
                       ->first();


                   $SelectiveCompulsorySubjectId = $subjectCondition->whereIn('id', $academicSelectiveCompulsorySubjectConditionIds)
                       ->where('condition_key', 'selectiveCompulsory')
                       ->first();

                   if ($SelectiveCompulsorySubjectId) {
                       if ($selectiveCompulsory_sub_limit) {
                           if ($selectiveCompulsory_sub_limit->not_show_academic_subject_ids) {
                               $limited_compulsory_subject_list = AcademicSubject::
                               whereIn('id', explode(',', $selectiveCompulsory_sub_limit->not_show_academic_subject_ids))
                               ->get();

                               $not_sowing_selective_Compulsory_subject = $selectiveCompulsory_sub_limit->not_show_academic_subject_ids ? $selectiveCompulsory_sub_limit->not_show_academic_subject_ids : "";

                               $check_limit_not_show_compulsory = $limited_compulsory_subject_list->where('id', $value->academic_subject_id)->first();
                               if (!$check_limit_not_show_compulsory) {
                                   $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                               }

                               $compulsory_subject_limit = $selectiveCompulsory_sub_limit->limit_amount ? $selectiveCompulsory_sub_limit->limit_amount : 0;
                           } else {
                               $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                               $compulsory_subject_limit = $selectiveCompulsory_sub_limit->limit_amount ? $selectiveCompulsory_sub_limit->limit_amount : 0;
                           }
                       } else {
                           $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                       }

                   }
                   ///======
                }

            };
        }

        $not_sowing_subject_array = explode(',', $not_sowing_subject??0);
        $not_sowing_Compulsory_subject_array = explode(',', $not_sowing_selective_Compulsory_subject??0);


        $OptionalSubjectList = AcademicSubject::whereIn('id', array_diff($classBaseOptionalSubjectIDList,$not_sowing_subject_array))->get();
        $SelectiveCompulsorySubjectList = AcademicSubject::whereIn('id', array_diff($classBaseSelectiveCompulsorySubjectIDList,$not_sowing_Compulsory_subject_array))->get();
        $religionSubjectList = AcademicSubject::whereIn('id', array_diff($classBaseReligionSubjectIDList,$not_sowing_subject_array))->withTranslation('bn')->get();
        $markinglessSubjectList = AcademicSubject::whereIn('id', array_diff($classBaseMarkinglessSubjectIDList,$not_sowing_subject_array))->withTranslation('bn')->get();
        $compulsorySubjectList = AcademicSubject::whereIn('id', $classBaseCompulsorySubjectIDList)->withTranslation('bn')->get();

        return [$religionSubjectList, $SelectiveCompulsorySubjectList, $OptionalSubjectList, $markinglessSubjectList, $compulsorySubjectList, $compulsory_subject_limit, $optional_subject_limit];
    }


    public function quickMultipleStudentPersonalInformationInsert(Request $request)
    {

        $StudentList = collect($request->StudentList);

         $valid_data = $this->studentValidation($StudentList, $request);
        if ($valid_data) {

            return $valid_data;
        }

        $check_batch_present = SiteInfoSetting::select('batch_present_status')->first();
        if ($check_batch_present->batch_present_status && !$request->site_batch_detail_id) {
            return Response::json([
                'message' => 'Please Select Batch',
                'mode' => 'Error'
            ], 412);
        }


        foreach ($StudentList as $key => $value) {
        //    if ($value['first_name'] && $value['father_name'] && $value['mother_name'] && $value['date_of_birth']) {
            if ($value['first_name']) {

                $studentUsername = $this->studentUserNameCreateUseCode($request);
                $studentpassword = mt_rand(10000, 99999);

                $academicSubjectIDs = $this->academicSubjectList($request, $value);

                $student = new Student();
                $studentHistory = new StudentHistory();

                $compulsory_subject_ids = (string)implode(',', $value['compulsory_subject_ids']);
                $optional_subject_ids = (string)implode(',', $value['optional_subject_ids']);

                $selective_markingless_subject_ids = (string)implode(',', $value['selective_markingless_subject_ids']);


                $student->username = $studentUsername;
                $student->password = $studentpassword;
                $student->first_name = ucwords($value['first_name']);
                $student->last_name = ucwords($value['last_name'] ? $value['last_name'] : '');
                $student->father_name = ucwords($value['father_name']);
                $student->mother_name = ucwords($value['mother_name']);
                $student->date_of_birth = $value['date_of_birth'];
                $student->gender_id = $value['gender_id'];
                $student->religion_id = $value['religion_id'];
                $student->blood_group_id = $value['blood_group_id'];


                $student->academic_version_id = $request->academic_version_id;
                $student->academic_year_id = $request->academic_year_id;
                $student->academic_shift_id = $request->academic_shift_id;
                $student->academic_department_id = $request->academic_department_id;
                $student->academic_class_id = $request->academic_class_id;
                $student->site_batch_detail_id = $request->site_batch_detail_id;
                $student->academic_class_group_id = $request->academic_class_group_id;
                $student->academic_section_id = $request->academic_section_id;
                //   $student->academic_session_id = $request->academic_session_id;

                $student->academic_student_admission_type_id = $value['academic_student_admission_type_id'];
                $student->academic_student_category_id = $value['academic_student_category_id'];
                $student->academic_student_type_id = $value['academic_student_type_id'];

                $student->academic_subject_ids = $academicSubjectIDs;

                $student->religion_subject_id = $value['religion_subject_id'];
                $student->compulsory_subject_ids = $compulsory_subject_ids;
                $student->selective_compulsory_subject_ids = $compulsory_subject_ids;
                $student->optional_subject_ids = $optional_subject_ids;
                $student->selective_markingless_subject_ids = $selective_markingless_subject_ids;


                $student->user_type = 'student';
                $student->site_id = Session::get('SITE_ID');
                $student->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
                $student->status = 1;
                $student->academic_subject_ids = $academicSubjectIDs;

                //                \Log::info('ok');
                if ($student->save()) {
                    $roleStudent = SiteRole::where('key', 'student')->first();
                    $student->siteRoles()->attach([$roleStudent->id]);
                }


                $studentHistory->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
                $studentHistory->site_id = Session::get('SITE_ID');
                $studentHistory->user_id = $student->id;

                $studentHistory->academic_version_id = $request->academic_version_id;
                $studentHistory->academic_year_id = $request->academic_year_id;
                $studentHistory->academic_shift_id = $request->academic_shift_id;
                $studentHistory->academic_department_id = $request->academic_department_id;
                $studentHistory->academic_class_id = $request->academic_class_id;
                $studentHistory->site_batch_detail_id = $request->site_batch_detail_id;
                $studentHistory->academic_class_group_id = $request->academic_class_group_id;
                $studentHistory->academic_section_id = $request->academic_section_id;
                $studentHistory->academic_session_id = $request->academic_session_id;
                $studentHistory->student_roll_number = $value['student_roll_number'];


                $studentHistory->academic_student_admission_type_id = $value['academic_student_admission_type_id'];
                $studentHistory->academic_student_category_id = $value['academic_student_category_id'];
                $studentHistory->academic_student_type_id = $value['academic_student_type_id'];

                $studentHistory->academic_subject_ids = $academicSubjectIDs;
                $studentHistory->religion_subject_id = $value['religion_subject_id'];
                $studentHistory->selective_compulsory_subject_ids = $compulsory_subject_ids;
                $studentHistory->compulsory_subject_ids = $compulsory_subject_ids;
                $studentHistory->optional_subject_ids = $optional_subject_ids;
                $studentHistory->selective_markingless_subject_ids = $selective_markingless_subject_ids;


                $studentHistory->academic_subject_ids = $academicSubjectIDs;
                $studentHistory->status = 1;
                $studentHistory->created_by = Auth::user()->id;

                if ($studentHistory->save()) {
                    $studentHistory->subjects()->sync(explode(',', $academicSubjectIDs));
                }
            }
        }

        return Response::json([
            'message' => 'Successfully Student Inserted.',
            'mode' => 'success'
        ], 200);
    }



    private function studentValidation($StudentList, $request)
    {

        // father_name_show: false,
        // mother_name_show: false,
        // date_of_birth_show: false,
        // blood_group_show: false,
        // admission_type_show: false,
        // student_category_show: false,
        // student_type_show: false,




        $blank_name_arr = array();
        $blank_name_array = [];
        foreach ($StudentList as $key => $value) {

            $first_name_required = !$value['first_name'] ? true : false;
            $father_name_required = !$value['father_name']  && $request->father_name_show ? true : false;
            $mother_name_required = !$value['mother_name'] && $request->mother_name_show ? true : false;
            $date_of_birth_required = !$value['date_of_birth'] && $request->father_name_show ? true : false;

            
            // first name required
            if ($first_name_required) {
                $blank_name_arr['first_name_required'] = $first_name_required;
                $blank_name_array[$key] = array_merge($value, $blank_name_arr);
            

                if(count($blank_name_array) > 0){
                    $blank_name_order = collect($blank_name_array)->values();

                        return Response::json([
                        'message' => 'You must fillup First Name!',
                        'duplicate_student_array' => null,
                        'required_data' => $blank_name_order,
                        'duplicate_roll' => null,
                        'mode' => 'Error'
                    ], 200);
                }
            }

            // father name required
            if ($father_name_required) {
                $blank_name_arr['father_name_required'] = $father_name_required;
                $blank_name_array[$key] = array_merge($value, $blank_name_arr);
           

                if(count($blank_name_array) > 0){
                    $blank_name_order = collect($blank_name_array)->values();

                        return Response::json([
                        'message' => 'You must fillup Father Name!',
                        'duplicate_student_array' => null,
                        'required_data' => $blank_name_order,
                        'duplicate_roll' => null,
                        'mode' => 'Error'
                    ], 200);
                }
            }

            // mother name required
            if ($mother_name_required) {
                $blank_name_arr['mother_name_required'] = $mother_name_required;
                $blank_name_array[$key] = array_merge($value, $blank_name_arr);
           

                if(count($blank_name_array) > 0){
                    $blank_name_order = collect($blank_name_array)->values();

                        return Response::json([
                        'message' => 'You must fillup Mother Name!',
                        'duplicate_student_array' => null,
                        'required_data' => $blank_name_order,
                        'duplicate_roll' => null,
                        'mode' => 'Error'
                    ], 200);
                }
            }

            // date of birth required
            if ($date_of_birth_required) {
                $blank_name_arr['date_of_birth_required'] = $date_of_birth_required;
                $blank_name_array[$key] = array_merge($value, $blank_name_arr);

                if(count($blank_name_array) > 0){
                    $blank_name_order = collect($blank_name_array)->values();

                        return Response::json([
                        'message' => 'You must fillup Date of Birth!',
                        'duplicate_student_array' => null,
                        'required_data' => $blank_name_order,
                        'duplicate_roll' => null,
                        'mode' => 'Error'
                    ], 200);
                }
            }
        }

          


        //     $first_name_required = !$value['first_name'] && ($value['father_name']  || $value['mother_name'] || $value['date_of_birth']) ? true : false;
        //     $father_name_required = !$value['father_name'] && ($value['first_name'] || $value['mother_name'] || $value['date_of_birth']) ? true : false;
        //     $mother_name_required = !$value['mother_name'] && ($value['first_name'] || $value['father_name'] || $value['date_of_birth']) ? true : false;
        //     $date_of_birth_required = !$value['date_of_birth'] && ($value['first_name'] || $value['father_name'] || $value['mother_name']) ? true : false;

        //     if ($first_name_required || $father_name_required || $mother_name_required || $date_of_birth_required) {
        //         $blank_name_arr['first_name_required'] = $first_name_required;
        //         $blank_name_arr['father_name_required'] = $father_name_required;
        //         $blank_name_arr['mother_name_required'] = $mother_name_required;
        //         $blank_name_arr['date_of_birth_required'] = $date_of_birth_required;


        //         $blank_name_array[$key] = array_merge($value, $blank_name_arr);
        //     }
        // }

        // $blank_name_order = collect($blank_name_array)->values();
        // if (count($blank_name_array) > 0) {
        //     return Response::json([
        //         'message' => 'You must fillup First Name, Father Name, Mother Name & Date of Birth!',
        //         'duplicate_student_array' => null,
        //         'required_data' => $blank_name_order,
        //         'duplicate_roll' => null,
        //         'mode' => 'Error'
        //     ], 200);
        // }






        $duplicate_data_array = [];
        $duplicate_roll_ar = [];
        foreach ($StudentList as $key => $value) {

            if ($value['first_name'] && $value['father_name'] && $value['mother_name'] && $value['date_of_birth']) {
                $check_dup = $StudentList
                    ->where('first_name', $value['first_name'])
                    ->where('last_name', $value['last_name'])
                    ->where('father_name', $value['father_name'])
                    ->where('mother_name', $value['mother_name'])
                    ->where('date_of_birth', $value['date_of_birth']);

                if (count($check_dup) > 1) {
                    $duplicate_data_array[] = $value;
                }

                $duplicate_roll_check = $StudentList
                    ->where('student_roll_number', $value['student_roll_number']);

                if (count($duplicate_roll_check) > 1) {
                    $duplicate_roll_ar[] = $value['student_roll_number'];
                }
            }
        }


        if (count($duplicate_data_array) > 0) {

            return Response::json([
                'message' => 'Duplicate Data Present!',
                'duplicate_student_array' => $duplicate_data_array,
                'required_data' => null,
                'duplicate_roll' => $duplicate_roll_ar,
                'mode' => 'Error'
            ], 200);
        }

        //  dd($duplicate_data_array);
        $blank_data_arr = array();
        $blank_data_array = [];
        foreach ($StudentList as $key => $value) {

            if ($value['first_name'] && $value['father_name'] && $value['mother_name']) {

                $birth_date_required = !$value['date_of_birth'] ? true : false;
                $religion_id_required = !$value['religion_id'] ? true : false;
                $gender_id_required = !$value['gender_id'] ? true : false;
                $category_id_required = !$value['academic_student_category_id'] ? true : false;

                if (count($request->ReligionSubjectList) > 0 && !$value['religion_subject_id']) {
                    $religion_subject_id_required = true;
                } else {
                    $religion_subject_id_required = false;
                }

                if ($birth_date_required || $religion_id_required || $gender_id_required) {
                  //  || $category_id_required || $religion_subject_id_required
                    $blank_data_arr['date_of_birth_required'] = $birth_date_required;
                    $blank_data_arr['religion_id_required'] = $religion_id_required;
                    $blank_data_arr['gender_id_required'] = $gender_id_required;
               //     $blank_data_arr['category_id_required'] = $category_id_required;
                //    $blank_data_arr['religion_subject_id_required'] = $religion_subject_id_required;

                    $blank_data_array[$key] = array_merge($value, $blank_data_arr);
                }
            }
        }


        $blank_data = collect($blank_data_array)->values();
        if (count($blank_data_array) > 0) {
            return Response::json([
                'message' => 'You must select/fillup Date of Birth, Religion, Gender', //Category & Religion Subject!
                'duplicate_student_array' => null,
                'required_data' => $blank_data,
                'duplicate_roll' => null,
                'mode' => 'Error'
            ], 200);
        }




        $roll_arr = $StudentList->pluck('student_roll_number')->filter();

        $data = $request->all();
        $student_duplicate_roll = StudentHistory::
            //            ->select('id', 'user_id', 'student_roll_number', 'student_roll_number_prefix')
            when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->whereIn('student_roll_number', $roll_arr)
            ->where('status', true)
            ->pluck('student_roll_number');

        if (count($student_duplicate_roll) > 0) {
            return Response::json([
                'message' => 'Duplicate Roll!',
                'duplicate_student_array' => null,
                'required_data' => null,
                'duplicate_roll' => $student_duplicate_roll,
                'mode' => 'Error'
            ], 200);
        }



        $duplicate_id = [];
        foreach ($StudentList as $key => $value) {

            if ($value['first_name'] && $value['father_name'] && $value['mother_name'] && $value['date_of_birth']) {


                $full_name_request = ($value['first_name']) . ($value['last_name'] ? $value['last_name'] : '');

                $date_formate = Carbon::parse($value['date_of_birth']);
                $date_of_birth = $date_formate->format('Y-m-d');

                $getStudentSameBirthDate = Student::where('site_id', Session::get('SITE_ID'))
                    ->where('date_of_birth', $date_of_birth)
                    ->select('id')
                    ->get();



                $student_birth_date_present_array = [];
                if (count($getStudentSameBirthDate) > 0) {

                    foreach ($getStudentSameBirthDate as $keys => $values) {



                        $full_name_with_out_space = strtoupper(str_replace(' ', '', $values->full_name));
                        $father_name_with_out_space = strtoupper(str_replace(' ', '', $values->father_name));
                        $mother_name_with_out_space = strtoupper(str_replace(' ', '', $values->mother_name));


                        $present_full_name_with_out_space = strtoupper(str_replace(' ', '', $full_name_request));
                        $present_father_name_with_out_space = strtoupper(str_replace(' ', '', $value['father_name']));
                        $present_mother_name_with_out_space = strtoupper(str_replace(' ', '', $value['mother_name']));



                        if (
                            $full_name_with_out_space == $present_full_name_with_out_space &&
                            $father_name_with_out_space == $present_father_name_with_out_space &&
                            $mother_name_with_out_space == $present_mother_name_with_out_space
                        ) {
                            $student_birth_date_present_array[] = 1;
                        }
                    }
                }


                $student_birth_date_present_count = collect($student_birth_date_present_array)->unique()->filter();
                if (count($student_birth_date_present_count) > 0) {
                    $student_birth_date_present = 1;
                } else {
                    $student_birth_date_present = 0;
                }


                if ($student_birth_date_present == 1) {
                    $duplicate_id[] = $value;
                }
            }
        }

        if (count($duplicate_id) > 0) {
            return Response::json([
                'message' => 'Duplicate Value!',
                'duplicate_student_array' => $duplicate_id,
                'required_data' => null,
                'duplicate_roll' => null,
                'mode' => 'Error'
            ], 200);
        }
    }


    private function studentUserNameCreateUseCode($requests)
    {
        $academicYear = AcademicYear::where('id', $requests->academic_year_id)->first();

        $start_date = Carbon::parse($academicYear->start_date)->format('d-m-Y');
        $onlyYear = explode("-", $start_date);
        $yearSelect = $onlyYear[2];
        //        $year= $start_date->format('Y');

        $yearCode = substr($yearSelect, 2, 2);

        $siteCode = sprintf("%03d", Session::get('SITE_ID'));

        $yearSiteCode = $yearCode . $siteCode;
        $yearSiteCodeLength = strlen($yearSiteCode);

        $userRows = UserForUsername::whereRaw("username REGEXP '^{$yearSiteCode}([0-9]*)?$'")
            ->orderBy('username', 'desc')
            ->first();

        if ($userRows) {
            $extructData = substr($userRows->username, $yearSiteCodeLength);
            $countValue = (int)$extructData;
            $countUser = $countValue + 1;
            $studentUserNameCre = $yearSiteCode . sprintf("%05d", $countUser);
        } else {
            $studentUserNameCre = $yearSiteCode . sprintf("%05d", 1);
        }

        return $studentUserNameCre;
    }



    private function academicSubjectList(Request $request, $student_data)
    {
        $data = $request->all();

        $subjectList = SubjectGroupConditionSetting::where('academic_class_id', $request->academic_class_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->get();

        $general_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

            $subjectCondition = SubjectCondition::where('condition_key', 'general')->first();

            if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                $general_subject_ids[$key] = $value->academic_subject_id;
            }
        }

        $general_markingless_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

            $markinglessSubjectCondition = SubjectCondition::where('condition_key', 'generalMarkingless')->first();

            if (in_array($markinglessSubjectCondition->id, $academicSubjectConditionIds)) {
                $general_markingless_subject_ids[$key] = $value->academic_subject_id;
            }
        }


        $compulsory_subject_ids = [];
        if ($request->academic_class_group_id) {

            foreach ($subjectList as $key => $value) {

                if ($value->academic_class_group_ids) {
                    $academicClassGroupIds = explode(',', $value->academic_class_group_ids);


                    if (in_array($request->academic_class_group_id, $academicClassGroupIds)) {
                        $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                        $subjectCondition = SubjectCondition::where('condition_key', 'compulsory')->first();

                        if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                            $compulsory_subject_ids[$key] = $value->academic_subject_id;
                        }
                    }
                }
            }
        }

        $compulsory_subject_idList = [];
        if ($student_data['compulsory_subject_ids']) {
            $compulsory_subject_idList = $student_data['compulsory_subject_ids'];
        }
        $Optional_subject_idList = [];
        if ($student_data['optional_subject_ids']) {
            $Optional_subject_idList = $student_data['optional_subject_ids'];
        }

        $selective_markingless_subject_idList = [];
        if ($student_data['selective_markingless_subject_ids']) {
            $selective_markingless_subject_idList = $student_data['selective_markingless_subject_ids'];
        }


        $religion_subject = [];
        if ($student_data['religion_subject_id']) {
            $religion_subject[] = $student_data['religion_subject_id'];
        }
        $Subjects = array_merge(
            $general_subject_ids,
            $general_markingless_subject_ids,
            $compulsory_subject_ids,
            $compulsory_subject_idList,
            $Optional_subject_idList,
            $selective_markingless_subject_idList,
            $religion_subject
        );

        $academicSubjectIds = (string)implode(',', $Subjects);
        $academicSubjectIdst = array_unique(explode(',', $academicSubjectIds));
        $finalAcademicSubjectIds = (string)implode(',', $academicSubjectIdst);

        return $finalAcademicSubjectIds;
    }


    public function quickMultipleStudentInsertFromExcel(Request $request)
    {

        $this->validate($request, [
            'academic_version_id' => 'required',
            'academic_year_id' => 'required',
            'academic_shift_id' => 'required',
            "academic_department_id" => 'required',
            "academic_class_id" => 'required',
        ]);

        $fileName = time() . '.' . $request->file->getClientOriginalExtension();
        $request->file->move(storage_path('pdf'), $fileName);


        $this->validate($request, [
            //'select_file' => 'required|mimes:xls,xlsx'
        ]);


        $import = new SiteStudentListImport;
        Excel::import($import, storage_path('pdf') . '/' . $fileName);
        $row_count = $import->getRowCount();

        //return $row_count;
        $StudentList = StudentHistoryExcel::where('site_id', Session::get('SITE_ID'))
            ->orderBy('roll_number')
            ->get();


        StudentHistoryExcel::where('site_id', Session::get('SITE_ID'))->delete();

        $genderList = Gender::get();
        $religionList = Religion::get();

        $data = $request->all();
        $studentCheckIds = StudentHistory::where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['site_batch_detail_id']), function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->pluck('user_id');


        $getStudentDetail = User::where('site_id', Session::get('SITE_ID'))
            ->select('id')
            ->whereIn('id', $studentCheckIds)
            ->get();


        foreach ($StudentList as $key => $value) {

            $check_student = $getStudentDetail->where('first_name', $value['student_name'])
                ->first();

            if ($value['mobile']) {
                $mobile_check = substr($value['mobile'], 0, 1);
                if ($mobile_check != 0) {
                    $mobile_number = str_pad($value['mobile'], 11, '0', STR_PAD_LEFT);
                } else {
                    $mobile_number = $value['mobile'];
                }
            } else {
                $mobile_number = null;
            }

            if (!$check_student) {

                $studentUsername = $this->studentUserNameCreateUseCode($request);
                $studentpassword = mt_rand(10000, 99999);

                $student = new Student();
                $studentHistory = new StudentHistory();

                $student_gender = $genderList->where('gender_name', $value['gender'])->first();
              //  dd($value['gender'], $student_gender);
                $student_geligion = $religionList->where('name', $value['religion'])->first();

                if(!$student_gender){
                   return Response::json(['message'=>'Gender name is not found!'],410);
                }


                if(!$student_geligion){
                   return Response::json(['message'=>'Religion name is not found!'],410);
                }


                $student->username = $studentUsername;
                $student->password = $studentpassword;
                $student->first_name = ucwords($value['student_name']);
                $student->father_name = ucwords($value['father_name']);
                $student->mother_name = ucwords($value['mother_name']);
                if ($value['date_of_birth']) {
                    $student->date_of_birth = $value['date_of_birth'];
                }
                $student->gender_id = $student_gender->id;
                $student->religion_id = $student_geligion->id;

                $student->academic_version_id = $request->academic_version_id;
                $student->academic_year_id = $request->academic_year_id;
                $student->academic_shift_id = $request->academic_shift_id;
                $student->academic_department_id = $request->academic_department_id;
                $student->academic_class_id = $request->academic_class_id;
                $student->site_batch_detail_id = $request->site_batch_detail_id;
                $student->academic_class_group_id = $request->academic_class_group_id;
                $student->academic_section_id = $request->academic_section_id;
                $student->academic_session_id = $request->academic_session_id;
                $student->student_roll_number = $value['roll_number'];

                $student->contact_number = $mobile_number;

                $student->user_type = 'student';
                $student->site_id = Session::get('SITE_ID');
                $student->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
                $student->status = 1;


                if ($student->save()) {
                    $roleStudent = SiteRole::where('key', 'student')->first();
                    $student->siteRoles()->attach([$roleStudent->id]);
                }

                //////
                $photo = new Photo();
                $photo->user_id = $student->id;
                $photo->imageable_id = $student->id;
                $photo->imageable_type = 'App\Models\Site\Student\Student';
                if ($student_gender->id == 30) {
                    $photo->name = 'student-boy.png';
                    $photo->path = 'uploads/student-boy.png';
                } else {
                    $photo->name = 'student-girl.png';
                    $photo->path = 'uploads/student-girl.png';
                }
                //////


                $studentHistory->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
                $studentHistory->site_id = Session::get('SITE_ID');
                $studentHistory->user_id = $student->id;

                $studentHistory->academic_version_id = $request->academic_version_id;
                $studentHistory->academic_year_id = $request->academic_year_id;
                $studentHistory->academic_shift_id = $request->academic_shift_id;
                $studentHistory->academic_department_id = $request->academic_department_id;
                $studentHistory->academic_class_id = $request->academic_class_id;
                $studentHistory->site_batch_detail_id = $request->site_batch_detail_id;
                $studentHistory->academic_class_group_id = $request->academic_class_group_id;
                $studentHistory->academic_section_id = $request->academic_section_id;
                $studentHistory->academic_session_id = $request->academic_session_id;
                $studentHistory->student_roll_number = $value['roll_number'];
                $studentHistory->board_registration_number = $value['board_registration_number'];

                $studentHistory->academic_student_category_id = 1;
                $studentHistory->academic_student_admission_type_id = 2;

                $studentHistory->status = 1;
                $studentHistory->created_by = Auth::user()->id;
                $studentHistory->save();
            } else {

                $check_student->contact_number = $mobile_number;
                $check_student->save();
                $check_student_history = StudentHistory::where('user_id', $check_student->id)->first();

                if ($check_student_history) {

                    $check_student_history->board_registration_number = $value['board_registration_number'];
                    $check_student_history->save();
                }
            }
        }

        return Response::json([
            'message' => 'Successfully Student Inserted.',
            'mode' => 'success'
        ], 200);
    }
}
