<?php

namespace App\Http\Controllers\Site\Student\TC;

use App\Models\Image\Photo;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\TC\SiteStudentTC;
use App\Models\Site\TC\SiteTcSetting;
use App\Models\Student\StudentHistory;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Result\SiteResultPrimarySetting;
use Illuminate\Support\Facades\Auth;
use App\Models\Site\Result\Testimonial\SiteManuallyTestimonialSetting;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Site\SiteInfo;
use App\Models\User\User;
use Image;
use PDF;
use Response;
use Session;
use File;


class StudentTCController extends Controller
{
    private $studentTC;
    private $tcSetting;
    private $carbon_now;

    public function __construct(SiteStudentTC $studentTC, SiteTcSetting $tcSetting)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->carbon_now = Carbon::now();
        $this->studentTC = $studentTC;
        $this->tcSetting = $tcSetting;


    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Student TC';
        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.site.student.TC.index',compact('viewType'));
    }


    public function getTCDataList(Request $request)
    {
        $siteStudentIDs = $this->returnSiteStudentIDs($request);

        $stdNumbers = collect($siteStudentIDs)->count();

        return [$siteStudentIDs, $stdNumbers];
    }

    private function returnSiteStudentIDs(Request $request)
    {

        $data = $request->all();
        $student_list=[];

        if ($request->academic_class_id) {

            $site_student_list = StudentHistory::with(['student' => function ($query) {
                $query->select('id','username');
            }])
                ->where('academic_version_id', $request->academic_version_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->select('id', 'user_id','student_roll_number','status')
                ->orderBy('student_roll_number')
                ->orderBy('academic_section_id')
                ->orderBy('academic_class_group_id')
                ->orderBy('academic_class_id')
                ->get();

            if($request->student_status=='active'){

                $site_student_list=$site_student_list->where('status',true);
                    $key=0;
                    foreach($site_student_list as $item){
                        $student_list[$key]['student_history_id']=$item->id;
                        $student_list[$key]['full_name']=$item->full_name;
                        $student_list[$key]['username']=$item->student->username;
                        $student_list[$key]['student_roll_number']=$item->student_roll_number;
                        $key++;
                    }

            }else{

                $student_history_ids=$site_student_list->pluck('id');

                $genareted_list=SiteStudentTC::with(['studentHistory' => function ($query) {
                        $query->select(['id', 'user_id','student_roll_number']);
                    }])
                    ->whereIn('student_history_id',$student_history_ids)
                    ->get();

                    $key=0;
                    foreach($genareted_list as $item){
                        $student_list[$key]['student_history_id']=$item->studentHistory->id;
                        $student_list[$key]['full_name']=$item->studentHistory->full_name;
                        $student_list[$key]['username']=$item->studentHistory->student->username;
                        $student_list[$key]['student_roll_number']=$item->studentHistory->student_roll_number;
                        $key++;
                    }
            }

        }

        return $student_list;

    }

    public function getTcSettingData()
    {
      //  $data = $request->all();
        $tc_setting=$this->tcSetting->first();


        if($tc_setting){

           // return $existing_setting_list;

            $prefix_present=$this->tcSetting->where('referance_prefix', $tc_setting->referance_prefix)
                ->Where('referance_suffix', $tc_setting->referance_suffix)
                ->where('referance_number', $tc_setting->referance_number)
                ->first();

                if($prefix_present){
                $arr=[
                    'ref_apply_status'=>true,
                    'edit_status'=>true,
                ];
            }
            else{
                $arr=[
                    'ref_apply_status'=>false,
                    'edit_status'=>true,
                ];
            }

            $setup_list=array_merge($tc_setting->toArray(), $arr);

        }
        else{
            $setup_list=[
                'logo_position'=> null,
                'border_image'=> null,
                'border_image_status'=> false,
                'watermark_image'=> null,
                'watermark_status'=> false,
                'address_present_status'=> true,
                'eiin_show_status'=> false,
                'college_code_show_status'=> false,
                'nu_code_show_status'=> false,
                'referance_number'=> null,
                'referance_prefix'=> null,
                'referance_suffix'=> null,

                'session_show_status'=>false,
                'tc_background_color'=>null,
                'edit_status'=>false,

            ];
        }

        return $setup_list;
    }


    public function createUpdateTCSetting(Request $request)
    {

        if(!$request->logo_position){
            return Response::json(['message' => 'Plese Select Logo Position!', 'mode' => 'Error'], 200);
        }

        if(!$request->referance_number){
            return Response::json(['message' => 'You Can not blank Initial Referance Number.!', 'mode' => 'Error'], 200);
        }



        $data = $request->all();

        $existing_setting_list=$this->tcSetting->first();


        if($existing_setting_list){

            if ($request->border_image == "borderimage.png") {
                $border_image = $request->border_image;

            }
            else if($request->border_image ==$existing_setting_list->border_image){
                $border_image=$existing_setting_list->border_image;
            }
            else {

                $image_path = "img/site/TC/" . $existing_setting_list->border_image;  // Value is not URL but directory file path
                if (File::exists($image_path)) {
                    File::delete($image_path);
                }



                $name = time().'border' . '.' . explode('/', explode(':', substr($request->border_image, 0, strpos($request->border_image, ';')))[1])[1];
                $border_image = $name;

                Image::make($request->border_image)
//                ->resize(440, 442)
                    ->save(public_path('img/site/TC/') . $name);
            }

        }
        else{

            if($request->border_image){
                if ($request->border_image == "borderimage.png") {
                    $border_image = $request->border_image;

                }

                else{

                    $name = time().'border' . '.' . explode('/', explode(':', substr($request->border_image, 0, strpos($request->border_image, ';')))[1])[1];
                    $border_image = $name;

                    Image::make($request->border_image)
//                ->resize(440, 442)
                        ->save(public_path('img/site/TC/') . $name);
                }
            }
            else{
                $border_image =null;
            }
        }

        if($existing_setting_list){
            if ($request->watermark_image == "watermarkimage.png") {
                $watermark_image = $request->watermark_image;

            }
            else if($request->watermark_image ==$existing_setting_list->watermark_image){
                $watermark_image=$existing_setting_list->watermark_image;
            }
            else {

                $image_path = "img/site/TC/" . $existing_setting_list->watermark_image;  // Value is not URL but directory file path
                if (File::exists($image_path)) {
                    File::delete($image_path);
                }

                $name = time() .'watermark'. '.' . explode('/', explode(':', substr($request->watermark_image, 0, strpos($request->watermark_image, ';')))[1])[1];
                $watermark_image = $name;

                Image::make($request->watermark_image)
//                ->resize(440, 442)
                    ->save(public_path('img/site/TC/') . $name);
            }
        }
        else{

            if($request->watermark_image){
                if ($request->watermark_image == "watermarkimage.png") {
                    $watermark_image = $request->watermark_image;
                }
                else {

                    $name = time() .'watermark'. '.' . explode('/', explode(':', substr($request->watermark_image, 0, strpos($request->watermark_image, ';')))[1])[1];
                    $watermark_image = $name;

                    Image::make($request->watermark_image)
                        ->save(public_path('img/site/TC/') . $name);
                }
            }
            else{
                $watermark_image =null;
            }
        }


        if($existing_setting_list){

            foreach ($existing_setting_list->ownFields as $ownFields) {
                if ($request->{$ownFields}) {
                        $existing_setting_list->{$ownFields} = $request->{$ownFields};
                }
            }
            $existing_setting_list->border_image=$border_image;
            $existing_setting_list->watermark_image=$watermark_image;

            $existing_setting_list->border_image=$border_image;
            $existing_setting_list->watermark_image=$watermark_image;
            $existing_setting_list->address_present_status=$request->address_present_status;
            $existing_setting_list->college_code_show_status=$request->college_code_show_status;
            $existing_setting_list->eiin_show_status=$request->eiin_show_status;
            $existing_setting_list->nu_code_show_status=$request->nu_code_show_status;
            $existing_setting_list->session_show_status=$request->session_show_status;
            $existing_setting_list->parents_title_status=$request->parents_title_status;
            $existing_setting_list->written_by_show_status=$request->written_by_show_status;
            $existing_setting_list->printed_date_show=$request->printed_date_show;

            $existing_setting_list->save();

           // dd('dfsf');

        }else{
           $siteTCSetting = new $this->tcSetting;

            foreach ($siteTCSetting->ownFields as $ownFields) {
                if ($request->{$ownFields}) {
                        $siteTCSetting->{$ownFields} = $request->{$ownFields};
                }
            }
            $siteTCSetting->border_image=$border_image;
            $siteTCSetting->watermark_image=$watermark_image;
            $siteTCSetting->address_present_status=$request->address_present_status;
            $siteTCSetting->college_code_show_status=$request->college_code_show_status;
            $siteTCSetting->eiin_show_status=$request->eiin_show_status;
            $siteTCSetting->nu_code_show_status=$request->nu_code_show_status;
            $siteTCSetting->session_show_status=$request->session_show_status;
            $siteTCSetting->parents_title_status=$request->parents_title_status;
            $siteTCSetting->written_by_show_status=$request->written_by_show_status;
            $siteTCSetting->printed_date_show=$request->printed_date_show;

            $siteTCSetting->save();
        }

        return Response::json(['message' => 'Transfer Certificate Setup Successfully!', 'mode' => 'Saved!'], 200);

    }

    public function getStudentTCSetup(Request $request){

        $data=$request->all();

        $academicClassList = [];
        $SiteInfoTableData = SiteInfoSetting::select('shift_ids','academic_class_ids','academic_department_ids','academic_year_ids', 'academic_version_ids')
        ->first();
        $academic_class_ids= explode(',', $SiteInfoTableData->academic_class_ids ?? null);


        $academicClass =SiteShiftClassGroupSectionSetting::
            where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->pluck('academic_class_id')
            ->unique()
            ->filter()
            ->toArray();

        $academicClassList = AcademicClass::whereIn('id', $academicClass)
            ->whereIn('id', $academic_class_ids)
            ->orderBy('serial_no', 'ASC')
            ->get();


        $site_info_settings = SiteInfoSetting::where('site_id',Session::get('SITE_ID'))->first();

        $site_exam_type_ids = explode(',', $site_info_settings->academic_result_primary_type_ids);
        $primaryResultTypeList= AcademicResultPrimaryType::whereIn('id',$site_exam_type_ids)->get();

        $checkTC=$this->studentTC->where('student_history_id',$request->student_history_id)->first();

        if($checkTC){
            $studentTC=$checkTC;

        }else{
            $TC=[
                'id'=>null,
                'student_history_id'=>"",
                'passing_year'=>"",
                'student_status'=>"",
                'institute_left_date'=>"",
                'payment_complition_date'=>"",
                'completed_class_id'=>null,
                'promoted_class_id'=>null,
                'examination_id'=>null,
                'gpa'=>"",
                'student_pass_fail_status'=>"",
                'reason'=>"",
                'behaviour'=>""
            ];

            $studentTC=$TC;
        }

        return response()->json([
            'class_list'=>$academicClassList,
            'result_type_list'=>$primaryResultTypeList,
            'studentTC'=>$studentTC,
        ],200);


    }

    public function createUpdateStudentTC(Request $request){

        $data=$request->all();

        $tc_setting=$this->tcSetting->first();
        if(!$tc_setting){
            return Response::json(['message','TC setting not found!', 'mode' => 'Error'],401);
        }

        $max_ref_number=$this->studentTC->max('referance_number');


      //  dd($checkTC);
            if(!$max_ref_number){
                $ref_num=$tc_setting->referance_number;
            }else{
                $ref_num=$max_ref_number+1;
            }


        $tc_no=$tc_setting->referance_prefix.$ref_num.$tc_setting->referance_suffix;

        //dd($this->carbon_now);
        $checkTC=$this->studentTC->where('student_history_id',$request->student_history_id)->first();

        if($checkTC){
            $studentTC= $checkTC;
            $studentTC->tc_updated_by=Auth::user()->id;
        }else{
            $studentTC= new $this->studentTC;
            $studentTC->tc_created_by=Auth::user()->id;
        }

        foreach ($studentTC->ownFields as $ownFields) {
            if ($request->{$ownFields}) {
                    $studentTC->{$ownFields} = $request->{$ownFields};
            }
           // dd($ref_num);
            $studentTC->generate_date=$this->carbon_now;
            $studentTC->tc_no=$tc_no;
            $studentTC->referance_prefix=$tc_setting->referance_prefix;
            $studentTC->referance_number=$ref_num;
            $studentTC->referance_suffix=$tc_setting->referance_suffix;
        }

        if( $studentTC->save()){
            $this->changeStudentStatus($request->student_history_id,0);
            return Response::json(['message'=>'TC generate and student pause successfully', 'mode' => 'success'],200);
        }

    }


    private function changeStudentStatus($history_id,$status)
    {

        $studentHistoryCheckList = StudentHistory::where('id', $history_id)->first();

        $student = User::where('id', $studentHistoryCheckList->user_id)->first();


        if ($student) {

            $studentMultiplicationCheck = StudentHistory::where('user_id', $student->id)->get('id', 'user_id');

            if (count($studentMultiplicationCheck) == 1) {
                if ($student->local_guardian_user_id) {
                    $guardianCount = User::where('local_guardian_user_id', $student->local_guardian_user_id)->get();
                    if (count($guardianCount) == 1) {
                        $guardian = User::where('id', $student->local_guardian_user_id)->first();
                        $guardian->status = $status;
                        $guardian->save();
                    }
                }


                $student->status = $status;
                $student->save();
            }
        }

        $studentHistoryCheckList->status = $status;
        $studentHistoryCheckList->save();

     //   return Response::json(['message' => 'Student Pause Successfully!', 'mode' => 'Update!']);
    }

    public function getStudentResult(Request $request){

        $data=$request->all();

        $result_primary_type_id=SiteResultPrimarySetting::where('status', true)
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->when(!empty($request->academic_class_group_id), function($q) use ($data){
                    $q->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($request->academic_department_id), function($q) use ($data){
                    $q->where('academic_department_id', $data['academic_department_id']);
                })
                ->where('academic_result_primary_type_id', $request->examination_id)
                ->pluck('academic_result_primary_type_id')
                ->first();


        $exam_result=SiteStudentPrimaryResultDetail::where('student_history_id', $data['student_history_id'])
                    ->where('academic_result_primary_type_id', $result_primary_type_id)
                    ->select('id','gpa','grade','fail_subject_count')
                    ->first();

        return $exam_result;


    }




    public function deleteStudentTC(Request $request){

        $studentTC=$this->studentTC->where('student_history_id',$request->student_history_id)->first();

        if($studentTC){
            if($studentTC->delete()){
                $this->changeStudentStatus($request->student_history_id,1);
            }
        }
        return Response::json(['message'=>'TC delete and student active successfully', 'mode' => 'success'],200);

    }


    public function TCPdfDownload(Request $request){

        // dd($request->all());
        ini_set('memory_limit', '-1');

        $page_tittle = "Transfer Certificate";
        $report_tittle = "<b>Transfer Certificate</b> <br/>";
        $report_tittle2 = " ";
        $title_view = "Transfer Certificate";

        $student_tc= $this->studentTC->with(['studentHistory'=>function($q){
                                $q->with('classGroup')
                                ->with(['student.gender'])
                                ->with(['student.section'])
                                ;
                            }])
                            ->where('student_history_id',$request->student_history_id)
                            ->first();
              //  dd($student_tc);
        //  return $student_tc;

        $tc_setting=$this->tcSetting->first();

        $data = $request->all();


        $site= SiteInfo::with(['district', 'photo', 'academicBoard'])
            ->where('id', Session::get('SITE_ID'))
            ->select('id', 'site_logo', 'district_id', 'academic_board_id','eiin','college_code','nu_code')
            ->first();


//        return compact('student_detail', 'site');

         $institute_head = Employee::where('institute_head', 1)->first();

     //   dd($institute_head);

        $signature = $institute_head->signature ?? '/img/signature/signature.png';
        $designation = $institute_head->designation->name ?? 'Institution Head';
    //    dd($tc_setting);



            if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.TC.site-student-tc-pdf')) {
                $pdf = PDF::loadView('custom.' . Session::get('ALIAS1') . '.student.TC.site-student-tc-pdf',
                      compact('student_tc', 'site', 'tc_setting', 'signature', 'designation', 'report_tittle',
                    'page_tittle', 'report_tittle2', 'title_view'))
                ->setPaper('a4', 'landscape')
                ->setWarnings(false);

            } else {
                $pdf = PDF::loadView('default.admin.site.student.TC.site-student-tc-pdf',
                compact('student_tc', 'site', 'tc_setting', 'signature', 'designation', 'report_tittle',
                    'page_tittle', 'report_tittle2', 'title_view'))
                ->setPaper('a4', 'landscape')
                ->setWarnings(false);
            }



        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json(['link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'], 200);

    }



    //==========================TC Application=============

    private function classGroupSectionValidation($request){

        $check_group_section=SiteShiftClassGroupSectionSetting::
        where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->first();

        if($check_group_section->academic_department_id && !$request->academic_department_id){
            return Response::json(['message' => 'Plese Select Department!', 'mode' => 'Error'], 200);
        }

        if($check_group_section->academic_class_group_id && !$request->academic_class_group_id){
            return Response::json(['message' => 'Plese Select Group!', 'mode' => 'Error'], 200);
        }

        if($check_group_section->academic_section_ids && !$request->academic_section_id){
            return Response::json(['message' => 'Plese Select Section!', 'mode' => 'Error'], 200);
        }

    }



    public function getStudentListForTcApplication(Request $request){

        $data=$request->all();

        $valiedation=$this->classGroupSectionValidation($request);
        if($valiedation){

            return $valiedation;
        }


        $student_list = StudentHistory::with(['student'=>function($query){
            $query->select('id');
        }])
            ->select('id', 'user_id', 'student_roll_number', 'student_roll_number_prefix',
                'registration_no', 'board_registration_number', 'board_roll_number')
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', true)
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_class_group_id', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('student_roll_number', 'ASC')
            ->get();



        return $student_list;

    }




}
