<?php



namespace App\Http\Controllers\Site\Web;



use App\Http\Controllers\ProjectController;

use App\Models\Site\SiteInfo;

use App\Models\Site\Web\ClassRoom\ClassRoom;

use App\Models\Site\Web\DesingSetting\SiteWebsiteHeaderDesign;

use App\Models\Site\Web\Event\Event;
use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;
use Response;

use App\Models\WebSite\WebsiteMenu;
use Session;
use Image;
use Storage;
use File;

class WebSiteSettingController extends ProjectController
{
    private $classRoom;

    public function __construct(ClassRoom $classRoom)
    {
        $this->classRoom = $classRoom;
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    public function master()
    {

        $viewType = "Web site Setting";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function webMenu($parent=null)
    {

        $viewType = "Web site Setting";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function eventEdit()
    {

        $viewType = "Web site Setting Edit";
        return view('default.admin.layouts.master', compact('viewType'));
    }



    public function socialIconSetting(Request $request){

        $site_list=SiteInfo::where('id', \Session::get('SITE_ID'))->first();

        $site_list->linkedin_link=$request->linkedin_link;
        $site_list->whatsapp_link=$request->whatsapp_link;
        $site_list->facebook_link=$request->facebook_link;
        $site_list->twitter_link=$request->twitter_link;
        $site_list->google_link=$request->google_link;
        $site_list->youtube_link=$request->youtube_link;
        $site_list->save();

        return Response::json(['message' => 'Update Successfully!', 'mode' => 'Save!'], 200);


    }


    public function getSocialIconSetting(){

        $site_list=SiteInfo::where('id', \Session::get('SITE_ID'))
            ->select('id', 'facebook_link', 'twitter_link', 'google_link', 'youtube_link','linkedin_link','whatsapp_link')
            ->first();

        return response()->json(
            [
                'iconList'=>$site_list,
            ]);

    }


//   ============================== current site infomation

public function getCurrentSiteInfo(){

   /// return \Session::get('SITE_ID');

    $site_info=SiteInfo::where('id', \Session::get('SITE_ID'))
        ->first();

    return response()->json($site_info,200);

}
//   ============================== header desing setting



    public function getWebHeaderDesign(){

        $site_list=SiteWebsiteHeaderDesign::where('site_id', \Session::get('SITE_ID'))->first();

        if($site_list){

            $desing=$site_list;

        }else{
            $desing=[
                'full_page_status'=>false,

                'header_top_background_color_change'=>'#004884',
                'header_top_phone_number_show_status'=>true,
                'header_top_web_mail_show_status'=>true,
                'header_top_social_icon_show_status'=>true,

                'bangabandhu_pic_show'=>true,
                'prime_minister_pic_show'=>true,
                'site_name_native_language_show'=>true,
                'site_address_show'=>true,
                'header_text_color'=>'#004884',
                'header_background_color'=>'#ffffff',
                'menu_text_color'=>'#ffffff',
                'menu_background_color'=>'#004884',
                'dropdown_menu_background_color'=>'#004884',
                'institute_logo_position'=>'center',


                'shuborno_joyonti_show_status'=>true,
                'slider_show_status'=>true,
                'slider_limit'=>3,

                'screen_modal_show_status'=>false,

                'special_image_show_status'=>false,
                'institute_template'=>'templateone',
                'home_page_background_color'=>'#F3F3DD',


                'message_show_status'=>true,
                'message_header_background_color'=>'#66CC9A',
                'message_header_text_color'=>'#FFFFFF',
                'message_sub_header_text_color'=>'#808080',


                'aboutus_show_status'=>true,
                'aboutus_header_background_color'=>'#B9E5F7',
                'aboutus_header_text_color'=>'#333333',
                'aboutus_sub_header_text_color'=>'#808080',


                'notice_show_status'=>true,
                'notice_header_background_color'=>'#66CC9A',
                'notice_subbox_background_color'=>'#97E1B5',
                'notice_header_text_color'=>'#FFFFFF',
                'notice_text_color'=>'#333333',


                'event_show_status'=>true,
                'event_header_background_color'=>'#FFFFFF',
                'event_header_text_color'=>'#333333',
                'event_subheader_text_color'=>'#808080',
                'event_text_color'=>'#333333',


                'visitor_count_show_status'=>true,
                'visitor_count_background_color'=>'#62A39F',
                'visitor_count_text_color'=>'#FFFFFF',
                'visitor_count_icon_color'=>'#FFFFFF',

                'video_show_status'=>false,


                'leading_video_show'=>false,
                'leading_video_header_background_color'=>'#62A39F',
                'leading_video_header_text_color'=>'#FFFFFF',

                'theme_background_color'=>'#4DBBDB',
                'theme_text_color'=>'#1E282C',
                'admission_button_show'=>false,
                'login_button_show'=>false,
                'google_map_show'=>false,
                'manual_student_list_show'=>false,

                'theme_language'=>'en',
                'eiin_show_status'=>false,
                'college_code_show_status'=>false,
                'nu_code_show_status'=>false,
                'dropdown_menu_background_color'=>'#004884',

                'bongobondhu_corner_show_staus'=>true,
                'institute_info_show_status'=>true,
                'academic_info_show_status'=>true,
                'download_show_status'=>true,
                'institute_corner_show_status'=>true,
                'employee_message_show_status'=>true,
                'management_message_show_status'=>true,
                'e_sheba_show_status'=>true,
                'official_link_show_status'=>true,
                'important_info_show_status'=>true,
                'education_board_show_status'=>true,
                'emergency_hotline_show_status'=>true,


            ];
        }

        return $desing;

    }



    public function createUpdateWebHeaderDesign(Request $request){

        $site_list=SiteWebsiteHeaderDesign::where('site_id', \Session::get('SITE_ID'))->first();


        if($site_list){
            $site_list->bangabandhu_pic_show = $request->bangabandhu_pic_show;
            $site_list->full_page_status = $request->full_page_status;

            $site_list->header_top_background_color_change = $request->header_top_background_color_change;
            $site_list->header_top_phone_number_show_status = $request->header_top_phone_number_show_status;
            $site_list->header_top_web_mail_show_status = $request->header_top_web_mail_show_status;
            $site_list->header_top_social_icon_show_status = $request->header_top_social_icon_show_status;

            $site_list->prime_minister_pic_show = $request->prime_minister_pic_show;
            $site_list->site_name_native_language_show = $request->site_name_native_language_show;
            $site_list->site_address_show = $request->site_address_show;
            $site_list->header_text_color = $request->header_text_color;
            $site_list->header_background_color = $request->header_background_color;
            $site_list->menu_text_color = $request->menu_text_color;
            $site_list->menu_background_color = $request->menu_background_color;
            $site_list->dropdown_menu_background_color = $request->dropdown_menu_background_color;
            $site_list->institute_logo_position = $request->institute_logo_position;
            $site_list->site_id = \Session::get('SITE_ID');


            $site_list->shuborno_joyonti_show_status = $request->shuborno_joyonti_show_status;
            $site_list->slider_show_status = $request->slider_show_status;
            $site_list->slider_limit = $request->slider_limit;

            $site_list->screen_modal_show_status = $request->screen_modal_show_status;


            $site_list->special_image_show_status = $request->special_image_show_status;
            $site_list->institute_template = $request->institute_template;
            $site_list->home_page_background_color = $request->home_page_background_color;



            $site_list->message_show_status = $request->message_show_status;
            $site_list->message_header_background_color = $request->message_header_background_color;
            $site_list->message_header_text_color = $request->message_header_text_color;
            $site_list->message_sub_header_text_color = $request->message_sub_header_text_color;


            $site_list->aboutus_show_status = $request->aboutus_show_status;
            $site_list->aboutus_header_background_color = $request->aboutus_header_background_color;
            $site_list->aboutus_header_text_color = $request->aboutus_header_text_color;
            $site_list->aboutus_sub_header_text_color = $request->aboutus_sub_header_text_color;

            $site_list->notice_show_status = $request->notice_show_status;
            $site_list->notice_header_background_color = $request->notice_header_background_color;
            $site_list->notice_subbox_background_color = $request->notice_subbox_background_color;
            $site_list->notice_header_text_color = $request->notice_header_text_color;
            $site_list->notice_text_color = $request->notice_text_color;

            $site_list->event_show_status = $request->event_show_status;
            $site_list->event_header_background_color = $request->event_header_background_color;
            $site_list->event_header_text_color = $request->event_header_text_color;
            $site_list->event_subheader_text_color = $request->event_subheader_text_color;
            $site_list->event_text_color = $request->event_text_color;

            $site_list->visitor_count_show_status = $request->visitor_count_show_status;
            $site_list->visitor_count_background_color = $request->visitor_count_background_color;
            $site_list->visitor_count_text_color = $request->visitor_count_text_color;
            $site_list->visitor_count_icon_color = $request->visitor_count_icon_color;

            $site_list->video_show_status = $request->video_show_status;

            $site_list->leading_video_show = $request->leading_video_show;
            $site_list->leading_video_header_background_color = $request->leading_video_header_background_color;
            $site_list->leading_video_header_text_color = $request->leading_video_header_text_color;

            $site_list->theme_background_color = $request->theme_background_color;
            $site_list->theme_text_color = $request->theme_text_color;
            $site_list->admission_button_show = $request->admission_button_show;
            $site_list->login_button_show = $request->login_button_show;
            $site_list->google_map_show = $request->google_map_show;
            $site_list->manual_student_list_show = $request->manual_student_list_show;

            $site_list->theme_language = $request->theme_language;
            $site_list->eiin_show_status = $request->eiin_show_status;
            $site_list->college_code_show_status = $request->college_code_show_status;
            $site_list->nu_code_show_status = $request->nu_code_show_status;

            $site_list->custom_button_show_status = $request->custom_button_show_status;
            $site_list->custom_button_title = $request->custom_button_title;
            $site_list->custom_button_link = $request->custom_button_link;

            $site_list->bongobondhu_corner_show_staus = $request->bongobondhu_corner_show_staus;
            $site_list->institute_info_show_status = $request->institute_info_show_status;
            $site_list->academic_info_show_status = $request->academic_info_show_status;
            $site_list->download_show_status = $request->download_show_status;
            $site_list->institute_corner_show_status = $request->institute_corner_show_status;
            $site_list->employee_message_show_status = $request->employee_message_show_status;
            $site_list->management_message_show_status = $request->management_message_show_status;
            $site_list->e_sheba_show_status = $request->e_sheba_show_status;
            $site_list->official_link_show_status = $request->official_link_show_status;
            $site_list->important_info_show_status = $request->important_info_show_status;
            $site_list->education_board_show_status = $request->education_board_show_status;
            $site_list->emergency_hotline_show_status = $request->emergency_hotline_show_status;

            $site_list->save();
        }
        else{
            $desing= new SiteWebsiteHeaderDesign();

            $desing->full_page_status = $request->full_page_status;

            $desing->header_top_background_color_change = $request->header_top_background_color_change;
            $desing->header_top_phone_number_show_status = $request->header_top_phone_number_show_status;
            $desing->header_top_web_mail_show_status = $request->header_top_web_mail_show_status;
            $desing->header_top_social_icon_show_status = $request->header_top_social_icon_show_status;

            $desing->bangabandhu_pic_show = $request->bangabandhu_pic_show;
            $desing->prime_minister_pic_show = $request->prime_minister_pic_show;
            $desing->site_name_native_language_show = $request->site_name_native_language_show;
            $desing->site_address_show = $request->site_address_show;
            $desing->header_text_color = $request->header_text_color;
            $desing->header_background_color = $request->header_background_color;
            $desing->menu_text_color = $request->menu_text_color;
            $desing->menu_background_color = $request->menu_background_color;
            $desing->dropdown_menu_background_color = $request->dropdown_menu_background_color;
            $desing->institute_logo_position = $request->institute_logo_position;
            $desing->site_id = \Session::get('SITE_ID');


            $desing->shuborno_joyonti_show_status = $request->shuborno_joyonti_show_status;
            $desing->slider_show_status = $request->slider_show_status;
            $desing->slider_limit = $request->slider_limit;

            $desing->screen_modal_show_status = $request->screen_modal_show_status;

            $desing->special_image_show_status = $request->special_image_show_status;
            $desing->institute_template = $request->institute_template;
            $desing->home_page_background_color = $request->home_page_background_color;


            $desing->message_show_status = $request->message_show_status;
            $desing->message_header_background_color = $request->message_header_background_color;
            $desing->message_header_text_color = $request->message_header_text_color;
            $desing->message_sub_header_text_color = $request->message_sub_header_text_color;


            $desing->aboutus_show_status = $request->aboutus_show_status;
            $desing->aboutus_header_background_color = $request->aboutus_header_background_color;
            $desing->aboutus_header_text_color = $request->aboutus_header_text_color;
            $desing->aboutus_sub_header_text_color = $request->aboutus_sub_header_text_color;

            $desing->notice_show_status = $request->notice_show_status;
            $desing->notice_header_background_color = $request->notice_header_background_color;
            $desing->notice_subbox_background_color = $request->notice_subbox_background_color;
            $desing->notice_header_text_color = $request->notice_header_text_color;
            $desing->notice_text_color = $request->notice_text_color;

            $desing->event_show_status = $request->event_show_status;
            $desing->event_header_background_color = $request->event_header_background_color;
            $desing->event_header_text_color = $request->event_header_text_color;
            $desing->event_subheader_text_color = $request->event_subheader_text_color;
            $desing->event_text_color = $request->event_text_color;


            $desing->visitor_count_show_status = $request->visitor_count_show_status;
            $desing->visitor_count_background_color = $request->visitor_count_background_color;
            $desing->visitor_count_text_color = $request->visitor_count_text_color;
            $desing->visitor_count_icon_color = $request->visitor_count_icon_color;

            $desing->video_show_status = $request->video_show_status;

            $desing->leading_video_show = $request->leading_video_show;
            $desing->leading_video_header_background_color = $request->leading_video_header_background_color;
            $desing->leading_video_header_text_color = $request->leading_video_header_text_color;

            $desing->theme_background_color = $request->theme_background_color;
            $desing->theme_text_color = $request->theme_text_color;
            $desing->admission_button_show = $request->admission_button_show;
            $desing->login_button_show = $request->login_button_show;
            $desing->google_map_show = $request->google_map_show;
            $desing->manual_student_list_show = $request->manual_student_list_show;

            $desing->theme_language = $request->theme_language;
            $desing->eiin_show_status = $request->eiin_show_status;
            $desing->college_code_show_status = $request->college_code_show_status;
            $desing->nu_code_show_status = $request->nu_code_show_status;

            $desing->custom_button_show_status = $request->custom_button_show_status;
            $desing->custom_button_title = $request->custom_button_title;
            $desing->custom_button_link = $request->custom_button_link;

            $desing->bongobondhu_corner_show_staus = $request->bongobondhu_corner_show_staus;
            $desing->institute_info_show_status = $request->institute_info_show_status;
            $desing->academic_info_show_status = $request->academic_info_show_status;
            $desing->download_show_status = $request->download_show_status;
            $desing->institute_corner_show_status = $request->institute_corner_show_status;
            $desing->employee_message_show_status = $request->employee_message_show_status;
            $desing->management_message_show_status = $request->management_message_show_status;
            $desing->e_sheba_show_status = $request->e_sheba_show_status;
            $desing->official_link_show_status = $request->official_link_show_status;
            $desing->important_info_show_status = $request->important_info_show_status;
            $desing->education_board_show_status = $request->education_board_show_status;
            $desing->emergency_hotline_show_status = $request->emergency_hotline_show_status;

            $desing->save();
        }

        return Response::json(['message' => 'Update Successfully!', 'mode' => 'Save!'], 200);

    }


}
