<?php

namespace App\Http\Controllers\Site\Payroll;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Event\Event;
use App\Models\Site\Payroll\SiteAllowance;
use App\Models\Site\Payroll\SiteBaseSalary;
use App\Models\Site\Payroll\SiteBonus;
use App\Models\Site\Payroll\SiteDeduction;
use App\Models\Site\Payroll\SiteEmployeeAttendance;
use App\Models\Site\Payroll\SiteEmployeePayroll;
use Illuminate\Support\Facades\DB;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Employee\EmployeeAttendance;
use App\Models\Site\Payroll\SiteAllowanceType;
use App\Models\Site\Payroll\SiteBonusType;
use App\Models\Site\Payroll\SiteDeductionType;
use App\Models\User\User;
use Carbon\Carbon;
use Exception;

class PayrollController extends Controller
{
    private $employee;
    private $SiteEmployeeAttendance;

    public function __construct(Employee $employee, SiteEmployeeAttendance $SiteEmployeeAttendance)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->employee = $employee;
        $this->SiteEmployeeAttendance = $SiteEmployeeAttendance;
    }
    public function index()
    {
        $viewType = 'Payroll';

        return view('default.admin.layouts.master', compact('viewType'));
    }
    public function report()
    {
        $viewType = 'report';

        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function siteGetBonusType()
    {
        $SiteBonusType = SiteBonusType::get();
        return response()->json($SiteBonusType, 200);
    }
    public function siteGetAllowanceTypeType()
    {
        $SiteAllowanceType = SiteAllowanceType::get();
        return response()->json($SiteAllowanceType, 200);
    }
    public function siteGetDeductionType()
    {
        $SiteDeductionType = SiteDeductionType::get();
        return response()->json($SiteDeductionType, 200);
    }
    public function DeleteDeductionType(Request $request)
    {
        $SiteDeductionType = SiteDeductionType::find($request->id)->delete();
        return response()->json($SiteDeductionType, 200);
    }
    public function DeleteAllowanceType(Request $request)
    {
        $SiteAllowanceType = SiteAllowanceType::find($request->id)->delete();
        return response()->json($SiteAllowanceType, 200);
    }
    public function DeleteBonusType(Request $request)
    {
        $SiteBonusType = SiteBonusType::find($request->id)->delete();
        return response()->json($SiteBonusType, 200);
    }

    public function StoreBaseSallery(Request $request)
    {
        foreach ($request->base_sallery as $user_id => $value) {
            if (SiteBaseSalary::where('user_id', $user_id)->first()) {
                SiteBaseSalary::where('user_id', $user_id)->update([
                    'user_id' => $user_id,
                    'base_sallery' => $value,
                ]);
            } else {
                SiteBaseSalary::insert([
                    'user_id' => $user_id,
                    'base_sallery' => $value,
                ]);
            }
        }
        return 'done';
    }
    public function getEmployeeBaseSallery()
    {
        $site_base_sallery = SiteBaseSalary::get();
        return response()->json($site_base_sallery, 200);
    }
    public function getEmployeeAttendance(Request $request)
    {
        $year = $request->selectedYear;
        $month = $request->selectedMonth;
        $firstDayOfMonth = mktime(0, 0, 0, $month, 1, $year);

        $TotlaDayOfMonth = date('t', $firstDayOfMonth);

        $offDayOfMonth = Event::whereYear('activate_date', '=', $year)
            ->whereMonth('activate_date', '=', $month)
            ->where('status', 1)
            ->with('academicCalendarHead')
            ->count();

        $site_employee_attendances = EmployeeAttendance::select(
            'user_id',
            DB::raw("count(*) as total_attedence"),
            DB::raw("SUM(late_status) as total_late_status")
        )
            ->where('present_year', $year)
            ->where('present_month', $month)
            ->groupBy('user_id')
            ->get();

        $site_employee_attendances->transform(function ($value) use ($offDayOfMonth, $TotlaDayOfMonth) {
            return [
                'user_id'           => $value->user_id,
                'was_present'       =>  $value,
                'was_absent'        => $TotlaDayOfMonth - ($value->total_attedence + $offDayOfMonth) ?? 0,
                'total_late_status' => $value->total_late_status ?? 0,
                'offDayOfMonth'     => $offDayOfMonth ?? 0,
            ];
        });

        return response()->json([
            'site_employee_attendance' => $site_employee_attendances,
            'TotlaDayOfMonth' => $TotlaDayOfMonth,
        ], 200);
    }
    public function getEmployeeUpdateAttendance(Request $request)
    {


        $EmployeeList = $request->EmployeeList;
        $manually_attendance = $request->manually_attendance;


        foreach ($manually_attendance as $id => $value) {
            foreach ($EmployeeList as $key => $employee) {
                if ($employee['id'] == $id) {
                    $EmployeeList[$key]['employee_manually_attendance'] = $value;
                    break;
                }
            }
        }


        $year = $request->selectedYear;
        $month = $request->selectedMonth;



        $siteEmployeeAttendance = $this->SiteEmployeeAttendance
            ->whereIn('user_id', array_column($EmployeeList, 'id'))
            ->where('month', $month)
            ->where('year', $year)
            ->get();

        foreach ($EmployeeList as $employee) {


            $siteEmployeeAttendanceRecord = $siteEmployeeAttendance->where('user_id', $employee['id'])->first();

            if (!$siteEmployeeAttendanceRecord) {
                $siteEmployeeAttendanceRecord = new SiteEmployeeAttendance();
                $siteEmployeeAttendanceRecord->user_id = $employee['id'];

                $siteEmployeeAttendanceRecord->was_present         = $employee['total_device_attendence'];
                $siteEmployeeAttendanceRecord->off_day             = $employee['offDayOfMonth'];
                $siteEmployeeAttendanceRecord->late_day            = $employee['total_late_status'];
                $siteEmployeeAttendanceRecord->academic_day        = $employee['TotalAcademicDay'];
                $siteEmployeeAttendanceRecord->manually_attendance = $employee['employee_manually_attendance'];
                $siteEmployeeAttendanceRecord->total_present       = $employee['offDayOfMonth'] + $employee['total_device_attendence'] + $employee['employee_manually_attendance'];

                if ($request->countable_absent) {
                    $siteEmployeeAttendanceRecord->countable_absent = $request->countable_absent;
                } else {
                    $siteEmployeeAttendanceRecord->countable_absent = $employee['countable_absent'];
                }

                if ($request->countable_late) {
                    $siteEmployeeAttendanceRecord->countable_late = $request->countable_late;
                } else {
                    $siteEmployeeAttendanceRecord->countable_late = $employee['countable_late'];
                }

                if ($request->countable_unpaid_leave) {

                    $siteEmployeeAttendanceRecord->countable_unpaid_leave = $request->countable_unpaid_leave;
                } else {

                    $siteEmployeeAttendanceRecord->countable_unpaid_leave = $employee['countable_unpaid_leave'];
                }

                if ($request->countable_half_day_leave) {

                    $siteEmployeeAttendanceRecord->countable_half_day_leave = $request->countable_half_day_leave;
                } else {
                    $siteEmployeeAttendanceRecord->countable_half_day_leave = $employee['countable_half_day_leave'];
                }


                $siteEmployeeAttendanceRecord->total_leave = $employee['total_without_unpaid_leave'];
                $siteEmployeeAttendanceRecord->total_unpaid_leave = $employee['total_unpaid_leave'];
                $siteEmployeeAttendanceRecord->total_half_day_leave = $employee['total_half_day_leave'];
                $siteEmployeeAttendanceRecord->month = $month;
                $siteEmployeeAttendanceRecord->year = $year;
                $siteEmployeeAttendanceRecord->save();
            }

            $siteEmployeeAttendanceRecord->was_present         = $employee['total_device_attendence'];
            $siteEmployeeAttendanceRecord->off_day             = $employee['offDayOfMonth'];
            $siteEmployeeAttendanceRecord->late_day            = $employee['total_late_status'];
            $siteEmployeeAttendanceRecord->academic_day        = $employee['TotalAcademicDay'];
            $siteEmployeeAttendanceRecord->total_present       = $employee['offDayOfMonth'] + $employee['total_device_attendence'] + $employee['employee_manually_attendance'];
            $siteEmployeeAttendanceRecord->manually_attendance = $employee['employee_manually_attendance'];
            $siteEmployeeAttendanceRecord->month               = $month;
            $siteEmployeeAttendanceRecord->year                = $year;

            if ($request->countable_absent) {
                $siteEmployeeAttendanceRecord->countable_absent = $request->countable_absent;
            } else {
                $siteEmployeeAttendanceRecord->countable_absent = $employee['countable_absent'];
            }

            if ($request->countable_late) {
                $siteEmployeeAttendanceRecord->countable_late = $request->countable_late;
            } else {
                $siteEmployeeAttendanceRecord->countable_late = $employee['countable_late'];
            }

            if ($request->countable_unpaid_leave) {

                $siteEmployeeAttendanceRecord->countable_unpaid_leave = $request->countable_unpaid_leave;
            } else {

                $siteEmployeeAttendanceRecord->countable_unpaid_leave = $employee['countable_unpaid_leave'];
            }

            if ($request->countable_half_day_leave) {

                $siteEmployeeAttendanceRecord->countable_half_day_leave = $request->countable_half_day_leave;
            } else {

                $siteEmployeeAttendanceRecord->countable_half_day_leave = $employee['countable_half_day_leave'];
            }

            $siteEmployeeAttendanceRecord->total_leave = $employee['total_without_unpaid_leave'];
            $siteEmployeeAttendanceRecord->total_unpaid_leave = $employee['total_unpaid_leave'];
            $siteEmployeeAttendanceRecord->total_half_day_leave = $employee['total_half_day_leave'];

            $siteEmployeeAttendanceRecord->save();
        }
    }

    public function StoreEmployeePayrollBonus(Request $request)
    {
        $request->validate([
            'bonus_type' => 'required',
            'bonus_date' => 'required',
        ]);
        foreach ($request->bonus_amount as $user_id => $bonus_amount) {
            SiteBonus::insert([
                'user_id'      => $user_id,
                'bonus_type'   => $request->bonus_type,
                'bonus_amount' => $bonus_amount,
                'bonus_date'   => $request->bonus_date,
            ]);
        }
    }
    public function StoreEmployeePayrollDeduction(Request $request)
    {

        $request->validate([
            'deduction_type' => 'required',
            'deduction_date' => 'required',
        ]);
        foreach ($request->deduction_amount as $user_id => $deduction_amount) {
            SiteDeduction::insert([
                'user_id' => $user_id,
                'deduction_type'   => $request->deduction_type,
                'deduction_amount' => $deduction_amount,
                'deduction_date'   => $request->deduction_date,
            ]);
        }
    }
    public function StoreEmployeePayrollAllowance(Request $request)
    {

        $request->validate([
            'allowance_type' => 'required',
            'allowance_date' => 'required',
        ]);
        foreach ($request->allowance_amount as $user_id => $allowance_amount) {
            SiteAllowance::insert([
                'user_id'          => $user_id,
                'allowance_type'   => $request->allowance_type,
                'allowance_amount' => $allowance_amount,
                'allowance_date'   => $request->allowance_date,
            ]);
        }
    }
    public function StoreEmployeePayroll(Request $request)
    {
        // return $request;

        $year             = $request->selectedYear;
        $year             = $request->selectedYear;
        $month            = $request->selectedMonth;
        $firstDayOfMonth  = mktime(0, 0, 0, $month, 1, $year);

        $TotlaAcademicDay = date('t', $firstDayOfMonth);
        $payDate          = Carbon::create("$TotlaAcademicDay-$month-$year")->format('Y-m-d');
        $targetMonth      = Carbon::create($year, $month, 1)->format('Y-m');

        foreach ($request->employeeId as $key => $employee) {

            $employee = $this->employee
                ->with(['designation'])
                ->with('BaseSalery')
                ->with([
                    'EmployeeAttendance'  => function ($query) use ($year, $month) {
                        $query->where('year', $year)
                            ->where('month', $month);
                    }
                ])
                ->with([
                    'Allowances' => function ($query) use ($targetMonth) {
                        $query->select(
                            'user_id',
                            DB::raw('SUM(allowance_amount) as total_allowance_amount')
                        )
                            ->where(DB::raw('DATE_FORMAT(allowance_date, "%Y-%m")'), $targetMonth)
                            ->groupBy('user_id');
                    }
                ])
                ->with([
                    'payrolls'  => function ($query) use ($targetMonth) {
                        $query->select(
                            'user_id',
                            'late_status_count',
                            'absent_count',

                        )
                            ->where(DB::raw('DATE_FORMAT(pay_date, "%Y-%m")'), $targetMonth)
                            ->groupBy('user_id');
                    }
                ])
                ->with([
                    'Bonus' => function ($query) use ($targetMonth) {
                        $query->select(
                            'user_id',
                            DB::raw('SUM(bonus_amount) as total_bonus_amount')
                        )
                            ->where(DB::raw('DATE_FORMAT(bonus_date, "%Y-%m")'), $targetMonth)
                            ->groupBy('user_id');
                    }
                ])
                ->with([
                    'Deductions' => function ($query) use ($targetMonth) {
                        $query->select(
                            'user_id',
                            DB::raw('SUM(deduction_amount) as total_deduction_amount')
                        )
                            ->where(DB::raw('DATE_FORMAT(deduction_date, "%Y-%m")'), $targetMonth)
                            ->groupBy('user_id');
                    }
                ])
                ->select('id', 'username', 'user_type')
                ->find($employee);




            $EmployeeAttendance =  $employee->EmployeeAttendance->first();

            $EmployeePayrolls   =  $employee->payrolls->first();



            $data                    = [];
            $data['user_id']         = $employee->id;

            $data['base_salary']     = round($employee->BaseSalery['base_sallery'] ?? 0);

            $data['total_bonus']     = round($employee->Bonus[0]->total_bonus_amount ?? 0);

            if ($EmployeeAttendance !== null) {
                $data['total_present'] = ($EmployeeAttendance['was_present'] ?? 0) + ($EmployeeAttendance['off_day'] ?? 0) + ($EmployeeAttendance['total_leave'] ?? 0) + ($EmployeeAttendance['manually_attendance'] ?? 0);
            } else {
                $data['total_present'] = 0;
            }

            $data['total_late']             = $EmployeeAttendance->late_day ?? 0;
            $data['countable_late']         = $EmployeeAttendance->countable_late ?? 0;
            $data['countable_absent']       = $EmployeeAttendance->countable_absent ?? 0;
            $data['countable_unpaid_leave'] = $EmployeeAttendance->countable_unpaid_leave ?? 0;
            $data['countable_half_day_leave'] = $EmployeeAttendance->countable_half_day_leave ?? 0;

            $data['total_unpaid_leave']     = $EmployeeAttendance->total_unpaid_leave ?? 0;
            $data['total_half_day_leave']   = $EmployeeAttendance->total_half_day_leave ?? 0;


            if ($TotlaAcademicDay - $data['total_present'] < 0) {
                $totalabsent = 0;
            } else {
                $totalabsent = $TotlaAcademicDay - $data['total_present'];
            }

            $data['total_absent']    =  $totalabsent;

            $data['total_allowance'] = round($employee->Allowances[0]->total_allowance_amount ?? 0);
            $data['total_deduction'] = round($employee->Deductions[0]->total_deduction_amount  ?? 0);

            $data['month']           = $month;
            $data['year']            = $year;

            if ($request->late_status_count) {
                $data['late_status_count'] =  $request->late_status_count;
            } else {

                if ($EmployeePayrolls !== null) {
                    $data['late_status_count'] =  $EmployeePayrolls->late_status_count;
                } else {
                    $data['late_status_count'] =  0;
                }
            }

            if ($request->absent_count) {
                $data['absent_count']    = $request->absent_count;
            } else {

                if ($EmployeePayrolls !== null) {
                    $data['absent_count']    = $EmployeePayrolls->absent_count;
                } else {
                    $data['absent_count']    = 0;
                }
            }

            if ($request->unpaid_leave_count) {
                $data['unpaid_leave_count']    = $request->unpaid_leave_count;
            } else {

                if ($EmployeePayrolls !== null) {
                    $data['unpaid_leave_count']    = $EmployeePayrolls->unpaid_leave_count;
                } else {
                    $data['unpaid_leave_count']    = 0;
                }
            }

            if ($request->unpaid_leave_count) {
                $data['unpaid_leave_count']    = $request->unpaid_leave_count;
            } else {

                if ($EmployeePayrolls !== null) {
                    $data['unpaid_leave_count']    = $EmployeePayrolls->unpaid_leave_count;
                } else {
                    $data['unpaid_leave_count']    = 0;
                }
            }

            if ($request->half_day_leave_count) {
                $data['half_day_leave_count']    = $request->half_day_leave_count;
            } else {

                if ($EmployeePayrolls !== null) {
                    $data['half_day_leave_count']    = $EmployeePayrolls->half_day_leave_count;
                } else {
                    $data['half_day_leave_count']    = 0;
                }
            }

            $data['pay_date']          = $payDate;






            $EmployeePayroll = SiteEmployeePayroll::where('user_id', $data['user_id'])
                ->where('month', $data['month'])
                ->where('year', $data['year'])
                ->first();

            if ($EmployeePayroll) {
                $EmployeePayroll->base_salary       = $data['base_salary'];
                $EmployeePayroll->total_bonus       = $data['total_bonus'];
                $EmployeePayroll->total_present     = $data['total_present'];
                $EmployeePayroll->total_absent      = $data['total_absent'];

                $EmployeePayroll->total_late             = $data['total_late'];
                $EmployeePayroll->absent_count           = $data['absent_count'];
                $EmployeePayroll->late_status_count      = $data['late_status_count'];
                $EmployeePayroll->unpaid_leave_count     = $data['unpaid_leave_count'];
                $EmployeePayroll->half_day_leave_count     = $data['half_day_leave_count'];
                $EmployeePayroll->total_half_day_leave     = $data['total_half_day_leave'];
                $EmployeePayroll->total_unpaid_leave     = $data['total_unpaid_leave'];
                $EmployeePayroll->countable_unpaid_leave =  $data['countable_unpaid_leave'];
                $EmployeePayroll->countable_half_day_leave =  $data['countable_half_day_leave'];

                $EmployeePayroll->total_allowance   = $data['total_allowance'];
                $EmployeePayroll->total_deduction   = $data['total_deduction'];
                $EmployeePayroll->month             = $data['month'];
                $EmployeePayroll->year              = $data['year'];
                $EmployeePayroll->pay_date          = $data['pay_date'];
                $EmployeePayroll->countable_absent  = $data['countable_absent'];
                $EmployeePayroll->countable_late    = $data['countable_late'];
                $EmployeePayroll->save();
            } else {
                $EmployeePayroll                    = new SiteEmployeePayroll();
                $EmployeePayroll->user_id           = $data['user_id'];
                $EmployeePayroll->base_salary       = $data['base_salary'];
                $EmployeePayroll->total_bonus       = $data['total_bonus'];
                $EmployeePayroll->total_present     = $data['total_present'];
                $EmployeePayroll->total_absent      = $data['total_absent'];

                $EmployeePayroll->total_late             = $data['total_late'];
                $EmployeePayroll->absent_count           = $data['absent_count'];
                $EmployeePayroll->late_status_count      = $data['late_status_count'];
                $EmployeePayroll->unpaid_leave_count     = $data['unpaid_leave_count'];
                $EmployeePayroll->half_day_leave_count     = $data['half_day_leave_count'];
                $EmployeePayroll->total_half_day_leave     = $data['total_half_day_leave'];
                $EmployeePayroll->total_unpaid_leave     = $data['total_unpaid_leave'];
                $EmployeePayroll->countable_unpaid_leave =  $data['countable_unpaid_leave'];
                $EmployeePayroll->countable_half_day_leave =  $data['countable_half_day_leave'];

                $EmployeePayroll->total_allowance   = $data['total_allowance'];
                $EmployeePayroll->total_deduction   = $data['total_deduction'];
                $EmployeePayroll->month             = $data['month'];
                $EmployeePayroll->year              = $data['year'];
                $EmployeePayroll->pay_date          = $data['pay_date'];
                $EmployeePayroll->countable_absent  = $data['countable_absent'];
                $EmployeePayroll->countable_late    = $data['countable_late'];
                $EmployeePayroll->save();
            }
        }
    }
}
