<?php

namespace App\Http\Controllers\SiteGroup\Admission;

use App\Models\Academic\AcademicAdmissionStyle;
use App\Models\Academic\AcademicAdmissionTestResultType;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Examinations\Examination;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Site\SiteGroupSetting;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Site\StudentAdmission\GlobalSiteAdmissionMeritList;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionApplication;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionDeclare;
use App\Models\Site\StudentAdmission\SiteAdmissionMeritList;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionApplication;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionDeclare;
use App\Models\SiteGroup\Admission\SiteGroupAdmissionDeclare;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Models\User\GlobalUser;
use App\Models\User\User;
use App\Models\User\UserTranslation;
use DB;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Validation\ValidationException;
use Response;
use Session;

class SiteGroupAdmissionDeclareController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');

    }


    public function index()
    {
        $viewType = 'Admission Declare';
        return view('default.admin.layouts.master', compact('viewType'));

    }



    public function getYearDeptClassShiftVersionSessionAdmissionDeclareList()
    {





        $site_group_setting = SiteGroupSetting::where('site_group_id', Session::get('SITE_GROUP_ID'))
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->first();



        $site_group=GlobalSiteGroup::where('id', $site_group_setting->site_group_id)->first();


        $academic_version_ids = explode(',', $site_group_setting->academic_version_ids) ?? null;
        $academicVersionList = AcademicVersion::select('id', 'version_name')
            ->whereIn('id', $academic_version_ids)
            ->get();


        $shift_ids = explode(',', $site_group_setting->shift_ids) ?? null;
        $shiftList = AcademicShift::select('id')
            ->whereIn('id', $shift_ids)
            ->get();


        $academic_year_ids = explode(',', $site_group_setting->academic_year_ids) ?? null;
        $academicYearList = AcademicYear::select('id', 'year_name')
            ->whereIn('id', $academic_year_ids)
            ->get();


        $academicDepartmentList = [];
        if ($site_group_setting->academic_department_ids) {
            $academicDepartment = explode(',', $site_group_setting->academic_department_ids) ?? null;
            $academicDepartmentList = AcademicDepartment::select('id', 'name as department_name')
                ->whereIn('id', $academicDepartment)->get();
        }

        $academicClass = explode(',', $site_group_setting->academic_class_ids) ?? null;
        $academicClassList = AcademicClass::select('id', 'class_name')
            ->whereIn('id', $academicClass)
            ->orderBy('serial_no', 'ASC')
            ->get();




        $academicSession = explode(',', $site_group_setting->academic_session_ids) ?? null;
        $academicSessionList = AcademicSession::select('id', 'session_name')
            ->whereIn('id', $academicSession)
            ->get();


        $educationQualification = explode(',', $site_group->employee_examination_ids) ?? null;
        $educationQualificationList = Examination::select('id', 'examination_name')
            ->whereIn('id', $educationQualification)
            ->get();




        $siteid=SiteInfo::where('site_group_id',$site_group_setting->site_group_id)->pluck('id');
        $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->pluck('site_id');


//         $test= GlobalSiteInfo::where('site_group_id', Session::get('SITE_GROUP_ID'))
//            ->orderBy('site_serial')
//            ->whereIn('id',$siteIDs)
//            ->pluck('site_email');
//
//        return implode(', ', $test->toArray());


        $siteList_all=GlobalSiteInfo::where('site_group_id', Session::get('SITE_GROUP_ID'))
            ->orderBy('site_serial')
            ->select('id', 'site_serial')
            ->whereIn('id',$siteIDs)
            ->get();


        $test_arr=Array();
        $siteList=[];
        foreach ($siteList_all as $key => $value) {

            $test_arr['id']=$value->id;
            $test_arr['site_name']=$value->site_serial? ('('.$value->site_serial.')'.' '.$value->site_name):$value->site_name;

            $siteList[$key]=$test_arr;
        }






        $AdmissionDeclare_List=SiteGroupAdmissionDeclare::where('site_group_id', Session::get('SITE_GROUP_ID'))->get();



        $admission_dec_arr=Array();
        $AdmissionDeclareList=[];
        foreach ($AdmissionDeclare_List as $key => $value) {

            $site_info_list=GlobalSiteStudentAdmissionDeclare::where('site_group_admission_declare_id', $value->id)
                ->pluck('site_id')
                ->unique();


            $admission_dec_arr['site_info_list']=$site_info_list;

            $AdmissionDeclareList[$key]=array_merge($value->toArray(), $admission_dec_arr);
        }


        $academicAdmissionStyleList=AcademicAdmissionStyle::get();


        return response()->json(
            [
                'academicVersionList'=>$academicVersionList,
                'shiftList'=>$shiftList,
                'academicYearList'=>$academicYearList,
                'academicDepartmentList'=>$academicDepartmentList,
                'academicClassList'=>$academicClassList,
                'academicSessionList'=>$academicSessionList,
                'educationQualificationList'=>$educationQualificationList,
                'siteList'=>$siteList,
                'AdmissionDeclareList'=>$AdmissionDeclareList,
                'academicAdmissionStyleList'=>$academicAdmissionStyleList,


            ]);



    }




    public function createSiteGroupAdmissionDeclare(Request $request, SiteGroupAdmissionDeclare $sbsrd){

        try {



            $this->validate($request, [
                "start_date" => "required",
                "end_date" => "required",
                "shift_ids" => "required",
                "academic_version_ids" => "required",
                "academic_year_ids" => "required",
                "academic_class_ids" => "required",
                "admission_form_language" => "required",

            ]);


            if ($request->start_date > $request->end_date) {

                $start_date = $request->end_date;
                $end_date = $request->start_date;

            } else {
                $start_date = $request->start_date;
                $end_date = $request->end_date;
            }


            $check_start_date = SiteGroupAdmissionDeclare::
            where('duration_from_date', '>=', $start_date)
                ->whereOr('duration_to_date', '>=', $start_date)
                ->where('status', true)
                ->first();


            $check_end_date = SiteGroupAdmissionDeclare::
            where('duration_from_date', '>=', $end_date)
                ->whereOr('duration_to_date', '>=', $end_date)
                ->where('status', true)
                ->first();


            if ($check_start_date || $check_end_date) {

                return 'sametimeerror';
            }
            else {


//                \Log::info($payment_company_ids);


                $check_active_data = SiteGroupAdmissionDeclare::
                where('status', true)
                    ->first();

                if ($check_active_data) {
                    $check_active_data->update([
                        'status' => false
                    ]);
                }



                $sbsrd->duration_from_date = $start_date;
                $sbsrd->duration_to_date = $end_date;
                $sbsrd->extended_date = $request->extended_date;
                $sbsrd->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
                $sbsrd->site_group_id = Session::get('SITE_GROUP_ID');

                $sbsrd->academic_shift_ids = implode(',', $request->shift_ids);
                $sbsrd->academic_version_ids = implode(',', $request->academic_version_ids);
                $sbsrd->academic_year_ids = implode(',', $request->academic_year_ids);
                $sbsrd->academic_department_ids = $request->academic_department_ids ? implode(',', $request->academic_department_ids) : null;
                $sbsrd->academic_class_ids = $request->academic_class_ids ? implode(',', $request->academic_class_ids) : null;
                $sbsrd->academic_session_ids = $request->academic_session_ids ? implode(',', $request->academic_session_ids) : null;

                $sbsrd->send_sms = $request->send_sms;
                $sbsrd->guardian_information_add = $request->guardian_information_add;
                $sbsrd->address_information_add = $request->address_information_add;
                $sbsrd->communication_information_add = $request->communication_information_add;
                $sbsrd->local_guardian_detail_information_add = $request->local_guardian_detail_information_add;
                $sbsrd->check_with_roll_number = $request->check_with_roll_number;
                $sbsrd->check_with_online_transaction_id = $request->check_with_online_transaction_id;
                $sbsrd->check_with_board_university = $request->check_with_board_university;



                $sbsrd->auto_roll_create_status = $request->auto_roll_create_status;
                $sbsrd->auto_roll_digit = $request->auto_roll_digit;
                $sbsrd->bank_recipt_downlaod_status = $request->bank_recipt_downlaod_status;
                $sbsrd->exam_passing_year_show = $request->exam_passing_year_show;
                $sbsrd->admission_form_language = $request->admission_form_language;
                $sbsrd->passing_year_examination_id = $request->passing_year_examination_id;



                $sbsrd->form_number_entry_box_show = $request->form_number_entry_box_show;
                $sbsrd->form_number_check = $request->form_number_check;
                $sbsrd->form_show_to_website = $request->form_show_to_website;
                $sbsrd->site_can_not_approve_student = $request->site_can_not_approve_student;
                $sbsrd->academic_admission_style_id = $request->academic_admission_style_id;

                $sbsrd->status = true;


                $sbsrd->save();
                $declare_id=$sbsrd->id;



                $year_base_all_site_shift=GlobalSiteShiftClassGroupSectionSetting::whereIn('academic_year_id', $request->academic_year_ids)
                    ->whereIn('site_id', $request->select_site_info_id)
                    ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                    ->get();


                foreach ($request->select_site_info_id as $key => $value) {

                    $gssad= new GlobalSiteStudentAdmissionDeclare();

                    $site_declared_list=$gssad->where('site_id', $value)
                        ->where('status', true);

                    if($site_declared_list){
                        $site_declared_list->update(['status'=>false]);
                    }

                    $get_site_detail=GlobalSiteInfoSetting::where('site_id', $value)
                        ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                        ->first();




                    $site_academic_class_ids=explode(',', $get_site_detail->academic_class_ids);
                    $sugested_academic_class_ids=$request->academic_class_ids;
                    $academic_class_ids=array_intersect($site_academic_class_ids, $sugested_academic_class_ids);




                    $year_base_shift=$year_base_all_site_shift->where('site_id', $value)
                        ->pluck('academic_shift_id')
                        ->unique();
                    if(count($year_base_shift)>0){
                        $academic_shift_ids=$year_base_shift;
                    }
                    else{
                        $site_academic_shift_ids=explode(',', $get_site_detail->shift_ids);
                        $sugested_academic_shift_ids=$request->shift_ids;
                        $academic_shift_ids=array_intersect($site_academic_shift_ids, $sugested_academic_shift_ids);
                    }







                    $site_academic_session_ids=explode(',', $get_site_detail->academic_session_ids);
                    $sugested_academic_session_ids=$request->academic_session_ids;
                    $academic_session_ids=array_intersect($site_academic_session_ids, $sugested_academic_session_ids);


                    $site_academic_department_ids=explode(',', $get_site_detail->academic_department_ids);
                    $sugested_academic_department_ids=$request->academic_department_ids;
                    $academic_department_ids=array_intersect($site_academic_department_ids, $sugested_academic_department_ids);


                    $gssad->duration_from_date = $start_date;
                    $gssad->duration_to_date = $end_date;
                    $gssad->extended_date = $request->extended_date;
                    $gssad->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
                    $gssad->site_group_id = Session::get('SITE_GROUP_ID');
                    $gssad->site_id = $value;

                    $gssad->academic_shift_ids = implode(',', $academic_shift_ids);
                    $gssad->academic_version_ids = implode(',', $request->academic_version_ids);
                    $gssad->academic_year_ids = implode(',', $request->academic_year_ids);
                    $gssad->academic_department_ids = $academic_department_ids ? implode(',', $academic_department_ids) : null;
                    $gssad->academic_class_ids = $academic_class_ids ? implode(',', $academic_class_ids) : null;
                    $gssad->academic_session_ids = $academic_session_ids ? implode(',', $academic_session_ids) : null;

                    $gssad->send_sms = $request->send_sms;
                    $gssad->guardian_information_add = $request->guardian_information_add;
                    $gssad->address_information_add = $request->address_information_add;
                    $gssad->communication_information_add = $request->communication_information_add;
                    $gssad->local_guardian_detail_information_add = $request->local_guardian_detail_information_add;
                    $gssad->check_with_roll_number = $request->check_with_roll_number;
                    $gssad->check_with_online_transaction_id = $request->check_with_online_transaction_id;
                    $gssad->check_with_board_university = $request->check_with_board_university;


                    $gssad->auto_roll_create_status = $request->auto_roll_create_status;
                    $gssad->auto_roll_digit = $request->auto_roll_digit;
                    $gssad->bank_recipt_downlaod_status = $request->bank_recipt_downlaod_status;
                    $gssad->exam_passing_year_show = $request->exam_passing_year_show;
                    $gssad->admission_form_language = $request->admission_form_language;
                    $gssad->passing_year_examination_id = $request->passing_year_examination_id;


                    $gssad->form_number_entry_box_show = $request->form_number_entry_box_show;
                    $gssad->form_number_check = $request->form_number_check;
                    $gssad->form_show_to_website = $request->form_show_to_website;
                    $gssad->site_can_not_approve_student = $request->site_can_not_approve_student;
                    $gssad->academic_admission_style_id = $request->academic_admission_style_id;

                    $gssad->status = true;
                    $gssad->site_group_admission_declare_id = $declare_id;


                    $gssad->save();

                }


                return Response::json(['message' => 'Admission Declare Create Successfully!', 'mode' => 'Create!'], 200);
            }


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }





    }




    public function updateSiteGroupAdmissionDeclare(Request $request){


        try {



            $this->validate($request, [
                "start_date" => "required",
                "end_date" => "required",
                "shift_ids" => "required",
                "academic_version_ids" => "required",
                "academic_year_ids" => "required",
                "academic_class_ids" => "required",
                "admission_form_language" => "required",

            ]);


            if ($request->start_date > $request->end_date) {

                $start_date = $request->end_date;
                $end_date = $request->start_date;

            } else {
                $start_date = $request->start_date;
                $end_date = $request->end_date;
            }


            $check_start_date = SiteGroupAdmissionDeclare::
            where('duration_from_date', '>=', $start_date)
                ->whereOr('duration_to_date', '>=', $start_date)
                ->where('id', '!=', $request->site_group_admission_declare_id)
                ->where('status', true)
                ->first();


            $check_end_date = SiteGroupAdmissionDeclare::
            where('duration_from_date', '>=', $end_date)
                ->whereOr('duration_to_date', '>=', $end_date)
                ->where('id', '!=', $request->site_group_admission_declare_id)
                ->where('status', true)
                ->first();




            if ($check_start_date || $check_end_date) {

                return 'sametimeerror';
            }
            else {


                $sbsrd=SiteGroupAdmissionDeclare::where('id', $request->site_group_admission_declare_id)
                    ->first();


                $sbsrd->duration_from_date = $start_date;
                $sbsrd->duration_to_date = $end_date;
                $sbsrd->extended_date = $request->extended_date;
                $sbsrd->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
                $sbsrd->site_group_id = Session::get('SITE_GROUP_ID');

                $sbsrd->academic_shift_ids = implode(',', $request->shift_ids);
                $sbsrd->academic_version_ids = implode(',', $request->academic_version_ids);
                $sbsrd->academic_year_ids = implode(',', $request->academic_year_ids);
                $sbsrd->academic_department_ids = $request->academic_department_ids ? implode(',', $request->academic_department_ids) : null;
                $sbsrd->academic_class_ids = $request->academic_class_ids ? implode(',', $request->academic_class_ids) : null;
                $sbsrd->academic_session_ids = $request->academic_session_ids ? implode(',', $request->academic_session_ids) : null;

                $sbsrd->send_sms = $request->send_sms;
                $sbsrd->guardian_information_add = $request->guardian_information_add;
                $sbsrd->address_information_add = $request->address_information_add;
                $sbsrd->communication_information_add = $request->communication_information_add;
                $sbsrd->local_guardian_detail_information_add = $request->local_guardian_detail_information_add;
                $sbsrd->check_with_roll_number = $request->check_with_roll_number;
                $sbsrd->check_with_online_transaction_id = $request->check_with_online_transaction_id;
                $sbsrd->check_with_board_university = $request->check_with_board_university;



                $sbsrd->auto_roll_create_status = $request->auto_roll_create_status;
                $sbsrd->auto_roll_digit = $request->auto_roll_digit;
                $sbsrd->bank_recipt_downlaod_status = $request->bank_recipt_downlaod_status;
                $sbsrd->exam_passing_year_show = $request->exam_passing_year_show;
                $sbsrd->admission_form_language = $request->admission_form_language;
                $sbsrd->passing_year_examination_id = $request->passing_year_examination_id;



                $sbsrd->form_number_entry_box_show = $request->form_number_entry_box_show;
                $sbsrd->form_number_check = $request->form_number_check;
                $sbsrd->form_show_to_website = $request->form_show_to_website;
                $sbsrd->site_can_not_approve_student = $request->site_can_not_approve_student;
                $sbsrd->academic_admission_style_id = $request->academic_admission_style_id;

                $sbsrd->status = true;


                $sbsrd->save();
                $declare_id=$request->site_group_admission_declare_id;



                $year_base_all_site_shift=GlobalSiteShiftClassGroupSectionSetting::whereIn('academic_year_id', $request->academic_year_ids)
                    ->whereIn('site_id', $request->select_site_info_id)
                    ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                    ->get();




                foreach ($request->select_site_info_id as $key => $value) {

                    $gssad= GlobalSiteStudentAdmissionDeclare::where('site_id', $value)
                        ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                        ->where('site_group_admission_declare_id', $request->site_group_admission_declare_id)
                        ->first();




                    $get_site_detail=GlobalSiteInfoSetting::where('site_id', $value)
                        ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                        ->first();




                    $site_academic_class_ids=explode(',', $get_site_detail->academic_class_ids);
                    $sugested_academic_class_ids=$request->academic_class_ids;
                    $academic_class_ids=array_intersect($site_academic_class_ids, $sugested_academic_class_ids);



                    $year_base_shift=$year_base_all_site_shift->where('site_id', $value)
                        ->pluck('academic_shift_id')
                        ->unique();


                    if(count($year_base_shift)>0){
                        $academic_shift_ids=$year_base_shift->toArray();
                    }
                    else{
                        $site_academic_shift_ids=explode(',', $get_site_detail->shift_ids);
                        $sugested_academic_shift_ids=$request->shift_ids;
                        $academic_shift_ids=array_intersect($site_academic_shift_ids, $sugested_academic_shift_ids);
                    }


//                    $site_academic_shift_ids=explode(',', $get_site_detail->shift_ids);
//                    $sugested_academic_shift_ids=$request->shift_ids;
//                    $academic_shift_ids=array_intersect($site_academic_shift_ids, $sugested_academic_shift_ids);



                    $site_academic_session_ids=explode(',', $get_site_detail->academic_session_ids);
                    $sugested_academic_session_ids=$request->academic_session_ids ?? [];
                    $academic_session_ids=array_intersect($site_academic_session_ids, $sugested_academic_session_ids);


                    $site_academic_department_ids=explode(',', $get_site_detail->academic_department_ids);
                    $sugested_academic_department_ids=$request->academic_department_ids;
                    $academic_department_ids=array_intersect($site_academic_department_ids, $sugested_academic_department_ids);



                    if($gssad){
                        $gssad->duration_from_date = $start_date;
                        $gssad->duration_to_date = $end_date;
                        $gssad->extended_date = $request->extended_date;
                        $gssad->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
                        $gssad->site_group_id = Session::get('SITE_GROUP_ID');
                        $gssad->site_id = $value;

                        $gssad->academic_shift_ids = implode(',', $academic_shift_ids);
                        $gssad->academic_version_ids = implode(',', $request->academic_version_ids);
                        $gssad->academic_year_ids = implode(',', $request->academic_year_ids);
                        $gssad->academic_department_ids = $academic_department_ids ? implode(',', $academic_department_ids) : null;
                        $gssad->academic_class_ids = $academic_class_ids ? implode(',', $academic_class_ids) : null;
                        $gssad->academic_session_ids = $academic_session_ids ? implode(',', $academic_session_ids) : null;

                        $gssad->send_sms = $request->send_sms;
                        $gssad->guardian_information_add = $request->guardian_information_add;
                        $gssad->address_information_add = $request->address_information_add;
                        $gssad->communication_information_add = $request->communication_information_add;
                        $gssad->local_guardian_detail_information_add = $request->local_guardian_detail_information_add;
                        $gssad->check_with_roll_number = $request->check_with_roll_number;
                        $gssad->check_with_online_transaction_id = $request->check_with_online_transaction_id;
                        $gssad->check_with_board_university = $request->check_with_board_university;


                        $gssad->auto_roll_create_status = $request->auto_roll_create_status;
                        $gssad->auto_roll_digit = $request->auto_roll_digit;
                        $gssad->bank_recipt_downlaod_status = $request->bank_recipt_downlaod_status;
                        $gssad->exam_passing_year_show = $request->exam_passing_year_show;
                        $gssad->admission_form_language = $request->admission_form_language;
                        $gssad->passing_year_examination_id = $request->passing_year_examination_id;


                        $gssad->form_number_entry_box_show = $request->form_number_entry_box_show;
                        $gssad->form_number_check = $request->form_number_check;
                        $gssad->form_show_to_website = $request->form_show_to_website;
                        $gssad->site_can_not_approve_student = $request->site_can_not_approve_student;
                        $gssad->academic_admission_style_id = $request->academic_admission_style_id;

                        $gssad->status = true;
                        $gssad->site_group_admission_declare_id = $declare_id;


                        $gssad->save();
                    }
                    else{

                        $gssad_create= new GlobalSiteStudentAdmissionDeclare();

                        $gssad_create->duration_from_date = $start_date;
                        $gssad_create->duration_to_date = $end_date;
                        $gssad_create->extended_date = $request->extended_date;
                        $gssad_create->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
                        $gssad_create->site_group_id = Session::get('SITE_GROUP_ID');
                        $gssad_create->site_id = $value;

                        $gssad_create->academic_shift_ids = implode(',', $academic_shift_ids);
                        $gssad_create->academic_version_ids = implode(',', $request->academic_version_ids);
                        $gssad_create->academic_year_ids = implode(',', $request->academic_year_ids);
                        $gssad_create->academic_department_ids = $academic_department_ids ? implode(',', $academic_department_ids) : null;
                        $gssad_create->academic_class_ids = $academic_class_ids ? implode(',', $academic_class_ids) : null;
                        $gssad_create->academic_session_ids = $academic_session_ids ? implode(',', $academic_session_ids) : null;

                        $gssad_create->send_sms = $request->send_sms;
                        $gssad_create->guardian_information_add = $request->guardian_information_add;
                        $gssad_create->address_information_add = $request->address_information_add;
                        $gssad_create->communication_information_add = $request->communication_information_add;
                        $gssad_create->local_guardian_detail_information_add = $request->local_guardian_detail_information_add;
                        $gssad_create->check_with_roll_number = $request->check_with_roll_number;
                        $gssad_create->check_with_online_transaction_id = $request->check_with_online_transaction_id;
                        $gssad_create->check_with_board_university = $request->check_with_board_university;


                        $gssad_create->auto_roll_create_status = $request->auto_roll_create_status;
                        $gssad_create->auto_roll_digit = $request->auto_roll_digit;
                        $gssad_create->bank_recipt_downlaod_status = $request->bank_recipt_downlaod_status;
                        $gssad_create->exam_passing_year_show = $request->exam_passing_year_show;
                        $gssad_create->admission_form_language = $request->admission_form_language;
                        $gssad_create->passing_year_examination_id = $request->passing_year_examination_id;


                        $gssad_create->form_number_entry_box_show = $request->form_number_entry_box_show;
                        $gssad_create->form_number_check = $request->form_number_check;
                        $gssad_create->form_show_to_website = $request->form_show_to_website;
                        $gssad_create->site_can_not_approve_student = $request->site_can_not_approve_student;
                        $gssad_create->academic_admission_style_id = $request->academic_admission_style_id;

                        $gssad_create->status = true;
                        $gssad_create->site_group_admission_declare_id = $declare_id;


                        $gssad_create->save();
                    }



                }


                $previous_all_site= $gssad= GlobalSiteStudentAdmissionDeclare::where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                    ->where('site_group_admission_declare_id', $request->site_group_admission_declare_id)
                    ->pluck('site_id')
                    ->unique();

                $ignor_site_ids=array_diff($previous_all_site->toArray(), $request->select_site_info_id);
                if(count($ignor_site_ids)>0){
                    GlobalSiteStudentAdmissionDeclare::where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                        ->where('site_group_admission_declare_id', $request->site_group_admission_declare_id)
                        ->whereIn('site_id', $ignor_site_ids)
                        ->delete();
                }


                return Response::json(['message' => 'Admission Declare Update Successfully!', 'mode' => 'Create!'], 200);
            }


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }


    }






    public function deleteSiteGroupAdmissionDeclare(Request $request){




        GlobalSiteStudentAdmissionDeclare::where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->where('site_group_admission_declare_id', $request->site_group_admission_declare_id)
            ->delete();


        SiteGroupAdmissionDeclare::where('id', $request->site_group_admission_declare_id)
            ->delete();



        return Response::json(['message' => 'Deleted Successfully!', 'mode' => 'delete!'], 200);


    }









    public function getSiteGroupAmissionAppliedCountList(){


        $siteid=SiteInfo::where('site_group_id',Session::get('SITE_GROUP_ID'))->pluck('id');
        $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
//            ->whereIn('site_id', [14])
            ->pluck('site_id');

        $siteList_all=GlobalSiteInfo::orderBy('site_serial')
            ->select('id', 'site_serial')
            ->whereIn('id',$siteIDs)
            ->get();
        $site_ids=$siteList_all->pluck('id');


        $active_site_group_admission_declare=SiteGroupAdmissionDeclare::where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->where('status', true)
            ->first();
//        return $active_site_group_admission_declare;

        $active_site_admission_declare=GlobalSiteStudentAdmissionDeclare::where('site_group_admission_declare_id',$active_site_group_admission_declare->id)
            ->select('id', 'site_id')
            ->get();

        $active_site_admission_ids=$active_site_admission_declare->pluck('id')->unique();



        $group_class_ids=$active_site_group_admission_declare->academic_class_ids[1];

        $class_list=AcademicClass::whereIn('id', $group_class_ids)->get();


        $group_list=AcademicClassGroup::get();





        $test_arr=Array();
        $siteList=[];
        foreach ($siteList_all as $key => $value) {

            $declare_id=$active_site_admission_declare->where('site_id', $value->id)->first();

            $class_arr=Array();
            $class_array=[];
            foreach ($class_list as $keys => $values) {

                $site_group_list_ids=GlobalSiteStudentAdmissionApplication::where('academic_class_id', $values->id)
                    ->where('site_id', $value->id)
                    ->where('site_student_admission_declare_id', $declare_id->id)
                    ->where('academic_class_group_id', '!=', null)
                    ->pluck('academic_class_group_id')
                    ->unique();

                $group_list_array=[];
                if(count($site_group_list_ids)>0){


                    $group_lists=$group_list->whereIn('id', $site_group_list_ids);
                    $group_list_arr=Array();
                    foreach ($group_lists as $keyst => $valuest) {

                        $group_student_count=GlobalSiteStudentAdmissionApplication::where('academic_class_id', $values->id)
                            ->where('site_id', $value->id)
                            ->where('site_student_admission_declare_id', $declare_id->id)
                            ->where('academic_class_group_id', $valuest->id)
                            ->where('academic_class_group_id', '!=', null)
                            ->count();


                        $group_list_arr['id']=$valuest->id;
                        $group_list_arr['group_name']=$valuest->group_name;
                        $group_list_arr['group_student_count']=$group_student_count;


                        $group_list_array[$keyst]=$group_list_arr;
                    }


                    $class_arr['id']=$values->id;
                    $class_arr['class_name']=$values->class_name;
                    $class_arr['student_count']=collect($group_list_array)->sum('group_student_count');
                    $class_arr['group_list']=$group_list_array;


                }
                else{
                    $count_student=GlobalSiteStudentAdmissionApplication::where('academic_class_id', $values->id)
                        ->where('site_id', $value->id)
                        ->where('site_student_admission_declare_id', $declare_id->id)
                        ->count();

                    $class_arr['id']=$values->id;
                    $class_arr['class_name']=$values->class_name;
                    $class_arr['student_count']=$count_student;
                    $class_arr['group_list']=[];
                }




                $class_array[$keys]=$class_arr;
            }

            $test_arr['id']=$value->id;
            $test_arr['site_name']=$value->site_serial? ('('.$value->site_serial.')'.' '.$value->site_name):$value->site_name;
            $test_arr['total_count']= (collect($class_array))->sum('student_count');
            $test_arr['class_list']=$class_array;
            $test_arr['declare_id']=$declare_id->id;

            $siteList[$key]=$test_arr;
        }

        $total_apply=collect($siteList)->sum('total_count');

        $admission_test_type_list=AcademicAdmissionTestResultType::get();

        return response()->json(
            [
                'class_list'=>$class_list,
                'siteList'=>$siteList,
                'total_apply'=>$total_apply,
                'admission_test_type_list'=>$admission_test_type_list,
            ]);



    }


//    public function getSiteGroupAmissionAppliedCountList(){
//
//
//        $siteid=SiteInfo::where('site_group_id',Session::get('SITE_GROUP_ID'))->pluck('id');
//        $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
//            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
////            ->whereIn('site_id', [14])
//            ->pluck('site_id');
//
//        $siteList_all=GlobalSiteInfo::orderBy('site_serial')
//            ->select('id', 'site_serial')
//            ->whereIn('id',$siteIDs)
//            ->get();
//        $site_ids=$siteList_all->pluck('id');
//
//
//        $active_site_group_admission_declare=SiteGroupAdmissionDeclare::where('site_group_id',Session::get('SITE_GROUP_ID'))
//            ->where('status', true)
//            ->first();
////        return $active_site_group_admission_declare;
//
//        $active_site_admission_declare=GlobalSiteStudentAdmissionDeclare::where('site_group_admission_declare_id',$active_site_group_admission_declare->id)
//            ->select('id', 'site_id')
//            ->get();
//
//        $active_site_admission_ids=$active_site_admission_declare->pluck('id')->unique();
//
//
//
//        $group_class_ids=$active_site_group_admission_declare->academic_class_ids[1];
//
//        $class_list=AcademicClass::whereIn('id', $group_class_ids)->get();
//
//
//        $applied_std_list=GlobalSiteStudentAdmissionApplication::whereIn('academic_class_id', $group_class_ids)
//            ->whereIn('site_student_admission_declare_id', $active_site_admission_ids)
//            ->select('id', 'academic_class_id', 'site_student_admission_declare_id', 'site_id', 'academic_class_group_id')
//            ->get();
//
//
//        $present_site_group_list=$applied_std_list->whereIn('academic_class_id', $group_class_ids)
////            ->whereIn('site_id', [14])
//            ->whereIn('site_id', $site_ids)
//            ->where('academic_class_group_id', '!=', null);
//
////        $only_group_ids=$present_site_group_list->pluck('academic_class_group_id')->unique();
//        $group_list=AcademicClassGroup::get();
//
//
//
//
//
//        $test_arr=Array();
//        $siteList=[];
//        foreach ($siteList_all as $key => $value) {
//
//            $class_arr=Array();
//            $class_array=[];
//            foreach ($class_list as $keys => $values) {
//
//                $check_group_present=$present_site_group_list->where('academic_class_id', $values->id)
//                    ->where('site_id', $value->id);
//
//                $group_list_array=[];
//                if(count($check_group_present)>0){
//
//                    $site_group_list_ids=$present_site_group_list->pluck('academic_class_group_id')->unique();
//                    $group_lists=$group_list->whereIn('id', $site_group_list_ids);
//                    $group_list_arr=Array();
//                    foreach ($group_lists as $keyst => $valuest) {
//
//                        $group_student_count=$check_group_present->where('academic_class_group_id', $valuest->id)
//                            ->count();
//
//
//                        $group_list_arr['id']=$valuest->id;
//                        $group_list_arr['group_name']=$valuest->group_name;
//                        $group_list_arr['group_student_count']=$group_student_count;
//
//
//                        $group_list_array[$keyst]=$group_list_arr;
//                    }
//                }
//
//
//
//                $count_student=$applied_std_list->where('academic_class_id', $values->id)
//                    ->where('site_id', $value->id)
//                    ->count();
//
//                $class_arr['id']=$values->id;
//                $class_arr['class_name']=$values->class_name;
//                $class_arr['student_count']=$count_student;
//                $class_arr['group_list']=$group_list_array;
//
//
//                $class_array[$keys]=$class_arr;
//            }
//
//            $test_arr['id']=$value->id;
//            $test_arr['site_name']=$value->site_serial? ('('.$value->site_serial.')'.' '.$value->site_name):$value->site_name;
//            $test_arr['total_count']= (collect($class_array))->sum('student_count');
//            $test_arr['class_list']=$class_array;
//
//            $siteList[$key]=$test_arr;
//        }
//
//        $total_apply=collect($siteList)->sum('total_count');
//
//        return response()->json(
//            [
//                'class_list'=>$class_list,
//                'siteList'=>$siteList,
//                'total_apply'=>$total_apply,
//            ]);
//
//
//
//    }


    public function getClassAppliedStudentListForSiteGroup(Request $request){

        $data=$request->all();
        $active_site_group_admission_declare=SiteGroupAdmissionDeclare::where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->where('status', true)
            ->first();


        $active_site_admission_declare=GlobalSiteStudentAdmissionDeclare::where('site_group_admission_declare_id',$active_site_group_admission_declare->id)
            ->where('site_id', $request->site_id)
            ->select('id', 'site_id')
            ->first();

        $student_list=GlobalSiteStudentAdmissionApplication::where('academic_class_id', $request->academic_class_id)
            ->where('site_id', $request->site_id)
            ->where('site_student_admission_declare_id', $active_site_admission_declare->id)
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->select('id', 'academic_class_id', 'academic_class_group_id', 'first_name', 'father_name', 'menual_form_number')
            ->orderBy('menual_form_number')
            ->get();


        $class_name=AcademicClass::where('id', $request->academic_class_id)->first();

        if($request->academic_class_group_id){
            $group_list=AcademicClassGroup::where('id', $request->academic_class_group_id)->first();
            $group_name=$group_list->group_name;
        }
        else{
            $group_name='';
        }


        $marite_student_ids=GlobalSiteAdmissionMeritList::where('site_id', $request->site_id)
            ->where('site_student_admission_declare_id', $active_site_admission_declare->id)
            ->where('academic_admission_test_result_type_id', $request->academic_admission_test_result_type_id)
            ->pluck('site_student_admission_application_id')
            ->unique()
            ->values();




        return response()->json(
            [
                'applied_student_list'=>$student_list,
                'class_name'=>$class_name->class_name,
                'group_name'=>$group_name,
                'marite_student_ids'=>$marite_student_ids,

            ]);

    }

    //======================================Loterry


    public function getSiteGroupAdmissionResultTypeForLoterry(){
        $admission_test_type_list=AcademicAdmissionTestResultType::get();

        return response()->json(
            [
                'admissionTestResultTypeList'=>$admission_test_type_list,
            ]);
    }








    public function getSiteGroupAdmissionDetailListForLoterry($type_id){





        $siteid=SiteInfo::where('site_group_id',Session::get('SITE_GROUP_ID'))->pluck('id');
        $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->pluck('site_id');

        $siteList_all=GlobalSiteInfo::orderBy('site_serial')
            ->select('id', 'site_serial')
//            ->whereIn('id',[13])
            ->whereIn('id',$siteIDs)
            ->get();
        $site_ids=$siteList_all->pluck('id');


        $active_site_group_admission_declare=SiteGroupAdmissionDeclare::where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->where('status', true)
            ->first();

//        return $active_site_group_admission_declare;

        $active_site_admission_declare=GlobalSiteStudentAdmissionDeclare::where('site_group_admission_declare_id',$active_site_group_admission_declare->id)
            ->select('id', 'site_id')
            ->where('status', true)
            ->get();



        $group_class_ids=$active_site_group_admission_declare->academic_class_ids[1];

        $class_list=AcademicClass::whereIn('id', $group_class_ids)->get();



        $group_list=AcademicClassGroup::get();


        $seat_list=GlobalSiteShiftClassGroupSectionSetting::whereIn('academic_class_id', $group_class_ids)
            ->whereIn('site_id', $site_ids)
//            ->whereIn('site_id', [13])
            ->select('id', 'site_id', 'academic_class_id', 'academic_class_group_id', 'admission_seat_capacity')
            ->get();





        $test_arr=Array();
        $siteList=[];
        foreach ($siteList_all as $key => $value) {

            $site_declare_id=$active_site_admission_declare->where('site_id', $value->id)->first();

            $applied_std_ids=GlobalSiteStudentAdmissionApplication::where('site_id',  $value->id)
                ->where('site_student_admission_declare_id', $site_declare_id->id)
                ->pluck('id')
                ->unique();


            $loterry_present=GlobalSiteAdmissionMeritList::whereIn('site_student_admission_application_id', $applied_std_ids)
                ->where('academic_admission_test_result_type_id', $type_id)
                ->first();

            $class_arr=Array();
            $class_array=[];
            foreach ($class_list as $keys => $values) {

                $site_class_seat=$seat_list->where('academic_class_id', $values->id)
                    ->where('site_id', $value->id);

                $site_group_list_ids=GlobalSiteStudentAdmissionApplication::where('site_id',  $value->id)
                    ->where('site_student_admission_declare_id', $site_declare_id->id)
                    ->where('academic_class_id', $values->id)
                    ->where('academic_class_group_id', '!=', null)
                    ->pluck('academic_class_group_id')
                    ->unique();

                $group_list_array=[];
                if(count($site_group_list_ids)>0){


                    $group_lists=$group_list->whereIn('id', $site_group_list_ids);



                    $group_list_arr=Array();
                    foreach ($group_lists as $keyst => $valuest) {

                        $site_group_seat=$site_class_seat->where('academic_class_group_id', $valuest->id)
                            ->sum('admission_seat_capacity');

                        $group_student_count=GlobalSiteStudentAdmissionApplication::where('site_id',  $value->id)
                            ->where('site_student_admission_declare_id', $site_declare_id->id)
                            ->where('academic_class_id', $values->id)
                            ->where('academic_class_group_id', '!=', null)
                            ->where('academic_class_group_id', $valuest->id)
                            ->count();


                        $group_list_arr['id']=$valuest->id;
                        $group_list_arr['group_name']=$valuest->group_name;
                        $group_list_arr['group_student_count']=$group_student_count;
                        $group_list_arr['group_seat_count']=$site_group_seat;


                        $group_list_array[$keyst]=$group_list_arr;
                    }


                    $class_arr['id']=$values->id;
                    $class_arr['class_name']=$values->class_name;
                    $class_arr['student_count']=collect($group_list_array)->sum('group_student_count');
                    $class_arr['group_list']=$group_list_array;
                    $class_arr['site_class_admission_seat']=collect($group_list_array)->sum('group_seat_count');

                }
                else{

                    $count_student=GlobalSiteStudentAdmissionApplication::where('site_id',  $value->id)
                        ->where('site_student_admission_declare_id', $site_declare_id->id)
                        ->where('academic_class_id', $values->id)
                        ->count();

                    $class_arr['id']=$values->id;
                    $class_arr['class_name']=$values->class_name;
                    $class_arr['student_count']=$count_student;
                    $class_arr['group_list']=[];
                    $class_arr['site_class_admission_seat']=$site_class_seat->sum('admission_seat_capacity');
                }






                $class_array[$keys]=$class_arr;
            }

            $test_arr['id']=$value->id;
            $test_arr['site_name']=$value->site_serial? ('('.$value->site_serial.')'.' '.$value->site_name):$value->site_name;
            $test_arr['site_student_admission_declare_id']=$site_declare_id->id;
            $test_arr['total_count']= (collect($class_array))->sum('student_count');
            $test_arr['class_list']=$class_array;
            $test_arr['site_total_admission_seat']=collect($class_array)->sum('site_class_admission_seat');
            $test_arr['loterry_complet']=$loterry_present?true:false;

            $siteList[$key]=$test_arr;
        }

        $total_apply=collect($siteList)->sum('total_count');
        $total_admission_seat=collect($siteList)->sum('site_total_admission_seat');

        return response()->json(
            [
                'class_list'=>$class_list,
                'siteList'=>$siteList,
                'total_apply'=>$total_apply,
                'total_admission_seat'=>$total_admission_seat,
            ]);


    }


//    public function getSiteGroupAdmissionDetailListForLoterry($type_id){
//
//
//
//
//
//        $siteid=SiteInfo::where('site_group_id',Session::get('SITE_GROUP_ID'))->pluck('id');
//        $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
//            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
//            ->pluck('site_id');
//
//        $siteList_all=GlobalSiteInfo::orderBy('site_serial')
//            ->select('id', 'site_serial')
////            ->whereIn('id',[13])
//            ->whereIn('id',$siteIDs)
//            ->get();
//        $site_ids=$siteList_all->pluck('id');
//
//
//        $active_site_group_admission_declare=SiteGroupAdmissionDeclare::where('site_group_id',Session::get('SITE_GROUP_ID'))
//            ->where('status', true)
//            ->first();
//
////        return $active_site_group_admission_declare;
//
//        $active_site_admission_declare=GlobalSiteStudentAdmissionDeclare::where('site_group_admission_declare_id',$active_site_group_admission_declare->id)
//            ->select('id', 'site_id')
//            ->where('status', true)
//            ->get();
//
//        $active_site_admission_ids=$active_site_admission_declare->pluck('id')->unique();
//
//
//
//        $group_class_ids=$active_site_group_admission_declare->academic_class_ids[1];
//
//        $class_list=AcademicClass::whereIn('id', $group_class_ids)->get();
//
//
//        $applied_std_list=GlobalSiteStudentAdmissionApplication::whereIn('academic_class_id', $group_class_ids)
//            ->whereIn('site_student_admission_declare_id', $active_site_admission_ids)
//            ->select('id', 'academic_class_id', 'site_student_admission_declare_id', 'site_id', 'academic_class_group_id')
//            ->get();
//
//
//
//
//        $present_site_group_list=$applied_std_list->whereIn('academic_class_id', $group_class_ids)
////            ->whereIn('site_id', [13])
//            ->whereIn('site_id', $site_ids)
//            ->where('academic_class_group_id', '!=', null);
//
////        $only_group_ids=$present_site_group_list->pluck('academic_class_group_id')->unique();
//        $group_list=AcademicClassGroup::get();
//
//
//        $seat_list=GlobalSiteShiftClassGroupSectionSetting::whereIn('academic_class_id', $group_class_ids)
//            ->whereIn('site_id', $site_ids)
////            ->whereIn('site_id', [13])
//            ->select('id', 'site_id', 'academic_class_id', 'academic_class_group_id', 'admission_seat_capacity')
//            ->get();
//
//
//
//
//
//        $test_arr=Array();
//        $siteList=[];
//        foreach ($siteList_all as $key => $value) {
//
//            $site_declare_id=$active_site_admission_declare->where('site_id', $value->id)->first();
//
//            $applied_std_ids=$applied_std_list->where('site_id',  $value->id)->pluck('id');
//
//            $loterry_present=GlobalSiteAdmissionMeritList::whereIn('site_student_admission_application_id', $applied_std_ids)
//                ->where('academic_admission_test_result_type_id', $type_id)
//                ->first();
//
//            $class_arr=Array();
//            $class_array=[];
//            foreach ($class_list as $keys => $values) {
//
//                $site_class_seat=$seat_list->where('academic_class_id', $values->id)
//                    ->where('site_id', $value->id);
//
//                $check_group_present=$present_site_group_list->where('academic_class_id', $values->id)
//                    ->where('site_id', $value->id);
//
//                $group_list_array=[];
//                if(count($check_group_present)>0){
//
//                    $site_group_list_ids=$present_site_group_list->pluck('academic_class_group_id')->unique();
//                    $group_lists=$group_list->whereIn('id', $site_group_list_ids);
//
//
//
//                    $group_list_arr=Array();
//                    foreach ($group_lists as $keyst => $valuest) {
//
//                        $site_group_seat=$site_class_seat->where('academic_class_group_id', $valuest->id)
//                            ->sum('admission_seat_capacity');
//
//                        $group_student_count=$check_group_present->where('academic_class_group_id', $valuest->id)
//                            ->count();
//
//
//                        $group_list_arr['id']=$valuest->id;
//                        $group_list_arr['group_name']=$valuest->group_name;
//                        $group_list_arr['group_student_count']=$group_student_count;
//                        $group_list_arr['group_seat_count']=$site_group_seat;
//
//
//                        $group_list_array[$keyst]=$group_list_arr;
//                    }
//                }
//
//
//
//                $count_student=$applied_std_list->where('academic_class_id', $values->id)
//                    ->where('site_id', $value->id)
//                    ->count();
//
//                $class_arr['id']=$values->id;
//                $class_arr['class_name']=$values->class_name;
//                $class_arr['student_count']=$count_student;
//                $class_arr['group_list']=$group_list_array;
//                $class_arr['site_class_admission_seat']=$site_class_seat->sum('admission_seat_capacity');
//
//
//                $class_array[$keys]=$class_arr;
//            }
//
//            $test_arr['id']=$value->id;
//            $test_arr['site_name']=$value->site_serial? ('('.$value->site_serial.')'.' '.$value->site_name):$value->site_name;
//            $test_arr['site_student_admission_declare_id']=$site_declare_id->id;
//            $test_arr['total_count']= (collect($class_array))->sum('student_count');
//            $test_arr['class_list']=$class_array;
//            $test_arr['site_total_admission_seat']=collect($class_array)->sum('site_class_admission_seat');
//            $test_arr['loterry_complet']=$loterry_present?true:false;
//
//            $siteList[$key]=$test_arr;
//        }
//
//        $total_apply=collect($siteList)->sum('total_count');
//        $total_admission_seat=collect($siteList)->sum('site_total_admission_seat');
//
//        return response()->json(
//            [
//                'class_list'=>$class_list,
//                'siteList'=>$siteList,
//                'total_apply'=>$total_apply,
//                'total_admission_seat'=>$total_admission_seat,
//            ]);
//
//
//    }


    public function individualSiteAdmissionLoterryFromSiteGroup(Request $request){

//        $applied_student_list=


        if(!($request->academic_admission_test_result_type_id)){
            return JsonResponse::create(['message' => 'Select Admission Type!'], 412);
        }

        $admission_declare_list=SiteStudentAdmissionDeclare::
            where('id', $request->site_seat_admission_list['site_student_admission_declare_id'])
            ->first();


        $admission_test_key=AcademicAdmissionTestResultType::where('id', $request->academic_admission_test_result_type_id)
            ->first();





        $applied_std_ids=GlobalSiteStudentAdmissionApplication::where('site_id', $request->site_seat_admission_list['id'])
            ->where('site_student_admission_declare_id', $request->site_seat_admission_list['site_student_admission_declare_id'])
            ->pluck('id')
            ->unique();




        $admission_type_ids=AcademicAdmissionTestResultType::where('name_key', 'merit')->first();

        if($request->academic_admission_test_result_type_id!=$admission_type_ids->id){
            $check_validity=GlobalSiteAdmissionMeritList::whereIn('site_student_admission_application_id', $applied_std_ids)
                ->where('academic_admission_test_result_type_id', $admission_type_ids->id)
                ->where('site_id', $request->site_seat_admission_list['id'])
                ->pluck('site_student_admission_application_id')
                ->unique();


            if(count($check_validity)<=0){
                return JsonResponse::create(['message' => 'You must generate Merite list first.!'], 412);
            }


        }else{
            $check_validity=[];
        }








        $created=[];
        foreach ($request->site_seat_admission_list['class_list'] as $key => $value) {


            if($admission_test_key->name_key=='merit'){
                $admission_seat=$value['site_class_admission_seat'];
            }
            else{

                if(!($request->seat_percentage)){
                    return JsonResponse::create(['message' => 'Please Enter Percentage!'], 412);
                }
                $admission_seat=floor(($value['site_class_admission_seat']*$request->seat_percentage)/100);
            }



            if($admission_seat>0){


                if(count($value['group_list'])>0){

                    foreach ($value['group_list'] as $keys => $values) {

                        if($admission_test_key->name_key=='merit'){
                            $admission_group_seat=$values['group_seat_count'];
                        }
                        else{
                            $admission_group_seat=floor(($values['group_seat_count']*$request->seat_percentage)/100);
                        }

                        $group_base_student=GlobalSiteStudentAdmissionApplication::
                            where('academic_class_id', $value['id'])
                            ->where('site_student_admission_declare_id', $request->site_seat_admission_list['site_student_admission_declare_id'])
                            ->where('academic_class_group_id', $values['id'])
                            ->whereNotIn('id', $check_validity)
                            ->select('id', 'academic_class_group_id')
                            ->inRandomOrder()
                            ->limit($admission_group_seat)
                            ->get();

                        foreach ($group_base_student as $keyst => $valuest) {
                            $created[]=[
                                'site_student_admission_application_id'=>$valuest['id'],
                                'academic_class_id'=>$value['id'],
                                'academic_class_group_id'=>$values['id'],
                                'academic_admission_test_result_type_id'=>$request->academic_admission_test_result_type_id,
                                'academic_admission_style_id'=> $admission_declare_list['academic_admission_style_id'],
                                'site_student_admission_declare_id'=>$request->site_seat_admission_list['site_student_admission_declare_id'],
                                'site_id'=>$request->site_seat_admission_list['id'],
                                'status'=>true,
                                'site_group_id'=>Session::get('SITE_GROUP_ID'),

                            ];
                        }



                    }


                }else{


                    $selected_std_list=GlobalSiteStudentAdmissionApplication::
                    where('academic_class_id', $value['id'])
                        ->where('site_student_admission_declare_id', $request->site_seat_admission_list['site_student_admission_declare_id'])
                        ->whereNotIn('id', $check_validity)
                        ->select('id', 'academic_class_group_id')
                        ->inRandomOrder()
                        ->limit($admission_seat)
                        ->get();


                    if(count($selected_std_list)>0){
                        foreach ($selected_std_list as $keys => $values) {

                            $created[]=[
                                'site_student_admission_application_id'=>$values['id'],
                                'academic_class_id'=>$value['id'],
                                'academic_class_group_id'=>null,
                                'academic_admission_test_result_type_id'=>$request->academic_admission_test_result_type_id,
                                'academic_admission_style_id'=> $admission_declare_list['academic_admission_style_id'],
                                'site_id'=>$request->site_seat_admission_list['id'],
                                'site_student_admission_declare_id'=>$request->site_seat_admission_list['site_student_admission_declare_id'],
                                'status'=>true,
                                'site_group_id'=>Session::get('SITE_GROUP_ID'),

                            ];


                        }
                    }
                }







            }


        }

//        return $created;

        if(count($created)>0){
            GlobalSiteAdmissionMeritList::insert($created);
        }




        return JsonResponse::create(['message' => 'Successfuly Loterry Complet!'], 200);


    }



    public function siteAdmissionLoterryResultSiteGroup(Request $request){


        $site_name=GlobalSiteInfo::where('id', $request->site_seat_admission_list['id'])
            ->select('id')
            ->first();


        $applied_std=GlobalSiteStudentAdmissionApplication::where('site_id', $request->site_seat_admission_list['id'])
            ->where('site_student_admission_declare_id', $request->site_seat_admission_list['site_student_admission_declare_id'])
            ->select('id', 'academic_class_id', 'academic_class_group_id', 'first_name', 'menual_form_number')
            ->orderBy('menual_form_number')
            ->get();


        $class_ids=AcademicClass::whereIn('id', $applied_std->pluck('academic_class_id')->unique())->get();


        $class_list_arr=Array();
        $class_list=[];
        foreach ($class_ids as $key => $value) {

//            if($value->id==22 || $value->id==23 ||$value->id==24||$value->id==20){



            $check_group=$applied_std->where('academic_class_id', $value->id)
                ->where('academic_class_group_id', '!=', null)
                ->first();

            if($check_group){

                $get_group=$applied_std->where('academic_class_id', $value->id)
                    ->where('academic_class_group_id', '!=', null)
                    ->pluck('academic_class_group_id')
                    ->unique();

                $group_list_all=AcademicClassGroup::whereIn('id', $get_group)->get();

                $group_list_arr=Array();
                $group_list=[];
                foreach ($group_list_all as $keys => $values) {

                    $class_group_applied_std=$applied_std->where('academic_class_id', $value->id)
                        ->where('academic_class_group_id', $values->id)
                        ->pluck('id');

                    $selected_student_group_ids=GlobalSiteAdmissionMeritList::whereIn('site_student_admission_application_id', $class_group_applied_std)
                        ->where('academic_admission_test_result_type_id', $request->academic_admission_test_result_type_id)
                        ->where('status', true)
                        ->pluck('site_student_admission_application_id')
                        ->unique();

                    $merite_group_list=$applied_std->whereIn('id', $selected_student_group_ids)->pluck('menual_form_number');

                    $group_list_arr['id']=$values->id;
                    $group_list_arr['group_name']=$values->group_name;
                    $group_list_arr['group_merit_list']=implode(', ', $merite_group_list->toArray());
                    $group_list_arr['student_count']=count($merite_group_list);

                    $group_list[$keys]=$group_list_arr;
                }



                $class_list_arr['id']= $value->id;
                $class_list_arr['class_name']= $value->class_name;
                $class_list_arr['merite_student_list']= [];
                $class_list_arr['merite_group_list']= $group_list;



                $class_list[$key]=$class_list_arr;

            }
            else{
                $class_applied_std=$applied_std->where('academic_class_id', $value->id)->pluck('id');

                $selected_student_ids=GlobalSiteAdmissionMeritList::whereIn('site_student_admission_application_id', $class_applied_std)
                    ->where('academic_admission_test_result_type_id', $request->academic_admission_test_result_type_id)
                    ->where('status', true)
                    ->pluck('site_student_admission_application_id')
                    ->unique();

                $merite_list=$applied_std->whereIn('id', $selected_student_ids)->pluck('menual_form_number');



                $class_list_arr['id']= $value->id;
                $class_list_arr['class_name']= $value->class_name;
                $class_list_arr['merite_student_list']= implode(', ', $merite_list->toArray());
                $class_list_arr['merite_group_list']= [];
                $class_list_arr['student_count']= count($merite_list);


                $class_list[$key]=$class_list_arr;
            }

//            }
        }



        return response()->json(
            [
                'class_list'=>$class_list,
                'site_detail'=>$site_name->site_name,
            ]);




//        $student_admission_list=GlobalSiteAdmissionMeritList::where('')

    }



    public function siteAdmissionLoterryDeleteSiteGroup(Request $request ){


        $applied_std_ids=GlobalSiteStudentAdmissionApplication::where('site_id', $request->site_seat_admission_list['id'])
            ->where('site_student_admission_declare_id', $request->site_seat_admission_list['site_student_admission_declare_id'])
            ->pluck('id')
            ->unique();

        $admission_type_ids=AcademicAdmissionTestResultType::where('name_key', '!=', 'merit')->pluck('id');

        $check_validity=GlobalSiteAdmissionMeritList::whereIn('site_student_admission_application_id', $applied_std_ids)
            ->whereIn('academic_admission_test_result_type_id', $admission_type_ids)
            ->first();
        if($check_validity){
            return JsonResponse::create(['message' => 'Presence of waiting list you can not delete merite list.!'], 412);
        }

        $check_publish=GlobalSiteAdmissionMeritList::
            where('site_student_admission_declare_id', $request->site_seat_admission_list['site_student_admission_declare_id'])
            ->where('publis_result', true)
            ->first();

        if($check_publish){
            return JsonResponse::create(['message' => 'Result Already Published. You can not delete or menupulate lottery.!'], 412);
        }

        GlobalSiteAdmissionMeritList::whereIn('site_student_admission_application_id', $applied_std_ids)
            ->where('academic_admission_test_result_type_id', $request->academic_admission_test_result_type_id)
            ->where('status', true)
            ->delete();



        return JsonResponse::create(['message' => 'Successfuly Loterry Delete!'], 200);
    }



    //====================Single Class Lottery Selection=====



    public function saveSingleClassLotteryResult(Request $request){



        $active_site_admission_declare=GlobalSiteStudentAdmissionDeclare::
            where('id', $request->site_student_admission_declare_id)
            ->where('site_id', $request->site_id)
            ->first('id', 'academic_admission_style_id')
            ->first();

        $data=$request->all();

        $get_marit_ist=GlobalSiteAdmissionMeritList::
            where('site_student_admission_declare_id',$request->site_student_admission_declare_id)
            ->where('site_id', $request->site_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
//            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->where('academic_admission_test_result_type_id', $request->academic_admission_test_result_type_id)
            ->select('id', 'site_student_admission_application_id')
            ->get();

        $merite_ids=$get_marit_ist->pluck('id');


        $created=[];
        $present_merit_ids=[];
        foreach ($request->site_student_admission_application_ids as $keys => $values) {

            $check_id_present=$get_marit_ist->where('site_student_admission_application_id', $values)->first();

            if($check_id_present){

                $present_merit_ids[]=$check_id_present->id;

            }
            else{
                $created[]=[
                    'site_student_admission_application_id'=>$values,
                    'academic_class_id'=>$request->academic_class_id,
                    'academic_class_group_id'=>$request->academic_class_group_id,
                    'academic_admission_test_result_type_id'=>$request->academic_admission_test_result_type_id,
                    'academic_admission_style_id'=> $active_site_admission_declare->academic_admission_style_id ?? 3,
                    'site_student_admission_declare_id'=>$request->site_student_admission_declare_id,
                    'site_id'=>$request->site_id,
                    'status'=>true,
                    'site_group_id'=>Session::get('SITE_GROUP_ID'),

                ];
            }
        }



//        if(count($present_merit_ids)>0){
            $siteMeriteCheck=array_diff($merite_ids->toArray(), $present_merit_ids);


            GlobalSiteAdmissionMeritList::whereIn('id', $siteMeriteCheck)->delete();
//        }


        if(count($created)>0){
            GlobalSiteAdmissionMeritList::insert($created);
        }


        return JsonResponse::create(['message' => 'Successfuly Loterry Save!'], 200);

    }



    //=========================Publish Loterry Result=====

    public function siteAdmissionLoterryPublishFromSiteGroup(Request $request){



        $active_site_group_admission_declare=SiteGroupAdmissionDeclare::where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->where('status', true)
            ->first();



        $active_site_admission_declare_ids=GlobalSiteStudentAdmissionDeclare::
            where('site_group_admission_declare_id', $active_site_group_admission_declare->id)
            ->where('status', true)
            ->pluck('id')
            ->unique();






//        $list=DB::table('site_student_admission_applications')
//            ->whereIn('site_student_admission_declare_id', $active_site_admission_declare_ids)
//            ->groupBy('menual_form_number')
//            ->havingRaw('COUNT(menual_form_number) > 1')
//            ->pluck('menual_form_number');
//
//        $applied_std_ids=GlobalSiteStudentAdmissionApplication::whereIn('menual_form_number', $list)
//            ->select('menual_form_number', 'site_id')
//            ->get();
//
//        $site_ids=$applied_std_ids->pluck('site_id')->unique();
//
//        $site=SiteInfo::whereIn('id', $site_ids)
//            ->orderBy('site_serial')
//            ->get();
//
//
//        $ab=Array();
//        $fcc=[];
//        foreach ($site as $key => $value) {
//
//
//            $llll=$applied_std_ids->where('site_id', $value['id'])->pluck('menual_form_number')->unique()->values()->toArray();
//
//
//            $ab['site_name']=$value->site_name;
//            $ab['serial']=$value->site_serial;
//            $ab['roll']=implode(', ', $llll);
//
//            $fcc[$key]=$ab;
//        }
//        return $fcc;


        GlobalSiteAdmissionMeritList::whereIn('site_student_admission_declare_id', $active_site_admission_declare_ids)
            ->where('academic_admission_test_result_type_id', $request->academic_admission_test_result_type_id)
            ->where('status', true)
            ->update([
                'publis_result'=>true,
            ]);



        return JsonResponse::create(['message' => 'Successfuly Result Publish To All Institute!'], 200);


    }



    public function siteAdmissionLoterryPauseFromSiteGroup(Request $request){
        $active_site_group_admission_declare=SiteGroupAdmissionDeclare::where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->where('status', true)
            ->first();



        $active_site_admission_declare_ids=GlobalSiteStudentAdmissionDeclare::
        where('site_group_admission_declare_id', $active_site_group_admission_declare->id)
            ->where('status', true)
            ->pluck('id')
            ->unique();


        GlobalSiteAdmissionMeritList::whereIn('site_student_admission_declare_id', $active_site_admission_declare_ids)
            ->where('academic_admission_test_result_type_id', $request->academic_admission_test_result_type_id)
            ->where('status', true)
            ->update([
                'publis_result'=>false,
            ]);



        return JsonResponse::create(['message' => 'Successfuly Result Pause To All Institute!'], 200);
    }

//    private function specialCode(){
//        $student_list=GlobalStudentHistory::where('site_id', 73)->get();
//
//        $student_user_ids=$student_list->pluck('user_id')->unique();
//
//
//
//        $clientIP = request()->ip();
//        $unique_code = intval("0" . rand(1, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(1, 9) .
//                rand(0, 9) . rand(0, 9) . rand(0, 9)) . 73;
//
//
//        foreach ($student_list as $key => $value) {
//
//
//
//            $student= new GlobalSiteStudentAdmissionApplication();
//
//            if (isset($student->ownFields)) {
//                foreach ($student->ownFields as $studentField) {
//                    if ($value->{$studentField}) {
//                        if (is_array($value->{$studentField})) {
//                            $student->{$studentField} = collect($value->{$studentField})->implode(',');
//                        } else {
//                            $student->{$studentField} = $value->{$studentField};
//
//                        }
//                    }
//                }
//
//
//                $student->academic_subject_ids = null;
//
//                $student->first_name = $value->full_name;
//                $student->father_name = $value->student->father_name;
//                $student->mother_name = $value->student->mother_name;
//                $student->date_of_birth = $value->student->date_of_birth;
//                $student->student_contact_number = $value->student->contact_number;
//
//
//
//                $student->unique_code = $unique_code;
//                $student->student_image = 'image-not.png';
//                $student->site_id = 73;
//                $student->client_ip = $clientIP;
//                $student->site_student_admission_declare_id = 55;
//                $student->student_roll_number = 0;
//                $student->menual_form_number = $value->student_roll_number;
//                $student->site_can_approve_student = false;
////                $student->father_nid = null;
//            }
//            $student->save();
//        }
//
//
//
//
//
//        GlobalStudentHistory::where('site_id', 73)->delete();
//
//        GlobalUser::whereIn('id', $student_user_ids)->delete();
//
//
//        return 'ok';
//
//
//    }
//














}
