<?php

namespace App\Http\Controllers\SiteGroup\Exam;

use App\Models\Examinations\Examination;
use App\Models\Package\EduPackage;
use App\Models\Site\Exam\GlobalSiteSubjectExaminationMark;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Session;

class ExamControleSettingController extends Controller
{
    private $eduPackage;
    public function __construct(EduPackage $eduPackage)
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
        $this->eduPackage = $eduPackage;

    }

    private function getSiteGroupId(){
        $site_id=SiteInfo::where('id', Session::get('SITE_ID'))->first();
        $site_group_id=$site_id->site_group_id;
        return $site_group_id;
    }

    public function getSiteGroupExamControleList(Request $request){

        $site_group_id=$this->getSiteGroupId();
        $siteid=SiteInfo::where('site_group_id',$site_group_id)->pluck('id');
        $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->pluck('site_id');

        $data = $request->all();

        $conditon_ids=GlobalSubjectGroupConditionSetting::whereIn('site_id', $siteIDs)
            ->where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('academic_class_id', $request->academic_class_id)
            ->pluck('id')
            ->unique()
            ->values();

        $exam_ids=GlobalSiteSubjectExaminationMark::whereIn('site_subject_group_condition_setting_id', $conditon_ids)
            ->pluck('examination_id')
            ->unique()
            ->values();

        $examination_list=Examination::whereIn('id', $exam_ids)->get();
        return $examination_list;
    }

}
