<?php

namespace App\Http\Controllers\SiteGroup\Exam;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;
use App\Models\Academic\AcademicClass;
use App\Models\Employee\GlobalSiteEmployeeDepartmentClassSubject;
use App\Models\Employee\SiteEmployeeDepartmentClassSubject;
//use App\Models\Site\Employee\Employee;
use App\Models\Site\Exam\GlobalSiteExamDeclares;
use App\Models\Site\Exam\GlobalSiteExamDeclareStudent;
use App\Models\Site\Exam\GlobalSiteExamDeclareStudentSubject;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\SiteGroup\Exam\SiteGroupAnswerPaperDistributionDetail;
use App\Models\SiteGroup\Exam\SiteGroupExamDeclareStore;
use App\Models\SiteGroup\Exam\SiteGroupStudentExamPeaperToken;
use App\Models\SiteGroup\Site\Employee\Employee;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use Session;
use Response;

class SiteGroupBaseExamPaperDistributionController extends SiteGroupProjectController
{
    
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');

    }

    public function index()
    {
        $viewType = "Site Group Exam Answer Paper";
        return view('default.admin.layouts.master', compact('viewType'));
    }


    public function getSiteGroupBaseAnswerPaperDistribution(Request $request){

        $data = $request->all();
        $academic_class_group_ids=$data['academic_class_group_id'];
      
        $examDeclar = SiteGroupExamDeclareStore::where('id', $request->examination_declared_id)->first();

        $getSubjectIDs=GlobalSubjectGroupConditionSetting::where('academic_subject_id', $request->academic_subject_id)
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->whereIn('site_id', $this->siteIds())
            ->where('status', true)
            ->pluck('id')
            ->unique();

          //  dd($getSubjectIDs);

        $site_emp_user_list=GlobalSiteEmployeeDepartmentClassSubject::where('academic_subject_id', $request->academic_subject_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->whereIn('site_id', $this->siteIds())
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->get();


        $site_emp_user_ids=$site_emp_user_list->pluck('user_id')->unique();

        $get_employee_list=Employee::with(['site'=>function($q){
                $q->select('id');
            }])
            ->whereIn('id', $site_emp_user_ids)
            ->whereIn('site_id', $this->siteIds())
            ->select('id','username','site_id')
            ->where('status',true)
            ->get();

        $examDeclaredList = GlobalSiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $examDeclar->examination_id)
            ->whereIn('site_id', $this->siteIds())
            ->where('exam_declared_by', 'site_group')
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            // ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            //     return $query->where('academic_session_id', $data['academic_session_id']);
            // })
            ->pluck('id');

         

        $studentIds=GlobalStudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->whereIn('site_id',$this->siteIds())
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            // ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            //     return $query->where('academic_session_id', $data['academic_session_id']);
            // })
            ->pluck('id');

           

        $declaredStudentHistoryIds=GlobalSiteExamDeclareStudent::with(['globalSiteExamDeclareStudentSubject'=>function($query) use ($getSubjectIDs){
            $query->whereIn('site_subject_group_condition_setting_id', $getSubjectIDs);
            $query->with(['academicExamType']);
         //   $query->where('exam_held_status', true);
        //    $query->where('exam_attendance_status', true);
            $query->select('id', 'academic_exam_type_id', 'examination_id', 'site_exam_routine_id', 'student_history_id',
                'site_exam_declare_id', 'site_exam_declare_student_id');

        },
            'studentHistory'=>function($querys) use ($data){

                $querys->select('id', 'user_id', 'student_roll_number');
                $querys->when(!empty($data['academic_class_group_id']), function ($q) use ($data) {
                    return $q->where('academic_class_group_id', $data['academic_class_group_id']);
                });

            }])
            ->whereIn('site_id',$this->siteIds())
            ->whereIn('site_exam_declare_id', $examDeclaredList)
            ->whereIn('student_history_id', $studentIds)
            ->pluck('student_history_id')
            ->unique();

       
          
        //  return $declaredStudentList;


        // $student_asc_list=[];
        // foreach ($declaredStudentList as $key => $value) {

        //     if(count($value->globalSiteExamDeclareStudentSubject)>0){
        //         $student_asc_list[]=$value;
        //     }

        // }

           // dd($getSubjectIDs);

        $student_declare_subject_ids=GlobalSiteExamDeclareStudentSubject::whereIn('student_history_id',$declaredStudentHistoryIds)
            ->whereIn('site_id',$this->siteIds())
            ->whereIn('site_exam_declare_id', $examDeclaredList)
            ->whereIn('site_subject_group_condition_setting_id', $getSubjectIDs)
            ->where('examination_id',$examDeclar->examination_id)
            ->where('academic_exam_type_id',$request->academic_exam_type_id)
            ->where('exam_attendance_status',true)
            ->pluck('id');

         

        $PaperTokenList=SiteGroupStudentExamPeaperToken::whereIn('site_exam_declare_student_subject_id',$student_declare_subject_ids)
                    ->whereIn('student_history_id',$declaredStudentHistoryIds)
                    ->select('id','peaper_token_no')   
                    ->orderBy('peaper_token_no','ASC')
                    ->get();
                    //->pluck('peaper_token_no');


        $getExamType=GlobalSiteExamDeclareStudentSubject::with(['academicExamType'])
                ->whereIn('site_exam_declare_id', $examDeclaredList)
                ->whereIn('student_history_id', $declaredStudentHistoryIds)
                ->whereIn('site_subject_group_condition_setting_id', $getSubjectIDs)
                ->whereIn('site_id',$this->siteIds())
                ->where('exam_attendance_status',true)
                ->where('academic_exam_type_id',$request->academic_exam_type_id)
                ->distinct('academic_exam_type_id')
                ->select('academic_exam_type_id')
                ->get();

      //  dd($getExamType);

        $getAnswerPaperDistList=SiteGroupAnswerPaperDistributionDetail::where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_subject_id', $request->academic_subject_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('site_group_exam_declare_id', $examDeclar->id)
            ->whereIn('user_id', $site_emp_user_ids)
            ->get();

            //    dd($getAnswerPaperDistList);

        if(count($getAnswerPaperDistList)>0){
            $emp_exam_type_list_arr=Array();
            $emp_exam_type_list_array=[];
            foreach ($get_employee_list as $key => $value) {

                $checkExaminer=$getAnswerPaperDistList->where('user_id', $value->id);
                if(count($checkExaminer)>0){
                    $emp_exam_type_list_arr['select_employee_id']=true;
                }else{
                    $emp_exam_type_list_arr['select_employee_id']=false;
                }
                //$emp_exam_type_list_arr['site_name']=$value->site?$value->site->site_name:'';

                $exam_type_list_arr=Array();
                $exam_type_list_array=[];
                foreach ($getExamType as $keys => $values) {

                    $checkExamType=$checkExaminer->where('academic_exam_type_id', $values->academic_exam_type_id);

                    if(count($checkExamType)>0){
                        $exam_type_list_arr['select_exam_type_id']=true;
                    }else{
                        $exam_type_list_arr['select_exam_type_id']=false;
                    }

                    if(count($checkExamType)>0){
                        $from_to_arr=Array();
                        $exam_token_from_to_array=[];
                        foreach ($checkExamType as $keyst => $valuest) {
                            $from_to_arr['token_from']=$valuest->token_from;
                            $from_to_arr['token_to']=$valuest->token_to;
                            $from_to_arr['select_token_from_to_id']=true;
                            $from_to_arr['id']=$valuest->id;

                            $exam_token_from_to_array[$keyst]=array_merge($from_to_arr, $valuest->toArray());
                        }
                    }else{
                        $exam_token_from_to_array=
                            [
                                [
                                    'token_from'=>0,
                                    'token_to'=>0,
                                    'select_token_from_to_id'=>false,
                                    'id'=>0
                                ]
                            ];
                    }

                    $exam_type_list_arr['exam_token_from_to']=$exam_token_from_to_array;

                    $exam_type_list_array[$keys]=array_merge($exam_type_list_arr, $values->toArray());
                }

                $emp_exam_type_list_arr['exam_type_list']=$exam_type_list_array;

                $emp_exam_type_list_array[$key]=array_merge($emp_exam_type_list_arr, $value->toArray());
            }
        }
         else{

            $emp_exam_type_list_arr=Array();
            $emp_exam_type_list_array=[];
            foreach ($get_employee_list as $key => $value) {

                $exam_type_list_arr=Array();
                $exam_type_list_array=[];
                foreach ($getExamType as $keys => $values) {

                    $exam_token_from_to_array=
                        [
                            [
                                'token_from'=>0,
                                'token_to'=>0,
                                'select_token_from_to_id'=>false,
                                'id'=>0
                            ]
                        ];

                    $exam_type_list_arr['exam_token_from_to']=$exam_token_from_to_array;
                    $exam_type_list_arr['select_exam_type_id']=false;


                    $exam_type_list_array[$keys]=array_merge($exam_type_list_arr, $values->toArray());
                }


                $emp_exam_type_list_arr['exam_type_list']=$exam_type_list_array;
                $emp_exam_type_list_arr['select_employee_id']=false;


                $emp_exam_type_list_array[$key]=array_merge($emp_exam_type_list_arr, $value->toArray());
            }
        }

        return compact('emp_exam_type_list_array', 'PaperTokenList');

    }

    public function saveSiteGroupBaseAnswerPaperDistribution(Request $request){

        $data = $request->all();

        $examDeclar = SiteGroupExamDeclareStore::where('id', $request->examination_declared_id)->first();
 

        $site_emp_user_list=SiteEmployeeDepartmentClassSubject::where('academic_subject_id', $request->academic_subject_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->get();
       

        $site_emp_user_ids=$site_emp_user_list->pluck('user_id')->unique();

        $getAnswerPaperDistList=SiteGroupAnswerPaperDistributionDetail::where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            // ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            //     return $query->where('academic_session_id', $data['academic_session_id']);
            // })
            ->where('academic_subject_id', $request->academic_subject_id)
            ->where('site_group_exam_declare_id', $examDeclar->id)
            ->whereIn('user_id', $site_emp_user_ids)
            ->get();



        $getAnswerPaperDistListIDs=$getAnswerPaperDistList->pluck('id')->unique();


    

        $created=[];
        $edited_list=[];
     //   dd($request['empExamType']);
        foreach ($request['empExamType'] as $key => $value) {

            if($value['select_employee_id']){

                foreach ($value['exam_type_list'] as $keys => $values) {

                    if($values['select_exam_type_id']){
                       
                        foreach ($values['exam_token_from_to'] as $keyst => $valuest) {
                           
                            if($valuest['select_token_from_to_id'] && ($valuest['token_from']<=$valuest['token_to'])){
                              //  dd($valuest['id']);
                                if($valuest['id']){
                                    $edited_list[]=$valuest['id'];


                                    SiteGroupAnswerPaperDistributionDetail::where('id', $valuest['id'])
                                    ->update([
                                        'token_from'=> $valuest['token_from'],
                                        'token_to'=> $valuest['token_to'],
                                      //  'site_subject_group_condition_setting_id'=> $request->site_subject_group_condition_setting_id,
                                        'academic_subject_id'=> $request->academic_subject_id,

                                    ]);


                                }else{
                                  
                                    $created[] = [
                                        'academic_group_id' => Session::get('ACADEMIC_GROUP_ID'),
                                        'academic_class_group_id' => $request->academic_class_group_id,
                                        'academic_year_id' => $request->academic_year_id,
                                        'academic_version_id' => $request->academic_version_id,
                                        'academic_shift_id' => $request->academic_shift_id,
                                        'academic_department_id' => $request->academic_department_id,
                                        'academic_class_id' => $request->academic_class_id,
                                        'academic_session_id' => $request->academic_session_id,
                                        'academic_section_id' => $request->academic_section_id,
                                        'site_group_exam_declare_id' => $examDeclar?$examDeclar->id:null,
                                        'academic_subject_id' =>$request->academic_subject_id,
                                        'academic_exam_type_id' =>$values['academic_exam_type_id'] ,
                                        'examination_id' => $examDeclar->examination_id,
                                        'token_from' => $valuest['token_from'],
                                        'token_to' => $valuest['token_to'],
                                        'user_id' => $value['id'],
                                        'status' => true,
                                        'site_group_id' => Session::get('SITE_GROUP_ID'),

                                    ];

                                  //  dd($created);
                                }



                            }
                        }
                    }
                }
            }

        }

     
        if(count($created)>0){
            SiteGroupAnswerPaperDistributionDetail::insert($created);
        }

       
        $siteAnswerPaperCheck=array_diff($getAnswerPaperDistListIDs->toArray(), $edited_list);
       // dd($edited_list);

       SiteGroupAnswerPaperDistributionDetail::whereIn('id', $siteAnswerPaperCheck)->delete();


        return Response::json(['message' => 'Save Successfully!', 'mode' => 'Save!'], 200);


    }
}
