<?php

namespace App\Http\Controllers\SiteGroup\Exam;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;
use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicSubject;
use App\Models\Site\Exam\GlobalSiteExamDeclares;
use App\Models\Site\Exam\GlobalSiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteSubjectExaminationMark;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\SiteGroup\Exam\SiteGroupExamDeclareStore;
use App\Models\SiteGroup\Exam\SiteGroupStudentExamRoll;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use PDF;

class SiteGroupExamAttendanceReportController extends SiteGroupProjectController
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
    }

    public function index()
    {
        $viewType = "Site Group Exam Settings";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getSiteGroupExamSubjectList(Request $request)
    {

        $data = $request->all();
        $examDeclar = SiteGroupExamDeclareStore::where('id', $request->examination_declared_id)->first();

        $examDeclar_ids = GlobalSiteExamDeclares::where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->whereIn('site_id', $this->siteIds())
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $examDeclar->examination_id)
            ->pluck('id')
            ->unique();

        $site_subject_group_condition_setting_ids = GlobalSiteExamDeclareStudentSubject::whereIn('site_exam_declare_id', $examDeclar_ids)
            ->pluck('site_subject_group_condition_setting_id')
            ->unique()
            ->values();



        $subjectIDs = GlobalSubjectGroupConditionSetting::whereIn('id', $site_subject_group_condition_setting_ids)
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->whereIn('site_id', $this->siteIds())
            // ->when(!empty($request->academic_class_group_id), function ($query) use ($request) {
            //     return $query->where('academic_class_group_ids', 'LIKE', "%$request->academic_class_group_id%");
            // })
            ->pluck('academic_subject_id')
            ->unique();
        $subject_array = AcademicSubject::whereIn('id', $subjectIDs)->get();

        return $subject_array;
    }


    public function getSiteGroupDeclatedExamTypeList(Request $request)
    {

        $data = $request->all();
        $examDeclar = SiteGroupExamDeclareStore::where('id', $request->examination_declared_id)->first();

        $siteExamDeclares = GlobalSiteExamDeclares::where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->whereIn('site_id', $this->siteIds())
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $examDeclar->examination_id)
            ->where('exam_declared_by', 'site_group')
            ->get();

        $examDeclar_ids = $siteExamDeclares->pluck('id')->unique()->values();
        $site_ids = $siteExamDeclares->pluck('site_id')->unique()->values();


        $subjectCondition = GlobalSubjectGroupConditionSetting::whereIn('site_id', $site_ids)
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_subject_id', $request->academic_subject_id)
            ->pluck('id')
            ->unique();


        $academic_exam_type_ids = GlobalSiteExamDeclareStudentSubject::whereIn('site_exam_declare_id', $examDeclar_ids)
            ->whereIn('site_subject_group_condition_setting_id', $subjectCondition)
            ->pluck('academic_exam_type_id')
            ->unique();


        $academicExamType = AcademicExamType::whereIn('id', $academic_exam_type_ids)->get();

        return $academicExamType;
    }

    public function getSiteGroupMarkCountReportPdf(Request $request)
    {
        $data = $request;
        $academicSubject = AcademicSubject::where('id', $data['academic_subject_id'])->first();
        $examType = AcademicExamType::where('id', $data['academic_exam_type_id'])->first();
        $AttendanceCountListArray =  $this->getSiteGroupExamMarkCountReport($request);
        $SiteGroupInfo =   GlobalSiteGroup::where('id', session()->get('SITE_GROUP_ID'))->first();

        //     dd($subjectCondition);
        $examDeclar = SiteGroupExamDeclareStore::with('examination')->where('id', $data['examination_declared_id'])->first();

        $page_tittle = 'Student Exam Mark Report';
        $report_tittle = "Exam Mark Report";
        $report_tittle .= '<br>';
        $report_tittle .= $examDeclar->examination->examination_name;

        $report_tittle2  = 'Subject: ';
        $report_tittle2 .= $academicSubject->subject_name;


        $report_type = '';

        // $site = GlobalSiteInfo::where('id', $SingleSiteListArray['id'])->first();



        $pdf = PDF::loadView(
            'default.admin.site_group.exam.site-all-group-student-wise-mark-pdf',
            compact('SiteGroupInfo', 'AttendanceCountListArray', 'page_tittle', 'report_tittle', 'report_tittle2', 'report_type')
        )
            ->setPaper('a4', 'portrait')
            ->setWarnings(false);

        $path = storage_path() . '/pdf';
        $time = Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return response()->json([
            'link' => route('site_group-open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'
        ], 200);
    }

    public function getSiteGroupExamAttendanceCountReportPdf(Request $request)
    {
        $data = $request;
        $academicSubject = AcademicSubject::where('id', $data['academic_subject_id'])->first();
        $examType = AcademicExamType::where('id', $data['academic_exam_type_id'])->first();
        $AttendanceCountListArray =  $this->getSiteGroupExamAttendanceCountReport($request);
        $SiteGroupInfo =   GlobalSiteGroup::where('id', session()->get('SITE_GROUP_ID'))->first();

        //     dd($subjectCondition);
        $examDeclar = SiteGroupExamDeclareStore::with('examination')->where('id', $data['examination_declared_id'])->first();

        $page_tittle = 'Student Exam Attendance Report';
        $report_tittle = "Exam Attendance Report";
        $report_tittle .= '<br>';
        $report_tittle .= $examDeclar->examination->examination_name;

        $report_tittle2  = 'Subject: ';
        $report_tittle2 .= $academicSubject->subject_name;
        $report_tittle2 .= ' / ';
        $report_tittle2 .= $examType->marks_type;

        $report_type = '';

        // $site = GlobalSiteInfo::where('id', $SingleSiteListArray['id'])->first();



        $pdf = PDF::loadView(
            'default.admin.site_group.exam.site-all-group-student-wise-attendence-pdf',
            compact('SiteGroupInfo', 'AttendanceCountListArray', 'page_tittle', 'report_tittle', 'report_tittle2', 'report_type')
        )
            ->setPaper('a4', 'portrait')
            ->setWarnings(false);

        $path = storage_path() . '/pdf';
        $time = Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return response()->json([
            'link' => route('site_group-open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'
        ], 200);
    }
    public function getSiteGroupExamMarkCountReport(Request $request)
    {
        $data = $request->all();
        $groupId = Session::get('ACADEMIC_GROUP_ID');

        $examDeclar = SiteGroupExamDeclareStore::find($request->examination_declared_id);

        // Get all students for the filter
        $studentHistories = GlobalStudentHistory::where([
            ['academic_version_id', $request->academic_version_id],
            ['academic_shift_id', $request->academic_shift_id],
            ['academic_year_id', $request->academic_year_id],
            ['academic_class_id', $request->academic_class_id],
            ['academic_group_id', $groupId],
            ['status', true],
        ])
            ->whereIn('site_id', $this->siteIds())
            ->when(!empty($data['academic_department_id']), fn($q) => $q->where('academic_department_id', $data['academic_department_id']))
            ->when(!empty($data['academic_class_group_id']), fn($q) => $q->where('academic_class_group_id', $data['academic_class_group_id']))
            ->when(!empty($data['academic_section_id']), fn($q) => $q->where('academic_section_id', $data['academic_section_id']))
            ->when(!empty($data['academic_session_id']), fn($q) => $q->where('academic_session_id', $data['academic_session_id']))
            ->get();

        // Get all site exam declares
        $siteExamDeclares = GlobalSiteExamDeclares::where([
            ['academic_group_id', $groupId],
            ['academic_version_id', $request->academic_version_id],
            ['academic_year_id', $request->academic_year_id],
            ['academic_shift_id', $request->academic_shift_id],
            ['academic_class_id', $request->academic_class_id],
            ['examination_id', $examDeclar->examination_id],
            ['exam_declared_by', 'site_group'],
        ])
            ->whereIn('site_id', $this->siteIds())
            ->get();

        // Get unique site IDs and exam declare IDs
        $siteIds = $siteExamDeclares->pluck('site_id')->unique();
        $siteExamDeclareIdsBySite = $siteExamDeclares->groupBy('site_id');

        // Fetch site info
        $siteInfo = GlobalSiteInfo::whereIn('id', $siteIds)->get()->keyBy('id');

        $results = [];

        // Global totals
        $total_site                 = 0;
        $total_site_student_declar  = 0;
        $total_site_student_present = 0;
        $total_with_marks_count     = 0;
        $total_without_marks_count  = 0;


        $AcademicExamType = AcademicExamType::get();

        foreach ($siteIds as $siteId) {
            $studentsForSite = $studentHistories->where('site_id', $siteId);
            $studentHistoryIds = $studentsForSite->pluck('id');

            // Get subject condition for this site
            $subjectCondition = GlobalSubjectGroupConditionSetting::where([
                ['academic_group_id', $groupId],
                ['site_id', $siteId],
                ['academic_year_id', $request->academic_year_id],
                ['academic_class_id', $request->academic_class_id],
                ['academic_subject_id', $request->academic_subject_id],
            ])->first();

            $siteData = [
                'id' => $siteId,
                'site_name' => $siteInfo[$siteId]->site_name ?? 'Unknown',
                'exam_type_summary' => [],

                'total_student'             => 0,
                'total_present_student'     => 0,
                'total_with_marks_count'    => 0,
                'total_without_marks_count' => 0,
            ];

            if ($subjectCondition) {
                $siteExamDeclareIds = $siteExamDeclareIdsBySite[$siteId]->pluck('id');

                $query = GlobalSiteExamDeclareStudentSubject::whereIn('student_history_id', $studentHistoryIds)
                    ->whereIn('site_exam_declare_id', $siteExamDeclareIds)
                    ->where([
                        ['examination_id', $examDeclar->examination_id],
                        ['site_subject_group_condition_setting_id', $subjectCondition->id],
                    ]);

                if ($request->academic_exam_type_id) {
                    $examSubjects = $query
                        ->where('academic_exam_type_id', $request->academic_exam_type_id)
                        ->get();

                    $total   = $examSubjects->count();
                    $present = $examSubjects->where('exam_attendance_status', true);
                    $absent  = $examSubjects->where('exam_attendance_status', false)->count();

                    // Count students with and without marks
                    $withMarks = $present->filter(function ($item) {
                        return !is_null($item->obtaine_marks);
                    })->count();

                    $withoutMarks = $present->count() - $withMarks;

                    $siteData['exam_type_summary'][] = [
                        'academic_exam_type_id' =>  $AcademicExamType->where('id', $request->academic_exam_type_id)->first()->marks_type ?? 'Unknown',
                        'total'                 => $total,
                        'present'               => $present->count(),
                        'absent'                => $absent,
                        'with_marks_count'      => $withMarks,
                        'without_marks_count'   => $withoutMarks,
                    ];

                    $siteData['total_student'] += $total;
                    $siteData['total_present_student']     = $present->count();
                    $siteData['total_with_marks_count']    = $withMarks;
                    $siteData['total_without_marks_count'] = $withoutMarks;

                } else {
                    // No specific exam type: get all and group
                    $examSubjects = $query->get();
                    $grouped = $examSubjects->groupBy('academic_exam_type_id');

                    foreach ($grouped as $typeId => $subjects) {
                        $count   = $subjects->count();
                        $present = $subjects->where('exam_attendance_status', true);
                        $absent  = $subjects->where('exam_attendance_status', false)->count();

                        $withMarks = $present->filter(function ($item) {
                            return !is_null($item->obtaine_marks);
                        })->count();

                        $withoutMarks = $present->count() - $withMarks;

                        $siteData['exam_type_summary'][] = [
                            'academic_exam_type_id' =>   $AcademicExamType->where('id', $typeId)->first()->marks_type ?? 'Unknown',
                            'total'                 => $count,
                            'present'               => $present->count(),
                            'absent'                => $absent,
                            'with_marks_count'      => $withMarks,
                            'without_marks_count'   => $withoutMarks,
                        ];


                        $siteData['total_student']             += $count;
                        $siteData['total_present_student']     += $present->count();
                        $siteData['total_with_marks_count']    += $withMarks;
                        $siteData['total_without_marks_count'] += $withoutMarks;
                    }
                }
            }

            // Accumulate to global totals (only once per site)
            $total_site                 += 1;
            $total_site_student_declar  += $siteData['total_student'];
            $total_site_student_present += $siteData['total_present_student'];
            $total_with_marks_count     += $siteData['total_with_marks_count'];
            $total_without_marks_count  += $siteData['total_without_marks_count'];

            $results[] = $siteData;
        }

        // Optionally return summary too
        return [
            'site_results' => $results,
            'mark_summary' => [
                'total_site'          => $total_site,
                'total_student'       => $total_site_student_declar,
                'total_present'       => $total_site_student_present,
                'total_without_marks' => $total_without_marks_count,
                'total_with_marks'    => $total_with_marks_count,
            ]
        ];
    }
    public function getSiteGroupExamAttendanceCountReport(Request $request)
    {
        $data = $request->all();
        $groupId = Session::get('ACADEMIC_GROUP_ID');

        $examDeclar = SiteGroupExamDeclareStore::find($request->examination_declared_id);

        // Get all students for the filter
        $studentHistories = GlobalStudentHistory::where([
            ['academic_version_id', $request->academic_version_id],
            ['academic_shift_id', $request->academic_shift_id],
            ['academic_year_id', $request->academic_year_id],
            ['academic_class_id', $request->academic_class_id],
            ['academic_group_id', $groupId],
            ['status', true],
        ])
            ->whereIn('site_id', $this->siteIds())
            ->when(!empty($data['academic_department_id']),  fn($q)  => $q->where('academic_department_id', $data['academic_department_id']))
            ->when(!empty($data['academic_class_group_id']), fn($q)  => $q->where('academic_class_group_id', $data['academic_class_group_id']))
            ->when(!empty($data['academic_section_id']),     fn($q)  => $q->where('academic_section_id', $data['academic_section_id']))
            ->when(!empty($data['academic_session_id']),     fn($q)  => $q->where('academic_session_id', $data['academic_session_id']))
            ->get();

        // Get all site exam declares
        $siteExamDeclares = GlobalSiteExamDeclares::where([
            ['academic_group_id', $groupId],
            ['academic_version_id', $request->academic_version_id],
            ['academic_year_id', $request->academic_year_id],
            ['academic_shift_id', $request->academic_shift_id],
            ['academic_class_id', $request->academic_class_id],
            ['examination_id', $examDeclar->examination_id],
            ['exam_declared_by', 'site_group'],
        ])
            ->whereIn('site_id', $this->siteIds())
            ->get();

        // Get unique site IDs and exam declare IDs
        $siteIds = $siteExamDeclares->pluck('site_id')->unique();
        $siteExamDeclareIdsBySite = $siteExamDeclares->groupBy('site_id');

        // Fetch site info
        $siteInfo = GlobalSiteInfo::whereIn('id', $siteIds)->get()->keyBy('id');

        $results = [];

        // Totals
        $total_site_student_declar = 0;
        $total_site_student_present = 0;
        $total_site_student_absent = 0;

        foreach ($siteIds as $siteId) {
            $studentsForSite = $studentHistories->where('site_id', $siteId);
            $studentHistoryIds = $studentsForSite->pluck('id');

            // Get subject condition for this site
            $subjectCondition = GlobalSubjectGroupConditionSetting::where([
                ['academic_group_id', $groupId],
                ['site_id', $siteId],
                ['academic_year_id', $request->academic_year_id],
                ['academic_class_id', $request->academic_class_id],
                ['academic_subject_id', $request->academic_subject_id],
            ])->first();

            $total = $present = $absent = 0;

            if ($subjectCondition) {
                $siteExamDeclareIds = $siteExamDeclareIdsBySite[$siteId]->pluck('id');

                $examSubjects = GlobalSiteExamDeclareStudentSubject::whereIn('student_history_id', $studentHistoryIds)
                    ->whereIn('site_exam_declare_id', $siteExamDeclareIds)
                    ->where([
                        ['examination_id', $examDeclar->examination_id],
                        ['site_subject_group_condition_setting_id', $subjectCondition->id],
                        ['academic_exam_type_id', $request->academic_exam_type_id],
                    ])
                    ->get();

                $total = $examSubjects->count();
                $present = $examSubjects->where('exam_attendance_status', true)->count();
                $absent = $examSubjects->where('exam_attendance_status', false)->count();
            }

            // Accumulate totals
            $total_site_student_declar  += $total;
            $total_site_student_present += $present;
            $total_site_student_absent  += $absent;

            $results[] = [
                'id' => $siteId,
                'site_name' => $siteInfo[$siteId]->site_name ?? 'Unknown',
                'total_student' => $total,
                'total_present_student' => $present,
                'total_absent_student' => $absent,
            ];
        }

        // Return with totals
        return [
            'report' => $results,
            'total_site_student_declar' => $total_site_student_declar,
            'total_site_student_present' => $total_site_student_present,
            'total_site_student_absent' => $total_site_student_absent,
        ];
    }

    public function getSiteGroupExamPresentAbsentReport(Request $request)
    {
        $data = $request->all();
        $groupId = Session::get('ACADEMIC_GROUP_ID');

        $examDeclar = SiteGroupExamDeclareStore::find($request->examination_declared_id);

        // Get all students for the filter
        $studentHistories = GlobalStudentHistory::where([
            ['academic_version_id', $request->academic_version_id],
            ['academic_shift_id', $request->academic_shift_id],
            ['academic_year_id', $request->academic_year_id],
            ['academic_class_id', $request->academic_class_id],
            ['academic_group_id', $groupId],
            ['status', true],
        ])
            ->where('site_id', $data['site_id'])
            ->when(!empty($data['academic_department_id']), fn($q) => $q->where('academic_department_id', $data['academic_department_id']))
            ->when(!empty($data['academic_class_group_id']), fn($q) => $q->where('academic_class_group_id', $data['academic_class_group_id']))
            ->when(!empty($data['academic_section_id']), fn($q) => $q->where('academic_section_id', $data['academic_section_id']))
            ->when(!empty($data['academic_session_id']), fn($q) => $q->where('academic_session_id', $data['academic_session_id']))
            ->get();

        $studentHistoryMap = $studentHistories->load('student')->keyBy('id');

        // Get all site exam declares
        $siteExamDeclares = GlobalSiteExamDeclares::where([
            ['academic_group_id', $groupId],
            ['academic_version_id', $request->academic_version_id],
            ['academic_year_id', $request->academic_year_id],
            ['academic_shift_id', $request->academic_shift_id],
            ['academic_class_id', $request->academic_class_id],
            ['examination_id', $examDeclar->examination_id],
            ['exam_declared_by', 'site_group'],
        ])
            ->where('site_id', $data['site_id'])
            ->get();

        // Get unique site IDs and exam declare IDs
        $siteIds = $siteExamDeclares->pluck('site_id')->unique();
        $siteExamDeclareIdsBySite = $siteExamDeclares->groupBy('site_id');

        // Fetch site info
        $siteInfo = GlobalSiteInfo::whereIn('id', $siteIds)->get()->keyBy('id');

        $results = [];

        $studentsForSite = $studentHistories->where('site_id', $data['site_id']);
        $studentHistoryIds = $studentsForSite->pluck('id');

        // Get subject condition for this site
        $subjectCondition = GlobalSubjectGroupConditionSetting::where([
            ['academic_group_id', $groupId],
            ['site_id', $data['site_id']],
            ['academic_year_id', $request->academic_year_id],
            ['academic_class_id', $request->academic_class_id],
            ['academic_subject_id', $request->academic_subject_id],
        ])
            ->first();

        $total = $present = $absent = 0;

        if ($subjectCondition) {
            $siteExamDeclareIds = $siteExamDeclareIdsBySite[$data['site_id']]->pluck('id');

            $examSubjects = GlobalSiteExamDeclareStudentSubject::whereIn('student_history_id', $studentHistoryIds)
                ->whereIn('site_exam_declare_id', $siteExamDeclareIds)
                ->where([
                    ['examination_id', $examDeclar->examination_id],
                    ['site_subject_group_condition_setting_id', $subjectCondition->id],
                    ['academic_exam_type_id', $request->academic_exam_type_id],
                ])
                ->get();

            $total = $examSubjects->count();
            $present = $examSubjects->where('exam_attendance_status', true);
            $absent = $examSubjects->where('exam_attendance_status', false);
        }

        $academicSubject = AcademicSubject::where('id', $data['academic_subject_id'])->first();
        $examType = AcademicExamType::where('id', $data['academic_exam_type_id'])->first();

        $obtaine_marks_count = 0;
        $without_mark_input_count = 0;

        $results = [
            'id'                    => $data['site_id'],
            'site_name'             => $siteInfo[$data['site_id']]->site_name ?? 'Unknown',
            'academic_subject'      => $academicSubject->subject_name ?? 'Unknown',
            'exam_type'             => $examType->marks_type ?? 'Unknown',
            'total_student'         => $total,
            'obtaine_marks_count'   => 0,
            'without_mark_input_count'   => 0,
            'total_present_student' => $present->transform(function ($item, $key) use ($studentHistoryMap, $examDeclar, &$obtaine_marks_count, &$without_mark_input_count) {
                $history = $studentHistoryMap[$item->student_history_id] ?? null;

                if (!is_null($item->obtaine_marks)) {
                    $obtaine_marks_count++;
                }
                if (is_null($item->obtaine_marks)) {
                    $without_mark_input_count++;
                }

                return [
                    'serial' => $key + 1,
                    'student_history' => $history ? [
                        'full_name'       => $history->full_name,
                        'username'        => $history->student->username ?? null,
                        'full_roll_number' => $history->student_full_roll_number ?? null,
                        'exam_roll_number' =>  SiteGroupStudentExamRoll::where('student_history_id', $history->id)
                            ->where('examination_id', $examDeclar->examination_id)
                            ->orderByDesc('id')
                            ->first()->roll,
                    ] : null,
                    'obtaine_marks'          => $item->obtaine_marks,
                    'exam_attendance_status' => $item->exam_attendance_status,
                    'exam_held_status'       => $item->exam_held_status,
                    'academic_exam_type_id'  => $item->academic_exam_type_id,
                    'site_subject_group_condition_setting_id' => $item->site_subject_group_condition_setting_id,
                ];
            })->sortBy(fn($item) => $item['student_history']['full_roll_number'] ?? '')->values(),

            'total_absent_student' => $absent->transform(function ($item, $key) use ($studentHistoryMap, $examDeclar) {
                $history = $studentHistoryMap[$item->student_history_id] ?? null;

                return [
                    'serial' => $key + 1,
                    'student_history' => $history ? [
                        'full_name'        => $history->full_name,
                        'username'         => $history->student->username ?? null,
                        'full_roll_number' => $history->student_full_roll_number ?? null,
                        'exam_roll_number' =>  SiteGroupStudentExamRoll::where('student_history_id', $history->id)
                            ->where('examination_id', $examDeclar->examination_id)
                            ->orderByDesc('id')
                            ->first()->roll,
                    ] : null,
                    'exam_attendance_status' => $item->exam_attendance_status,
                    'exam_held_status' => $item->exam_held_status,
                    'academic_exam_type_id' => $item->academic_exam_type_id,
                    'site_subject_group_condition_setting_id' => $item->site_subject_group_condition_setting_id,
                ];
            }),
        ];


        $results['obtaine_marks_count'] = $obtaine_marks_count;
        $results['without_mark_input_count'] = $without_mark_input_count;

        return $results;
    }
    public function getSiteGroupMarkReportPdf(Request $request)
    {
        $pdf_type = $request->pdf_type;
        $SingleSiteListArray = $request->SingleSiteListArray;

        $data = $request->form;
        $academicSubject = AcademicSubject::where('id', $data['academic_subject_id'])->first();
        $examType = AcademicExamType::where('id', $data['academic_exam_type_id'])->first();

        //     dd($subjectCondition);
        $examDeclar = SiteGroupExamDeclareStore::with('examination')->where('id', $data['examination_declared_id'])->first();

        $page_tittle = 'Student Exam Mark Report';
        $report_tittle = 'Exam Mark List';
        $report_tittle .= '<br>';
        $report_tittle .= $examDeclar->examination->examination_name;

        $report_tittle2  = 'Subject: ';
        $report_tittle2 .= $academicSubject->subject_name;
        $report_tittle2 .= ' / ';
        $report_tittle2 .= $examType->marks_type;

        $report_type = '';

        $site = GlobalSiteInfo::where('id', $SingleSiteListArray['id'])->first();



        $pdf = PDF::loadView(
            'default.admin.site_group.exam.site-group-student-mark-list-pdf',
            compact('site', 'pdf_type', 'SingleSiteListArray', 'page_tittle', 'report_tittle', 'report_tittle2', 'report_type')
        )
            ->setPaper('a4', 'portrait')
            ->setWarnings(false);

        $path = storage_path() . '/pdf';
        $time = Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return response()->json([
            'link' => route('site_group-open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'
        ], 200);
    }
    public function getSiteGroupExamPresentAbsentReportPdf(Request $request)
    {
        $pdf_type = $request->pdf_type;
        $SingleSiteListArray = $request->SingleSiteListArray;

        $data = $request->form;
        $academicSubject = AcademicSubject::where('id', $data['academic_subject_id'])->first();
        $examType = AcademicExamType::where('id', $data['academic_exam_type_id'])->first();

        //     dd($subjectCondition);
        $examDeclar = SiteGroupExamDeclareStore::with('examination')->where('id', $data['examination_declared_id'])->first();

        $page_tittle = 'Student Exam Attendance Report';
        $report_tittle = $request->pdf_type == 'present' ? 'Present List' : 'Absent List';
        $report_tittle .= '<br>';
        $report_tittle .= $examDeclar->examination->examination_name;

        $report_tittle2  = 'Subject: ';
        $report_tittle2 .= $academicSubject->subject_name;
        $report_tittle2 .= ' / ';
        $report_tittle2 .= $examType->marks_type;

        $report_type = '';

        $site = GlobalSiteInfo::where('id', $SingleSiteListArray['id'])->first();



        $pdf = PDF::loadView(
            'default.admin.site_group.exam.site-group-student-attendence-pdf',
            compact('site', 'pdf_type', 'SingleSiteListArray', 'page_tittle', 'report_tittle', 'report_tittle2', 'report_type')
        )
            ->setPaper('a4', 'portrait')
            ->setWarnings(false);

        $path = storage_path() . '/pdf';
        $time = Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return response()->json([
            'link' => route('site_group-open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'
        ], 200);
    }
}
