<?php

namespace App\Http\Controllers\SiteGroup\Exam;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;
use App\Models\Academic\AcademicClass;
use App\Models\Site\Exam\GlobalSiteExamDeclares;
use App\Models\Site\Exam\GlobalSiteExamDeclareStudent;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\SiteGroup\Exam\SiteGroupStudentExamRoll;
use App\Models\SiteGroup\GlobalSiteGroup;
use Carbon\Carbon;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Session;
use PDF;

class SiteGroupStudentExamRollController extends SiteGroupProjectController
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
    }
    public function getSiteGroupExamRollStudentListPdf(Request $request)
    {
        $SiteGroupExamRollStudentList =  $request->params['SingleSiteListArray'];
        $SiteGroupInfo =   GlobalSiteGroup::where('id', session()->get('SITE_GROUP_ID'))->first();
        $pdf = PDF::loadView(
            'default.admin.site_group.single-site-group-exam-roll-student-pdf',
            compact(
                'SiteGroupExamRollStudentList',
                'SiteGroupInfo',

            )
        )
            ->setPaper('a4','portrait')
            ->setWarnings(false);


        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';
        $route_name = route('open-pdf-file-storage-for-group', [$name]);

        return response()->json([
            'link' => $route_name,
        ], 200);
    }
    public function getSiteGroupExamRollStudentList(Request $request)
    {
        $site = $request->site;
        $data = $request->form;

        $site_array = [
            'id' => $site['id'],
            'site_name' => $site['site_name'],
            'class_list' => '',
            'total_student' => 0,
            'total_roll_created_student' => 0,
            'roll_created_student_list' => []
        ];

        // Get Student History IDs
        $studentHistoryIds = GlobalStudentHistory::where([
                ['academic_version_id', $data['academic_version_id']],
                ['academic_shift_id', $data['academic_shift_id']],
                ['academic_year_id', $data['academic_year_id']],
                ['site_id', $site['id']],
                ['academic_group_id', Session::get('ACADEMIC_GROUP_ID')],
                ['status', true],
            ])
            ->when(!empty($data['academic_class_id']), fn($q) => $q->where('academic_class_id', $data['academic_class_id']))
            ->when(!empty($data['academic_department_id']), fn($q) => $q->where('academic_department_id', $data['academic_department_id']))
            ->when(!empty($data['academic_class_group_id']), fn($q) => $q->where('academic_class_group_id', $data['academic_class_group_id']))
            ->when(!empty($data['academic_section_id']), fn($q) => $q->where('academic_section_id', $data['academic_section_id']))
            ->when(!empty($data['academic_session_id']), fn($q) => $q->where('academic_session_id', $data['academic_session_id']))
            ->pluck('id')
            ->unique();

        // Fetch Exam Declaration
        $examDeclare = GlobalSiteExamDeclares::where([
            ['site_id', $site['id']],
            ['academic_year_id', $data['academic_year_id']],
            ['academic_shift_id', $data['academic_shift_id']],
            ['academic_class_id', $data['academic_class_id']],
            ['examination_id', $data['examination_id']],
        ])->first();

        if ($examDeclare) {
            $studentIds = GlobalSiteExamDeclareStudent::where([
                    ['site_id', $site['id']],
                    ['site_exam_declare_id', $examDeclare->id],
                ])
                ->whereIn('student_history_id', $studentHistoryIds)
                ->orderBy('student_history_id')
                ->pluck('student_history_id')
                ->unique();

            $site_array['total_student'] = $studentIds->count();

            $rolls = SiteGroupStudentExamRoll::whereIn('student_history_id', $studentIds)
                ->where('examination_id', $data['examination_id'])
                ->with('studentHistory.student')
                ->orderByDesc('id')
                ->get();

            $site_array['total_roll_created_student'] = $rolls->count();
            $site_array['roll_created_student_list'] = $rolls->map(function ($item) {
                return [
                    'student_name' => $item->studentHistory->full_name ?? '',
                    'student_user_name' => $item->studentHistory->student->username ?? '',
                    'student_roll' => $item->roll ?? '',
                    'site_id' => $item->site_id,
                    'examination_id' => $item->examination_id,
                ];
            });

            // Determine Class List
            if (!empty($data['academic_class_id'])) {
                $classList = AcademicClass::where('id', $data['academic_class_id'])->get();
            } else {
                $classIds = GlobalSiteShiftClassGroupSectionSetting::whereIn('site_id', $this->siteIds())
                    ->where([
                        ['academic_version_id', $data['academic_version_id']],
                        ['academic_year_id', $data['academic_year_id']],
                        ['academic_shift_id', $data['academic_shift_id']],
                        ['academic_group_id', Session::get('ACADEMIC_GROUP_ID')],
                    ])
                    ->whereNotNull('academic_class_id')
                    ->pluck('academic_class_id')
                    ->unique();

                $classList = AcademicClass::whereIn('id', $classIds)->get();
            }

            $site_array['class_list'] = $classList->map(function ($class) use ($site) {
                return [
                    'select_class_id' => false,
                    'site_id' => $site['id'],
                    'id' => $class->id,
                    'class_name' => $class->class_name,
                ];
            });
        }

        return $site_array;
    }

    public function getSiteGroupExamRoll(Request $request)
    {

        $data = $request->all();
        $siteInfo = GlobalSiteInfo::whereIn('id', $this->siteIds())->get();

        $site_array = [];

        foreach ($siteInfo as $key => $site) {

            $studentHistorIds = GlobalStudentHistory::where('academic_version_id', $request->academic_version_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('site_id', $site->id)
                ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                ->when(!empty($data['academic_class_id']), function ($q) use ($data) {
                    $q->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->where('status', true)
                ->pluck('id')
                ->unique();


            $site_exam_declare = GlobalSiteExamDeclares::where('site_id', $site->id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->where('examination_id', $request->examination_id)
                ->first();
            if ($site_exam_declare) {


                $student_history_ids = GlobalSiteExamDeclareStudent::where('site_id', $site->id)
                    ->where('site_exam_declare_id', $site_exam_declare->id)
                    ->whereIn('student_history_id', $studentHistorIds)
                    //  ->where('examination_id',$request->examination_id)
                    ->orderBy('student_history_id')
                    ->pluck('student_history_id')
                    ->unique();


                $total_student = $student_history_ids->count();
                // $student_history_ids=$studentHistoryList->pluck('id')->unique();

                $total_roll_created_student = SiteGroupStudentExamRoll::whereIn('student_history_id', $student_history_ids)
                    ->where('examination_id', $request->examination_id)
                    ->orderBy('id', 'DESC')
                    ->count();

                //  dd($students);

                if ($request->academic_class_id) {
                    $classList = AcademicClass::where('id', $request->academic_class_id)->get();
                } else {
                    $academicClassList = GlobalSiteShiftClassGroupSectionSetting::whereIn('site_id', $this->siteIds())
                        ->where('academic_version_id', $request->academic_version_id)
                        ->where('academic_year_id', $request->academic_year_id)
                        ->where('academic_shift_id', $request->academic_shift_id)
                        ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                        ->whereNotNull('academic_class_id')
                        ->distinct()
                        ->pluck('academic_class_id')
                        ->unique();

                    $classList = AcademicClass::whereIn('id', $academicClassList)->get();
                }
                //  dd($classList);
                $classArray = [];
                foreach ($classList as $keys => $class) {
                    $classArray[$keys]['select_class_id'] = false;
                    $classArray[$keys]['site_id'] = $site->id;
                    $classArray[$keys]['id'] = $class->id;
                    $classArray[$keys]['class_name'] = $class->class_name;
                }

                //  dd($classArray);
                $site_array[$key]['id'] = $site->id;
                $site_array[$key]['site_name'] = $site->site_name;
                $site_array[$key]['class_list'] = $classArray;
                $site_array[$key]['total_student'] = $total_student;
                $site_array[$key]['total_roll_created_student'] = $total_roll_created_student;
            } else {
                $site_array[$key]['id'] = $site->id;
                $site_array[$key]['site_name'] = $site->site_name;
                $site_array[$key]['class_list'] = '';
                $site_array[$key]['total_student'] = '';
                $site_array[$key]['total_roll_created_student'] = '';
            }
        }

        return $site_array;
        // dd($site_array);
    }


    public function siteGroupStudentRollGenerate(Request $request)
    {

        $this->validate($request, [
            'academic_version_id' => 'required',
            'academic_year_id' => 'required',
            'academic_shift_id' => 'required',
            'examination_id' => 'required',
        ]);


        $data = $request->all();

        $studentHistoresIds = GlobalStudentHistory::where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $data['class_item']['id'])
            ->where('site_id', $data['class_item']['site_id'])
            ->when(!empty($data['academic_class_id']), function ($q) use ($data) {
                $q->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->orderBy('site_id')
            ->orderBy('id')
            ->where('status', true)
            ->pluck('id')
            ->unique();


        $site_exam_declare = GlobalSiteExamDeclares::where('site_id', $data['class_item']['site_id'])
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->first();

        $student_history_ids = GlobalSiteExamDeclareStudent::where('site_id', $data['class_item']['site_id'])
            ->where('site_exam_declare_id', $site_exam_declare->id)
            ->whereIn('student_history_id', $studentHistoresIds)
            // ->where('examination_id',$request->examination_id)
            ->orderBy('student_history_id')
            ->pluck('student_history_id')
            ->unique();

        // dd($studentHistores);

        foreach ($student_history_ids as $student_history_id) {
            $groupStudentRoll = SiteGroupStudentExamRoll::where('student_history_id', $student_history_id)
                ->where('examination_id', $request->examination_id)
                ->orderBy('id', 'DESC')
                ->first();

            if (!$groupStudentRoll) {
                $checkRoll = SiteGroupStudentExamRoll::orderBy('id', 'DESC')->first();

                if ($checkRoll) {
                    $examination_roll = $checkRoll->roll + 1;
                } else {
                    $examination_roll = 100000 + 1;
                }
                $StudentRoll = new SiteGroupStudentExamRoll();
                $StudentRoll->student_history_id = $student_history_id;
                $StudentRoll->site_id = $data['class_item']['site_id'];
                $StudentRoll->roll = $examination_roll;
                $StudentRoll->examination_id = $request->examination_id;
                $StudentRoll->save();
            }
        }

        return Response::json(['message' => 'Roll Create Successfully!', 'mode' => 'Save'], 200);
    }
}
