<?php

namespace App\Http\Controllers\SiteGroup\Exam;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Examinations\Examination;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use App\Models\Site\Exam\GlobalSiteExaminationExamTypeSetting;
use App\Models\Site\Exam\GlobalSiteSubjectExaminationMark;
use App\Models\Site\Exam\GlobalSiteSubjectExaminationExamTypeMark;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\SiteGroup\Exam\SiteGroupExaminationExamTypeSettingStore;
use App\Models\SiteGroup\Exam\SiteGroupSubjectExaminationMarkStore;
use App\Models\SiteGroup\Exam\SiteGroupSubjectExaminationExamTypeMarkStore;
use App\Models\SiteGroup\Settings\SiteGroupSubjectGroupConditionSettingStore;
use JsonSchema\Exception\ValidationException;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Carbon;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;

use Response;
use Session;
use Exception;
use DB;


class SiteGroupSubjectExaminationMarkSetupController extends SiteGroupProjectController
{
    private $siteGroupExaminationExamTypeSettingStore;
    private $siteGroupSubjectGroupConditionSettingStore;
    private $siteGroupSubjectExaminationMarkStore;
    private $siteGroupSubjectExaminationExamTypeMarkStore;
    private $globalSubjectGroupConditionSetting;
    private $globalSiteSubjectExaminationMark;
    private $globalSiteSubjectExaminationExamTypeMark;

    public function __construct(SiteGroupExaminationExamTypeSettingStore $siteGroupExaminationExamTypeSettingStore,
    SiteGroupSubjectGroupConditionSettingStore $siteGroupSubjectGroupConditionSettingStore,
    SiteGroupSubjectExaminationMarkStore $siteGroupSubjectExaminationMarkStore,
    SiteGroupSubjectExaminationExamTypeMarkStore $siteGroupSubjectExaminationExamTypeMarkStore,
    GlobalSubjectGroupConditionSetting $globalSubjectGroupConditionSetting,
    GlobalSiteSubjectExaminationMark $globalSiteSubjectExaminationMark,
    GlobalSiteSubjectExaminationExamTypeMark $globalSiteSubjectExaminationExamTypeMark)

    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
        $this->siteGroupExaminationExamTypeSettingStore = $siteGroupExaminationExamTypeSettingStore;
        $this->siteGroupSubjectGroupConditionSettingStore = $siteGroupSubjectGroupConditionSettingStore;
        $this->siteGroupSubjectExaminationMarkStore = $siteGroupSubjectExaminationMarkStore;
        $this->siteGroupSubjectExaminationExamTypeMarkStore = $siteGroupSubjectExaminationExamTypeMarkStore;
        $this->globalSubjectGroupConditionSetting = $globalSubjectGroupConditionSetting;
        $this->globalSiteSubjectExaminationMark = $globalSiteSubjectExaminationMark;
        $this->globalSiteSubjectExaminationExamTypeMark = $globalSiteSubjectExaminationExamTypeMark;
    }


    public function getSiteGroupDepartmentClassBaseExaminationList(Request $request){

        $data = $request->all();

            $examinationAll = $this->siteGroupExaminationExamTypeSettingStore
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->pluck('examination_id')
            ->unique();

        $examination_list=Examination::whereIn('id', $examinationAll)->get();
        return $examination_list;
    }

    public function getSiteGroupSubjectListForExamTypeMarksSetup(Request $request)
    {
        $data=$request->all();
        try {

            if (!$data['academic_class_id'] || !$data['academic_year_id']) {
                return Response::json(['message' => 'Select * Marked Field!'], 410);
            }

            $subjectWithMarks = $this->siteGroupSubjectGroupConditionSettingStore
                ->with(['siteGroupSubjectExaminationMarkStore'=>function($q) use ($data){
                    return $q->with(['siteGroupSubjectExaminationExamTypeMarkStore'=>function($qu){
                        $qu->with('academicExamType');
                    }])->where('examination_id',$data['examination_id']);
                },'academicSubject'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->where('status', true)
                ->get();

             //   dd($subjectWithMarks);
                $subject_list=[];
                foreach($subjectWithMarks as $key=>$item){
                    $prisentExamTypelist=$this->siteGroupExaminationExamTypeSettingStore->with(['academicExamType', 'examination'])
                    ->where('academic_class_id', $data['academic_class_id'])
                    ->where('academic_year_id', $data['academic_year_id'])
                    ->where('examination_id', $data['examination_id'])
                    ->when($data['academic_department_id'], function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->where('direct_result_input', false)
                    ->where('status', true)
                    ->get();

                  

                    $exam_type=[];
                    foreach($prisentExamTypelist as $keyss=>$prisent_exam_type){
                       
                        if(count($item->siteGroupSubjectExaminationMarkStore)){
                            $exam_type_list = $item->siteGroupSubjectExaminationMarkStore[0]->siteGroupSubjectExaminationExamTypeMarkStore;
                        if(count($exam_type_list)){
                            $exam_type_item=$exam_type_list->where('academic_exam_type_id', $prisent_exam_type->academic_exam_type_id)->first();
                            if($exam_type_item){  
                                if($exam_type_item->status){
                                    $exam_type[$keyss]['marks']=$exam_type_item->marks;
                                    $exam_type[$keyss]['pass_marks']=$exam_type_item->pass_marks;
                                    $exam_type[$keyss]['exam_type_name']=$exam_type_item->academicExamType->marks_type;
                                    $exam_type[$keyss]['academic_exam_type_id']=$exam_type_item->academic_exam_type_id;
                                    $exam_type[$keyss]['select_exam_type']=true;
                                    $exam_type[$keyss]['countable_marks_status']=$exam_type_item->countable_marks_status;
                                    $exam_type[$keyss]['countable_marks']=$exam_type_item->countable_marks;
                                    $exam_type[$keyss]['countable_persent_of_obtain_marks']=$exam_type_item->countable_persent_of_obtain_marks;
                                }
                               
                            }else{
                                $exam_type[$keyss]['marks']="";
                                $exam_type[$keyss]['pass_marks']="";
                                $exam_type[$keyss]['exam_type_name']=$prisent_exam_type->academicExamType->marks_type;
                                $exam_type[$keyss]['academic_exam_type_id']=$prisent_exam_type->academic_exam_type_id;
                                $exam_type[$keyss]['select_exam_type']=false;
                                $exam_type[$keyss]['countable_marks_status']=false;
                                $exam_type[$keyss]['countable_marks']=null;
                                $exam_type[$keyss]['countable_persent_of_obtain_marks']=null;
                            }
                        }else{
                            $exam_type[$keyss]['marks']="";
                            $exam_type[$keyss]['pass_marks']="";
                            $exam_type[$keyss]['exam_type_name']=$prisent_exam_type->academicExamType->marks_type;
                            $exam_type[$keyss]['academic_exam_type_id']=$prisent_exam_type->academic_exam_type_id;
                            $exam_type[$keyss]['select_exam_type']=false;
                            $exam_type[$keyss]['countable_marks_status']=false;
                            $exam_type[$keyss]['countable_marks']=null;
                            $exam_type[$keyss]['countable_persent_of_obtain_marks']=null;
                        }
                    }else{
                        $exam_type[$keyss]['marks']="";
                        $exam_type[$keyss]['pass_marks']="";
                        $exam_type[$keyss]['exam_type_name']=$prisent_exam_type->academicExamType->marks_type;
                        $exam_type[$keyss]['academic_exam_type_id']=$prisent_exam_type->academic_exam_type_id;
                        $exam_type[$keyss]['select_exam_type']=false;
                        $exam_type[$keyss]['countable_marks_status']=false;
                        $exam_type[$keyss]['countable_marks']=null;
                        $exam_type[$keyss]['countable_persent_of_obtain_marks']=null;
                    }
                }
                if(count($item->siteGroupSubjectExaminationMarkStore)){
                    $subject_list[$key]['site_group_subject_group_condition_setting_id']=$item->siteGroupSubjectExaminationMarkStore[0]->site_group_subject_group_condition_setting_id;
                    $subject_list[$key]['marks']=$item->siteGroupSubjectExaminationMarkStore[0]->marks;
                    $subject_list[$key]['pass_marks']=$item->siteGroupSubjectExaminationMarkStore[0]->pass_marks;
                }else{
                    $subject_list[$key]['site_group_subject_group_condition_setting_id']="";
                    $subject_list[$key]['marks']="";
                    $subject_list[$key]['pass_marks']=""; 
                }
                     $subject_list[$key]['subject_name']=$item->academicSubject->subject_name;
                     $subject_list[$key]['academic_subject_id']=$item->academic_subject_id;
                     $subject_list[$key]['subject_exam_type']=$exam_type;
            }

            // exist site list
       // existing site ids

      
  
            if (count($subjectWithMarks)) {

                $existingSiteIds = $this->globalSubjectGroupConditionSetting
                    ->with([
                        'globalSiteSubjectExaminationMark' => function ($query) use ($data) {
                            $query->with([
                                'globalSiteSubjectExaminationExamTypeMark' => function ($subQuery) {
                                    $subQuery->with('academicExamType');
                                }
                            ])->where('examination_id', $data['examination_id']);
                        },
                        'academicSubject'
                    ])
                    ->whereHas('globalSiteSubjectExaminationMark', function ($query) use ($data) {
                        $query->where('examination_id', $data['examination_id'])
                            ->whereHas('globalSiteSubjectExaminationExamTypeMark');
                    })
                    ->where('academic_class_id', $data['academic_class_id'])
                    ->where('academic_year_id', $data['academic_year_id'])
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                    ->whereIn('site_id', $this->siteIds())
                    ->where('status', true)
                    ->pluck('site_id')
                    ->unique()
                    ->values();

            //  return $existingSiteIds;
        
        }else{
            $existingSiteIds=[];
        }
                 
            return response()->json(['subject_list'=>$subject_list,'site_ids'=>$existingSiteIds]);
       } catch (Exception $exception) {
           return $exception->getMessage();

       }
    }

    public function siteGroupSubjectListForExamTypeMarksSetupSubmit(Request $request){
       
        DB::beginTransaction();
        try {
        $site_group_id=Session::get('SITE_GROUP_ID');
        $academic_group_id=Session::get('ACADEMIC_GROUP_ID');

        $this->validate($request, [
            'academic_class_id' => 'required',
            'academic_year_id' => 'required',
            'examination_id' => 'required',
        ]);

        $data=$request->all();

        $class_id = $request->academic_class_id;
        $department_id = $request->academic_department_id;
        $year_id = $request->academic_year_id;
        $examinationId = $request->examination_id;
        $subjects = $request->subject_list;

        $sg_groupCondition = $this->siteGroupSubjectGroupConditionSettingStore->where('academic_class_id', $data['academic_class_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->get();

        $groupCondition = $this->globalSubjectGroupConditionSetting->where('academic_class_id', $data['academic_class_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('academic_group_id', $academic_group_id)
            ->where('status', true)
            ->get();
     
        if (count($subjects) > 0) {
            foreach ($subjects as $key => $val) {
           
                if(is_null($val['site_group_subject_group_condition_setting_id'])){
                    $sg_groupCnditionSetting=$sg_groupCondition->where('academic_subject_id', $val['academic_subject_id'])->first();
                    if($sg_groupCnditionSetting){
                        $sg_SubjectGroupConditionSettingID = $sg_groupCnditionSetting->id;
                    }
                }else{
                    $sg_SubjectGroupConditionSettingID = $val['site_group_subject_group_condition_setting_id'];
                }
          
                $examExist = $this->siteGroupSubjectExaminationMarkStore
                    ->with('siteGroupSubjectExaminationExamTypeMarkStore')->where('examination_id', $examinationId)
                    ->where('site_group_subject_group_condition_setting_id', $sg_SubjectGroupConditionSettingID)
                    ->first();

                if($examExist){

                    $examExist->update([
                        'marks' => $val['marks'],
                        'pass_marks' => $val['pass_marks'],
                        'status' => true,
                    ]);

                    $siteGroupSubjectExaminationMarkId=$examExist->id;
                }else{
                 
                    $this->siteGroupSubjectExaminationMarkStore= new $this->siteGroupSubjectExaminationMarkStore;

                    $this->siteGroupSubjectExaminationMarkStore->site_group_subject_group_condition_setting_id=$sg_SubjectGroupConditionSettingID;
                    $this->siteGroupSubjectExaminationMarkStore->examination_id=$examinationId;
                    $this->siteGroupSubjectExaminationMarkStore->marks=$val['marks']?$val['marks']:0;
                    $this->siteGroupSubjectExaminationMarkStore->status=true;
                    $this->siteGroupSubjectExaminationMarkStore->pass_marks=$val['pass_marks']?$val['pass_marks']:0;
                    $this->siteGroupSubjectExaminationMarkStore->save();

                    $siteGroupSubjectExaminationMarkId=$this->siteGroupSubjectExaminationMarkStore->id;

                }

                foreach ($val['subject_exam_type'] as $keyl => $valuel) {

                
                    if($valuel['select_exam_type']){
                     
                        $examTypeExist = $this->siteGroupSubjectExaminationExamTypeMarkStore
                            ->where('academic_exam_type_id', $valuel['academic_exam_type_id'])
                            ->where('site_group_subject_examination_mark_id', $siteGroupSubjectExaminationMarkId)
                            ->first();

                        if(is_null($valuel['marks'])){
                            $countable_percent=100;
                           
                        }else{
                            if(is_null($valuel['countable_marks'])){
                                $countable_percent=100;
                            }else{
                                $countable_percent=($valuel['countable_marks']/$valuel['marks'])*100;

                            }
                        }

                        if($examTypeExist){

                            $examTypeExist->marks       =   $valuel['marks'];
                            $examTypeExist->status      =   true;
                            $examTypeExist->pass_marks  =   $valuel['pass_marks'];
                            $examTypeExist->countable_marks_status  =   $valuel['countable_marks_status'];
                            
                            if($examTypeExist->countable_marks_status){

                                if(!is_null($valuel['countable_marks'])){
                                    $examTypeExist->countable_marks=$valuel['countable_marks']?$valuel['countable_marks']:0;
                                    $examTypeExist->countable_persent_of_obtain_marks=$countable_percent?$countable_percent:100;

                                }else{
                                    $examTypeExist->countable_marks=$valuel['marks']?$valuel['marks']:null;
                                    $examTypeExist->countable_persent_of_obtain_marks=100;
                                }
                            }else{
                                $examTypeExist->countable_marks = $valuel['marks']?$valuel['marks']:0;
                                $examTypeExist->countable_persent_of_obtain_marks=$countable_percent?$countable_percent:100;
                            }
                           
                            $examTypeExist->save();

                        }else{
                            $this->siteGroupSubjectExaminationExamTypeMarkStore=new $this->siteGroupSubjectExaminationExamTypeMarkStore;

                            $this->siteGroupSubjectExaminationExamTypeMarkStore->site_group_subject_examination_mark_id=$siteGroupSubjectExaminationMarkId;
                            $this->siteGroupSubjectExaminationExamTypeMarkStore->academic_exam_type_id=$valuel['academic_exam_type_id'];
                            $this->siteGroupSubjectExaminationExamTypeMarkStore->marks=$valuel['marks']?$valuel['marks']:0;
                            $this->siteGroupSubjectExaminationExamTypeMarkStore->status=true;
                            $this->siteGroupSubjectExaminationExamTypeMarkStore->pass_marks=$valuel['pass_marks']?$valuel['pass_marks']:0;
                            $this->siteGroupSubjectExaminationExamTypeMarkStore->countable_marks_status=$valuel['countable_marks_status']?$valuel['countable_marks_status']:false;

                            if($valuel['countable_marks_status']){

                                if(!is_null($valuel['countable_marks'])){
                                    $this->siteGroupSubjectExaminationExamTypeMarkStore->countable_marks=$valuel['countable_marks']?$valuel['countable_marks']:0;
                                    $this->siteGroupSubjectExaminationExamTypeMarkStore->countable_persent_of_obtain_marks=$countable_percent?$countable_percent:100;

                                }else{
                                    $this->siteGroupSubjectExaminationExamTypeMarkStore->countable_marks=$valuel['marks']?$valuel['marks']:null;
                                    $this->siteGroupSubjectExaminationExamTypeMarkStore->countable_persent_of_obtain_marks=100;
                                }
                            }else{
                                $this->siteGroupSubjectExaminationExamTypeMarkStore->countable_marks=$valuel['marks']?$valuel['marks']:null;
                                $this->siteGroupSubjectExaminationExamTypeMarkStore->countable_persent_of_obtain_marks=100;
                            }
                            
                            $this->siteGroupSubjectExaminationExamTypeMarkStore->save();
                        }

                    }else{
                        
                        $sg_examTypeExists = $this->siteGroupSubjectExaminationExamTypeMarkStore
                            ->where('academic_exam_type_id', $valuel['academic_exam_type_id'])
                            ->where('site_group_subject_examination_mark_id', $siteGroupSubjectExaminationMarkId)
                            ->first();
                         
                        if($sg_examTypeExists){
                            $sg_examTypeExists->delete();
                        }

                    }

                }
                
                $sg_examExist = $this->siteGroupSubjectExaminationMarkStore->with('siteGroupSubjectExaminationExamTypeMarkStore')->where('examination_id', $examinationId)
                ->where('site_group_subject_group_condition_setting_id', $sg_SubjectGroupConditionSettingID)
                ->first();
         
                if($sg_examExist){
          
                    if(count($sg_examExist->siteGroupSubjectExaminationExamTypeMarkStore)<=0){
                        $sg_examExist->delete();
                    }
                   
                }

            // site settings start
        foreach($request->site_ids as $site_id){   
          //  dd($site_id);
            $groupCnditionSetting=$groupCondition->where('site_id', $site_id)->where('academic_subject_id', $val['academic_subject_id'])->first();
            if($groupCnditionSetting){
                $SubjectGroupConditionSettingID = $groupCnditionSetting->id;
           // }
            // else{
            //     return Response::json(['message' => 'somethinks is wrong'], 410);
            // }
       
        $examExist = $this->globalSiteSubjectExaminationMark->with('globalSiteSubjectExaminationExamTypeMark')->where('examination_id', $examinationId)
            ->where('site_subject_group_condition_setting_id', $SubjectGroupConditionSettingID)
            ->where('academic_group_id', $academic_group_id)
            ->where('site_id', $site_id)
            ->first();

        if($examExist){
            $examExist->update([
                'marks' => $val['marks'],
                'pass_marks' => $val['pass_marks'],
                'status' => true,
            ]);

            $globalSiteSubjectExaminationMarkId=$examExist->id;
        }else{
            $this->globalSiteSubjectExaminationMark= new $this->globalSiteSubjectExaminationMark;
            $this->globalSiteSubjectExaminationMark->site_subject_group_condition_setting_id=$SubjectGroupConditionSettingID;
            $this->globalSiteSubjectExaminationMark->examination_id=$examinationId;
            $this->globalSiteSubjectExaminationMark->marks=$val['marks']?$val['marks']:0;
            $this->globalSiteSubjectExaminationMark->academic_group_id=$academic_group_id;
            $this->globalSiteSubjectExaminationMark->site_id=$site_id;
            $this->globalSiteSubjectExaminationMark->status=true;
            $this->globalSiteSubjectExaminationMark->pass_marks=$val['pass_marks']?$val['pass_marks']:0;
            $this->globalSiteSubjectExaminationMark->save();
            $globalSiteSubjectExaminationMarkId=$this->globalSiteSubjectExaminationMark->id;
        }

        foreach ($val['subject_exam_type'] as $keyl => $valuel) {
            if($valuel['select_exam_type']){
                $examTypeExist = $this->globalSiteSubjectExaminationExamTypeMark
                    ->where('academic_exam_type_id', $valuel['academic_exam_type_id'])
                    ->where('site_subject_examination_mark_id', $globalSiteSubjectExaminationMarkId)
                    ->where('academic_group_id', $academic_group_id)
                    ->where('site_id', $site_id)
                    ->first();

                if(is_null($valuel['marks'])){
                    $countable_percent=100;
                }else{
                    if(is_null($valuel['countable_marks'])){
                        $countable_percent=100;
                    }else{
                        $countable_percent=($valuel['countable_marks']/$valuel['marks'])*100;
                    }
                }

                if($examTypeExist){
                    $examTypeExist->marks       =   $valuel['marks'];
                    $examTypeExist->status      =   true;
                    $examTypeExist->pass_marks  =   $valuel['pass_marks'];
                    $examTypeExist->countable_marks_status  =   $valuel['countable_marks_status'];
                    
                    if($examTypeExist->countable_marks_status){
                        if(!is_null($valuel['countable_marks'])){
                            $examTypeExist->countable_marks=$valuel['countable_marks']?$valuel['countable_marks']:0;
                            $examTypeExist->countable_persent_of_obtain_marks=$countable_percent?$countable_percent:100;
                        }else{
                            $examTypeExist->countable_marks=$valuel['marks']?$valuel['marks']:null;
                            $examTypeExist->countable_persent_of_obtain_marks=100;
                        }
                    }else{
                        $examTypeExist->countable_marks = $valuel['marks']?$valuel['marks']:0;
                        $examTypeExist->countable_persent_of_obtain_marks=$countable_percent?$countable_percent:100;
                    }
                   
                    $examTypeExist->save();
                }else{
                    $this->globalSiteSubjectExaminationExamTypeMark=new $this->globalSiteSubjectExaminationExamTypeMark;
                    $this->globalSiteSubjectExaminationExamTypeMark->site_subject_examination_mark_id=$globalSiteSubjectExaminationMarkId;
                    $this->globalSiteSubjectExaminationExamTypeMark->academic_exam_type_id=$valuel['academic_exam_type_id'];
                    $this->globalSiteSubjectExaminationExamTypeMark->marks=$valuel['marks']?$valuel['marks']:0;
                    $this->globalSiteSubjectExaminationExamTypeMark->academic_group_id=$academic_group_id;
                    $this->globalSiteSubjectExaminationExamTypeMark->site_id=$site_id;
                    $this->globalSiteSubjectExaminationExamTypeMark->status=true;
                    $this->globalSiteSubjectExaminationExamTypeMark->pass_marks=$valuel['pass_marks']?$valuel['pass_marks']:0;
                    $this->globalSiteSubjectExaminationExamTypeMark->countable_marks_status=$valuel['countable_marks_status']?$valuel['countable_marks_status']:false;
                    if($valuel['countable_marks_status']){

                        if(!is_null($valuel['countable_marks'])){
                            $this->globalSiteSubjectExaminationExamTypeMark->countable_marks=$valuel['countable_marks']?$valuel['countable_marks']:0;
                            $this->globalSiteSubjectExaminationExamTypeMark->countable_persent_of_obtain_marks=$countable_percent?$countable_percent:100;
                        }else{
                            $this->globalSiteSubjectExaminationExamTypeMark->countable_marks=$valuel['marks']?$valuel['marks']:null;
                            $this->globalSiteSubjectExaminationExamTypeMark->countable_persent_of_obtain_marks=100;
                        }
                    }else{
                        $this->globalSiteSubjectExaminationExamTypeMark->countable_marks=$valuel['marks']?$valuel['marks']:null;
                        $this->globalSiteSubjectExaminationExamTypeMark->countable_persent_of_obtain_marks=100;
                    }
                    $this->globalSiteSubjectExaminationExamTypeMark->save();
                }

            }else{
                
                $examTypeExists = $this->globalSiteSubjectExaminationExamTypeMark
                    ->where('academic_group_id', $academic_group_id)
                    ->where('site_id', $site_id)
                    ->where('academic_exam_type_id', $valuel['academic_exam_type_id'])
                    ->where('site_subject_examination_mark_id', $globalSiteSubjectExaminationMarkId)
                    ->first();
                 
                if($examTypeExists){
                    $examTypeExists->delete();
                }

            }

        }
        
        $examExist = $this->globalSiteSubjectExaminationMark->with('globalSiteSubjectExaminationExamTypeMark')->where('examination_id', $examinationId)
            ->where('academic_group_id', $academic_group_id)
            ->where('site_id', $site_id)
            ->where('site_subject_group_condition_setting_id', $SubjectGroupConditionSettingID)
            ->first();

           // dd($examExist);

        if($examExist){

            if(count($examExist->globalSiteSubjectExaminationExamTypeMark)<=0){
                $examExist->delete();
            }
         }
         }
            // site settings end
         }

        }

        }

        DB::commit();
        return Response::json(['message' => 'Exam Marks Update' . ' Successfully!']);
       

    }  catch (ValidationException $exception) {
        DB::rollBack();
        return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (Exception $exception) {
        DB::rollBack();
        return Response::json(['message' => $exception->getMessage()], 410);
    }

    }
}
