<?php

namespace App\Http\Controllers\SiteGroup\ExamResult;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;
use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Examinations\Examination;
use App\Models\Site\Exam\GlobalSiteExamDeclares;
use App\Models\Site\Exam\GlobalSiteExamDeclareStudentSubject;
use App\Models\Site\Exam\GlobalSiteExaminationExamTypeSetting;
use App\Models\Site\Exam\GlobalSiteSubjectExaminationMark;
use App\Models\Site\Result\GlobalSiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\GlobalSiteStudentPrimaryResultDetail;
use App\Models\Site\Result\SiteIndividualCombineSubjectResultStore;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\SiteGroup\Exam\SiteGroupStudentExamRoll;
use App\Models\SiteGroup\ExamResult\SiteGroupResultPrimarySettingStore;
use App\Models\SiteGroup\ExamResult\SiteGroupResultSystemSettingStore;
use App\Models\SiteGroup\Settings\SiteGroupAcademicSettingsStore;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use Carbon\Carbon;
use Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;


class SiteGroupExamResultGenerateController extends SiteGroupProjectController
{
    private $siteGroupSettings;
    private $globalSiteIndividualCombineSubjectResultStore;

    public function __construct(SiteGroupAcademicSettingsStore $siteGroupSettings, GlobalSiteIndividualCombineSubjectResultStore $globalSiteIndividualCombineSubjectResultStore)
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
        $this->siteGroupSettings = $siteGroupSettings;
    }

    public function index()
    {
        //  dd('sf');
        $viewType = "Site Group Exam Result Generate";
        return view('default.admin.layouts.master', compact('viewType'));
    }
    public function getStudenthistoryList(Request $request, $site_ids)
    {
        $data = $request->all();

        $studentList = GlobalStudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_group_id', session()->get('ACADEMIC_GROUP_ID'))
            // ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            //     return $query->where('academic_department_id', $data['academic_department_id']);
            // })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->whereIn('site_id', $site_ids)
            ->where('status', true)
            ->get();

        return $studentList;
    }

    public function getStieGroupBaseMeritListResultTypeList(Request $request)
    {
        $data = $request->all();

        $siteExamDeclares = GlobalSiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('exam_declared_by', 'site_group')
            // ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            //     return $query->where('academic_department_id', $data['academic_department_id']);
            // })
            // ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            //     return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            // })
            ->where('status', true)
            ->get();

        $site_ids = $siteExamDeclares->pluck('site_id');
        $studentList = $this->getStudenthistoryList($request, $site_ids);
        $student_ids = $studentList->pluck('id');
       
        $primary_exam_type_ids = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_ids)
            ->pluck('academic_result_primary_type_id')
            ->unique()
            ->filter();


        $result_primary_type_list = AcademicResultPrimaryType::whereIn('id', $primary_exam_type_ids)->where('use_key', 'site_group')
            ->get(['id', 'name']);

        return $result_primary_type_list;
    }
    public function getStieGroupBaseResultTypeList(Request $request)
    {


        $data = $request->all();

        $resultSettingList = SiteGroupResultPrimarySettingStore::with(['academicResultPrimaryType', 'examination'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();

        //            ->distinct('academic_result_primary_type_id')
        //            ->pluck('academic_result_primary_type_id');


        $resultSettingListIds = $resultSettingList->pluck('academic_result_primary_type_id')->unique()->filter();

        $siteExamDeclares = GlobalSiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('exam_declared_by', 'site_group')
            // ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            //     return $query->where('academic_department_id', $data['academic_department_id']);
            // })
            // ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            //     return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            // })
            ->where('status', true)
            ->get();

        $site_ids = $siteExamDeclares->pluck('site_id');


        //  return $resultSettingListIds;

        $academic_result_primary_type_id_array = [];
        foreach ($resultSettingListIds as $key => $value) {

            $ExaminationFromSetting = $resultSettingList->where('academic_result_primary_type_id', $value);
            $ExaminationIDsFromSetting = $ExaminationFromSetting->pluck('examination_id')->unique();
            $countExaminationFromSetting = count($ExaminationIDsFromSetting);

            $ExaminationFromExamDeclare = $siteExamDeclares->whereIn('examination_id', $ExaminationIDsFromSetting);
            $ExaminationIDsFromExamDeclare = $ExaminationFromExamDeclare->pluck('examination_id')->unique();
            $countExaminationFromExamDeclare = count($ExaminationIDsFromExamDeclare);

            if ($countExaminationFromSetting == $countExaminationFromExamDeclare) {
                $academic_result_primary_type_id_array[] = $value;
            }
        }
        //  dd($academic_result_primary_type_id_array);
        $resultlist_test = AcademicResultPrimaryType::whereIn('id', $academic_result_primary_type_id_array)->get();
        //  dd($resultlist_test);
        $test_arr = array();
        $resultlist = [];
        foreach ($resultlist_test as $key => $value) {

            $student_list_ids = GlobalStudentHistory::where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->whereIn('site_id', $site_ids)
                //                ->where('status', true)
                ->pluck('id');


            $check_result_present = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
                ->where('academic_result_primary_type_id', $value->id)
                ->pluck('id');

            if (count($check_result_present) > 0) {
                $test_arr['result_generate_status'] = true;
            } else {
                $test_arr['result_generate_status'] = false;
            }


            $check_result__publish_emp_panel = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
                ->where('academic_result_primary_type_id', $value->id)
                ->where('result_employee_publish_status', true)
                ->first();

            $check_result_publish_std_panel = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
                ->where('academic_result_primary_type_id', $value->id)
                ->where('result_student_publish_status', true)
                ->first();

            $check_result_publish_public = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
                ->where('academic_result_primary_type_id', $value->id)
                ->where('result_public_publish_status', true)
                ->first();

            if ($check_result__publish_emp_panel) {
                $test_arr['result_employee_publish_status'] = true;
            } else {
                $test_arr['result_employee_publish_status'] = false;
            }


            if ($check_result_publish_std_panel) {
                $test_arr['result_student_publish_status'] = true;
            } else {
                $test_arr['result_student_publish_status'] = false;
            }

            if ($check_result_publish_public) {
                $test_arr['result_public_publish_status'] = true;
            } else {
                $test_arr['result_public_publish_status'] = false;
            }



            $test_arr['loading_result_generate_image'] = false;

            $resultlist[$key] = array_merge($test_arr, $value->toArray());
        }
        return $resultlist;
    }


    public function createUpdateSiteGroupMeritListExamResultGenerate(Request $request)
    {
        $data = $request->all();
        $offset = $request->offset ?? 0;
        $limit = 500;

        // Step 1: Get eligible site IDs
        $examDeclareSiteIds = GlobalSiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->whereIn('site_id', $this->siteIds())
            ->where('exam_declared_by', 'site_group')
            ->where('status', true)
            ->pluck('site_id');

        // Step 2: Get student list
        $studentList = $this->getStudenthistoryList($request, $examDeclareSiteIds);
        $student_list_ids = $studentList->pluck('id');
        $total_students = $student_list_ids->count();

        // Step 3: If no students, exit early
        if ($total_students === 0) {
            return response()->json([
                'message' => 'No students found.',
                'next_offset' => 0,
                'completed_percent' => 100,
                'completed' => true,
            ]);
        }

        // Step 4: Highest marks calculation (only once on offset 0)
        if ($offset === 0) {
            $highest_marks_list = GlobalSiteIndividualCombineSubjectResultStore::select(
                'exam_dependent_academic_subject_id',
                DB::raw('MAX(obtain_total_marks_for_show) as obtain_total_marks_for_show'),
                DB::raw('MAX(obtain_raw_total_marks) as obtain_raw_total_marks')
            )
                ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->whereIn('student_history_id', $student_list_ids)
                ->where('status', true)
                ->groupBy('exam_dependent_academic_subject_id')
                ->get();


            $highest_marks_json = json_encode($highest_marks_list);
        } else {
            $highest_marks_json = $request->highest_marks_json ?? json_encode([]);
        }

        // Step 5: Process result details for current chunk
        $resultDetails = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->join('student_histories', 'site_student_primary_result_details.student_history_id', '=', 'student_histories.id')
            ->orderByDesc('gpa')
            ->orderBy('fail_subject_count')
            ->orderByDesc('sum_of_obtain_raw_total_marks')
            ->orderBy('student_histories.student_roll_number')
            ->select('site_student_primary_result_details.*')
            ->skip($offset)
            ->take($limit)
            ->get();

        // Step 6: Check if finished
        if ($resultDetails->isEmpty()) {
            return response()->json([
                'message' => 'Merit list generation completed.',
                'next_offset' => $offset,
                'completed_percent' => 100,
                'completed' => true
            ]);
        }

        // Step 7: Update each student's result info
        $central_rank = $offset + 1;

        foreach ($resultDetails as $result) {
            $result->update([
                'total_student' => $total_students,
                'central_rank' => $central_rank,
                'highest_marks_list' => $highest_marks_json,
            ]);

            $central_rank++;
        }

        // Step 8: Calculate progress and prepare next chunk
        $next_offset = $offset + $limit;
        $raw_percent = $total_students > 0 ? ($next_offset / $total_students) * 100 : 100;
        $isCompleted = $next_offset >= $total_students;
        $completed_percent = $isCompleted ? 100 : max(1, round($raw_percent));

        return response()->json([
            'message' => $isCompleted ? 'Merit list generation completed.' : 'Chunk processed!',
            'next_offset' => $next_offset,
            'totalStudnets' => $total_students,
            'completed_percent' => $completed_percent,
            'completed' => $isCompleted,
            'highest_marks_json' => $highest_marks_json,
        ]);
    }

    public function createUpdateSiteGroupExamResultGenerate(Request $request)
    {

        $data = $request->all();

        $resultSettingList = SiteGroupResultPrimarySettingStore::with(['academicResultPrimaryType', 'examination'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->orderBy('show_position', 'asc')
            ->get(['id', 'academic_result_primary_type_id', 'examination_id', 'marks_percentage', 'show_position']);

        $examination_ids = $resultSettingList->pluck('examination_id');


        $examDeclareList = GlobalSiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->whereIn('examination_id', $examination_ids)
            // ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            //     return $query->where('academic_department_id', $data['academic_department_id']);
            // })
            // ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            //     return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            // })
            ->where('status', true)
            ->where('exam_declared_by', 'site_group')
            ->whereIn('site_id', $this->siteIds())
         //   ->whereIn('site_id', [33,171]) // for testing purpose
            ->get();

      //  $site_ids = $examDeclareList->pluck('site_id');




        //        $examinationlist=Examination::whereIn('id', $resultSettingList)->get();

        $examDeclareListIDs = $examDeclareList->pluck('id');


        if ($request->request_count == 1) {
            $studentMarksAllList = GlobalSiteExamDeclareStudentSubject::with([
                'examination' => function ($query) {
                    $query->get(['id', 'examination_name']);
                },
                'academicExamType' => function ($query) {
                    $query->get(['id', 'marks_type']);
                }
            ])
                ->whereIn('site_exam_declare_id', $examDeclareListIDs)
                ->whereIn('site_id', $this->siteIds())
              //  ->whereIn('site_id', [33,171]) // for testing purpose
             //   ->where('student_history_id', 113036) // for testing purpose
                ->get([
                    'id',
                    'site_exam_declare_id',
                    'site_exam_declare_student_id',
                    'student_history_id',
                    'examination_id',
                    'academic_exam_type_id',
                    'site_subject_group_condition_setting_id',
                    'obtaine_marks',
                    'pass_mark',
                    'countable_obtaine_marks',
                    'exam_type_countable_marks_status',
                    'exam_type_countable_marks',
                    'exam_type_countable_persent_of_obtain_marks',
                    'subject_exam_type_mark',
                    'exam_held_status',
                    'exam_attendance_status'
                ]);

            $studentIdsList = $studentMarksAllList->pluck('student_history_id')->unique()->filter()->values();
            $classAllStudentlist = GlobalStudentHistory::whereIn('id', $studentIdsList)->pluck('id');
        } else {
            $studentMarksAllList = collect($request->studentMarksAllList);
            $studentIdsList = $studentMarksAllList->pluck('student_history_id')->unique()->filter()->values();
            $classAllStudentlist = $request->classAllStudentlist;
        }



        $generateStudentRest = array_diff($studentIdsList->toArray(), $request->select_student_history_ids);

        if (count($generateStudentRest) > 0) {
            $tenStudentIDs = collect($generateStudentRest)->take(200);
        } else {
            $tenStudentIDs = [];
        }

        $generatedStudentIDs = array_merge($tenStudentIDs->toArray(), $request->select_student_history_ids);

        $studentMarksList = $studentMarksAllList->whereIn('student_history_id', $tenStudentIDs);

        $student_list = GlobalStudentHistory::whereIn('id', $tenStudentIDs)->get();

        $student_site_ids = $student_list->pluck('site_id')->unique();


        $subject_condition_setting = GlobalSubjectGroupConditionSetting::with([
            'academicSubjectClassExamCondition',
            'examDependentAcademicSubject',
            'siteSubjectExaminationMark'
        ])
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->whereIn('site_id', $student_site_ids)
          //  ->whereIn('site_id', [33,171]) // for testing purpose
            ->where('status', true)
            ->get();

        //   dd($subject_condition_setting);



        $showTableBellowSubjectIDs = $subject_condition_setting->where('result_show_in_table_bellow', true)
            ->pluck('id')->unique();

        $OtherSubjectIDs = $subject_condition_setting->where('result_show_in_table_bellow', false)
            ->pluck('id')->unique();



        // $globalSiteExamDeclareStudentSubject=GlobalSiteExamDeclareStudentSubject::distinct('examination_id', 'academic_exam_type_id')
        //     ->whereIn('site_exam_declare_id', $examDeclareListIDs)
        //     ->get(['examination_id', 'academic_exam_type_id']);

        // $showTableBellowSubjectExamList=$globalSiteExamDeclareStudentSubject->whereIn('site_subject_group_condition_setting_id', $showTableBellowSubjectIDs);
        // $OtherSubjectExamList=$globalSiteExamDeclareStudentSubject->whereIn('site_subject_group_condition_setting_id', $OtherSubjectIDs);



        $showTableBellowSubjectExamList = $studentMarksAllList
            ->whereIn('site_subject_group_condition_setting_id', $showTableBellowSubjectIDs)
            ->unique(function ($item) {
                return $item['examination_id'] . '-' . $item['academic_exam_type_id'];
            })
            ->values()
            ->all();

        $OtherSubjectExamList = $studentMarksAllList
            ->whereIn('site_subject_group_condition_setting_id', $OtherSubjectIDs)
            ->unique(function ($item) {
                return $item['examination_id'] . '-' . $item['academic_exam_type_id'];
            })
            ->values()
            ->all();


           $grade_list = SiteGroupResultSystemSettingStore::with(['academicResultSystem'])
                ->where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                // ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                //     return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                // })
                ->where('status', true)
                ->get()
                ->sortBy(function ($item) {
                    return $item->academicResultSystem->serial ?? 0;
                });


        // $OtherSubjectExamList=GlobalSiteExamDeclareStudentSubject::distinct('examination_id', 'academic_exam_type_id')
        //     ->whereIn('site_subject_group_condition_setting_id', $OtherSubjectIDs)
        //     ->whereIn('site_exam_declare_id', $examDeclareListIDs)
        //     ->whereIn('site_id',$this->siteIds())
        //     ->whereIn('site_id', $site_ids)
        //     ->get(['examination_id', 'academic_exam_type_id']);

        $filter_for_examination_ids = Examination::whereIn('id', $studentMarksList->pluck('examination_id')
            ->unique()
            ->filter())
            ->get(['id', 'examination_name', 'name_key']);

        $exam_type_arr = array();
        $exam_type_array = [];
        foreach ($filter_for_examination_ids as $key => $value) {

            $get_postions = $resultSettingList->where('examination_id', $value->id)->first();

            $exam_type_ids = $studentMarksList->where('examination_id', $value->id)
                ->whereIn('site_subject_group_condition_setting_id', $OtherSubjectIDs)
                ->pluck('academic_exam_type_id')
                ->unique()
                ->filter();

            $exam_type_ids_for_table_bellow = $studentMarksList->where('examination_id', $value->id)
                ->whereIn('site_subject_group_condition_setting_id', $showTableBellowSubjectIDs)
                ->pluck('academic_exam_type_id')
                ->unique()
                ->filter();

            // exam position wise serial
            $exam_type_setting = GlobalSiteExaminationExamTypeSetting::where('academic_year_id', $request->academic_year_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->where('examination_id', $value->id)
                ->whereIn('academic_exam_type_id', $exam_type_ids)
                ->whereIn('site_id', $student_site_ids)
                ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                ->orderBy('position_show', 'ASC')
                ->get();

            $exam_type_list = [];
            $key = 0;
            foreach ($exam_type_setting as $type_sett) {

                $exam_type = AcademicExamType::where('id', $type_sett->academic_exam_type_id)->first();

                $exam_type_list[$key]['id'] = $exam_type->id;
                $exam_type_list[$key]['marks_type'] = $exam_type->marks_type;
                $exam_type_list[$key]['head_key'] = $exam_type->head_key;
                $key++;
            }

            $unique_exam_type_list = collect($exam_type_list)->unique('id')->values()->all();


            $exam_type_list_for_table_bellow = AcademicExamType::whereIn('id', $exam_type_ids_for_table_bellow)->get(['id', 'marks_type']);

            $exam_type_arr['academic_exam_type_list'] = $unique_exam_type_list;
            $exam_type_arr['grade_setting_list'] = $grade_list;
            $exam_type_arr['academic_exam_type_list_for_table_bellow'] = $exam_type_list_for_table_bellow;
            $exam_type_arr['table_bellow_status'] = count($exam_type_list_for_table_bellow) > 0 ? 1 : 0;
            $exam_type_arr['obtain_marks'] = 'Obt';
            $exam_type_arr['academic_exam_type_count'] = count($unique_exam_type_list);
            $exam_type_arr['exam_type_list_for_table_bellow_count'] = count($exam_type_list_for_table_bellow);
            $exam_type_arr['show_position'] = $get_postions->show_position;
            $exam_type_arr['marks_percentage'] = $get_postions->marks_percentage ?? 0;

            $exam_type_array[$key] = array_merge($exam_type_arr, $value->toArray());
        }


        $exam_type_array_with_sort = array_values(array_sort(collect($exam_type_array), function ($value) {
            return $value['show_position'];
        }));


        $academic_result_primary_type_id = $request->academic_result_primary_type_id;
       

        $student_indivisual_subject_list = $this->studentMarkslist(
            $studentMarksList,
            $student_list,
            $grade_list,
            $resultSettingList,
            $academic_result_primary_type_id,
            $showTableBellowSubjectExamList,
            $OtherSubjectExamList
        );



        $student_ids = collect($student_indivisual_subject_list)->pluck('student_history_id');

        $getSiteStudentPrimaryResultDetail = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('status', true)
            ->get();


        $header_items = [
            'grade_list' => $grade_list,
            'exam_list' => $exam_type_array_with_sort,
        ];

        ////
         $resultSett = SiteGroupResultPrimarySettingStore::with(['academicResultPrimaryType', 'examination'])
            ->where([
                'academic_version_id' => $request->academic_version_id,
                'academic_year_id' => $request->academic_year_id,
                'academic_shift_id' => $request->academic_shift_id,
                'academic_class_id' => $request->academic_class_id,
                'academic_result_primary_type_id' => $request->academic_result_primary_type_id
            ])
          //  ->when($data['academic_department_id'], fn($q) => $q->where('academic_department_id', $data['academic_department_id']))
            ->first();

        $examRolls = SiteGroupStudentExamRoll::whereIn('student_history_id', $student_ids)
            ->where('examination_id', $resultSett->examination_id)
            ->pluck('roll', 'student_history_id');

        foreach ($student_indivisual_subject_list as $key => $value) {

            $examRoll = $examRolls[$value['student_history_id']] ?? null;


            $checkStudentResult = $getSiteStudentPrimaryResultDetail->where('student_history_id', $value['student_history_id'])->first();

            if ($checkStudentResult) {
                $checkStudentResult->update([

                    'gpa' => $value['final_point'],
                    'grade' => $value['final_grade'],
                    'fail_subject_count' => $value['fail_subject_count'],

                    'optional_subject_ids' => $value['optional_subject_ids'],
                    'final_point_without_optional' => $value['final_point_without_optional'],
                    'final_grade_without_optional' => $value['final_grade_without_optional'],
                    'combine_subject_present' => $value['combine_subject_present'],
                    'classtest_is_present' => $value['classtest_is_present'],
                    'exam_attendance_status' => $value['exam_attendance_status'],


                    'sum_of_obtain_raw_total_marks' => ceil($value['sum_of_obtain_raw_total_marks']),
                    'sum_of_obtain_percent_total_marks' => ceil($value['sum_of_obtain_percent_total_marks']),
                    'sum_of_raw_total_marks' => ceil($value['sum_of_raw_total_marks']),
                    'raw_obtain_marks_percentage' => $value['sum_of_obtain_raw_total_marks'] * 100 /
                        ($value['sum_of_raw_total_marks'] ? $value['sum_of_raw_total_marks'] : 1),

                    'sum_of_obtain_raw_total_marks_only_passed_subject' => ceil($value['sum_of_obtain_raw_total_marks_only_passed_subject']),
                    'pass_subject_base_marks_percentage' => $value['pass_subject_base_marks_percentage'],
                    'total_marks_base_percentage' => $value['total_marks_base_percentage'],
                    'pass_subject_base_marks_grade' => $value['pass_subject_base_marks_grade'],
                    'total_marks_base_grade' => $value['total_marks_base_grade'],
                    'pass_subject_base_marks_point' => $value['pass_subject_base_marks_point'],
                    'total_marks_base_point' => $value['total_marks_base_point'],

                    'sum_of_obtain_total_marks_for_show' => $value['sum_of_obtain_total_marks_for_show'],
                    'sum_of_obtain_total_percent_for_show' => $value['sum_of_obtain_total_percent_for_show'],

                   // 'table_header' => json_encode($exam_type_array_with_sort),
                    'table_header' => json_encode($exam_type_array_with_sort),
                    'sheet_header' => json_encode($header_items),
                    'site_individual_combine_subject_result_store_ids' => implode(',', $value['site_individual_combine_subject_result_store_ids']),
                    'site_id' => $value['site_id'],
                    'result_generated_by' => 'site_group',
                    'examination_roll' => $examRoll??'',
                ]);
            } else {

                GlobalSiteStudentPrimaryResultDetail::create([
                    'academic_result_primary_type_id' => $request->academic_result_primary_type_id,
                    'student_history_id' => $value['student_history_id'],
                    'gpa' => $value['final_point'],
                    'grade' => $value['final_grade'],
                    'fail_subject_count' => $value['fail_subject_count'],
                    'exam_attendance_status' => $value['exam_attendance_status'],

                    'optional_subject_ids' => $value['optional_subject_ids'],
                    'final_point_without_optional' => $value['final_point_without_optional'],
                    'final_grade_without_optional' => $value['final_grade_without_optional'],
                    'combine_subject_present' => $value['combine_subject_present'],
                    'classtest_is_present' => $value['classtest_is_present'],

                    'sum_of_obtain_raw_total_marks' => ceil($value['sum_of_obtain_raw_total_marks']),
                    'sum_of_obtain_percent_total_marks' => ceil($value['sum_of_obtain_percent_total_marks']),
                    'sum_of_raw_total_marks' => ceil($value['sum_of_raw_total_marks']),
                    //         'raw_obtain_marks_percentage'=>$value['sum_of_obtain_raw_total_marks']*100/$value['sum_of_raw_total_marks'],

                    'raw_obtain_marks_percentage' => $value['sum_of_obtain_raw_total_marks'] * 100 /
                        ($value['sum_of_raw_total_marks'] ? $value['sum_of_raw_total_marks'] : 1),

                    'sum_of_obtain_raw_total_marks_only_passed_subject' => ceil($value['sum_of_obtain_raw_total_marks_only_passed_subject']),
                    'pass_subject_base_marks_percentage' => $value['pass_subject_base_marks_percentage'],
                    'total_marks_base_percentage' => $value['total_marks_base_percentage'],
                    'pass_subject_base_marks_grade' => $value['pass_subject_base_marks_grade'],
                    'total_marks_base_grade' => $value['total_marks_base_grade'],
                    'pass_subject_base_marks_point' => $value['pass_subject_base_marks_point'],
                    'total_marks_base_point' => $value['total_marks_base_point'],

                    'sum_of_obtain_total_marks_for_show' => ceil($value['sum_of_obtain_total_marks_for_show']),
                    'sum_of_obtain_total_percent_for_show' => $value['sum_of_obtain_total_percent_for_show'],

                    //                'result_detail'=>json_encode($value['subject_list']),
                 //   'table_header' => json_encode($exam_type_array_with_sort),
                    'table_header' => json_encode($exam_type_array_with_sort),
                    'sheet_header' => json_encode($header_items),
                    'site_individual_combine_subject_result_store_ids' => implode(',', $value['site_individual_combine_subject_result_store_ids']),
                    'site_id' => $value['site_id'],
                    'result_generated_by' => 'site_group',
                    'examination_roll' => $examRoll??'',
                ]);
            }
        }

        $count_student = count($classAllStudentlist);
        $completed_percent = ceil(count($generatedStudentIDs) * 100 / $count_student);


        if (count($tenStudentIDs) > 0) {

            return response()->json(
                [
                    'generatedStudentIDs' => $generatedStudentIDs,
                    'studentMarksAllList' => $studentMarksAllList,
                    'count_student' => $count_student,
                    'completed_percent' => $completed_percent,
                    //   'studentMarksAllList'=>$studentMarksAllList->toArray(),
                    'classAllStudentlist' => $classAllStudentlist,
                    'request_count' => $request->request_count,
                ]
            );

        } else {
            return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);
        }
    }


    private function studentMarkslist(
        $studentMarksList,
        $student_list,
        $grade_list,
        $resultSettingList,
        $academic_result_primary_type_id,
        $showTableBellowSubjectExamList,
        $OtherSubjectExamList
    ) {

        $exam_type_ids = collect($OtherSubjectExamList)->pluck('academic_exam_type_id');

        $academicExamType = AcademicExamType::whereIn('id', $exam_type_ids)->get();

        $student_array = $this->examTypePassFailStatus($studentMarksList);

        $class_test_present_list = $resultSettingList->where('examination.name_key', 'classtest');

        if (count($class_test_present_list) > 0) {
            $classtest_is_present = 1;
        } else {
            $classtest_is_present = 0;
        }

        // $exam_percentage_sum=$resultSettingList->sum('marks_percentage');
        // dd($class_test_present_list);

        $student_history_ids = collect($student_array)->pluck('student_history_id')->unique()->filter()->values();

        $site_subject_examination_marks_ids = collect($student_array)->pluck('site_subject_group_condition_setting_id')->unique()->filter();

        $site_subject_examination_marks_list = GlobalSiteSubjectExaminationMark::whereIn('site_subject_group_condition_setting_id', $site_subject_examination_marks_ids)
            ->where('status', true)
            ->get(['id', 'site_subject_group_condition_setting_id', 'examination_id', 'marks', 'pass_marks']);


        $siteIndividualCombineSubjectStudentList = GlobalSiteIndividualCombineSubjectResultStore::where('academic_result_primary_type_id', $academic_result_primary_type_id)
            ->whereIn('student_history_id', $student_history_ids)
            ->where('status', true)
            ->orderBy('subject_position')
            ->get();


        $student_list_arr = array();
        $student_list_array = [];
        $studentr_count = 0;
        foreach ($student_history_ids as $key => $value) {


            $student_present_check = $student_list->where('id', $value)->first();
            //   $student_present_check=GlobalStudentHistory::findOrFail($value);

            $student_exam_number_list = collect($student_array)->where('student_history_id', $value);
            $site_subject_group_condition_setting_ids = collect($student_array)->where('student_history_id', $value)
                ->pluck('site_subject_group_condition_setting_id')
                ->unique()
                ->values();


            $examination_ids = $student_exam_number_list
                ->pluck('examination_id')
                ->unique()
                ->filter();

            $individual_subject_entry = [];
            $subject_arr = array();
            $subject_array = [];
            $keye_count = 0;

            foreach ($site_subject_group_condition_setting_ids as $keye => $valuee) {


                $examination_List = $student_exam_number_list
                    ->where('site_subject_group_condition_setting_id', $valuee);

                $student_exam_subject_attendance = $examination_List
                    ->where('exam_attendance_status', true)
                    ->first();

                if ($student_exam_subject_attendance) {
                    $student_exam_subject_attendance_status = true;
                } else {
                    $student_exam_subject_attendance_status = false;
                }

                $subject_base_pass_fail_list = $site_subject_examination_marks_list
                    ->where('site_subject_group_condition_setting_id', $valuee);
                //$selected_subject_list=$subject_condition_setting->where('id', $valuee)->first();
                $selected_subject_list = GlobalSubjectGroupConditionSetting::where('id', $valuee)->first();
                //  dd($subject_base_pass_fail_list);
                $exam_type_arr = array();
                $exam_type_array = [];

                foreach ($examination_ids as $keys => $values) {

                    if ($selected_subject_list->result_show_in_table_bellow == 0) {


                        $used_academic_exam_type_ids = collect($OtherSubjectExamList)
                            ->pluck('academic_exam_type_id')
                            ->unique()
                            ->filter();

                        $used_academic_exam_type_list = $academicExamType->whereIn('id', $used_academic_exam_type_ids);

                        $all_exam_type_arr = array();
                        $all_exam_type_array = [];


                        foreach ($used_academic_exam_type_list as $keystt => $valuestt) {

                            $check_exam_type = $examination_List
                                ->where('examination_id', $values)
                                ->where('academic_exam_type_id', $valuestt->id)
                                ->first();

                            //    dd($used_academic_exam_type_list);

                            if ($check_exam_type) {
                                $all_exam_type_arr['academic_exam_type_id'] = $valuestt->id;
                                $all_exam_type_arr['academic_exam_type_name'] = $valuestt->marks_type;
                                $all_exam_type_arr['examination_id'] = $values;
                                $all_exam_type_arr['id'] = $check_exam_type['id'];
                                //==== this condition add for exam type countable mark
                                //    dd($check_exam_type['exam_type_countable_marks_status']);
                                if ($check_exam_type['exam_type_countable_marks_status']) {
                                    $countable_obtain_marks = ($check_exam_type['exam_type_countable_persent_of_obtain_marks'] / 100) * $check_exam_type['obtaine_marks'];
                                    $countable_pass_mark = ($check_exam_type['exam_type_countable_persent_of_obtain_marks'] / 100) * $check_exam_type['pass_mark'];

                                    $all_exam_type_arr['obtaine_marks'] = ceil($countable_obtain_marks);
                                    $all_exam_type_arr['pass_mark'] = ceil($countable_pass_mark);
                                } else {
                                    $all_exam_type_arr['obtaine_marks'] = ceil($check_exam_type['obtaine_marks']);
                                    $all_exam_type_arr['pass_mark'] = $check_exam_type['pass_mark'];
                                }



                                //====

                                $all_exam_type_arr['primary_pass_fail_status'] = $check_exam_type['primary_pass_fail_status'];

                                $all_exam_type_arr['site_subject_group_condition_setting_id'] = $check_exam_type['site_subject_group_condition_setting_id'];
                                $all_exam_type_arr['student_history_id'] = $check_exam_type['student_history_id'];
                                $all_exam_type_arr['subject_exam_type_mark'] = $check_exam_type['subject_exam_type_mark'];


                                $all_exam_type_arr['exam_type_countable_marks'] = $check_exam_type['exam_type_countable_marks'];


                                $all_exam_type_arr['exam_held_status'] = $check_exam_type['exam_held_status'];
                                $all_exam_type_arr['exam_attendance_status'] = $check_exam_type['exam_attendance_status'];
                                $all_exam_type_arr['exam_exist_status'] = true;
                            } else {
                                $all_exam_type_arr['academic_exam_type_id'] = $valuestt->id;
                                $all_exam_type_arr['academic_exam_type_name'] = $valuestt->marks_type;


                                $all_exam_type_arr['examination_id'] = $values;
                                $all_exam_type_arr['id'] = 0;
                                $all_exam_type_arr['obtaine_marks'] = 0;
                                $all_exam_type_arr['pass_mark'] = 0;
                                $all_exam_type_arr['primary_pass_fail_status'] = 1;
                                $all_exam_type_arr['site_subject_group_condition_setting_id'] = 0;
                                $all_exam_type_arr['student_history_id'] = 0;
                                $all_exam_type_arr['subject_exam_type_mark'] = 0;
                                $all_exam_type_arr['exam_held_status'] = false;
                                $all_exam_type_arr['exam_attendance_status'] = false;
                                $all_exam_type_arr['exam_exist_status'] = false;
                            }

                            $all_exam_type_array[$keystt] = array_merge($all_exam_type_arr);
                        }
                    } else {

                        $used_academic_exam_type_ids = $showTableBellowSubjectExamList->where('examination_id', $values)
                            ->pluck('academic_exam_type_id')->unique()->filter();

                        $used_academic_exam_type_list = $academicExamType->whereIn('id', $used_academic_exam_type_ids);



                        $all_exam_type_arr = array();
                        $all_exam_type_array = [];
                        foreach ($used_academic_exam_type_list as $keystt => $valuestt) {

                            $check_exam_type = $examination_List
                                ->where('examination_id', $values)
                                ->where('academic_exam_type_id', $valuestt->id)->first();


                            if ($check_exam_type) {
                                $all_exam_type_arr['academic_exam_type_id'] = $valuestt->id;
                                $all_exam_type_arr['academic_exam_type_name'] = $valuestt->marks_type;
                                $all_exam_type_arr['examination_id'] = $values;
                                $all_exam_type_arr['id'] = $check_exam_type['id'];

                                //==== this condition add for exam type countable mark

                                if ($check_exam_type['exam_type_countable_marks_status']) {
                                    $countable_obtain_marks = ($check_exam_type['exam_type_countable_persent_of_obtain_marks'] / 100) * $check_exam_type['obtaine_marks'];
                                    $countable_pass_mark = ($check_exam_type['exam_type_countable_persent_of_obtain_marks'] / 100) * $check_exam_type['pass_mark'];

                                    $all_exam_type_arr['obtaine_marks'] = ceil($countable_obtain_marks);
                                    $all_exam_type_arr['pass_mark'] = ceil($countable_pass_mark);
                                } else {
                                    $all_exam_type_arr['obtaine_marks'] = ceil($check_exam_type['obtaine_marks']);
                                    $all_exam_type_arr['pass_mark'] = $check_exam_type['pass_mark'];
                                }
                                //====

                                $all_exam_type_arr['primary_pass_fail_status'] = $check_exam_type['primary_pass_fail_status'];

                                $all_exam_type_arr['site_subject_group_condition_setting_id'] = $check_exam_type['site_subject_group_condition_setting_id'];
                                $all_exam_type_arr['student_history_id'] = $check_exam_type['student_history_id'];
                                $all_exam_type_arr['subject_exam_type_mark'] = $check_exam_type['subject_exam_type_mark'];
                                $all_exam_type_arr['exam_exist_status'] = true;
                                $all_exam_type_arr['exam_held_status'] = true;
                                $all_exam_type_arr['exam_attendance_status'] = true;
                            } else {
                                $all_exam_type_arr['academic_exam_type_id'] = $valuestt->id;
                                $all_exam_type_arr['academic_exam_type_name'] = $valuestt->marks_type;

                                $all_exam_type_arr['examination_id'] = $values;
                                $all_exam_type_arr['id'] = 0;
                                $all_exam_type_arr['obtaine_marks'] = 0;
                                $all_exam_type_arr['pass_mark'] = 0;
                                $all_exam_type_arr['primary_pass_fail_status'] = 1;
                                $all_exam_type_arr['site_subject_group_condition_setting_id'] = 0;
                                $all_exam_type_arr['student_history_id'] = 0;
                                $all_exam_type_arr['subject_exam_type_mark'] = 0;
                                $all_exam_type_arr['exam_exist_status'] = false;
                                $all_exam_type_arr['exam_held_status'] = false;
                                $all_exam_type_arr['exam_attendance_status'] = false;
                            }

                            $all_exam_type_array[$keystt] = array_merge($all_exam_type_arr);
                        }
                    }

                    $exam_setting_list = $resultSettingList->where('examination_id', $values)->first();

                    $examination_base_pass_fail = $subject_base_pass_fail_list->where('examination_id', $values)->first();

                    $exam_type_all_ids = $examination_List
                        ->where('examination_id', $values)
                        ->pluck('academic_exam_type_id')
                        ->unique()
                        ->filter();

                    //==== this condition add for exam type countable mark

                    $exam_list = $examination_List->where('examination_id', $values);
                    $exam_type_sum = 0;
                    foreach ($exam_list as $exam) {
                        if ($exam['exam_type_countable_marks_status']) {
                            if (!is_null($exam['countable_obtaine_marks'])) {
                                $exam_type_sum += $exam['countable_obtaine_marks'];
                            } else {
                                $exam_type_sum += $exam['obtaine_marks'];
                            }
                        } else {
                            $exam_type_sum += $exam['obtaine_marks'];
                        }
                    }

                    //======


                    $find_term_exam_unheld_list = $examination_List
                        ->where('examination.name_key', 'termexam')
                        ->first();

                    $find_class_test_unheld_list = $examination_List
                        ->where('examination.name_key', 'classtest')
                        ->where('exam_held_status', true)
                        ->pluck('examination_id')
                        ->unique();


                    $find_class_test_unheld_percentage = $resultSettingList
                        ->where('examination.name_key', 'classtest')
                        ->whereNotIn('examination_id', $find_class_test_unheld_list)
                        ->sum('marks_percentage');



                    if (
                        $find_class_test_unheld_percentage > 0 &&
                        $find_term_exam_unheld_list['examination_id'] == $exam_setting_list->examination_id
                    ) {

                        $class_test_percentage_with_term_exam = $exam_setting_list->marks_percentage +
                            $find_class_test_unheld_percentage;
                    } else {
                        $class_test_percentage_with_term_exam = $exam_setting_list->marks_percentage;
                    }
                    //  dd($class_test_percentage_with_term_exam);
                    if ($exam_setting_list->marks_percentage && $examination_base_pass_fail) {

                        // if($examination_base_pass_fail){

                        if ($exam_setting_list->marks_percentage > $examination_base_pass_fail->marks) {

                            $marksPercent = $class_test_percentage_with_term_exam *
                                ($examination_base_pass_fail->marks ? $examination_base_pass_fail->marks : 1) / 100;


                            $countable_dependent_obtain_exam_type_marks_for_show = $exam_type_sum *
                                $marksPercent /
                                ($examination_base_pass_fail->marks ? $examination_base_pass_fail->marks : 1);
                            // dd($marksPercent);
                        } else {
                            $countable_dependent_obtain_exam_type_marks_for_show = $exam_type_sum *
                                $class_test_percentage_with_term_exam /
                                ($examination_base_pass_fail->marks ? $examination_base_pass_fail->marks : 1);
                            //  dd($countable_dependent_obtain_exam_type_marks_for_show);
                        }




                        ///////////
                        // if($exam_setting_list->marks_percentage>$examination_base_pass_fail->marks){

                        //     $marksPercent=$class_test_percentage_with_term_exam*
                        //         ($examination_base_pass_fail->marks?$examination_base_pass_fail->marks:1)/100;

                        //     $countable_dependent_obtain_exam_type_marks= $exam_type_sum *
                        //         $marksPercent/
                        //         ($examination_base_pass_fail->marks?$examination_base_pass_fail->marks:1);

                        // }else{
                        //     $countable_dependent_obtain_exam_type_marks= $exam_type_sum *
                        //         $exam_setting_list->marks_percentage/
                        //         ($examination_base_pass_fail->marks?$examination_base_pass_fail->marks:1);
                        // }

                        ////////

                        $countable_dependent_obtain_exam_type_marks = $exam_type_sum *
                            $exam_setting_list->marks_percentage /
                            ($examination_base_pass_fail->marks ? $examination_base_pass_fail->marks : 1);

                        //   }
                    } else {

                        $countable_dependent_obtain_exam_type_marks = $exam_type_sum;
                        $countable_dependent_obtain_exam_type_marks_for_show = $exam_type_sum;
                    }
                    //                    Log::info($countable_dependent_obtain_exam_type_marks);

                    $exam_type_indivisula_pass_count = $examination_List
                        ->where('examination_id', $values)
                        ->sum('primary_pass_fail_status');

                    $exam_type = collect($all_exam_type_array)
                        ->where('examination_id', $values);


                    if (count($exam_type_all_ids) == $exam_type_indivisula_pass_count) {
                        $subject_indivisual_pass_fail_status = 1;
                    } else {
                        $subject_indivisual_pass_fail_status = 0;
                    }

                    $check_exam_held = $examination_List
                        ->where('examination_id', $values)
                        ->where('exam_held', 1)
                        ->first();

                    if ($check_exam_held) {
                        $exam_held_status = $check_exam_held['exam_held'];
                    } else {
                        $exam_held_status = 0;
                    }

                    $exam_type_arr['examination_id'] = $values;
                    $exam_type_arr['id'] = $exam_setting_list->show_position;

                    $exam_type_arr['examination_marks'] = $examination_base_pass_fail ? $examination_base_pass_fail->marks : 0;
                    $exam_type_arr['examination_pass_marks'] = $examination_base_pass_fail ? $examination_base_pass_fail->pass_marks : 0;

                    $exam_type_arr['subject_indivisual_pass_fail_status'] = $subject_indivisual_pass_fail_status;
                    $exam_type_arr['exam_type_list'] = collect($exam_type)->values();
                    $exam_type_arr['obtaine_total_marks'] = ceil($exam_type_sum);
                    $exam_type_arr['exam_held_status'] = $exam_held_status;

                    $exam_type_arr['examination_name'] = $exam_setting_list->examination->examination_name;
                    $exam_type_arr['examination_name_key'] = $exam_setting_list->examination->name_key;
                    $exam_type_arr['marks_percentage'] = $exam_setting_list->marks_percentage;

                    $exam_type_arr['show_position'] = $exam_setting_list->show_position;

                    $exam_type_arr['countable_dependent_obtain_exam_type_marks'] = $countable_dependent_obtain_exam_type_marks;
                    $exam_type_arr['countable_dependent_obtain_exam_type_marks_for_show'] = ceil($countable_dependent_obtain_exam_type_marks_for_show);

                    $exam_type_array[$keye_count] = array_merge($exam_type_arr);
                    $keye_count++;
                }

                $exam_type_array_list = collect($exam_type_array);

                $term_exam_marks_percentage_sum = $exam_type_array_list->where('examination_name_key', 'termexam')
                    ->sum('marks_percentage');

                $term_exam_obtaine_total_marks_sum = $exam_type_array_list->where('examination_name_key', 'termexam')
                    ->sum('obtaine_total_marks');


                $term_exam_obtaine_total_marks_sum_for_show = $exam_type_array_list->where('examination_name_key', 'termexam')
                    ->sum('countable_dependent_obtain_exam_type_marks_for_show');

                //                $term_exam_countable_dependent_obtain_exam_type_marks_sum=$exam_type_array_list->where('examination_name_key', 'termexam')
                //                    ->sum('countable_dependent_obtain_exam_type_marks');

                $termexam_exam_held = $exam_type_array_list->where('examination_name_key', 'termexam')
                    ->where('exam_held_status', 1)
                    ->first();

                if ($termexam_exam_held) {
                    $termexam_exam_held_status = $termexam_exam_held['exam_held_status'];
                } else {
                    $termexam_exam_held_status = 0;
                }

                $term_examination_marks_sum = $exam_type_array_list->where('examination_name_key', 'termexam')
                    ->sum('examination_marks');

                $term_examination_pass_marks_sum = $exam_type_array_list->where('examination_name_key', 'termexam')
                    ->sum('examination_pass_marks');


                $term_pass_fail_primary_status = $term_exam_obtaine_total_marks_sum >= $term_examination_pass_marks_sum ? 1 : 0;

                $classtest_marks_percentage_sum = $exam_type_array_list->where('examination_name_key', 'classtest')
                    ->sum('marks_percentage');

                $classtest_obtaine_total_marks_sum = $exam_type_array_list->where('examination_name_key', 'classtest')
                    ->sum('obtaine_total_marks');

                $classtest_obtaine_total_marks_sum_for_show = $exam_type_array_list->where('examination_name_key', 'classtest')
                    ->sum('countable_dependent_obtain_exam_type_marks_for_show');



                $classtest_exam_held = $exam_type_array_list->where('examination_name_key', 'classtest')
                    ->where('exam_held_status', 1)->first();
                if ($classtest_exam_held) {
                    $classtest_exam_held_status = $classtest_exam_held['exam_held_status'];
                } else {
                    $classtest_exam_held_status = 0;
                }


                $classtest_examination_marks_sum = $exam_type_array_list->where('examination_name_key', 'classtest')
                    ->sum('examination_marks');

                $indivisual_pass_fail_check_depend_on_exam_type = $exam_type_array_list
                    ->pluck('subject_indivisual_pass_fail_status')->unique();

                // dd($exam_type_array);

                if ($term_pass_fail_primary_status) {
                    if (count($indivisual_pass_fail_check_depend_on_exam_type) == 1) {
                        $subject_base_pass_fail_status = 1;
                    } else if (count($indivisual_pass_fail_check_depend_on_exam_type) == 2) {
                        $subject_base_pass_fail_status = 0;
                    }
                } else {
                    $subject_base_pass_fail_status = 0;
                }

                if ($classtest_obtaine_total_marks_sum <= 0 && !$classtest_exam_held_status) {

                    if ($term_exam_marks_percentage_sum <= 0) {
                        $obtain_total_marks_in_term_exam = $term_exam_obtaine_total_marks_sum;
                    } else {
                        $obtain_total_marks_in_term_exam = ($term_exam_obtaine_total_marks_sum * 100) / $term_examination_marks_sum;
                    }

                    $obtain_total_marks_in_class_test = 0;

                    $subject_arr['total_marks_in_term_exam'] = $term_examination_marks_sum;
                    $subject_arr['total_marks_in_class_test'] = 0;
                    $subject_arr['obtain_raw_total_marks_in_term_exam'] = $term_exam_obtaine_total_marks_sum;
                    $subject_arr['obtain_raw_total_marks_in_class_test'] = 0;



                    $subject_arr['obtain_total_marks_in_term_exam'] = ceil($obtain_total_marks_in_term_exam);
                    $subject_arr['obtain_total_marks_in_class_test'] = $obtain_total_marks_in_class_test;
                } else {

                    if ($term_exam_marks_percentage_sum <= 0) {
                        $obtain_total_marks_in_term_exam = $term_exam_obtaine_total_marks_sum;
                        $obtain_total_marks_in_class_test = $classtest_obtaine_total_marks_sum;
                    } else {
                        $obtain_total_marks_in_term_exam = ($term_exam_obtaine_total_marks_sum * $term_exam_marks_percentage_sum) / $term_examination_marks_sum;
                        $obtain_total_marks_in_class_test = ($classtest_obtaine_total_marks_sum * $classtest_marks_percentage_sum) / $classtest_examination_marks_sum;
                    }


                    $subject_arr['total_marks_in_term_exam'] = $term_examination_marks_sum;
                    $subject_arr['total_marks_in_class_test'] = $classtest_examination_marks_sum;
                    $subject_arr['obtain_raw_total_marks_in_term_exam'] = $term_exam_obtaine_total_marks_sum;
                    $subject_arr['obtain_raw_total_marks_in_class_test'] = $classtest_obtaine_total_marks_sum;



                    $subject_arr['obtain_total_marks_in_term_exam'] = ceil($obtain_total_marks_in_term_exam);
                    $subject_arr['obtain_total_marks_in_class_test'] = $obtain_total_marks_in_class_test;
                }


                $subject_total_number = $obtain_total_marks_in_term_exam + $obtain_total_marks_in_class_test;


                $subject_arr['obtain_total_marks_in_term_exam_for_show'] = ceil($term_exam_obtaine_total_marks_sum_for_show);
                $subject_arr['obtain_total_marks_in_class_test_for_show'] = ceil($classtest_obtaine_total_marks_sum_for_show);



                $subject_arr['termexam_exam_held_status'] = $termexam_exam_held_status;
                $subject_arr['classtest_exam_held_status'] = $classtest_exam_held_status;

                $subject_arr['student_exam_subject_attendance_status'] = $student_exam_subject_attendance_status;

                //   dd($subject_base_pass_fail_status);
                $subject_arr['subject_base_pass_fail_status'] = $subject_base_pass_fail_status;
                $subject_arr['result_show_in_table_bellow'] = $selected_subject_list->result_show_in_table_bellow;



                $subject_arr['obtain_subject_total_marks'] = ceil($subject_total_number);

                $subject_arr['subject_code'] = $selected_subject_list->subject_code;

                $subject_arr['subject_name'] = $selected_subject_list->subject_name;
                $subject_arr['exam_dependent_academic_subject'] = $selected_subject_list->examDependentAcademicSubject->subject_name;
                $subject_arr['subject_exam_name_key'] = $selected_subject_list->academicSubjectClassExamCondition->name_key;
                $subject_arr['subject_exam_name'] = $selected_subject_list->academicSubjectClassExamCondition->name;
                $subject_arr['exam_dependent_academic_subject_id'] = $selected_subject_list->exam_dependent_academic_subject_id;


                $subject_arr['academic_subject_id'] = $selected_subject_list->academic_subject_id;
                $subject_arr['subject_position'] = $selected_subject_list->subject_position;

                $subject_arr['site_subject_group_condition_setting_id'] = $valuee;
                $subject_arr['examination_list'] = array_values(array_sort($exam_type_array_list, function ($value) {
                    return $value['show_position'];
                }));
                $subject_arr['countable_subject_total'] = $exam_type_array_list->sum('countable_dependent_obtain_exam_type_marks_for_show');

                //  dd(collect($student_present_check->optional_subject_ids[0]));

                if ($student_present_check) {
                    $checkOptionalSubject = collect($student_present_check->optional_subject_ids[0])
                        ->where('id', $selected_subject_list->academic_subject_id)->first();

                    if ($checkOptionalSubject) {
                        $subject_arr['optional_academic_subject_status'] = 1;
                    } else {
                        $subject_arr['optional_academic_subject_status'] = 0;
                    }

                    $subject_array[$keye] = array_merge($subject_arr);
                }
            }



            $getPreviousAllSubjectStoreCombineListIds = $siteIndividualCombineSubjectStudentList
                ->where('student_history_id', $value)
                ->pluck('id')
                ->toArray();


            $subject_group_by_array = collect($subject_array)
                ->groupBy('exam_dependent_academic_subject_id')->values();


            $dependent_single_subject_arr = array();
            $dependent_single_subject_array = [];
            $count = 0;
            $individual_combine_subject_entry = [];
            $combine_subject_present = [];
            $stable_ids = [];

            // return $subject_group_by_array;

            foreach ($subject_group_by_array as $keyo => $valueo) {

                if (count($valueo) > 1) {
                    $combine_subject_present[] = 1;
                } else {
                    $combine_subject_present[] = 0;
                }

                //  $subject_condition_setting_ids= collect($valueo)->pluck('site_subject_group_condition_setting_id');

                $examination_list_array = [];
                foreach ($valueo as $examinationValue) {
                    foreach ($examinationValue['examination_list'] as $examinationKeyt => $examinationValuet) {
                        $examination_list_array[] = $examinationValuet;
                    }
                }

                $dependent_subject_array = [];
                // dd($valueo);
                if (count($valueo) > 1) {

                    $dependent_subject_examination_ids = collect($examination_list_array)
                        ->pluck('examination_id')->unique()->filter();

                    $dependent_subject_arr = array();
                    $marks_percent_present_absent = [];
                    foreach ($dependent_subject_examination_ids as $keyExamination => $valueExamination) {

                        $exam_setting_lists = $resultSettingList->where('examination_id', $valueExamination)->first();

                        $get_only_dependent_subject_lists = collect($examination_list_array)
                            ->where('examination_id', $valueExamination);

                        $exam_type_list_array = [];
                        foreach ($get_only_dependent_subject_lists as $examValue) {
                            //  dd($examValue);
                            foreach ($examValue['exam_type_list'] as $examValuet) {
                                $exam_type_list_array[] = $examValuet;
                            }
                        }

                        $only_dependent_subject_exam_type_ids = collect($exam_type_list_array)
                            ->where('examination_id', $valueExamination)
                            ->where('exam_exist_status', true)
                            ->pluck('academic_exam_type_id')->unique()->filter();

                        $exam_type_list_array = collect($exam_type_list_array)
                            ->where('exam_exist_status', true);

                        $examtype_arr = array();
                        $examtype_array = [];

                        foreach ($only_dependent_subject_exam_type_ids as $keyExamtype => $valueExamtype) {
                            $only_dependent_exam_type_lists = $exam_type_list_array
                                ->where('academic_exam_type_id', $valueExamtype);
                            //  dd($only_dependent_exam_type_lists);

                            $only_dependent_exam_type_marks_sum = $exam_type_list_array
                                ->where('academic_exam_type_id', $valueExamtype)
                                ->sum('subject_exam_type_mark');

                            // $only_dependent_exam_type_marks_sum33=$exam_type_list_array
                            //     ->where('academic_exam_type_id', $valueExamtype)
                            //     ->sum('exam_type_countable_marks');
                            //  dd($only_dependent_exam_type_marks_sum33);
                            $only_dependent_exam_pass_mark_sum = $exam_type_list_array
                                ->where('academic_exam_type_id', $valueExamtype)
                                ->sum('pass_mark');
                            $only_dependent_exam_type_obtaine_marks_sum = $exam_type_list_array
                                ->where('academic_exam_type_id', $valueExamtype)
                                ->sum('obtaine_marks');

                            $count_dependent_exam_type_pass_fail = $exam_type_list_array
                                ->where('academic_exam_type_id', $valueExamtype)
                                ->where('primary_pass_fail_status', 1);

                            //    dd();

                            //  dd(count($only_dependent_exam_type_lists));

                            $get_academic_exam_type_name_list = collect($exam_type_list_array)->where('academic_exam_type_id', $valueExamtype)->first();

                            //  $dependent_exam_pass_fail_status=$only_dependent_exam_type_obtaine_marks_sum>=$only_dependent_exam_pass_mark_sum?1:0;
                            $dependent_exam_pass_fail_status = count($only_dependent_exam_type_lists) == count($count_dependent_exam_type_pass_fail) ? 1 : 0;


                            $examtype_arr['examination_id'] = $valueExamination;
                            $examtype_arr['academic_exam_type_id'] = $valueExamtype;
                            $examtype_arr['academic_exam_type_name'] = $get_academic_exam_type_name_list['academic_exam_type_name'];
                            $examtype_arr['pass_mark'] = $only_dependent_exam_pass_mark_sum;
                            $examtype_arr['subject_exam_type_mark'] = $only_dependent_exam_type_marks_sum;
                            $examtype_arr['obtaine_marks'] = ceil($only_dependent_exam_type_obtaine_marks_sum);
                            $examtype_arr['primary_pass_fail_status'] = $dependent_exam_pass_fail_status;

                            //extra
                            $examtype_arr['exam_held_status'] = true;

                            $examtype_array[$keyExamtype] = array_merge($examtype_arr);
                        }

                        // dd($examtype_array);
                        $dependent_exam_type_marks_sum = collect($examtype_array)->where('examination_id', $valueExamination)
                            ->sum('subject_exam_type_mark');
                        $dependent_exam_pass_mark_sum = collect($examtype_array)->where('examination_id', $valueExamination)
                            ->sum('pass_mark');
                        $dependent_exam_type_obtaine_marks_sum = collect($examtype_array)->where('examination_id', $valueExamination)
                            ->sum('obtaine_marks');
                        $dependent_exam_pass_fail_status_sum = collect($examtype_array)->where('examination_id', $valueExamination)
                            ->sum('primary_pass_fail_status');

                        //   dd($dependent_exam_pass_fail_status_sum);


                        $dependent_exam_type_obtaine_marks_sum_for_show_arr = [];
                        foreach ($valueo as $keyObtMarks => $valueObtMarks) {
                            //  dd($valueObtMarks);
                            $dependent_exam_type_obtaine_marks_sum_for_show_arr[$keyObtMarks] = collect($valueObtMarks['examination_list'])
                                ->where('examination_id', $valueExamination)
                                ->sum('countable_dependent_obtain_exam_type_marks_for_show');
                        }
                        $dependent_exam_type_obtaine_marks_sum_for_show = array_sum($dependent_exam_type_obtaine_marks_sum_for_show_arr);
                        // dd($dependent_exam_type_obtaine_marks_sum);
                        if ($exam_setting_lists->marks_percentage) {
                            $countable_dependent_obtain_exam_type_marks = $dependent_exam_type_obtaine_marks_sum *
                                ($exam_setting_lists->marks_percentage / 100);
                            ($dependent_exam_type_marks_sum ? $dependent_exam_type_marks_sum : 1);
                        } else {
                            $countable_dependent_obtain_exam_type_marks = $dependent_exam_type_obtaine_marks_sum;
                        }
                        //    dd($countable_dependent_obtain_exam_type_marks);

                        $check_combine_exam_held = collect($examination_list_array)
                            ->where('examination_id', $valueExamination)
                            ->where('exam_held', 1)
                            ->first();
                        if ($check_combine_exam_held) {
                            $exam_held_status = $check_exam_held['exam_held'];
                        } else {
                            $exam_held_status = 0;
                        }

                        $dependent_exam_setting_list = $resultSettingList->where('examination_id', $valueExamination)->first();

                        if (count($examtype_array) == $dependent_exam_pass_fail_status_sum) {
                            $status_dependent_exam_pass_fail = 1;
                        } else {
                            $status_dependent_exam_pass_fail = 0;
                        }

                        $get_dependent_single_subject_list = $get_only_dependent_subject_lists->first();

                        //Log::info([count($examtype_array), $dependent_exam_pass_fail_status_sum]);

                        $dependent_subject_arr['exam_held_status'] = $exam_held_status;

                        $dependent_subject_arr['exam_type_list'] = collect($examtype_array);
                        $dependent_subject_arr['examination_id'] = $valueExamination;
                        $dependent_subject_arr['examination_name'] = $dependent_exam_setting_list->examination->examination_name;
                        $dependent_subject_arr['examination_marks'] = $dependent_exam_type_marks_sum;
                        $dependent_subject_arr['examination_name_key'] = $get_dependent_single_subject_list['examination_name_key'];
                        $dependent_subject_arr['examination_pass_marks'] = $dependent_exam_pass_mark_sum;
                        $dependent_subject_arr['marks_percentage'] = $dependent_exam_setting_list->marks_percentage;
                        $dependent_subject_arr['show_position'] = $dependent_exam_setting_list->show_position;
                        $dependent_subject_arr['obtaine_total_marks'] = ceil($dependent_exam_type_obtaine_marks_sum);
                        $dependent_subject_arr['subject_indivisual_pass_fail_status'] = $status_dependent_exam_pass_fail;
                        $dependent_subject_arr['countable_dependent_obtain_exam_type_marks'] = ceil($countable_dependent_obtain_exam_type_marks);
                        $dependent_subject_arr['countable_dependent_obtain_exam_type_marks_for_show'] = ceil($dependent_exam_type_obtaine_marks_sum_for_show);
                        $dependent_subject_array[$keyExamination] = array_merge($dependent_subject_arr);
                    }
                } else {
                    $dependent_subject_array = $valueo[0]['examination_list'];
                }


                $result_show_in_table_bellow_sum = $valueo->sum('result_show_in_table_bellow');
                $result_show_in_table_bellows = $result_show_in_table_bellow_sum / count($valueo);
                if ($result_show_in_table_bellows > 0) {
                    $result_show_in_table_bellow_status = 1;
                } else {
                    $result_show_in_table_bellow_status = 0;
                }





              $dependentCollection = collect($dependent_subject_array);

                // যদি `$valueo` > 1 হয়, subject_code_array তৈরি করো
                if (count($valueo) > 1) {
                    $subject_code_array = $dependentCollection->pluck('subject_code')->unique()->filter();
                    $subject_code = $subject_code_array->isNotEmpty() ? $subject_code_array->implode(', ') : '';
                } else {
                    $subject_code = $valueo[0]['subject_code'] ?? '';
                }

                // Filter করে বারবার ব্যবহার করব termexam এবং classtest
                $termExam = $dependentCollection->where('examination_name_key', 'termexam');
                $classTest = $dependentCollection->where('examination_name_key', 'classtest');

                // termexam related sums
                $countable_dependent_obtain_termexam_marks_sum       = $termExam->sum('countable_dependent_obtain_exam_type_marks');
                $dependent_term_exam_marks_percentage_sum            = $termExam->sum('marks_percentage');
                $dependent_term_exam_obtaine_total_marks_sum         = $termExam->sum('obtaine_total_marks');
                $dependent_term_exam_obtaine_total_marks_sum_for_show = $termExam->sum('countable_dependent_obtain_exam_type_marks_for_show');
                $dependent_term_examination_marks_sum                = $termExam->sum('examination_marks');
                $dependent_term_examination_pass_marks_sum           = $termExam->sum('examination_pass_marks');

                // Pass/fail status based on term exam
                $dependent_term_pass_fail_primary_status = $dependent_term_exam_obtaine_total_marks_sum >= $dependent_term_examination_pass_marks_sum ? 1 : 0;

                // classtest related sums
                $countable_dependent_obtain_classtest_marks_sum      = $classTest->sum('countable_dependent_obtain_exam_type_marks');
                $dependent_classtest_marks_percentage_sum            = $classTest->where('countable_dependent_obtain_exam_type_marks', '>=', 0)->sum('marks_percentage');
                $dependent_classtest_exam_held_status                = $classTest->where('exam_held_status', 1)->isNotEmpty() ? 1 : 0;
                $dependent_classtest_obtaine_total_marks_sum         = $classTest->sum('obtaine_total_marks');
                $dependent_classtest_obtaine_total_marks_sum_for_show = $classTest->sum('obtaine_total_marks');
                $dependent_classtest_examination_marks_sum           = $classTest->sum('examination_marks');

                // Exam count
                $exam_count = $dependentCollection->pluck('examination_id')->count();

                // Individual pass/fail status sum
                $dependent_indivisual_pass_fail_check_depend_on_exam_type = $dependentCollection->sum('subject_indivisual_pass_fail_status');

                // Total marks for show
                $obtain_total_marks_for_show = $dependentCollection->sum('obtaine_total_marks');





                $dependent_single_subject_arr['obtain_total_marks_in_term_exam_for_show'] = ceil($dependent_term_exam_obtaine_total_marks_sum_for_show);
                $dependent_single_subject_arr['obtain_total_marks_in_class_test_for_show'] = ceil($dependent_classtest_obtaine_total_marks_sum_for_show);
                $dependent_single_subject_arr['obtain_total_marks_for_show'] = ceil($obtain_total_marks_for_show);

                if ($dependent_term_pass_fail_primary_status) {
                    if ($exam_count == $dependent_indivisual_pass_fail_check_depend_on_exam_type) {
                        $dependent_subject_base_pass_fail_status = 1;
                    } else {
                        $dependent_subject_base_pass_fail_status = 0;
                    }
                } else {
                    $dependent_subject_base_pass_fail_status = 0;
                }

                $rest_percentage = 100 - ($dependent_term_exam_marks_percentage_sum + $dependent_classtest_marks_percentage_sum);

                if ($dependent_classtest_obtaine_total_marks_sum <= 0 && $dependent_classtest_exam_held_status == 0) {

                    if ($dependent_term_examination_marks_sum > 0) {

                        if ($dependent_term_exam_marks_percentage_sum > 0) {
                            $dependent_obtain_total_marks_in_term_exam = ($countable_dependent_obtain_termexam_marks_sum *
                                100) / $dependent_term_exam_marks_percentage_sum;
                        } else {
                            $dependent_obtain_total_marks_in_term_exam = $countable_dependent_obtain_termexam_marks_sum;
                        }
                    } else {
                        $dependent_obtain_total_marks_in_term_exam = 0;
                    }

                    $dependent_obtain_total_marks_in_class_test = 0;

                    $total_marks_in_term_exam = $dependent_term_examination_marks_sum;
                    $total_marks_in_class_test = 0;
                    $obtain_raw_total_marks_in_term_exam = $dependent_term_exam_obtaine_total_marks_sum;
                    $obtain_raw_total_marks_in_class_test = 0;

                    $dependent_single_subject_arr['total_marks_in_term_exam'] = $dependent_term_examination_marks_sum;
                    $dependent_single_subject_arr['total_marks_in_class_test'] = 0;
                    $dependent_single_subject_arr['obtain_raw_total_marks_in_term_exam'] = ceil($dependent_term_exam_obtaine_total_marks_sum);
                    $dependent_single_subject_arr['obtain_raw_total_marks_in_class_test'] = 0;

                    $dependent_single_subject_arr['obtain_total_marks_in_term_exam'] = ceil(number_format((float)$dependent_obtain_total_marks_in_term_exam, 2, '.', ''));
                    $dependent_single_subject_arr['obtain_total_marks_in_class_test'] = ceil(number_format((float)$dependent_obtain_total_marks_in_class_test, 2, '.', ''));
                } else {

                    if ($dependent_term_examination_marks_sum > 0) {

                        if ($dependent_term_exam_marks_percentage_sum > 0) {
                            $dependent_obtain_total_marks_in_term_exam = ($countable_dependent_obtain_termexam_marks_sum *
                                ($rest_percentage + $dependent_term_exam_marks_percentage_sum)) /
                                $dependent_term_exam_marks_percentage_sum;
                        } // 71.2*
                        else {
                            $dependent_obtain_total_marks_in_term_exam = $countable_dependent_obtain_termexam_marks_sum;
                        }
                    } else {
                        $dependent_obtain_total_marks_in_term_exam = 0;
                    }

                    $dependent_obtain_total_marks_in_class_test = $countable_dependent_obtain_classtest_marks_sum;

                    $total_marks_in_term_exam = $dependent_term_examination_marks_sum;
                    $total_marks_in_class_test = $dependent_classtest_examination_marks_sum;
                    $obtain_raw_total_marks_in_term_exam = ceil($dependent_term_exam_obtaine_total_marks_sum);
                    $obtain_raw_total_marks_in_class_test = ceil($dependent_classtest_obtaine_total_marks_sum);

                    $dependent_single_subject_arr['total_marks_in_term_exam'] = $dependent_term_examination_marks_sum;
                    $dependent_single_subject_arr['total_marks_in_class_test'] = $dependent_classtest_examination_marks_sum;
                    $dependent_single_subject_arr['obtain_raw_total_marks_in_term_exam'] = ceil($dependent_term_exam_obtaine_total_marks_sum);
                    $dependent_single_subject_arr['obtain_raw_total_marks_in_class_test'] = ceil($dependent_classtest_obtaine_total_marks_sum);
                    // dd($dependent_obtain_total_marks_in_term_exam);
                    $dependent_single_subject_arr['obtain_total_marks_in_term_exam'] = ceil(number_format((float)$dependent_obtain_total_marks_in_term_exam, 2, '.', ''));
                    $dependent_single_subject_arr['obtain_total_marks_in_class_test'] = ceil(number_format((float)$dependent_obtain_total_marks_in_class_test, 2, '.', ''));
                }


                $dependent_single_subject_arr['obtain_raw_total_marks'] = $obtain_raw_total_marks_in_term_exam + $obtain_raw_total_marks_in_class_test;
                $dependent_single_subject_arr['obtain_percent_total_marks'] = ceil($obtain_total_marks_in_term_exam + $obtain_total_marks_in_class_test);
                // $dependent_single_subject_arr['obtain_percent_total_marks']=$obtain_total_marks_for_show;
                $dependent_single_subject_arr['raw_total_marks'] = $total_marks_in_term_exam + $total_marks_in_class_test;
                if ($dependent_obtain_total_marks_in_class_test > 0) {
                    // if($exam_percentage_sum>0){
                    $dependent_subject_total_number = $dependent_obtain_total_marks_in_term_exam +
                        $dependent_obtain_total_marks_in_class_test;
                    //dd($dependent_obtain_total_marks_in_class_test);

                } else {

                    $dependent_subject_total_number = $dependent_single_subject_arr['obtain_raw_total_marks'] * 100 /
                        $dependent_single_subject_arr['raw_total_marks'];
                }

                if ($dependent_subject_base_pass_fail_status == 1) {
                    $subject_grade_find = $grade_list
                        ->where('number_from', '<=', ceil($dependent_subject_total_number))
                        ->Where('number_to', '>=', ceil($dependent_subject_total_number))
                        ->first();
                } else {
                    $subject_grade_find = $grade_list
                        ->where('number_from', '<=', ceil(0))
                        ->Where('number_to', '>=', ceil(0))
                        ->first();
                }


                $find_first_data = collect($valueo)->first();

                $dependent_single_subject_arr['exam_dependent_academic_subject_id'] = $find_first_data['exam_dependent_academic_subject_id'];
                $dependent_single_subject_arr['subject_position'] = $find_first_data['subject_position'];
                $dependent_single_subject_arr['exam_dependent_academic_subject'] = $find_first_data['exam_dependent_academic_subject'];

                $dependent_single_subject_arr['subject_code'] = $subject_code;

                $optional_sub_check = collect($valueo)->pluck('optional_academic_subject_status')->unique()->filter();


                if (count($optional_sub_check) > 0) {

                    $dependent_single_subject_arr['dependent_optional_academic_subject_status'] = 1;

                    $dependent_single_subject_arr['subject_countable_point'] = $subject_grade_find ? $subject_grade_find->point > 2 ? ($subject_grade_find->point - 2) : 0 : 0;
                } else {
                    $dependent_single_subject_arr['dependent_optional_academic_subject_status'] = 0;

                    $dependent_single_subject_arr['subject_countable_point'] = $subject_grade_find ? $subject_grade_find->point : 0;
                }

                $dependent_single_subject_arr['result_show_in_table_bellow_status'] = $result_show_in_table_bellow_status;
                // $dependent_single_subject_arr['subject_base_pass_fail_status']=$dependent_subject_base_pass_fail_status;
                $dependent_single_subject_arr['subject_base_pass_fail_status'] = $subject_grade_find ? $subject_grade_find->pass_fail_status : 0;

                $dependent_single_subject_arr['obtain_subject_total_marks'] = floor($dependent_single_subject_arr['obtain_raw_total_marks']);

                $dependent_single_subject_arr['subject_marks_percentage'] = floor($dependent_subject_total_number);

                $dependent_single_subject_arr['subject_point'] = $subject_grade_find ? $subject_grade_find->point : 0;
                $dependent_single_subject_arr['subject_grade'] = $subject_grade_find ? $subject_grade_find->academicResultSystem->name : 0;
                $dependent_single_subject_arr['indivisual_student_subject_list'] = $valueo;
                $dependent_single_subject_arr['subject_count'] = count($valueo);
                $dependent_single_subject_arr['dependent_subject_list'] = array_values(array_sort(collect($dependent_subject_array), function ($value) {
                    return $value['show_position'];
                }));


                $tab_arr = array();
                $tab_array = [];
                foreach ($valueo as $keytp => $valuetp) {

                    // dd($valuetp);

                    $tab_exam_arr = array();
                    $tab_exam_array = [];


                    foreach ($valuetp['examination_list'] as $keytpt => $valuetpt) {

                        $tab_exam_arr['exam_type_list'] = $valuetpt['exam_type_list'];
                        $tab_exam_arr['examination_id'] = $valuetpt['examination_id'];
                        $tab_exam_arr['examination_name'] = $valuetpt['examination_name'];
                        $tab_exam_arr['obtaine_total_marks'] = ceil($valuetpt['obtaine_total_marks']);
                        $tab_exam_arr['examination_marks'] = $valuetpt['examination_marks'];
                        $tab_exam_arr['countable_dependent_obtain_exam_type_marks'] = $valuetpt['countable_dependent_obtain_exam_type_marks'];
                        // $tab_exam_arr['countable_dependent_obtain_exam_type_marks']=ceil($valuetpt['obtaine_total_marks']*($valuetpt['marks_percentage']/100));


                        $tab_exam_array[$keytpt] = array_merge($tab_exam_arr);
                    }
                    // ==extra add for percentage==
                    $countable_mark = collect($tab_exam_array)->sum('countable_dependent_obtain_exam_type_marks');
                    $tab_arr['countable_obtain_marks'] = ceil($countable_mark);

                    //===
                    $tab_arr['obtain_marks'] = ceil($valuetp['obtain_total_marks_in_term_exam'] + $valuetp['obtain_total_marks_in_class_test']);

                    $tab_arr['subject_name'] = $valuetp['subject_name'];
                    $tab_arr['academic_subject_id'] = $valuetp['academic_subject_id'];
                    $tab_arr['subject_base_pass_fail_status'] = $valuetp['subject_base_pass_fail_status'];
                    $tab_arr['examination_list'] = $tab_exam_array;

                    $tab_array[$keytp] = array_merge($tab_arr);
                }


                $dependent_single_subject_array[$count] = array_merge($dependent_single_subject_arr);
                $count++;

                $checkCombineSubjectIntable = $siteIndividualCombineSubjectStudentList->where('student_history_id', $value)
                    ->where('exam_dependent_academic_subject_id', $dependent_single_subject_arr['exam_dependent_academic_subject_id'])
                    ->first();

                $student_exam_combine_subject_attendance = collect($valueo)
                    ->where('student_exam_subject_attendance_status', true)
                    ->first();

                if ($student_exam_combine_subject_attendance) {
                    $student_exam_combine_subject_attendance_status = true;
                } else {
                    $student_exam_combine_subject_attendance_status = false;
                }


                if ($checkCombineSubjectIntable) {

                    $stable_ids[] = $checkCombineSubjectIntable->id;

                    $checkCombineSubjectIntable
                        ->update([
                          //  'subject_base_pass_fail_status' => $dependent_subject_base_pass_fail_status,
                            'subject_base_pass_fail_status' => $dependent_single_subject_arr['subject_base_pass_fail_status'],
                            'obtain_subject_total_marks' => ceil($dependent_single_subject_arr['obtain_subject_total_marks']),
                            'subject_marks_percentage' => $dependent_single_subject_arr['subject_marks_percentage'],
                            'subject_grade' => $dependent_single_subject_arr['subject_grade'],
                            'subject_point' => $dependent_single_subject_arr['subject_point'],
                            'exam_attendance_status' => $student_exam_combine_subject_attendance_status,
                            'subject_position' => $dependent_single_subject_arr['subject_position'],
                            'subject_count' => count($valueo),
                            'subject_detail' => json_encode($dependent_single_subject_arr),
                            'list_for_tabulation' => json_encode($tab_array),

                            'result_show_in_table_bellow_status' => $dependent_single_subject_arr['result_show_in_table_bellow_status'],
                            'updated_at' => Carbon::today(),
                            'obtain_raw_total_marks' => ceil($obtain_raw_total_marks_in_term_exam + $obtain_raw_total_marks_in_class_test),

                            'raw_total_marks' => ceil($dependent_single_subject_arr['raw_total_marks']),
                            'obtain_total_marks_for_show' => $obtain_total_marks_for_show,
                            'obtain_percent_total_marks' => ceil($obtain_total_marks_in_term_exam + $obtain_total_marks_in_class_test),
                            'site_id' =>$student_present_check->site_id,
                            'result_generated_by' => 'site_group'
                            // 'obtain_percent_total_marks'=> $tab_array[0]['countable_obtain_marks'],
                            //  'obtain_percent_total_marks'=> ceil($obtain),
                        ]);
                    //                    }

                    //                    }


                } else {
                    //  $obtain = collect($tab_exam_array)->sum('countable_dependent_obtain_exam_type_marks');

                    $individual_combine_subject_entry[] = [
                        'student_history_id' => $value,
                        'academic_result_primary_type_id' => $academic_result_primary_type_id,
                        'exam_dependent_academic_subject_id' => $dependent_single_subject_arr['exam_dependent_academic_subject_id'],
                        'optional_academic_subject_status' => $dependent_single_subject_arr['dependent_optional_academic_subject_status'],
                        // 'subject_base_pass_fail_status' => $dependent_subject_base_pass_fail_status,
                        'subject_base_pass_fail_status' => $dependent_single_subject_arr['subject_base_pass_fail_status'],

                        'raw_total_marks' => ceil($dependent_single_subject_arr['raw_total_marks']),

                        'obtain_subject_total_marks' => ceil($dependent_single_subject_arr['obtain_subject_total_marks']),
                        'subject_marks_percentage' => $dependent_single_subject_arr['subject_marks_percentage'],
                        'subject_grade' => $dependent_single_subject_arr['subject_grade'],
                        'subject_position' => $dependent_single_subject_arr['subject_position'],
                        'exam_attendance_status' => $student_exam_combine_subject_attendance_status,

                        'result_show_in_table_bellow_status' => $dependent_single_subject_arr['result_show_in_table_bellow_status'],

                        'subject_point' => $dependent_single_subject_arr['subject_point'],
                        'subject_count' => count($valueo),
                        'subject_detail' => json_encode($dependent_single_subject_arr),

                        'list_for_tabulation' => json_encode($tab_array),

                        'status' => true,
                        'created_at' => Carbon::today(),

                        'obtain_total_marks_for_show' => $obtain_total_marks_for_show,

                        'obtain_raw_total_marks' => ceil($obtain_raw_total_marks_in_term_exam + $obtain_raw_total_marks_in_class_test),
                        'obtain_percent_total_marks' => ceil($obtain_total_marks_in_term_exam + $obtain_total_marks_in_class_test),

                        // 'obtain_percent_total_marks'=> $tab_array[0]['countable_obtain_marks'],
                        //  'countable_obtain_marks'=> $tab_array[0]['countable_obtain_marks'],

                        //'obtain_percent_total_marks'=> ceil($obtain_raw_total_marks_in_term_exam+$obtain_raw_total_marks_in_class_test),
                        //'total_exam_marks'=>$dependent_single_subject_arr['total_exam_marks'],
                        //'obtain_percent_total_marks'=> ceil($obtain),
                        'site_id' =>$student_present_check->site_id,
                        'result_generated_by' => 'site_group'
                    ];
                }
            }


            if (count($getPreviousAllSubjectStoreCombineListIds) > 0) {
                if (count($stable_ids) > 0) {
                    $ids_for_delete = array_diff($getPreviousAllSubjectStoreCombineListIds, $stable_ids);
                    GlobalSiteIndividualCombineSubjectResultStore::whereIn('id', $ids_for_delete)->delete();
                }
            }

            if (count($individual_combine_subject_entry) > 0) {
                GlobalSiteIndividualCombineSubjectResultStore::insert($individual_combine_subject_entry);
            }

            $getlatestSubjectStoreCombineList = $siteIndividualCombineSubjectStudentList
                ->where('student_history_id', $value);


            $full_exam_attendance_list = $getlatestSubjectStoreCombineList->where('exam_attendance_status', true)->first();

            $checkFailSubject = $getlatestSubjectStoreCombineList->where('optional_academic_subject_status', false)
                        ->where('subject_base_pass_fail_status', false)
                        ->first();


            if ($full_exam_attendance_list) {
                $full_exam_attendance_list_status = true;
            } else {
                $full_exam_attendance_list_status = false;
            }

            if ($checkFailSubject) {
                $check_failed_subject_without_optional = false;
            } else {
                $check_failed_subject_without_optional = true;
            }

            $getlatestSubjectStoreCombineIDs = $getlatestSubjectStoreCombineList->pluck('id');

            //    dd($getlatestSubjectStoreCombineIDs);

            $subject_detail = [];
            $optional_subject_list = [];
            foreach ($getlatestSubjectStoreCombineList as $keyt => $valuet) {

                $subject_detail[] = $valuet->subject_detail;
                if ($valuet->optional_academic_subject_status == 1) {
                    $optional_subject_list[] = $valuet->exam_dependent_academic_subject_id;
                }
            }



            // $sum_of_obtain_total_marks_for_show = collect($subject_detail)
            //     ->sum('obtain_total_marks_for_show');

            // $sum_of_obtain_total_percent_for_show = collect($subject_detail)
            //     ->avg('subject_marks_percentage');

            // $sum_of_obtain_raw_total_marks = collect($subject_detail)
            //     ->sum('obtain_raw_total_marks');
            // $sum_of_obtain_percent_total_marks = collect($subject_detail)
            //     ->sum('obtain_percent_total_marks');
            // $sum_of_raw_total_marks = collect($subject_detail)
            //     ->sum('raw_total_marks');
            // //obtain_percent_total_marks

            // $sum_of_total_point_with_optional = collect($subject_detail)
            //     ->sum('subject_countable_point');
            // $sum_of_total_point_without_optional = collect($subject_detail)
            //     ->where('dependent_optional_academic_subject_status', 0)
            //     ->sum('subject_countable_point');
            // $sum_of_total_countable_subject = collect($subject_detail)
            //     ->where('dependent_optional_academic_subject_status', 0)
            //     ->count('exam_dependent_academic_subject_id');
            // $sum_of_subject_base_pass_fail_status = collect($subject_detail)
            //     ->where('dependent_optional_academic_subject_status', 0)
            //     ->sum('subject_base_pass_fail_status');


            $subjectCollection = collect($subject_detail);

         //   dd($subjectCollection);

            $sum_of_obtain_total_marks_for_show = $subjectCollection->sum('obtain_total_marks_for_show');
            $sum_of_obtain_total_percent_for_show = $subjectCollection->avg('subject_marks_percentage');
            $sum_of_obtain_raw_total_marks = $subjectCollection->sum('obtain_raw_total_marks');
            $sum_of_obtain_percent_total_marks = $subjectCollection->sum('obtain_percent_total_marks');
            $sum_of_raw_total_marks = $subjectCollection->sum('raw_total_marks');

            $sum_of_total_point_with_optional = $subjectCollection->sum('subject_countable_point');

            $filteredCollection = $subjectCollection->where('dependent_optional_academic_subject_status', 0);

            $sum_of_total_point_without_optional = $filteredCollection->sum('subject_countable_point');
            $sum_of_total_countable_subject = $filteredCollection->count('exam_dependent_academic_subject_id');

            $failed_subject_count = $filteredCollection->where('subject_base_pass_fail_status',0)->count();

          //  dd($sum_of_total_countable_subject, $failed_subject_count,$filteredCollection);

            if($checkFailSubject){
                $student_final_point_with_optional= 0;
                $student_final_point_without_optional= 0;
            }else{
                if ($sum_of_total_countable_subject <= 0) {
                    $student_final_point_with_optional = 0;
                    $student_final_point_without_optional = 0;
                }else{
                    $student_final_point_with_optional = ($sum_of_total_point_with_optional / $sum_of_total_countable_subject) > 5 ? 5 : ($sum_of_total_point_with_optional / $sum_of_total_countable_subject);

                    $student_final_point_without_optional = $sum_of_total_point_without_optional / $sum_of_total_countable_subject ?? 1;
                }
            }


            // if ($failed_subject_count==0) {
            //     if ($sum_of_total_countable_subject <= 0) {
            //         $student_final_point_with_optional = 0;
            //         $student_final_point_without_optional = 0;
            //     } else {
            //         $student_final_point_with_optional = ($sum_of_total_point_with_optional / $sum_of_total_countable_subject) > 5 ? 5 : ($sum_of_total_point_with_optional / $sum_of_total_countable_subject);

            //         $student_final_point_without_optional = $sum_of_total_point_without_optional / $sum_of_total_countable_subject ?? 1;
            //     }
            // } else {
            //     $student_final_point_with_optional = 0;
            //     $student_final_point_without_optional = 0;
            // }

            //Log::info($student_final_point_with_optional);

            $total_grade_find = collect($grade_list)
                ->where('point_from', '<=', $student_final_point_with_optional)
                ->Where('point_to', '>=', $student_final_point_with_optional)
                ->first();


            $total_grade_find_without_optional = $grade_list
                ->where('point_from', '<=', $student_final_point_without_optional)
                ->Where('point_to', '>=', $student_final_point_without_optional)
                ->first();

            $academic_primary_id_get = collect($resultSettingList)->first();

            $multiple_subject_present = collect($combine_subject_present)->unique()->filter();

            //=======================এইগুলো টেবিলে দিতে হবে।===================

            $sum_of_obtain_raw_total_marks_only_passed_subject = collect($subject_detail)
                ->where('subject_base_pass_fail_status', 1)
                ->sum('obtain_raw_total_marks');

            if ($sum_of_raw_total_marks <= 0) {
                $pass_subject_base_marks_percentage = 0;
                $total_marks_base_percentage = 0;
            } else {
                $pass_subject_base_marks_percentage = $sum_of_obtain_raw_total_marks_only_passed_subject * 100 /
                    $sum_of_raw_total_marks;

                $total_marks_base_percentage = $sum_of_obtain_raw_total_marks * 100 /
                    $sum_of_raw_total_marks;
            }

            $pass_subject_base_marks_grade = $grade_list
                ->where('number_from', '<=', ceil($pass_subject_base_marks_percentage))
                ->Where('number_to', '>=', ceil($pass_subject_base_marks_percentage))
                ->first();


            if ($total_marks_base_percentage > 100) {
                $total_marks_base_percentage = 100;
            }

            $total_marks_base_grade = $grade_list
                ->where('number_from', '<=', ceil($total_marks_base_percentage))
                ->Where('number_to', '>=', ceil($total_marks_base_percentage))
                ->first();

            //    dd($total_marks_base_grade);

            $pass_subject_base_marks_point = $pass_subject_base_marks_grade->point;

            $total_marks_base_point = $total_marks_base_grade->point;


            $student_list_arr['sum_of_obtain_raw_total_marks_only_passed_subject'] = ceil($sum_of_obtain_raw_total_marks_only_passed_subject);
            $student_list_arr['pass_subject_base_marks_percentage'] = $pass_subject_base_marks_percentage;
            $student_list_arr['total_marks_base_percentage'] = $total_marks_base_percentage;
            $student_list_arr['pass_subject_base_marks_grade'] = $pass_subject_base_marks_grade->academicResultSystem->name;
            $student_list_arr['total_marks_base_grade'] = $total_marks_base_grade->academicResultSystem->name;
            $student_list_arr['pass_subject_base_marks_point'] = $pass_subject_base_marks_point;
            $student_list_arr['total_marks_base_point'] = $total_marks_base_point;

            $student_list_arr['exam_attendance_status'] = $full_exam_attendance_list_status;

            $student_list_arr['fail_subject_count'] = $failed_subject_count;
            $student_list_arr['academic_result_primary_type_id'] = $academic_primary_id_get->academicResultPrimaryType->id;
            $student_list_arr['final_grade'] = $total_grade_find->academicResultSystem->name ?? null;

            $student_list_arr['final_point'] = number_format((float)$student_final_point_with_optional, 2, '.', '');

            $student_list_arr['student_history_id'] = $value;
            $student_list_arr['subject_list'] = $subject_detail;
            $student_list_arr['site_individual_combine_subject_result_store_ids'] = $getlatestSubjectStoreCombineIDs->toArray();


            $student_list_arr['final_grade_without_optional'] = $total_grade_find_without_optional->academicResultSystem->name ?? null;
            $student_list_arr['final_point_without_optional'] = number_format((float)$student_final_point_without_optional, 2, '.', '');
            $student_list_arr['optional_subject_ids'] = implode(',', $optional_subject_list);
            $student_list_arr['combine_subject_present'] = count($multiple_subject_present) >= 1 ? 1 : 0;
            $student_list_arr['classtest_is_present'] = $classtest_is_present;

            $student_list_arr['sum_of_obtain_total_marks_for_show'] = ceil($sum_of_obtain_total_marks_for_show);
            $student_list_arr['sum_of_obtain_total_percent_for_show'] = number_format((float)$sum_of_obtain_total_percent_for_show, 2, '.', '');

            $student_list_arr['sum_of_obtain_raw_total_marks'] = ceil($sum_of_obtain_raw_total_marks);
            $student_list_arr['sum_of_obtain_percent_total_marks'] = $sum_of_obtain_percent_total_marks;
            $student_list_arr['sum_of_raw_total_marks'] = $sum_of_raw_total_marks;
            $student_list_arr['site_id'] = $selected_subject_list->site_id;

        //    dd($student_list_arr);

            $student_list_array[$studentr_count] = array_merge($student_list_arr);
            $studentr_count++;

            //   }
        }

        return $student_list_array;
    }


    private function examTypePassFailStatus($studentMarksList)
    {

        $student_arr = array();
        $student_array = [];
        foreach ($studentMarksList as $key => $value) {

            if ($value['exam_held_status']) {

                if ($value['exam_attendance_status']) {

                    if ($value['obtaine_marks'] >= $value['pass_mark']) {

                        $student_arr['primary_pass_fail_status'] = 1;
                        $student_arr['exam_held'] = 1;
                    } else {
                        $student_arr['primary_pass_fail_status'] = 0;
                        $student_arr['exam_held'] = 1;
                    }
                } else {
                    $student_arr['primary_pass_fail_status'] = 0;
                    $student_arr['exam_held'] = 1;
                    $student_arr['is_countable_mark'] = 1;
                }
            } else {
                $student_arr['primary_pass_fail_status'] = 1;
                $student_arr['exam_held'] = 0;
            }

            $student_array[$key] = array_merge($student_arr, is_array($value) ? $value : $value->toArray());
        }

        return $student_array;
    }
}
