<?php

namespace App\Http\Controllers\SiteGroup\ExamResult;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Site\Result\GlobalSiteStudentPrimaryResultDetail;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\SiteGroup\ExamResult\SiteGroupResultPermission;
use App\Models\SiteGroup\ExamResult\SiteGroupResultPrimarySettingStore;
use Illuminate\Auth\Access\Response as AccessResponse;
use Response;
use Session;

class SiteGroupExamResultPermissionController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
      
    }

    public function index(){
        $viewType = "Site Group Exam Answer Paper";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getStieGroupBaseResultTypeListForPermission(Request $request){

        $data=$request->all();
        
        $student_histories_ids = GlobalStudentHistory::select('id', 'user_id','student_roll_number','site_batch_detail_id')
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->pluck('id')
                ->unique()
                ->values();

        
        $academic_result_primary_type_ids=GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id',$student_histories_ids)
                    ->where('status', true)
                    ->where('status', true)
                    ->pluck('academic_result_primary_type_id')
                    ->unique()
                    ->values();

        $resultlist_test=AcademicResultPrimaryType::whereIn('id', $academic_result_primary_type_ids)->where('use_key','site_group')->get();

        return $resultlist_test;


    }


    public function getStieGroupSiteExamResultPermissionList(Request $request){

        $data=$request->all();

        $permissions=SiteGroupResultPermission::where('academic_year_id', $data['academic_year_id'])
                    ->where('academic_class_id', $data['academic_class_id'])
                    ->get();

        $student_histories_ids = GlobalStudentHistory::select('id', 'user_id','student_roll_number','site_batch_detail_id')
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->pluck('id')
                ->unique()
                ->values();

        $site_ids=GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id',$student_histories_ids)
                ->where('academic_result_primary_type_id',$request->academic_result_primary_type_id)
                ->where('status', true)
                ->pluck('site_id')
                ->unique()
                ->values();

        $site_list=GlobalSiteInfo::whereIn('id',$site_ids)->get();

        $site_array=[];
        if(count($site_list)){
            $key=0;
            foreach($site_list as $site){

                $checkPermission=$permissions->where('site_id',$site->id)->first();

                if($checkPermission){
                    $site_array[$key]['id']=$checkPermission->id;
                    $site_array[$key]['site_result_permission_status']=$checkPermission->site_result_permission_status;
                    $site_array[$key]['employee_result_permission_status']=$checkPermission->employee_result_permission_status;
                    $site_array[$key]['student_result_permission_status']=$checkPermission->student_result_permission_status;
                    $site_array[$key]['public_result_permission_status']=$checkPermission->public_result_permission_status;
                }else{
                    $site_array[$key]['id']='';
                    $site_array[$key]['site_result_permission_status']=false;
                    $site_array[$key]['employee_result_permission_status']=false;
                    $site_array[$key]['student_result_permission_status']=false;
                    $site_array[$key]['public_result_permission_status']=true;
                }

                $site_array[$key]['site_id']=$site->id;
                $site_array[$key]['site_name']=$site->site_name;
                $site_array[$key]['site_alias']=$site->site_alias;

                $key++;

            }
        }

        return $site_array;
    }


    public function updateStieGroupSiteExamResultPermission(Request $request){

        $data=$request->all();

        foreach($request->SitePermissionList as $item){

            if($item['id']){
                $permissions=SiteGroupResultPermission::where('id', $item['id'])->first();
                $permissions->site_result_permission_status=$item['site_result_permission_status'];
                $permissions->employee_result_permission_status=$item['employee_result_permission_status'];
                $permissions->student_result_permission_status=$item['student_result_permission_status'];
                $permissions->public_result_permission_status=$item['public_result_permission_status'];
                $permissions->save();
            }else{
                $newpermissions=new SiteGroupResultPermission;

                $newpermissions->academic_year_id=$data['academic_year_id'];
                $newpermissions->academic_class_id=$data['academic_class_id'];
                $newpermissions->academic_result_primary_type_id=$data['academic_result_primary_type_id'];

                $newpermissions->site_id=$item['site_id'];
                $newpermissions->site_result_permission_status=$item['site_result_permission_status'];
                $newpermissions->employee_result_permission_status=$item['employee_result_permission_status'];
                $newpermissions->student_result_permission_status=$item['student_result_permission_status'];
                $newpermissions->public_result_permission_status=$item['public_result_permission_status'];
                $newpermissions->save();
            }
        }

       return Response::json(['message'=>'Permission Update Successfully','status'=>'200'],200);
       
    }


}
