<?php

namespace App\Http\Controllers\SiteGroup\Fee;

use App\Models\Academic\AcademicFeeGroup;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Site\Fee\GlobalSiteStudentFeeFineAllocation;
use App\Models\Site\Fee\GlobalSiteStudentFeeGenerate;
use App\Models\Site\SiteGroupSetting;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\SiteGroup\Fee\SiteGroupFeeSubHeadAllocation;
use App\Models\SiteGroup\Fee\SiteGroupStudentFeeFineAllocation;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;
use Response;
use Session;

class SiteGroupFeeAllocationController extends Controller
{


    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
    }



    public function getSiteGroupGlobalFeeHeadAllocation(Request $request){



        $FeeGroupsID=AcademicFeeGroup::whereIn('head_key', ['global'])
            ->where('status', true)
            ->pluck('id');


        $selectedSiteGroupList=SiteGroupSetting::where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->where('status', true)
            ->first();
        $selectedFeeHeadList= AcademicFeeHead::whereIn('id', explode(',', $selectedSiteGroupList->academic_fee_head_ids))->get();



        $siteGroupsFeeHead=SiteGroupFeeSubHeadAllocation::with(['academicFeeHead', 'academicFeeGroup','academicFeeSubHead' ])
            ->whereIn('academic_fee_group_id', $FeeGroupsID)
            ->where('status', true)
            ->where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->get();



        $headArray=[];
        foreach ($selectedFeeHeadList as $key => $value) {

            $feeheadArr=Array();
            foreach ($siteGroupsFeeHead as $keys => $values) {

                if($values->academic_fee_head_id==$value->id){
                    $feeheadArr['id']=$values->academic_fee_head_id;
                    $feeheadArr['name']=$values->academicFeeHead->name;

                    $headArray[$key]=$feeheadArr;
                }
            }
        }


        $academicFeeGroup=AcademicFeeGroup::get();

        $feeheadidsArray=[];
        $feeheadidsArr=Array();
        foreach ($headArray as $key => $value) {
            $feegroupids=$siteGroupsFeeHead->where('academic_fee_head_id', $value['id'])->pluck('academic_fee_group_id');
            $academicFeeGroupList=$academicFeeGroup->whereIn('id', $feegroupids);
            $feeheadidsArr['academic_fee_group_list']=$academicFeeGroupList;
            $feeheadidsArray[$key]=array_merge($feeheadidsArr, $value);
        }




        if($request->checked_site_id){
            $siteGroupFeeAllocationPresent=GlobalSiteStudentFeeFineAllocation::where('site_group_id',Session::get('SITE_GROUP_ID'))
                ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                ->where('site_id',$request->checked_site_id)
                ->whereIn('academic_fee_group_id',$FeeGroupsID)
                ->where('academic_version_id',$request->academic_version_id)
                ->where('academic_shift_id',$request->academic_shift_id)
                ->where('academic_year_id',$request->academic_year_id)
                ->where('status', true)
                ->whereNull('academic_class_id')
                ->whereNull('academic_department_id')
                ->get();




            $cFeeHeadArr=Array();
            $cFeeHeadArray=[];
            foreach ($feeheadidsArray as $key => $value) {

                $bArr=Array();
                $bArray=[];
                foreach ($value['academic_fee_group_list'] as $keys => $values) {

                    $feeGroupPresent=$siteGroupFeeAllocationPresent
                        ->where('academic_fee_head_id', $value['id'])
                        ->where('academic_fee_group_id', $values['id'])
                        ->first();
                    if($feeGroupPresent){
                        $bArr['select_fee_group_id']=true;
                    }else{
                        $bArr['select_fee_group_id']=false;
                    }




                    $checkfeegroupid=$siteGroupsFeeHead
                        ->where('academic_fee_head_id', $value['id'])
                        ->where('academic_fee_group_id', $values['id']);

                    $aArr=Array();
                    $aArray=[];
                    foreach ($checkfeegroupid as $ke => $val) {
                        $aArr['id']=$val->academic_fee_sub_head_id;
                        $aArr['name']=$val->academicFeeSubHead->name;

                        $feeSubHeadPresent=$siteGroupFeeAllocationPresent
                            ->where('academic_fee_head_id', $value['id'])
                            ->where('academic_fee_group_id', $values['id'])
                            ->where('academic_fee_sub_head_id', $val->academic_fee_sub_head_id)
                            ->first();
                        if($feeSubHeadPresent){
                            $aArr['select_fee_sub_head_id']=true;
                            $aArr['amount']=$feeSubHeadPresent->amount;
                            $aArr['fine_amount']=$feeSubHeadPresent->fine_amount;
                            $aArr['fine_applicable_day']=$feeSubHeadPresent->fine_applicable_day;
                        }else{
                            $aArr['select_fee_sub_head_id']=false;
                            $aArr['amount']=null;
                            $aArr['fine_amount']=null;
                            $aArr['fine_applicable_day']=null;
                        }

                        $aArray[$ke]=array_merge($aArr);
                    }
                    $bArr['academic_fee_sub_head']=$aArray;



                    $bArray[$keys]=array_merge($bArr, $values->toArray());

                }
                $cFeeHeadArr['academic_fee_group']=$bArray;

                $feeheadPresent=$siteGroupFeeAllocationPresent->where('academic_fee_head_id', $value['id'])->first();
                if($feeheadPresent){
                    $cFeeHeadArr['select_fee_head_id']=true;
                }else{
                    $cFeeHeadArr['select_fee_head_id']=false;
                }


                $cFeeHeadArray[$key]=array_merge($cFeeHeadArr, $value);

            }




        }
        else{




            $cFeeHeadArr=Array();
            $cFeeHeadArray=[];
            foreach ($feeheadidsArray as $key => $value) {

                $bArr=Array();
                $bArray=[];
                foreach ($value['academic_fee_group_list'] as $keys => $values) {
                    $bArr['select_fee_group_id']=false;

                    $checkfeegroupid=$siteGroupsFeeHead
                        ->where('academic_fee_head_id', $value['id'])
                        ->where('academic_fee_group_id', $values['id']);

                    $aArr=Array();
                    $aArray=[];
                    foreach ($checkfeegroupid as $ke => $val) {
                        $aArr['id']=$val->academic_fee_sub_head_id;
                        $aArr['name']=$val->academicFeeSubHead->name;

                        $aArr['select_fee_sub_head_id']=false;
                        $aArr['amount']=null;
                        $aArr['fine_amount']=null;
                        $aArr['fine_applicable_day']=null;

                        $aArray[$ke]=array_merge($aArr);
                    }
                    $bArr['academic_fee_sub_head']=$aArray;



                    $bArray[$keys]=array_merge($bArr, $values->toArray());

                }
                $cFeeHeadArr['academic_fee_group']=$bArray;
                $cFeeHeadArr['select_fee_head_id']=false;

                $cFeeHeadArray[$key]=array_merge($cFeeHeadArr, $value);

            }



        }



        $siteid=SiteInfo::where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->where('status', true)
            ->pluck('id');
        $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->where('status', true)
            ->pluck('site_id');

        $siteList=GlobalSiteInfo::select('id')
            ->whereIn('id',$siteIDs)
            ->where('status', true)
            ->get();



        return response()->json([$cFeeHeadArray, $siteList], 200, []);

    }










    public function getSiteGroupClassbaseStudentbaseFeeHeadAllocation(Request $request){


        $FeeGroupsID=AcademicFeeGroup::whereIn('head_key', ['classbase','studentbase'])
            ->where('status', true)
            ->pluck('id');


        $selectedSiteGroupList=SiteGroupSetting::where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->where('status', true)
            ->first();
        $selectedFeeHeadList= AcademicFeeHead::whereIn('id', explode(',', $selectedSiteGroupList->academic_fee_head_ids))->get();



        $siteGroupsFeeHead=SiteGroupFeeSubHeadAllocation::with(['academicFeeHead', 'academicFeeGroup','academicFeeSubHead' ])
            ->whereIn('academic_fee_group_id', $FeeGroupsID)
            ->where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->where('status', true)
            ->get();



        $headArray=[];
        foreach ($selectedFeeHeadList as $key => $value) {

            $feeheadArr=Array();
            foreach ($siteGroupsFeeHead as $keys => $values) {

                if($values->academic_fee_head_id==$value->id){
                    $feeheadArr['id']=$values->academic_fee_head_id;
                    $feeheadArr['name']=$values->academicFeeHead->name;

                    $headArray[$key]=$feeheadArr;
                }
            }
        }


        $academicFeeGroup=AcademicFeeGroup::get();

        $feeheadidsArray=[];
        $feeheadidsArr=Array();
        foreach ($headArray as $key => $value) {
            $feegroupids=$siteGroupsFeeHead->where('academic_fee_head_id', $value['id'])->pluck('academic_fee_group_id');
            $academicFeeGroupList=$academicFeeGroup->whereIn('id', $feegroupids);
            $feeheadidsArr['academic_fee_group_list']=$academicFeeGroupList;
            $feeheadidsArray[$key]=array_merge($feeheadidsArr, $value);
        }


        $data = $request->all();

        if($request->checked_site_id){
            $siteGroupFeeAllocationPresent=GlobalSiteStudentFeeFineAllocation::where('site_group_id',Session::get('SITE_GROUP_ID'))
                ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                ->where('status', true)
                ->where('site_id',$request->checked_site_id)
                ->whereIn('academic_fee_group_id',$FeeGroupsID)
                ->where('academic_version_id',$request->academic_version_id)
                ->where('academic_shift_id',$request->academic_shift_id)
                ->where('academic_year_id',$request->academic_year_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })

                ->when(empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->whereNull('academic_department_id');
                })
                ->when(empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->whereNull('academic_class_id');
                })
                ->when(empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->whereNull('academic_class_group_id');
                })
                ->when(empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->whereNull('academic_session_id');
                })
                ->when(empty($data['academic_student_category_id']), function ($query) use ($data) {
                    return $query->whereNull('academic_student_category_id');
                })
                ->when(empty($data['academic_student_type_id']), function ($query) use ($data) {
                    return $query->whereNull('academic_student_type_id');
                })
                ->when(empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                    return $query->whereNull('academic_student_admission_type_id');
                })
                ->get();




            $cFeeHeadArr=Array();
            $cFeeHeadArray=[];
            foreach ($feeheadidsArray as $key => $value) {

                $bArr=Array();
                $bArray=[];
                foreach ($value['academic_fee_group_list'] as $keys => $values) {

                    $feeGroupPresent=$siteGroupFeeAllocationPresent
                        ->where('academic_fee_head_id', $value['id'])
                        ->where('academic_fee_group_id', $values['id'])
                        ->first();
                    if($feeGroupPresent){
                        $bArr['select_fee_group_id']=true;
                    }else{
                        $bArr['select_fee_group_id']=false;
                    }




                    $checkfeegroupid=$siteGroupsFeeHead
                        ->where('academic_fee_head_id', $value['id'])
                        ->where('academic_fee_group_id', $values['id']);

                    $aArr=Array();
                    $aArray=[];
                    foreach ($checkfeegroupid as $ke => $val) {
                        $aArr['id']=$val->academic_fee_sub_head_id;
                        $aArr['name']=$val->academicFeeSubHead->name;

                        $feeSubHeadPresent=$siteGroupFeeAllocationPresent
                            ->where('academic_fee_head_id', $value['id'])
                            ->where('academic_fee_group_id', $values['id'])
                            ->where('academic_fee_sub_head_id', $val->academic_fee_sub_head_id)
                            ->first();
                        if($feeSubHeadPresent){
                            $aArr['select_fee_sub_head_id']=true;
                            $aArr['amount']=$feeSubHeadPresent->amount;
                            $aArr['fine_amount']=$feeSubHeadPresent->fine_amount;
                            $aArr['fine_applicable_day']=$feeSubHeadPresent->fine_applicable_day;
                        }else{
                            $aArr['select_fee_sub_head_id']=false;
                            $aArr['amount']=null;
                            $aArr['fine_amount']=null;
                            $aArr['fine_applicable_day']=null;
                        }

                        $aArray[$ke]=array_merge($aArr);
                    }
                    $bArr['academic_fee_sub_head']=$aArray;



                    $bArray[$keys]=array_merge($bArr, $values->toArray());

                }
                $cFeeHeadArr['academic_fee_group']=$bArray;

                $feeheadPresent=$siteGroupFeeAllocationPresent->where('academic_fee_head_id', $value['id'])->first();
                if($feeheadPresent){
                    $cFeeHeadArr['select_fee_head_id']=true;
                }else{
                    $cFeeHeadArr['select_fee_head_id']=false;
                }


                $cFeeHeadArray[$key]=array_merge($cFeeHeadArr, $value);

            }




        }
        else{




            $cFeeHeadArr=Array();
            $cFeeHeadArray=[];
            foreach ($feeheadidsArray as $key => $value) {

                $bArr=Array();
                $bArray=[];
                foreach ($value['academic_fee_group_list'] as $keys => $values) {
                    $bArr['select_fee_group_id']=false;

                    $checkfeegroupid=$siteGroupsFeeHead
                        ->where('academic_fee_head_id', $value['id'])
                        ->where('academic_fee_group_id', $values['id']);

                    $aArr=Array();
                    $aArray=[];
                    foreach ($checkfeegroupid as $ke => $val) {
                        $aArr['id']=$val->academic_fee_sub_head_id;
                        $aArr['name']=$val->academicFeeSubHead->name;

                        $aArr['select_fee_sub_head_id']=false;
                        $aArr['amount']=null;
                        $aArr['fine_amount']=null;
                        $aArr['fine_applicable_day']=null;

                        $aArray[$ke]=array_merge($aArr);
                    }
                    $bArr['academic_fee_sub_head']=$aArray;



                    $bArray[$keys]=array_merge($bArr, $values->toArray());

                }
                $cFeeHeadArr['academic_fee_group']=$bArray;
                $cFeeHeadArr['select_fee_head_id']=false;

                $cFeeHeadArray[$key]=array_merge($cFeeHeadArr, $value);

            }



        }



        $siteid=SiteInfo::where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->where('status', true)
            ->pluck('id');
        $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->where('status', true)
            ->pluck('site_id');

        $siteList=GlobalSiteInfo::select('id')
            ->where('status', true)
            ->whereIn('id',$siteIDs)
            ->get();




        return response()->json([$cFeeHeadArray, $siteList], 200, []);


    }








    public function createUpdateSiteGroupFeeAllocation(Request $request){

        $siteid=SiteInfo::where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->where('status', true)
            ->pluck('id');
        $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->where('status', true)
            ->pluck('site_id');

        $siteFeeList=GlobalSiteStudentFeeFineAllocation::whereIn('site_id',$siteIDs)
            ->where('status', true)
            ->get();



        $data = $request->all();



        $siteFeeSetPresentList=GlobalSiteStudentFeeFineAllocation::where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->whereIn('site_id', $request->select_site_info_id)
            ->where('status', true)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                return $query->where('academic_student_category_id', $data['academic_student_category_id']);
            })
            ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_type_id', $data['academic_student_type_id']);
            })
            ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
            })

            ->when(empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->whereNull('academic_department_id');
            })
            ->when(empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->whereNull('academic_class_id');
            })
            ->when(empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->whereNull('academic_class_group_id');
            })
            ->when(empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->whereNull('academic_session_id');
            })
            ->when(empty($data['academic_student_category_id']), function ($query) use ($data) {
                return $query->whereNull('academic_student_category_id');
            })
            ->when(empty($data['academic_student_type_id']), function ($query) use ($data) {
                return $query->whereNull('academic_student_type_id');
            })
            ->when(empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                return $query->whereNull('academic_student_admission_type_id');
            })
            ->get();


        $site_info_id_array=array_filter($request->select_site_info_id);

        $charges=[];
        $siteFeeHeadGroupSubHeadCheckFinalIDs=[];
        foreach ($site_info_id_array as $k => $val) {


            if(count($siteFeeSetPresentList)>0){
                $siteGroupFeeSetPresent=$siteFeeSetPresentList->where('site_id', $val);
            }else{
                $siteGroupFeeSetPresent=[];
            }






//            $siteFeeHeadGroupSubHeadCheckIDs=[];
            foreach ($request->FeeHeadSubHeadGroupList as $key => $value) {

                if($value['select_fee_head_id']){

//                    $siteFeeGroupCheckIDs=[];
                    foreach ($value['academic_fee_group'] as $keys => $values) {

                        if($values['select_fee_group_id']){

//                            $siteFeeSubHeadCheckIDs=[];
                            foreach ($values['academic_fee_sub_head'] as $keyst => $valuest) {


                                if($valuest['select_fee_sub_head_id']){


                                    $siteFeeHead = $siteFeeList
                                        ->where('academic_fee_head_id', $value['id'])
                                        ->where('academic_fee_group_id', $values['id'])
                                        ->where('academic_fee_sub_head_id', $valuest['id'])
                                        ->where('site_group_id', null)
                                        ->first();


                                    if ($siteFeeHead) {
                                        $siteFeeHead->status = false;
                                        $siteFeeHead->save();
                                    }



                                    $siteGroupFeeCheck=null;
                                    if(count($siteFeeSetPresentList)) {
                                        $siteGroupFeeCheck = $siteFeeSetPresentList->where('site_id', $val)
                                            ->where('academic_fee_head_id', $value['id'])
                                            ->where('academic_fee_group_id', $values['id'])
                                            ->where('academic_fee_sub_head_id', $valuest['id'])
                                            ->first();
                                    }



                                    if($siteGroupFeeCheck){
                                        $siteFeeHeadGroupSubHeadCheckFinalIDs[]=$siteGroupFeeCheck->id;

                                        $siteGroupFeeCheck->amount=$valuest['amount'];
                                        $siteGroupFeeCheck->fine_amount=$valuest['fine_amount'];
                                        $siteGroupFeeCheck->fine_applicable_day=$valuest['fine_applicable_day'];
                                        $siteGroupFeeCheck->save();

                                    }else{
                                        $charges[] = [

                                            'academic_fee_head_id'=>$value['id'],
                                            'academic_fee_group_id'=>$values['id'],
                                            'academic_fee_sub_head_id'=>$valuest['id'],
                                            'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                                            'academic_shift_id'=>$request->academic_shift_id,
                                            'academic_version_id'=>$request->academic_version_id,
                                            'academic_year_id'=>$request->academic_year_id,
                                            'academic_department_id'=>$request->academic_department_id,
                                            'academic_class_id'=>$request->academic_class_id,
                                            'academic_class_group_id'=>$request->academic_class_group_id,
                                            'academic_session_id'=>$request->academic_session_id,
                                            'academic_student_category_id'=>$request->academic_student_category_id,
                                            'academic_student_type_id'=>$request->academic_student_type_id,
                                            'academic_student_admission_type_id'=>$request->academic_student_admission_type_id,

                                            'amount'=>$valuest['amount']?$valuest['amount']:0,
                                            'fine_amount'=>$valuest['fine_amount']?$valuest['fine_amount']:0,
                                            'fine_applicable_day'=>$valuest['fine_applicable_day']?$valuest['fine_applicable_day']:0,
                                            'status'=>true,
                                            'site_group_id'=>Session::get('SITE_GROUP_ID'),
                                            'site_id'=>$val,

                                        ];
                                    }





                                }

                            }

//                            $siteFeeGroupCheckIDs[$keys]=array_merge($siteFeeSubHeadCheckIDs);


                        }


                    }

//                    $siteFeeHeadGroupSubHeadCheckIDs[$key]=array_merge($siteFeeGroupCheckIDs);

                }

            }

//            $siteFeeHeadGroupSubHeadCheckFinalIDs[$k]=array_merge($siteFeeHeadGroupSubHeadCheckIDs);

        }




        if(count($charges)>0){
            GlobalSiteStudentFeeFineAllocation::insert($charges);

        }





//        $siteCollection = collect($siteFeeHeadGroupSubHeadCheckFinalIDs);
//        $siteFeeCheckIDsCollapsed = ((($siteCollection->collapse())->collapse())->collapse())->unique();


        if(count($siteGroupFeeSetPresent)){
            $siteFeeSetPresentIDArr=$siteGroupFeeSetPresent->pluck('id');
            $siteFeeidCheck=array_diff($siteFeeSetPresentIDArr->toArray(), $siteFeeHeadGroupSubHeadCheckFinalIDs);
        }else{
            $siteFeeSetPresentIDArr=[];
            $siteFeeidCheck=array_diff($siteFeeSetPresentIDArr, $siteFeeHeadGroupSubHeadCheckFinalIDs);
        }


        $selectIDforDelete=[];
        foreach ($siteFeeidCheck as $key => $value) {

            $checkAlradyFeeSubmit=GlobalSiteStudentFeeGenerate::where('site_student_fee_fine_allocation_id', $value)->first();

            if($checkAlradyFeeSubmit){
                $GlobalSiteStudentFeeFineAllocation=GlobalSiteStudentFeeFineAllocation::where('id', $value)
                    ->first();

                $GlobalSiteStudentFeeFineAllocation->status=false;
                $GlobalSiteStudentFeeFineAllocation->save();

            }else{
                $selectIDforDelete[]=$value;
            }
        }


        GlobalSiteStudentFeeFineAllocation::whereIn('id', $selectIDforDelete)->delete();








        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);
    }














}
