<?php

namespace App\Http\Controllers\SiteGroup\Fee;

use App\Models\Academic\AcademicFeeGroup;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Site\Fee\GlobalSiteStudentFeeSubHeadAllocation;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeeSubHeadAllocation;
use App\Models\Site\SiteFeeSubHeadAllocation;
use App\Models\Site\SiteGroupSetting;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\SiteGroup\Fee\SiteGroupFeeSubHeadAllocation;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;
use Session;
use Response;

class SiteGroupFeeSubHeadAllocationController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
    }

    public function index()
    {
        $viewType = 'Site Group Fee Setting Page';

        return view('default.admin.layouts.master', compact('viewType'));
        //        return view('default.admin.site_group.fee.fee-setting', compact('viewType'));
    }



    public function getSiteGroupFeeHeadSubheadGroupList(){


        $siteGroupSettinglist=SiteGroupSetting::select('academic_fee_head_ids','academic_fee_group_ids', 'academic_fee_sub_head_ids')
            ->where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->first();


        $feeheadSplite = explode(',', $siteGroupSettinglist->academic_fee_head_ids);
        $feeheadList = AcademicFeeHead::whereIn('id', $feeheadSplite)->get();


        $feegroupSplite = explode(',', $siteGroupSettinglist->academic_fee_group_ids);
        $feegroupList = AcademicFeeGroup::whereIn('id', $feegroupSplite)->get();


        $feeSubHeadSplite = explode(',', $siteGroupSettinglist->academic_fee_sub_head_ids);
        $feeSubHeadList = AcademicFeeSubHead::whereIn('id', $feeSubHeadSplite)->get();


        $siteGroupFeeSetCheck=SiteGroupFeeSubHeadAllocation::where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->get();

        if(count($siteGroupFeeSetCheck)<=0){

            $headArr=Array();
            $headArray=[];
            foreach ($feeheadList as $key => $value) {

                $headArr['select_fee_head_id']=false;

                $groupArr=Array();
                $groupArray=[];
                foreach ($feegroupList as $keys => $values) {

                    $groupArr['id']=$values->id;
                    $groupArr['name']=$values->name;
                    $groupArr['select_fee_group_id']=false;

                    $subheadArr=Array();
                    $subHeadArray=[];
                    foreach ($feeSubHeadList as $keyst => $valuest) {
                        $subheadArr['select_fee_sub_head_id']=false;
                        $subheadArr['vat_amount']=null;

                        $subHeadArray[$keyst]=array_merge($valuest->toArray(), $subheadArr);
                    }

                    $groupArr['fee_sub_head']=$subHeadArray;

                    $groupArray[$keys]= array_merge($groupArr);
                }
                $headArr['fee_group']=$groupArray;


                $headArray[$key]= array_merge($value->toArray(), $headArr);
            }
        }
        else{







            $headArr=Array();
            $headArray=[];
            foreach ($feeheadList as $key => $value) {

               $feeHeadPresent= $siteGroupFeeSetCheck->where('academic_fee_head_id', $value['id'])->first();

                if($feeHeadPresent){
                    $headArr['select_fee_head_id']=true;
                }else{
                    $headArr['select_fee_head_id']=false;
                }


                $groupArr=Array();
                $groupArray=[];
                foreach ($feegroupList as $keys => $values) {

                    $feeGrouPresent= $siteGroupFeeSetCheck->where('academic_fee_head_id', $value['id'])
                        ->where('academic_fee_group_id', $values['id'])
                        ->first();


                    if($feeGrouPresent){
                        $groupArr['select_fee_group_id']=true;

                    }else{
                        $groupArr['select_fee_group_id']=false;
                    }

                    $groupArr['id']=$values->id;
                    $groupArr['name']=$values->name;



                    $subheadArr=Array();
                    $subHeadArray=[];
                    foreach ($feeSubHeadList as $keyst => $valuest) {

                        $feeSubHeadPresent= $siteGroupFeeSetCheck->where('academic_fee_head_id', $value['id'])
                            ->where('academic_fee_group_id', $values['id'])
                            ->where('academic_fee_sub_head_id', $valuest['id'])
                            ->first();


                        if($feeSubHeadPresent){
                            $subheadArr['select_fee_sub_head_id']=true;
                            $subheadArr['vat_amount']=$feeSubHeadPresent->vat_amount;
                        }else{
                            $subheadArr['select_fee_sub_head_id']=false;
                            $subheadArr['vat_amount']=null;
                        }




                        $subHeadArray[$keyst]=array_merge($valuest->toArray(), $subheadArr);
                    }

                    $groupArr['fee_sub_head']=$subHeadArray;

                    $groupArray[$keys]= array_merge($groupArr);

                }

                $headArr['fee_group']=$groupArray;


                $headArray[$key]= array_merge($value->toArray(), $headArr);

            }








        }

        return response()->json($headArray, 200, []);


    }








    public function createUpdateFeeHeadGroupSubHead(Request $request){

      //  dd($request->all());

        $siteid=SiteInfo::where('site_group_id',Session::get('SITE_GROUP_ID'))->pluck('id');
        $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->pluck('site_id');

        $siteFeeList=GlobalSiteStudentFeeSubHeadAllocation::whereIn('site_id',$siteIDs)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->get();




        $siteGroupFeeSetPresent=SiteGroupFeeSubHeadAllocation::where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->get();

        $siteGroupFeeSetPresentIDArr=$siteGroupFeeSetPresent->pluck('id');


        $siteFeeHeadIDs=[];
        $siteGroupFeeCheckIDs=[];
        $charges=[];
        $chargest=[];
        foreach ($request->FeeHeadSubHeadGroupList as $key => $value) {


            if($value['select_fee_head_id']){

                foreach ($value['fee_group'] as $keys => $values) {


                    if($values['select_fee_group_id']){


                        foreach ($values['fee_sub_head'] as $keyst => $valuest) {
                            if($valuest['select_fee_sub_head_id']){

                                $siteFeeSubHeadCheck= $siteGroupFeeSetPresent
                                    ->where('academic_fee_head_id', $value['id'])
                                    ->where('academic_fee_group_id', $values['id'])
                                    ->where('academic_fee_sub_head_id', $valuest['id'])
                                    ->first();

//                                Log::info($valuest['vat_amount']);

                                if($siteFeeSubHeadCheck){
                                    $siteGroupFeeCheckIDs[]=$siteFeeSubHeadCheck->id;

                                    $siteFeeSubHeadCheck->academic_fee_sub_head_id=$valuest['id'];
                                    $siteFeeSubHeadCheck->vat_amount=$valuest['vat_amount']?$valuest['vat_amount']:0;
                                    $siteFeeSubHeadCheck->save();

                                }else{
                                    $charges[] = [
                                        'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                                        'academic_fee_head_id'=>$value['id'],
                                        'academic_fee_group_id'=>$values['id'],
                                        'academic_fee_sub_head_id'=>$valuest['id'],
                                        'vat_amount'=>$valuest['vat_amount']?$valuest['vat_amount']:0,
                                        'site_group_id'=>Session::get('SITE_GROUP_ID'),
                                        'status'=>true,

                                    ];
                                }
                            }






                        foreach ($siteIDs as $keysts => $valuests) {

//                            Log::info($valuests);

                            if($valuest['select_fee_sub_head_id']){

                                $siteFeeHead = $siteFeeList
                                    ->where('academic_fee_head_id', $value['id'])
                                    ->where('academic_fee_group_id', $values['id'])
                                    ->where('academic_fee_sub_head_id', $valuest['id'])
                                    ->where('site_group_id', null)
                                    ->first();


                                if ($siteFeeHead) {
                                    $siteFeeHead->status = false;
                                    $siteFeeHead->save();
                                }


                                $siteFeeHeadWithSiteGroup = $siteFeeList
                                    ->where('academic_fee_head_id', $value['id'])
                                    ->where('academic_fee_group_id', $values['id'])
                                    ->where('academic_fee_sub_head_id', $valuest['id'])
                                    ->where('site_id', $valuests)
                                    ->where('site_group_id', Session::get('SITE_GROUP_ID'))
                                    ->first();



                                if ($siteFeeHeadWithSiteGroup) {


                                    $siteFeeHeadIDs[] = $siteFeeHeadWithSiteGroup->id;

                                    $siteFeeHeadWithSiteGroup->academic_fee_sub_head_id = $valuest['id'];
                                    $siteFeeHeadWithSiteGroup->vat_amount =$valuest['vat_amount']?$valuest['vat_amount']:0;
                                    $siteFeeHeadWithSiteGroup->save();
                                } else {
                                    Log::info('ok');
                                    $chargest[] = [
                                        'academic_group_id' => Session::get('ACADEMIC_GROUP_ID'),
                                        'academic_fee_head_id' => $value['id'],
                                        'academic_fee_group_id' => $values['id'],
                                        'academic_fee_sub_head_id' => $valuest['id'],
                                        'vat_amount' => $valuest['vat_amount']?$valuest['vat_amount']:0,
                                        'site_group_id' => Session::get('SITE_GROUP_ID'),
                                        'site_id' => $valuests,
                                        'status' => true,

                                    ];
                                }
                            }


                        }

                        }

                    }

                }
            }


        }



        if(count($charges)>0){
            SiteGroupFeeSubHeadAllocation::insert($charges);
        }
        if(count($chargest)>0){
            GlobalSiteStudentFeeSubHeadAllocation::insert($chargest);
        }



//        Log::info($siteGroupFeeCheckIDs);

        $siteGroupFeeCheckIDsCollapsed = $siteGroupFeeCheckIDs;
        $siteGroupFeeidCheck=array_diff($siteGroupFeeSetPresentIDArr->toArray(), $siteGroupFeeCheckIDsCollapsed);
        SiteGroupFeeSubHeadAllocation::whereIn('id', $siteGroupFeeidCheck)->delete();





//        Log::info($siteFeeHeadIDs);

        $siteFeeCheckIDsCollapsed = $siteFeeHeadIDs;
        $siteFeeSetPresentIDArr=$siteFeeList->pluck('id');
        $siteFeeidCheck=array_diff($siteFeeSetPresentIDArr->toArray(), $siteFeeCheckIDsCollapsed);
        GlobalSiteStudentFeeSubHeadAllocation::whereIn('id', $siteFeeidCheck)->delete();



        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);


    }





}
