<?php

namespace App\Http\Controllers\SiteGroup;

use App\Models\Modules\SubModule;
use App\Models\Package\EduPackage;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Models\SiteGroup\Role\GlobalSiteGroupRole;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;

class SiteGroupAccessController extends Controller
{


    private $eduPackage;

    public function __construct(EduPackage $eduPackage)
    {
        $this->middleware('auth');
        $this->eduPackage = $eduPackage;

    }




    public function assignPackagesToSiteGroup(Request $req)
    {

        $this->validate($req, [
            'selectedPackages' => 'required',
            'selectedSiteGroup' => 'required'
        ]);

        $package_ids = $req->selectedPackages;
        $site_group_id = $req->selectedSiteGroup;
        $total = count($package_ids);

        $module_ids = [];
        $sub_module_ids = [];

        foreach ($package_ids as $k => $v) {
            $package = $this->eduPackage->findOrFail($v);
            if ($package) {
                $module_ids = array_merge($module_ids, $package->modules->pluck('id')->toArray());
            }

        }
        $unique_module_ids = array_unique($module_ids);

        foreach ($unique_module_ids as $k => $v) {
            $sub_module_ids = array_merge($sub_module_ids, SubModule::whereModuleId($v)->pluck('id')->toArray());
        }
        $unique_sub_module_ids = array_unique($sub_module_ids);

        $theSiteGroup = GlobalSiteGroup::findOrFail($site_group_id);
        $theSiteGroup->edu_package_ids = implode(',', $package_ids);
        $theSiteGroup->subModules()->sync($unique_sub_module_ids);
        $theSiteGroup->save();

        //assigned newly subModule to superAdmin too

        /*  if (file_exists(base_path("resources/views/default/admin/layouts/sidebars/" . $theSite->site_alias))) {
              deleteDir((base_path("resources/views/default/admin/layouts/sidebars/" . $theSite->site_alias)));
          }
  */
        $site_group_role = GlobalSiteGroupRole::firstOrCreate(['name' => 'superadmin', 'site_group_id' => $site_group_id]);
        $imploded_sub_module_ids = implode(',', $sub_module_ids) ?? null;

        if ($site_group_role->roleAccess == null) {
            $site_group_role->roleAccess()->insert([
                'site_group_role_id' => $site_group_role->id,
                'site_group_id' => $site_group_id,
                'sub_module_ids' => $imploded_sub_module_ids,

            ]);
        } else {
            $site_group_role->roleAccess->update([
                'site_group_id' => $site_group_id,
                'sub_module_ids' => $imploded_sub_module_ids
            ]);

        }

        return Response::json(['message' => $total . ' Package Attached Done Successfully!']);
    }

}
