<?php

namespace App\Http\Controllers\SiteGroup;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use Response;
use Session;
use Exception;
use Illuminate\Support\Facades\Auth;

class SiteGroupProjectController extends Controller
{

    public function siteIds(){
        if(Session::get('USER_TYPE')=='eduworld'){
            $siteid=GlobalSiteInfo::where('site_group_id',Session::get('SITE_GROUP_ID'))->pluck('id');
            $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
                ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->pluck('site_id');
        }else{
            $user_site_ids = Auth::user()->siteInfoes->pluck('id');

            $siteid=GlobalSiteInfo::where('site_group_id',Session::get('SITE_GROUP_ID'))->pluck('id');
            $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
                ->whereIn('site_id',$user_site_ids)
                ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->pluck('site_id');
            }

            return $siteIDs;

    }


}
