<?php

namespace App\Http\Controllers\SiteGroup\Student;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;
use App\Models\SiteGroup\GlobalSiteGroup;
use Error;
use Exception;
use PDF;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class SiteGroupStudentListController extends SiteGroupProjectController
{
    public $StudentAttendance;
    private $site, $GlobalStudentHistory;
    public function __construct(GlobalStudentHistory $GlobalStudentHistory)
    {
        $this->GlobalStudentHistory = $GlobalStudentHistory;
    }
    public function index()
    {
        $viewType = "Site Group Student List";
        return view('default.admin.layouts.master', compact('viewType'));
    }
    public function SiteGroupwiseStudentListCountPdfDownload(Request $request)
    {
        $groupWiseSiteStudentList =  $request->groupWiseSiteStudentList;
        $total_count              =  $request->total_count;


        $SiteGroupInfo =   GlobalSiteGroup::where('id', session()->get('SITE_GROUP_ID'))->first();
        $pdf = PDF::loadView(
            'default.admin.site_group.site-group-wise-student-count-pdf',
            compact(
                'groupWiseSiteStudentList',
                'total_count',
                'SiteGroupInfo',
            )
        )
            ->setPaper('a4', 'portrait')
            ->setWarnings(false);


        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';
        $route_name = route('open-pdf-file-storage-for-group', [$name]);

        return response()->json([
            'link' => $route_name,
        ], 200);
    }
    public function SiteGroupwiseStudentListCount(Request $request)
    {
        $paginate   = $request->paginate ?? 20;
        $searchText = trim($request->search_txt);
        $likeText   = $searchText ? '%' . $searchText . '%' : null;

        $filters = [
            'academic_class_id'                  => $request->academic_class_id,
            'academic_year_id'                   => $request->academic_year_id,
            'academic_group_id'                  => session()->get('ACADEMIC_GROUP_ID'),
            'academic_version_id'                => $request->academic_version_id,
            'academic_shift_id'                  => $request->academic_shift_id,
            'academic_session_id'               => $request->academic_session_id,
            'academic_student_admission_type_id' => $request->academic_student_admission_type_id,
            'academic_student_category_id'       => $request->academic_student_category_id,
            'academic_student_type_id'           => $request->academic_student_type_id,
            'academic_class_group_id'            => $request->academic_class_group_id,
            'site_id'                             => $request->site_id,
        ];

        $sites = [];

        if ($filters['site_id']) {
            $sites = GlobalSiteInfo::where('id', $filters['site_id'])->get();
        } else {
            $sites = GlobalSiteInfo::whereIn('id', $this->siteIds())
                ->when($likeText, function ($q) use ($likeText) {
                    $q->where(function ($query) use ($likeText) {
                        $query->orWhere('site_alias', 'LIKE', $likeText);
                        $query->orWhereTranslationLike('site_name', $likeText);
                    });
                })
                ->orderByDesc('id')
                ->get();
        }

        $results = [];
        $Total_counts = [
            'total_boys'   => 0,
            'total_girls'  => 0,
            'total_others' => 0,
            'total_students' => 0,
            'total_site' => 0,
        ];
        foreach ($sites as $site) {
            $students = $this->GlobalStudentHistory
                ->where('academic_group_id', $filters['academic_group_id'])
                ->where('site_id', $site->id)
                ->where('status', true)
                ->when($filters['academic_version_id'], fn($q) => $q->where('academic_version_id', $filters['academic_version_id']))
                ->when($filters['academic_shift_id'], fn($q) => $q->where('academic_shift_id', $filters['academic_shift_id']))
                ->when($filters['academic_year_id'], fn($q) => $q->where('academic_year_id', $filters['academic_year_id']))
                ->when($filters['academic_class_id'], fn($q) => $q->where('academic_class_id', $filters['academic_class_id']))
                ->when($filters['academic_class_group_id'], fn($q) => $q->where('academic_class_group_id', $filters['academic_class_group_id']))
                ->when($filters['academic_session_id'], fn($q) => $q->where('academic_session_id', $filters['academic_session_id']))
                ->when($filters['academic_student_admission_type_id'], fn($q) => $q->where('academic_student_admission_type_id', $filters['academic_student_admission_type_id']))
                ->when($filters['academic_student_category_id'], fn($q) => $q->where('academic_student_category_id', $filters['academic_student_category_id']))
                ->when($filters['academic_student_type_id'], fn($q) => $q->where('academic_student_type_id', $filters['academic_student_type_id']))
                ->with([
                    'student.gender',
                    'student:id,gender_id'
                ])
                ->orderBy('student_roll_number')
                ->get();

            $counts = [
                'total_boys'   => 0,
                'total_girls'  => 0,
                'total_others' => 0,
            ];

            foreach ($students as $student) {
                $gender = $student->student->gender->head_key ?? null;
                if ($gender && isset($counts["total_{$gender}"])) {
                    $counts["total_{$gender}"]++;
                }
            }

            $results[] = [
                'id'             => $site->id,
                'site_name'      => $site->site_name,
                'total_students' => $students->count(),
            ] + $counts;

            $Total_counts['total_site'] += 1;
            $Total_counts['total_students'] += $students->count();
            $Total_counts['total_boys'] += $counts['total_boys'];
            $Total_counts['total_girls'] += $counts['total_girls'];
            $Total_counts['total_others'] += $counts['total_others'];
        }


        return response()->json([$results, $Total_counts, 200]);
    }
    public function SingleSiteGroupwiseStudentList(Request $request)
    {
        $paginate = $request->paginate ?? 20;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';


        $data = [];

        $data['academic_class_id']                    = $request->academic_class_id          ? $request->academic_class_id : null;
        $data['academic_year_id']                     = $request->academic_year_id           ? $request->academic_year_id : null;
        $data['academic_group_id']                    = session()->get('ACADEMIC_GROUP_ID')  ? session()->get('ACADEMIC_GROUP_ID') : null;
        $data['academic_version_id']                  = $request->academic_version_id        ? $request->academic_version_id : null;
        $data['academic_shift_id']                    = $request->academic_shift_id          ? $request->academic_shift_id : null;
        $data['academic_session_id']                  = $request->academic_session_id        ? $request->academic_session_id : null;
        $data['academic_student_admission_type_id']   = $request->academic_student_admission_type_id  ? $request->academic_student_admission_type_id : null;
        $data['academic_student_category_id']         = $request->academic_student_category_id        ? $request->academic_student_category_id : null;
        $data['academic_student_type_id']             = $request->academic_student_type_id            ? $request->academic_student_type_id : null;
        $data['academic_student_admission_type_id']   = $request->academic_student_admission_type_id  ? $request->academic_student_admission_type_id : null;
        $data['academic_class_group_id']              = $request->academic_class_group_id  ? $request->academic_class_group_id : null;
        $data['site_id']                              = $request->single_site_id           ? $request->single_site_id : null;



        if ($data['site_id']) {

            $site = GlobalSiteInfo::select('id')
                ->where('id', $data['site_id'])
                ->first();

            $student_lists = $this->GlobalStudentHistory
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })
                ->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })

                ->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })

                ->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->when($data['academic_student_category_id'], function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when($data['academic_student_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })

                ->where('academic_group_id', $data['academic_group_id'])

                ->select('id', 'user_id', 'student_roll_number')
                ->whereHas('student', function ($query) use ($search_txt, $txt) {

                    $query->where('user_type', 'student')
                        ->when($search_txt, function ($q) use ($txt) {
                            return $q->where(function ($query) use ($txt) {
                                $query->where('username', 'LIKE', $txt)
                                    ->orWhere('email', 'LIKE', $txt)
                                    ->orWhere('contact_number', 'LIKE', $txt)
                                    ->orWhereTranslationLike('first_name', $txt)
                                    ->orWhereTranslationLike('last_name', $txt);
                            });
                        })->select('id', 'religion_id', 'gender_id', 'biometric_id', 'username', 'present_id_card_code');
                })
                ->with([
                    'shift',
                    'section',
                    'stClass',
                    'student.religion',
                    'student.gender',
                    'student.latestPhoto',
                    'student' => function ($query) {
                        $query->select('id', 'religion_id', 'gender_id', 'biometric_id', 'username', 'present_id_card_code');
                    },
                ])
                ->orderBy('student_roll_number')
                ->where('site_id', $data['site_id'])
                ->where('status', true)
                ->paginate($paginate);

            return response()->json([
                'students' => $student_lists,
                'site_name' => $site->site_name,
            ], 200);
        }
    }
    public function SiteGroupwiseReligionStudentListCount(Request $request)
    {

        $paginate = $request->paginate ?? 20;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';


        $data = [];

        $data['academic_class_id']                    = $request->academic_class_id          ? $request->academic_class_id : null;
        $data['academic_year_id']                     = $request->academic_year_id           ? $request->academic_year_id : null;
        $data['academic_group_id']                    = session()->get('ACADEMIC_GROUP_ID')  ? session()->get('ACADEMIC_GROUP_ID') : null;
        $data['academic_version_id']                  = $request->academic_version_id        ? $request->academic_version_id : null;
        $data['academic_shift_id']                    = $request->academic_shift_id          ? $request->academic_shift_id : null;
        $data['academic_session_id']                  = $request->academic_session_id        ? $request->academic_session_id : null;
        $data['academic_student_admission_type_id']   = $request->academic_student_admission_type_id  ? $request->academic_student_admission_type_id : null;
        $data['academic_student_category_id']         = $request->academic_student_category_id        ? $request->academic_student_category_id : null;
        $data['academic_student_type_id']             = $request->academic_student_type_id            ? $request->academic_student_type_id : null;
        $data['academic_student_admission_type_id']   = $request->academic_student_admission_type_id  ? $request->academic_student_admission_type_id : null;
        $data['academic_class_group_id']              = $request->academic_class_group_id  ? $request->academic_class_group_id : null;
        $data['site_id']                              = $request->site_id  ? $request->site_id : null;

        if (!$data['academic_year_id']) {
            throw new Error('Please Select Year');
        }

        $s_List = [];
        $key = 0;

        $TotalGroupWiseCount                             = [];
        $TotalGroupWiseCount['total_Grpup_site']         = 0;
        $TotalGroupWiseCount['total_undefined_religion'] = 0;
        $TotalGroupWiseCount['total_Group_students']     = 0;

        if ($data['site_id']) {

            $site = GlobalSiteInfo::select('id')
                ->where('id', $data['site_id'])
                ->first();

            $student_lists_for_single_site = $this->GlobalStudentHistory
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })
                ->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })

                ->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })

                ->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->when($data['academic_student_category_id'], function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when($data['academic_student_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })

                ->where('academic_group_id', $data['academic_group_id'])
                ->select('id', 'user_id',)
                ->with([
                    'student.religion',
                    'student' => function ($query) {
                        $query->select('id', 'religion_id');
                    },
                ])

                ->orderBy('student_roll_number')
                ->where('site_id', $data['site_id'])
                ->where('status', true)
                ->get();



            $ReligionCounts = [];
            $UndefinedReligion = 0;


            foreach ($student_lists_for_single_site as $student) {
                if (isset($student->student->religion)) {
                    $religionName = $student->student->religion->name;

                    $index = array_search($religionName, array_column($ReligionCounts, 'religion_name'));

                    if ($index !== false) {
                        $ReligionCounts[$index]['religion_count']++;
                    } else {
                        $ReligionCounts[] = ['religion_name' => $religionName, 'religion_count' => 1];
                    }
                } else {
                    $UndefinedReligion += 1;
                }
            }



            $s_List[$key]['id']               = $site->id;
            $s_List[$key]['site_name']        = $site->site_name;
            $s_List[$key]['total_students']   = $student_lists_for_single_site->count();
            $s_List[$key]['ReligionCounts']   = $ReligionCounts;

            $TotalGroupWiseCount['total_Grpup_site']++;
            $TotalGroupWiseCount['total_undefined_religion'] += $UndefinedReligion;
            $TotalGroupWiseCount['total_Group_students']     += $student_lists_for_single_site->count();
        } else {
            $siteLists = GlobalSiteInfo::select('id')
                ->whereIn('id', $this->siteIds())
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->orWhere('site_alias', 'LIKE', $txt);
                        $query->orWhereTranslationLike('site_name', $txt);
                    });
                })
                ->orderBy('id', 'DESC')
                ->get();

            foreach ($siteLists as $site) {

                $student_lists = $this->GlobalStudentHistory
                    ->when($data['academic_version_id'], function ($query) use ($data) {
                        return $query->where('academic_version_id', $data['academic_version_id']);
                    })
                    ->when($data['academic_shift_id'], function ($query) use ($data) {
                        return $query->where('academic_shift_id', $data['academic_shift_id']);
                    })
                    ->when($data['academic_year_id'], function ($query) use ($data) {
                        return $query->where('academic_year_id', $data['academic_year_id']);
                    })
                    ->when($data['academic_class_id'], function ($query) use ($data) {
                        return $query->where('academic_class_id', $data['academic_class_id']);
                    })

                    ->when($data['academic_class_group_id'], function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })

                    ->when($data['academic_session_id'], function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->when($data['academic_student_category_id'], function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when($data['academic_student_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })

                    ->where('academic_group_id', $data['academic_group_id'])
                    ->select('id', 'user_id',)
                    ->with([
                        'student.religion',
                        'student' => function ($query) {
                            $query->select('id', 'religion_id');
                        },
                    ])

                    ->orderBy('student_roll_number')
                    ->where('site_id', $site->id)
                    ->where('status', true)
                    ->get();



                $ReligionCounts = [];
                $UndefinedReligion = 0;


                foreach ($student_lists as $student) {
                    if (isset($student->student->religion)) {
                        $religionName = $student->student->religion->name;

                        $index = array_search($religionName, array_column($ReligionCounts, 'religion_name'));

                        if ($index !== false) {
                            $ReligionCounts[$index]['religion_count']++;
                        } else {
                            $ReligionCounts[] = ['religion_name' => $religionName, 'religion_count' => 1];
                        }
                    } else {
                        $UndefinedReligion += 1;
                    }
                }



                $s_List[$key]['id']               = $site->id;
                $s_List[$key]['site_name']        = $site->site_name;
                $s_List[$key]['total_students']   = $student_lists->count();
                $s_List[$key]['ReligionCounts']   = $ReligionCounts;
                $key++;

                $TotalGroupWiseCount['total_Grpup_site']++;
                $TotalGroupWiseCount['total_undefined_religion'] += $UndefinedReligion;
                $TotalGroupWiseCount['total_Group_students']     += $student_lists->count();
            }
        }

        return response()->json([
            's_List' => $s_List,
            'TotalGroupWiseCount' => $TotalGroupWiseCount
        ], 200);
    }
}
