<?php

namespace App\Http\Controllers\SitePublic\Site;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Academic\AcademicPeriodType;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicSessionType;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Relation\Relation;
use App\Models\Site\Batch\GlobalBatchDetail;
use App\Models\Site\Employee\TeacherAssignToClassSection;
use App\Models\Site\GlobalSiteClassSessionSerialSetting;
use App\Models\Site\Fee\SiteStudentFeeSubHeadAllocation;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Academic\AcademicResultPrimaryType;

use App\Models\Student\StudentHistory;
use App\Models\Student\PublicStudentHistory;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Site\Result\SiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\GlobalSiteResultSystemSetting;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use Exception;
use Illuminate\Support\Facades\Auth;
use App\Models\Site\Employee\Employee;

use Response;
use Session;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use App\Models\Academic\AcademicExamType;
use App\Models\Site\Result\GlobalSiteExamResultReportSetting;
use App\Models\Site\Result\GlobalSiteStudentPrimaryResultDetail;
use App\Models\SiteGroup\Exam\GlobalSiteGroupStudentExamRoll;
use App\Models\SiteGroup\ExamResult\GlobalSiteGroupResultPermission;
use App\Models\SiteGroup\ExamResult\GlobalSiteGroupResultPrimarySettingStore;
use App\Models\SiteGroup\ExamResult\SiteGroupResultPrimarySettingStore;
use App\Traits\Site\Result\ExamResultTrait;
use PDF;

class PublicResultController extends Controller
{
    use ExamResultTrait;

    private $siteShiftClassGroupSectionSetting;
    private $academicClassGroup;


    public function __construct(AcademicClassGroup $academicClassGroup, GlobalSiteShiftClassGroupSectionSetting $siteShiftClassGroupSectionSetting)
    {
      
        $this->siteShiftClassGroupSectionSetting = $siteShiftClassGroupSectionSetting;
        $this->academicClassGroup = $academicClassGroup;
    }

    private function getStudenthistoryIDs(Request $request, $site_id){
   $data = $request->all();
  

   $studentList = GlobalStudentHistory::select('id', 'user_id','student_roll_number')
       ->with(['student' => function ($q) {
           $q->with('latestPhoto');
           $q->select('id');
           $q->where('user_type', 'student');
       },
           'year', 'shift','department','stClass','classGroup','session','section'
       ])
       ->where('site_id', $site_id)
       ->where('academic_group_id', $request->academic_group_id)
       ->where('academic_version_id', $request->academic_version_id)
       ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
           return $query->where('academic_year_id', $data['academic_year_id']);
       })
       ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
           return $query->where('academic_shift_id', $data['academic_shift_id']);
       })
       ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
           return $query->where('academic_department_id', $data['academic_department_id']);
       })
       ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
           return $query->where('academic_class_id', $data['academic_class_id']);
       })
       ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
           return $query->where('academic_class_group_id', $data['academic_class_group_id']);
       })
       ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
           return $query->where('academic_section_id', $data['academic_section_id']);
       })
       ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
           return $query->where('academic_session_id', $data['academic_session_id']);
       })
       ->orderBy('student_roll_number')
       ->orderBy('academic_department_id')
       ->orderBy('academic_class_id')
       ->orderBy('academic_class_group_id')
       ->orderBy('academic_section_id')
       ->get();

   return $studentList;
}


    public function getStudentPrimaryResultList(Request $request){
        $primary_exam_type_ids=SiteStudentPrimaryResultDetail::where('student_history_id', $request->student_history_id)
        ->where('result_student_publish_status', true)
        ->pluck('academic_result_primary_type_id')
        ->unique()
        ->filter();

    $result_primary_type_list=AcademicResultPrimaryType::whereIn('id', $primary_exam_type_ids)->get(['id', 'name']);

    }


   public function getResultListForPublic(Request $request){

    $site_list = $this->getSiteId();
    $site_id = $site_list->id;

    if($request->student_username){
        $student_ids=[$request->student_history_id];

    }else{
        $studentList=$this->getStudenthistoryIDs($request, $site_id);
        $student_ids=$studentList->pluck('id');
    }

    $checkGroupPermission=GlobalSiteGroupResultPermission::where('academic_year_id',$request->academic_year_id)
            ->where('academic_class_id',$request->academic_class_id)
            ->where('site_id',$site_id)
            ->where('academic_group_id',$request->academic_group_id)
            ->where('public_result_permission_status', true)
            ->pluck('academic_result_primary_type_id');

    $primary_exam_type_ids=GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_ids)
          ->where('site_id', $site_id)
           ->where(function ($query) use ($checkGroupPermission) {
                $query->where(function ($q) {
                    $q->where('result_generated_by', 'site')
                    ->where('result_public_publish_status', true);
                })->orWhere(function ($q) use ($checkGroupPermission) {
                    $q->where('result_generated_by', 'site_group')
                    ->whereIn('academic_result_primary_type_id', $checkGroupPermission);
                });
            })
          ->pluck('academic_result_primary_type_id')
          ->unique()
          ->filter();

    $result_primary_type_list=AcademicResultPrimaryType::whereIn('id', $primary_exam_type_ids)->where('use_key','site')->get();

    return $result_primary_type_list;

   }

  

   public function getGroupResultListForPublic(Request $request){

        $site_group_id=Session::get('SITE_GROUP_ID');
        $academic_group_id=Session::get('ACADEMIC_GROUP_ID');

       // dd($academic_group_id);

        $primary_exam_type_ids = GlobalSiteGroupResultPrimarySettingStore::where([
                'site_group_id' => $site_group_id,
                'academic_group_id' => $request->academic_group_id,
               // 'academic_version_id' => $request->academic_version_id,
                'academic_year_id' => $request->academic_year_id,
            //    'academic_shift_id' => $request->academic_shift_id,
                'academic_class_id' => $request->academic_class_id
            ])
            ->pluck('academic_result_primary_type_id');

           // dd($primary_exam_type_ids);
   
        $result_primary_type_list=AcademicResultPrimaryType::whereIn('id', $primary_exam_type_ids)->where('use_key','site_group')->get();

      return $result_primary_type_list;

   }

  


   public function versionYearShiftBasedSectionsOrClassGroupsAndSessionByClassForPublic(Request $requests)
   {
    //this function returns class groups by version,year, and shift if groups not present then sections

    if(Session::get('USER_TYPE')=='site'){
       
  
        $site_list = $this->getSiteId();
        $site_id = $site_list->id;

        $data = $requests->all();
        $group_id  =   $data['academic_group_id'];
        $version_id  =   $data['academic_version_id'];
        $year_id     =   $data['academic_year_id'];
        $shift_id    =   $data['academic_shift_id'];
        $class_id    =   $data['academic_class_id'];
     
  //  dd($data);

       if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id'] || !$data['academic_class_id']) {
           return Response::json(['message' => 'Select * Marked Field!'], 411);
       }


       $SiteInfoTableData = GlobalSiteInfoSetting::where('site_id', $site_id)->where('academic_group_id',$group_id)->select('id', 'batch_present_status')
           ->first();


       if ($SiteInfoTableData->batch_present_status) {
           $batch_list = GlobalBatchDetail::where('academic_class_id', $class_id)
               ->where('academic_group_id', $group_id)
               ->where('site_id', $site_id)
               ->where('academic_version_id', $version_id)
               ->where('academic_shift_id', $shift_id)
               ->where('academic_year_id', $year_id)
               ->select('id', 'batch_name', 'batch_code')
               ->get();

           //   dd($class_id,$version_id,$shift_id,$year_id);


       } else {
           $batch_list = [];
       }


       $group_list = [];
       $section_list = [];

       $group_present = $this->siteShiftClassGroupSectionSetting
           ->where('site_id', $site_id)
           ->where('academic_group_id', $group_id)
           ->where('academic_version_id', $version_id)
           ->where('academic_year_id', $year_id)
           ->where('academic_shift_id', $shift_id)
           ->where('academic_class_id', $class_id)
           ->whereNotNull('academic_class_group_id')
           ->get();
//        return $group_present;


       if (count($group_present) > 0) {
           $group_ids = $group_present->pluck('academic_class_group_id')->toArray();
           $group_list = $this->academicClassGroup
               ->whereIn('id', $group_ids)
               ->get();


       } else {

           $section_present = $this->siteShiftClassGroupSectionSetting
                ->where('site_id', $site_id)
                ->where('academic_group_id', $group_id)
               ->where('academic_version_id', $version_id)
               ->where('academic_year_id', $year_id)
               ->where('academic_shift_id', $shift_id)
               ->where('academic_class_id', $class_id)
               ->first();

           $exploded_section_ids = explode(',', $section_present->academic_section_ids ?? null);

           $section_list = AcademicSection::select('id', 'section_name')
               ->whereIn('id', $exploded_section_ids)
               ->get();
            }

       $session_exist = GlobalSiteClassSessionSerialSetting::where('academic_class_id', $data['academic_class_id'])
            ->where('site_id', $site_id)
           ->where('academic_group_id', $group_id)
           ->where('academic_version_id', $data['academic_version_id'])
           ->where('academic_year_id', $data['academic_year_id'])
           ->where('academic_shift_id', $data['academic_shift_id'])
           ->when($data['academic_department_id'],function($q) use ($data){
                $q->where('academic_department_id', $data['academic_department_id']);
           })
           ->first();

       if ($session_exist && $session_exist->session_present) {
           $exploded_session_list = explode(',', $session_exist->session_ids);
           $session_list = AcademicSession::whereIn('id', $exploded_session_list)->get();
       } else {
           $session_list = [];
       }
       $resultList=$this->getResultListForPublic($requests);

    }else{
        $group_list=[];
        $section_list=[]; 
        $session_list=[]; 
        $batch_list=[]; 
        $resultList=$this->getGroupResultListForPublic($requests);

    }

       return [$group_list, $section_list, $session_list, $batch_list, $resultList];
   }


   public function getSiteClassGroupBaseSectionSessionList(Request $requests)
   {//this function returns class groups by version,year, and shift if groups not present then sections

       $data = $requests->all();
       $group_id  =   $data['academic_group_id'];
       $version_id  =   $data['academic_version_id'];
       $year_id     =   $data['academic_year_id'];
       $shift_id    =   $data['academic_shift_id'];
       $class_id    =   $data['academic_class_id'];
       $class_group_id  =   $data['academic_class_group_id'];
    // dd($year_id);
       $site_list = $this->getSiteId();
        $site_id = $site_list->id;

        $groupPresentCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_class_group_id')
        ->where('academic_version_id', $version_id)
        ->where('academic_year_id', $year_id)
        ->where('academic_class_id', $class_id)
        ->whereNotNull('academic_class_group_id')
        ->count();

        $sessionPresentCheck = GlobalSiteClassSessionSerialSetting::where('site_id', $site_id)
        ->where('academic_group_id', $group_id)->where('academic_class_id', $class_id)->first();

        if ($sessionPresentCheck) {
        if ($sessionPresentCheck->session_present) {
            $SiteInfoTableData = GlobalSiteInfoSetting::where('site_id', $site_id)->where('academic_group_id',$group_id)->first();
            $Sessionlistsplite = explode(',', $SiteInfoTableData->academic_session_ids);
            $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();
        } else {
            $Sessionlist = [];
        }
        } else {
        $Sessionlist = [];
        }


        if (!$groupPresentCount) {

        $SiteClassBaseSectionCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_shift_id')
            ->where('site_id', $site_id)
            ->where('academic_group_id', $group_id)
            ->where('academic_version_id', $version_id)
            ->where('academic_year_id', $year_id)
            ->where('academic_class_id', $class_id)
            ->count();


        if (!$shift_id && $SiteClassBaseSectionCount > 1) {
            return 4001;
        } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
            $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                ->where('site_id', $site_id)
                ->where('academic_group_id', $group_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_class_id', $class_id)
                ->first();

        } else if ($shift_id && $class_id) {
            $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                ->where('site_id', $site_id)
                ->where('academic_group_id', $group_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_class_id', $class_id)
                ->where('academic_shift_id', $shift_id)
                ->first();

            }
        } else {
        if (!$shift_id && !$class_group_id) {
            return 4001;
        } else if ($shift_id && !$class_group_id) {
            $SiteGroup = GlobalSiteShiftClassGroupSectionSetting::select('academic_class_group_id')
                ->where('site_id', $site_id)
                ->where('academic_group_id', $group_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_class_id', $class_id)
                ->where('academic_shift_id', $shift_id)
                ->get();

            $sectionDataList = AcademicClassGroup::select('id', 'group_name')
                ->whereIn('id', $SiteGroup)
                ->get();


            return [2001, $sectionDataList, $Sessionlist];
        } else {
            $SiteClassBaseSectionCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_shift_id')
                ->where('site_id', $site_id)
                ->where('academic_group_id', $group_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_class_id', $class_id)
                ->where('academic_class_group_id', $class_group_id)
                ->get()
                ->count();


            if (!$shift_id && $SiteClassBaseSectionCount > 1) {
                return 4001;
            } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
                $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                    ->where('site_id', $site_id)
                    ->where('academic_group_id', $group_id)
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_class_group_id', $class_group_id)
                    ->first();
            } else if ($shift_id && $class_id) {
                $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                    ->where('site_id', $site_id)
                    ->where('academic_group_id', $group_id)
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_shift_id', $shift_id)
                    ->where('academic_class_group_id', $class_group_id)
                //    ->where('site_id',$site_id)
                    ->first();
                  //  dd($SiteClassBaseSection);
            }
        }
        }

        $SectionData = explode(',', $SiteClassBaseSection->academic_section_ids ?? null);

        $SectionDataList = AcademicSection::select('id', 'section_name')
        ->whereIn('id', $SectionData)
        ->get();

        return [$SectionDataList, $Sessionlist];
   }

   private function getSiteId()
   {
       $domain = "";
       if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
           $getHost = explode(".", $_SERVER['HTTP_HOST']);
           $domain = array_shift($getHost);
       }

       $get_site_id = SiteInfo::select('id', 'site_logo', 'site_alias')->where('site_alias', $domain)->first();

       return $get_site_id;
   }

   public function getStudentResulForPublic(Request $request){

        $data=[];
        $data = $request->all();
        if(Session::get('USER_TYPE')=='site'){
           

        

        $site_list = $this->getSiteId();

      //  dd($site_list->id);
        $site_id = $site_list->id;

       

        if($request->student_username){
        $this->validate($request, [
            "student_username" => "required",
            "student_history_id" => "required",
            "academic_result_primary_type_id" => "required",
           
        ]);

        $studentHistory=GlobalStudentHistory::with('site')
            ->where('site_id', $site_id)
            ->where('id', $request->student_history_id)
         //   ->select('id','site_id',)
            ->orderBy('id','DESC')
            ->first();
    }else{
        $this->validate($request, [
            "academic_group_id" => "required",
            "academic_version_id" => "required",
            "academic_year_id" => "required",
            "academic_shift_id" => "required",
            "academic_class_id" => "required",
            "academic_result_primary_type_id" => "required",
            "student_roll_number" => "required",
        ]);

          $studentHistory=GlobalStudentHistory::with('site')
            ->where('site_id', $site_id)
            ->where('academic_group_id', $request->academic_group_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('student_roll_number', $request->student_roll_number)
            ->where('status', true)
            ->when(!empty($data['academic_class_group_id']), function($q) use ($request){
            $q->where('academic_class_group_id', $request->academic_class_group_id);
            })
            ->when(!empty($data['academic_section_id']), function($q) use ($request){
            $q->where('academic_section_id', $request->academic_section_id);
            })
            ->when(!empty($data['site_batch_detail_id']), function($q) use ($request){
            $q->where('site_batch_detail_id', $request->site_batch_detail_id);
            })
           // ->select('id','site_id','student_roll_number')
            ->orderBy('id','DESC')
            ->first();

           
                  

        }
    }else{

       //  return response()->json(['message'=>'Result Not Found','status'=>false],422);

        $site_group_id=Session::get('SITE_GROUP_ID');


           $resultSett = GlobalSiteGroupResultPrimarySettingStore::where([
                'site_group_id' => $site_group_id,
                'academic_group_id' => $request->academic_group_id,
                'academic_version_id' => $request->academic_version_id,
                'academic_year_id' => $request->academic_year_id,
                'academic_shift_id' => $request->academic_shift_id,
                'academic_class_id' => $request->academic_class_id,
                'academic_result_primary_type_id' => $request->academic_result_primary_type_id
            ])
            ->first();

           

            $examRolls = GlobalSiteGroupStudentExamRoll::where([
                    'site_group_id' => $site_group_id,
                    'academic_group_id' => $request->academic_group_id,
                    'examination_id' => $resultSett->examination_id,
                    'roll' => $request->student_roll_number,
                ])
                ->first();
         //   dd($examRolls);

           $studentHistory=GlobalStudentHistory::with('site')
            ->where('id', $examRolls->student_history_id)
            ->first();
           
    }
      
         
        if(!$studentHistory){
            return Response::json(['message'=>'Student not found', 'status'=>'404'],404);
        }
        
           $student_ids=[$studentHistory->id];
           
        $data['site_id']=$studentHistory->site_id;
        $data['academic_group_id']=$studentHistory->academic_group_id;
        $data['academic_version_id']=$studentHistory->academic_version_id;
        $data['academic_year_id']=$studentHistory->academic_year_id;
        $data['academic_shift_id']=$studentHistory->academic_shift_id;
        $data['academic_class_id']=$studentHistory->academic_class_id;
        $data['academic_section_id']=$studentHistory->academic_section_id;
        $data['academic_class_group_id']=$studentHistory->academic_class_group_id;
        $data['academic_session_id']=$studentHistory->academic_session_id;
        $data['site_batch_detail_id']=$studentHistory->site_batch_detail_id;

    $resultDetails=$this->primaryResultTypeBaseResultDetails($data,$student_ids,'site_public');

    if($resultDetails['status']!=200){
        return Response::json(['message'=>$resultDetails['message'],'status'=>$resultDetails['status']],410);
    }

   return $resultDetails['result_array'];

   }

   
   public function getSiteStudentAndPrimaryResultTypeBaseResultDetail($request){


    $site_list = $this->getSiteId();
    $site_id = $site_list->id;

    if($request->student_username){
        $this->validate($request, [
            "student_username" => "required",
            "student_history_id" => "required",
            "academic_result_primary_type_id" => "required",
           
        ]);

        $studentHistory=GlobalStudentHistory::with('site')
            ->where('site_id', $site_id)
            ->where('id', $request->student_history_id)
         //   ->select('id','site_id',)
            ->orderBy('id','DESC')
            ->first();
    }else{
        $this->validate($request, [
            "academic_group_id" => "required",
            "academic_version_id" => "required",
            "academic_year_id" => "required",
            "academic_shift_id" => "required",
            "academic_class_id" => "required",
            "academic_result_primary_type_id" => "required",
            "student_roll_number" => "required",
        ]);

        $data = $request->all();

        $studentHistory=GlobalStudentHistory::with('site')
            ->where('site_id', $site_id)
            ->where('academic_group_id', $request->academic_group_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('student_roll_number', $request->student_roll_number)
            ->where('status', true)
            ->when($data['academic_class_group_id'], function($q) use ($request){
            $q->where('academic_class_group_id', $request->academic_class_group_id);
            })
            ->when($data['academic_section_id'], function($q) use ($request){
            $q->where('academic_section_id', $request->academic_section_id);
            })
            ->when($data['site_batch_detail_id'], function($q) use ($request){
            $q->where('site_batch_detail_id', $request->site_batch_detail_id);
            })
           // ->select('id','site_id','student_roll_number')
            ->orderBy('id','DESC')
            ->first();
        
        }

       if($studentHistory){
            $dataaa=SiteStudentPrimaryResultDetail::with(['studentHistory'=>function ($query) {
                $query->select('id', 'user_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id',
                    'academic_session_id', 'academic_student_category_id', 'board_registration_number',
                    'academic_class_group_id', 'academic_section_id', 'academic_year_id', 'student_roll_number',
                    'registration_no');
                $query->with(['student' => function ($q) {
                    $q->with('latestPhoto');
                    $q->select('id','date_of_birth');
                    $q->where('user_type', 'student');
                },
                'site','year', 'shift','department','stClass','classGroup','session','section'
                ]);
            }, 'academicResultPrimaryType'])
            ->where('student_history_id', $studentHistory->id)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('result_public_publish_status', true)
            ->where('result_public_full_publish_status', true)
            ->where('status', true)
            ->get();

         //   dd(count($dataaa));
          
            
        if(count($dataaa)<=0){
            return response()->json(['message'=>'Result Not Found','status'=>false],422);
        }
  
       }else{
        return response()->json(['message'=>'Student Not Found','status'=>false],422);
       }

          // Employee
          $institute_head = Employee::where('institute_head', 1)->first();
          $site_info =  SiteInfo::find(Session::get('SITE_ID'));
   
          $get_signature = $institute_head->signature ?? '/img/signature/signature.png';
          $get_designation = $institute_head->designation->name ?? 'Institution Head';


    
      $a_arr=Array();
      $a_array=[];

      foreach ($dataaa as $key => $value){
       
          $b_array=[];
          foreach ($value->site_individual_combine_subject_result_store_ids as $keyt => $valuet){
              $b_array[]=$valuet->subject_detail;
          }

          $result_show_in_table_bellow_status_present=collect($b_array)->pluck('result_show_in_table_bellow_status')->unique()->filter();

        $a_arr['academic_result_primary_type_id']=$value->academic_result_primary_type_id;
            $a_arr['result_type_name']=$value->academicResultPrimaryType->name;
            $a_arr['student_history_id']=$value->student_history_id;
            $a_arr['fail_subject_count']=$value->fail_subject_count;
            $a_arr['gpa']=$value->gpa;
            $a_arr['grade']=$value->grade;
            $a_arr['student_rank']=$value->student_rank;
            $a_arr['site_result_primary_setting_id']=$value->site_result_primary_setting_id;
            $a_arr['academic_result_primary_type_id']=$value->academic_result_primary_type_id;
            $a_arr['subject_list']=$b_array;
            $a_arr['table_header']=$value->table_header;
            $a_arr['highest_marks']=json_decode($value->highest_marks_list);
            $a_arr['student_history']=$value->studentHistory;
            
            $a_arr['total_student']=$value->total_student;

            $a_arr['student_photo']=$value->studentHistory->student->latestPhoto?
                $value->studentHistory->student->latestPhoto->name:'image-not.png';

            $a_arr['result_show_in_table_bellow_status_present']=count($result_show_in_table_bellow_status_present)>0?1:0;
    
            $a_arr['result_type_name']=$value->academicResultPrimaryType->name;
            $a_arr['result_type_id']=$value->academicResultPrimaryType->id;

            $a_arr['classtest_is_present']=$value->classtest_is_present;
            $a_arr['combine_subject_present']=$value->combine_subject_present;
            $a_arr['final_grade_without_optional']=$value->final_grade_without_optional;
            $a_arr['final_point_without_optional']=$value->final_point_without_optional;
            $a_arr['id']=$value->id;
            $a_arr['raw_obtain_marks_percentage']=number_format((float)$value->raw_obtain_marks_percentage, 2, '.', '');
            $a_arr['sum_of_obtain_percent_total_marks']=$value->sum_of_obtain_percent_total_marks;
            $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;
            $a_arr['sum_of_raw_total_marks']=$value->sum_of_raw_total_marks;
            $a_arr['sum_of_obtain_total_marks_for_show']=$value->sum_of_obtain_total_marks_for_show;
          //  $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;
          $a_arr['sum_of_obtain_total_percent_for_show']=$value->sum_of_obtain_total_percent_for_show;
          //$a_arr['obtain_total_marks_for_show']=$value->obtain_total_marks_for_show;

          $a_arr['institute_head_teacher_signature']=$get_signature;
          $a_arr['institute_head_teacher_designation']=$get_designation;
          $a_arr['address']=$site_info->site_name;
          $a_arr['comment']=$site_info->comment;

          $a_arr['academic_days']=$value->academic_days;
          $a_arr['present_days']=$value->present_days;
          $a_arr['absent_days']=$value->absent_days;
          $a_arr['behaviour']=$value->behaviour;
          $a_arr['cultural_activities']=$value->cultural_activities;
          $a_arr['bncc']=$value->bncc;
          $a_arr['debate']=$value->bncc;
          $a_arr['scout']=$value->scout;
          $a_arr['sports']=$value->sports;
          $a_arr['others']=$value->others;

          $a_array[$key]=array_merge($a_arr);
       //   $final_array[$key]=array_merge($a_arr);
      }

    
    $data = $request->all();
    $siteResultSystemSettingPresent=GlobalSiteResultSystemSetting::with(['academicResultSystem'])
        ->where('site_id', $site_id)
      //  ->where('academic_group_id', $studentHistory->academic_group_id)
        ->where('academic_year_id', $studentHistory->academic_year_id)
        ->where('academic_version_id', $studentHistory->academic_version_id)
        ->where('academic_class_id', $studentHistory->academic_class_id)
        ->when(!empty($studentHistory->academic_department_id), function ($query) use ($studentHistory) {
            return $query->where('academic_department_id', $studentHistory->academic_department_id);
        })
        ->where('status',true)
        ->get()
        ->sortBy(function ($item) {
            return $item->academicResultSystem->serial ?? 0;
        });

    return [$a_array, $siteResultSystemSettingPresent];

}

   public function getStudentResulDetailsPdfForPublic(Request $request){

    $data=[];
    $data = $request->all();

    if(Session::get('USER_TYPE')=='site'){
       

        $site_list = $this->getSiteId();
        $site_id = $site_list->id;

        //dd($site_id);

    if($request->student_username){
        $this->validate($request, [
            "student_username" => "required",
            "student_history_id" => "required",
            "academic_result_primary_type_id" => "required",
           
        ]);

        $studentHistory=GlobalStudentHistory::with('site')
            ->where('site_id', $site_id)
            ->where('id', $request->student_history_id)
         //   ->select('id','site_id',)
            ->orderBy('id','DESC')
            ->first();
    }else{
        $this->validate($request, [
            "academic_group_id" => "required",
            "academic_version_id" => "required",
            "academic_year_id" => "required",
            "academic_shift_id" => "required",
            "academic_class_id" => "required",
            "academic_result_primary_type_id" => "required",
            "student_roll_number" => "required",
        ]);


        $studentHistory=GlobalStudentHistory::with('site')
            ->where('site_id', $site_id)
            ->where('academic_group_id', $request->academic_group_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('student_roll_number', $request->student_roll_number)
            ->where('status', true)
            ->when($data['academic_class_group_id'], function($q) use ($request){
            $q->where('academic_class_group_id', $request->academic_class_group_id);
            })
            ->when($data['academic_section_id'], function($q) use ($request){
            $q->where('academic_section_id', $request->academic_section_id);
            })
            ->when($data['site_batch_detail_id'], function($q) use ($request){
            $q->where('site_batch_detail_id', $request->site_batch_detail_id);
            })
           // ->select('id','site_id','student_roll_number')
            ->orderBy('id','DESC')
            ->first();
        
        }
    }else{
        

            $site_group_id=Session::get('SITE_GROUP_ID');
      
           $resultSett = GlobalSiteGroupResultPrimarySettingStore::where([
                'site_group_id' => $site_group_id,
                'academic_group_id' => $request->academic_group_id,
                'academic_version_id' => $request->academic_version_id,
                'academic_year_id' => $request->academic_year_id,
                'academic_shift_id' => $request->academic_shift_id,
                'academic_class_id' => $request->academic_class_id,
                'academic_result_primary_type_id' => $request->academic_result_primary_type_id
            ])
            ->first();

           

            $examRolls = GlobalSiteGroupStudentExamRoll::where([
                    'site_group_id' => $site_group_id,
                    'academic_group_id' => $request->academic_group_id,
                    'examination_id' => $resultSett->examination_id,
                    'roll' => $request->student_roll_number,
                ])
                ->first();
         //   dd($examRolls);

           $studentHistory=GlobalStudentHistory::with('site')
            ->where('id', $examRolls->student_history_id)
            ->first();
           
    }
      
         
        if(!$studentHistory){
            return Response::json(['message'=>'Student not found', 'status'=>'404'],404);
    }

        $student_ids=[$studentHistory->id];
        $data['site_id']=$studentHistory->site_id;
        $data['academic_version_id']=$studentHistory->academic_version_id;
        $data['academic_year_id']=$studentHistory->academic_year_id;
        $data['academic_shift_id']=$studentHistory->academic_shift_id;
        $data['academic_class_id']=$studentHistory->academic_class_id;
        $data['academic_section_id']=$studentHistory->academic_section_id;
        $data['academic_class_group_id']=$studentHistory->academic_class_group_id;
        $data['academic_session_id']=$studentHistory->academic_session_id;
        $data['site_batch_detail_id']=$studentHistory->site_batch_detail_id;
        $data['academic_group_id']=$studentHistory->academic_group_id;

        
    
        $resultPdf=$this->studentResulDetailsPdf($data,$student_ids,'site_public');

        if($resultPdf['status']==200){

          
          //  return response()->download($resultPdf['full_path'], $resultPdf['file_name']);
         
            return Response::json([
                'link' => route('open-pdf-file-storage-for-public', [$resultPdf['file_name']]),
                'message' => 'Successfully Created Card Report',
                'status'=> $resultPdf['status']
            ],200);
        }else{
            return Response::json([
                'message' => 'Failed to Create Card Report',
                'status'=> $resultPdf['status']
            ],422);
        }
      
        
   }

   public function openReportForPublic($name)
   {
       try {
           if (!file_exists(storage_path('pdf/' . $name))) {
               return "The file existed only for 1 day and deleted today!";
           }
           return response()->file(storage_path('pdf/' . $name));

       } catch (Exception $exception) {
           return Response::json(['message' => $exception->getMessage()], 410);
       }
   }

}
