<?php

namespace App\Http\Controllers\SitePublic\Site;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Academic\AcademicPeriodType;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicSessionType;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Relation\Relation;
use App\Models\Site\Batch\BatchDetail;
use App\Models\Site\Employee\TeacherAssignToClassSection;
use App\Models\Site\SiteClassSessionSerialSetting;
use App\Models\Site\Fee\SiteStudentFeeSubHeadAllocation;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Models\SiteGroup\GlobalSiteGroupSetting;
use Illuminate\Support\Carbon;
use App\Models\Academic\AcademicGroup;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Student\StudentHistory;
use App\Models\User\GlobalUser;
use Exception;
use Illuminate\Support\Facades\Auth;
use Response;
use Session;

class SitePublicAcademicController extends Controller
{
    private $SiteShiftClassGroupSectionSetting;

    public function __construct(GlobalSiteShiftClassGroupSectionSetting $SiteShiftClassGroupSectionSetting)
    {
      
        $this->SiteShiftClassGroupSectionSetting = $SiteShiftClassGroupSectionSetting;
    }


    public function getAcademicGroupForSitePublic(Request $request){

      //  dd(Session::all());
        if(Session::get('USER_TYPE')=='site'){

            $get_acc_group_ids = GlobalSiteInfoSetting::whereSiteId($request->site_id)->pluck('academic_group_id');
            $site_id=$this->getSiteId($request);
            $get_acc_group_ids = GlobalSiteInfoSetting::whereSiteId($site_id)->pluck('academic_group_id');

            $the_site = GlobalSiteInfo::findOrFail($site_id);

            $site_academic_group = explode(',', $the_site->academic_group_ids);

            $acc_gr = AcademicGroup::whereIn('id', $get_acc_group_ids)
                ->whereIn('id', $site_academic_group)
                ->orderBy('serial')
                ->orderBy('id', 'ASC')
                ->get();


        }else{
           
            $site_group_id = Session::get('SITE_GROUP_ID');

            $get_acc_group_ids = GlobalSiteGroupSetting::where('site_group_id', $site_group_id)
                ->orderBy('serial')
                ->pluck('academic_group_id');

                $siteGroup=GlobalSiteGroup::where('id',$site_group_id)->first();

               // dd($get_acc_group_ids);

                $academic_group_ids=explode(',',$siteGroup->academic_group_ids);
                $acc_gr = [];
                if (count($get_acc_group_ids) && count($academic_group_ids)) {
                    $acc_gr = AcademicGroup::whereIn('id', $get_acc_group_ids)
                    ->whereIn('id',$academic_group_ids)
                    ->orderBy('serial')
                    ->orderBy('id', 'ASC')
                    ->get();
                   
                }


            // $get_acc_group_ids = GlobalSiteGroupSetting::whereSiteGroupId($site_group_id)->pluck('academic_group_id');
            // $acc_gr = AcademicGroup::whereIn('id', $get_acc_group_ids)
            //  //   ->whereIn('id', $site_academic_group)
            //     ->orderBy('serial')
            //     ->orderBy('id', 'ASC')
            //     ->get();
        }
       

        return $acc_gr;
    //   }
    }

    private function getSiteId($request){
         
        if(empty($request->site_id)){
            $domain = "";
            if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
                $getHost = explode(".", $_SERVER['HTTP_HOST']);
                $domain = array_shift($getHost);
            }
            $site_info = GlobalSiteInfo::where('site_alias', $domain)->first();
            if($site_info){
                 $site_id = $site_info->id;
                Session::put('SITE_ID', $site_id);
            }else{
                $site_id= null;
              //  Session::put('SITE_ID', null);
            }
           
        }else{
            Session::put('SITE_ID', $request->site_id);
            $site_id = $request->site_id;
        }
        return $site_id;
    }
    public function getVersionYearShiftDeptListForSitePublic(Request $request)
    {
        try {

            
        if(Session::get('USER_TYPE')=='site'){

            $site_id=$this->getSiteId($request);


            $the_site_info_setting = GlobalSiteInfoSetting::where('site_id', $site_id)
                ->where('academic_group_id', $request->academic_group_id)
                ->first();

            $the_site_info = GlobalSiteInfo::findOrFail($site_id);

            if (!$the_site_info_setting) {
                return Response::json(['message' => 'No "SiteInfoSetting" Found'], 422);
            }

            $academicShift = explode(',', $the_site_info_setting->shift_ids ?? null);
            $academicShiftList = AcademicShift::whereIn('id', $academicShift)
                ->get();

            $academicYear = explode(',', $the_site_info_setting->academic_year_ids ?? null);
            $academicYearList = AcademicYear::whereIn('id', $academicYear)->orderBy('serial_no', 'desc')->get();

         //   dd($academicYearList);

            $academicStudentCategory = explode(',', $the_site_info_setting->academic_student_category_ids ?? null);
            $academicStudentCategoryList = AcademicStudentCategory::whereIn('id', $academicStudentCategory)->get();


            $admissionlist = explode(',', $the_site_info_setting->academic_admission_type_ids ?? null);
            $admissionlistdata = AcademicAdmissionType::whereIn('id', $admissionlist)->get();


//            $academicDepartmentList = [];
//            $academicClassList = [];
//
//            if ($the_site_info_setting->academic_department_ids ?? null) {
//                $academicDepartment = explode(',', $the_site_info_setting->academic_department_ids ?? null) ?? null;
//                $academicDepartmentList = AcademicDepartment::select('id', 'name as department_name')
//                    ->whereIn('id', $academicDepartment)->get();
//            } else {
//                $academicClass = SiteShiftClassGroupSectionSetting::groupBy('academic_class_id')->pluck('academic_class_id')->toArray();//explode(',', $SiteInfoTableData->academic_class_ids) ?? [];
//                $academicClassList = AcademicClass::whereIn('id', $academicClass)
//                    ->orderBy('serial_no', 'ASC')
//                    ->get();
//            }
//
//            $academic_session_type_ids = explode(',', $the_site_info_setting->academic_session_type_ids ?? null);
//            $academicSessionTypeList = AcademicSessionType::whereIn('id', $academic_session_type_ids)
//                ->get();
//
//
//            $academic_period_type_ids = explode(',', $the_site_info->academic_period_type_ids ?? null);
//            $academicPeriodTypeList = AcademicPeriodType::whereIn('id', $academic_period_type_ids)
//                ->get();

            $academicVersionIDs = explode(',', $the_site_info_setting->academic_version_ids);
            $academicVersionList = AcademicVersion::whereIn('id', $academicVersionIDs)->get();

            $academicStudentTypeIDs = explode(',', $the_site_info_setting->academic_student_type_ids);
            $academicStudentTypeList = AcademicStudentType::whereIn('id', $academicStudentTypeIDs)->get();
            $Sessionlistsplite = explode(',', $the_site_info_setting->academic_session_ids);
            $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();
            $relationList = Relation::all();
        }else{
            $site_group_id = Session::get('SITE_GROUP_ID');

            $the_site_group_setting = GlobalSiteGroupSetting::where('site_group_id', $site_group_id)
                ->where('academic_group_id', $request->academic_group_id)
                ->first();

            if (!$the_site_group_setting) {
                return Response::json(['message' => 'No "SiteGroupSetting" Found'], 422);
            }

            $academicShift = explode(',', $the_site_group_setting->shift_ids ?? null);
            $academicShiftList = AcademicShift::whereIn('id', $academicShift)
                ->get();

            $academicYear = explode(',', $the_site_group_setting->academic_year_ids ?? null);
            $academicYearList = AcademicYear::whereIn('id', $academicYear)->where('id',13)->orderBy('serial_no', 'desc')->get();

            $academicStudentCategory = explode(',', $the_site_group_setting->academic_student_category_ids ?? null);
            $academicStudentCategoryList = AcademicStudentCategory::whereIn('id', $academicStudentCategory)->get();
            $academicVersionList = AcademicVersion::whereIn('id', explode(',', $the_site_group_setting->academic_version_ids))->get();
            $admissionlist = explode(',', $the_site_group_setting->academic_admission_type_ids ?? null);
            $admissionlistdata = [];
        }
            

//         return $academicVersionList;


            return [
                $academicVersionList,
                $academicYearList,
                $academicShiftList,
                $admissionlistdata,
                $academicStudentCategoryList,

            ];
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }

    }

    public function getStudentHistoryList(Request $request){

        if($request->student_username){
            $site_id=$this->getSiteId($request);
            $user=GlobalUser::where('username',$request->student_username)->where('site_id',$site_id)->where('status',true)->first();

            if (!$user) {
                return Response::json(['message' => 'Student Not Found!'], 411);
            }

            $student_histories=GlobalStudentHistory::where('user_id',$user->id)
                ->with(['department','stClass', 'shift', 'classGroup', 'section', 'session'])
                 ->select('id', 'user_id', 'student_roll_number', 'student_roll_number_prefix', 'academic_department_id', 'academic_class_id', 'academic_shift_id',
                     'academic_class_group_id', 'academic_section_id', 'academic_session_id')
                ->get();

            $student_history_array=[];
            foreach($student_histories as $key=>$history){
                $student_history_array[$key]['id']=$history->id;
                $student_history_array[$key]['class_id']=$history->stClass?$history->stClass->id:null;
                $student_history_array[$key]['class_name']=$history->stClass?$history->stClass->class_name:'';
                $student_history_array[$key]['group_id']=$history->classGroup?$history->classGroup->id:null;
                $student_history_array[$key]['group_name']=$history->classGroup?$history->classGroup->group_name:'';
                $student_history_array[$key]['session_id']=$history->session?$history->session->id:null;
                $student_history_array[$key]['session_name']=$history->session?$history->session->session_name:'';
                $student_history_array[$key]['section_id']=$history->section?$history->section->id:null;
                $student_history_array[$key]['section_name']=$history->section?$history->section->section_name:'';
                $student_history_array[$key]['roll']=$history->student_full_roll_number;

            }


         return $student_history_array;

        }
    }

    public function getYearVersionAndShiftBasedDepartmentClassForSitePublic(Request $request)
    {
       
        if(Session::get('USER_TYPE')=='site'){

        $site_id=$this->getSiteId($request);

        
        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;


        if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id']) {
            return Response::json(['message' => 'Select Version, Year And Shift For Class List'], 411);
        }

        $academic_class_list = [];
        $academic_department_list = [];


        $SiteInfoTableData = GlobalSiteInfoSetting::where('site_id', $site_id)
            ->where('academic_group_id', $request->academic_group_id)
            ->select('academic_class_ids')
            ->first();


        $academicClassIds = explode(',', $SiteInfoTableData->academic_class_ids);

        $academicDepartment = $this->SiteShiftClassGroupSectionSetting
            ->where('site_id', $site_id)
            ->where('academic_group_id', $request->academic_group_id)
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->whereNotNull('academic_department_id')
//            ->groupBy('academic_department_id', 'academic_class_id')
            //   ->get()
            ->pluck('academic_department_id')
            ->unique()
            ->filter()
            ->toArray();

        // dd($academicDepartment);


        if (count($academicDepartment) > 0) {
            $academic_department_list = AcademicDepartment::whereIn('id', $academicDepartment)
                ->get();
        } else {

//test
            $plucked_class_ids = $this->SiteShiftClassGroupSectionSetting
                ->where('site_id', $site_id)
                ->where('academic_group_id', $request->academic_group_id)
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->whereIn('academic_class_id', $academicClassIds)
//                ->groupBy('academic_class_id')
                ->pluck('academic_class_id')
                ->unique()
                ->filter()
                ->toArray();

            if (count($plucked_class_ids) == 0) {
                return Response::json(['message' => 'No Class Found For The Year! Go: <a target="_blank" href="' . route('site-shift-class-group-section-setting-opening-page') . '">Click</a>'], 411);

            }


            $academic_class_list = AcademicClass::whereIn('id', $plucked_class_ids)
                ->orderBy('serial_no', 'ASC')
                ->get();
        }


        $countDepartment = count($academic_department_list);

    }else{

        $site_group_id = Session::get('SITE_GROUP_ID');
     
        $the_site_group_setting = GlobalSiteGroupSetting::where('site_group_id', $site_group_id)
                ->where('academic_group_id', $request->academic_group_id)
                ->first();

        $academic_class_list = AcademicClass::whereIn('id', explode(',',$the_site_group_setting->academic_class_ids))
                ->orderBy('serial_no', 'ASC')
                ->get();
        $academic_department_list = [];
        $countDepartment = count($academic_department_list);

    }
        

        return [$academic_class_list, $academic_department_list, $countDepartment];
    }

}
