<?php

namespace App\Http\Controllers\Student;

use App\Forms\DataHelper;
use App\Forms\FormControll;
use App\Forms\StudentForm;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Mail\SendMailToUserWithQueue;
use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicOccupation;
use App\Models\Academic\AcademicResidence;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicStudentQuata;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicSubjectClassExamCondition;
use App\Models\Academic\AcademicVersion;
use App\Models\Academic\SubjectCondition;
use App\Models\AcademicYear\AcademicYear;
use App\Models\AddFieldTable\AddFieldToTable;
use App\Models\Attendance\StudentAttendance;
use App\Models\BloodGroup\BloodGroup;
use App\Models\Department\Department;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Gender\Gender;
use App\Models\Relation\Relation;
use App\Models\Religion\Religion;
use App\Models\Site\Exam\SiteExamDeclareStudent;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Site\Role\SiteRole;
use App\Models\Site\SiteClassSessionSerialSetting;
use App\Models\Site\GlobalSiteClassSessionSerialSetting;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\Student\Student;
use App\Models\Student\Section;
use App\Models\Student\StudentClass;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SiteSubjectConditionLimit;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Models\User\User;
use App\Models\User\UserForUsername;
use App\Models\Site\SiteInfo;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Site\Result\SiteIndividualCombineSubjectResultStore;


use App\Traits\Site\UserPermission\UserAccessTrait;
use Auth;
use Carbon\Carbon;
use Error;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Requests;
use Illuminate\Support\Facades\Log;
use Illuminate\Validation\ValidationException;
use Image;
use App\Models\Image\Photo;
use App\Models\Media\Media;
use App\Models\Examinations\Examination;
use DB;
use Response;
use Session;
use View;

class StudentController extends ProjectController
{
    use Lang, FormControll, DataHelper, UserAccessTrait;

    private $student;
    private $studentHistory;
    private $fileName;
    private $extension;
    private $studentAttendance;

    /**
     * StudentController constructor.
     * @param User $student
     */
    public function __construct(Student $student, StudentHistory $studentHistory, StudentAttendance $studentAttendance)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->student = $student;
        $this->studentHistory = $studentHistory;
        $this->studentAttendance = $studentAttendance;
    }

    public function index()
    {

        $viewType = 'Student List';
        return view('default.admin.students.index', compact('viewType'));
    }

    public function createStudentForm()
    {

        $viewType = 'Create Student';
        return view('default.admin.layouts.master', compact('viewType'));

        //return view('default.admin.students.create', compact('viewType'));
    }

    /**
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function viewStudent(Request $request, $history_id)
    {
      //  dd('sfsf');

        try {

            if ($request->ajax()) {
                $student_history = $this->studentHistory->with(['student'=>function($q){
                    return $q->with('fatherOccupation','motherOccupation');
                },'year'])
                ->findOrFail($history_id);

                //dd($student_history->student->religion);

                $history = [];

                $history['id'] = $student_history->id;
                $history['username'] = $student_history->student->username;
                $history['email'] = $student_history->student->email ?? 'Not Found';
                $history['contact_number'] = $student_history->student->contact_number ?? 'Not Found';
                $history['emergency_contact'] = $student_history->student->emergency_contact ?? 'Not Found';
                $history['full_name'] = $student_history->full_name;
                $history['guardian_full_name'] = $student_history->student->guardian->full_name ?? 'Not Found';
                $history['guardian_emergency_contact'] = $student_history->student->guardian->guardian_emergency_contact ?? 'Not Found';
                $history['father_name'] = $student_history->student->father_name ?? 'Not Found';
                $history['father_contact_number'] = $student_history->student->father_contact_number ?? 'Not Found';
                $history['father_nid'] = $student_history->student->father_nid ?? 'n/a';
                $history['father_bcn'] = $student_history->student->father_bcn ?? 'n/a';
                $history['father_occupation'] = $student_history->student->fatherOccupation?$student_history->student->fatherOccupation->occupation_name : 'Not Found';
                $history['mother_name'] = $student_history->student->mother_name ?? 'Not Found';
                $history['mother_contact_number'] = $student_history->student->mother_contact_number ?? 'Not Found';
                $history['mother_nid'] = $student_history->student->mother_nid ?? 'n/a';
                $history['mother_bcn'] = $student_history->student->mother_bcn ?? 'n/a';
                $history['mother_occupation'] = $student_history->student->motherOccupation?$student_history->student->motherOccupation->occupation_name : 'Not Found';
                $history['student_roll_number'] = $student_history->student_roll_number ?? 'Not Found';
                $history['pic_path'] = $student_history->student->latestPhoto? '/uploads/' . $student_history->student->latestPhoto->name:'';
                $history['year'] = $student_history->year->year_name ?? 'Not Found';
                $history['class_name'] = $student_history->stClass->class_name ?? 'Not Found';
                $history['department_name'] = $student_history->department->name ?? 'n/a';
                $history['dept_join_date'] = $student_history->student->dept_join_date ?? 'n/a';
                $history['address'] = $student_history->student->address ?? 'n/a';
                $history['gender_name'] = $student_history->student->gender?$student_history->student->gender->gender_name:'n/a';
                $history['religion_name'] = $student_history->student->religion?$student_history->student->religion->name:'n/a';
                $history['nid_number'] = $student_history->student->nid_number ?? 'n/a';
                $history['passport_no'] = $student_history->student->passport_no ?? 'n/a';
                $history['birth_certificate_no'] = $student_history->student->birth_certificate_no ?? 'n/a';

                return response()->json($history, 200);
            }

            $viewType = 'View Student';
            return view('default.admin.layouts.master', compact('viewType'));

            return view('default.admin.students.view', compact('student_history', 'viewType'));
        } catch (Exception $e) {
            return response()->json($e->getMessage(), 200);
        }
    }
    public function getStudentHistoryForDetails($student_history_id){

        $student_history = $this->studentHistory
                ->findOrFail($student_history_id);

            return response()->json($student_history, 200);
    }

    public function getStudentAcademicYearList(Request $request){
        $student_history = $this->studentHistory
        ->findOrFail($request->student_history_id);

        $academic_year_ids = $this->studentHistory->where('user_id', $student_history->user_id)->pluck('academic_year_id');
        $year_list=AcademicYear::whereIn('id',$academic_year_ids)
                ->select('id','year_name','serial_no')
                ->orderBy('id','DESC')
                ->get();

        return $year_list;
    }

    public function getStudentAttendance(Request $request){

        $data=$request->all();
        $first_date=$data['att_date']['start'];
        $last_date=$data['att_date']['end'];

        $user_Attendance = $this->studentAttendance
            ->whereBetween('present_date', [$first_date, $last_date])
            ->where('student_history_id', $data['student_history_id'])
            ->get();

        return response()->json($user_Attendance, 200);

    }

    public function getStudentExamResultList(Request $request){
        $student_history = $this->studentHistory
            ->findOrFail($request->student_history_id);

        $history = $this->studentHistory->where('user_id', $student_history->user_id)
                    ->where('academic_year_id',$request->academic_year_id)
                    ->first();

            $primary_exam_type_ids=SiteStudentPrimaryResultDetail::where('student_history_id', $history->id)
            ->pluck('academic_result_primary_type_id')
            ->unique()
            ->filter();

            $result_primary_type_list=AcademicResultPrimaryType::whereIn('id', $primary_exam_type_ids)
                    ->orderBy('id', 'DESC')
                    ->get(['id', 'name']);

        return [$result_primary_type_list, $history->id];

    }

    public function getStudentExamResultDetails(Request $request){
      //  dd($request->all());
        $dataaa=SiteStudentPrimaryResultDetail::with(['studentHistory'=>function($q){
            $q->with('shift','stClass','year','accGroup','section','department','session');
        }],'academicResultPrimaryType')
            ->where('student_history_id', $request->student_history_id)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('status', true)
            ->get();


            $a_arr=Array();
            $a_array=[];
            foreach ($dataaa as $key => $value){

                $b_array=[];
                foreach ($value->site_individual_combine_subject_result_store_ids as $keyt => $valuet){

                    $b_array[]=$valuet->subject_detail;
                }
              //  return $b_array;

                $subject_ids=collect($b_array)->pluck('exam_dependent_academic_subject_id')->unique();
                $result_show_in_table_bellow_status_present=collect($b_array)->pluck('result_show_in_table_bellow_status')->unique()->filter();

                $a_arr['academic_result_primary_type_id']=$value->academic_result_primary_type_id;
                $a_arr['result_type_name']=$value->academicResultPrimaryType->name;
                $a_arr['student_history_id']=$value->student_history_id;
                $a_arr['fail_subject_count']=$value->fail_subject_count;
                $a_arr['gpa']=$value->gpa;
                $a_arr['grade']=$value->grade;
                $a_arr['student_rank']=$value->student_rank;
                $a_arr['site_result_primary_setting_id']=$value->site_result_primary_setting_id;
                $a_arr['academic_result_primary_type_id']=$value->academic_result_primary_type_id;
                $a_arr['subject_list']=$b_array;
                $a_arr['table_header']=$value->table_header;
                $a_arr['student_history']=$value->studentHistory;

                $a_arr['student_photo']=$value->studentHistory->student->latestPhoto?
                    $value->studentHistory->student->latestPhoto->name:'image-not.png';

                $a_arr['result_show_in_table_bellow_status_present']=count($result_show_in_table_bellow_status_present)>0?1:0;

                $a_arr['result_type_name']=$value->academicResultPrimaryType->name;
                $a_arr['result_type_id']=$value->academicResultPrimaryType->id;

                $a_arr['classtest_is_present']=$value->classtest_is_present;
                $a_arr['combine_subject_present']=$value->combine_subject_present;
                $a_arr['final_grade_without_optional']=$value->final_grade_without_optional;
                $a_arr['final_point_without_optional']=$value->final_point_without_optional;
                $a_arr['id']=$value->id;
                $a_arr['raw_obtain_marks_percentage']=number_format((float)$value->raw_obtain_marks_percentage, 2, '.', '');
                $a_arr['sum_of_obtain_percent_total_marks']=$value->sum_of_obtain_percent_total_marks;
                $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;
                $a_arr['sum_of_raw_total_marks']=$value->sum_of_raw_total_marks;
                $a_arr['sum_of_obtain_total_marks_for_show']=$value->sum_of_obtain_total_marks_for_show;
                $a_arr['sum_of_obtain_total_percent_for_show']=$value->sum_of_obtain_total_percent_for_show;

                $a_arr['academic_days']=$value->academic_days;
                $a_arr['present_days']=$value->present_days;
                $a_arr['absent_days']=$value->absent_days;
                $a_arr['behaviour']=$value->behaviour;
                $a_arr['cultural_activities']=$value->cultural_activities;
                $a_arr['bncc']=$value->bncc;
                $a_arr['debate']=$value->bncc;
                $a_arr['scout']=$value->scout;
                $a_arr['sports']=$value->sports;
                $a_arr['others']=$value->others;

                $a_array[$key]=array_merge($a_arr);

            }
            return $a_array;

    }

    public function getStudentSubjectDetails(Request $request){
        $student_history = $this->studentHistory->with('religionSubject')->select('id','academic_subject_ids','compulsory_subject_ids',
            'optional_subject_ids','selective_compulsory_subject_ids','religion_subject_id','selective_markingless_subject_ids')
            ->findOrFail($request->student_history_id);

            $s_history=[];
            $s_history['id']=$student_history->id;
            $s_history['academic_subject']=$student_history->academic_subject_ids[0];
            $s_history['compulsory_subject']=$student_history->compulsory_subject_ids[0];
            $s_history['optional_subject']=$student_history->optional_subject_ids[0];
            $s_history['selective_compulsory_subject']=$student_history->selective_compulsory_subject_ids[0];
            $s_history['selective_markingless_subject']=$student_history->selective_markingless_subject_ids[0];
            $s_history['religion_subject']=$student_history->religionSubject?$student_history->religionSubject:null;

            return $s_history;

    }

    public function getStudentBySearch(Request $request)
    {


        $search_txt = $request->search_txt;

        $txt = '%' . $search_txt . '%';
        $status = $request->status ?? 1;

        $students = $this->student
            ->where('status', $status)
            ->when($search_txt, function ($q) use ($txt) {
                return $q->where(function ($query) use ($txt) {
                    $query->where('user_type', 'student')
                        ->where('username', 'LIKE', $txt)
                        ->orWhere('email', 'LIKE', $txt)
                        ->orWhere('contact_number', 'LIKE', $txt)
                        ->orWhereTranslationLike('first_name', $txt)
                        ->orWhereTranslationLike('last_name', $txt);
                })->orderByTranslation('first_name', 'ASC');
            })
            ->get()->map(function ($val) {
                return [
                    'id' => $val->id,
                    'full_name' => $val->full_name ?? '',
                    'username' => $val->username ?? '',
                    'img' => '/uploads/' . $val->latestPhoto->name ?? ''
                ];
            });

        return $students;
    }

    public function getStudentListForAttendanceReport(Request $request){

        $data=$request->all();

        $st_att_list = $this->studentHistory
        // ->when($data['st_id'], function ($query) use ($data) {
        //     $query->where('user_id', $data['st_id']);
        // })
        ->when($data['academic_version_id'], function ($query) use ($data) {
            return $query->where('academic_version_id', $data['academic_version_id']);
        })->when($data['academic_year_id'], function ($query) use ($data) {
            return $query->where('academic_year_id', $data['academic_year_id']);
        })->when($data['academic_shift_id'], function ($query) use ($data) {
            return $query->where('academic_shift_id', $data['academic_shift_id']);
        })->when($data['academic_class_id'], function ($query) use ($data) {
            return $query->where('academic_class_id', $data['academic_class_id']);
        })->when($data['academic_department_id'], function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })->when($data['academic_section_id'], function ($query) use ($data) {
            return $query->where('academic_section_id', $data['academic_section_id']);
        })->when($data['academic_class_group_id'], function ($query) use ($data) {
            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
        })->when($data['academic_session_id'], function ($query) use ($data) {
            return $query->where('academic_session_id', $data['academic_session_id']);
        })->when($data['site_batch_detail_id'], function ($query) use ($data) {
            return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
        })
        ->orderBy('student_roll_number', 'ASC')
        ->orderBy('academic_section_id', 'ASC')
        ->orderBy('academic_class_id', 'ASC')
        ->where('status', $data['status'])
        // ->with(['attendances' => function ($q) use ($start, $end) {
        //     $q->whereBetween('present_date', [$start, $end]);
        // }])
        ->select('id', 'user_id', 'student_roll_number')
        ->get();

       // return response($st_att_list);

        return $st_att_list;

    }


    public function getStudentHistoryBySearch(Request $request)
    {


        $search_txt = $request->search_txt;

        $txt = '%' . $search_txt . '%';

        $students = $this->studentHistory
            ->where('status', 1)
            ->when($search_txt, function ($q) use ($txt) {
                return $q->whereHas('student', function ($q1) use ($txt) {
                    $q1->where(function ($query) use ($txt) {
                        $query->where('user_type', 'student')
                            ->where('username', 'LIKE', $txt)
                            ->orWhere('email', 'LIKE', $txt)
                            ->orWhere('contact_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('first_name', $txt)
                            ->orWhereTranslationLike('last_name', $txt);
                    })->orderByTranslation('first_name', 'ASC');
                });

            })
            ->get()->map(function ($val) {
                return [
                    'id' => $val->id,
                    'full_name' => $val->full_name ?? '',
                    'details' => ($val->department->name ?? '') . '' . ($val->stClass->class_name ?? '') . '' . ($val->section->section_name ?? '') . '' . ($val->classGroup->group_name ?? ''),
                    'username' => $val->student->username ?? '',
                    'img' => $val->student->latestPhoto->path ?? ''
                ];
            });

        return $students;
    }


    public function getStudentDataBySearchWithPaginaton(Request $request)
    {


        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
        $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
        $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;


        $search_txt = $request->search_txt;
        $status = $request->status;
        $paginate = $request->paginate ?? 20;
        $txt = '%' . $search_txt . '%';


        $st_att_list = $this->studentHistory
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })->when(!empty($data['site_batch_detail_id']), function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when($search_txt, function ($qu) use ($txt) {
                $qu->whereHas('student', function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('username', 'LIKE', $txt)
                            ->orWhere('email', 'LIKE', $txt)
                            ->orWhere('contact_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('first_name', $txt)
                            ->orWhereTranslationLike('last_name', $txt);
                    });
                });
            })
            ->where('status', $status)
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('student_roll_number', 'ASC')
            ->paginate($paginate);

        $st_att_list->getCollection()->transform(function ($st_history) {

            return [

                'user_id' => $st_history->student->id ?? 0,
                'history_id' => $st_history->id ?? 0,
                'sms_sending' => false,

                'username' => $st_history->student->username ?? '',
                'student_roll_number' => $st_history->student_full_roll_number ?? '',
                'contact_number' => $st_history->student->contact_number ?? '',
                'full_name' => ($st_history->student->full_name ?? ''),

                'year_name' => $st_history->year->year_name ?? '',
                'version_name' => $st_history->version->version_name ?? '',
                'shift_name' => $st_history->shift->shift_name ?? '',

                'details' => ($st_history->department->name ?? '') . ($st_history->stClass->class_name ?? '') . ($st_history->section->section_name ?? '') . ($st_history->classGroup->group_name ?? ''),
                'dept_name' => $st_history->department->name ?? '',
                'class_name' => $st_history->stClass->class_name ?? '',
                'class_group' => $st_history->classGroup->group_name ?? '',
                'section_name' => $st_history->section->section_name ?? '',
                'session_name' => $st_history->session->session_name ?? '',

                'site_id' => $st_history->site_id ?? null,
            ];

        });

        if (count($st_att_list) < 1) {
            return response()->json('No Student Found!', 410);

        }
        return response()->json($st_att_list, 200);
    }


    /**
     * @param $classid
     * @param $groupid
     * @return mixed
     */
    public function getSiteYearShiftClassSessionVersionConditionList()
    {

        $SiteInfoTableData = SiteInfoSetting::first();
        if (!$SiteInfoTableData) {
            return Response::json(['message' => 'No "SiteInfoSetting" Found'], 422);
        }

        $siteGroupShift = GlobalSiteShiftClassGroupSectionSetting::where('site_id', Session::get('SITE_ID'))
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
        //    ->whereIn('academic_shift_id', explode(',', $SiteInfoTableData->shift_ids))
            ->pluck('academic_shift_id')
            ->unique();
        $academicShiftList = AcademicShift::whereIn('id', $siteGroupShift)->get();

        $academicYear = explode(',', $SiteInfoTableData->academic_year_ids ?? null);
        $academicYearList = AcademicYear::whereIn('id', $academicYear)->orderBy('id', 'desc')->get();


        $academicVersionIDs = explode(',', $SiteInfoTableData->academic_version_ids);
        $academicVersionList = AcademicVersion::whereIn('id', $academicVersionIDs)->get();


        $academicAdmissionTypeIDs = explode(',', $SiteInfoTableData->academic_admission_type_ids);
        $admissionlistdata = AcademicAdmissionType::whereIn('id', $academicAdmissionTypeIDs)
            ->where('status', 1)
            ->get();


        $academicStudentTypeIDs = explode(',', $SiteInfoTableData->academic_student_type_ids);
        $academicStudentTypeList = AcademicStudentType::whereIn('id', $academicStudentTypeIDs)->get();
        //        $Sessionlistsplite = explode(',', $SiteInfoTableData->academic_session_ids);
        //        $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();
        $relationList = Relation::all();
        $academicKey = Session::get('ACADEMIC_KEY');

        return [
            $academicVersionList,
            $academicYearList,
            $academicShiftList,
            //            $academicClassList,
            //            $Sessionlist,
            $admissionlistdata,
            $academicStudentTypeList,
            $relationList,
            $academicKey,
            //            $academicDepartmentList
        ];
    }


    public function getGenderReligionBloodStudentCategoryQuata()
    {

        $siteInfoSettinglist = SiteInfoSetting::first();


        $genderlistsplite = explode(',', $siteInfoSettinglist->gender_ids);
        $genderlist = Gender::whereIn('id', $genderlistsplite)->get();


        $religionlistsplite = explode(',', $siteInfoSettinglist->religion_ids);
        $religionlist = Religion::whereIn('id', $religionlistsplite)->get();


        $bloodlist = BloodGroup::get();

        $studentCategorylistsplite = explode(',', $siteInfoSettinglist->academic_student_category_ids);
        $studentCategorylist = AcademicStudentCategory::whereIn('id', $studentCategorylistsplite)->get();


        $StudentQuatalistdata = AcademicStudentQuata::where('status', 1)->get();

        $Occupationlistdata = AcademicOccupation::where('status', 1)->get();


        $residencelistsplite = explode(',', $siteInfoSettinglist->academic_residence_ids);
        $residencelist = AcademicResidence::whereIn('id', $residencelistsplite)->get();

        return [
            $genderlist, $religionlist, $bloodlist, $studentCategorylist,
            $StudentQuatalistdata, $Occupationlistdata, $residencelist
        ];
    }

    /**
     * @param $class_id
     * @param $shift_id
     * @param $class_group_id
     * @return int
     */
    public function siteClassBaseSection($class_id, $shift_id, $class_group_id, $year_id, $version_id)
    {
      //  dd('ss');

        $groupPresentCount = SiteShiftClassGroupSectionSetting::select('academic_class_group_id')
            ->where('academic_version_id', $version_id)
            ->where('academic_year_id', $year_id)
            ->where('academic_class_id', $class_id)
            ->whereNotNull('academic_class_group_id')
//            ->get()
            ->count();


        $sessionPresentCheck = SiteClassSessionSerialSetting::where('academic_class_id', $class_id)->first();

        if ($sessionPresentCheck) {
            if ($sessionPresentCheck->session_present) {
                $SiteInfoTableData = SiteInfoSetting::first();
                $Sessionlistsplite = explode(',', $SiteInfoTableData->academic_session_ids);
                $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();
            } else {
                $Sessionlist = [];
            }
        } else {
            $Sessionlist = [];
        }

        if (!$groupPresentCount) {

            $SiteClassBaseSectionCount = SiteShiftClassGroupSectionSetting::select('academic_shift_id')
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_class_id', $class_id)
//                ->get()
                ->count();


            if (!$shift_id && $SiteClassBaseSectionCount > 1) {
                return 4001;
            } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
                $SiteClassBaseSection = SiteShiftClassGroupSectionSetting::select('academic_section_ids')
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_class_id', $class_id)
                    ->first();


            } else if ($shift_id && $class_id) {

                $SiteClassBaseSection = SiteShiftClassGroupSectionSetting::select('academic_section_ids')
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_shift_id', $shift_id)
                    ->first();

            }
        } else {
            if (!$shift_id && !$class_group_id) {
                return 4001;
            } else if ($shift_id && !$class_group_id) {
                $SiteGroup = SiteShiftClassGroupSectionSetting::select('academic_class_group_id')
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_shift_id', $shift_id)
                    ->get();


                $sectionDataList = AcademicClassGroup::select('id', 'group_name')
                    ->whereIn('id', $SiteGroup)
                    ->get();


                return [2001, $sectionDataList, $Sessionlist];
            } else {
                $SiteClassBaseSectionCount = SiteShiftClassGroupSectionSetting::select('academic_shift_id')
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_class_group_id', $class_group_id)
                    ->get()
                    ->count();


                if (!$shift_id && $SiteClassBaseSectionCount > 1) {
                    return 4001;
                } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
                    $SiteClassBaseSection = SiteShiftClassGroupSectionSetting::select('academic_section_ids')
                        ->where('academic_version_id', $version_id)
                        ->where('academic_year_id', $year_id)
                        ->where('academic_class_id', $class_id)
                        ->where('academic_class_group_id', $class_group_id)
                        ->first();
                } else if ($shift_id && $class_id) {


                    $SiteClassBaseSection = SiteShiftClassGroupSectionSetting::select('academic_section_ids')
                        ->where('academic_version_id', $version_id)
                        ->where('academic_year_id', $year_id)
                        ->where('academic_class_id', $class_id)
                        ->where('academic_shift_id', $shift_id)
                        ->where('academic_class_group_id', $class_group_id)
                        ->first();
                }
            }
        }



        $SectionData = explode(',', $SiteClassBaseSection->academic_section_ids ?? null);

        $SectionDataList = AcademicSection::select('id', 'section_name')
            ->whereIn('id', $SectionData)
            ->get();




        return [$SectionDataList, $Sessionlist];
    }

    public function siteGlobalClassBaseSection($academic_group_id,$class_id, $shift_id, $class_group_id, $year_id, $version_id)
    {
      //  dd('ss');

        $groupPresentCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_class_group_id')
            ->where('site_id', Session::get('SITE_ID'))
            ->where('academic_group_id', $academic_group_id)
            ->where('academic_version_id', $version_id)
            ->where('academic_year_id', $year_id)
            ->where('academic_class_id', $class_id)
            ->whereNotNull('academic_class_group_id')
//            ->get()
            ->count();


        $sessionPresentCheck = GlobalSiteClassSessionSerialSetting::where('site_id', Session::get('SITE_ID'))
            ->where('academic_group_id', $academic_group_id)
            ->where('academic_class_id', $class_id)
            ->first();

        if ($sessionPresentCheck) {
            if ($sessionPresentCheck->session_present) {
                $SiteInfoTableData = GlobalSiteInfoSetting::where('site_id', Session::get('SITE_ID'))
                    ->where('academic_group_id', $academic_group_id)
                    ->first();

                $Sessionlistsplite = explode(',', $SiteInfoTableData->academic_session_ids);
                $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();
            } else {
                $Sessionlist = [];
            }
        } else {
            $Sessionlist = [];
        }

        if (!$groupPresentCount) {

            $SiteClassBaseSectionCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_shift_id')
                ->where('site_id', Session::get('SITE_ID'))
                ->where('academic_group_id', $academic_group_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_class_id', $class_id)
//                ->get()
                ->count();


            if (!$shift_id && $SiteClassBaseSectionCount > 1) {
                return 4001;
            } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
                $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                    ->where('site_id', Session::get('SITE_ID'))
                    ->where('academic_group_id', $academic_group_id)
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_class_id', $class_id)
                    ->first();


            } else if ($shift_id && $class_id) {

                $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                    ->where('site_id', Session::get('SITE_ID'))
                    ->where('academic_group_id', $academic_group_id)
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_shift_id', $shift_id)
                    ->first();

            }
        } else {
            if (!$shift_id && !$class_group_id) {
                return 4001;
            } else if ($shift_id && !$class_group_id) {
                $SiteGroup = GlobalSiteShiftClassGroupSectionSetting::select('academic_class_group_id')
                    ->where('site_id', Session::get('SITE_ID'))
                    ->where('academic_group_id', $academic_group_id)
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_shift_id', $shift_id)
                    ->get();


                $sectionDataList = AcademicClassGroup::select('id', 'group_name')
                    ->whereIn('id', $SiteGroup)
                    ->get();


                return [2001, $sectionDataList, $Sessionlist];
            } else {
                $SiteClassBaseSectionCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_shift_id')
                    ->where('site_id', Session::get('SITE_ID'))
                    ->where('academic_group_id', $academic_group_id)
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_class_group_id', $class_group_id)
                    ->get()
                    ->count();


                if (!$shift_id && $SiteClassBaseSectionCount > 1) {
                    return 4001;
                } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
                    $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                        ->where('site_id', Session::get('SITE_ID'))
                        ->where('academic_group_id', $academic_group_id)
                        ->where('academic_version_id', $version_id)
                        ->where('academic_year_id', $year_id)
                        ->where('academic_class_id', $class_id)
                        ->where('academic_class_group_id', $class_group_id)
                        ->first();
                } else if ($shift_id && $class_id) {


                    $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                        ->where('site_id', Session::get('SITE_ID'))
                        ->where('academic_group_id', $academic_group_id)
                        ->where('academic_version_id', $version_id)
                        ->where('academic_year_id', $year_id)
                        ->where('academic_class_id', $class_id)
                        ->where('academic_shift_id', $shift_id)
                        ->where('academic_class_group_id', $class_group_id)
                        ->first();
                }
            }
        }



        $SectionData = explode(',', $SiteClassBaseSection->academic_section_ids ?? null);

        $SectionDataList = AcademicSection::select('id', 'section_name')
            ->whereIn('id', $SectionData)
            ->get();




        return [$SectionDataList, $Sessionlist];
    }


    public function sectionCategoryTypeAdmissionType(Request $requests)
    {


        $data = $requests->all();

        $studentList = StudentHistory::select('id', 'user_id', 'student_roll_number', 'student_roll_number_prefix')
            ->with(['student' => function ($query) {
                $query->select('id');
                $query->where('user_type', 'student');
            }])
            ->where('academic_version_id', $requests->academic_version_id)
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['site_batch_detail_id']), function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->get();


        //
        //        $std_arr=Array();
        //        $std_array=[];
        //        foreach ($studentList as $key => $value) {
        //
        //
        //            $std_arr['id']=$value->id;
        //            $std_arr['full_name']=$value->student->first_name + ' ' + $value->student->last_name;
        //
        //            $std_array[$key]=array_merge($std_arr);
        //        }

        return $studentList;
    }


    public function getStudentDetailForEdit($student_history_id)
    {
       // dd($student_history_id);

        $studentHistoryDetail = StudentHistory::where('id', $student_history_id)
            ->where('status', true)
            ->first();


        $studentDetail = $this->student
            ->with(['latestPhoto'])
            ->where('id', $studentHistoryDetail->user_id)
            ->select(
                'id',
                'local_guardian_user_id',
                'birth_certificate_no',
                'blood_group_id',
                'contact_number',
                'date_of_birth',
                'email',
                'emergency_contact',
                'gender_id',
                'guardian_student_relation_id',
                'last_academic_group_id',
                'name_native_language',
                'nationality',
                'nid_number',
               // 'student_roll_number',
                'father_contact_number',
                'father_nid',
                'father_bcn',
                'father_email',
                'father_occupation_id',
                'father_yearly_income',
                'mother_contact_number',
                'mother_nid',
                'mother_bcn',
                'mother_email',
                'mother_occupation_id',
                'mother_yearly_income',
                'passport_no',
                'permanent_country_id',
                'permanent_district_id',
                'permanent_division_id',
                'permanent_thana_id',
                'phone',
                'present_country_id',
                'present_district_id',
                'present_division_id',
                'present_thana_id',
                'religion_id',
                'student_registration_number'
            )
                    //    ->makeHidden(['academic_subject_ids', 'optional_subject_ids', 'compulsory_subject_ids',
                    //       'getStudentDetailForEdit', 'selective_markingless_subject_ids', 'general_markingless_subject_ids'])
            ->first();
           // dd($studentDetail);

        $guardianPanel = [];
        if ($studentDetail->local_guardian_user_id) {
            $guardianDetail = User::where('id', $studentDetail->local_guardian_user_id)->first();

            $guardianPanel['local_gurdian_name'] = $guardianDetail->first_name ?? '';
            $guardianPanel['local_gurdian_mobile'] = $guardianDetail->contact_number ?? '';
            $guardianPanel['local_gurdian_address'] = $guardianDetail->address ?? '';
            $guardianPanel['local_gurdian_email'] = $guardianDetail->email ?? '';
            $guardianPanel['relation_id'] = $guardianDetail->guardian_student_relation_id ?? '';
        }

        $guardianPanel['student_history_id'] = $studentHistoryDetail->id;

        //=== subject limit
        $dept_id = $studentHistoryDetail->academic_department_id;
            $limit_list = SiteSubjectConditionLimit::where('academic_class_id', $studentHistoryDetail->academic_class_id)
            ->where('academic_year_id', $studentHistoryDetail->academic_year_id)
            ->where('academic_group_id', $studentHistoryDetail->academic_group_id)
            ->where('academic_class_group_id', $studentHistoryDetail->academic_class_group_id)
            ->when($studentHistoryDetail->academic_department_id != 'null', function ($query) use ($dept_id) {
                return $query->where('academic_department_id', $dept_id);
            })
            ->where('status', true)
            ->get();



            $s_subjectCondition = SubjectCondition::where('condition_key','selectiveCompulsory')->first();
            $selective_copulsory = $limit_list->where('academic_subject_condition_id', $s_subjectCondition->id)->first();
            $selective_copulsory_limit['selective_copulsory_subject_limit'] = $selective_copulsory->limit_amount??null;

          //  dd($selective_copulsory->limit_amount);

            $o_subjectCondition = SubjectCondition::where('condition_key','optional')->first();
            $optional = $limit_list->where('academic_subject_condition_id', $o_subjectCondition->id)->first();
            $optional_limit['optional_subject_limit'] = $optional->limit_amount??null;

            //===

        $studentFullDetail = array_merge($guardianPanel, $studentHistoryDetail ? $studentHistoryDetail->toArray() : [], $studentDetail->toArray(), $selective_copulsory_limit, $optional_limit);
           // dd($studentFullDetail);
        return response()->json($studentFullDetail, 200, []);
    }//


    /**
     * @param $classid
     * @return string
     */





    public function getClassGroupBaseSubjectList($classid, $groupid, $yearid, $department_id)
    {

        $dept_id = $department_id;
        $academic_exam_condition_ids = AcademicSubjectClassExamCondition::whereIn('name_key', ['onlyforexam', 'forclassandexam'])
            ->pluck('id');


        $groupPresentCount = SiteShiftClassGroupSectionSetting::select('academic_class_group_id')
            ->where('academic_class_id', $classid)
            ->where('academic_year_id', $yearid)
            ->when($department_id != 'null', function ($query) use ($dept_id) {
                return $query->where('academic_department_id', $dept_id);
            })
            ->whereNotNull('academic_class_group_id')
            ->get()
            ->count();


        $siteClassBaseSubjectDetail = SubjectGroupConditionSetting::where('academic_class_id', $classid)
            ->where('academic_year_id', $yearid)
            ->when($department_id != 'null', function ($query) use ($dept_id) {
                return $query->where('academic_department_id', $dept_id);
            })
            ->whereIn('academic_subject_class_exam_condition_id', $academic_exam_condition_ids)
            ->where('status', true)
            ->get();

        $subjectCondition = SubjectCondition::get();


        $limit_list = SiteSubjectConditionLimit::where('academic_class_id', $classid)
            ->where('academic_year_id', $yearid)
            ->when($department_id != 'null', function ($query) use ($dept_id) {
                return $query->where('academic_department_id', $dept_id);
            })
            ->where('status', true)
            ->get();


        $classBaseOptionalSubjectIDList = [];
        $classBaseSelectiveCompulsorySubjectIDList = [];
        $classBaseCompulsorySubjectIDList = [];
        $optional_subject_limit = 0;
        $compulsory_subject_limit = 0;
        if (!$groupPresentCount && !$groupid) {

            foreach ($siteClassBaseSubjectDetail as $key => $value) {

                $academicOptionalSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                $optional_id = $subjectCondition->where('condition_key', 'optional')
                    ->first();

                $optional_sub_limit = $limit_list->where('academic_subject_condition_id', $optional_id->id)
                    ->first();


                $OptionalSubjectId = $subjectCondition->whereIn('id', $academicOptionalSubjectConditionIds)
                    ->where('condition_key', 'optional')
                    ->first();

                if ($OptionalSubjectId) {
                    if ($optional_sub_limit) {
                        if ($optional_sub_limit->not_show_academic_subject_ids) {
                            $limited_subject_list = AcademicSubject::
                            whereIn('id', explode(',', $optional_sub_limit->not_show_academic_subject_ids))
                                ->get();

                            $check_limit_not_show = $limited_subject_list->where('id', $value->academic_subject_id)->first();
                            if (!$check_limit_not_show) {
                                $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                            }

                            $optional_subject_limit = $optional_sub_limit->limit_amount ? $optional_sub_limit->limit_amount : 0;
                        } else {
                            $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                            $optional_subject_limit = $optional_sub_limit->limit_amount ? $optional_sub_limit->limit_amount : 0;
                        }
                    } else {
                        $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                    }

                }


                $academicSelectiveCompulsorySubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                $selectiveCompulsory_id = $subjectCondition->where('condition_key', 'selectiveCompulsory')
                    ->first();

                $selectiveCompulsory_sub_limit = $limit_list->where('academic_subject_condition_id', $selectiveCompulsory_id->id)
                    ->first();


                $SelectiveCompulsorySubjectId = $subjectCondition->whereIn('id', $academicSelectiveCompulsorySubjectConditionIds)
                    ->where('condition_key', 'selectiveCompulsory')
                    ->first();

                if ($SelectiveCompulsorySubjectId) {
                    if ($selectiveCompulsory_sub_limit) {
                        if ($selectiveCompulsory_sub_limit->not_show_academic_subject_ids) {
                            $limited_compulsory_subject_list = AcademicSubject::
                            whereIn('id', explode(',', $selectiveCompulsory_sub_limit->not_show_academic_subject_ids))
                                ->get();

                            $check_limit_not_show_compulsory = $limited_compulsory_subject_list->where('id', $value->academic_subject_id)->first();
                            if (!$check_limit_not_show_compulsory) {
                                $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                            }

                            $compulsory_subject_limit = $selectiveCompulsory_sub_limit->limit_amount ? $selectiveCompulsory_sub_limit->limit_amount : 0;
                        } else {
                            $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                            $compulsory_subject_limit = $selectiveCompulsory_sub_limit->limit_amount ? $selectiveCompulsory_sub_limit->limit_amount : 0;
                        }
                    } else {
                        $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                    }

                }

            };
        } else if ($groupPresentCount && $groupid) {

            $group_sub_limit_list = $limit_list->where('academic_class_group_id', $groupid);

            foreach ($siteClassBaseSubjectDetail as $key => $value) {

                $academicClassGroupIds = explode(',', $value->academic_class_group_ids);
                $academicClassGroupPresent = array_keys($academicClassGroupIds, $groupid);

                if ($academicClassGroupPresent) {
                    $academicOptionalSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
                    $OptionalSubjectId = $subjectCondition->whereIn('id', $academicOptionalSubjectConditionIds)
                        ->where('condition_key', 'optional')
                        ->first();


                    $optional_id = $subjectCondition->where('condition_key', 'optional')
                        ->first();

                    $optional_sub_limit = $group_sub_limit_list->where('academic_subject_condition_id', $optional_id->id)
                        ->first();

                    if ($OptionalSubjectId) {

                        if ($optional_sub_limit) {
                            if ($optional_sub_limit->not_show_academic_subject_ids) {
                                $limited_subject_list = AcademicSubject::
                                whereIn('id', explode(',', $optional_sub_limit->not_show_academic_subject_ids))
                                    ->get();

                                $check_limit_not_show = $limited_subject_list->where('id', $value->academic_subject_id)->first();
                                if (!$check_limit_not_show) {
                                    $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                                }

                                $optional_subject_limit = $optional_sub_limit->limit_amount ? $optional_sub_limit->limit_amount : 0;
                            } else {
                                $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                                $optional_subject_limit = $optional_sub_limit->limit_amount ? $optional_sub_limit->limit_amount : 0;
                            }
                        } else {

                            $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                            $optional_subject_limit = null;
                        }


                    }


                    $academicSelectiveCompulsorySubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
                    $SelectiveCompulsorySubjectId = $subjectCondition->whereIn('id', $academicSelectiveCompulsorySubjectConditionIds)
                        ->where('condition_key', 'selectiveCompulsory')
                        ->first();


                    $selectiveCompulsory_id = $subjectCondition->where('condition_key', 'selectiveCompulsory')
                        ->first();

                    $selectiveCompulsory_sub_limit = $group_sub_limit_list->where('academic_subject_condition_id', $selectiveCompulsory_id->id)
                        ->first();


                    if ($SelectiveCompulsorySubjectId) {
                       // dd($selectiveCompulsory_sub_limit);
                        if ($selectiveCompulsory_sub_limit) {
                            if ($selectiveCompulsory_sub_limit->not_show_academic_subject_ids) {
                                $limited_compulsory_subject_list = AcademicSubject::
                                whereIn('id', explode(',', $selectiveCompulsory_sub_limit->not_show_academic_subject_ids))
                                    ->get();

                                $check_limit_not_show_compulsory = $limited_compulsory_subject_list->where('id', $value->academic_subject_id)->first();
                                if (!$check_limit_not_show_compulsory) {
                                    $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                                }

                                $compulsory_subject_limit = $selectiveCompulsory_sub_limit->limit_amount ? $selectiveCompulsory_sub_limit->limit_amount : 0;
                            } else {
                                $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                                $compulsory_subject_limit = $selectiveCompulsory_sub_limit->limit_amount ? $selectiveCompulsory_sub_limit->limit_amount : 0;
                            }
                        } else {
                            $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                            $compulsory_subject_limit = null;

                        }

                    }
                }
            };
        }

        $OptionalSubjectList = AcademicSubject::whereIn('id', $classBaseOptionalSubjectIDList)->get();


        $SelectiveCompulsorySubjectList = AcademicSubject::whereIn('id', $classBaseSelectiveCompulsorySubjectIDList)->get();


        //================religion subject list======================
        $classBaseReligionSubjectIDList = [];
        foreach ($siteClassBaseSubjectDetail as $key => $value) {

            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
            $religionSubjectId = $subjectCondition->whereIn('id', $academicSubjectConditionIds)
                ->where('condition_key', 'religion')
                ->first();


            if ($religionSubjectId) {
                $classBaseReligionSubjectIDList[$key] = $value->academic_subject_id;
            }
        };


        $religionSubjectList = AcademicSubject::whereIn('id', $classBaseReligionSubjectIDList)->withTranslation('bn')->get();

        //return $religionSubjectList;


        //================Markingless subject list======================
        $classBaseMarkinglessSubjectIDList = [];
        foreach ($siteClassBaseSubjectDetail as $key => $value) {

            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
            $markinglessSubjectId = $subjectCondition->whereIn('id', $academicSubjectConditionIds)
                ->where('condition_key', 'selectiveMarkingless')
                ->first();


            if ($markinglessSubjectId) {
                $classBaseMarkinglessSubjectIDList[$key] = $value->academic_subject_id;
            }
        };


        $markinglessSubjectList = AcademicSubject::whereIn('id', $classBaseMarkinglessSubjectIDList)->withTranslation('bn')->get();

        //return Markingless;


        return [$religionSubjectList, $SelectiveCompulsorySubjectList, $OptionalSubjectList, $markinglessSubjectList,
            $compulsory_subject_limit, $optional_subject_limit];
    }

    private function RandomString($length) {
        $keys = array_merge(range(0,9), range('A', 'Z'));

        $key = "";
        for($i=0; $i < $length; $i++) {
            $key .= $keys[mt_rand(0, count($keys) - 1)];
        }
        return $key;
    }
    /**
     * @param Requests\Validator $validatedRequest
     * @return mixed
     */
    public function createStudent(Student $student, StudentHistory $studentHistory, Request $requests)
    {

        DB::beginTransaction();
        try {
            $this->validate($requests, [
                "academic_version_id" => "required",
                "academic_year_id" => "required",
                "academic_shift_id" => "required",
                "academic_class_id" => "required",
                'first_name' => 'required',
                'father_name' => 'required',
                'mother_name' => 'required',
                "religion_id" => "required",
                "gender_id" => "required",
                "academic_student_category_id" => "required",

                "previous_marks" => $requests->previous_institute_name ? "required" : "",

                "tc_number" => $requests->previous_institute_name ? "required" : "",
                "tc_date" => $requests->previous_institute_name ? "required" : "",
                "local_gurdian_name" => $requests->local_gurdian_name ? "required" : "",
                //                "relation_id" => $requests->local_gurdian_name ? "required" : "",
                "local_gurdian_mobile" => $requests->local_gurdian_name ? "required" : "",

                // "academic_session_id" => count($requests->AcademicSessionList) > 0 ? "required" : "",
                "religion_subject_id" => count($requests->ReligionSubjectList) > 0 ? "required" : "",
            ]);


            $data = $requests->all();
            $site_id = Session::get('SITE_ID');

            $date_formate = Carbon::parse($requests->date_of_birth);
            $date_of_birth = $date_formate->format('Y-m-d');


            $check_batch_present = SiteInfoSetting::select('batch_present_status')->first();
            if ($check_batch_present->batch_present_status && !$requests->site_batch_detail_id) {
                return Response::json(['message' => 'Please Select Batch',
                    'mode' => 'Error'], 412);
            }


            // if ($requests->compulsory_subject_limit) {
            //     if (is_array($requests->compulsory_subject_ids)) {
            //         $compulsory_subject_ids_list = $requests->compulsory_subject_ids;
            //     } else {
            //         $compulsory_subject_ids_list[] = $requests->compulsory_subject_ids;
            //     }

            //     if ($requests->compulsory_subject_limit < count($compulsory_subject_ids_list) ||
            //         $requests->compulsory_subject_limit > count($compulsory_subject_ids_list)
            //     ) {
            //         return Response::json(['message' => 'Please Choose ' . $requests->compulsory_subject_limit . ' Compulsory Subject!.',
            //             'mode' => 'Error'], 412);
            //     }

            // }

                 // check selective compulsory subject limit

                 if ($requests->compulsory_subject_limit) {
                    if (is_array($requests->selective_compulsory_subject_ids)) {

                        $compulsory_subject_ids_list = $requests->selective_compulsory_subject_ids;
                    } else {
                        $compulsory_subject_ids_list[] = $requests->selective_compulsory_subject_ids;

                    }

                    if ($requests->compulsory_subject_limit < count($compulsory_subject_ids_list) ||
                        $requests->compulsory_subject_limit > count($compulsory_subject_ids_list)
                    ) {
                        return Response::json(['message' => 'Please Choose ' . $requests->compulsory_subject_limit . ' Compulsory Subject!.',
                            'mode' => 'Error'], 412);
                    }

                }

                 // check optional subject limit

            if ($requests->optional_subject_limit) {
                if (is_array($requests->optional_subject_ids)) {
                    $optional_subject_ids_list = $requests->optional_subject_ids;
                } else {
                    $optional_subject_ids_list[] = $requests->optional_subject_ids;
                }

                if ($requests->optional_subject_limit < count($optional_subject_ids_list) ||
                    $requests->optional_subject_limit > count($optional_subject_ids_list)
                ) {
                    return Response::json(['message' => 'Please Choose ' . $requests->optional_subject_limit . ' Optional Subject!.',
                        'mode' => 'Error'], 412);
                }

            }


            //            $studentList = User::whereHas('translations', function ($query) use ($requests, $data) {
            //                $query->where('locale', 'en')
            //                    ->where('first_name', $requests->first_name)
            //                    ->where('father_name', $requests->father_name)
            //                    ->where('mother_name', $requests->mother_name)
            //                    ->when(!empty($data[$requests->last_name]), function ($query) use ($data) {
            //                        return $query->where('last_name', $data['last_name']);
            //                    });
            //            })->where('date_of_birth', $date_of_birth)->first();


            $getStudentSameBirthDate = User::where('site_id', Session::get('SITE_ID'))
                ->where('date_of_birth', $date_of_birth)
                ->select('id')
                ->get();


            $full_name_request = ($requests->first_name) . ($requests->last_name ? $requests->last_name : '');

            if (count($getStudentSameBirthDate) > 0) {

                foreach ($getStudentSameBirthDate as $key => $value) {
                    $full_name_with_out_space = strtoupper(str_replace(' ', '', $value->full_name));
                    $father_name_with_out_space = strtoupper(str_replace(' ', '', $value->father_name));
                    $mother_name_with_out_space = strtoupper(str_replace(' ', '', $value->mother_name));


                    $present_full_name_with_out_space = strtoupper(str_replace(' ', '', $full_name_request));
                    $present_father_name_with_out_space = strtoupper(str_replace(' ', '', $requests->father_name));
                    $present_mother_name_with_out_space = strtoupper(str_replace(' ', '', $requests->mother_name));
                    //
                    //                    return [$full_name_with_out_space, $father_name_with_out_space, $mother_name_with_out_space,
                    //                    $present_full_name_with_out_space, $present_father_name_with_out_space,
                    //                        $present_mother_name_with_out_space];

                    if (
                        $full_name_with_out_space == $present_full_name_with_out_space &&
                        $father_name_with_out_space == $present_father_name_with_out_space &&
                        $mother_name_with_out_space == $present_mother_name_with_out_space
                    ) {

                        $student_birth_date_present_array[] = 1;
                    } else {
                        $student_birth_date_present_array[] = 0;
                    }
                }
            } else {
                $student_birth_date_present_array[] = 0;
            }


            $student_birth_date_present_count = collect($student_birth_date_present_array)->unique()->filter();
            if (count($student_birth_date_present_count) > 0) {
                if ($requests->site_batch_detail_id) {
                    $student_birth_date_present = 0;
                } else {
                    $student_birth_date_present = 1;
                }

            } else {
                $student_birth_date_present = 0;
            }


            $studentCheckList = User::select('id')
                ->where('academic_year_id', $requests->academic_year_id)
                ->where('academic_shift_id', $requests->academic_shift_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['site_batch_detail_id']), function ($query) use ($data) {
                    return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->where('student_roll_number', $requests->student_roll_number)
                ->first();


            if (!$requests->date_of_birth && !$requests->student_roll_number) {
                return Response::json(['message' => 'You must be fill up Date of birth Or Roll Number Field!'], 412);
            } else if ($requests->date_of_birth && !$requests->student_roll_number) {

                if ($student_birth_date_present == 1) {
                    return Response::json(['message' => 'This Student already present!'], 412);
                }
            } else if (!$requests->date_of_birth && $requests->student_roll_number) {

                if ($studentCheckList) {
                    return Response::json(['message' => 'Please change roll number'], 412);
                }
            } else if ($requests->date_of_birth && $requests->student_roll_number) {
                if ($student_birth_date_present == 1) {
                    return Response::json(['message' => 'This Student already present!'], 412);
                }
                if ($studentCheckList) {
                    return Response::json(['message' => 'Please change roll number!'], 412);
                }
            }


            if ($requests->local_gurdian_name) {
                $check_guardian = UserForUsername::where('contact_number', $requests->local_gurdian_mobile)->first();

                if (!$check_guardian) {
                    $guardianUsername = $this->guardianUserNameCreateUseName($requests);
                    $guardianPassword = mt_rand(10000, 99999);

                    $guardian_id = $student->create([
                        'username' => $guardianUsername,
                        'password' => $guardianPassword,
                        'user_type' => 'guardian',
                        'first_name' => $requests->local_gurdian_name,
                        'contact_number' => $requests->local_gurdian_mobile,
                        'address' => $requests->local_gurdian_address,
                        'email' => $requests->local_gurdian_email,
                        'created_by' => Auth::user()->id,
                        'status' => 1,
                    ]);
                    $guardianID = $guardian_id->id;

                    $roleGuardian = SiteRole::where('key', 'guardian')->first();
                    $guardian_id->siteRoles()->attach([$roleGuardian->id]);
                } else {
                    $guardianID = $check_guardian->id;
                }
            } else {
                $guardianID = 0;
            }

            $studentUsername = $this->studentUserNameCreateUseCode($requests);
           // $studentpassword = mt_rand(10000, 99999);
            $studentpassword = $this->RandomString(6);
            $academicSubjectIDs = $this->academicSubjectList($requests);
            $compulsorySubjectIDs = $this->compulsorySubjectList($requests);


            if (isset($student->studentFields)) {
                foreach ($student->studentFields as $studentField) {
                    if ($requests->{$studentField}) {
                        if (is_array($requests->{$studentField})) {
                            $student->{$studentField} = collect($requests->{$studentField})->implode(',');
                        } else {
                            $student->{$studentField} = $requests->{$studentField};
                        }
                    }
                }

                $student->username = $studentUsername;
                $student->password = $studentpassword;
                $student->local_guardian_user_id = $guardianID;
                $student->contact_number = $requests->student_contact_number;
                $student->address = $requests->present_address;

                $student->academic_section_id = $requests->academic_section_id;
                $student->academic_session_id = $requests->academic_session_id;
                $student->academic_student_admission_type_id = $requests->academic_student_admission_type_id;
                $student->academic_student_category_id = $requests->academic_student_category_id;
                $student->academic_student_type_id = $requests->academic_student_type_id;

                $student->user_type = 'student';
                $student->site_id = $site_id;
                $student->academic_group_id = Session::get('ACADEMIC_GROUP_ID');

                $student->academic_subject_ids = $academicSubjectIDs;
                $student->compulsory_subject_ids = $compulsorySubjectIDs;

                $student->guardian_student_relation_id = $requests->relation_id;
                $student->emergency_contact = $requests->student_emergency_contact_number;
                $student->birth_certificate_no = $requests->student_birth_certificate_no;
                $student->nid_number = $requests->student_national_id;
                $student->passport_no = $requests->student_passport_number;
                $student->email = $requests->student_email_id;
                $student->status = 1;

                $student->created_by = Auth::user()->id;
            }


            if ($student->save()) {
                $roleStudent = SiteRole::where('key', 'student')->first();
                $student->siteRoles()->attach([$roleStudent->id]);

                $this->setTheUserPermission($student);


            }


            if (isset($studentHistory)) {
                foreach ($studentHistory->ownFields as $ownField) {
                    if ($requests->{$ownField}) {
                        if (is_array($requests->{$ownField})) {
                            $studentHistory->{$ownField} = collect($requests->{$ownField})->implode(',');
                        } else {
                            $studentHistory->{$ownField} = $requests->{$ownField};
                        }
                    }
                }

                $studentHistory->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
                $studentHistory->user_id = $student->id;
                $studentHistory->local_guardian_id = $guardianID;
                $studentHistory->previous_exam_mark = $requests->previous_marks;
                $studentHistory->registration_no = $requests->student_registration_number;
                $studentHistory->academic_subject_ids = $academicSubjectIDs;
                $studentHistory->compulsory_subject_ids = $compulsorySubjectIDs;
                $studentHistory->status = 1;
                $studentHistory->created_by = Auth::user()->id;
            }

            $message = 'Student(' . $studentUsername . ') Save Successfully!';

            if ($studentHistory->save()) {
                $studentHistory->subjects()->sync(explode(',', $academicSubjectIDs));
                if ($requests->student_image) {
                    $this->savePhoto($student, $requests);
                    $message = 'Student(' . $studentUsername . ')  Save Successfully with Picture!';
                }
            }


            if ($requests->sendSms) {
                if ($requests->student_contact_number) {

                    $site = SiteInfo::findOrFail($site_id);
                    $url = config('app.url');

                    // $sms_txt = 'Congrats, ' . $student->full_name;
                    // $sms_txt .= 'nl' . $url;
                    // $sms_txt .= 'nl' . 'Username: ' . $studentUsername;
                    // $sms_txt .= 'nl' . 'Password: ' . $studentpassword;
                    // $sms_txt .= 'nl' . 'Regards: ' . $site->site_name;

                    $sms_txt = 'Congrats, ' . ucwords($student->full_name);
                    $sms_txt .= ',' . $url;
                    $sms_txt .= ', ' . 'Username: ' . $studentUsername;
                    $sms_txt .= ', ' . 'Password: ' . $studentpassword;
                    $sms_txt .= ', ' . 'Thanks: ' . $site->site_name;

                    $tt = $this->sendSms($site_id, [$requests->student_contact_number], $sms_txt);
                } else {
                    DB::rollBack();
                    throw new Error('Please Input Contact Number Field');
                }
            }


            DB::commit();
            return Response::json(['message' => $message, 'mode' => 'Saved!'], 200);
        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }


    private function sendMail(Student $emp, $username, $password)
    {

        try {

            $site = SiteInfo::whereId($emp->site_id)->first();

            $url = config('app.url');
            $parsedUrl = parse_url($url);
            $sub_domain = $parsedUrl['scheme'] . '://' . $site->site_alias . '.' . $parsedUrl['host'];
            $subject = 'Student Login Details';

            $data = [
                'name' => $emp->first_name . ' ' . $emp->last_name,
                'username' => $username,
                'sub_domain' => $sub_domain,
                'password' => $password,
                'message' => 'Employee Successfully Added!',
                'user_id' => Auth::user()->username
            ];

            \Mail::to([$site->site_email, 'eduworlderp@gmail.com'])->send(new SendMailToUserWithQueue($subject, $data));
        } catch (Exception $exception) {

            $issue = new    IssueDetail();
            $issue->issue_type = 'email';
            $issue->issue_details = json_encode($exception->getMessage());
            $issue->site_id = $site->id;
            $issue->save();
        }
    }

    private function compulsorySubjectList(Request $requests){
        $data = $requests->all();

        $subjectList = SubjectGroupConditionSetting::where('academic_class_id', $requests->academic_class_id)
            ->where('academic_year_id', $requests->academic_year_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->get();
            $compulsory_subject_ids = [];
            if ($requests->academic_class_group_id) {

                foreach ($subjectList as $key => $value) {

                    if ($value->academic_class_group_ids) {
                        $academicClassGroupIds = explode(',', $value->academic_class_group_ids);


                        if (in_array($requests->academic_class_group_id, $academicClassGroupIds)) {
                            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                            $subjectCondition = SubjectCondition::where('condition_key', 'compulsory')->first();

                            if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                                $compulsory_subject_ids[$key] = $value->academic_subject_id;
                            }
                        }
                    }
                }
            }
            $compulsorySubjectIds = (string)implode(',', $compulsory_subject_ids);

           return $compulsorySubjectIds;

    }


    private function academicSubjectList(Request $requests)
    {
        $data = $requests->all();

        $subjectList = SubjectGroupConditionSetting::where('academic_class_id', $requests->academic_class_id)
            ->where('academic_year_id', $requests->academic_year_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->get();



        $general_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

            $subjectCondition = SubjectCondition::where('condition_key', 'general')->first();

            if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                $general_subject_ids[$key] = $value->academic_subject_id;
            }
        }

        $general_markingless_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

            $markinglessSubjectCondition = SubjectCondition::where('condition_key', 'generalMarkingless')->first();

            if (in_array($markinglessSubjectCondition->id, $academicSubjectConditionIds)) {
                $general_markingless_subject_ids[$key] = $value->academic_subject_id;
            }
        }


        $compulsory_subject_ids = [];
        if ($requests->academic_class_group_id) {

            foreach ($subjectList as $key => $value) {

                if ($value->academic_class_group_ids) {
                    $academicClassGroupIds = explode(',', $value->academic_class_group_ids);


                    if (in_array($requests->academic_class_group_id, $academicClassGroupIds)) {
                        $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                        $subjectCondition = SubjectCondition::where('condition_key', 'compulsory')->first();

                        if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                            $compulsory_subject_ids[$key] = $value->academic_subject_id;
                        }
                    }
                }
            }
        }

        $selective_compulsory_subject_ids = [];
        if ($requests->academic_class_group_id) {

            foreach ($subjectList as $key => $value) {

                if ($value->academic_class_group_ids) {
                    $academicClassGroupIds = explode(',', $value->academic_class_group_ids);


                    if (in_array($requests->academic_class_group_id, $academicClassGroupIds)) {
                        $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                        $subjectCondition = SubjectCondition::where('condition_key', 'selectiveCompulsory')->first();

                        if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                            $selective_compulsory_subject_ids[$key] = $value->academic_subject_id;
                        }
                    }
                }
            }
        }



        $compulsory_subject_idList = [];
        if ($requests->compulsory_subject_ids) {
            if (is_array($requests->compulsory_subject_ids)) {
                $compulsory_subject_idList = $requests->compulsory_subject_ids??0;
            } else {
                $compulsory_subject_idList[] = $requests->compulsory_subject_ids??0;
            }

        }

        $Optional_subject_idList = [];
    //    dd($requests->optional_subject_ids);
        if ($requests->optional_subject_ids) {
            if (is_array($requests->optional_subject_ids)) {
                $Optional_subject_idList = $requests->optional_subject_ids??0;
            } else {
                $Optional_subject_idList[] = $requests->optional_subject_ids??0;
            }
        }


        $selective_markingless_subject_idList = [];
        if ($requests->selective_markingless_subject_ids) {
            if (is_array($requests->selective_markingless_subject_ids)) {
                $selective_markingless_subject_idList = $requests->selective_markingless_subject_ids??0;
            } else {
                $selective_markingless_subject_idList[] = $requests->selective_markingless_subject_ids??0;
            }
        }


        $religion_subject = [];
        if ($requests->religion_subject_id) {
            $religion_subject[] = $requests->religion_subject_id??0;
        }


      //  dd($Optional_subject_idList);
        $Subjects = array_merge(
            $general_subject_ids,
            $general_markingless_subject_ids,
            $compulsory_subject_ids,
            $selective_compulsory_subject_ids,
          //  $compulsory_subject_idList,
           // $Optional_subject_idList,
          //  $selective_markingless_subject_idList,
            $religion_subject
        );

       // dd($Subjects);

            $academicSubjectIds = (string)implode(',', $Subjects);
            $academicSubjectIdst = array_unique(explode(',', $academicSubjectIds));
            $finalAcademicSubjectIds = (string)implode(',', $academicSubjectIdst);

            return $finalAcademicSubjectIds;


    }


    private function studentUserNameCreateUseCode(Request $requests)
    {
        $academicYear = AcademicYear::where('id', $requests->academic_year_id)->first();

        $start_date = Carbon::parse($academicYear->start_date)->format('d-m-Y');
        $onlyYear = explode("-", $start_date);
        $yearSelect = $onlyYear[2];
        //        $year= $start_date->format('Y');

        $yearCode = substr($yearSelect, 2, 2);

        $siteCode = sprintf("%03d", Session::get('SITE_ID'));

        $yearSiteCode = $yearCode . $siteCode;
        $yearSiteCodeLength = strlen($yearSiteCode);

        $userRows = UserForUsername::whereRaw("username REGEXP '^{$yearSiteCode}([0-9]*)?$'")
            ->orderBy('username', 'desc')
            ->first();

        if ($userRows) {
            $extructData = substr($userRows->username, $yearSiteCodeLength);
            $countValue = (int)$extructData;
            $countUser = $countValue + 1;
            $studentUserNameCre = $yearSiteCode . sprintf("%05d", $countUser);
        } else {
            $studentUserNameCre = $yearSiteCode . sprintf("%05d", 1);
        }

        return $studentUserNameCre;
    }


    // user name create use first name & last name
    private function guardianUserNameCreateUseName(Request $requests)
    {
        if ($requests->local_gurdian_name) {
            $Name = $requests->local_gurdian_name;
            $NameSplite = explode(' ', $Name, 3);

            if (count($NameSplite) == 1) {
                $UserName = strtolower($NameSplite[0]);
            } else {
                $UserName = strtolower($NameSplite[0] . $NameSplite[1]);
            }

            $userLength = strlen($UserName);


            $userRows = UserForUsername::whereRaw("username REGEXP '^{$UserName}([0-9]*)?$'")
                ->orderBy('username', 'desc')
                ->first();

            if ($userRows) {
                $extructData = substr($userRows->username, $userLength);
                $countValue = (int)$extructData;
                $countUser = $countValue + 1;
                $UserNameCre = "{$UserName}{$countUser}";
            } else {
                $UserNameCre = $UserName;
            }
        } else {
            $UserNameCre = null;
        }

        return $UserNameCre;
    }

    /**
     * @param $classId
     * @param $attDate
     * @param SiteRole $role
     * @param StudentClass $studentClass
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function getStudentListByClass($classId, $attDate, SiteRole $role, StudentClass $studentClass)
    {
        $attDate = $attDate;
        $studentClass = $studentClass->findOrFail($classId);
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $roleId = $this->role('Student');
        $roleOfStudent = $role->with('users')->findOrFail($roleId);
        $studentList = $roleOfStudent->users()->with('studentAttendances')->whereStudentClassId($classId)->get();

        $studentsWithPhotos = array();

        if (!$studentList->isEmpty()) {

            foreach ($studentList as $student) {

                if (count($student->photos) > 0)

                    $studentsWithPhotos[$student->photos->last()->name] = $student;
            }
        }

        $viewType = 'Student List';
        if (request()->ajax()) {
            return view('default.admin.students.student-list-for-attendance', compact('studentsWithPhotos', 'locale', 'defaultLocale', 'viewType', 'attDate', 'studentClass'));
        }
    }


    /**
     * @param $id
     * @param Requests\Validator $validatedRequest
     * @return mixed
     */
    public function editStudent($id, Request $requests)
    {

        try {

            DB::beginTransaction();
            $data = $requests->all();

     //   dd($requests->AcademicSessionList);

            $date_formate = Carbon::parse($requests->date_of_birth);
            $date_of_birth = $date_formate->format('Y-m-d');

            $this->validate($requests, [
                'first_name' => 'required',
                'father_name' => 'required',
                'mother_name' => 'required',
                "religion_id" => "required",
                "gender_id" => "required",
                "academic_student_category_id" => "required",

                "previous_marks" => $requests->previous_institute_name ? "required" : "",
                "tc_number" => $requests->previous_institute_name ? "required" : "",
                "tc_date" => $requests->previous_institute_name ? "required" : "",
                "local_gurdian_name" => $requests->local_gurdian_name ? "required" : "",
                "relation_id" => $requests->local_gurdian_name ? "required" : "",
                "local_gurdian_mobile" => $requests->local_gurdian_name ? "required" : "",

                "academic_session_id" => count($requests->AcademicSessionList) > 0 ? "required" : "",
                "religion_subject_id" => count($requests->ReligionSubjectList) > 0 ? "required" : "",

            ]);



            $studentList = User::select(['id', 'username'])
                ->whereHas('translations', function ($query) use ($data) {
                    $query->where('locale', 'en')
                        ->where('first_name', $data['first_name'])
                        ->where('father_name', $data['father_name'])
                        ->where('mother_name', $data['mother_name'])
                        ->when(!empty($data['last_name']), function ($query) use ($data) {
                            return $query->where('last_name', $data['last_name']);
                        });
                })
                ->where('date_of_birth', $requests->date_of_birth)
                ->whereNotIn('id', [$requests->user_id])
                ->first();



            // check selective compulsory subject limit

            if ($requests->compulsory_subject_limit) {
                if (is_array($requests->selective_compulsory_subject_ids)) {

                    $compulsory_subject_ids_list = $requests->selective_compulsory_subject_ids;
                } else {
                    $compulsory_subject_ids_list[] = $requests->selective_compulsory_subject_ids;

                }


                $positive_values = array_filter($compulsory_subject_ids_list, function($value) {
                    return is_numeric($value) && $value > 0;
                });

             //   dd($positive_values);
                $positive_values_subject_ids = array_values($positive_values);

             //   dd($positive_values_subject_ids);

                if ($requests->compulsory_subject_limit < count($positive_values_subject_ids) ||
                    $requests->compulsory_subject_limit > count($positive_values_subject_ids)
                ) {
                    return Response::json(['message' => 'Please Choose ' . $requests->compulsory_subject_limit . ' Compulsory Subject!.',
                        'mode' => 'Error'], 412);
                }

            }

            // check optional subject limit

            if ($requests->optional_subject_limit) {
                if (is_array($requests->optional_subject_ids)) {
                    $optional_subject_ids_list = $requests->optional_subject_ids;
                } else {
                    $optional_subject_ids_list[] = $requests->optional_subject_ids;
                }

                if ($requests->optional_subject_limit < count($optional_subject_ids_list) ||
                    $requests->optional_subject_limit > count($optional_subject_ids_list)
                ) {
                    return Response::json(['message' => 'Please Choose ' . $requests->optional_subject_limit . ' Optional Subject!.',
                        'mode' => 'Error'], 412);
                }

            }


            $getStudentSameBirthDate = User::where('site_id', Session::get('SITE_ID'))
                ->where('date_of_birth', $date_of_birth)
                ->whereNotIn('id', [$requests->user_id])
                ->select('id')
                ->get();


            $full_name_request = ($requests->first_name) . ($requests->last_name ? $requests->last_name : '');

            if (count($getStudentSameBirthDate) > 0) {

                foreach ($getStudentSameBirthDate as $key => $value) {
                    $full_name_with_out_space = strtoupper(str_replace(' ', '', $value->full_name));
                    $father_name_with_out_space = strtoupper(str_replace(' ', '', $value->father_name));
                    $mother_name_with_out_space = strtoupper(str_replace(' ', '', $value->mother_name));


                    $present_full_name_with_out_space = strtoupper(str_replace(' ', '', $full_name_request));
                    $present_father_name_with_out_space = strtoupper(str_replace(' ', '', $requests->father_name));
                    $present_mother_name_with_out_space = strtoupper(str_replace(' ', '', $requests->mother_name));

                    //                    return [$full_name_with_out_space, $father_name_with_out_space, $mother_name_with_out_space,
                    //                    $present_full_name_with_out_space, $present_father_name_with_out_space,
                    //                        $present_mother_name_with_out_space];

                    if (
                        $full_name_with_out_space == $present_full_name_with_out_space &&
                        $father_name_with_out_space == $present_father_name_with_out_space &&
                        $mother_name_with_out_space == $present_mother_name_with_out_space
                    ) {

                        $student_birth_date_present_array[] = 1;
                    } else {
                        $student_birth_date_present_array[] = 0;
                    }
                }
            } else {
                $student_birth_date_present_array[] = 0;
            }


            $student_birth_date_present_count = collect($student_birth_date_present_array)->unique()->filter();
            if (count($student_birth_date_present_count) > 0) {
                if ($requests->site_batch_detail_id) {
                    $student_birth_date_present = 0;
                } else {
                    $student_birth_date_present = 1;
                }
//                $student_birth_date_present = 1;
            } else {
                $student_birth_date_present = 0;
            }


            //  throw new \Error($requests->user_id);
            //  throw new \Error($studentList);

            $studentCheckList = StudentHistory::select('id')
                ->where('academic_year_id', $requests->academic_year_id)
                ->where('academic_shift_id', $requests->academic_shift_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['site_batch_detail_id']), function ($query) use ($data) {
                    return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->where('student_roll_number', $requests->student_roll_number)
                ->whereNotIn('id', [$id])
                ->first();


            if (!$requests->date_of_birth && !$requests->student_roll_number) {
                return Response::json(['message' => 'You must be fill up Date of birth Or Roll Number Field!'], 412);
            } else if ($requests->date_of_birth && !$requests->student_roll_number) {

                if ($student_birth_date_present == 1) {
                    return Response::json(['message' => 'This Student already present!'], 412);
                }
            } else if (!$requests->date_of_birth && $requests->student_roll_number) {

                if ($studentCheckList) {
                    return Response::json(['message' => 'Please change roll number'], 412);
                }
            } else if ($requests->date_of_birth && $requests->student_roll_number) {
                if ($student_birth_date_present == 1) {
                    return Response::json(['message' => 'This Student Already Present with username: ' . $studentList->username], 412);
                }
                if ($studentCheckList) {
                    return Response::json(['message' => 'Please change roll number!'], 412);
                }
            }

            $academicSubjectIDs = $this->academicSubjectList($requests);
            $Compulsory_subject_ids = $this->compulsorySubjectList($requests);

            $studentHistory = StudentHistory::findOrFail($id);
            $student = Student::where('id', $studentHistory->user_id)->first();


            //Guardian part Update

            $guardianID = 0;
            if (($student->local_guardian_user_id) && ($requests->local_gurdian_name)) {
                $guardian = User::where('id', $student->local_guardian_user_id)->first();

                if (
                    $requests->local_gurdian_name == $guardian->first_name
                    || $requests->local_gurdian_mobile == $guardian->contact_number
                ) {

                    $guardian->first_name = $requests->local_gurdian_name;
                    $guardian->contact_number = $requests->local_gurdian_mobile;
                    $guardian->address = $requests->local_gurdian_address;
                    $guardian->email = $requests->local_gurdian_email;
                    $guardian->guardian_student_relation_id = $requests->relation_id;
                    $guardian->updated_by = Auth::user()->id;
                    $guardian->save();

                    $guardianID = $student->local_guardian_user_id;
                } else {

                    $guardianCount = User::where('local_guardian_user_id', $student->local_guardian_user_id)->get();
                    if (count($guardianCount) == 1) {
                        $guardian->status = 0;
                        $guardian->save();
                    }

                    $guardianUsername = $this->guardianUserNameCreateUseName($requests);
                    $guardianPassword = mt_rand(10000, 99999);

                    $guardian_id = User::create([
                        'username' => $guardianUsername,
                        'password' => $guardianPassword,
                        'first_name' => $requests->local_gurdian_name,
                        'user_type' => 'guardian',
                        'contact_number' => $requests->local_gurdian_mobile,
                        'address' => $requests->local_gurdian_address,
                        'email' => $requests->local_gurdian_email,
                        'created_by' => Auth::user()->id,
                        'status' => 1,
                    ]);
                    $guardianID = $guardian_id->id;

                    $roleGuardian = SiteRole::where('name', 'guardian')->first();
                    $guardian_id->siteRoles()->attach([$roleGuardian->id]);
                }
            } elseif (($student->local_guardian_user_id) && (!$requests->local_gurdian_name)) {

                $guardianCount = User::where('local_guardian_user_id', $student->local_guardian_user_id)->get();
                if (count($guardianCount) == 1) {
                    $guardian = User::where('id', $student->local_guardian_user_id)->first();
                    $guardian->status = 0;
                    $guardian->updated_by = Auth::user()->id;
                    $guardian->save();
                }
            } elseif ((!$student->local_guardian_user_id) && ($requests->local_gurdian_name)) {


                $guardianUsername = $this->guardianUserNameCreateUseName($requests);
                $guardianPassword = mt_rand(10000, 99999);

                $guardian = User::create([
                    'username' => $guardianUsername,
                    'password' => $guardianPassword,
                    'user_type' => 'guardian',
                    'first_name' => $requests->local_gurdian_name,
                    'contact_number' => $requests->local_gurdian_mobile,
                    'address' => $requests->local_gurdian_address,
                    'email' => $requests->local_gurdian_email,
                    'created_by' => Auth::user()->id,
                    'status' => 1,
                ]);

                $guardianID = $guardian->id;

                $roleGuardian = SiteRole::where('name', 'guardian')->first();
                $guardian->siteRoles()->attach([$roleGuardian->id]);
            } elseif ((!$student->local_guardian_user_id) && (!$requests->local_gurdian_name)) {
                $guardianID = 0;

            }


            //Student History part Update


            if (isset($studentHistory)) {
                foreach ($studentHistory->ownFields as $ownField) {
                //    dd($requests->{$ownField});
                    if ($requests->{$ownField}) {
                        if (is_array($requests->{$ownField})) {
                            $studentHistory->{$ownField} = collect($requests->{$ownField})->implode(',');
                        } else {
                            $studentHistory->{$ownField} = $requests->{$ownField};
                        }
                    }
                }

                //            Log::info($requests->academic_section_id);
                $studentHistory->academic_section_id = $requests->academic_section_id;
                $studentHistory->academic_session_id = $requests->academic_session_id;

                $studentHistory->academic_student_admission_type_id = $requests->academic_student_admission_type_id;
                $studentHistory->academic_student_category_id = $requests->academic_student_category_id;
                $studentHistory->academic_student_type_id = $requests->academic_student_type_id;

                $studentHistory->previous_exam_mark = $requests->previous_marks;
                $studentHistory->registration_no = $requests->student_registration_number;
                $studentHistory->academic_subject_ids = $academicSubjectIDs;
                $studentHistory->compulsory_subject_ids = $Compulsory_subject_ids;
                $studentHistory->local_guardian_id = $guardianID;
              //  $studentHistory->local_guardian_user_id = $guardianID;
              //  $studentHistory->guardian_student_relation_id = $requests->relation_id;

                $studentHistory->updated_by = Auth::user()->id;
                $studentHistory->site_id = Session::get('SITE_ID');
                $studentHistory->academic_group_id = Session::get('ACADEMIC_GROUP_ID');


                if (!($requests->selective_compulsory_subject_ids)) {
                    $studentHistory->selective_compulsory_subject_ids = null;
                }
                if (!($requests->optional_subject_ids)) {
                    $studentHistory->optional_subject_ids = null;
                }
                if (!($requests->selective_markingless_subject_ids)) {
                    $studentHistory->selective_markingless_subject_ids = null;
                }
            }
            if ($studentHistory->save()) {
                $studentHistory->subjects()->sync(explode(',', $academicSubjectIDs));
                $abc = $studentHistory->id;
            }


            //Student User part Update


            if (isset($student->studentFields)) {
                foreach ($student->studentFields as $studentField) {
                    if ($requests->{$studentField}) {
                        if (is_array($requests->{$studentField})) {
                            $student->{$studentField} = collect($requests->{$studentField})->implode(',');
                        } else {
                            $student->{$studentField} = $requests->{$studentField};
                        }
                    }

                }

                $student->academic_section_id = $requests->academic_section_id;
                $student->last_name = $requests->last_name ?? null;

                $student->academic_student_admission_type_id = $requests->academic_student_admission_type_id;
                $student->academic_student_category_id = $requests->academic_student_category_id;
                $student->academic_student_type_id = $requests->academic_student_type_id;

                $student->academic_section_id = $requests->academic_section_id ?? null;

                //return $requests->academic_section_id;

                $student->user_type = 'student';
                $student->site_id = Session::get('SITE_ID');
                $student->academic_group_id = Session::get('ACADEMIC_GROUP_ID');

                $student->academic_subject_ids = $academicSubjectIDs;
                $student->compulsory_subject_ids = $Compulsory_subject_ids;

                $student->contact_number = $requests->student_contact_number;
                $student->address = $requests->present_address;
                $student->local_guardian_user_id = $guardianID;
              //  dd($requests->relation_id);
                $student->guardian_student_relation_id = $requests->relation_id;
                $student->emergency_contact = $requests->student_emergency_contact_number;
                $student->birth_certificate_no = $requests->student_birth_certificate_no;
                $student->nid_number = $requests->student_national_id;
                $student->passport_no = $requests->student_passport_number;
                $student->email = $requests->student_email_id;

                $student->updated_by = Auth::user()->id;



                if (!($requests->selective_compulsory_subject_ids)) {
                    $student->selective_compulsory_subject_ids = null;
                }
                if (!($requests->optional_subject_ids)) {
                    $student->optional_subject_ids = null;
                }
                if (!($requests->selective_markingless_subject_ids)) {
                    $student->selective_markingless_subject_ids = null;
                }
            }
            if ($student->save()) {
                if (strpos($requests->student_image, 'base64')) {
                    $this->savePhoto($student, $requests);
                }
            }

            DB::commit();
            return Response::json(['message' => 'information Update Successfully!', 'mode' => 'Update!']);

        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();

            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    /**
     * @param $sectionId
     * @param SiteRole $role
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function getStudentListBySection($classId = null, $sectionId = null, $attDate = null, SiteRole $role, StudentClass $studentClass1, Section $section)
    {
        $viewType = 'Student List';
        $studentClass = $studentClass1->findOrFail($classId);
        $studentSection = $section->findOrFail($sectionId);
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $roleId = $this->role('Student');

        $roleOfStudent = $role->with('users')->findOrFail($roleId);


        $studentList = $roleOfStudent->users()
            ->whereStudentClassId($classId)
            ->whereSectionId($sectionId)
            ->get();

        $studentAttendanceExist = (new StudentAttendance())
            ->whereSectionId($sectionId)
            ->wherePresentDate($attDate)
            ->first();


        $studentsWithPhotos = array();
        foreach ($studentList as $student) {

            if (count($student->photos) > 0)
                $studentsWithPhotos[$student->photos->last()->name] = $student;
        }

        $Options = DB::table('Options')->get();
        if (request()->ajax()) {
            return view('default.admin.students.student-list-for-attendance', compact('viewType', 'studentAttendanceExist', 'studentsWithPhotos', 'locale', 'defaultLocale', 'attDate', 'studentClass', 'studentSection', 'Options'));
        }
        return view('default.admin.students.student-list-for-attendance', compact('viewType', 'studentAttendanceExist', 'studentsWithPhotos', 'locale', 'defaultLocale', 'attDate', 'studentClass', 'studentSection', 'Options'));
    }


    //----------------------------------get student list---------------------------------------

    public function getStudentList(Request $requests)
    {
//                return $requests;
        try {

            $data = $requests->all();

            //   Log::info($data);

            $search_txt = $requests->search_txt;
            $txt = '%' . $search_txt . '%';

            $studentList = $this->studentHistory
                ->select(
                    'id',
                    'user_id',
                    'academic_class_id',
                    'academic_section_id',
                    'academic_department_id',
                    'academic_class_group_id',
                    'academic_session_id',
                    'compulsory_subject_ids',
                    'student_roll_number',
                    'student_roll_number_prefix',
                    'academic_shift_id',
                    'optional_subject_ids',
                    'selective_markingless_subject_ids',
                    'site_batch_detail_id'
                )
                ->with(['shift', 'section', 'stClass', 'student.religion', 'student.gender', 'student.latestPhoto',
                    'student' => function ($query) {
                        $query->select('id', 'religion_id', 'gender_id', 'biometric_id', 'username', 'present_id_card_code');
                    }, 'batch' => function ($query) {
                        $query->select('id', 'batch_name');
                    }])
                ->whereHas('student', function ($query) use ($search_txt, $txt) {

                    $query->where('user_type', 'student')
                        ->when($search_txt, function ($q) use ($txt) {
                            return $q->where(function ($query) use ($txt) {
                                $query->where('username', 'LIKE', $txt)
                                    ->orWhere('email', 'LIKE', $txt)
                                    ->orWhere('contact_number', 'LIKE', $txt)
                                    ->orWhereTranslationLike('first_name', $txt)
                                    ->orWhereTranslationLike('last_name', $txt);
                            });
                        })->select('id', 'religion_id', 'gender_id', 'biometric_id', 'username', 'present_id_card_code');
                })
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['site_batch_detail_id']), function ($query) use ($data) {
                    return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
                })
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                    return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
                })
                ->when($data['academic_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_admission_type_id']);
                })
                ->when($data['academic_student_category_id'], function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->where('status', $data['status'])
                ->orderBy('student_roll_number', 'ASC')
                ->paginate($data['paginate']);


            if (count($studentList) < 1) {
                throw new Error("No Student Found!");
            }


            return $studentList;
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }


    //==============================pause Student=========

    public function pauseSingleStudent(Request $request)
    {


        $studentHistoryCheckList = StudentHistory::where('id', $request->StudentHistoryID)->first();


        $student = User::where('id', $studentHistoryCheckList->user_id)->first();


        if ($student) {

            $studentMultiplicationCheck = StudentHistory::where('user_id', $student->id)->get('id', 'user_id');

            if (count($studentMultiplicationCheck) == 1) {
                if ($student->local_guardian_user_id) {
                    $guardianCount = User::where('local_guardian_user_id', $student->local_guardian_user_id)->get();
                    if (count($guardianCount) == 1) {
                        $guardian = User::where('id', $student->local_guardian_user_id)->first();
                        $guardian->status = 0;
                        $guardian->save();
                    }
                }


                $student->status = 0;
                $student->save();
            }
        }


        $studentHistoryCheckList->status = 0;
        $studentHistoryCheckList->save();


        return Response::json(['message' => 'Student Pause Successfully!', 'mode' => 'Update!']);
    }


    public function activeSingleStudent(Request $request)
    {

        $studentHistoryCheckList = StudentHistory::where('id', $request->StudentHistoryID)->first();


        $student = User::where('id', $studentHistoryCheckList->user_id)->first();


        if ($student) {

            $studentMultiplicationCheck = StudentHistory::where('user_id', $student->id)->get('id', 'user_id');

            if (count($studentMultiplicationCheck) == 1) {
                if ($student->local_guardian_user_id) {
                    $guardianCount = User::where('local_guardian_user_id', $student->local_guardian_user_id)->get();
                    if (count($guardianCount) == 1) {
                        $guardian = User::where('id', $student->local_guardian_user_id)->first();
                        $guardian->status = 1;
                        $guardian->save();
                    }
                }


                $student->status = 1;
                $student->save();
            }
        }


        $studentHistoryCheckList->status = 1;
        $studentHistoryCheckList->save();


        return Response::json(['message' => 'Student Pause Successfully!', 'mode' => 'Update!']);
    }


    public function deleteSingleStudent(Request $request)
    {

        $studentHistoryCheckList = StudentHistory::where('id', $request->StudentHistoryID)->first();

        $check_exam_present = SiteExamDeclareStudent::where('student_history_id', $request->StudentHistoryID)
            ->first();
        if ($check_exam_present) {
            return Response::json(['message' => 'Sorry.! You can not delete this student from your database.
                This Student Information Present in Exam Section.
                After delete his/her info form exam then you can delete his info from database.', 'mode' => 'Error'], 412);
        }


        $check_class_attendance = StudentAttendance::where('student_history_id', $request->StudentHistoryID)
            ->first();

        if ($check_class_attendance) {
            return Response::json(['message' => 'Sorry.! You can not delete this student from your database.', 'mode' => 'Error'], 412);
        }


        $student = User::where('id', $studentHistoryCheckList->user_id)->first();


        if ($student) {

            if ($student->local_guardian_user_id) {
                $guardianCount = User::where('local_guardian_user_id', $student->local_guardian_user_id)->get();
                if (count($guardianCount) == 1) {
                    $guardian = User::where('id', $student->local_guardian_user_id)->first();
                    $guardian->status = 0;
                    $guardian->save();
                }
            }


            $student->delete();
        }


        $studentHistoryCheckList->delete();


        return Response::json(['message' => 'Student Delete Successfully!', 'mode' => 'Update!']);
    }

    /* public function getStudentListBySubject($classId, $sectionId, $attDate, $subjectId, Role $role, StudentClass $studentClass1, Section $section, Subject $subject)
     {
         $viewType = 'Student List';
         $studentClass = $studentClass1->findOrFail($classId);
         $studentSection = $section->findOrFail($sectionId);
         $studentSubject = $subject->findOrFail($subjectId);
         $locale = $this->chosenLanguage();
         $defaultLocale = $this->defaultLocale();
         $roleId = $this->role('Student');

         $roleOfStudent = $role->with('users')->findOrFail($roleId);


         $studentList = $roleOfStudent->users()
             ->whereStudentClassId($classId)
             ->whereSectionId($sectionId)
             //->whereSubjectGroupeId($subjectId)
             ->get();

         $studentAttendanceExist = (new Student())
             ->whereSectionId($sectionId)
             ->wherePresentTypeId($subjectId)
             ->wherePresentDate($attDate)
             ->first();

 //dd($studentSubject->id);
         $studentsWithPhotos = array();
         foreach ($studentList as $student) {

             if (count($student->photos) > 0)

                 $studentsWithPhotos[$student->photos->last()->name] = $student;
         }


         $Options = DB::table('Options')->get();

         if (request()->ajax()) {
             return view('default.admin.students.student-list-for-attendance', compact('viewType', 'studentAttendanceExist', 'studentsWithPhotos', 'locale', 'defaultLocale', 'attDate', 'studentClass', 'studentSection', 'Options', 'studentSubject'));
         }

         return view('default.admin.students.student-list-for-attendance', compact('viewType', 'studentAttendanceExist', 'studentsWithPhotos', 'locale', 'defaultLocale', 'attDate', 'studentClass', 'studentSection', 'Options', 'studentSubject'));

     }*/


    public function getClassForDepartment($departmentId, Department $department, Request $request)
    {
        $selectedDepertment = $department->findOrFail($departmentId);
        $classesForDept = $selectedDepertment->studentClasses;
        if ($request->ajax()) {
            return response()->json([$classesForDept]);
        }
    }








    /**
     * @param User $student
     * @param Requests\Validator $validatedRequest
     * @return bool
     */

    //    private function ownFieldsToSave(User $student, Requests\Validator $validatedRequest)
    //    {
    //
    //
    //        if (isset($student->studentFields)) {
    //
    //            foreach ($student->studentFields as $ownField) {
    //                if ($validatedRequest->{$ownField})
    //                    $student->{$ownField} = $validatedRequest->{$ownField};
    //            }
    //        }
    //
    //        $this->usernameToSave($student, $validatedRequest);
    //        //dd('ok');
    //        $this->passwordToSave($student, $validatedRequest);
    //
    //        if ($student->save()) {
    //
    //            return $student;
    //        }
    //
    //        return false;
    //    }

    /**
     * @param User $student
     * @param Requests\Validator $validatedRequest
     */
    private function passwordToSave(User $student, Requests\Validator $validatedRequest)
    {
        //dd($validatedRequest->get('username'));
        if ($validatedRequest->password == null) {

            $student->password = bcrypt(mt_rand(10000, 99999));
        }
    }


    private function usernameToSave(User $student, Requests\Validator $validatedRequest)
    {


        $sessionid = Session::get(SITE_ID);
        //dd($sessionid);
        $stdname = $validatedRequest->first_name_en;
        //dd($stdname);
        $siteinfos = new SiteInfo();
        $siteinfo = $siteinfos->findOrFail($sessionid);
        //dd($siteinfo);
        $countryid = $siteinfo->country_id;
        $divisionid = $siteinfo->division_id;
        $districtid = $siteinfo->district_id;
        $thanaid = $siteinfo->thana_id;
        $id = $siteinfo->id;

        $createusername = $countryid . $divisionid . $districtid . $thanaid . $id . $stdname;

        $user = new User();
        $usercheck = $user->where('username', $createusername)->first();

        if ($usercheck != null) {
            $usercheck1 = $createusername;

            $usercheck2 = '';

            for ($i = 0; $i < 1000; $i++) {

                $i += 1;
                $usercheck2 = $usercheck1 . $i;
                $usercheck3 = $user->where('username', $usercheck2)->first();
                if ($usercheck3) {
                    $i--;
                    continue;
                }
                break;
            }
            $student->username = $usercheck2;
            return;
        }
        $student->username = $createusername;
    }

    /**
     * @param User $user
     * @param Requests\Validator $validatedRequest
     * @return bool
     */
    private function translatedAttrToSave(User $user, Request $request)
    {
        //dd($validatedRequest->first_name);
        foreach ($user->translatedAttributes as $field) {
            foreach ($this->locales() as $locale => $value) {
                if ($request->get($field . '_' . $locale)) {
                    $user->translateOrNew($locale)->{$field} = $request->get($field . '_' . $locale);
                }
            }
        }
        //dd($user->first_name);

        if ($user->save()) {

            return true;
        }
        return false;
    }

    /**
     * @param User $student
     * @return mixed
     */
    private function newlyCreatedUser(User $student)
    {
        $newlyCreatedUser = $student->all()->last();
        return $newlyCreatedUser;
    }

    /**
     * @param User $student
     * @param Requests\Validator $validatedRequest
     */
    private function setRole(User $student, Requests\Validator $validatedRequest)
    {
        if ($validatedRequest->role) {
            $roleId = $validatedRequest->role;
            $student->roles()->attach($roleId);
        }
    }

    /**
     * @param User $student
     * @param Requests\Validator $validatedRequest
     * @param array $studentHistory
     */
    private function saveStudentHistory(User $student, Requests\Validator $validatedRequest, array $studentHistory = [])
    {
        // dd($student);
        $countArr = count($studentHistory);

        if (isset($student->studentHistoryFields)) {
            foreach ($student->studentHistoryFields as $studentHistoryField) {
                if ($validatedRequest->{$studentHistoryField})
                    $studentHistory[$studentHistoryField] = $validatedRequest->{$studentHistoryField};
            }
        }

        if (count($studentHistory) > $countArr) {
            $student->studentHistories()->create($studentHistory);
        }
    }


    /**
     * @param User $student
     * @param Requests\Validator $validatedRequest
     */
    private function savePhoto(Student $newlyCreatedUser, Request $request)
    {


        if ($request->student_image == "image-not.png") {
            $fileName = $request->student_image;
        } else {
            $name = time() . '.' . explode('/', explode(':', substr($request->student_image, 0, strpos($request->student_image, ';')))[1])[1];
            $fileName = $name;
            Image::make($request->student_image)->resize(440, 442)->save(public_path('uploads/') . $name);
        }

        $photo = new Photo();
        $photo->name = $fileName;
        $photo->path = '/uploads/' . $fileName;
        $photo->user_id = $newlyCreatedUser->id;
        $newlyCreatedUser->photo()->save($photo);
    }

    /**
     * @param User $student
     * @param Requests\Validator $validatedRequest
     */
    private function saveDocuments(User $student, Requests\Validator $validatedRequest)
    {
        if ($validatedRequest->file) :
            $filesExceptImage = $validatedRequest->file('file');
            foreach ($filesExceptImage as $file) {
                if ($file) :
                    $this->fileUpload($file, $student);
                endif;
            }
        endif;
    }

    /**
     * @param $file
     * @param $newlyCreatedUser
     */
    private function fileUpload($file, User $newlyCreatedUser)
    {
        $this->fileName = time() . str_random(3) . $file->getClientOriginalName();
        $this->extension = $file->getClientOriginalExtension();
        $destinationPath = public_path('uploads');
        $file->move($destinationPath, $this->fileName);
        $media = new Media();
        $media->name = $this->fileNameWithoutExtension($this->fileName);
        $media->extension = $this->extension;
        $media->user_id = $newlyCreatedUser->id;
        $newlyCreatedUser->files()->save($media);
    }


    /**
     * @param User $user
     * @param Requests\Validator $validatedRequest
     */
    private function saveExtraFields(User $user, Requests\Validator $validatedRequest)
    {
        $newFieldsForStudents = $user->getNewFieldsName('student');
        if (isset($newFieldsForStudents) && !empty($newFieldsForStudents)) {
            foreach ($newFieldsForStudents as $newStdField) {
                $addNewFields = new AddFieldToTable();
                if ($validatedRequest->{$newStdField})
                    $addNewFields->key = $newStdField;
                $addNewFields->value = $validatedRequest->{$newStdField};
                $user->addFieldsToTable()->save($addNewFields);
            }
        }
    }

    /**
     * get FileName without Extension
     * @param $fileName
     * @return string
     */
    private function fileNameWithoutExtension($fileName)
    {
        $ext = strtolower(substr($fileName, strrpos($fileName, '.') + 1));
        $fileNameWithoutExt = basename($fileName, '.' . $ext); // output: "youFileName" only

        return $fileNameWithoutExt;
    }

    public function getStudentEditForm($id, StudentForm $studentForm)
    {
        $viewType = 'Edit Student';
        $editStudent = $studentForm;
        $studentProfile = $this->editFormModel($this->student->findOrFail($id));
        return view('default.admin.students.edit', compact('studentProfile', 'viewType', 'editStudent'));
    }





    //
    //    public function editStudent($id, Requests\Validator $validatedRequest)
    //    {
    //        $studentProfile = $this->student->findOrFail($id);
    //        $isOwnFieldsSaved = $this->ownFieldsToSave($studentProfile, $validatedRequest);
    //        $isTranslatedFieldsSaved = $this->translatedAttrToSave($studentProfile, $validatedRequest);
    //        $basicUserInfoArr = [
    //            'user_id' => $studentProfile->id,
    //            'updated_at' => date('Y-m-d')
    //        ];
    //
    //        if ($isOwnFieldsSaved) {
    //
    //            if ($isTranslatedFieldsSaved) {
    //
    //                $this->saveStudentHistory(
    //                    $studentProfile,
    //                    $validatedRequest,
    //                    $basicUserInfoArr
    //                );
    //
    //                $this->savePhoto(
    //                    $studentProfile,
    //                    $validatedRequest
    //                );
    //
    //                $this->saveDocuments(
    //                    $studentProfile,
    //                    $validatedRequest
    //                );
    //                /*$this->updateExtraFields(
    //                    $studentProfile,
    //                    $validatedRequest
    //                );*/
    //                return redirect()->route('student-list')->withSuccess('Successfully Updated');
    //            }
    //        }
    //    }

    /**
     * @param User $user
     * @param Requests\Validator $validatedRequest
     */
    private function updateExtraFields(User $user, Requests\Validator $validatedRequest)
    {


        $newFieldsForStudents = $user->getNewFieldsName('student');
        if (isset($newFieldsForStudents) && !empty($newFieldsForStudents)) {
            foreach ($newFieldsForStudents as $newStdField) {
                if ($validatedRequest->{$newStdField}) {

                    if (count($user->addFieldsToTable) > 0) { //update
                        foreach ($user->addFieldsToTable as $value) {

                            // dd($validatedRequest->{$newStdField});


                            //    $addNewFields->value = $validatedRequest->{$newStdField};
                            $user->addFieldsToTable()->update(['key' => $validatedRequest->{$newStdField}]);

                            //  $user->addFieldsToTable()->update(['value']));


                        }
                    } else {
                        $addNewFields = new AddFieldToTable();
                        if ($validatedRequest->{$newStdField})
                            $addNewFields->key = $newStdField;
                        $addNewFields->value = $validatedRequest->{$newStdField};
                        $user->addFieldsToTable()->save($addNewFields);
                    }


                    /*   $addNewFields = new AddFieldToTable();
                    $addNewFields->key = $newStdField;
                       $addNewFields->value = $validatedRequest->{$newStdField};
                       $user->addFieldsToTable()->save($addNewFields);*/
                }
            }
        }
    }

    /**
     * @param $id
     * @return $this
     */
    public function deleteStudent($id)
    {
        $studentToDelete = $this->student->findOrFail($id);
        if ($studentToDelete->delete()) {
            return back()->withSuccess('Successfully Deleted');
        }

        return back()->withErrors('Not Successfully Deleted');
    }

    public function idCardPage()
    {
        $viewType = 'Get Student Id Card';
        return view('default.admin.students.student-id-card', compact('viewType'));
    }

    public function studentOfSection($sectionId, User $user, Section $section, Request $request)
    {
        $selectedSection = $section->findOrFail($sectionId);
        $studentForSection = $selectedSection->users;
        //dd($selectedSection);
        if ($request->ajax()) {
            return response()->json([$studentForSection]);
        }
    }

    public function studentIdCard($studentClassId, $sectionId, $studentId, User $user, StudentClass $studentClass, SiteInfo $siteInfo)
    {
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $siteId = request()->user()->site_id;
        $siteData = $siteInfo->findOrFail($siteId);
        //        dd($siteData);
        //        dd($siteData->site_name);

        $file_name = 'id_card.txt';
        $base_path = base_path('reports/default/en/');
        $studentData = $user->with('photos')->findOrFail($studentId);
        $guardianId = $studentData->guardian_id;
        $guardianData = $this->student->findOrFail($guardianId);
        $classData = $studentClass->findOrFail($studentClassId);
        //dd($classData->class_name);
        $studentData = $user->with('photos')->findOrFail($studentId);
        // $studentPhoto = \Html::image('imagecache/dummy/'.$studentData->photo->last()->name);
        $studentPhoto = "/imagecache/dummy/" . $studentData->photo->last()->name;
        // dd($studentPhoto);
        $student_extra_data = array();
        $student_extra_data['guardian_first_name'] = $guardianData->first_name;
        $student_extra_data['guardian_last_name'] = $guardianData->last_name;
        $student_extra_data['class_name'] = $classData->class_name;
        $student_extra_data['site_name'] = $siteData->site_name;
        $student_extra_data['site_address'] = $siteData->address;
        $student_extra_data['studentPhoto'] = $studentPhoto;
        //dd($studentData);
        $rep_key = array("username", "roll_no", "first_name", "last_name", "guardian_first_name", "guardian_last_name", "phone", "class_name", "site_name", "site_address", "studentPhoto");
        if (file_exists($base_path . $file_name)) {
            $content = file_get_contents($base_path . $file_name);
        } else {
            $content = file_get_contents($base_path . $file_name);
        }
        if (isset($rep_key) && !empty($rep_key)) {
            foreach ($rep_key as $key) {
                if (isset($studentData->{$key})) {
                    $content = str_replace("%%{$key}%%", $studentData->{$key}, $content);
                } else {
                    if (isset($student_extra_data[$key])) {
                        $content = str_replace("%%{$key}%%", $student_extra_data[$key], $content);
                    }
                }
            }
        }
        return $content;
    }

    public
    function admitCardPage()
    {
        $viewType = 'Get Admit Card';

        return view('default.admin.students.student-admit-card', compact('viewType'));
    }

    public
    function studentAdmitCard($examinationId, $studentClassId, $sectionId, $studentId, User $user, StudentClass $studentClass, Examination $examination, SiteInfo $siteInfo)
    {
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();

        $siteId = request()->user()->site_id;
        $siteData = $siteInfo->findOrFail($siteId);
        //        dd($siteData);

        $file_name = 'admit_card.txt';
        $base_path = base_path('reports/default/en/');

        $studentData = $user->with('photos')->findOrFail($studentId);
        // $studentPhoto = \Html::image('imagecache/dummy/'.$studentData->photo->last()->name);
        $studentPhoto = "/imagecache/dummy/" . $studentData->photo->last()->name;
        // dd($studentPhoto);
        $classData = $studentClass->findOrFail($studentClassId);
        $examData = $examination->findOrFail($examinationId);
        //dd($examData->examination_name);
        //dd($classData->class_name);
        $student_extra_data = array();
        $student_extra_data['examination_name'] = $examData->examination_name;
        $student_extra_data['class_name'] = $classData->class_name;
        $student_extra_data['studentPhoto'] = $studentPhoto;
        $student_extra_data['site_name'] = $siteData->site_name;
        //dd($studentData);
        $rep_key = array("username", "roll_no", "first_name", "last_name", "father_name", "mother_name", "examination_name", "phone", "class_name", "studentPhoto", "site_name");
        if (file_exists($base_path . $file_name)) {
            $content = file_get_contents($base_path . $file_name);
        } else {
            $content = file_get_contents($base_path . $file_name);
        }
        if (isset($rep_key) && !empty($rep_key)) {
            foreach ($rep_key as $key) {
                if (isset($studentData->{$key})) {
                    $content = str_replace("%%{$key}%%", $studentData->{$key}, $content);
                } else {
                    if (isset($student_extra_data[$key])) {
                        $content = str_replace("%%{$key}%%", $student_extra_data[$key], $content);
                    }
                }
            }
        }
        return $content;
    }

    public
    function testimonialPage()
    {
        $viewType = 'Get Testimonial';
        return view('default.admin.students.testimonial', compact('viewType'));
    }

    public
    function studentTestimonial($studentClassId, $sectionId, $studentId, User $user, StudentClass $studentClass, SiteInfo $siteInfo)
    {
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();

        $siteId = request()->user()->site_id;
        $siteData = $siteInfo->findOrFail($siteId);
        //        dd($siteData);

        $file_name = 'testimonial.txt';
        $base_path = base_path('reports/default/en/');
        $studentData = $user->with('photos')->findOrFail($studentId);
        $guardianId = $studentData->guardian_id;
        $guardianData = $this->student->findOrFail($guardianId);
        $classData = $studentClass->findOrFail($studentClassId);
        //dd($classData->class_name);
        $today = \Carbon\Carbon::now()->format('Y-m-d');
        $student_extra_data = array();
        $student_extra_data['guardian_first_name'] = $guardianData->first_name;
        $student_extra_data['guardian_last_name'] = $guardianData->last_name;
        $student_extra_data['student_address'] = $studentData->address;
        $student_extra_data['class_name'] = $classData->class_name;
        $student_extra_data['site_name'] = $siteData->site_name;
        $student_extra_data['site_address'] = $siteData->address;
        $student_extra_data['site_email'] = $siteData->site_email;
        $student_extra_data['site_phone'] = $siteData->site_phone;
        $student_extra_data['today'] = $today;
        //dd($studentData);
        $rep_key = array("username", "roll_no", "first_name", "last_name", "father_name", "mother_name", "birthday", "phone", "class_name", "today", "student_address", "site_name", "site_address", "site_email", "site_phone");
        if (file_exists($base_path . $file_name)) {
            $content = file_get_contents($base_path . $file_name);
        } else {
            $content = file_get_contents($base_path . $file_name);
        }
        if (isset($rep_key) && !empty($rep_key)) {
            foreach ($rep_key as $key) {
                if (isset($studentData->{$key})) {
                    $content = str_replace("%%{$key}%%", $studentData->{$key}, $content);
                } else {
                    if (isset($student_extra_data[$key])) {
                        $content = str_replace("%%{$key}%%", $student_extra_data[$key], $content);
                    }
                }
            }
        }
        return $content;
    }

    public
    function tcPage()
    {
        $viewType = 'Get TC';
        return view('default.admin.students.tc', compact('viewType'));
    }

    public
    function studentTc($applicationSubject, $studentClassId, $sectionId, $studentId, User $user, StudentClass $studentClass)
    {
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();

        $file_name = 'tc.txt';
        $base_path = base_path('reports/default/en/');
        $studentData = $user->with('photos')->findOrFail($studentId);
        $guardianId = $studentData->guardian_id;
        $guardianData = $this->student->findOrFail($guardianId);
        $classData = $studentClass->findOrFail($studentClassId);
        //dd($classData->class_name);
        $today = \Carbon\Carbon::now()->format('Y-m-d');
        $student_extra_data = array();
        $student_extra_data['guardian_first_name'] = $guardianData->first_name;
        $student_extra_data['guardian_last_name'] = $guardianData->last_name;
        $student_extra_data['class_name'] = $classData->class_name;
        $student_extra_data['today'] = $today;
        $student_extra_data['application_subject'] = $applicationSubject;
        //dd($studentData);
        $rep_key = array("username", "roll_no", "first_name", "last_name", "father_name", "mother_name", "address", "birthday", "phone", "class_name", "today", "application_subject");
        if (file_exists($base_path . $file_name)) {
            $content = file_get_contents($base_path . $file_name);
        } else {
            $content = file_get_contents($base_path . $file_name);
        }
        if (isset($rep_key) && !empty($rep_key)) {
            foreach ($rep_key as $key) {
                if (isset($studentData->{$key})) {
                    $content = str_replace("%%{$key}%%", $studentData->{$key}, $content);
                } else {
                    if (isset($student_extra_data[$key])) {
                        $content = str_replace("%%{$key}%%", $student_extra_data[$key], $content);
                    }
                }
            }
        }
        return $content;
    }

    public
    function clearancePage()
    {
        $viewType = 'Get Clearance';
        return view('default.admin.students.clearance', compact('viewType'));
    }

    public
    function studentClearance($studentClassId, $sectionId, $studentId, User $user, StudentClass $studentClass)
    {
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();

        $file_name = 'clearance.txt';
        $base_path = base_path('reports/default/en/');
        $studentData = $user->with('photos')->findOrFail($studentId);
        $guardianId = $studentData->guardian_id;
        $guardianData = $this->student->findOrFail($guardianId);
        $classData = $studentClass->findOrFail($studentClassId);
        //dd($classData->class_name);
        $today = \Carbon\Carbon::now()->format('Y-m-d');
        $student_extra_data = array();
        $student_extra_data['guardian_first_name'] = ucwords($guardianData->first_name);
        $student_extra_data['guardian_last_name'] = ucwords($guardianData->last_name);
        $student_extra_data['class_name'] = $classData->class_name;
        $student_extra_data['today'] = $today;
        //dd($studentData);
        $rep_key = array("username", "roll_no", "first_name", "last_name", "father_name", "mother_name", "address", "birthday", "phone", "class_name", "today");
        if (file_exists($base_path . $file_name)) {
            $content = file_get_contents($base_path . $file_name);
        } else {
            $content = file_get_contents($base_path . $file_name);
        }
        if (isset($rep_key) && !empty($rep_key)) {
            foreach ($rep_key as $key) {
                if (isset($studentData->{$key})) {
                    $content = str_replace("%%{$key}%%", $studentData->{$key}, $content);
                } else {
                    if (isset($student_extra_data[$key])) {
                        $content = str_replace("%%{$key}%%", $student_extra_data[$key], $content);
                    }
                }
            }
        }
        return $content;
    }

    public
    function certificationPage()
    {
        $viewType = 'Get Certification';
        return view('default.admin.students.certification', compact('viewType'));
    }

    public
    function studentCertification($studentClassId, $sectionId, $studentId, User $user, StudentClass $studentClass, SiteInfo $siteInfo)
    {
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();

        $siteId = request()->user()->site_id;
        $siteData = $siteInfo->findOrFail($siteId);

        $file_name = 'certification.txt';
        $base_path = base_path('reports/default/en/');
        $studentData = $user->with('photos')->findOrFail($studentId);
        $guardianId = $studentData->guardian_id;
        $guardianData = $this->student->findOrFail($guardianId);
        $classData = $studentClass->findOrFail($studentClassId);
        //dd($classData->class_name);
        $today = \Carbon\Carbon::now()->format('Y-m-d');
        $student_extra_data = array();
        $student_extra_data['guardian_first_name'] = ucwords($guardianData->first_name);
        $student_extra_data['guardian_last_name'] = ucwords($guardianData->last_name);
        $student_extra_data['class_name'] = $classData->class_name;
        $student_extra_data['site_name'] = $siteData->site_name;
        $student_extra_data['site_address'] = $siteData->address;
        $student_extra_data['today'] = $today;
        //dd($studentData);
        $rep_key = array("username", "roll_no", "first_name", "last_name", "father_name", "mother_name", "address", "birthday", "phone", "class_name", "today", "site_name", "site_address");
        if (file_exists($base_path . $file_name)) {
            $content = file_get_contents($base_path . $file_name);
        } else {
            $content = file_get_contents($base_path . $file_name);
        }
        if (isset($rep_key) && !empty($rep_key)) {
            foreach ($rep_key as $key) {
                if (isset($studentData->{$key})) {
                    $content = str_replace("%%{$key}%%", $studentData->{$key}, $content);
                } else {
                    if (isset($student_extra_data[$key])) {
                        $content = str_replace("%%{$key}%%", $student_extra_data[$key], $content);
                    }
                }
            }
        }
        return $content;
    }


    public function getStudentListReport(Request $requests)
    {


        try {

            $page_tittle = "Student List Report";
            $report_tittle = "<b>Student List Report</b> <br/>";
            $report_tittle2 = "";


            $search_txt = $requests->search_txt;
            $txt = '%' . $search_txt . '%';


            $data = [];
            $data['academic_version_id'] = $requests->academic_version_id == 'null' ? null : $requests->academic_version_id;
            $data['academic_year_id'] = $requests->academic_year_id == 'null' ? null : $requests->academic_year_id;
            $data['academic_shift_id'] = $requests->academic_shift_id == 'null' ? null : $requests->academic_shift_id;
            $data['academic_department_id'] = $requests->academic_department_id == 'null' ? null : $requests->academic_department_id;
            $data['academic_class_id'] = $requests->academic_class_id == 'null' ? null : $requests->academic_class_id;
            $data['academic_section_id'] = $requests->academic_section_id == 'null' ? null : $requests->academic_section_id;
            $data['academic_class_group_id'] = $requests->academic_class_group_id == 'null' ? null : $requests->academic_class_group_id;
            $data['academic_session_id'] = $requests->academic_session_id == 'null' ? null : $requests->academic_session_id;
            $data['site_batch_detail_id'] = $requests->site_batch_detail_id == 'null' ? null : $requests->site_batch_detail_id;
            $data['academic_admission_type_id'] = $requests->academic_admission_type_id == 'null' ? null : $requests->academic_admission_type_id;
            $data['academic_student_category_id'] = $requests->academic_student_category_id == 'null' ? null : $requests->academic_student_category_id;
//return $data;
            if (!$data['academic_year_id'] || !$data['academic_version_id'] || !$data['academic_shift_id']) {
                return "Please select Version Or Year Or Shift";
            }

             $student_list = StudentHistory::select(
                'id',
                'user_id',
                'academic_version_id',
                'academic_year_id',
                'academic_shift_id',
                'academic_class_id',
                'site_batch_detail_id',
                'academic_section_id',
                'academic_department_id',
                'academic_class_group_id',
                'academic_session_id',
                'compulsory_subject_ids',
                'student_roll_number_prefix',
                'student_roll_number',
                'optional_subject_ids',
                'selective_markingless_subject_ids'
            )
                ->with(['version', 'year', 'shift', 'section', 'stClass', 'student.religion', 'student.gender', 'student.latestPhoto'])
                ->whereHas('student', function ($query) use ($search_txt, $txt) {
                    $query->where('user_type', 'student')
                        ->when($search_txt, function ($q) use ($txt) {
                            return $q->where(function ($query) use ($txt) {
                                $query->where('username', 'LIKE', $txt)
                                    ->orWhere('email', 'LIKE', $txt)
                                    ->orWhere('contact_number', 'LIKE', $txt)
                                    ->orWhereTranslationLike('first_name', $txt)
                                    ->orWhereTranslationLike('last_name', $txt);
                            });
                        })->select('id', 'religion_id', 'gender_id', 'biometric_id', 'username');
                })
                ->where('academic_version_id', $requests->academic_version_id)
                ->where('academic_year_id', $requests->academic_year_id)
                ->where('academic_shift_id', $requests->academic_shift_id)
                ->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                    return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
                })
                ->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when($data['academic_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_admission_type_id']);
                })
                ->when($data['academic_student_category_id'], function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->where('status', $requests->status)
                ->orderBy('student_roll_number', 'ASC')
                ->get();

                $student_list->transform(function ($student) {
                    $student->optional_subject_name = $student->optional_subject_ids[0][0]->subject_name	 ?? null;
                    return $student;
                });





            if (count($student_list) < 1) {
                throw new Exception('No Data Found!');
            }


            //  dd($student_list[0]);

            $report_tittle2 .= '<b>Version:</b>' . ($student_list[0]->version->version_name ?? 'n/a');
            $report_tittle2 .= '<b> Year:</b>' . ($student_list[0]->year->year_name ?? 'n/a');
            $report_tittle2 .= ' <b> Shift:</b>' . ($student_list[0]->shift->shift_name ?? 'n/a');

            if ($data['academic_department_id'] && $student_list[0]->department) {
                $report_tittle2 .= ' <b>Dept:</b>' . ($student_list[0]->department->name ?? 'n/a');
            }


            if ($data['academic_class_id'] && $student_list[0]->stClass) {
                $report_tittle2 .= ' <b>Class:</b>' . ($student_list[0]->stClass->class_name ?? 'n/a');
            }


            if ($data['academic_class_group_id'] && $student_list[0]->classGroup) {
                $report_tittle2 .= ' <b>Group:</b>' . ($student_list[0]->classGroup->group_name ?? 'n/a');
            }

            if ($data['academic_section_id'] && $student_list[0]->section) {
                $report_tittle2 .= ' <b>Section:</b>' . ($student_list[0]->section->section_name ?? 'n/a');
            }


            // return view('default.site.student.report.list-report', compact('student_list', 'page_tittle', 'report_tittle', 'report_tittle2'));
            $site = getSiteInfoForPdf();
            if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.report.list-report')) {
                $view = View::make('report-test', compact('student_list', 'page_tittle', 'report_tittle', 'report_tittle2', 'site'));
//                $pdf = \PDF::loadView(Session::get('ALIAS1') . '.student.report.list-report', compact('student_list', 'page_tittle', 'report_tittle', 'report_tittle2'));
            } else {
                $view = View::make('default.site.student.report.list-report', compact('student_list', 'page_tittle', 'report_tittle', 'report_tittle2', 'site'));
            }

            $view = View::make('default.site.student.report.list-report', compact('student_list', 'page_tittle', 'report_tittle', 'report_tittle2', 'site'));


            $contents = $view->render();
//            return $contents;
            $mpdf = new \Mpdf\Mpdf();
            $mpdf->autoScriptToLang = true;
            $mpdf->autoLangToFont = true;
            $mpdf->allow_charset_conversion = false;
            $mpdf->WriteHTML($contents);
            $mpdf->Output();
            return $contents;
            //$pdf->set_option("isPhpEnabled", true);
//            return $pdf->stream(time() . '-student-list.pdf');
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }
}
