<?php

namespace App\Http\Controllers\Timetable;


use App\Models\Site\Routine\ClassTiming;
use App\Models\Site\Routine\ClassTimingDetail;
use App\Models\Site\Routine\RoutineDetail;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Forms\ClassTimingDetailsForm;
use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use Illuminate\Validation\ValidationException;
use Response;


class ClassTimingDetailsController extends ProjectController
{
    use Lang, FormControll;

    private $classTimingDetail;
    private $classTiming;
    private $fileName;
    private $extension;

    private $routineDetail;


    /**
     * StudentController constructor.
     * @param ClassTimingDetail $classTimingDetail
     */
    public function __construct(RoutineDetail $routineDetail, ClassTiming $classTiming, ClassTimingDetail $classTimingDetail)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->classTimingDetail = $classTimingDetail;
        $this->classTiming = $classTiming;
        $this->routineDetail = $routineDetail;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id)
    {
        $viewType = 'Class Timing Details List';
        $classTiming = $this->classTiming->findOrFail($id);
        return view('default.admin.class-timing-details.index', compact('classTiming', 'viewType'));

    }


    public function getClassTimingDetailsList($id)
    {
        $classTiming = $this->classTiming->findOrFail($id);
        $classTimingDetails = $this->classTimingDetail->whereClassTimingId($id)->orderBy('start_time', 'ASC')->get();
        return [$classTiming, $classTimingDetails];
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
        $viewType = 'Class Timing Details List';
        $classTiming = $this->classTiming->findOrFail($id);


        return view('default.admin.class-timing-details.create', compact('classTiming', 'viewType'));
    }


    public function store(ClassTimingDetail $classTimingDetail, Request $validatedRequest, $id)
    {
        try {

            $this->validate($validatedRequest, [
                'name' => 'required',
                'start_time' => 'required',
                'end_time' => 'required'

            ]);

            $classTimingDetail->class_timing_id = $id;
            $classTimingDetail->name = $validatedRequest->name;
            $classTimingDetail->start_time = $validatedRequest->start_time;
            $classTimingDetail->end_time = $validatedRequest->end_time;
            $classTimingDetail->is_break = $validatedRequest->is_break;

            $classTimingDetail->save();
            return Response::json(['message' => 'Save Successfully!'], 200);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function getClassTimingDetailsEditForm($id, ClassTimingDetailsForm $classTimingDetailsForm)
    {
        $viewType = 'Edit Class Timing Details';
        $editClassTimingDetails = $classTimingDetailsForm;
        $classTimingDetailsData = $this->editFormModel($this->classTimingDetail->findOrFail($id));


        return view('default.admin.class-timing-details.edit', compact('viewType', 'editClassTimingDetails', 'classTimingDetailsData'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return JsonResponse
     */
    public function update(Request $request, $id)
    {
        try {

            $classTimingDetailsToEdit = $this->classTimingDetail->findOrFail($id);
            $classTimingDetailsToEdit->name = $request->get('name');
            $classTimingDetailsToEdit->start_time = $request->get('start_time');
            $classTimingDetailsToEdit->end_time = $request->get('end_time');
            $classTimingDetailsToEdit->is_break = $request->get('is_break');
            $classTimingDetailsToEdit->save();

            return Response::json(['message' => 'Update Successfully!'], 200);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }


    public function destroy($id)
    {
        try {

            $existed = $this->routineDetail->where('class_timing_details_id', $id)->first();
            if ($existed) {
                return Response::json(['message' => 'This Time Already is used in routine!'], 422);
            }

            $classTimingDetailsToDelete = $this->classTimingDetail->findOrFail($id);

            if ($classTimingDetailsToDelete->delete()) {
                return Response::json(['message' => 'Successfully Deleted'], 200);
            }
            return Response::json(['message' => 'Not Deleted']);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }


}
