<?php

namespace App\Http\Middleware;

use Auth;
use Carbon\Carbon;
use Closure;
use Illuminate\Contracts\Auth\Guard;
use Request;
use Response;
use Route;

class EduStudentTransactionCheck
{

    private $auth;
    public function __construct(Guard $auth)
    {
        $this->auth = $auth;
    }


    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
//        return $next($request);


        if (Auth::check()) {
            $current_route=Route::current()->getName();


            if($this->auth->user()->user_type=='student'){

                if(!$this->auth->user()->student_edu_payment_status){
                    $today=Carbon::today();
                    if($this->auth->user()->edu_student_panel_close_date < $today){


                        if($current_route =='student-transaction-master-form'
                            || $current_route =='user-notification-get-notifications'
                            || $current_route =='get-student-edu-invoice-list-for-transaction'
                            || $current_route =='get-online-payment-method-list-for-transaction'
                            || $current_route =='get-payment-base-page-for-transaction'
                            || $current_route =='get-nagad-edu-callback-website')
                        {
                            return $next($request);

                        }
                        else{

                            if ($request->ajax() || $request->isJson()) {
                                return response()->json(['message' => "Your panel is blocked. Please Pay " .
                                    '<a href="' . Request::root()."/student/transaction/master" . '">
                                        <button style="color:white;background-color:blue"> Click Hear </button></a>'] , 401);
                            }
                            else {

                                return Response::make(view('default.admin.layouts.master',
                                    ['viewType' => "Your panel is blocked. Please Pay " .
                                        '<a href="' . Request::root()."/student/transaction/master" . '">
                                            <button style="color:white;background-color:blue"> Click Hear </button></a>']));

                            }

                        }


                    }

                }

            }

        }


        return $next($request);






    }





}
