<?php

namespace App\Http\Middleware;

use App\Models\Academic\AcademicGroup;
use App\Models\Company\GlobalCompany;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\GlobalSiteGroupSetting;
use Auth;
use Closure;
use DB;
use http\Env;
use Illuminate\Support\Facades\Session;
use Response;
use Route;

class MySite
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        //  app()->setLocale($request->user()->locale);
        //dd(\App::getLocale());

        $url = parse_url($request->url());

      //  \Config::set('app.url', $url['scheme'] . '://' . $url['host']);
        \Config::set('app.url', 'https' . '://' . $url['host']);

        //dd(Session::get('LOGO_PATH'));

        //\Log::info(Auth::check());

        //   Session::flush();

//dd(Session::get('ACADEMIC_GROUP_ID'));


        if (Auth::check()) {
            if (!Session::get('ALIAS') || !Session::get('ALIAS1') || !Session::get('ACADEMIC_GROUP_ID') || !Session::get('USER_TYPE') || !Session::get('LOGO_PATH')) {
                $domain = "";
                if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
                    $getHost = explode(".", $_SERVER['HTTP_HOST']);
                    $domain = array_shift($getHost);
                }

                $edu = ['eduworld', 'eduworlderp', 'eduworldapp','artshop'];

                if (in_array($domain, $edu)) {
                    Session::put('USER_TYPE', 'eduworld');
                    Session::put('ALIAS', 'eduworld');
                    Session::put('ALIAS1', 'eduworld');//for saving user
                    Session::put('LOGO_PATH', 'image/edu.png');


                } else {//site_group or site
//                \Log::info(!Session::get('SITE_ID'));

                    //  if (!Session::get('SITE_ID') || !Session::get('ALIAS') || !Session::get('ALIAS1') || !Session::get(SITE_ID) || !Session::get('USER_TYPE') || !Session::get('FULL_NAME')) {
                    $site_info = SiteInfo::where('site_alias', $domain)->first();

                    if ($site_info) {//site
                        $s_settings = $site_info->siteInfoSettings()->get();
                        $s_setting = $s_settings->first();

                        $user_last_acc_group_id = Auth::user()->last_academic_group_id ?? Auth::user()->academic_group_id ?? $s_setting->academic_group_id;


                        //dd($user_last_acc_group_id);

                        $academic_group_name = $s_settings->where('academic_group_id', $user_last_acc_group_id)->first()->academicGroup->academic_group_name;

                        Session::put('SITE_ID', $site_info->id);

                        Session::put('ACADEMIC_GROUP_ID', $user_last_acc_group_id ?? 0);
                        Session::put('ACADEMIC_GROUP_NAME', $academic_group_name ?? 0);

                        // dd($s_setting);

                        Session::put('ALIAS', $site_info->site_alias);
                        Session::put('ALIAS1', $site_info->site_alias);//for saving user

                        Session::put('USER_TYPE', 'site');
                        Session::put('FULL_NAME', $site_info->site_name);
                        Session::put('LOGO_PATH', $site_info->site_logo);
                        Session::save();


                    } else if ($site_group = DB::table('site_groups')->where('group_alias', $domain)->first()) {//site_group
                        Session::put('SITE_GROUP_ID', $site_group->id);
                        Session::put('ALIAS', $site_group->group_alias);
                        Session::put('ALIAS1', $site_group->group_alias);//for saving user
                        Session::put('USER_TYPE', 'site_group');
                        Session::put('FULL_NAME', $site_group->name);
                        Session::put('LOGO_PATH', 'img/site_group/logo/' . $site_group->group_logo);

                        $get_acc_group = GlobalSiteGroupSetting::where('site_group_id', Session::get('SITE_GROUP_ID'))->first();
                        if ($get_acc_group) {
                            $acc_gr = AcademicGroup::where('id', $get_acc_group->academic_group_id)->first();
                            Session::put('ACADEMIC_GROUP_ID', $acc_gr->id ?? 0);
                            Session::put('ACADEMIC_GROUP_NAME', $acc_gr->academic_group_name ?? 0);

                        }

                    } else if ($company = GlobalCompany::where('alias', $domain)->first()) {//company

                        Session::put('COMPANY_ID', $company->id);
                        Session::put('ALIAS', $company->alias);
                        Session::put('ALIAS1', $company->alias);
                        Session::put('USER_TYPE', 'company');
                        Session::put('FULL_NAME', $company->name);
                        Session::put('LOGO_PATH', 'img/company/' . $company->logo);

                    }
                }

                //save
            }
        }


        //  0.1 checek site in not on hold

        //  dd( Session::driver()->getId());
        //  Session::forget('G4CkAysQ3KPZjnC5ALYFxwFHEwDqeP0S4C8mBEhY');

        $currentRoute = Route::getRoutes()->match($request)->getName();
        if (Auth::check() && Session::get('USER_TYPE') == 'site' && $currentRoute != 'log-out') {

            if (Session::get('SITE_STATUS') != 0 || !Session::get('SITE_STATUS_REASON')) {
                $site_info = SiteInfo::where('id', Session::get('SITE_ID'))->first();
                Session::put('SITE_STATUS', $site_info->status);
                Session::put('SITE_STATUS_REASON', $site_info->reason);
            }

            if (!Session::get('SITE_STATUS')) {
                return Response::make(view('default.no-permission', [
                    'message' => Session::get('SITE_STATUS_REASON'),
                    'title' => 'Site On Hold!',
                    'viewType' => 'Site On Hold!'
                ]), 401);
            }

        }


        return $next($request);
    }
}


/*
if(isset($_GET['test'])){
    if($_GET['test'] == 'test'){
        $test = Artisan::call('migrate', [
            '--force' => true,
        ]);
        var_dump($test);
        die();
    }
}*/