<?php

namespace App\Http\Middleware;

use Closure;
use Response;
use Route;
use Session;

class SiteGroupPageCheckerMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        $user_type = Session::get('USER_TYPE');

        $site_group_id = Session::get('SITE_GROUP_ID');
        $acc_gr_id = Session::get('ACADEMIC_GROUP_ID');

       // dd($site_group_id, $acc_gr_id);

        if ($user_type == 'site') {
            if ($request->ajax() || $request->isJson()) {
                return Response::json(['message' => 'Don"t have site group id or acc group'], 401);
            } else {
                return Response::make(view('default.no-permission', [
                    'message' => 'Don"t have site id or acc group',
                    'title' => 'Don"t have site id or acc group',
                    'viewType' => 'Don"t have site id or acc group'
                ]), 401);
            }
        }
        /*
                if ($user_type == 'site_group') {
                    if ($request->ajax() || $request->isJson()) {
                        return Response::json(['message' => 'Don"t have site group id or acc group'], 401);
                    } else {
                        return Response::make(view('default.no-permission', [
                            'message' => 'Don"t have site id or acc group',
                            'title' => 'Don"t have site id or acc group',
                            'viewType' => 'Don"t have site id or acc group'
                        ]), 401);
                    }
                }*/


        if ($site_group_id && $acc_gr_id) {
            return $next($request);

        } else {

            if ($user_type == 'site_group') {

                if ($request->ajax() || $request->isJson()) {
                    return Response::json(['message' => 'Don"t have site group id or acc group'], 401);
                } else {
                    return Response::make(view('default.no-permission', [
                        'message' => 'Don"t have site id or acc group',
                        'title' => 'Don"t have site id or acc group',
                        'viewType' => 'Don"t have site id or acc group'
                    ]), 401);
                }
            }
            $currentRoute = Route::getRoutes()->match($request)->getName();
            Session::put('redirect_route', $currentRoute);
            return redirect()->route('site-group-impersonate-form');
        }


    }
}
