<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;
use App\UserTranslation;
use App\Forms\FormControll;
use Illuminate\Support\Facades\Config;

class Validator extends Request
{
    use FormControll;

    private $formToValidate;
    private $formToValidateObject;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * get the validation rules that applies to the request.
     *
     * @return rules in array
     */

    public function rules()
    {
        $rules = [];
        $defaultLocale = config('app.fallback_locale');
        $locales = config('app.locales');

        if(!is_null($this->fieldName()) && !is_null($this->get($this->fieldName())) ){

            $this->formToValidate = $this->get($this->fieldName());

            $this->formToValidateObject = new $this->formToValidate;
        }

        foreach($this->formToValidateObject->filteredForm($this->id) as $field){

            if(isset($field['name']) && isset($field['validation']) && (isset($field['trans']) && ($field['trans']== false) || !isset($field['trans']) )){
                $rules[$field['name']]= $field['validation'];
            }

            if(isset($field['name']) && isset($field['validation']) && isset($field['trans']) && $field['trans']==true  ){

                foreach($locales as $locale => $value){
                    if($locale == $defaultLocale){
                         $rules[$field['name'].'_'.$locale]= $field['validation'];
                     }else{
                         $fieldValidation = explode('|',$field['validation']);
                         $key = array_search('required',$fieldValidation);
                         unset($fieldValidation[$key]);
                         $rules[$field['name'].'_'.$locale]= implode('|',$fieldValidation);
                     }
                }
            }
        }
    //dd($rules);

       return $rules ;
    }
}


\Validator::extend('uniqueWithSiteId', function ($attribute, $value, $parameters, $validator) {


   // dd($parameters );

    $count = \DB::table($parameters[0])->where($attribute, $value)
        ->where('site_id', session()->get(SITE_ID))
        ->count();

    return $count === 0;
});


\Validator::replacer('uniqueWithSiteId', function($message, $attribute, $rule, $parameters){
    //dd($parameters);
    $split=  preg_split("/[_]+/", $attribute);
    $string=implode(' ',$split);
    //dd($jj);
    $message=$string." is duplicate";

    return str_replace('', $parameters[0], $message);
});















