<?php

namespace App\Imports\Edu;

use App\Models\Academic\AcademicEducationLevel;
use App\Models\Academic\AcademicInstituteManagementType;
use App\Models\District\District;
use App\Models\Division\Division;
use App\Models\Edu\NonSite\AllInstituteList;
use App\Models\Edu\NonSite\AllInstituteListExcel;
use App\Models\Gender\Gender;
use App\Models\Thana\Thana;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class NonSiteEntryImport implements ToModel, WithHeadingRow
{
    /**
    * @param Collection $collection
    */
    private $rows = 0;
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */


    public function model(array $row)
    {

    //                ++$this->rows;
            if($row['name']){
                return new AllInstituteListExcel([
                    'division' => $row['division'],
                    'district' => $row['district'],
                    'thana' => $row['upazila_thana'],
                    'eiin' => $row['eiin'],
                    'institution_name' => $row['name'],
                    'academic_education_level' => $row['edu_level'],
                    'academic_institute_management_type' =>$row['management'],
                    'institution_mobile' => $row['mobile'],
                    'institution_email' => strtolower(str_replace(' ', '', $row['email'])),
                    'gender' => $row['stud_type'],
                ]);
            }

    }


    public function getRowCount(): int
    {
        return $this->rows;
    }



}
