<?php

namespace App\Jobs\site;

use App\Models\Site\Role\GlobalSiteRole;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Notifications\Site\GlobalStudentPaymentHistoryNotification;
use App\User;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\Notification;

class GlobalPaymentHistoryJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public $tries = 1;

    protected $payment_history_details;

    public function __construct($payment_history_details)
    {
        $this->payment_history_details = $payment_history_details;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {

            $user = GlobalStudentHistory::where('id', $this->payment_history_details->student_history_id)->first();

            $user_role = GlobalSiteRole::with('users')->where('site_id',$user->site_id)->where('name', 'admin')->first();
            $admin_user_details =  $user_role->users;
            $admin_user_id =  $admin_user_details[0]->id;

            $id = [$admin_user_id, $user->user_id];

            $users = User::whereIn('id', $id)->get();

            $route=route('site-notice-view',['']);
//        $users->notify(new GlobalSiteStudentFeePaymentHistory($this->payment_history_details,$route));

            //$user->notify(new InvoicePaid($invoice));
            foreach ($users as $key => $value){

                $user = User::where('id', $value->id)
                ->select(['id'])
                ->first();
                $user->notify(new GlobalStudentPaymentHistoryNotification($this->payment_history_details,$route));
            }

           // Notification::send($user, new StudentPaymentNotification($value));


    }
}
