<?php

namespace App\Jobs\site;

use App\Models\Site\Sms\SiteSms;

use App\Notifications\Site\UserMessageNotification;
use App\User;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\Notification;

class GlobalUserMessageJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;


    private $user_ids_array;
    private $the_sms;
    private $route;
    public $tries = 1;

    public function __construct($user_ids_array, SiteSms $the_sms,$route)
    {
        $this->user_ids_array=$user_ids_array;
        $this->the_sms=$the_sms;
        $this->route=$route;
    }


    public function handle()
        {
            
        $users = User::whereIn('id', $this->user_ids_array)
                ->select(['id'])
                ->get();
                
        Notification::send($users, new UserMessageNotification($this->the_sms, $this->route));

        }
}
