<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 6/5/2016
 * Time: 11:37 AM
 */

namespace App\Models\Author;

use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Dimsav\Translatable\Translatable;
use App\Models\Image\Photo;
use App\Models\Book\Book;

class Author extends ProjectModel
{
    use  Translatable;

    const AUTHOR_NAME = 'author_name';
    const AUTHOR_DATE_OF_BIRTH = 'date_of_birth';
    const AUTHOR_BIRTH_PLACE = 'author_birth_place';
    const AUTHOR_NOTE = 'author_note';
    const STATUS = 'status';
    const Active_status = 'active_status';
    const PHOTO = 'photo';

    const BirthDate = 'birthDate';
    const FirstName = 'firstName';
    const LastName = 'lastName';
    const Gender = 'gender';
    const Nationality = 'nationality';
    const Email = 'email';
    const Biography = 'biography';
    const Genres = 'genres';


    public $timestamps = false;

    protected $table = 'authors';

    protected $dates = ['deleted_at'];
    protected $appends = ['name'];

    protected $fillable = [
        self::AUTHOR_NAME,
        self::AUTHOR_DATE_OF_BIRTH,
        self::AUTHOR_BIRTH_PLACE,
        self::AUTHOR_NOTE,
        self::STATUS,
        self::BirthDate,
        self::FirstName,
        self::LastName,
        self::Gender,
        self::Nationality,
        self::Email,
        self::Biography,
        self::Genres,
        self::Active_status,
    ];

    public $translatedAttributes = [
        self::AUTHOR_NAME,
        self::AUTHOR_BIRTH_PLACE,
        self::AUTHOR_NOTE
    ];

    public $ownFields = [
        self::AUTHOR_DATE_OF_BIRTH,
        self::STATUS,
        self::BirthDate,
        self::FirstName,
        self::LastName,
        self::Gender,
        self::Nationality,
        self::Email,
        self::Biography,
        self::Genres,
        self::Active_status,
    ];

    public function photo()
    {
        return $this->morphMany(Photo::class, 'imageable');
    }

    public function photos()
    {
        return $this->hasMany(Photo::class);
    }

    //Author hasMany Book
    public function booksOfAuthor()
    {
        return $this->hasMany(Book::class);
    }
    public function getNameAttribute()
    {
        return trim("{$this->firstName} {$this->lastName}");
    }
}
