<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 6/6/2016
 * Time: 11:25 AM
 */

namespace App\Models\Book;


use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class BookBorrowing  extends Model
{
    protected $table = 'book_borrowings';

    const MEMBER_ID       = 'member_id';
    const BOOK_ID         = 'book_id';
    const book_history_id         = 'book_history_id';
    const BORROWED_DATE   = 'borrowed_date';
    const RETURNED_DATE   = 'returned_date';
    const DUE_DATE        = 'due_date';
    const NOTES           = 'notes';
    const Status          = 'status';
    const Returned_status = 'returned_status';
    const Site_id = 'site_id';
    const fine = 'fine';

    protected $fillable = [
        self::MEMBER_ID,
        self::BOOK_ID,
        self::book_history_id,
        self::BORROWED_DATE,
        self::RETURNED_DATE,
        self::DUE_DATE,
        self::NOTES,
        self::Status,
        self::Returned_status,
        self::Site_id,
        self::fine,
    ];
    protected $dates = [
        self::BORROWED_DATE,
        self::RETURNED_DATE,
        self::DUE_DATE,

    ];
    public function book()
    {
        return $this->belongsTo(Book::class);
    }
    public function member()
    {
        return $this->belongsTo(LibraryMember::class);
    }
    public function BookHistory()
    {
        return $this->belongsTo(LibraryBookHistory::class);
    }
}
