<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 6/6/2016
 * Time: 11:25 AM
 */

namespace App\Models\Book;


use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Dimsav\Translatable\Translatable;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class LibraryBookHistory extends ProjectModel
{

    protected $table = 'library_book_history';

    // Fillable columns
    protected $fillable = [
        'book_code',
        'book_id',
        'site_id',
        'status',
        'condition',
        'sale_status',
        'damage_info',
    ];


    public function book()
    {
        return $this->belongsTo(Book::class, 'book_id');
    }
}
