<?php

namespace App\Models\Company;

use Illuminate\Database\Eloquent\Model;

class CompanyProjectModel extends Model
{
    const COMPANY_ID = 'company_id';


    /**
     * ProjectModel constructor.
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {


        $this->fillable[] = self::COMPANY_ID;
        $this->{self::COMPANY_ID} = (int)session()->get('COMPANY_ID');
        parent::__construct($attributes);

        //\Log::info('id '.$this);
    }


    public function newQuery()
    {
        $site_id = (int)session()->get('COMPANY_ID');
        $builder = $this->newQueryWithoutScopes();
        $tableName = $builder->getModel()->getTable();
        $final = $builder->where($tableName . '.company_id', $site_id);

        return $final;
    }

}
