<?php

namespace App\Models\Company;

use App\Models\Image\Photo;
use App\Models\Role\HasRoles;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\SiteGroup\GlobalSiteGroup;
use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CompanyUser extends Model
{
    use Translatable, HasRoles, SoftDeletes;

    protected $formName;

    public $translationModel = 'App\Models\User\UserTranslation';
    public $translationForeignKey = 'user_id';
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'users';
    protected $dates = ['deleted_at'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    const ALIAS = 'alias';

    public function __construct(array $attributes = [])
    {
        $this->{self::ALIAS} = session()->get('ALIAS1');
        $this->fillable[] = self::ALIAS;
        parent::__construct($attributes);
    }

    public function newQuery()
    {

        $alias = session()->get('ALIAS1');
        $builder = $this->newQueryWithoutScopes();
        $tableName = $builder->getModel()->getTable();
        $final = $builder->where($tableName . '.alias', $alias)->where($tableName . '.deleted_at', '=', null);

        return $final;//$this->applyGlobalScopes($final);
    }


    public function setPasswordAttribute($request)
    {
        $this->attributes['password'] = bcrypt($request);

    }


    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];


    const COMPANY_BRANCH_ID = 'company_branch_id';
    const USERNAME = 'username';
    const EMAIL = 'email';
    const FIRST_NAME = 'first_name';
    const LAST_NAME = 'last_name';
    const PASSWORD = 'password';


    const PHONE = 'phone';
    const EMERGENCY_CONTACT = 'emergency_contact';
    const PASSPORT_NO = 'passport_no';
    const STATUS = 'status';
    const REMEMBER_TOKEN = 'remember_token';
    const DELETED_AT = 'deleted_at';

    const NATIONALITY = 'nationality';
    const INSTITUTE_JOINING_DATE = 'institute_joining_date';
    const NTRC_REGISRATION_NUMBER = 'ntrc_registration_number';


    public $translatedAttributes = [
        self::FIRST_NAME,
        self::LAST_NAME,
    ];
    public $timestamps = false;

    protected $fillable = [
        self::FIRST_NAME,
        self::LAST_NAME,
        self::USERNAME,
        self::EMAIL,
        self::PASSWORD,
        self::PHONE,
        self::COMPANY_BRANCH_ID,
        self::PASSPORT_NO,
        self::STATUS,
        self::REMEMBER_TOKEN,
        self::ALIAS,
        self::DELETED_AT,
    ];

    /**
     * this function is used for getting the values from
     * tables associated with hasMany relationship with the user table
     * while displaying the user-edit page
     * @var array
     */


    public $ownFields = [
        self::FIRST_NAME,
        self::LAST_NAME,
        self::USERNAME,
        self::EMAIL,
        self::PASSWORD,
        self::PHONE,
        self::COMPANY_BRANCH_ID,
        self::PASSPORT_NO,
        self::STATUS,
        self::REMEMBER_TOKEN,
        self::ALIAS,
        self::DELETED_AT,
        self::NATIONALITY,
        self::INSTITUTE_JOINING_DATE,
        self::NTRC_REGISRATION_NUMBER,

    ];


    public function siteInfoes()
    {
        return $this->belongsToMany(GlobalSiteInfo::class, 'site_info_user', 'user_id', 'site_id');
    }

    public function siteGroups()
    {
        return $this->belongsToMany(GlobalSiteGroup::class, 'site_group_user', 'user_id', 'site_group_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\MorphMany
     */
    public function photo()
    {
        return $this->morphMany(Photo::class, 'imageable');
    }

    public function photos()
    {
        return $this->hasMany(Photo::class);
    }

    public function latestPhoto()
    {
        return $this->hasOne(Photo::class, 'imageable_id')->orderBy('id', 'DESC');
    }



}
